% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbeta_rs.R
\name{rbeta_rs}
\alias{rbeta_rs}
\title{Random Variable From a Beta Distribution}
\usage{
rbeta_rs(n = 10, shape1 = 0.5, shape2 = 0.5, pmean = 0, psd = 1)
}
\arguments{
\item{n}{The number of random numbers
to generate.}

\item{shape1}{\code{shape1} for
\code{\link[stats:Beta]{stats::rbeta()}}.}

\item{shape2}{\code{shape2} for
\code{\link[stats:Beta]{stats::rbeta()}}.}

\item{pmean}{Population mean.}

\item{psd}{Population standard
deviation.}
}
\value{
A vector of the generated
random numbers.
}
\description{
Generate random numbers
from a beta distribution, rescaled to
have user-specified population mean
and standard deviation.
}
\details{
First, specify the two parameters,
\code{shape1} and \code{shape2}, and the
desired population mean and standard
deviation. The random numbers, drawn
from a beta distribution by
\code{\link[stats:Beta]{stats::rbeta()}} will then be
rescaled with the desired population
mean and standard deviation.
}
\examples{
set.seed(90870962)
x <- rbeta_rs(n = 5000,
              shape1 = .5,
              shape2 = .5,
              pmean = 3,
              psd = 1)
mean(x)
sd(x)
hist(x)

}
