% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_subset.r
\name{informloci}
\alias{informloci}
\title{Remove all non-phylogentically informative loci}
\usage{
informloci(pop, cutoff = 2/nInd(pop), MAF = 0.01, quiet = FALSE)
}
\arguments{
\item{pop}{a \code{\linkS4class{genclone}} or \code{\link[adegenet:genind-class]{genind}} 
object.}

\item{cutoff}{\code{numeric}. A number from 0 to 1 defining the minimum 
number of differentiating samples.}

\item{MAF}{\code{numeric}. A number from 0 to 1 defining the minimum minor
allele frequency. This is passed as the \code{thresh} parameter of
\code{\link[adegenet]{isPoly}}.}

\item{quiet}{\code{logical}. When \code{quiet = TRUE} (default), messages 
indicating the loci removed will be printed to screen. When \code{quiet = 
FALSE}, nothing will be printed to screen.}
}
\value{
A \code{genind} object with user-defined informative loci.
}
\description{
This function will facilitate in removing phylogenetically uninformative loci
from a \code{\linkS4class{genclone}} or \code{\link[adegenet:genind-class]{genind}} object. 
The user has the ability to define what uninformative means by setting a 
cutoff value for either percentage of differentiating genotypes or minor 
allele frequency.
}
\details{
This function will remove uninformative loci using a traditional MAF
  cutoff (using \code{\link[adegenet]{isPoly}} from \pkg{adegenet}) as well
  as analyzing the number of observed genotypes in a locus. This is important
  for clonal organisms that can have fixed heterozygous sites not detected by
  MAF methods.
}
\note{
This will have a few side effects that affect certain analyses. First, 
  the number of multilocus genotypes might be reduced due to the reduced 
  number of markers (if you are only using a genind object). Second, if you 
  plan on using this data for analysis of the index of association, be sure 
  to use the standardized version (rbarD) that corrects for the number of 
  observed loci.
}
\examples{
# We will use a dummy data set to demonstrate how this detects uninformative
# loci using both MAF and a cutoff.

genos <- c("A/A", "A/B", "A/C", "B/B", "B/C", "C/C")

v <- sample(genos, 100, replace = TRUE)
w <- c(rep(genos[2], 99), genos[3])           # found by cutoff
x <- c(rep(genos[1], 98), genos[3], genos[2]) # found by MAF
y <- c(rep(genos[1], 99), genos[2])           # found by both
z <- sample(genos, 100, replace = TRUE)
dat <- df2genind(data.frame(v = v, w = w, x = x, y = y, z = z), sep = "/")

informloci(dat)

\dontrun{
# Ignore MAF
informloci(dat, MAF = 0)

# Ignore cutoff
informloci(dat, cutoff = 0)

# Real data
data(H3N2)
informloci(H3N2)

}
}
\author{
Zhian N. Kamvar
}
