% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregating.R
\name{setaggre}
\alias{setaggre}
\title{Set \code{aggre} attributes to an object by modifying in place}
\usage{
setaggre(x, values = NULL, by = NULL, breaks = NULL)
}
\arguments{
\item{x}{a \code{data.frame} or \code{data.table}}

\item{values}{a character string vector; the names of value variables}

\item{by}{a character string vector; the names of variables by which 
\code{values} have been tabulated}

\item{breaks}{a list of breaks, where each element is a breaks vector
as usually passed to e.g. \code{\link{splitLexisDT}}. The list must be
fully named, with the names corresponding to time scales at the aggregate
level in your data. Every unique value in a time scale variable in data must
also exist in the corresponding vector in the breaks list.}
}
\value{
Returns `x` invisibly after setting attributes to it without taking a copy.
This function is called for its side effects.
}
\description{
Coerces an R object to an \code{aggre} object, identifying
the object as one containing aggregated counts, person-years and other
information. \code{setaggre} modifies in place without taking any copies.
Retains all other attributes.
}
\details{
\code{setaggre} sets \code{x} to the \code{aggre} class in place 
without taking a copy as e.g. \code{as.data.frame.XXX} functions do; see e.g. 
\code{\link[data.table]{setDT}}.
}
\examples{
df <- data.frame(sex = rep(c("male", "female"), each = 5), 
                 obs = rpois(10, rep(7,5, each=5)), 
                 pyrs = rpois(10, lambda = 10000))
## without any breaks
setaggre(df, values = c("obs", "pyrs"), by = "sex")
df <- data.frame(df)
df$FUT <- 0:4
## with breaks list
setaggre(df, values = c("obs", "pyrs"), by = "sex", breaks = list(FUT = 0:5))
}
\seealso{
Other aggregation functions: 
\code{\link{aggre}()},
\code{\link{as.aggre}()},
\code{\link{lexpand}()},
\code{\link{summary.aggre}()}
}
\author{
Joonas Miettinen
}
\concept{aggregation functions}
