% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/relative_poisson_net_survival.R
\name{rpcurve}
\alias{rpcurve}
\title{Marginal piecewise parametric relative survival curve}
\usage{
rpcurve(object = NULL, conf.int = 0.95)
}
\arguments{
\item{object}{a \code{relpois} object}

\item{conf.int}{confidence interval level; e.g. \code{0.95} for \code{95 \%}
confidence intervals (region)}
}
\description{
Fit a marginal relative survival curve based on a \code{relpois} fit
}
\details{
Currently only estimates a marginal curve, i.e. the average of all
possible individual curves. The confidence intervals are based on an
assumption of asymptotic normalcy at the cumulative hazard level.

Only supported when the reserved \code{FOT} variable was used in \code{relpois}.
Computes a curve for each unique combination of covariates (e.g. 4 sets)
and returns a weighted average curve based on the counts
of subjects for each combination (e.g. 1000, 125, 50, 25 respectively).
Fairly fast when only factor variables have been used, otherwise
go get a cup of coffee.

If delayed entry is present in data due to period analysis limiting,
the marginal curve is constructed only for those whose follow-up started
in the respective period.
}
\examples{
\dontrun{
## use the simulated rectal cancer cohort
sr <- copy(sire)
ab <- c(0,45,55,65,70,Inf)
sr$agegr <- cut(sr$dg_age, breaks = ab, right = FALSE)

BL <- list(fot= seq(0,10,1/12))
x <- lexpand(sr, breaks=BL, pophaz=popmort, status=status)

rpm <- relpois(x, formula = lex.Xst \%in\% 1:2 ~ -1+ FOT + agegr, fot.breaks=c(0,0.25,0.5,1:8,10))
pmc <- rpcurve(rpm)

## compare with non-parametric estimates
st <- survtab(x,relsurv.method = "e2", agegr.w.breaks=c(0,45,55,65,75,Inf))

plot(I(c(0.5,1))~I(c(0,10)), type="n", xlab="years", ylab="relative survival")
matlines(y = st[, list(r.e2.as, r.e2.as.lo, r.e2.as.hi)], x = st$Tstop, col="blue", lty=c(1,2,2))
matlines(y = pmc[, list(est, lo, hi)], x = pmc$Tstop, col="red", lty=c(1,2,2))
}
}
\author{
Joonas Miettinen
}

