% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causal_forest-scores.R,
%   R/causal_survival_forest-scores.R, R/instrumental_forest-scores.R,
%   R/multi_arm_causal_forest-scores.R, R/scores.R
\name{double_robust_scores.causal_forest}
\alias{double_robust_scores.causal_forest}
\alias{double_robust_scores.causal_survival_forest}
\alias{double_robust_scores.instrumental_forest}
\alias{double_robust_scores.multi_arm_causal_forest}
\alias{double_robust_scores}
\title{Matrix \eqn{\Gamma} of scores for each treatment \eqn{a}}
\usage{
\method{double_robust_scores}{causal_forest}(object, ...)

\method{double_robust_scores}{causal_survival_forest}(object, ...)

\method{double_robust_scores}{instrumental_forest}(object, compliance.score = NULL, ...)

\method{double_robust_scores}{multi_arm_causal_forest}(object, outcome = 1, ...)

double_robust_scores(object, ...)
}
\arguments{
\item{object}{An appropriate causal forest type object}

\item{...}{Additional arguments}

\item{compliance.score}{An estimate of the causal effect of Z on W.
i.e., Delta(X) = E(W | X, Z = 1) - E(W | X, Z = 0), for each sample i = 1, ..., n. If NULL (default)
then this is estimated with a causal forest.}

\item{outcome}{Only used with multi arm causal forets. In the event the forest is trained
with multiple outcomes Y, a column number/name specifying the outcome of interest.
Default is 1.}
}
\value{
A matrix of scores for each treatment
}
\description{
Computes a matrix of double robust scores
\eqn{\Gamma_{ia} = \mu_a(x) + \frac{1}{e_a(x)} (Y_i - \mu_a(x)) 1(A_i=a)}
}
\details{
This is the matrix used for CAIPWL (Cross-fitted Augmented Inverse Propensity Weighted Learning)
}
\section{Methods (by class)}{
\itemize{
\item \code{double_robust_scores(causal_forest)}: Scores \eqn{(\Gamma_0, \Gamma_1)}

\item \code{double_robust_scores(causal_survival_forest)}: Scores \eqn{(\Gamma_0, \Gamma_1)}

\item \code{double_robust_scores(instrumental_forest)}: Scores \eqn{(-\Gamma, \Gamma)}

\item \code{double_robust_scores(multi_arm_causal_forest)}: Matrix \eqn{\Gamma} of scores for each treatment \eqn{a}

}}
\note{
For instrumental_forest this method returns \eqn{(-\Gamma_i, \Gamma_i)} where \eqn{\Gamma_i}
is the double robust estimator of the treatment effect as in eqn. (44) in Athey and Wager (2021).
}
\examples{
\donttest{
# Compute double robust scores for a multi-arm causal forest
n <- 500
p <- 10
X <- matrix(rnorm(n * p), n, p)
W <- as.factor(sample(c("A", "B", "C"), n, replace = TRUE))
Y <- X[, 1] + X[, 2] * (W == "B") + X[, 3] * (W == "C") + runif(n)
forest <- grf::multi_arm_causal_forest(X, Y, W)
scores <- double_robust_scores(forest)
head(scores)

# Compute double robust scores for a causal forest
n <- 500
p <- 10
X <- matrix(rnorm(n * p), n, p)
W <- rbinom(n, 1, 0.5)
Y <- pmax(X[, 1], 0) * W + X[, 2] + pmin(X[, 3], 0) + rnorm(n)
c.forest <- grf::causal_forest(X, Y, W)
scores <- double_robust_scores(c.forest)
}
}
\references{
Athey, Susan, and Stefan Wager. "Policy Learning With Observational Data." Econometrica 89.1 (2021): 133-161.
}
