% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radarplot.R
\name{RadarPlot}
\alias{RadarPlot}
\alias{SpiderPlot}
\title{Radar plot / Spider plot}
\usage{
RadarPlot(
  data,
  x,
  x_sep = "_",
  group_by = NULL,
  group_by_sep = "_",
  y = NULL,
  group_name = NULL,
  scale_y = c("group", "global", "x", "none"),
  y_min = 0,
  y_max = NULL,
  y_nbreaks = 4,
  fill = TRUE,
  linewidth = 1,
  pt_size = 4,
  max_charwidth = 16,
  split_by = NULL,
  split_by_sep = "_",
  theme = "theme_this",
  theme_args = list(),
  palette = "Paired",
  palcolor = NULL,
  facet_by = NULL,
  facet_scales = "fixed",
  facet_ncol = NULL,
  facet_nrow = NULL,
  facet_byrow = TRUE,
  alpha = 0.2,
  aspect.ratio = 1,
  legend.position = waiver(),
  legend.direction = "vertical",
  title = NULL,
  subtitle = NULL,
  seed = 8525,
  combine = TRUE,
  nrow = NULL,
  ncol = NULL,
  byrow = TRUE,
  ...
)

SpiderPlot(
  data,
  x,
  x_sep = "_",
  group_by = NULL,
  group_by_sep = "_",
  y = NULL,
  group_name = NULL,
  scale_y = c("group", "global", "x", "none"),
  y_min = 0,
  y_max = NULL,
  y_nbreaks = 4,
  fill = TRUE,
  linewidth = 1,
  pt_size = 4,
  max_charwidth = 16,
  split_by = NULL,
  split_by_sep = "_",
  theme = "theme_this",
  theme_args = list(),
  palette = "Paired",
  palcolor = NULL,
  facet_by = NULL,
  facet_scales = "fixed",
  facet_ncol = NULL,
  facet_nrow = NULL,
  facet_byrow = TRUE,
  alpha = 0.2,
  aspect.ratio = 1,
  legend.position = waiver(),
  legend.direction = "vertical",
  title = NULL,
  subtitle = NULL,
  seed = 8525,
  combine = TRUE,
  nrow = NULL,
  ncol = NULL,
  byrow = TRUE,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{x}{A character string specifying the column name of the data frame to plot for the x-axis.}

\item{x_sep}{A character string to concatenate the columns in \code{x}, if multiple columns are provided.}

\item{group_by}{Columns to group the data for plotting
For those plotting functions that do not support multiple groups,
They will be concatenated into one column, using \code{group_by_sep} as the separator}

\item{group_by_sep}{The separator for multiple group_by columns. See \code{group_by}}

\item{y}{A character string specifying the column name of the data frame to plot for the y-axis.}

\item{group_name}{A character string to name the legend of group.}

\item{scale_y}{How should the y-axis be scaled? Default is "group".
Other options are "global", "x" and "none".
\itemize{
\item If "group", the y-axis will be scaled to the fraction within each group.
\item If "global", the y-axis will be scaled to the fraction of the total.
\item If "x", the y-axis will be scaled to the fraction of the total within each x-axis group.
\item If "none", the y-axis will be scaled to the count of each x-axis group.
}}

\item{y_min}{A numeric value to set the minimum value of the y-axis.}

\item{y_max}{A numeric value to set the maximum value of the y-axis.}

\item{y_nbreaks}{A numeric value to set the number of breaks in the y-axis.}

\item{fill}{A logical value to fill the polygons with colors.}

\item{linewidth}{A numeric value to set the width of the lines.}

\item{pt_size}{A numeric value to set the size of the points.}

\item{max_charwidth}{A numeric value to set the maximum character width for the x labels.}

\item{split_by}{The column(s) to split data by and plot separately.}

\item{split_by_sep}{The separator for multiple split_by columns. See \code{split_by}}

\item{theme}{A character string or a theme class (i.e. ggplot2::theme_classic) specifying the theme to use.
Default is "theme_this".}

\item{theme_args}{A list of arguments to pass to the theme function.}

\item{palette}{A character string specifying the palette to use.}

\item{palcolor}{A character string specifying the color to use in the palette.}

\item{facet_by}{A character string specifying the column name of the data frame to facet the plot.
Otherwise, the data will be split by \code{split_by} and generate multiple plots
and combine them into one using \code{patchwork::wrap_plots}}

\item{facet_scales}{Whether to scale the axes of facets. Default is "fixed"
Other options are "free", "free_x", "free_y". See \code{ggplot2::facet_wrap}}

\item{facet_ncol}{A numeric value specifying the number of columns in the facet.
When facet_by is a single column and facet_wrap is used.}

\item{facet_nrow}{A numeric value specifying the number of rows in the facet.
When facet_by is a single column and facet_wrap is used.}

\item{facet_byrow}{A logical value indicating whether to fill the plots by row. Default is TRUE.}

\item{alpha}{A numeric value specifying the transparency of the plot.}

\item{aspect.ratio}{A numeric value specifying the aspect ratio of the plot.}

\item{legend.position}{A character string specifying the position of the legend.
if \code{waiver()}, for single groups, the legend will be "none", otherwise "right".}

\item{legend.direction}{A character string specifying the direction of the legend.}

\item{title}{A character string specifying the title of the plot.
A function can be used to generate the title based on the default title.
This is useful when split_by is used and the title needs to be dynamic.}

\item{subtitle}{A character string specifying the subtitle of the plot.}

\item{seed}{The random seed to use. Default is 8525.}

\item{combine}{Whether to combine the plots into one when facet is FALSE. Default is TRUE.}

\item{nrow}{A numeric value specifying the number of rows in the facet.}

\item{ncol}{A numeric value specifying the number of columns in the facet.}

\item{byrow}{A logical value indicating whether to fill the plots by row.}

\item{...}{Additional arguments.}
}
\value{
A ggplot object or wrap_plots object or a list of ggplot objects
}
\description{
Create a radar plot or spider plot for a series of data.
Radar plot uses circles as the plot grid and Spider plot uses polygons.
}
\examples{
# use the count
data <- data.frame(
   x = c(rep("A", 2), rep("B", 3), rep("C", 3), rep("D", 4), rep("E", 5)),
   group = sample(paste0("G", 1:4), 17, replace = TRUE)
)
RadarPlot(data, x = "x")
RadarPlot(data, x = "x", scale_y = "none")
RadarPlot(data, x = "x", group_by = "group")
SpiderPlot(data, x = "x")
SpiderPlot(data, x = "x", group_by = "group")

# use the y value
data <- data.frame(
   x = rep(LETTERS[1:5], 2),
   y = c(1, 3, 6, 4, 2, 5, 7, 8, 9, 10),
   group = rep(c("G1", "G2"), each = 5)
)
RadarPlot(data, x = "x", y = "y", scale_y = "none", group_by = "group")
RadarPlot(data, x = "x", y = "y", facet_by = "group")
RadarPlot(data, x = "x", y = "y", split_by = "group")
}
