% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sankeyplot.R
\name{SankeyPlotAtomic}
\alias{SankeyPlotAtomic}
\title{Atomic Sankey plot}
\usage{
SankeyPlotAtomic(
  data,
  y = NULL,
  nodes_by,
  nodes_color = "grey30",
  links_by = NULL,
  links_by_sep = "_",
  links_name = NULL,
  nodes_palette = "Paired",
  nodes_palcolor = NULL,
  nodes_alpha = 1,
  nodes_label = FALSE,
  links_palette = "Paired",
  links_palcolor = NULL,
  links_alpha = 0.6,
  legend.box = "vertical",
  x_text_angle = 0,
  aspect.ratio = 1,
  legend.position = "right",
  legend.direction = "vertical",
  theme = "theme_this",
  theme_args = list(),
  title = NULL,
  subtitle = NULL,
  xlab = NULL,
  ylab = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{y}{A character string of the column name to plot on the y-axis.
A numeric column is expected.
If NULL, the count of each nodes_by column will be used.}

\item{nodes_by}{A character vector of column names to define the nodes.}

\item{nodes_color}{A character string to color the nodes.}

\item{links_by}{A character vector of column names to define the links.
If NULL, the links_by will be the first column in nodes_by.}

\item{links_by_sep}{A character string to concatenate the columns in \code{links_by}, if multiple columns are provided.}

\item{links_name}{A character string to name the legend of links.}

\item{nodes_palette}{A character string to specify the palette of nodes.}

\item{nodes_palcolor}{A character vector to specify the colors of nodes.}

\item{nodes_alpha}{A numeric value to specify the transparency of nodes.}

\item{nodes_label}{A logical value to show the labels on the nodes.}

\item{links_palette}{A character string to specify the palette of links.}

\item{links_palcolor}{A character vector to specify the colors of links.}

\item{links_alpha}{A numeric value to specify the transparency of links.}

\item{legend.box}{A character string to specify the box of the legend, either "vertical" or "horizontal".}

\item{x_text_angle}{A numeric value specifying the angle of the x-axis text.}

\item{aspect.ratio}{A numeric value specifying the aspect ratio of the plot.}

\item{legend.position}{A character string specifying the position of the legend.
if \code{waiver()}, for single groups, the legend will be "none", otherwise "right".}

\item{legend.direction}{A character string specifying the direction of the legend.}

\item{theme}{A character string or a theme class (i.e. ggplot2::theme_classic) specifying the theme to use.
Default is "theme_this".}

\item{theme_args}{A list of arguments to pass to the theme function.}

\item{title}{A character string specifying the title of the plot.
A function can be used to generate the title based on the default title.
This is useful when split_by is used and the title needs to be dynamic.}

\item{subtitle}{A character string specifying the subtitle of the plot.}

\item{xlab}{A character string specifying the x-axis label.}

\item{ylab}{A character string specifying the y-axis label.}

\item{...}{Additional arguments.}
}
\value{
A ggplot object
}
\description{
Plot a Sankey plot without splitting the data.
}
\keyword{internal}
