% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivarrugplot.r
\name{bivarrugplot}
\alias{bivarrugplot}
\title{Plots the bivariate relationship between two measures and a rugplot for each measure}
\usage{
bivarrugplot(x, y, data)
}
\arguments{
\item{x}{A vector.}

\item{y}{A vector.}

\item{data}{A data frame.}
}
\value{
A plot of the bivariate relationship between two measures with a rugplot for each measure.
}
\description{
Returns a plot of the bivariate relationship between two measures with a rugplot for each measure.
}
\examples{
a <- runif(1000, min = 0, max = 1)
b <- a + rnorm(1000, mean = 0, sd = 1)
data <- data.frame(a, b)
bivarrugplot("a", "b", data)
}
\author{
Charles Crabtree \email{ccrabtr@umich.edu}
}
