% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{USvote2016}
\alias{USvote2016}
\title{Self-reported votes from VOTER Survey in 2016}
\format{
\code{tibble} (\code{data.frame}) with 8000 observations of 7 variables:
\describe{
\item{idcode:}{voter identifier (integer).}
\item{vote:}{declared vote, afactor with three levels: "Clinton", "Trump",
"Other".}
\item{race:}{race, a factor with six levels: "White", "Black", "Hispanic",
"Asian", "Mixed",
"Other".}
\item{educ:}{level of education, a factor with six levels: "No high school",
"High school grad.", "Some college", "2-year college", "4-year college",
"Post-grad".}
\item{gender:}{gender, a factor with four levels: "Male", "Female", "Skipped",
"Not Asked".}
\item{birthyr:}{decades when the voter was born, a factor with six levels:
"[1920,1940)", "[1940,1950)", "[1950,1960)", "[1960,1970)", "[1970,1980)",
"[1980,2000)".}
\item{famincome:}{income (in USD) of voter's family, a factor with five
levels: "[0; 30,000)", "[30,000; 60,000)", "[60,000; 100,000)",
"[100,000; 150,000)", "[150,000; Inf)".}
}
}
\description{
Self-reported votes from 2016 VOTER Survey by
\insertCite{dfvsg2017;textual}{plot3logit}. Object \code{USvote2016} includes only
few variables based on the result of the survey, which are publicly available
online. See file \code{"data-raw/USvote2016_prepare.R"} in the GitHub repository
\code{"f-santi/plot3logit"} (\url{https://github.com/f-santi/plot3logit}), where
it is documented how the dataset \code{USvote2016} has been generated.
}
\references{
\insertAllCited{}
}
\keyword{data}
