% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggtern.R
\name{gg3logit}
\alias{gg3logit}
\title{Create a new gg3logit}
\usage{
gg3logit(data = NULL, mapping = aes(), ...)
}
\arguments{
\item{data}{a \code{field3logit} or a \code{multifield3logit} object. If not
specified, must be supplied in each layer added to the plot.}

\item{mapping}{list of aesthetic mappings to use for plot. If not
specified, must be supplied in each layer added to the plot. \strong{Note
that} mappings \code{x}, \code{y} and \code{z} are \strong{not} required: they will be
overwritten if specified (see examples).}

\item{...}{additional arguments passed through to \code{\link[ggtern:ggtern]{ggtern}}.}
}
\description{
\code{gg3logit} initializes a \code{\link[ggplot2:ggplot]{ggplot}} object through
\code{\link[ggtern:ggtern]{ggtern}}. If a fortified \code{field3logit} or a
\code{multifield3logit} object is passed as argument \code{data} to \code{gg3logit},
the labels of the ternary plot are automatically. The same happens if a
\code{field3logit} or a \code{multifield3logit} object is passed; in that case,
\code{gg3logit} preliminarly invoke the \code{fortify} method.
}
\examples{
data(cross_1year)

mod0 <- nnet::multinom(employment_sit ~ gender + finalgrade, data = cross_1year)
field0 <- field3logit(mod0, 'genderFemale')

gg3logit(field0) + stat_3logit()

}
\seealso{
Other `gg` functions: \code{\link{multifield3logit}},
  \code{\link{stat_3logit}}
}
\concept{`gg` functions}
