% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user-drop.R
\name{drop_sqs}
\alias{drop_sqs}
\title{Drop sequences in a cluster}
\usage{
drop_sqs(phylota, cid, sid)
}
\arguments{
\item{phylota}{Phylota object}

\item{cid}{Cluster ID}

\item{sid}{Sequence ID(s) to be kept}
}
\value{
phylota
}
\description{
Drop all sequences in a cluster except those identified by user.
}
\examples{
data("dragonflies")
# drop random sequences from cluster 0
clstr <- dragonflies[['0']]
# specify the sids to *keep*
sids <- sample(clstr@sids, 100)
(dragonflies <- drop_sqs(phylota = dragonflies, cid = '0', sid = sids))
# Note, sequences dropped may be represented in other clusters
}
\seealso{
Other tools-public: \code{\link{calc_mad}},
  \code{\link{calc_wrdfrq}}, \code{\link{drop_by_rank}},
  \code{\link{drop_clstrs}}, \code{\link{get_clstr_slot}},
  \code{\link{get_nsqs}}, \code{\link{get_ntaxa}},
  \code{\link{get_sq_slot}}, \code{\link{get_stage_times}},
  \code{\link{get_tx_slot}}, \code{\link{get_txids}},
  \code{\link{is_txid_in_clstr}},
  \code{\link{is_txid_in_sq}},
  \code{\link{list_clstrrec_slots}},
  \code{\link{list_ncbi_ranks}},
  \code{\link{list_seqrec_slots}},
  \code{\link{list_taxrec_slots}},
  \code{\link{plot_phylota_pa}},
  \code{\link{plot_phylota_treemap}},
  \code{\link{read_phylota}}, \code{\link{write_sqs}}
}
