% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenology_MHmcmc_p.R
\name{phenology_MHmcmc_p}
\alias{phenology_MHmcmc_p}
\title{Generates set of parameters to be used with phenology_MHmcmc()}
\usage{
phenology_MHmcmc_p(
  result = stop("An output from fit_phenology() must be provided"),
  default.density = "dunif",
  accept = FALSE
)
}
\arguments{
\item{result}{An object obtained after a fit_phenology() fit}

\item{default.density}{The default density, "dnorm" or "dunif'}

\item{accept}{If TRUE, does not wait for use interaction}
}
\value{
A matrix with the parameters
}
\description{
Interactive script used to generate set of parameters to be used with phenology_MHmcmc().
}
\details{
phenology_MHmcmc_p generates set of parameters to be used with phenology_MHmcmc()
}
\examples{
\dontrun{
library(phenology)
data(Gratiot)
# Generate a formatted list named data_Gratiot 
data_Gratiot<-add_phenology(Gratiot, name="Complete", 
  	reference=as.Date("2001-01-01"), format="\%d/\%m/\%Y")
# Generate initial points for the optimisation
parg<-par_init(data_Gratiot, fixed.parameters=NULL)
# Run the optimisation
result_Gratiot<-fit_phenology(data=data_Gratiot, 
		fitted.parameters=parg, fixed.parameters=NULL)
# Generate set of priors for Bayesian analysis
pmcmc <- phenology_MHmcmc_p(result_Gratiot, accept = TRUE)
result_Gratiot_mcmc <- phenology_MHmcmc(result = result_Gratiot, n.iter = 10000, 
parametersMCMC = pmcmc, n.chains = 1, n.adapt = 0, thin = 1, trace = FALSE)
# Get standard error of parameters
summary(result_Gratiot_mcmc)
# Make diagnostics of the mcmc results using coda package
mcmc <- as.mcmc(result_Gratiot_mcmc)
require(coda)
heidel.diag(mcmc)
raftery.diag(mcmc)
autocorr.diag(mcmc)
acf(mcmc[[1]][,"LengthB"], lag.max=200, bty="n", las=1)
acf(mcmc[[1]][,"Max_Gratiot"], lag.max=50, bty="n", las=1)
batchSE(mcmc, batchSize=100)
# The batch standard error procedure is usually thought to 
# be not as accurate as the time series methods used in summary
summary(mcmc)$statistics[,"Time-series SE"]
plot(result_Gratiot_mcmc, parameters=3, las=1, xlim=c(-10, 300))
}
}
\seealso{
Other Phenology model: 
\code{\link{AutoFitPhenology}()},
\code{\link{BE_to_LBLE}()},
\code{\link{Gratiot}},
\code{\link{LBLE_to_BE}()},
\code{\link{LBLE_to_L}()},
\code{\link{L_to_LBLE}()},
\code{\link{MarineTurtles_2002}},
\code{\link{MinBMinE_to_Min}()},
\code{\link{adapt_parameters}()},
\code{\link{add_SE}()},
\code{\link{add_phenology}()},
\code{\link{extract_result}()},
\code{\link{fit_phenology}()},
\code{\link{likelihood_phenology}()},
\code{\link{logLik.phenology}()},
\code{\link{map_Gratiot}},
\code{\link{map_phenology}()},
\code{\link{par_init}()},
\code{\link{phenology2fitRMU}()},
\code{\link{phenology_MHmcmc}()},
\code{\link{phenology}()},
\code{\link{plot.phenologymap}()},
\code{\link{plot.phenology}()},
\code{\link{plot_delta}()},
\code{\link{plot_phi}()},
\code{\link{print.phenologymap}()},
\code{\link{print.phenologyout}()},
\code{\link{print.phenology}()},
\code{\link{remove_site}()},
\code{\link{result_Gratiot1}},
\code{\link{result_Gratiot2}},
\code{\link{result_Gratiot_Flat}},
\code{\link{result_Gratiot_mcmc}},
\code{\link{result_Gratiot}},
\code{\link{summary.phenologymap}()},
\code{\link{summary.phenologyout}()},
\code{\link{summary.phenology}()}
}
\author{
Marc Girondot
}
\concept{Phenology model}
