% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.phenology.R
\name{summary.phenology}
\alias{summary.phenology}
\title{Print the result information from a result object.}
\usage{
\method{summary}{phenology}(object, resultmcmc = NULL, chain = 1,
  series = "all", replicate.CI.mcmc = "all", replicate.CI = 10000,
  level = 0.95, print = TRUE, ...)
}
\arguments{
\item{object}{A result file generated by fit_phenology}

\item{resultmcmc}{A mcmc object}

\item{chain}{The number of chain to be used in resultmcmc}

\item{series}{Names of the series to be analyzed or "all"}

\item{replicate.CI.mcmc}{Number of iterations to be used or "all"}

\item{replicate.CI}{Number of replicates for ML resampling}

\item{level}{Level to estimate confidence interval or credibility interval}

\item{print}{Should information be shown}

\item{...}{Not used}
}
\value{
A list with four objects: synthesis is a data.frame with global estimate of nesting.\cr
details_MCMC, details_ML and details_mean are lists with day by day information for each series.
}
\description{
The function summary.phenology shows result and estimates confidence interval.
}
\details{
summary.phenology prints the information from a result object.
}
\examples{
\dontrun{
library(phenology)
# Read a file with data
Gratiot<-read.delim("http://max2.ese.u-psud.fr/epc/conservation/BI/Complete.txt", header=FALSE)
data(Gratiot)
# Generate a formatted list nammed data_Gratiot 
data_Gratiot<-add_phenology(Gratiot, name="Complete", 
		reference=as.Date("2001-01-01"), format="\%d/\%m/\%Y")
# Generate initial points for the optimisation
parg<-par_init(data_Gratiot, fixed.parameters=NULL)
# Run the optimisation
result_Gratiot<-fit_phenology(data=data_Gratiot, 
		fitted.parameters=parg, fixed.parameters=NULL, trace=1)
data(result_Gratiot)
# Display information from the result
summary(result_Gratiot)
# Using mcmc
summary(result_Gratiot, resultmcmc=result_Gratiot_mcmc)
}
}
\author{
Marc Girondot
}
