% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IPModel.R
\name{IPModel}
\alias{IPModel}
\title{Estimates the pattern of internesting intervals for a set of parameters.}
\usage{
IPModel(
  par,
  parallel = TRUE,
  limits = list(meanIP = 40, meanECF = 4, minIP = 15, sdAbort = 1, sdIP = 1, sdECF = 1,
    DeltameanIP = 0.5, maxDays = 365)
)
}
\arguments{
\item{par}{Set of parameters}

\item{parallel}{If TRUE, will use parallel computing}

\item{limits}{A list of limits for various parameters}
}
\value{
Return a list with two elements.\cr
}
\description{
This function fits a model of internesting period.\cr
The parameters are:\cr
\itemize{
\item \code{meanIP} : The average number of days between two nesting processes
\item \code{DeltameanIP} : The shift in days for IP at each new clutch.
\item \code{sdIP} : The standard deviation of number of days between two nesting processes
\item \code{minIP} : The minimum number of days between two nesting processes
\item \code{pAbort} : The -logit of the probability to abort a nesting process
\item \code{meanAbort} : The average of the number of days after the abortion of a nesting process
\item \code{sdAbort} : The standard deviation of the number of days after the abortion of a nesting process
\item \code{pCapture} : The -logit of the probability to capture a female on the beach
\item \code{meanECF} : The average number of clutch a female will try to do being reprensented as ECF
\item \code{sdECF} : The standard deviation of number of clutch a female will try to do
\item \code{N} : The number of replicates to generate the distribution (default is 10000 if not indicated)
\item \code{ECF.x} : The relative proportion of females nesting with ECF = x (ECF.1 being fixed to 1)
}
}
\details{
IPModel estimates the pattern of internesting intervals for a set of parameters.
}
\examples{
\dontrun{
library(phenology)
# Example
par <- c(meanIP = 9.8, 
sdIP = 0.1, 
minIP = 7, 

pAbort = -logit(0.1), 
meanAbort = 2, 
sdAbort = 0.05, 

pCapture = -logit(0.8), 

meanECF = 4, 
sdECF = 0.1)

model <- IPModel(c(par, N=10000))

plot(model)

}
}
\seealso{
Other Model of Internesting Period: 
\code{\link{IPFit}()},
\code{\link{IPPredict}()},
\code{\link{plot.IP}()},
\code{\link{summary.IP}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{Model of Internesting Period}
