% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_update_anomaly}
\alias{cloudwatchlogs_update_anomaly}
\title{Use this operation to suppress anomaly detection for a specified anomaly
or pattern}
\usage{
cloudwatchlogs_update_anomaly(
  anomalyId = NULL,
  patternId = NULL,
  anomalyDetectorArn,
  suppressionType = NULL,
  suppressionPeriod = NULL
)
}
\arguments{
\item{anomalyId}{If you are suppressing or unsuppressing an anomaly, specify its unique
ID here. You can find anomaly IDs by using the
\code{\link[=cloudwatchlogs_list_anomalies]{list_anomalies}} operation.}

\item{patternId}{If you are suppressing or unsuppressing an pattern, specify its unique
ID here. You can find pattern IDs by using the
\code{\link[=cloudwatchlogs_list_anomalies]{list_anomalies}} operation.}

\item{anomalyDetectorArn}{[required] The ARN of the anomaly detector that this operation is to act on.}

\item{suppressionType}{Use this to specify whether the suppression to be temporary or infinite.
If you specify \code{LIMITED}, you must also specify a \code{suppressionPeriod}.
If you specify \code{INFINITE}, any value for \code{suppressionPeriod} is ignored.}

\item{suppressionPeriod}{If you are temporarily suppressing an anomaly or pattern, use this
structure to specify how long the suppression is to last.}
}
\description{
Use this operation to \emph{suppress} anomaly detection for a specified anomaly or pattern. If you suppress an anomaly, CloudWatch Logs won’t report new occurrences of that anomaly and won't update that anomaly with new data. If you suppress a pattern, CloudWatch Logs won’t report any anomalies related to that pattern.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchlogs_update_anomaly/} for full documentation.
}
\keyword{internal}
