# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include controltower_service.R
NULL

#' Creates a new landing zone
#'
#' @description
#' Creates a new landing zone. This API call starts an asynchronous operation that creates and configures a landing zone, based on the parameters specified in the manifest JSON file.
#'
#' See [https://www.paws-r-sdk.com/docs/controltower_create_landing_zone/](https://www.paws-r-sdk.com/docs/controltower_create_landing_zone/) for full documentation.
#'
#' @param manifest &#91;required&#93; The manifest JSON file is a text file that describes your Amazon Web
#' Services resources. For examples, review [Launch your landing
#' zone](https://docs.aws.amazon.com/controltower/latest/userguide/lz-api-launch.html).
#' @param tags Tags to be applied to the landing zone.
#' @param version &#91;required&#93; The landing zone version, for example, 3.0.
#'
#' @keywords internal
#'
#' @rdname controltower_create_landing_zone
controltower_create_landing_zone <- function(manifest, tags = NULL, version) {
  op <- new_operation(
    name = "CreateLandingZone",
    http_method = "POST",
    http_path = "/create-landingzone",
    paginator = list()
  )
  input <- .controltower$create_landing_zone_input(manifest = manifest, tags = tags, version = version)
  output <- .controltower$create_landing_zone_output()
  config <- get_config()
  svc <- .controltower$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.controltower$operations$create_landing_zone <- controltower_create_landing_zone

#' Decommissions a landing zone
#'
#' @description
#' Decommissions a landing zone. This API call starts an asynchronous operation that deletes Amazon Web Services Control Tower resources deployed in accounts managed by Amazon Web Services Control Tower.
#'
#' See [https://www.paws-r-sdk.com/docs/controltower_delete_landing_zone/](https://www.paws-r-sdk.com/docs/controltower_delete_landing_zone/) for full documentation.
#'
#' @param landingZoneIdentifier &#91;required&#93; The unique identifier of the landing zone.
#'
#' @keywords internal
#'
#' @rdname controltower_delete_landing_zone
controltower_delete_landing_zone <- function(landingZoneIdentifier) {
  op <- new_operation(
    name = "DeleteLandingZone",
    http_method = "POST",
    http_path = "/delete-landingzone",
    paginator = list()
  )
  input <- .controltower$delete_landing_zone_input(landingZoneIdentifier = landingZoneIdentifier)
  output <- .controltower$delete_landing_zone_output()
  config <- get_config()
  svc <- .controltower$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.controltower$operations$delete_landing_zone <- controltower_delete_landing_zone

#' This API call turns off a control
#'
#' @description
#' This API call turns off a control. It starts an asynchronous operation that deletes Amazon Web Services resources on the specified organizational unit and the accounts it contains. The resources will vary according to the control that you specify. For usage examples, see [*the Amazon Web Services Control Tower User Guide*](https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html) .
#'
#' See [https://www.paws-r-sdk.com/docs/controltower_disable_control/](https://www.paws-r-sdk.com/docs/controltower_disable_control/) for full documentation.
#'
#' @param controlIdentifier &#91;required&#93; The ARN of the control. Only **Strongly recommended** and **Elective**
#' controls are permitted, with the exception of the **landing zone Region
#' deny** control. For information on how to find the `controlIdentifier`,
#' see [the overview
#' page](https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html).
#' @param targetIdentifier &#91;required&#93; The ARN of the organizational unit. For information on how to find the
#' `targetIdentifier`, see [the overview
#' page](https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html).
#'
#' @keywords internal
#'
#' @rdname controltower_disable_control
controltower_disable_control <- function(controlIdentifier, targetIdentifier) {
  op <- new_operation(
    name = "DisableControl",
    http_method = "POST",
    http_path = "/disable-control",
    paginator = list()
  )
  input <- .controltower$disable_control_input(controlIdentifier = controlIdentifier, targetIdentifier = targetIdentifier)
  output <- .controltower$disable_control_output()
  config <- get_config()
  svc <- .controltower$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.controltower$operations$disable_control <- controltower_disable_control

#' This API call activates a control
#'
#' @description
#' This API call activates a control. It starts an asynchronous operation that creates Amazon Web Services resources on the specified organizational unit and the accounts it contains. The resources created will vary according to the control that you specify. For usage examples, see [*the Amazon Web Services Control Tower User Guide*](https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html) .
#'
#' See [https://www.paws-r-sdk.com/docs/controltower_enable_control/](https://www.paws-r-sdk.com/docs/controltower_enable_control/) for full documentation.
#'
#' @param controlIdentifier &#91;required&#93; The ARN of the control. Only **Strongly recommended** and **Elective**
#' controls are permitted, with the exception of the **landing zone Region
#' deny** control. For information on how to find the `controlIdentifier`,
#' see [the overview
#' page](https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html).
#' @param parameters An array of `EnabledControlParameter` objects
#' @param tags Tags to be applied to the `EnabledControl` resource.
#' @param targetIdentifier &#91;required&#93; The ARN of the organizational unit. For information on how to find the
#' `targetIdentifier`, see [the overview
#' page](https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html).
#'
#' @keywords internal
#'
#' @rdname controltower_enable_control
controltower_enable_control <- function(controlIdentifier, parameters = NULL, tags = NULL, targetIdentifier) {
  op <- new_operation(
    name = "EnableControl",
    http_method = "POST",
    http_path = "/enable-control",
    paginator = list()
  )
  input <- .controltower$enable_control_input(controlIdentifier = controlIdentifier, parameters = parameters, tags = tags, targetIdentifier = targetIdentifier)
  output <- .controltower$enable_control_output()
  config <- get_config()
  svc <- .controltower$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.controltower$operations$enable_control <- controltower_enable_control

#' Returns the status of a particular EnableControl or DisableControl
#' operation
#'
#' @description
#' Returns the status of a particular [`enable_control`][controltower_enable_control] or [`disable_control`][controltower_disable_control] operation. Displays a message in case of error. Details for an operation are available for 90 days. For usage examples, see [*the Amazon Web Services Control Tower User Guide*](https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html) .
#'
#' See [https://www.paws-r-sdk.com/docs/controltower_get_control_operation/](https://www.paws-r-sdk.com/docs/controltower_get_control_operation/) for full documentation.
#'
#' @param operationIdentifier &#91;required&#93; The ID of the asynchronous operation, which is used to track status. The
#' operation is available for 90 days.
#'
#' @keywords internal
#'
#' @rdname controltower_get_control_operation
controltower_get_control_operation <- function(operationIdentifier) {
  op <- new_operation(
    name = "GetControlOperation",
    http_method = "POST",
    http_path = "/get-control-operation",
    paginator = list()
  )
  input <- .controltower$get_control_operation_input(operationIdentifier = operationIdentifier)
  output <- .controltower$get_control_operation_output()
  config <- get_config()
  svc <- .controltower$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.controltower$operations$get_control_operation <- controltower_get_control_operation

#' Retrieves details about an enabled control
#'
#' @description
#' Retrieves details about an enabled control. For usage examples, see [*the Amazon Web Services Control Tower User Guide*](https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html) .
#'
#' See [https://www.paws-r-sdk.com/docs/controltower_get_enabled_control/](https://www.paws-r-sdk.com/docs/controltower_get_enabled_control/) for full documentation.
#'
#' @param enabledControlIdentifier &#91;required&#93; The `controlIdentifier` of the enabled control.
#'
#' @keywords internal
#'
#' @rdname controltower_get_enabled_control
controltower_get_enabled_control <- function(enabledControlIdentifier) {
  op <- new_operation(
    name = "GetEnabledControl",
    http_method = "POST",
    http_path = "/get-enabled-control",
    paginator = list()
  )
  input <- .controltower$get_enabled_control_input(enabledControlIdentifier = enabledControlIdentifier)
  output <- .controltower$get_enabled_control_output()
  config <- get_config()
  svc <- .controltower$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.controltower$operations$get_enabled_control <- controltower_get_enabled_control

#' Returns details about the landing zone
#'
#' @description
#' Returns details about the landing zone. Displays a message in case of error.
#'
#' See [https://www.paws-r-sdk.com/docs/controltower_get_landing_zone/](https://www.paws-r-sdk.com/docs/controltower_get_landing_zone/) for full documentation.
#'
#' @param landingZoneIdentifier &#91;required&#93; The unique identifier of the landing zone.
#'
#' @keywords internal
#'
#' @rdname controltower_get_landing_zone
controltower_get_landing_zone <- function(landingZoneIdentifier) {
  op <- new_operation(
    name = "GetLandingZone",
    http_method = "POST",
    http_path = "/get-landingzone",
    paginator = list()
  )
  input <- .controltower$get_landing_zone_input(landingZoneIdentifier = landingZoneIdentifier)
  output <- .controltower$get_landing_zone_output()
  config <- get_config()
  svc <- .controltower$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.controltower$operations$get_landing_zone <- controltower_get_landing_zone

#' Returns the status of the specified landing zone operation
#'
#' @description
#' Returns the status of the specified landing zone operation. Details for an operation are available for 60 days.
#'
#' See [https://www.paws-r-sdk.com/docs/controltower_get_landing_zone_operation/](https://www.paws-r-sdk.com/docs/controltower_get_landing_zone_operation/) for full documentation.
#'
#' @param operationIdentifier &#91;required&#93; A unique identifier assigned to a landing zone operation.
#'
#' @keywords internal
#'
#' @rdname controltower_get_landing_zone_operation
controltower_get_landing_zone_operation <- function(operationIdentifier) {
  op <- new_operation(
    name = "GetLandingZoneOperation",
    http_method = "POST",
    http_path = "/get-landingzone-operation",
    paginator = list()
  )
  input <- .controltower$get_landing_zone_operation_input(operationIdentifier = operationIdentifier)
  output <- .controltower$get_landing_zone_operation_output()
  config <- get_config()
  svc <- .controltower$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.controltower$operations$get_landing_zone_operation <- controltower_get_landing_zone_operation

#' Lists the controls enabled by Amazon Web Services Control Tower on the
#' specified organizational unit and the accounts it contains
#'
#' @description
#' Lists the controls enabled by Amazon Web Services Control Tower on the specified organizational unit and the accounts it contains. For usage examples, see [*the Amazon Web Services Control Tower User Guide*](https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html) .
#'
#' See [https://www.paws-r-sdk.com/docs/controltower_list_enabled_controls/](https://www.paws-r-sdk.com/docs/controltower_list_enabled_controls/) for full documentation.
#'
#' @param maxResults How many results to return per API call.
#' @param nextToken The token to continue the list from a previous API call with the same
#' parameters.
#' @param targetIdentifier &#91;required&#93; The ARN of the organizational unit. For information on how to find the
#' `targetIdentifier`, see [the overview
#' page](https://docs.aws.amazon.com/controltower/latest/APIReference/Welcome.html).
#'
#' @keywords internal
#'
#' @rdname controltower_list_enabled_controls
controltower_list_enabled_controls <- function(maxResults = NULL, nextToken = NULL, targetIdentifier) {
  op <- new_operation(
    name = "ListEnabledControls",
    http_method = "POST",
    http_path = "/list-enabled-controls",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "enabledControls")
  )
  input <- .controltower$list_enabled_controls_input(maxResults = maxResults, nextToken = nextToken, targetIdentifier = targetIdentifier)
  output <- .controltower$list_enabled_controls_output()
  config <- get_config()
  svc <- .controltower$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.controltower$operations$list_enabled_controls <- controltower_list_enabled_controls

#' Returns the landing zone ARN for the landing zone deployed in your
#' managed account
#'
#' @description
#' Returns the landing zone ARN for the landing zone deployed in your managed account. This API also creates an ARN for existing accounts that do not yet have a landing zone ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/controltower_list_landing_zones/](https://www.paws-r-sdk.com/docs/controltower_list_landing_zones/) for full documentation.
#'
#' @param maxResults The maximum number of returned landing zone ARNs, which is one.
#' @param nextToken The token to continue the list from a previous API call with the same
#' parameters.
#'
#' @keywords internal
#'
#' @rdname controltower_list_landing_zones
controltower_list_landing_zones <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListLandingZones",
    http_method = "POST",
    http_path = "/list-landingzones",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "landingZones")
  )
  input <- .controltower$list_landing_zones_input(maxResults = maxResults, nextToken = nextToken)
  output <- .controltower$list_landing_zones_output()
  config <- get_config()
  svc <- .controltower$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.controltower$operations$list_landing_zones <- controltower_list_landing_zones

#' Returns a list of tags associated with the resource
#'
#' @description
#' Returns a list of tags associated with the resource. For usage examples, see [*the Amazon Web Services Control Tower User Guide*](https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html) .
#'
#' See [https://www.paws-r-sdk.com/docs/controltower_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/controltower_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource.
#'
#' @keywords internal
#'
#' @rdname controltower_list_tags_for_resource
controltower_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .controltower$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .controltower$list_tags_for_resource_output()
  config <- get_config()
  svc <- .controltower$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.controltower$operations$list_tags_for_resource <- controltower_list_tags_for_resource

#' This API call resets a landing zone
#'
#' @description
#' This API call resets a landing zone. It starts an asynchronous operation that resets the landing zone to the parameters specified in its original configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/controltower_reset_landing_zone/](https://www.paws-r-sdk.com/docs/controltower_reset_landing_zone/) for full documentation.
#'
#' @param landingZoneIdentifier &#91;required&#93; The unique identifier of the landing zone.
#'
#' @keywords internal
#'
#' @rdname controltower_reset_landing_zone
controltower_reset_landing_zone <- function(landingZoneIdentifier) {
  op <- new_operation(
    name = "ResetLandingZone",
    http_method = "POST",
    http_path = "/reset-landingzone",
    paginator = list()
  )
  input <- .controltower$reset_landing_zone_input(landingZoneIdentifier = landingZoneIdentifier)
  output <- .controltower$reset_landing_zone_output()
  config <- get_config()
  svc <- .controltower$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.controltower$operations$reset_landing_zone <- controltower_reset_landing_zone

#' Applies tags to a resource
#'
#' @description
#' Applies tags to a resource. For usage examples, see [*the Amazon Web Services Control Tower User Guide*](https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html) .
#'
#' See [https://www.paws-r-sdk.com/docs/controltower_tag_resource/](https://www.paws-r-sdk.com/docs/controltower_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource to be tagged.
#' @param tags &#91;required&#93; Tags to be applied to the resource.
#'
#' @keywords internal
#'
#' @rdname controltower_tag_resource
controltower_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .controltower$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .controltower$tag_resource_output()
  config <- get_config()
  svc <- .controltower$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.controltower$operations$tag_resource <- controltower_tag_resource

#' Removes tags from a resource
#'
#' @description
#' Removes tags from a resource. For usage examples, see [*the Amazon Web Services Control Tower User Guide*](https://docs.aws.amazon.com/controltower/latest/userguide/control-api-examples-short.html) .
#'
#' See [https://www.paws-r-sdk.com/docs/controltower_untag_resource/](https://www.paws-r-sdk.com/docs/controltower_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource.
#' @param tagKeys &#91;required&#93; Tag keys to be removed from the resource.
#'
#' @keywords internal
#'
#' @rdname controltower_untag_resource
controltower_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .controltower$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .controltower$untag_resource_output()
  config <- get_config()
  svc <- .controltower$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.controltower$operations$untag_resource <- controltower_untag_resource

#' Updates the configuration of an already enabled control
#'
#' @description
#' Updates the configuration of an already enabled control.
#'
#' See [https://www.paws-r-sdk.com/docs/controltower_update_enabled_control/](https://www.paws-r-sdk.com/docs/controltower_update_enabled_control/) for full documentation.
#'
#' @param enabledControlIdentifier &#91;required&#93; The ARN of the enabled control that will be updated.
#' @param parameters &#91;required&#93; A key/value pair, where `Key` is of type `String` and `Value` is of type
#' `Document`.
#'
#' @keywords internal
#'
#' @rdname controltower_update_enabled_control
controltower_update_enabled_control <- function(enabledControlIdentifier, parameters) {
  op <- new_operation(
    name = "UpdateEnabledControl",
    http_method = "POST",
    http_path = "/update-enabled-control",
    paginator = list()
  )
  input <- .controltower$update_enabled_control_input(enabledControlIdentifier = enabledControlIdentifier, parameters = parameters)
  output <- .controltower$update_enabled_control_output()
  config <- get_config()
  svc <- .controltower$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.controltower$operations$update_enabled_control <- controltower_update_enabled_control

#' This API call updates the landing zone
#'
#' @description
#' This API call updates the landing zone. It starts an asynchronous operation that updates the landing zone based on the new landing zone version, or on the changed parameters specified in the updated manifest file.
#'
#' See [https://www.paws-r-sdk.com/docs/controltower_update_landing_zone/](https://www.paws-r-sdk.com/docs/controltower_update_landing_zone/) for full documentation.
#'
#' @param landingZoneIdentifier &#91;required&#93; The unique identifier of the landing zone.
#' @param manifest &#91;required&#93; The manifest JSON file is a text file that describes your Amazon Web
#' Services resources. For examples, review [Launch your landing
#' zone](https://docs.aws.amazon.com/controltower/latest/userguide/lz-api-launch.html).
#' @param version &#91;required&#93; The landing zone version, for example, 3.2.
#'
#' @keywords internal
#'
#' @rdname controltower_update_landing_zone
controltower_update_landing_zone <- function(landingZoneIdentifier, manifest, version) {
  op <- new_operation(
    name = "UpdateLandingZone",
    http_method = "POST",
    http_path = "/update-landingzone",
    paginator = list()
  )
  input <- .controltower$update_landing_zone_input(landingZoneIdentifier = landingZoneIdentifier, manifest = manifest, version = version)
  output <- .controltower$update_landing_zone_output()
  config <- get_config()
  svc <- .controltower$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.controltower$operations$update_landing_zone <- controltower_update_landing_zone
