# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon CloudWatch Application Insights
#'
#' @description
#' Amazon CloudWatch Application Insights is a service that helps you
#' detect common problems with your applications. It enables you to
#' pinpoint the source of issues in your applications (built with
#' technologies such as Microsoft IIS, .NET, and Microsoft SQL Server), by
#' providing key insights into detected problems.
#' 
#' After you onboard your application, CloudWatch Application Insights
#' identifies, recommends, and sets up metrics and logs. It continuously
#' analyzes and correlates your metrics and logs for unusual behavior to
#' surface actionable problems with your application. For example, if your
#' application is slow and unresponsive and leading to HTTP 500 errors in
#' your Application Load Balancer (ALB), Application Insights informs you
#' that a memory pressure problem with your SQL Server database is
#' occurring. It bases this analysis on impactful metrics and log errors.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- applicationinsights(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- applicationinsights()
#' svc$add_workload(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=applicationinsights_add_workload]{add_workload} \tab Adds a workload to a component\cr
#'  \link[=applicationinsights_create_application]{create_application} \tab Adds an application that is created from a resource group\cr
#'  \link[=applicationinsights_create_component]{create_component} \tab Creates a custom component by grouping similar standalone instances to monitor\cr
#'  \link[=applicationinsights_create_log_pattern]{create_log_pattern} \tab Adds an log pattern to a LogPatternSet\cr
#'  \link[=applicationinsights_delete_application]{delete_application} \tab Removes the specified application from monitoring\cr
#'  \link[=applicationinsights_delete_component]{delete_component} \tab Ungroups a custom component\cr
#'  \link[=applicationinsights_delete_log_pattern]{delete_log_pattern} \tab Removes the specified log pattern from a LogPatternSet\cr
#'  \link[=applicationinsights_describe_application]{describe_application} \tab Describes the application\cr
#'  \link[=applicationinsights_describe_component]{describe_component} \tab Describes a component and lists the resources that are grouped together in a component\cr
#'  \link[=applicationinsights_describe_component_configuration]{describe_component_configuration} \tab Describes the monitoring configuration of the component\cr
#'  \link[=applicationinsights_describe_component_configuration_recommendation]{describe_component_configuration_recommendation} \tab Describes the recommended monitoring configuration of the component\cr
#'  \link[=applicationinsights_describe_log_pattern]{describe_log_pattern} \tab Describe a specific log pattern from a LogPatternSet\cr
#'  \link[=applicationinsights_describe_observation]{describe_observation} \tab Describes an anomaly or error with the application\cr
#'  \link[=applicationinsights_describe_problem]{describe_problem} \tab Describes an application problem\cr
#'  \link[=applicationinsights_describe_problem_observations]{describe_problem_observations} \tab Describes the anomalies or errors associated with the problem\cr
#'  \link[=applicationinsights_describe_workload]{describe_workload} \tab Describes a workload and its configuration\cr
#'  \link[=applicationinsights_list_applications]{list_applications} \tab Lists the IDs of the applications that you are monitoring\cr
#'  \link[=applicationinsights_list_components]{list_components} \tab Lists the auto-grouped, standalone, and custom components of the application\cr
#'  \link[=applicationinsights_list_configuration_history]{list_configuration_history} \tab Lists the INFO, WARN, and ERROR events for periodic configuration updates performed by Application Insights\cr
#'  \link[=applicationinsights_list_log_patterns]{list_log_patterns} \tab Lists the log patterns in the specific log LogPatternSet\cr
#'  \link[=applicationinsights_list_log_pattern_sets]{list_log_pattern_sets} \tab Lists the log pattern sets in the specific application\cr
#'  \link[=applicationinsights_list_problems]{list_problems} \tab Lists the problems with your application\cr
#'  \link[=applicationinsights_list_tags_for_resource]{list_tags_for_resource} \tab Retrieve a list of the tags (keys and values) that are associated with a specified application\cr
#'  \link[=applicationinsights_list_workloads]{list_workloads} \tab Lists the workloads that are configured on a given component\cr
#'  \link[=applicationinsights_remove_workload]{remove_workload} \tab Remove workload from a component\cr
#'  \link[=applicationinsights_tag_resource]{tag_resource} \tab Add one or more tags (keys and values) to a specified application\cr
#'  \link[=applicationinsights_untag_resource]{untag_resource} \tab Remove one or more tags (keys and values) from a specified application\cr
#'  \link[=applicationinsights_update_application]{update_application} \tab Updates the application\cr
#'  \link[=applicationinsights_update_component]{update_component} \tab Updates the custom component name and/or the list of resources that make up the component\cr
#'  \link[=applicationinsights_update_component_configuration]{update_component_configuration} \tab Updates the monitoring configurations for the component\cr
#'  \link[=applicationinsights_update_log_pattern]{update_log_pattern} \tab Adds a log pattern to a LogPatternSet\cr
#'  \link[=applicationinsights_update_problem]{update_problem} \tab Updates the visibility of the problem or specifies the problem as RESOLVED\cr
#'  \link[=applicationinsights_update_workload]{update_workload} \tab Adds a workload to a component
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname applicationinsights
#' @export
applicationinsights <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .applicationinsights$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.applicationinsights <- list()

.applicationinsights$operations <- list()

.applicationinsights$metadata <- list(
  service_name = "applicationinsights",
  endpoints = list("*" = list(endpoint = "applicationinsights.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "applicationinsights.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "applicationinsights.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "applicationinsights.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Application Insights",
  api_version = "2018-11-25",
  signing_name = "applicationinsights",
  json_version = "1.1",
  target_prefix = "EC2WindowsBarleyService"
)

.applicationinsights$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.applicationinsights$metadata, handlers, config)
}
