% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_get_aggregate_config_rule_compliance_summary}
\alias{configservice_get_aggregate_config_rule_compliance_summary}
\title{Returns the number of compliant and noncompliant rules for one or more
accounts and regions in an aggregator}
\usage{
configservice_get_aggregate_config_rule_compliance_summary(
  ConfigurationAggregatorName, Filters, GroupByKey, Limit, NextToken)
}
\arguments{
\item{ConfigurationAggregatorName}{[required] The name of the configuration aggregator.}

\item{Filters}{Filters the results based on the ConfigRuleComplianceSummaryFilters
object.}

\item{GroupByKey}{Groups the result based on ACCOUNT\\_ID or AWS\\_REGION.}

\item{Limit}{The maximum number of evaluation results returned on each page. The
default is 1000. You cannot specify a number greater than 1000. If you
specify 0, AWS Config uses the default.}

\item{NextToken}{The \code{nextToken} string returned on a previous page that you use to get
the next page of results in a paginated response.}
}
\description{
Returns the number of compliant and noncompliant rules for one or more
accounts and regions in an aggregator.
}
\details{
The results can return an empty result page, but if you have a
nextToken, the results are displayed on the next page.
}
\section{Request syntax}{
\preformatted{svc$get_aggregate_config_rule_compliance_summary(
  ConfigurationAggregatorName = "string",
  Filters = list(
    AccountId = "string",
    AwsRegion = "string"
  ),
  GroupByKey = "ACCOUNT_ID"|"AWS_REGION",
  Limit = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
