% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_put_stored_query}
\alias{configservice_put_stored_query}
\title{Saves a new query or updates an existing saved query}
\usage{
configservice_put_stored_query(StoredQuery, Tags)
}
\arguments{
\item{StoredQuery}{[required] A list of \code{StoredQuery} objects. The mandatory fields are \code{QueryName}
and \code{Expression}.}

\item{Tags}{A list of \code{Tags} object.}
}
\value{
A list with the following syntax:\preformatted{list(
  QueryArn = "string"
)
}
}
\description{
Saves a new query or updates an existing saved query. The \code{QueryName}
must be unique for an AWS account in an AWS Region. You can create upto
300 queries in an AWS account in an AWS Region.
}
\section{Request syntax}{
\preformatted{svc$put_stored_query(
  StoredQuery = list(
    QueryId = "string",
    QueryArn = "string",
    QueryName = "string",
    Description = "string",
    Expression = "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
