% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distanceMatrix.R
\name{metricDistance}
\alias{metricDistance}
\title{Calculate Generalized Minkowski Distance Between Two Vectors}
\usage{
metricDistance(vec1, vec2, n)
}
\arguments{
\item{vec1}{Numeric vector, the first vector for which the distance will be calculated.}

\item{vec2}{Numeric vector, the second vector for which the distance will be calculated.}

\item{n}{Integer, the order of the Minkowski distance. When n=2, it becomes the Euclidean distance; when n=1, it becomes the Manhattan distance.}
}
\value{
Numeric, the computed Minkowski distance between the two vectors.
}
\description{
This function calculates the generalized Minkowski distance of order 'n' between two numeric vectors. This distance is a metric in a normed vector space which generalizes the Euclidean and Manhattan distances. It is used for various data science applications, particularly in clustering, optimization, and outlier detection in complex systems.
}
\examples{
vec1 <- c(1, 2, 3)
vec2 <- c(4, 5, 6)
n <- 2
distance <- metricDistance(vec1, vec2, n)
print(distance)
}
