% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contiguous.R
\name{contiguous}
\alias{contiguous}
\title{Are cores sampled contiguously?}
\usage{
contiguous(x, threshold = 1)
}
\arguments{
\item{x}{An object of the class "pfSiteSel"}

\item{threshold}{Numeric, threshold for considering two samples as
contiguous (default=1cm)}
}
\value{
Summary table of sites with the added contiguous logical column
(TRUE--FALSE)
}
\description{
The function checks wether cores have been sampled contiguously or with a
depth resolution <1cm.
}
\examples{
\dontrun{
x=pfSiteSel(lat>12,lat<60,long<(-50),long>-140)
contiguous(x)
}
}
\seealso{
\code{\link[paleofire]{pfResolution}}
}
\author{
O. Blarquez
}
