% Generated by roxygen2 (4.0.1): do not edit by hand
\name{pfResolution}
\alias{pfResolution}
\title{Calculates age resolution indicators for charcoal records}
\usage{
pfResolution(ID, AgeLim = NULL)
}
\arguments{
\item{ID}{An object of the class "pfSiteSel"}

\item{AgeLim}{Numeric, defines age limits for age resolution calculations
(e.g. AgeLim=c(-50,6000))}
}
\value{
\item{data.frame}{A data frame with the following informations: ID_SITE,
SITE_NAME, Median Resolution of the record, Mean Resolution and Standard
deviation}
}
\description{
Calculates age resolution indicators for charcoal records selected using
\code{\link{pfSiteSel}} or \code{\link{pfInteractive}} functions.
}
\examples{
ID=pfSiteSel(lat>40, lat<90, long>-100, long<=-50)
Res=pfResolution(ID,AgeLim=c(-50,8000))
head(Res)
}
\author{
O. Blarquez
}

