#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
# pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1161
#define LARGE_STATE_COUNT 166
#define SYMBOL_COUNT 149
#define ALIAS_COUNT 4
#define TOKEN_COUNT 67
#define EXTERNAL_TOKEN_COUNT 15
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 6

enum ts_symbol_identifiers {
  sym__backslash_escape = 1,
  sym_entity_reference = 2,
  sym_numeric_character_reference = 3,
  anon_sym_LBRACK = 4,
  anon_sym_RBRACK = 5,
  anon_sym_LT = 6,
  anon_sym_GT = 7,
  anon_sym_BANG = 8,
  anon_sym_DQUOTE = 9,
  anon_sym_POUND = 10,
  anon_sym_DOLLAR = 11,
  anon_sym_PERCENT = 12,
  anon_sym_AMP = 13,
  anon_sym_SQUOTE = 14,
  anon_sym_STAR = 15,
  anon_sym_PLUS = 16,
  anon_sym_COMMA = 17,
  anon_sym_DASH = 18,
  anon_sym_DOT = 19,
  anon_sym_SLASH = 20,
  anon_sym_COLON = 21,
  anon_sym_SEMI = 22,
  anon_sym_EQ = 23,
  anon_sym_QMARK = 24,
  anon_sym_AT = 25,
  anon_sym_BSLASH = 26,
  anon_sym_CARET = 27,
  anon_sym__ = 28,
  anon_sym_BQUOTE = 29,
  anon_sym_LBRACE = 30,
  anon_sym_PIPE = 31,
  anon_sym_RBRACE = 32,
  anon_sym_TILDE = 33,
  anon_sym_LPAREN = 34,
  anon_sym_RPAREN = 35,
  sym__newline_token = 36,
  sym_uri_autolink = 37,
  sym_email_autolink = 38,
  sym__attribute_name = 39,
  aux_sym__attribute_value_token1 = 40,
  anon_sym_LT_BANG_DASH_DASH = 41,
  anon_sym_DASH_DASH_GT = 42,
  anon_sym_LT_QMARK = 43,
  anon_sym_QMARK_GT = 44,
  aux_sym__declaration_token1 = 45,
  anon_sym_LT_BANG_LBRACKCDATA_LBRACK = 46,
  anon_sym_RBRACK_RBRACK_GT = 47,
  sym__whitespace_ge_2 = 48,
  aux_sym__whitespace_token1 = 49,
  sym__word_no_digit = 50,
  sym__digits = 51,
  sym__error = 52,
  sym__trigger_error = 53,
  sym__code_span_start = 54,
  sym__code_span_close = 55,
  sym__emphasis_open_star = 56,
  sym__emphasis_open_underscore = 57,
  sym__emphasis_close_star = 58,
  sym__emphasis_close_underscore = 59,
  sym__last_token_whitespace = 60,
  sym__last_token_punctuation = 61,
  sym__strikethrough_open = 62,
  sym__strikethrough_close = 63,
  sym__latex_span_start = 64,
  sym__latex_span_close = 65,
  sym__unclosed_span = 66,
  sym_inline = 67,
  sym_backslash_escape = 68,
  sym_link_label = 69,
  sym_link_destination = 70,
  sym__link_destination_parenthesis = 71,
  sym__text_no_angle = 72,
  sym_link_title = 73,
  sym_code_span = 74,
  sym_latex_block = 75,
  sym__link_text = 76,
  sym__link_text_non_empty = 77,
  sym_shortcut_link = 78,
  sym_full_reference_link = 79,
  sym_collapsed_reference_link = 80,
  sym_inline_link = 81,
  sym_image = 82,
  sym__image_inline_link = 83,
  sym__image_shortcut_link = 84,
  sym__image_full_reference_link = 85,
  sym__image_collapsed_reference_link = 86,
  sym__image_description = 87,
  sym__image_description_non_empty = 88,
  sym__html_tag = 89,
  sym__open_tag = 90,
  sym__closing_tag = 91,
  sym__tag_name = 92,
  sym__attribute = 93,
  sym__attribute_value = 94,
  sym__html_comment = 95,
  sym__processing_instruction = 96,
  sym__declaration = 97,
  sym__cdata_section = 98,
  sym_hard_line_break = 99,
  sym__whitespace = 100,
  sym__word = 101,
  sym__soft_line_break = 102,
  sym__inline_base = 103,
  sym__text_base = 104,
  sym__text_inline_no_link = 105,
  sym__inline_element = 106,
  aux_sym__inline = 107,
  sym__inline_element_no_star = 108,
  aux_sym__inline_no_star = 109,
  sym__inline_element_no_underscore = 110,
  aux_sym__inline_no_underscore = 111,
  sym__inline_element_no_tilde = 112,
  aux_sym__inline_no_tilde = 113,
  sym__strikethrough = 114,
  sym__emphasis_star = 115,
  sym__strong_emphasis_star = 116,
  sym__emphasis_underscore = 117,
  sym__strong_emphasis_underscore = 118,
  sym__inline_element_no_link = 119,
  aux_sym__inline_no_link = 120,
  sym__inline_element_no_star_no_link = 121,
  aux_sym__inline_no_star_no_link = 122,
  sym__inline_element_no_underscore_no_link = 123,
  aux_sym__inline_no_underscore_no_link = 124,
  sym__inline_element_no_tilde_no_link = 125,
  aux_sym__inline_no_tilde_no_link = 126,
  sym__strikethrough_no_link = 127,
  sym__emphasis_star_no_link = 128,
  sym__strong_emphasis_star_no_link = 129,
  sym__emphasis_underscore_no_link = 130,
  sym__strong_emphasis_underscore_no_link = 131,
  aux_sym_link_label_repeat1 = 132,
  aux_sym_link_destination_repeat1 = 133,
  aux_sym_link_destination_repeat2 = 134,
  aux_sym_link_title_repeat1 = 135,
  aux_sym_link_title_repeat2 = 136,
  aux_sym_link_title_repeat3 = 137,
  aux_sym_code_span_repeat1 = 138,
  aux_sym_latex_block_repeat1 = 139,
  aux_sym_inline_link_repeat1 = 140,
  aux_sym__open_tag_repeat1 = 141,
  aux_sym__tag_name_repeat1 = 142,
  aux_sym__attribute_value_repeat1 = 143,
  aux_sym__attribute_value_repeat2 = 144,
  aux_sym__html_comment_repeat1 = 145,
  aux_sym__processing_instruction_repeat1 = 146,
  aux_sym__declaration_repeat1 = 147,
  aux_sym__inline_base_repeat1 = 148,
  alias_sym_emphasis = 149,
  alias_sym_html_tag = 150,
  alias_sym_image_description = 151,
  alias_sym_link_text = 152,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym__backslash_escape] = "_backslash_escape",
  [sym_entity_reference] = "entity_reference",
  [sym_numeric_character_reference] = "numeric_character_reference",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_BANG] = "!",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_POUND] = "#",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_PERCENT] = "%",
  [anon_sym_AMP] = "&",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_STAR] = "*",
  [anon_sym_PLUS] = "+",
  [anon_sym_COMMA] = ",",
  [anon_sym_DASH] = "-",
  [anon_sym_DOT] = ".",
  [anon_sym_SLASH] = "/",
  [anon_sym_COLON] = ":",
  [anon_sym_SEMI] = ";",
  [anon_sym_EQ] = "=",
  [anon_sym_QMARK] = "\?",
  [anon_sym_AT] = "@",
  [anon_sym_BSLASH] = "\\",
  [anon_sym_CARET] = "^",
  [anon_sym__] = "_",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_LBRACE] = "{",
  [anon_sym_PIPE] = "|",
  [anon_sym_RBRACE] = "}",
  [anon_sym_TILDE] = "~",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [sym__newline_token] = "_newline_token",
  [sym_uri_autolink] = "uri_autolink",
  [sym_email_autolink] = "email_autolink",
  [sym__attribute_name] = "_attribute_name",
  [aux_sym__attribute_value_token1] = "_attribute_value_token1",
  [anon_sym_LT_BANG_DASH_DASH] = "<!--",
  [anon_sym_DASH_DASH_GT] = "-->",
  [anon_sym_LT_QMARK] = "<\?",
  [anon_sym_QMARK_GT] = "\?>",
  [aux_sym__declaration_token1] = "_declaration_token1",
  [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = "<![CDATA[",
  [anon_sym_RBRACK_RBRACK_GT] = "]]>",
  [sym__whitespace_ge_2] = "_whitespace_ge_2",
  [aux_sym__whitespace_token1] = "_whitespace_token1",
  [sym__word_no_digit] = "_word_no_digit",
  [sym__digits] = "_digits",
  [sym__error] = "_error",
  [sym__trigger_error] = "_trigger_error",
  [sym__code_span_start] = "code_span_delimiter",
  [sym__code_span_close] = "code_span_delimiter",
  [sym__emphasis_open_star] = "_emphasis_open_star",
  [sym__emphasis_open_underscore] = "_emphasis_open_underscore",
  [sym__emphasis_close_star] = "emphasis_delimiter",
  [sym__emphasis_close_underscore] = "emphasis_delimiter",
  [sym__last_token_whitespace] = "_last_token_whitespace",
  [sym__last_token_punctuation] = "_last_token_punctuation",
  [sym__strikethrough_open] = "_strikethrough_open",
  [sym__strikethrough_close] = "emphasis_delimiter",
  [sym__latex_span_start] = "latex_span_delimiter",
  [sym__latex_span_close] = "latex_span_delimiter",
  [sym__unclosed_span] = "_unclosed_span",
  [sym_inline] = "inline",
  [sym_backslash_escape] = "backslash_escape",
  [sym_link_label] = "link_label",
  [sym_link_destination] = "link_destination",
  [sym__link_destination_parenthesis] = "_link_destination_parenthesis",
  [sym__text_no_angle] = "_text_no_angle",
  [sym_link_title] = "link_title",
  [sym_code_span] = "code_span",
  [sym_latex_block] = "latex_block",
  [sym__link_text] = "_link_text",
  [sym__link_text_non_empty] = "_link_text_non_empty",
  [sym_shortcut_link] = "shortcut_link",
  [sym_full_reference_link] = "full_reference_link",
  [sym_collapsed_reference_link] = "collapsed_reference_link",
  [sym_inline_link] = "inline_link",
  [sym_image] = "image",
  [sym__image_inline_link] = "_image_inline_link",
  [sym__image_shortcut_link] = "_image_shortcut_link",
  [sym__image_full_reference_link] = "_image_full_reference_link",
  [sym__image_collapsed_reference_link] = "_image_collapsed_reference_link",
  [sym__image_description] = "_image_description",
  [sym__image_description_non_empty] = "_image_description_non_empty",
  [sym__html_tag] = "_html_tag",
  [sym__open_tag] = "_open_tag",
  [sym__closing_tag] = "_closing_tag",
  [sym__tag_name] = "_tag_name",
  [sym__attribute] = "_attribute",
  [sym__attribute_value] = "_attribute_value",
  [sym__html_comment] = "_html_comment",
  [sym__processing_instruction] = "_processing_instruction",
  [sym__declaration] = "_declaration",
  [sym__cdata_section] = "_cdata_section",
  [sym_hard_line_break] = "hard_line_break",
  [sym__whitespace] = "_whitespace",
  [sym__word] = "_word",
  [sym__soft_line_break] = "_soft_line_break",
  [sym__inline_base] = "_inline_base",
  [sym__text_base] = "_text_base",
  [sym__text_inline_no_link] = "_text_inline_no_link",
  [sym__inline_element] = "_inline_element",
  [aux_sym__inline] = "_inline",
  [sym__inline_element_no_star] = "_inline_element_no_star",
  [aux_sym__inline_no_star] = "_inline_no_star",
  [sym__inline_element_no_underscore] = "_inline_element_no_underscore",
  [aux_sym__inline_no_underscore] = "_inline_no_underscore",
  [sym__inline_element_no_tilde] = "_inline_element_no_tilde",
  [aux_sym__inline_no_tilde] = "_inline_no_tilde",
  [sym__strikethrough] = "strikethrough",
  [sym__emphasis_star] = "_emphasis_star",
  [sym__strong_emphasis_star] = "strong_emphasis",
  [sym__emphasis_underscore] = "_emphasis_underscore",
  [sym__strong_emphasis_underscore] = "strong_emphasis",
  [sym__inline_element_no_link] = "_inline_element_no_link",
  [aux_sym__inline_no_link] = "_inline_no_link",
  [sym__inline_element_no_star_no_link] = "_inline_element_no_star_no_link",
  [aux_sym__inline_no_star_no_link] = "_inline_no_star_no_link",
  [sym__inline_element_no_underscore_no_link] = "_inline_element_no_underscore_no_link",
  [aux_sym__inline_no_underscore_no_link] = "_inline_no_underscore_no_link",
  [sym__inline_element_no_tilde_no_link] = "_inline_element_no_tilde_no_link",
  [aux_sym__inline_no_tilde_no_link] = "_inline_no_tilde_no_link",
  [sym__strikethrough_no_link] = "strikethrough",
  [sym__emphasis_star_no_link] = "_emphasis_star_no_link",
  [sym__strong_emphasis_star_no_link] = "strong_emphasis",
  [sym__emphasis_underscore_no_link] = "_emphasis_underscore_no_link",
  [sym__strong_emphasis_underscore_no_link] = "strong_emphasis",
  [aux_sym_link_label_repeat1] = "link_label_repeat1",
  [aux_sym_link_destination_repeat1] = "link_destination_repeat1",
  [aux_sym_link_destination_repeat2] = "link_destination_repeat2",
  [aux_sym_link_title_repeat1] = "link_title_repeat1",
  [aux_sym_link_title_repeat2] = "link_title_repeat2",
  [aux_sym_link_title_repeat3] = "link_title_repeat3",
  [aux_sym_code_span_repeat1] = "code_span_repeat1",
  [aux_sym_latex_block_repeat1] = "latex_block_repeat1",
  [aux_sym_inline_link_repeat1] = "inline_link_repeat1",
  [aux_sym__open_tag_repeat1] = "_open_tag_repeat1",
  [aux_sym__tag_name_repeat1] = "_tag_name_repeat1",
  [aux_sym__attribute_value_repeat1] = "_attribute_value_repeat1",
  [aux_sym__attribute_value_repeat2] = "_attribute_value_repeat2",
  [aux_sym__html_comment_repeat1] = "_html_comment_repeat1",
  [aux_sym__processing_instruction_repeat1] = "_processing_instruction_repeat1",
  [aux_sym__declaration_repeat1] = "_declaration_repeat1",
  [aux_sym__inline_base_repeat1] = "_inline_base_repeat1",
  [alias_sym_emphasis] = "emphasis",
  [alias_sym_html_tag] = "html_tag",
  [alias_sym_image_description] = "image_description",
  [alias_sym_link_text] = "link_text",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym__backslash_escape] = sym__backslash_escape,
  [sym_entity_reference] = sym_entity_reference,
  [sym_numeric_character_reference] = sym_numeric_character_reference,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym__] = anon_sym__,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [sym__newline_token] = sym__newline_token,
  [sym_uri_autolink] = sym_uri_autolink,
  [sym_email_autolink] = sym_email_autolink,
  [sym__attribute_name] = sym__attribute_name,
  [aux_sym__attribute_value_token1] = aux_sym__attribute_value_token1,
  [anon_sym_LT_BANG_DASH_DASH] = anon_sym_LT_BANG_DASH_DASH,
  [anon_sym_DASH_DASH_GT] = anon_sym_DASH_DASH_GT,
  [anon_sym_LT_QMARK] = anon_sym_LT_QMARK,
  [anon_sym_QMARK_GT] = anon_sym_QMARK_GT,
  [aux_sym__declaration_token1] = aux_sym__declaration_token1,
  [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
  [anon_sym_RBRACK_RBRACK_GT] = anon_sym_RBRACK_RBRACK_GT,
  [sym__whitespace_ge_2] = sym__whitespace_ge_2,
  [aux_sym__whitespace_token1] = aux_sym__whitespace_token1,
  [sym__word_no_digit] = sym__word_no_digit,
  [sym__digits] = sym__digits,
  [sym__error] = sym__error,
  [sym__trigger_error] = sym__trigger_error,
  [sym__code_span_start] = sym__code_span_start,
  [sym__code_span_close] = sym__code_span_start,
  [sym__emphasis_open_star] = sym__emphasis_open_star,
  [sym__emphasis_open_underscore] = sym__emphasis_open_underscore,
  [sym__emphasis_close_star] = sym__emphasis_close_star,
  [sym__emphasis_close_underscore] = sym__emphasis_close_star,
  [sym__last_token_whitespace] = sym__last_token_whitespace,
  [sym__last_token_punctuation] = sym__last_token_punctuation,
  [sym__strikethrough_open] = sym__strikethrough_open,
  [sym__strikethrough_close] = sym__emphasis_close_star,
  [sym__latex_span_start] = sym__latex_span_start,
  [sym__latex_span_close] = sym__latex_span_start,
  [sym__unclosed_span] = sym__unclosed_span,
  [sym_inline] = sym_inline,
  [sym_backslash_escape] = sym_backslash_escape,
  [sym_link_label] = sym_link_label,
  [sym_link_destination] = sym_link_destination,
  [sym__link_destination_parenthesis] = sym__link_destination_parenthesis,
  [sym__text_no_angle] = sym__text_no_angle,
  [sym_link_title] = sym_link_title,
  [sym_code_span] = sym_code_span,
  [sym_latex_block] = sym_latex_block,
  [sym__link_text] = sym__link_text,
  [sym__link_text_non_empty] = sym__link_text_non_empty,
  [sym_shortcut_link] = sym_shortcut_link,
  [sym_full_reference_link] = sym_full_reference_link,
  [sym_collapsed_reference_link] = sym_collapsed_reference_link,
  [sym_inline_link] = sym_inline_link,
  [sym_image] = sym_image,
  [sym__image_inline_link] = sym__image_inline_link,
  [sym__image_shortcut_link] = sym__image_shortcut_link,
  [sym__image_full_reference_link] = sym__image_full_reference_link,
  [sym__image_collapsed_reference_link] = sym__image_collapsed_reference_link,
  [sym__image_description] = sym__image_description,
  [sym__image_description_non_empty] = sym__image_description_non_empty,
  [sym__html_tag] = sym__html_tag,
  [sym__open_tag] = sym__open_tag,
  [sym__closing_tag] = sym__closing_tag,
  [sym__tag_name] = sym__tag_name,
  [sym__attribute] = sym__attribute,
  [sym__attribute_value] = sym__attribute_value,
  [sym__html_comment] = sym__html_comment,
  [sym__processing_instruction] = sym__processing_instruction,
  [sym__declaration] = sym__declaration,
  [sym__cdata_section] = sym__cdata_section,
  [sym_hard_line_break] = sym_hard_line_break,
  [sym__whitespace] = sym__whitespace,
  [sym__word] = sym__word,
  [sym__soft_line_break] = sym__soft_line_break,
  [sym__inline_base] = sym__inline_base,
  [sym__text_base] = sym__text_base,
  [sym__text_inline_no_link] = sym__text_inline_no_link,
  [sym__inline_element] = sym__inline_element,
  [aux_sym__inline] = aux_sym__inline,
  [sym__inline_element_no_star] = sym__inline_element_no_star,
  [aux_sym__inline_no_star] = aux_sym__inline_no_star,
  [sym__inline_element_no_underscore] = sym__inline_element_no_underscore,
  [aux_sym__inline_no_underscore] = aux_sym__inline_no_underscore,
  [sym__inline_element_no_tilde] = sym__inline_element_no_tilde,
  [aux_sym__inline_no_tilde] = aux_sym__inline_no_tilde,
  [sym__strikethrough] = sym__strikethrough,
  [sym__emphasis_star] = sym__emphasis_star,
  [sym__strong_emphasis_star] = sym__strong_emphasis_star,
  [sym__emphasis_underscore] = sym__emphasis_underscore,
  [sym__strong_emphasis_underscore] = sym__strong_emphasis_star,
  [sym__inline_element_no_link] = sym__inline_element_no_link,
  [aux_sym__inline_no_link] = aux_sym__inline_no_link,
  [sym__inline_element_no_star_no_link] = sym__inline_element_no_star_no_link,
  [aux_sym__inline_no_star_no_link] = aux_sym__inline_no_star_no_link,
  [sym__inline_element_no_underscore_no_link] = sym__inline_element_no_underscore_no_link,
  [aux_sym__inline_no_underscore_no_link] = aux_sym__inline_no_underscore_no_link,
  [sym__inline_element_no_tilde_no_link] = sym__inline_element_no_tilde_no_link,
  [aux_sym__inline_no_tilde_no_link] = aux_sym__inline_no_tilde_no_link,
  [sym__strikethrough_no_link] = sym__strikethrough,
  [sym__emphasis_star_no_link] = sym__emphasis_star_no_link,
  [sym__strong_emphasis_star_no_link] = sym__strong_emphasis_star,
  [sym__emphasis_underscore_no_link] = sym__emphasis_underscore_no_link,
  [sym__strong_emphasis_underscore_no_link] = sym__strong_emphasis_star,
  [aux_sym_link_label_repeat1] = aux_sym_link_label_repeat1,
  [aux_sym_link_destination_repeat1] = aux_sym_link_destination_repeat1,
  [aux_sym_link_destination_repeat2] = aux_sym_link_destination_repeat2,
  [aux_sym_link_title_repeat1] = aux_sym_link_title_repeat1,
  [aux_sym_link_title_repeat2] = aux_sym_link_title_repeat2,
  [aux_sym_link_title_repeat3] = aux_sym_link_title_repeat3,
  [aux_sym_code_span_repeat1] = aux_sym_code_span_repeat1,
  [aux_sym_latex_block_repeat1] = aux_sym_latex_block_repeat1,
  [aux_sym_inline_link_repeat1] = aux_sym_inline_link_repeat1,
  [aux_sym__open_tag_repeat1] = aux_sym__open_tag_repeat1,
  [aux_sym__tag_name_repeat1] = aux_sym__tag_name_repeat1,
  [aux_sym__attribute_value_repeat1] = aux_sym__attribute_value_repeat1,
  [aux_sym__attribute_value_repeat2] = aux_sym__attribute_value_repeat2,
  [aux_sym__html_comment_repeat1] = aux_sym__html_comment_repeat1,
  [aux_sym__processing_instruction_repeat1] = aux_sym__processing_instruction_repeat1,
  [aux_sym__declaration_repeat1] = aux_sym__declaration_repeat1,
  [aux_sym__inline_base_repeat1] = aux_sym__inline_base_repeat1,
  [alias_sym_emphasis] = alias_sym_emphasis,
  [alias_sym_html_tag] = alias_sym_html_tag,
  [alias_sym_image_description] = alias_sym_image_description,
  [alias_sym_link_text] = alias_sym_link_text,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym__backslash_escape] = {
    .visible = false,
    .named = true,
  },
  [sym_entity_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_numeric_character_reference] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym__newline_token] = {
    .visible = false,
    .named = true,
  },
  [sym_uri_autolink] = {
    .visible = true,
    .named = true,
  },
  [sym_email_autolink] = {
    .visible = true,
    .named = true,
  },
  [sym__attribute_name] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__attribute_value_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LT_BANG_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_GT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__declaration_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK_GT] = {
    .visible = true,
    .named = false,
  },
  [sym__whitespace_ge_2] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__whitespace_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__word_no_digit] = {
    .visible = false,
    .named = true,
  },
  [sym__digits] = {
    .visible = false,
    .named = true,
  },
  [sym__error] = {
    .visible = false,
    .named = true,
  },
  [sym__trigger_error] = {
    .visible = false,
    .named = true,
  },
  [sym__code_span_start] = {
    .visible = true,
    .named = true,
  },
  [sym__code_span_close] = {
    .visible = true,
    .named = true,
  },
  [sym__emphasis_open_star] = {
    .visible = false,
    .named = true,
  },
  [sym__emphasis_open_underscore] = {
    .visible = false,
    .named = true,
  },
  [sym__emphasis_close_star] = {
    .visible = true,
    .named = true,
  },
  [sym__emphasis_close_underscore] = {
    .visible = true,
    .named = true,
  },
  [sym__last_token_whitespace] = {
    .visible = false,
    .named = true,
  },
  [sym__last_token_punctuation] = {
    .visible = false,
    .named = true,
  },
  [sym__strikethrough_open] = {
    .visible = false,
    .named = true,
  },
  [sym__strikethrough_close] = {
    .visible = true,
    .named = true,
  },
  [sym__latex_span_start] = {
    .visible = true,
    .named = true,
  },
  [sym__latex_span_close] = {
    .visible = true,
    .named = true,
  },
  [sym__unclosed_span] = {
    .visible = false,
    .named = true,
  },
  [sym_inline] = {
    .visible = true,
    .named = true,
  },
  [sym_backslash_escape] = {
    .visible = true,
    .named = true,
  },
  [sym_link_label] = {
    .visible = true,
    .named = true,
  },
  [sym_link_destination] = {
    .visible = true,
    .named = true,
  },
  [sym__link_destination_parenthesis] = {
    .visible = false,
    .named = true,
  },
  [sym__text_no_angle] = {
    .visible = false,
    .named = true,
  },
  [sym_link_title] = {
    .visible = true,
    .named = true,
  },
  [sym_code_span] = {
    .visible = true,
    .named = true,
  },
  [sym_latex_block] = {
    .visible = true,
    .named = true,
  },
  [sym__link_text] = {
    .visible = false,
    .named = true,
  },
  [sym__link_text_non_empty] = {
    .visible = false,
    .named = true,
  },
  [sym_shortcut_link] = {
    .visible = true,
    .named = true,
  },
  [sym_full_reference_link] = {
    .visible = true,
    .named = true,
  },
  [sym_collapsed_reference_link] = {
    .visible = true,
    .named = true,
  },
  [sym_inline_link] = {
    .visible = true,
    .named = true,
  },
  [sym_image] = {
    .visible = true,
    .named = true,
  },
  [sym__image_inline_link] = {
    .visible = false,
    .named = true,
  },
  [sym__image_shortcut_link] = {
    .visible = false,
    .named = true,
  },
  [sym__image_full_reference_link] = {
    .visible = false,
    .named = true,
  },
  [sym__image_collapsed_reference_link] = {
    .visible = false,
    .named = true,
  },
  [sym__image_description] = {
    .visible = false,
    .named = true,
  },
  [sym__image_description_non_empty] = {
    .visible = false,
    .named = true,
  },
  [sym__html_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__open_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__closing_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__tag_name] = {
    .visible = false,
    .named = true,
  },
  [sym__attribute] = {
    .visible = false,
    .named = true,
  },
  [sym__attribute_value] = {
    .visible = false,
    .named = true,
  },
  [sym__html_comment] = {
    .visible = false,
    .named = true,
  },
  [sym__processing_instruction] = {
    .visible = false,
    .named = true,
  },
  [sym__declaration] = {
    .visible = false,
    .named = true,
  },
  [sym__cdata_section] = {
    .visible = false,
    .named = true,
  },
  [sym_hard_line_break] = {
    .visible = true,
    .named = true,
  },
  [sym__whitespace] = {
    .visible = false,
    .named = true,
  },
  [sym__word] = {
    .visible = false,
    .named = true,
  },
  [sym__soft_line_break] = {
    .visible = false,
    .named = true,
  },
  [sym__inline_base] = {
    .visible = false,
    .named = true,
  },
  [sym__text_base] = {
    .visible = false,
    .named = true,
  },
  [sym__text_inline_no_link] = {
    .visible = false,
    .named = true,
  },
  [sym__inline_element] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__inline] = {
    .visible = false,
    .named = false,
  },
  [sym__inline_element_no_star] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__inline_no_star] = {
    .visible = false,
    .named = false,
  },
  [sym__inline_element_no_underscore] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__inline_no_underscore] = {
    .visible = false,
    .named = false,
  },
  [sym__inline_element_no_tilde] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__inline_no_tilde] = {
    .visible = false,
    .named = false,
  },
  [sym__strikethrough] = {
    .visible = true,
    .named = true,
  },
  [sym__emphasis_star] = {
    .visible = false,
    .named = true,
  },
  [sym__strong_emphasis_star] = {
    .visible = true,
    .named = true,
  },
  [sym__emphasis_underscore] = {
    .visible = false,
    .named = true,
  },
  [sym__strong_emphasis_underscore] = {
    .visible = true,
    .named = true,
  },
  [sym__inline_element_no_link] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__inline_no_link] = {
    .visible = false,
    .named = false,
  },
  [sym__inline_element_no_star_no_link] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__inline_no_star_no_link] = {
    .visible = false,
    .named = false,
  },
  [sym__inline_element_no_underscore_no_link] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__inline_no_underscore_no_link] = {
    .visible = false,
    .named = false,
  },
  [sym__inline_element_no_tilde_no_link] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__inline_no_tilde_no_link] = {
    .visible = false,
    .named = false,
  },
  [sym__strikethrough_no_link] = {
    .visible = true,
    .named = true,
  },
  [sym__emphasis_star_no_link] = {
    .visible = false,
    .named = true,
  },
  [sym__strong_emphasis_star_no_link] = {
    .visible = true,
    .named = true,
  },
  [sym__emphasis_underscore_no_link] = {
    .visible = false,
    .named = true,
  },
  [sym__strong_emphasis_underscore_no_link] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_link_label_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_link_destination_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_link_destination_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_link_title_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_link_title_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_link_title_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_code_span_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_latex_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_inline_link_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__open_tag_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__tag_name_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__attribute_value_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__attribute_value_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__html_comment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__processing_instruction_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__inline_base_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_emphasis] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_html_tag] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_image_description] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_link_text] = {
    .visible = true,
    .named = true,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_html_tag,
  },
  [2] = {
    [0] = alias_sym_emphasis,
  },
  [3] = {
    [0] = sym__emphasis_close_star,
  },
  [4] = {
    [1] = alias_sym_link_text,
  },
  [5] = {
    [2] = alias_sym_image_description,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__html_tag, 2,
    sym__html_tag,
    alias_sym_html_tag,
  aux_sym__inline, 2,
    aux_sym__inline,
    alias_sym_image_description,
  sym__emphasis_star, 2,
    sym__emphasis_star,
    alias_sym_emphasis,
  sym__emphasis_underscore, 2,
    sym__emphasis_underscore,
    alias_sym_emphasis,
  aux_sym__inline_no_link, 2,
    aux_sym__inline_no_link,
    alias_sym_link_text,
  sym__emphasis_star_no_link, 2,
    sym__emphasis_star_no_link,
    alias_sym_emphasis,
  sym__emphasis_underscore_no_link, 2,
    sym__emphasis_underscore_no_link,
    alias_sym_emphasis,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 11,
  [17] = 17,
  [18] = 12,
  [19] = 19,
  [20] = 13,
  [21] = 21,
  [22] = 22,
  [23] = 22,
  [24] = 13,
  [25] = 25,
  [26] = 11,
  [27] = 11,
  [28] = 13,
  [29] = 22,
  [30] = 12,
  [31] = 31,
  [32] = 22,
  [33] = 6,
  [34] = 4,
  [35] = 3,
  [36] = 36,
  [37] = 13,
  [38] = 38,
  [39] = 22,
  [40] = 17,
  [41] = 12,
  [42] = 14,
  [43] = 14,
  [44] = 17,
  [45] = 45,
  [46] = 46,
  [47] = 11,
  [48] = 14,
  [49] = 12,
  [50] = 14,
  [51] = 17,
  [52] = 17,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 53,
  [57] = 57,
  [58] = 58,
  [59] = 57,
  [60] = 60,
  [61] = 54,
  [62] = 55,
  [63] = 54,
  [64] = 57,
  [65] = 53,
  [66] = 55,
  [67] = 60,
  [68] = 60,
  [69] = 54,
  [70] = 55,
  [71] = 60,
  [72] = 54,
  [73] = 60,
  [74] = 57,
  [75] = 53,
  [76] = 55,
  [77] = 54,
  [78] = 60,
  [79] = 25,
  [80] = 53,
  [81] = 54,
  [82] = 60,
  [83] = 57,
  [84] = 54,
  [85] = 60,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 87,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 100,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 102,
  [111] = 102,
  [112] = 107,
  [113] = 105,
  [114] = 107,
  [115] = 108,
  [116] = 100,
  [117] = 117,
  [118] = 118,
  [119] = 104,
  [120] = 120,
  [121] = 118,
  [122] = 118,
  [123] = 108,
  [124] = 104,
  [125] = 125,
  [126] = 100,
  [127] = 104,
  [128] = 107,
  [129] = 105,
  [130] = 108,
  [131] = 105,
  [132] = 118,
  [133] = 133,
  [134] = 104,
  [135] = 102,
  [136] = 136,
  [137] = 137,
  [138] = 136,
  [139] = 137,
  [140] = 140,
  [141] = 140,
  [142] = 137,
  [143] = 140,
  [144] = 136,
  [145] = 140,
  [146] = 136,
  [147] = 137,
  [148] = 148,
  [149] = 149,
  [150] = 148,
  [151] = 149,
  [152] = 148,
  [153] = 149,
  [154] = 149,
  [155] = 148,
  [156] = 149,
  [157] = 148,
  [158] = 149,
  [159] = 149,
  [160] = 148,
  [161] = 149,
  [162] = 148,
  [163] = 149,
  [164] = 148,
  [165] = 148,
  [166] = 166,
  [167] = 167,
  [168] = 166,
  [169] = 166,
  [170] = 166,
  [171] = 167,
  [172] = 167,
  [173] = 167,
  [174] = 167,
  [175] = 167,
  [176] = 166,
  [177] = 166,
  [178] = 167,
  [179] = 166,
  [180] = 180,
  [181] = 180,
  [182] = 167,
  [183] = 166,
  [184] = 166,
  [185] = 180,
  [186] = 180,
  [187] = 167,
  [188] = 180,
  [189] = 180,
  [190] = 180,
  [191] = 191,
  [192] = 192,
  [193] = 180,
  [194] = 192,
  [195] = 192,
  [196] = 191,
  [197] = 180,
  [198] = 198,
  [199] = 191,
  [200] = 192,
  [201] = 191,
  [202] = 192,
  [203] = 191,
  [204] = 204,
  [205] = 204,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 207,
  [210] = 204,
  [211] = 207,
  [212] = 204,
  [213] = 206,
  [214] = 208,
  [215] = 208,
  [216] = 206,
  [217] = 208,
  [218] = 207,
  [219] = 206,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 207,
  [226] = 226,
  [227] = 227,
  [228] = 223,
  [229] = 224,
  [230] = 224,
  [231] = 231,
  [232] = 221,
  [233] = 204,
  [234] = 224,
  [235] = 223,
  [236] = 226,
  [237] = 237,
  [238] = 206,
  [239] = 231,
  [240] = 240,
  [241] = 231,
  [242] = 242,
  [243] = 208,
  [244] = 240,
  [245] = 240,
  [246] = 240,
  [247] = 221,
  [248] = 223,
  [249] = 221,
  [250] = 231,
  [251] = 221,
  [252] = 223,
  [253] = 223,
  [254] = 237,
  [255] = 226,
  [256] = 223,
  [257] = 224,
  [258] = 258,
  [259] = 226,
  [260] = 237,
  [261] = 237,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 237,
  [280] = 272,
  [281] = 281,
  [282] = 282,
  [283] = 269,
  [284] = 284,
  [285] = 285,
  [286] = 286,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 237,
  [291] = 291,
  [292] = 292,
  [293] = 293,
  [294] = 240,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 289,
  [301] = 301,
  [302] = 231,
  [303] = 273,
  [304] = 304,
  [305] = 237,
  [306] = 268,
  [307] = 307,
  [308] = 308,
  [309] = 226,
  [310] = 310,
  [311] = 268,
  [312] = 312,
  [313] = 269,
  [314] = 237,
  [315] = 272,
  [316] = 272,
  [317] = 317,
  [318] = 298,
  [319] = 319,
  [320] = 269,
  [321] = 297,
  [322] = 276,
  [323] = 277,
  [324] = 268,
  [325] = 278,
  [326] = 326,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 223,
  [331] = 331,
  [332] = 312,
  [333] = 273,
  [334] = 258,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 263,
  [342] = 342,
  [343] = 273,
  [344] = 310,
  [345] = 301,
  [346] = 264,
  [347] = 265,
  [348] = 266,
  [349] = 267,
  [350] = 289,
  [351] = 299,
  [352] = 295,
  [353] = 326,
  [354] = 275,
  [355] = 286,
  [356] = 293,
  [357] = 291,
  [358] = 292,
  [359] = 270,
  [360] = 289,
  [361] = 361,
  [362] = 329,
  [363] = 363,
  [364] = 336,
  [365] = 365,
  [366] = 361,
  [367] = 367,
  [368] = 368,
  [369] = 363,
  [370] = 368,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 371,
  [375] = 375,
  [376] = 376,
  [377] = 331,
  [378] = 378,
  [379] = 335,
  [380] = 372,
  [381] = 273,
  [382] = 373,
  [383] = 268,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 390,
  [391] = 237,
  [392] = 392,
  [393] = 262,
  [394] = 328,
  [395] = 327,
  [396] = 319,
  [397] = 317,
  [398] = 307,
  [399] = 304,
  [400] = 298,
  [401] = 297,
  [402] = 338,
  [403] = 308,
  [404] = 296,
  [405] = 288,
  [406] = 284,
  [407] = 276,
  [408] = 269,
  [409] = 277,
  [410] = 272,
  [411] = 284,
  [412] = 288,
  [413] = 390,
  [414] = 389,
  [415] = 304,
  [416] = 307,
  [417] = 317,
  [418] = 319,
  [419] = 327,
  [420] = 328,
  [421] = 312,
  [422] = 388,
  [423] = 278,
  [424] = 296,
  [425] = 387,
  [426] = 386,
  [427] = 308,
  [428] = 385,
  [429] = 338,
  [430] = 326,
  [431] = 329,
  [432] = 375,
  [433] = 264,
  [434] = 265,
  [435] = 266,
  [436] = 267,
  [437] = 270,
  [438] = 331,
  [439] = 275,
  [440] = 286,
  [441] = 291,
  [442] = 292,
  [443] = 293,
  [444] = 295,
  [445] = 299,
  [446] = 301,
  [447] = 310,
  [448] = 365,
  [449] = 361,
  [450] = 335,
  [451] = 363,
  [452] = 368,
  [453] = 371,
  [454] = 372,
  [455] = 373,
  [456] = 262,
  [457] = 375,
  [458] = 376,
  [459] = 342,
  [460] = 263,
  [461] = 340,
  [462] = 339,
  [463] = 336,
  [464] = 384,
  [465] = 385,
  [466] = 386,
  [467] = 387,
  [468] = 388,
  [469] = 389,
  [470] = 390,
  [471] = 390,
  [472] = 389,
  [473] = 388,
  [474] = 387,
  [475] = 386,
  [476] = 335,
  [477] = 331,
  [478] = 289,
  [479] = 384,
  [480] = 329,
  [481] = 326,
  [482] = 338,
  [483] = 308,
  [484] = 296,
  [485] = 385,
  [486] = 384,
  [487] = 336,
  [488] = 278,
  [489] = 277,
  [490] = 276,
  [491] = 284,
  [492] = 288,
  [493] = 297,
  [494] = 298,
  [495] = 304,
  [496] = 307,
  [497] = 317,
  [498] = 319,
  [499] = 327,
  [500] = 328,
  [501] = 312,
  [502] = 339,
  [503] = 339,
  [504] = 340,
  [505] = 340,
  [506] = 263,
  [507] = 507,
  [508] = 342,
  [509] = 376,
  [510] = 365,
  [511] = 342,
  [512] = 376,
  [513] = 264,
  [514] = 265,
  [515] = 266,
  [516] = 267,
  [517] = 270,
  [518] = 375,
  [519] = 275,
  [520] = 286,
  [521] = 291,
  [522] = 292,
  [523] = 293,
  [524] = 295,
  [525] = 299,
  [526] = 301,
  [527] = 310,
  [528] = 365,
  [529] = 361,
  [530] = 262,
  [531] = 363,
  [532] = 368,
  [533] = 371,
  [534] = 372,
  [535] = 373,
  [536] = 385,
  [537] = 266,
  [538] = 266,
  [539] = 298,
  [540] = 297,
  [541] = 276,
  [542] = 277,
  [543] = 278,
  [544] = 326,
  [545] = 329,
  [546] = 331,
  [547] = 335,
  [548] = 336,
  [549] = 339,
  [550] = 340,
  [551] = 263,
  [552] = 342,
  [553] = 310,
  [554] = 301,
  [555] = 299,
  [556] = 295,
  [557] = 293,
  [558] = 291,
  [559] = 270,
  [560] = 266,
  [561] = 266,
  [562] = 312,
  [563] = 328,
  [564] = 327,
  [565] = 319,
  [566] = 317,
  [567] = 307,
  [568] = 304,
  [569] = 288,
  [570] = 284,
  [571] = 292,
  [572] = 287,
  [573] = 274,
  [574] = 271,
  [575] = 386,
  [576] = 387,
  [577] = 365,
  [578] = 361,
  [579] = 388,
  [580] = 363,
  [581] = 368,
  [582] = 371,
  [583] = 372,
  [584] = 373,
  [585] = 262,
  [586] = 375,
  [587] = 376,
  [588] = 389,
  [589] = 390,
  [590] = 308,
  [591] = 296,
  [592] = 264,
  [593] = 265,
  [594] = 266,
  [595] = 267,
  [596] = 338,
  [597] = 384,
  [598] = 275,
  [599] = 286,
  [600] = 600,
  [601] = 601,
  [602] = 602,
  [603] = 603,
  [604] = 604,
  [605] = 605,
  [606] = 606,
  [607] = 601,
  [608] = 606,
  [609] = 604,
  [610] = 600,
  [611] = 603,
  [612] = 602,
  [613] = 613,
  [614] = 614,
  [615] = 615,
  [616] = 616,
  [617] = 617,
  [618] = 601,
  [619] = 614,
  [620] = 620,
  [621] = 600,
  [622] = 622,
  [623] = 606,
  [624] = 622,
  [625] = 604,
  [626] = 603,
  [627] = 602,
  [628] = 613,
  [629] = 613,
  [630] = 602,
  [631] = 603,
  [632] = 620,
  [633] = 604,
  [634] = 606,
  [635] = 600,
  [636] = 620,
  [637] = 620,
  [638] = 622,
  [639] = 613,
  [640] = 622,
  [641] = 641,
  [642] = 614,
  [643] = 601,
  [644] = 614,
  [645] = 645,
  [646] = 646,
  [647] = 647,
  [648] = 647,
  [649] = 646,
  [650] = 645,
  [651] = 651,
  [652] = 651,
  [653] = 647,
  [654] = 654,
  [655] = 655,
  [656] = 651,
  [657] = 167,
  [658] = 645,
  [659] = 166,
  [660] = 646,
  [661] = 647,
  [662] = 646,
  [663] = 645,
  [664] = 647,
  [665] = 645,
  [666] = 646,
  [667] = 651,
  [668] = 651,
  [669] = 669,
  [670] = 231,
  [671] = 240,
  [672] = 180,
  [673] = 167,
  [674] = 166,
  [675] = 226,
  [676] = 310,
  [677] = 291,
  [678] = 180,
  [679] = 312,
  [680] = 293,
  [681] = 681,
  [682] = 206,
  [683] = 683,
  [684] = 684,
  [685] = 685,
  [686] = 686,
  [687] = 687,
  [688] = 688,
  [689] = 204,
  [690] = 690,
  [691] = 691,
  [692] = 692,
  [693] = 204,
  [694] = 694,
  [695] = 226,
  [696] = 231,
  [697] = 240,
  [698] = 698,
  [699] = 699,
  [700] = 700,
  [701] = 701,
  [702] = 702,
  [703] = 703,
  [704] = 206,
  [705] = 705,
  [706] = 339,
  [707] = 226,
  [708] = 231,
  [709] = 276,
  [710] = 277,
  [711] = 278,
  [712] = 326,
  [713] = 240,
  [714] = 705,
  [715] = 329,
  [716] = 705,
  [717] = 331,
  [718] = 718,
  [719] = 718,
  [720] = 718,
  [721] = 705,
  [722] = 335,
  [723] = 705,
  [724] = 718,
  [725] = 336,
  [726] = 297,
  [727] = 340,
  [728] = 705,
  [729] = 263,
  [730] = 342,
  [731] = 310,
  [732] = 301,
  [733] = 299,
  [734] = 295,
  [735] = 298,
  [736] = 312,
  [737] = 293,
  [738] = 291,
  [739] = 270,
  [740] = 740,
  [741] = 741,
  [742] = 718,
  [743] = 718,
  [744] = 744,
  [745] = 745,
  [746] = 705,
  [747] = 718,
  [748] = 748,
  [749] = 749,
  [750] = 749,
  [751] = 751,
  [752] = 752,
  [753] = 749,
  [754] = 754,
  [755] = 755,
  [756] = 748,
  [757] = 757,
  [758] = 758,
  [759] = 748,
  [760] = 755,
  [761] = 761,
  [762] = 754,
  [763] = 757,
  [764] = 751,
  [765] = 749,
  [766] = 752,
  [767] = 751,
  [768] = 758,
  [769] = 757,
  [770] = 758,
  [771] = 758,
  [772] = 757,
  [773] = 749,
  [774] = 751,
  [775] = 748,
  [776] = 752,
  [777] = 755,
  [778] = 748,
  [779] = 755,
  [780] = 278,
  [781] = 754,
  [782] = 754,
  [783] = 754,
  [784] = 298,
  [785] = 297,
  [786] = 276,
  [787] = 277,
  [788] = 755,
  [789] = 326,
  [790] = 329,
  [791] = 752,
  [792] = 331,
  [793] = 748,
  [794] = 755,
  [795] = 751,
  [796] = 754,
  [797] = 335,
  [798] = 336,
  [799] = 339,
  [800] = 800,
  [801] = 340,
  [802] = 800,
  [803] = 263,
  [804] = 342,
  [805] = 310,
  [806] = 301,
  [807] = 299,
  [808] = 754,
  [809] = 749,
  [810] = 758,
  [811] = 757,
  [812] = 751,
  [813] = 295,
  [814] = 752,
  [815] = 751,
  [816] = 293,
  [817] = 752,
  [818] = 291,
  [819] = 755,
  [820] = 748,
  [821] = 270,
  [822] = 752,
  [823] = 757,
  [824] = 749,
  [825] = 757,
  [826] = 758,
  [827] = 758,
  [828] = 828,
  [829] = 829,
  [830] = 830,
  [831] = 831,
  [832] = 832,
  [833] = 833,
  [834] = 834,
  [835] = 833,
  [836] = 836,
  [837] = 837,
  [838] = 838,
  [839] = 839,
  [840] = 840,
  [841] = 829,
  [842] = 842,
  [843] = 829,
  [844] = 844,
  [845] = 845,
  [846] = 846,
  [847] = 833,
  [848] = 231,
  [849] = 833,
  [850] = 240,
  [851] = 833,
  [852] = 833,
  [853] = 853,
  [854] = 854,
  [855] = 855,
  [856] = 829,
  [857] = 857,
  [858] = 829,
  [859] = 829,
  [860] = 829,
  [861] = 833,
  [862] = 862,
  [863] = 863,
  [864] = 864,
  [865] = 865,
  [866] = 866,
  [867] = 867,
  [868] = 868,
  [869] = 869,
  [870] = 293,
  [871] = 871,
  [872] = 872,
  [873] = 873,
  [874] = 312,
  [875] = 875,
  [876] = 876,
  [877] = 877,
  [878] = 878,
  [879] = 879,
  [880] = 310,
  [881] = 881,
  [882] = 240,
  [883] = 883,
  [884] = 884,
  [885] = 885,
  [886] = 231,
  [887] = 231,
  [888] = 888,
  [889] = 889,
  [890] = 890,
  [891] = 240,
  [892] = 240,
  [893] = 231,
  [894] = 890,
  [895] = 895,
  [896] = 896,
  [897] = 896,
  [898] = 310,
  [899] = 293,
  [900] = 231,
  [901] = 240,
  [902] = 293,
  [903] = 903,
  [904] = 904,
  [905] = 905,
  [906] = 293,
  [907] = 310,
  [908] = 908,
  [909] = 909,
  [910] = 310,
  [911] = 293,
  [912] = 310,
  [913] = 913,
  [914] = 914,
  [915] = 915,
  [916] = 916,
  [917] = 916,
  [918] = 916,
  [919] = 916,
  [920] = 916,
  [921] = 916,
  [922] = 916,
  [923] = 744,
  [924] = 924,
  [925] = 924,
  [926] = 926,
  [927] = 927,
  [928] = 928,
  [929] = 928,
  [930] = 927,
  [931] = 926,
  [932] = 928,
  [933] = 926,
  [934] = 927,
  [935] = 924,
  [936] = 927,
  [937] = 926,
  [938] = 928,
  [939] = 927,
  [940] = 928,
  [941] = 924,
  [942] = 926,
  [943] = 924,
  [944] = 944,
  [945] = 945,
  [946] = 945,
  [947] = 947,
  [948] = 945,
  [949] = 944,
  [950] = 944,
  [951] = 951,
  [952] = 952,
  [953] = 944,
  [954] = 945,
  [955] = 944,
  [956] = 944,
  [957] = 944,
  [958] = 958,
  [959] = 945,
  [960] = 945,
  [961] = 945,
  [962] = 962,
  [963] = 963,
  [964] = 963,
  [965] = 965,
  [966] = 966,
  [967] = 966,
  [968] = 966,
  [969] = 966,
  [970] = 744,
  [971] = 963,
  [972] = 963,
  [973] = 744,
  [974] = 966,
  [975] = 963,
  [976] = 963,
  [977] = 966,
  [978] = 978,
  [979] = 979,
  [980] = 966,
  [981] = 963,
  [982] = 982,
  [983] = 983,
  [984] = 240,
  [985] = 240,
  [986] = 231,
  [987] = 987,
  [988] = 988,
  [989] = 989,
  [990] = 990,
  [991] = 991,
  [992] = 991,
  [993] = 993,
  [994] = 994,
  [995] = 995,
  [996] = 996,
  [997] = 997,
  [998] = 998,
  [999] = 999,
  [1000] = 1000,
  [1001] = 991,
  [1002] = 997,
  [1003] = 994,
  [1004] = 993,
  [1005] = 990,
  [1006] = 989,
  [1007] = 988,
  [1008] = 995,
  [1009] = 1009,
  [1010] = 1010,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 1013,
  [1014] = 983,
  [1015] = 1015,
  [1016] = 1016,
  [1017] = 1017,
  [1018] = 1018,
  [1019] = 996,
  [1020] = 998,
  [1021] = 1013,
  [1022] = 999,
  [1023] = 1000,
  [1024] = 997,
  [1025] = 994,
  [1026] = 993,
  [1027] = 1018,
  [1028] = 1017,
  [1029] = 1016,
  [1030] = 1015,
  [1031] = 983,
  [1032] = 1012,
  [1033] = 991,
  [1034] = 990,
  [1035] = 1012,
  [1036] = 1011,
  [1037] = 1010,
  [1038] = 1009,
  [1039] = 995,
  [1040] = 988,
  [1041] = 989,
  [1042] = 990,
  [1043] = 995,
  [1044] = 996,
  [1045] = 993,
  [1046] = 998,
  [1047] = 999,
  [1048] = 994,
  [1049] = 1000,
  [1050] = 996,
  [1051] = 997,
  [1052] = 998,
  [1053] = 1000,
  [1054] = 1009,
  [1055] = 997,
  [1056] = 994,
  [1057] = 993,
  [1058] = 1010,
  [1059] = 990,
  [1060] = 989,
  [1061] = 988,
  [1062] = 999,
  [1063] = 999,
  [1064] = 1009,
  [1065] = 998,
  [1066] = 1010,
  [1067] = 1011,
  [1068] = 1011,
  [1069] = 1012,
  [1070] = 1013,
  [1071] = 989,
  [1072] = 1015,
  [1073] = 1016,
  [1074] = 1017,
  [1075] = 1018,
  [1076] = 996,
  [1077] = 995,
  [1078] = 231,
  [1079] = 988,
  [1080] = 991,
  [1081] = 1009,
  [1082] = 991,
  [1083] = 1000,
  [1084] = 1010,
  [1085] = 1013,
  [1086] = 983,
  [1087] = 1015,
  [1088] = 1016,
  [1089] = 1089,
  [1090] = 1000,
  [1091] = 1000,
  [1092] = 1011,
  [1093] = 1012,
  [1094] = 1017,
  [1095] = 1018,
  [1096] = 1013,
  [1097] = 983,
  [1098] = 1015,
  [1099] = 991,
  [1100] = 1016,
  [1101] = 1018,
  [1102] = 1017,
  [1103] = 293,
  [1104] = 310,
  [1105] = 310,
  [1106] = 293,
  [1107] = 1107,
  [1108] = 1108,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 1111,
  [1112] = 1112,
  [1113] = 1113,
  [1114] = 1114,
  [1115] = 1115,
  [1116] = 1116,
  [1117] = 1117,
  [1118] = 1116,
  [1119] = 1117,
  [1120] = 1116,
  [1121] = 1117,
  [1122] = 1117,
  [1123] = 1117,
  [1124] = 1116,
  [1125] = 1116,
  [1126] = 231,
  [1127] = 1127,
  [1128] = 1127,
  [1129] = 1127,
  [1130] = 1130,
  [1131] = 1127,
  [1132] = 1127,
  [1133] = 1127,
  [1134] = 1127,
  [1135] = 1135,
  [1136] = 1135,
  [1137] = 1135,
  [1138] = 1138,
  [1139] = 1138,
  [1140] = 1140,
  [1141] = 1138,
  [1142] = 1142,
  [1143] = 1135,
  [1144] = 1138,
  [1145] = 1140,
  [1146] = 1135,
  [1147] = 1147,
  [1148] = 1140,
  [1149] = 1135,
  [1150] = 1140,
  [1151] = 1140,
  [1152] = 1140,
  [1153] = 1140,
  [1154] = 1154,
  [1155] = 1138,
  [1156] = 1138,
  [1157] = 293,
  [1158] = 1135,
  [1159] = 1159,
  [1160] = 1138,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(2183);
      ADVANCE_MAP(
        '\t', 2242,
        '\n', 2226,
        '\r', 2227,
        ' ', 2244,
        '!', 2194,
        '"', 2195,
        '#', 2196,
        '$', 2197,
        '%', 2198,
        '&', 2200,
        '\'', 2201,
        '(', 2224,
        ')', 2225,
        '*', 2202,
        '+', 2203,
        ',', 2204,
        '-', 2206,
        '.', 2207,
        '/', 2208,
        ':', 2209,
        ';', 2210,
        '<', 2191,
        '=', 2211,
        '>', 2193,
        '?', 2213,
        '@', 2214,
        '[', 2187,
        '\\', 2216,
        ']', 2189,
        '^', 2217,
        '_', 2218,
        '`', 2219,
        '{', 2220,
        '|', 2221,
        '}', 2222,
        '~', 2223,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2246);
      if (lookahead != 0) ADVANCE(2245);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '\t', 2242,
        '\n', 2226,
        '\r', 2227,
        ' ', 2244,
        '!', 2194,
        '"', 2195,
        '#', 2196,
        '$', 2197,
        '%', 2198,
        '&', 2200,
        '\'', 2201,
        '(', 2224,
        ')', 2225,
        '*', 2202,
        '+', 2203,
        ',', 2204,
        '-', 2205,
        '.', 2207,
        '/', 2208,
        ':', 2209,
        ';', 2210,
        '<', 2192,
        '=', 2211,
        '>', 2193,
        '?', 2212,
        '@', 2214,
        '\\', 2216,
        ']', 2188,
        '^', 2217,
        '_', 2218,
        '`', 2219,
        '{', 2220,
        '|', 2221,
        '}', 2222,
        '~', 2223,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2246);
      if (lookahead != 0 &&
          (lookahead < '[' || '`' < lookahead)) ADVANCE(2245);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '\t', 2242,
        '\n', 2226,
        '\r', 2227,
        ' ', 2244,
        '!', 2194,
        '"', 2195,
        '#', 2196,
        '$', 2197,
        '%', 2198,
        '&', 2200,
        '\'', 2201,
        '(', 2224,
        ')', 2225,
        '*', 2202,
        '+', 2203,
        ',', 2204,
        '-', 2205,
        '.', 2207,
        '/', 2208,
        ':', 2209,
        ';', 2210,
        '<', 2190,
        '=', 2211,
        '>', 2193,
        '?', 2212,
        '@', 2214,
        '[', 2187,
        '\\', 2216,
        ']', 2188,
        '^', 2217,
        '_', 2218,
        '`', 2219,
        '{', 2220,
        '|', 2221,
        '}', 2222,
        '~', 2223,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2246);
      if (lookahead != 0) ADVANCE(2245);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '\t', 2242,
        '\n', 2226,
        '\r', 2227,
        ' ', 2244,
        '!', 2194,
        '"', 2195,
        '#', 2196,
        '$', 2197,
        '%', 2198,
        '&', 2199,
        '\'', 2201,
        '(', 2224,
        ')', 2225,
        '*', 2202,
        '+', 2203,
        ',', 2204,
        '-', 2206,
        '.', 2207,
        '/', 2208,
        ':', 2209,
        ';', 2210,
        '<', 2192,
        '=', 2211,
        '>', 2193,
        '?', 2212,
        '@', 2214,
        '[', 2187,
        '\\', 2216,
        ']', 2188,
        '^', 2217,
        '_', 2218,
        '`', 2219,
        '{', 2220,
        '|', 2221,
        '}', 2222,
        '~', 2223,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2246);
      if (lookahead != 0) ADVANCE(2245);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '\t', 2242,
        '\n', 2226,
        '\r', 2227,
        ' ', 2244,
        '!', 2194,
        '"', 2195,
        '#', 2196,
        '$', 2197,
        '%', 2198,
        '&', 2199,
        '\'', 2201,
        '(', 2224,
        ')', 2225,
        '*', 2202,
        '+', 2203,
        ',', 2204,
        '-', 2206,
        '.', 2207,
        '/', 2208,
        ':', 2209,
        ';', 2210,
        '<', 2192,
        '=', 2211,
        '>', 2193,
        '?', 2212,
        '@', 2214,
        '[', 2187,
        '\\', 2215,
        ']', 2188,
        '^', 2217,
        '_', 2218,
        '`', 2219,
        '{', 2220,
        '|', 2221,
        '}', 2222,
        '~', 2223,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2246);
      if (lookahead != 0) ADVANCE(2245);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '\t', 2242,
        '\n', 2226,
        '\r', 2227,
        ' ', 2244,
        '!', 2194,
        '"', 2195,
        '#', 2196,
        '$', 2197,
        '%', 2198,
        '&', 2199,
        '\'', 2201,
        '(', 2224,
        ')', 2225,
        '*', 2202,
        '+', 2203,
        ',', 2204,
        '-', 2206,
        '.', 2207,
        '/', 2208,
        ':', 2209,
        ';', 2210,
        '<', 2190,
        '=', 2211,
        '>', 2193,
        '?', 2212,
        '@', 2214,
        '[', 2187,
        '\\', 2215,
        ']', 2188,
        '^', 2217,
        '_', 2218,
        '`', 2219,
        '{', 2220,
        '|', 2221,
        '}', 2222,
        '~', 2223,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2246);
      if (lookahead != 0) ADVANCE(2245);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '\t', 2242,
        '\n', 2226,
        '\r', 2227,
        ' ', 2244,
        '!', 2194,
        '"', 2195,
        '#', 2196,
        '$', 2197,
        '%', 2198,
        '&', 2199,
        '\'', 2201,
        '(', 2224,
        ')', 2225,
        '*', 2202,
        '+', 2203,
        ',', 2204,
        '-', 2205,
        '.', 2207,
        '/', 2208,
        ':', 2209,
        ';', 2210,
        '<', 2192,
        '=', 2211,
        '>', 2193,
        '?', 2213,
        '@', 2214,
        '[', 2187,
        '\\', 2216,
        ']', 2188,
        '^', 2217,
        '_', 2218,
        '`', 2219,
        '{', 2220,
        '|', 2221,
        '}', 2222,
        '~', 2223,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2246);
      if (lookahead != 0) ADVANCE(2245);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '\t', 2242,
        '\n', 2226,
        '\r', 2227,
        ' ', 2244,
        '!', 2194,
        '"', 2195,
        '#', 2196,
        '$', 2197,
        '%', 2198,
        '&', 2199,
        '\'', 2201,
        '(', 2224,
        ')', 2225,
        '*', 2202,
        '+', 2203,
        ',', 2204,
        '-', 2205,
        '.', 2207,
        '/', 2208,
        ':', 2209,
        ';', 2210,
        '<', 2192,
        '=', 2211,
        '>', 2193,
        '?', 2213,
        '@', 2214,
        '[', 2187,
        '\\', 2215,
        ']', 2188,
        '^', 2217,
        '_', 2218,
        '`', 2219,
        '{', 2220,
        '|', 2221,
        '}', 2222,
        '~', 2223,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2246);
      if (lookahead != 0) ADVANCE(2245);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        '\t', 2242,
        '\n', 2226,
        '\r', 2227,
        ' ', 2244,
        '!', 2194,
        '"', 2195,
        '#', 2196,
        '$', 2197,
        '%', 2198,
        '&', 2199,
        '\'', 2201,
        '(', 2224,
        ')', 2225,
        '*', 2202,
        '+', 2203,
        ',', 2204,
        '-', 2205,
        '.', 2207,
        '/', 2208,
        ':', 2209,
        ';', 2210,
        '<', 2192,
        '=', 2211,
        '>', 2193,
        '?', 2212,
        '@', 2214,
        '[', 2187,
        '\\', 2216,
        ']', 2189,
        '^', 2217,
        '_', 2218,
        '`', 2219,
        '{', 2220,
        '|', 2221,
        '}', 2222,
        '~', 2223,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2246);
      if (lookahead != 0) ADVANCE(2245);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '\t', 2242,
        '\n', 2226,
        '\r', 2227,
        ' ', 2244,
        '!', 2194,
        '"', 2195,
        '#', 2196,
        '$', 2197,
        '%', 2198,
        '&', 2199,
        '\'', 2201,
        '(', 2224,
        ')', 2225,
        '*', 2202,
        '+', 2203,
        ',', 2204,
        '-', 2205,
        '.', 2207,
        '/', 2208,
        ':', 2209,
        ';', 2210,
        '<', 2192,
        '=', 2211,
        '>', 2193,
        '?', 2212,
        '@', 2214,
        '[', 2187,
        '\\', 2216,
        ']', 2188,
        '^', 2217,
        '_', 2218,
        '`', 2219,
        '{', 2220,
        '|', 2221,
        '}', 2222,
        '~', 2223,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2246);
      if (lookahead != 0) ADVANCE(2245);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        '\t', 2242,
        '\n', 2226,
        '\r', 2227,
        ' ', 2244,
        '!', 2194,
        '"', 2195,
        '#', 2196,
        '$', 2197,
        '%', 2198,
        '&', 2199,
        '\'', 2201,
        '(', 2224,
        ')', 2225,
        '*', 2202,
        '+', 2203,
        ',', 2204,
        '-', 2205,
        '.', 2207,
        '/', 2208,
        ':', 2209,
        ';', 2210,
        '<', 2192,
        '=', 2211,
        '>', 2193,
        '?', 2212,
        '@', 2214,
        '[', 2187,
        '\\', 2215,
        ']', 2189,
        '^', 2217,
        '_', 2218,
        '`', 2219,
        '{', 2220,
        '|', 2221,
        '}', 2222,
        '~', 2223,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2246);
      if (lookahead != 0) ADVANCE(2245);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        '\t', 2242,
        '\n', 2226,
        '\r', 2227,
        ' ', 2244,
        '!', 2194,
        '"', 2195,
        '#', 2196,
        '$', 2197,
        '%', 2198,
        '&', 2199,
        '\'', 2201,
        '(', 2224,
        ')', 2225,
        '*', 2202,
        '+', 2203,
        ',', 2204,
        '-', 2205,
        '.', 2207,
        '/', 2208,
        ':', 2209,
        ';', 2210,
        '<', 2192,
        '=', 2211,
        '>', 2193,
        '?', 2212,
        '@', 2214,
        '[', 2187,
        '\\', 2215,
        ']', 2188,
        '^', 2217,
        '_', 2218,
        '`', 2219,
        '{', 2220,
        '|', 2221,
        '}', 2222,
        '~', 2223,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2246);
      if (lookahead != 0) ADVANCE(2245);
      END_STATE();
    case 12:
      ADVANCE_MAP(
        '\t', 2242,
        '\n', 2226,
        '\r', 2227,
        ' ', 2244,
        '!', 2194,
        '"', 2195,
        '#', 2196,
        '$', 2197,
        '%', 2198,
        '&', 2199,
        '\'', 2201,
        '(', 2224,
        ')', 2225,
        '*', 2202,
        '+', 2203,
        ',', 2204,
        '-', 2205,
        '.', 2207,
        '/', 2208,
        ':', 2209,
        ';', 2210,
        '<', 2190,
        '=', 2211,
        '>', 2193,
        '?', 2213,
        '@', 2214,
        '[', 2187,
        '\\', 2215,
        ']', 2188,
        '^', 2217,
        '_', 2218,
        '`', 2219,
        '{', 2220,
        '|', 2221,
        '}', 2222,
        '~', 2223,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2246);
      if (lookahead != 0) ADVANCE(2245);
      END_STATE();
    case 13:
      ADVANCE_MAP(
        '\t', 2242,
        '\n', 2226,
        '\r', 2227,
        ' ', 2244,
        '!', 2194,
        '"', 2195,
        '#', 2196,
        '$', 2197,
        '%', 2198,
        '&', 2199,
        '\'', 2201,
        '(', 2224,
        ')', 2225,
        '*', 2202,
        '+', 2203,
        ',', 2204,
        '-', 2205,
        '.', 2207,
        '/', 2208,
        ':', 2209,
        ';', 2210,
        '<', 2190,
        '=', 2211,
        '>', 2193,
        '?', 2212,
        '@', 2214,
        '[', 2187,
        '\\', 2215,
        ']', 2189,
        '^', 2217,
        '_', 2218,
        '`', 2219,
        '{', 2220,
        '|', 2221,
        '}', 2222,
        '~', 2223,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2246);
      if (lookahead != 0) ADVANCE(2245);
      END_STATE();
    case 14:
      ADVANCE_MAP(
        '\t', 2242,
        '\n', 2226,
        '\r', 2227,
        ' ', 2244,
        '!', 2194,
        '"', 2195,
        '#', 2196,
        '$', 2197,
        '%', 2198,
        '&', 2199,
        '\'', 2201,
        '(', 2224,
        ')', 2225,
        '*', 2202,
        '+', 2203,
        ',', 2204,
        '-', 2205,
        '.', 2207,
        '/', 2208,
        ':', 2209,
        ';', 2210,
        '<', 2190,
        '=', 2211,
        '>', 2193,
        '?', 2212,
        '@', 2214,
        '[', 2187,
        '\\', 2215,
        ']', 2188,
        '^', 2217,
        '_', 2218,
        '`', 2219,
        '{', 2220,
        '|', 2221,
        '}', 2222,
        '~', 2223,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2246);
      if (lookahead != 0) ADVANCE(2245);
      END_STATE();
    case 15:
      if (lookahead == '\t') ADVANCE(2242);
      if (lookahead == '\n') ADVANCE(2226);
      if (lookahead == '\r') ADVANCE(2227);
      if (lookahead == ' ') ADVANCE(2244);
      if (lookahead == '"') ADVANCE(2195);
      if (lookahead == '\'') ADVANCE(2201);
      if (lookahead != 0 &&
          (lookahead < '<' || '>' < lookahead) &&
          lookahead != '`') ADVANCE(2231);
      END_STATE();
    case 16:
      if (lookahead == '\t') ADVANCE(2242);
      if (lookahead == '\n') ADVANCE(2226);
      if (lookahead == '\r') ADVANCE(2227);
      if (lookahead == ' ') ADVANCE(2244);
      if (lookahead == '/') ADVANCE(2208);
      if (lookahead == '>') ADVANCE(2193);
      if (lookahead == ':' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2230);
      END_STATE();
    case 17:
      if (lookahead == '-') ADVANCE(18);
      if (lookahead == '@') ADVANCE(2177);
      if (lookahead == '[') ADVANCE(431);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(2238);
      if (lookahead == '!' ||
          ('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('.' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          lookahead == '?' ||
          ('^' <= lookahead && lookahead <= '~')) ADVANCE(390);
      END_STATE();
    case 18:
      if (lookahead == '-') ADVANCE(2233);
      if (lookahead == '@') ADVANCE(2177);
      if (lookahead == '!' ||
          ('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('.' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          ('^' <= lookahead && lookahead <= '~')) ADVANCE(390);
      END_STATE();
    case 19:
      if (lookahead == '-') ADVANCE(141);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(140);
      END_STATE();
    case 20:
      if (lookahead == '-') ADVANCE(21);
      if (lookahead == '[') ADVANCE(431);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(2239);
      END_STATE();
    case 21:
      if (lookahead == '-') ADVANCE(2232);
      END_STATE();
    case 22:
      if (lookahead == '-') ADVANCE(2178);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(143);
      END_STATE();
    case 23:
      if (lookahead == '-') ADVANCE(2178);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(143);
      END_STATE();
    case 24:
      if (lookahead == '-') ADVANCE(27);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(26);
      END_STATE();
    case 25:
      if (lookahead == '-') ADVANCE(27);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(26);
      END_STATE();
    case 26:
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(22);
      END_STATE();
    case 27:
      if (lookahead == '-') ADVANCE(23);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(22);
      END_STATE();
    case 28:
      if (lookahead == '-') ADVANCE(31);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(30);
      END_STATE();
    case 29:
      if (lookahead == '-') ADVANCE(31);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(30);
      END_STATE();
    case 30:
      if (lookahead == '-') ADVANCE(25);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(24);
      END_STATE();
    case 31:
      if (lookahead == '-') ADVANCE(25);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(24);
      END_STATE();
    case 32:
      if (lookahead == '-') ADVANCE(35);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(34);
      END_STATE();
    case 33:
      if (lookahead == '-') ADVANCE(35);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(34);
      END_STATE();
    case 34:
      if (lookahead == '-') ADVANCE(29);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(28);
      END_STATE();
    case 35:
      if (lookahead == '-') ADVANCE(29);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(28);
      END_STATE();
    case 36:
      if (lookahead == '-') ADVANCE(39);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(38);
      END_STATE();
    case 37:
      if (lookahead == '-') ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(38);
      END_STATE();
    case 38:
      if (lookahead == '-') ADVANCE(33);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(32);
      END_STATE();
    case 39:
      if (lookahead == '-') ADVANCE(33);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(32);
      END_STATE();
    case 40:
      if (lookahead == '-') ADVANCE(43);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(42);
      END_STATE();
    case 41:
      if (lookahead == '-') ADVANCE(43);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(42);
      END_STATE();
    case 42:
      if (lookahead == '-') ADVANCE(37);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(36);
      END_STATE();
    case 43:
      if (lookahead == '-') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(36);
      END_STATE();
    case 44:
      if (lookahead == '-') ADVANCE(47);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(46);
      END_STATE();
    case 45:
      if (lookahead == '-') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(46);
      END_STATE();
    case 46:
      if (lookahead == '-') ADVANCE(41);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(40);
      END_STATE();
    case 47:
      if (lookahead == '-') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(40);
      END_STATE();
    case 48:
      if (lookahead == '-') ADVANCE(51);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(50);
      END_STATE();
    case 49:
      if (lookahead == '-') ADVANCE(51);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(50);
      END_STATE();
    case 50:
      if (lookahead == '-') ADVANCE(45);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(44);
      END_STATE();
    case 51:
      if (lookahead == '-') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(44);
      END_STATE();
    case 52:
      if (lookahead == '-') ADVANCE(55);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(54);
      END_STATE();
    case 53:
      if (lookahead == '-') ADVANCE(55);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(54);
      END_STATE();
    case 54:
      if (lookahead == '-') ADVANCE(49);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(48);
      END_STATE();
    case 55:
      if (lookahead == '-') ADVANCE(49);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(48);
      END_STATE();
    case 56:
      if (lookahead == '-') ADVANCE(59);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(58);
      END_STATE();
    case 57:
      if (lookahead == '-') ADVANCE(59);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(58);
      END_STATE();
    case 58:
      if (lookahead == '-') ADVANCE(53);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(52);
      END_STATE();
    case 59:
      if (lookahead == '-') ADVANCE(53);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(52);
      END_STATE();
    case 60:
      if (lookahead == '-') ADVANCE(63);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(62);
      END_STATE();
    case 61:
      if (lookahead == '-') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(62);
      END_STATE();
    case 62:
      if (lookahead == '-') ADVANCE(57);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(56);
      END_STATE();
    case 63:
      if (lookahead == '-') ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(56);
      END_STATE();
    case 64:
      if (lookahead == '-') ADVANCE(67);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 65:
      if (lookahead == '-') ADVANCE(67);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 66:
      if (lookahead == '-') ADVANCE(61);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(60);
      END_STATE();
    case 67:
      if (lookahead == '-') ADVANCE(61);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(60);
      END_STATE();
    case 68:
      if (lookahead == '-') ADVANCE(71);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(70);
      END_STATE();
    case 69:
      if (lookahead == '-') ADVANCE(71);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(70);
      END_STATE();
    case 70:
      if (lookahead == '-') ADVANCE(65);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 71:
      if (lookahead == '-') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 72:
      if (lookahead == '-') ADVANCE(75);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 73:
      if (lookahead == '-') ADVANCE(75);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 74:
      if (lookahead == '-') ADVANCE(69);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(68);
      END_STATE();
    case 75:
      if (lookahead == '-') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(68);
      END_STATE();
    case 76:
      if (lookahead == '-') ADVANCE(79);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(78);
      END_STATE();
    case 77:
      if (lookahead == '-') ADVANCE(79);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(78);
      END_STATE();
    case 78:
      if (lookahead == '-') ADVANCE(73);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(72);
      END_STATE();
    case 79:
      if (lookahead == '-') ADVANCE(73);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(72);
      END_STATE();
    case 80:
      if (lookahead == '-') ADVANCE(83);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(82);
      END_STATE();
    case 81:
      if (lookahead == '-') ADVANCE(83);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(82);
      END_STATE();
    case 82:
      if (lookahead == '-') ADVANCE(77);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(76);
      END_STATE();
    case 83:
      if (lookahead == '-') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(76);
      END_STATE();
    case 84:
      if (lookahead == '-') ADVANCE(87);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(86);
      END_STATE();
    case 85:
      if (lookahead == '-') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(86);
      END_STATE();
    case 86:
      if (lookahead == '-') ADVANCE(81);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(80);
      END_STATE();
    case 87:
      if (lookahead == '-') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(80);
      END_STATE();
    case 88:
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(90);
      END_STATE();
    case 89:
      if (lookahead == '-') ADVANCE(91);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(90);
      END_STATE();
    case 90:
      if (lookahead == '-') ADVANCE(85);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 91:
      if (lookahead == '-') ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 92:
      if (lookahead == '-') ADVANCE(95);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(94);
      END_STATE();
    case 93:
      if (lookahead == '-') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(94);
      END_STATE();
    case 94:
      if (lookahead == '-') ADVANCE(89);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(88);
      END_STATE();
    case 95:
      if (lookahead == '-') ADVANCE(89);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(88);
      END_STATE();
    case 96:
      if (lookahead == '-') ADVANCE(99);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(98);
      END_STATE();
    case 97:
      if (lookahead == '-') ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(98);
      END_STATE();
    case 98:
      if (lookahead == '-') ADVANCE(93);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(92);
      END_STATE();
    case 99:
      if (lookahead == '-') ADVANCE(93);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(92);
      END_STATE();
    case 100:
      if (lookahead == '-') ADVANCE(103);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(102);
      END_STATE();
    case 101:
      if (lookahead == '-') ADVANCE(103);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(102);
      END_STATE();
    case 102:
      if (lookahead == '-') ADVANCE(97);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(96);
      END_STATE();
    case 103:
      if (lookahead == '-') ADVANCE(97);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(96);
      END_STATE();
    case 104:
      if (lookahead == '-') ADVANCE(107);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(106);
      END_STATE();
    case 105:
      if (lookahead == '-') ADVANCE(107);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(106);
      END_STATE();
    case 106:
      if (lookahead == '-') ADVANCE(101);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(100);
      END_STATE();
    case 107:
      if (lookahead == '-') ADVANCE(101);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(100);
      END_STATE();
    case 108:
      if (lookahead == '-') ADVANCE(111);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 109:
      if (lookahead == '-') ADVANCE(111);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 110:
      if (lookahead == '-') ADVANCE(105);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(104);
      END_STATE();
    case 111:
      if (lookahead == '-') ADVANCE(105);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(104);
      END_STATE();
    case 112:
      if (lookahead == '-') ADVANCE(115);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(114);
      END_STATE();
    case 113:
      if (lookahead == '-') ADVANCE(115);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(114);
      END_STATE();
    case 114:
      if (lookahead == '-') ADVANCE(109);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(108);
      END_STATE();
    case 115:
      if (lookahead == '-') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(108);
      END_STATE();
    case 116:
      if (lookahead == '-') ADVANCE(119);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(118);
      END_STATE();
    case 117:
      if (lookahead == '-') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(118);
      END_STATE();
    case 118:
      if (lookahead == '-') ADVANCE(113);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(112);
      END_STATE();
    case 119:
      if (lookahead == '-') ADVANCE(113);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(112);
      END_STATE();
    case 120:
      if (lookahead == '-') ADVANCE(123);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(122);
      END_STATE();
    case 121:
      if (lookahead == '-') ADVANCE(123);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(122);
      END_STATE();
    case 122:
      if (lookahead == '-') ADVANCE(117);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 123:
      if (lookahead == '-') ADVANCE(117);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 124:
      if (lookahead == '-') ADVANCE(127);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 125:
      if (lookahead == '-') ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 126:
      if (lookahead == '-') ADVANCE(121);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(120);
      END_STATE();
    case 127:
      if (lookahead == '-') ADVANCE(121);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(120);
      END_STATE();
    case 128:
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 129:
      if (lookahead == '-') ADVANCE(131);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(130);
      END_STATE();
    case 130:
      if (lookahead == '-') ADVANCE(125);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(124);
      END_STATE();
    case 131:
      if (lookahead == '-') ADVANCE(125);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(124);
      END_STATE();
    case 132:
      if (lookahead == '-') ADVANCE(135);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(134);
      END_STATE();
    case 133:
      if (lookahead == '-') ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(134);
      END_STATE();
    case 134:
      if (lookahead == '-') ADVANCE(129);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(128);
      END_STATE();
    case 135:
      if (lookahead == '-') ADVANCE(129);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(128);
      END_STATE();
    case 136:
      if (lookahead == '-') ADVANCE(139);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 137:
      if (lookahead == '-') ADVANCE(139);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 138:
      if (lookahead == '-') ADVANCE(133);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(132);
      END_STATE();
    case 139:
      if (lookahead == '-') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(132);
      END_STATE();
    case 140:
      if (lookahead == '-') ADVANCE(137);
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(136);
      END_STATE();
    case 141:
      if (lookahead == '-') ADVANCE(137);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(136);
      END_STATE();
    case 142:
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      END_STATE();
    case 143:
      if (lookahead == '.') ADVANCE(2177);
      if (lookahead == '>') ADVANCE(2229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 144:
      if (lookahead == '1') ADVANCE(2157);
      if (lookahead == '3') ADVANCE(147);
      END_STATE();
    case 145:
      if (lookahead == '1') ADVANCE(2171);
      if (lookahead == ';') ADVANCE(2185);
      END_STATE();
    case 146:
      if (lookahead == '1') ADVANCE(373);
      if (lookahead == '2') ADVANCE(2158);
      if (lookahead == '3') ADVANCE(370);
      if (lookahead == '4') ADVANCE(149);
      if (lookahead == '5') ADVANCE(2159);
      if (lookahead == '7') ADVANCE(150);
      END_STATE();
    case 147:
      if (lookahead == '4') ADVANCE(152);
      END_STATE();
    case 148:
      if (lookahead == '4') ADVANCE(152);
      if (lookahead == 'f') ADVANCE(1668);
      END_STATE();
    case 149:
      if (lookahead == '5') ADVANCE(152);
      END_STATE();
    case 150:
      if (lookahead == '8') ADVANCE(152);
      END_STATE();
    case 151:
      if (lookahead == ':') ADVANCE(388);
      if (lookahead == '@') ADVANCE(2177);
      if (lookahead == '!' ||
          ('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '/' ||
          lookahead == '=' ||
          lookahead == '?' ||
          ('^' <= lookahead && lookahead <= '`') ||
          ('{' <= lookahead && lookahead <= '~')) ADVANCE(390);
      if (lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(151);
      END_STATE();
    case 152:
      if (lookahead == ';') ADVANCE(2185);
      END_STATE();
    case 153:
      ADVANCE_MAP(
        ';', 2185,
        'A', 593,
        'B', 583,
        'E', 280,
        'H', 546,
        'a', 819,
        'b', 584,
        'c', 611,
        'd', 803,
        'e', 277,
        'f', 1261,
        'g', 167,
        'h', 629,
        'j', 754,
        'l', 203,
        'm', 1244,
        'n', 464,
        'o', 554,
        'p', 633,
        'r', 587,
        's', 534,
        't', 230,
        'u', 1778,
        'v', 1071,
      );
      END_STATE();
    case 154:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'A') ADVANCE(1769);
      if (lookahead == 'a') ADVANCE(1762);
      if (lookahead == 'd') ADVANCE(1598);
      if (lookahead == 'q') ADVANCE(2079);
      if (lookahead == 's') ADVANCE(976);
      if (lookahead == 'x') ADVANCE(1303);
      END_STATE();
    case 155:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'A') ADVANCE(1881);
      END_STATE();
    case 156:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'A') ADVANCE(1881);
      if (lookahead == 'V') ADVANCE(1072);
      END_STATE();
    case 157:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'B') ADVANCE(546);
      END_STATE();
    case 158:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'B') ADVANCE(546);
      if (lookahead == 'D') ADVANCE(1652);
      END_STATE();
    case 159:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'B') ADVANCE(546);
      if (lookahead == 'E') ADVANCE(1740);
      END_STATE();
    case 160:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'B') ADVANCE(546);
      if (lookahead == 'L') ADVANCE(1074);
      END_STATE();
    case 161:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'B') ADVANCE(546);
      if (lookahead == 'R') ADVANCE(1325);
      END_STATE();
    case 162:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'B') ADVANCE(546);
      if (lookahead == 'U') ADVANCE(1696);
      END_STATE();
    case 163:
      ADVANCE_MAP(
        ';', 2185,
        'C', 1663,
        'D', 1637,
        'E', 1372,
        'G', 1897,
        'H', 2090,
        'L', 1046,
        'N', 1013,
        'P', 1858,
        'R', 1047,
        'S', 1741,
        'T', 1250,
        'V', 1086,
      );
      END_STATE();
    case 164:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'C') ADVANCE(572);
      END_STATE();
    case 165:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'D') ADVANCE(1598);
      if (lookahead == 'E') ADVANCE(1740);
      END_STATE();
    case 166:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'D') ADVANCE(445);
      END_STATE();
    case 167:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'E') ADVANCE(152);
      END_STATE();
    case 168:
      ADVANCE_MAP(
        ';', 2185,
        'E', 152,
        'a', 1677,
        'c', 2068,
        'e', 229,
        'i', 1499,
        'n', 463,
        'o', 882,
        's', 1255,
        'u', 1809,
      );
      END_STATE();
    case 169:
      ADVANCE_MAP(
        ';', 2185,
        'E', 152,
        'd', 1598,
        'e', 240,
        'm', 2075,
        'n', 2160,
        'p', 1448,
        'r', 583,
        's', 1026,
      );
      END_STATE();
    case 170:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'E') ADVANCE(152);
      if (lookahead == 'd') ADVANCE(1598);
      if (lookahead == 'v') ADVANCE(2173);
      END_STATE();
    case 171:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'E') ADVANCE(152);
      if (lookahead == 'e') ADVANCE(325);
      END_STATE();
    case 172:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'E') ADVANCE(152);
      if (lookahead == 'i') ADVANCE(881);
      if (lookahead == 'o') ADVANCE(1903);
      if (lookahead == 'p') ADVANCE(1829);
      END_STATE();
    case 173:
      ADVANCE_MAP(
        ';', 2185,
        'E', 297,
        'a', 821,
        'b', 1749,
        'c', 1291,
        'd', 1598,
        'e', 298,
        'f', 1750,
        'g', 280,
        'i', 1484,
        'j', 754,
        'l', 369,
        'n', 464,
        'o', 1680,
        'r', 537,
        's', 789,
        't', 231,
        'v', 1071,
      );
      END_STATE();
    case 174:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'E') ADVANCE(1740);
      END_STATE();
    case 175:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'E') ADVANCE(1740);
      if (lookahead == 'F') ADVANCE(2097);
      if (lookahead == 'G') ADVANCE(1890);
      if (lookahead == 'L') ADVANCE(972);
      if (lookahead == 'S') ADVANCE(1458);
      if (lookahead == 'T') ADVANCE(1318);
      END_STATE();
    case 176:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'E') ADVANCE(1740);
      if (lookahead == 'F') ADVANCE(2097);
      if (lookahead == 'T') ADVANCE(1318);
      END_STATE();
    case 177:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'E') ADVANCE(1740);
      if (lookahead == 'G') ADVANCE(1890);
      if (lookahead == 'L') ADVANCE(972);
      if (lookahead == 'S') ADVANCE(1458);
      if (lookahead == 'T') ADVANCE(1318);
      END_STATE();
    case 178:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'E') ADVANCE(1740);
      if (lookahead == 'S') ADVANCE(1458);
      END_STATE();
    case 179:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'E') ADVANCE(1740);
      if (lookahead == 'S') ADVANCE(1458);
      if (lookahead == 'T') ADVANCE(1318);
      END_STATE();
    case 180:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'G') ADVANCE(152);
      END_STATE();
    case 181:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'H') ADVANCE(152);
      END_STATE();
    case 182:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'I') ADVANCE(1580);
      if (lookahead == 'S') ADVANCE(2061);
      if (lookahead == 'U') ADVANCE(1561);
      END_STATE();
    case 183:
      ADVANCE_MAP(
        ';', 2185,
        'J', 754,
        'a', 820,
        'c', 613,
        'e', 1103,
        'f', 1750,
        'l', 257,
        'm', 1243,
        'o', 1528,
        's', 786,
        'T', 152,
        't', 152,
      );
      END_STATE();
    case 184:
      ADVANCE_MAP(
        ';', 2185,
        'J', 754,
        'a', 1500,
        'b', 1749,
        'c', 980,
        'd', 1598,
        'f', 1750,
        'o', 1680,
        'r', 998,
        's', 778,
        'T', 152,
        'g', 152,
        't', 152,
      );
      END_STATE();
    case 185:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'L') ADVANCE(972);
      END_STATE();
    case 186:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'N') ADVANCE(152);
      END_STATE();
    case 187:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'P') ADVANCE(152);
      END_STATE();
    case 188:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'P') ADVANCE(1448);
      END_STATE();
    case 189:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'T') ADVANCE(152);
      END_STATE();
    case 190:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'T') ADVANCE(1318);
      END_STATE();
    case 191:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'Y') ADVANCE(152);
      END_STATE();
    case 192:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'a') ADVANCE(784);
      if (lookahead == 'p') ADVANCE(1414);
      END_STATE();
    case 193:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'a') ADVANCE(1135);
      if (lookahead == 'o') ADVANCE(2013);
      END_STATE();
    case 194:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'a') ADVANCE(2175);
      END_STATE();
    case 195:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'a') ADVANCE(778);
      if (lookahead == 'l') ADVANCE(152);
      END_STATE();
    case 196:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'a') ADVANCE(1750);
      END_STATE();
    case 197:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'a') ADVANCE(792);
      if (lookahead == 'p') ADVANCE(152);
      END_STATE();
    case 198:
      ADVANCE_MAP(
        ';', 2185,
        'a', 1678,
        'c', 2068,
        'e', 249,
        'i', 1817,
        'n', 463,
        'p', 1673,
        's', 1255,
        'E', 152,
        'y', 152,
      );
      END_STATE();
    case 199:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'a') ADVANCE(305);
      if (lookahead == 's') ADVANCE(1256);
      if (lookahead == 't') ADVANCE(152);
      END_STATE();
    case 200:
      ADVANCE_MAP(
        ';', 2185,
        'a', 1677,
        'b', 276,
        'f', 1903,
        'h', 1339,
        'l', 1677,
        'p', 1358,
        's', 1255,
        't', 1358,
        'c', 152,
        'w', 152,
      );
      END_STATE();
    case 201:
      ADVANCE_MAP(
        ';', 2185,
        'a', 850,
        'c', 1233,
        'd', 2169,
        'm', 309,
        's', 1255,
        't', 2121,
        'b', 152,
        'e', 152,
      );
      END_STATE();
    case 202:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'a') ADVANCE(850);
      if (lookahead == 'i') ADVANCE(881);
      if (lookahead == 'o') ADVANCE(1903);
      if (lookahead == 'p') ADVANCE(1823);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 203:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'a') ADVANCE(1769);
      if (lookahead == 'c') ADVANCE(1649);
      if (lookahead == 'h') ADVANCE(648);
      if (lookahead == 't') ADVANCE(1785);
      END_STATE();
    case 204:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'a') ADVANCE(1769);
      if (lookahead == 'd') ADVANCE(272);
      if (lookahead == 'i') ADVANCE(1137);
      if (lookahead == 'o') ADVANCE(1750);
      if (lookahead == 's') ADVANCE(1413);
      if (lookahead == 'v') ADVANCE(152);
      END_STATE();
    case 205:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'a') ADVANCE(1903);
      END_STATE();
    case 206:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'a') ADVANCE(1914);
      if (lookahead == 'c') ADVANCE(1233);
      if (lookahead == 'd') ADVANCE(1605);
      END_STATE();
    case 207:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'a') ADVANCE(1358);
      END_STATE();
    case 208:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'a') ADVANCE(1803);
      if (lookahead == 'e') ADVANCE(921);
      if (lookahead == 'i') ADVANCE(1817);
      if (lookahead == 'y') ADVANCE(152);
      END_STATE();
    case 209:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'a') ADVANCE(1363);
      if (lookahead == 'c') ADVANCE(1958);
      if (lookahead == 'g') ADVANCE(152);
      END_STATE();
    case 210:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'a') ADVANCE(1503);
      if (lookahead == 'b') ADVANCE(1872);
      if (lookahead == 'c') ADVANCE(576);
      if (lookahead == 'd') ADVANCE(1598);
      if (lookahead == 's') ADVANCE(152);
      END_STATE();
    case 211:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'a') ADVANCE(1503);
      if (lookahead == 's') ADVANCE(1413);
      if (lookahead == 'd' ||
          lookahead == 'v') ADVANCE(152);
      END_STATE();
    case 212:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'a') ADVANCE(843);
      END_STATE();
    case 213:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'a') ADVANCE(1798);
      if (lookahead == 'c') ADVANCE(1190);
      if (lookahead == 'o') ADVANCE(1837);
      if (lookahead == 'y') ADVANCE(152);
      END_STATE();
    case 214:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'a') ADVANCE(1382);
      END_STATE();
    case 215:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'a') ADVANCE(1766);
      if (lookahead == 'f') ADVANCE(152);
      END_STATE();
    case 216:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'a') ADVANCE(1712);
      if (lookahead == 'c') ADVANCE(2088);
      if (lookahead == 'e') ADVANCE(1732);
      if (lookahead == 'n') ADVANCE(670);
      if (lookahead == 's') ADVANCE(1255);
      END_STATE();
    case 217:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'a') ADVANCE(1263);
      if (lookahead == 'e') ADVANCE(334);
      END_STATE();
    case 218:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'a') ADVANCE(1457);
      if (lookahead == 's') ADVANCE(1358);
      if (lookahead == 't') ADVANCE(152);
      END_STATE();
    case 219:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'b') ADVANCE(1598);
      if (lookahead == 'c') ADVANCE(1233);
      if (lookahead == 'f') ADVANCE(318);
      END_STATE();
    case 220:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'b') ADVANCE(152);
      if (lookahead == 'd') ADVANCE(356);
      END_STATE();
    case 221:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'b') ADVANCE(152);
      if (lookahead == 'h') ADVANCE(1950);
      END_STATE();
    case 222:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'b') ADVANCE(196);
      END_STATE();
    case 223:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'b') ADVANCE(196);
      if (lookahead == 'd') ADVANCE(152);
      END_STATE();
    case 224:
      ADVANCE_MAP(
        ';', 2185,
        'b', 276,
        'f', 1903,
        'h', 1339,
        'l', 1677,
        'p', 1358,
        's', 1255,
        't', 1358,
      );
      END_STATE();
    case 225:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'b') ADVANCE(546);
      if (lookahead == 'e') ADVANCE(1732);
      END_STATE();
    case 226:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'b') ADVANCE(1825);
      if (lookahead == 'c') ADVANCE(576);
      if (lookahead == 'd') ADVANCE(1598);
      if (lookahead == 'o') ADVANCE(1750);
      if (lookahead == 's') ADVANCE(152);
      END_STATE();
    case 227:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'c') ADVANCE(152);
      END_STATE();
    case 228:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'c') ADVANCE(260);
      if (lookahead == 'f') ADVANCE(1566);
      if (lookahead == 'm') ADVANCE(1222);
      if (lookahead == 's') ADVANCE(850);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 229:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'c') ADVANCE(216);
      END_STATE();
    case 230:
      ADVANCE_MAP(
        ';', 2185,
        'c', 763,
        'd', 1598,
        'h', 1799,
        'i', 1497,
        'l', 583,
        'q', 2080,
        'r', 505,
      );
      END_STATE();
    case 231:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'c') ADVANCE(763);
      if (lookahead == 'd') ADVANCE(1598);
      if (lookahead == 'l') ADVANCE(504);
      if (lookahead == 'q') ADVANCE(2080);
      if (lookahead == 'r') ADVANCE(571);
      END_STATE();
    case 232:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'c') ADVANCE(259);
      END_STATE();
    case 233:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'c') ADVANCE(762);
      if (lookahead == 'd') ADVANCE(1642);
      if (lookahead == 'l') ADVANCE(267);
      END_STATE();
    case 234:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'c') ADVANCE(762);
      if (lookahead == 'd') ADVANCE(1643);
      if (lookahead == 'g') ADVANCE(267);
      if (lookahead == 's') ADVANCE(669);
      END_STATE();
    case 235:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'c') ADVANCE(600);
      if (lookahead == 'e') ADVANCE(1168);
      if (lookahead == 'l') ADVANCE(655);
      if (lookahead == 'p') ADVANCE(1810);
      END_STATE();
    case 236:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'c') ADVANCE(1233);
      if (lookahead == 'w') ADVANCE(152);
      END_STATE();
    case 237:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'c') ADVANCE(2068);
      if (lookahead == 'e') ADVANCE(232);
      END_STATE();
    case 238:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'c') ADVANCE(2068);
      if (lookahead == 'e' ||
          lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 239:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'c') ADVANCE(690);
      if (lookahead == 'f') ADVANCE(1278);
      if (lookahead == 'o') ADVANCE(876);
      if (lookahead == 't') ADVANCE(235);
      END_STATE();
    case 240:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'd') ADVANCE(1598);
      END_STATE();
    case 241:
      ADVANCE_MAP(
        ';', 2185,
        'd', 1598,
        'e', 325,
        'g', 167,
        'l', 167,
        'n', 926,
        'p', 1448,
        'r', 583,
      );
      END_STATE();
    case 242:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'd') ADVANCE(1598);
      if (lookahead == 's') ADVANCE(358);
      if (lookahead == 'E' ||
          lookahead == 'v') ADVANCE(152);
      END_STATE();
    case 243:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'd') ADVANCE(152);
      END_STATE();
    case 244:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'd') ADVANCE(152);
      if (lookahead == 'l') ADVANCE(926);
      END_STATE();
    case 245:
      ADVANCE_MAP(
        ';', 2185,
        'd', 1599,
        'e', 240,
        'h', 1916,
        'l', 583,
        'm', 2075,
        'n', 2160,
        'p', 1448,
        's', 1026,
      );
      if (('1' <= lookahead && lookahead <= '3') ||
          lookahead == 'E') ADVANCE(152);
      END_STATE();
    case 246:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'd') ADVANCE(1591);
      if (lookahead == 'l') ADVANCE(986);
      if (lookahead == 'r') ADVANCE(1286);
      END_STATE();
    case 247:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'd') ADVANCE(1591);
      if (lookahead == 'l') ADVANCE(986);
      if (lookahead == 'u') ADVANCE(1677);
      END_STATE();
    case 248:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'd') ADVANCE(1591);
      if (lookahead == 'l') ADVANCE(1079);
      if (lookahead == 'q') ADVANCE(152);
      if (lookahead == 'r') ADVANCE(1329);
      END_STATE();
    case 249:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'd') ADVANCE(1263);
      END_STATE();
    case 250:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 251:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e') ADVANCE(152);
      if (lookahead == 'l') ADVANCE(926);
      if (lookahead == 'm') ADVANCE(1933);
      if (lookahead == 'r') ADVANCE(1987);
      if (lookahead == 's') ADVANCE(1700);
      if (lookahead == 'z') ADVANCE(583);
      END_STATE();
    case 252:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e') ADVANCE(152);
      if (lookahead == 's') ADVANCE(1014);
      END_STATE();
    case 253:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e') ADVANCE(1750);
      END_STATE();
    case 254:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e') ADVANCE(1733);
      if (lookahead == 'm') ADVANCE(1315);
      if (lookahead == 'p') ADVANCE(1448);
      if (lookahead == 's') ADVANCE(1747);
      END_STATE();
    case 255:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e') ADVANCE(1958);
      END_STATE();
    case 256:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e') ADVANCE(1161);
      END_STATE();
    case 257:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e') ADVANCE(1106);
      END_STATE();
    case 258:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e') ADVANCE(325);
      END_STATE();
    case 259:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e') ADVANCE(1732);
      END_STATE();
    case 260:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e') ADVANCE(1732);
      if (lookahead == 'l') ADVANCE(946);
      END_STATE();
    case 261:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e') ADVANCE(334);
      END_STATE();
    case 262:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e') ADVANCE(852);
      if (lookahead == 'i') ADVANCE(1487);
      if (lookahead == 'o') ADVANCE(905);
      END_STATE();
    case 263:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e') ADVANCE(321);
      END_STATE();
    case 264:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e') ADVANCE(1737);
      END_STATE();
    case 265:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e') ADVANCE(1737);
      if (lookahead == 'n') ADVANCE(991);
      END_STATE();
    case 266:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e') ADVANCE(599);
      END_STATE();
    case 267:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e') ADVANCE(1903);
      END_STATE();
    case 268:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e') ADVANCE(1934);
      END_STATE();
    case 269:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e') ADVANCE(1558);
      if (lookahead == 'f') ADVANCE(152);
      END_STATE();
    case 270:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e') ADVANCE(1835);
      if (lookahead == 's') ADVANCE(961);
      END_STATE();
    case 271:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e') ADVANCE(1791);
      if (lookahead == 's') ADVANCE(1677);
      END_STATE();
    case 272:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e') ADVANCE(1801);
      if (lookahead == 'f' ||
          lookahead == 'm') ADVANCE(152);
      END_STATE();
    case 273:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e') ADVANCE(1790);
      END_STATE();
    case 274:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'f') ADVANCE(152);
      END_STATE();
    case 275:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'f') ADVANCE(152);
      if (lookahead == 'r') ADVANCE(1587);
      if (lookahead == 'y') ADVANCE(335);
      END_STATE();
    case 276:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'f') ADVANCE(1903);
      END_STATE();
    case 277:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'f') ADVANCE(1963);
      if (lookahead == 'g') ADVANCE(152);
      if (lookahead == 'q') ADVANCE(326);
      if (lookahead == 's') ADVANCE(234);
      END_STATE();
    case 278:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'f') ADVANCE(1504);
      if (lookahead == 'l') ADVANCE(947);
      END_STATE();
    case 279:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'f') ADVANCE(1988);
      if (lookahead == 'q') ADVANCE(326);
      if (lookahead == 's') ADVANCE(334);
      END_STATE();
    case 280:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'g') ADVANCE(152);
      END_STATE();
    case 281:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'g') ADVANCE(152);
      if (lookahead == 'l') ADVANCE(1979);
      if (lookahead == 'm') ADVANCE(1711);
      END_STATE();
    case 282:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'g') ADVANCE(1958);
      END_STATE();
    case 283:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'g') ADVANCE(926);
      END_STATE();
    case 284:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'h') ADVANCE(152);
      END_STATE();
    case 285:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'h') ADVANCE(152);
      if (lookahead == 'l') ADVANCE(1629);
      END_STATE();
    case 286:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'h') ADVANCE(1588);
      END_STATE();
    case 287:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'i') ADVANCE(1236);
      if (lookahead == 'n') ADVANCE(1118);
      if (lookahead == 'o') ADVANCE(1979);
      END_STATE();
    case 288:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'i') ADVANCE(900);
      if (lookahead == 'o') ADVANCE(1520);
      END_STATE();
    case 289:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'i') ADVANCE(1780);
      if (lookahead == 'u') ADVANCE(1994);
      if (lookahead == 'E' ||
          lookahead == 'd' ||
          lookahead == 'y') ADVANCE(152);
      END_STATE();
    case 290:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'i') ADVANCE(1780);
      if (lookahead == 'y') ADVANCE(152);
      END_STATE();
    case 291:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'i') ADVANCE(1538);
      if (lookahead == 'p') ADVANCE(652);
      if (lookahead == 's') ADVANCE(152);
      END_STATE();
    case 292:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'i') ADVANCE(2017);
      END_STATE();
    case 293:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'i') ADVANCE(865);
      END_STATE();
    case 294:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'i') ADVANCE(1512);
      if (lookahead == 'n') ADVANCE(1246);
      END_STATE();
    case 295:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'i') ADVANCE(1440);
      END_STATE();
    case 296:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'i') ADVANCE(1577);
      if (lookahead == 'l') ADVANCE(152);
      if (lookahead == 's') ADVANCE(240);
      END_STATE();
    case 297:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'l') ADVANCE(152);
      END_STATE();
    case 298:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'l') ADVANCE(152);
      if (lookahead == 'q') ADVANCE(326);
      if (lookahead == 's') ADVANCE(233);
      END_STATE();
    case 299:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'l') ADVANCE(2016);
      if (lookahead == 'e' ||
          lookahead == 'f') ADVANCE(152);
      END_STATE();
    case 300:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'l') ADVANCE(1958);
      END_STATE();
    case 301:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'l') ADVANCE(1629);
      END_STATE();
    case 302:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'l') ADVANCE(1629);
      if (lookahead == 'v') ADVANCE(152);
      END_STATE();
    case 303:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'l') ADVANCE(926);
      if (lookahead == 'd' ||
          lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 304:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'l') ADVANCE(2020);
      if (lookahead == 'm') ADVANCE(572);
      END_STATE();
    case 305:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'l') ADVANCE(1399);
      END_STATE();
    case 306:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'm') ADVANCE(152);
      END_STATE();
    case 307:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'm') ADVANCE(271);
      END_STATE();
    case 308:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'm') ADVANCE(606);
      END_STATE();
    case 309:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'n') ADVANCE(152);
      END_STATE();
    case 310:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'n') ADVANCE(625);
      END_STATE();
    case 311:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'o') ADVANCE(152);
      END_STATE();
    case 312:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'o') ADVANCE(330);
      END_STATE();
    case 313:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'o') ADVANCE(297);
      END_STATE();
    case 314:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'o') ADVANCE(1096);
      END_STATE();
    case 315:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'o') ADVANCE(2127);
      END_STATE();
    case 316:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'o') ADVANCE(2116);
      END_STATE();
    case 317:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'o') ADVANCE(850);
      END_STATE();
    case 318:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'o') ADVANCE(1804);
      END_STATE();
    case 319:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'o') ADVANCE(2033);
      END_STATE();
    case 320:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'o') ADVANCE(1543);
      if (lookahead == 's') ADVANCE(152);
      END_STATE();
    case 321:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'o') ADVANCE(1568);
      END_STATE();
    case 322:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'p') ADVANCE(152);
      END_STATE();
    case 323:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'p') ADVANCE(1096);
      if (lookahead == 't') ADVANCE(294);
      END_STATE();
    case 324:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'p') ADVANCE(1829);
      END_STATE();
    case 325:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'q') ADVANCE(152);
      END_STATE();
    case 326:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'q') ADVANCE(152);
      if (lookahead == 's') ADVANCE(1443);
      END_STATE();
    case 327:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'q') ADVANCE(326);
      if (lookahead == 's') ADVANCE(152);
      END_STATE();
    case 328:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'q') ADVANCE(325);
      END_STATE();
    case 329:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'q') ADVANCE(2079);
      END_STATE();
    case 330:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 331:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'r') ADVANCE(564);
      if (lookahead == 's') ADVANCE(240);
      END_STATE();
    case 332:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'r') ADVANCE(1271);
      END_STATE();
    case 333:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'r') ADVANCE(1249);
      END_STATE();
    case 334:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 's') ADVANCE(152);
      END_STATE();
    case 335:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 's') ADVANCE(1750);
      END_STATE();
    case 336:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 's') ADVANCE(243);
      if (lookahead == 'v') ADVANCE(152);
      END_STATE();
    case 337:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 's') ADVANCE(223);
      END_STATE();
    case 338:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 's') ADVANCE(2149);
      if (lookahead == 'v') ADVANCE(152);
      END_STATE();
    case 339:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 's') ADVANCE(1463);
      END_STATE();
    case 340:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 's') ADVANCE(1358);
      END_STATE();
    case 341:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 's') ADVANCE(2021);
      END_STATE();
    case 342:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 's') ADVANCE(961);
      if (lookahead == 'v') ADVANCE(152);
      END_STATE();
    case 343:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 's') ADVANCE(1016);
      END_STATE();
    case 344:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 's') ADVANCE(1029);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 345:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 's') ADVANCE(2083);
      END_STATE();
    case 346:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 't') ADVANCE(152);
      END_STATE();
    case 347:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 't') ADVANCE(532);
      END_STATE();
    case 348:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 't') ADVANCE(1588);
      END_STATE();
    case 349:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 't') ADVANCE(273);
      END_STATE();
    case 350:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 't') ADVANCE(734);
      END_STATE();
    case 351:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 't') ADVANCE(1358);
      END_STATE();
    case 352:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 't') ADVANCE(832);
      if (lookahead == 'v') ADVANCE(152);
      END_STATE();
    case 353:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 't') ADVANCE(679);
      END_STATE();
    case 354:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 't') ADVANCE(1612);
      END_STATE();
    case 355:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 't') ADVANCE(1271);
      END_STATE();
    case 356:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'u') ADVANCE(152);
      END_STATE();
    case 357:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'u') ADVANCE(1241);
      END_STATE();
    case 358:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'v') ADVANCE(152);
      END_STATE();
    case 359:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'v') ADVANCE(2173);
      END_STATE();
    case 360:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'v') ADVANCE(723);
      END_STATE();
    case 361:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'v') ADVANCE(1028);
      END_STATE();
    case 362:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'a' ||
          lookahead == 'h') ADVANCE(152);
      END_STATE();
    case 363:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'b' ||
          lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 364:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'c' ||
          lookahead == 'w') ADVANCE(152);
      END_STATE();
    case 365:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e' ||
          lookahead == 'g') ADVANCE(152);
      END_STATE();
    case 366:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e' ||
          lookahead == 'l') ADVANCE(152);
      END_STATE();
    case 367:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'f' ||
          lookahead == 'v') ADVANCE(152);
      END_STATE();
    case 368:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'e' ||
          lookahead == 'f') ADVANCE(152);
      END_STATE();
    case 369:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'E' ||
          lookahead == 'a' ||
          lookahead == 'j') ADVANCE(152);
      END_STATE();
    case 370:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == '4' ||
          lookahead == '5' ||
          lookahead == '8') ADVANCE(152);
      END_STATE();
    case 371:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'D' ||
          lookahead == 'U' ||
          lookahead == 'd' ||
          lookahead == 'u') ADVANCE(152);
      END_STATE();
    case 372:
      if (lookahead == ';') ADVANCE(2185);
      if (lookahead == 'H' ||
          lookahead == 'L' ||
          lookahead == 'R' ||
          lookahead == 'h' ||
          lookahead == 'l' ||
          lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 373:
      if (lookahead == ';') ADVANCE(2185);
      if (('2' <= lookahead && lookahead <= '6') ||
          lookahead == '8') ADVANCE(152);
      END_STATE();
    case 374:
      if (lookahead == ';') ADVANCE(2186);
      END_STATE();
    case 375:
      if (lookahead == ';') ADVANCE(2186);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(376);
      END_STATE();
    case 376:
      if (lookahead == ';') ADVANCE(2186);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(374);
      END_STATE();
    case 377:
      if (lookahead == ';') ADVANCE(2186);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(375);
      END_STATE();
    case 378:
      if (lookahead == ';') ADVANCE(2186);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(377);
      END_STATE();
    case 379:
      if (lookahead == ';') ADVANCE(2186);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(378);
      END_STATE();
    case 380:
      if (lookahead == ';') ADVANCE(2186);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(379);
      END_STATE();
    case 381:
      if (lookahead == ';') ADVANCE(2186);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(374);
      END_STATE();
    case 382:
      if (lookahead == ';') ADVANCE(2186);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(381);
      END_STATE();
    case 383:
      if (lookahead == ';') ADVANCE(2186);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(382);
      END_STATE();
    case 384:
      if (lookahead == ';') ADVANCE(2186);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(383);
      END_STATE();
    case 385:
      if (lookahead == ';') ADVANCE(2186);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(384);
      END_STATE();
    case 386:
      if (lookahead == '>') ADVANCE(2234);
      END_STATE();
    case 387:
      if (lookahead == '>') ADVANCE(2241);
      END_STATE();
    case 388:
      if (lookahead == '>') ADVANCE(2228);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '<') ADVANCE(388);
      END_STATE();
    case 389:
      if (lookahead == '@') ADVANCE(2177);
      if (lookahead == '!' ||
          ('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '/' ||
          lookahead == '=' ||
          lookahead == '?' ||
          ('^' <= lookahead && lookahead <= '`') ||
          ('{' <= lookahead && lookahead <= '~')) ADVANCE(390);
      if (lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(151);
      END_STATE();
    case 390:
      if (lookahead == '@') ADVANCE(2177);
      if (lookahead == '!' ||
          ('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          ('^' <= lookahead && lookahead <= '~')) ADVANCE(390);
      END_STATE();
    case 391:
      ADVANCE_MAP(
        'A', 509,
        'a', 825,
        'c', 1289,
        'f', 1750,
        'i', 1377,
        'o', 1683,
        's', 799,
        'u', 1476,
      );
      END_STATE();
    case 392:
      ADVANCE_MAP(
        'A', 593,
        'B', 583,
        'H', 546,
        'a', 772,
        'b', 584,
        'c', 611,
        'd', 802,
        'e', 209,
        'f', 1261,
        'h', 630,
        'i', 1151,
        'l', 589,
        'm', 1661,
        'n', 1477,
        'o', 555,
        'p', 637,
        'r', 583,
        's', 535,
        't', 1217,
        'u', 1403,
        'x', 152,
      );
      END_STATE();
    case 393:
      if (lookahead == 'A') ADVANCE(527);
      END_STATE();
    case 394:
      ADVANCE_MAP(
        'A', 754,
        'I', 754,
        'U', 754,
        'a', 812,
        'c', 1291,
        'f', 1750,
        'o', 1680,
        's', 778,
        'u', 1485,
      );
      END_STATE();
    case 395:
      if (lookahead == 'A') ADVANCE(448);
      END_STATE();
    case 396:
      ADVANCE_MAP(
        'A', 1575,
        'C', 1088,
        'D', 1593,
        'F', 1402,
        'R', 1324,
        'T', 1033,
        'U', 1691,
        'V', 1067,
        'a', 1881,
        'r', 1317,
      );
      END_STATE();
    case 397:
      if (lookahead == 'A') ADVANCE(518);
      END_STATE();
    case 398:
      ADVANCE_MAP(
        'A', 1769,
        'B', 640,
        'D', 579,
        'a', 1535,
        'c', 2139,
        'd', 579,
        'e', 939,
        'f', 1750,
        'l', 2016,
        'n', 1932,
        'o', 1680,
        'p', 1819,
        'r', 2016,
        's', 801,
        'z', 1264,
      );
      END_STATE();
    case 399:
      if (lookahead == 'A') ADVANCE(1769);
      if (lookahead == 'E') ADVANCE(152);
      if (lookahead == 'a') ADVANCE(1769);
      if (lookahead == 'd') ADVANCE(1750);
      if (lookahead == 'e') ADVANCE(279);
      if (lookahead == 's') ADVANCE(1255);
      if (lookahead == 't') ADVANCE(333);
      END_STATE();
    case 400:
      ADVANCE_MAP(
        'A', 1769,
        'H', 546,
        'a', 1134,
        'b', 1355,
        'c', 616,
        'd', 193,
        'e', 281,
        'f', 1262,
        'h', 623,
        'i', 594,
        'j', 754,
        'l', 768,
        'o', 1406,
        'r', 730,
        's', 770,
        't', 880,
        'u', 588,
        'w', 598,
        'z', 759,
      );
      END_STATE();
    case 401:
      ADVANCE_MAP(
        'A', 1769,
        'H', 546,
        'a', 813,
        'b', 1772,
        'c', 1270,
        'd', 585,
        'f', 1262,
        'g', 1811,
        'h', 624,
        'l', 861,
        'm', 195,
        'o', 1138,
        'p', 695,
        'r', 860,
        's', 778,
        't', 877,
        'u', 590,
        'w', 598,
      );
      END_STATE();
    case 402:
      ADVANCE_MAP(
        'A', 1769,
        'a', 1277,
        'b', 546,
        'c', 1289,
        'e', 677,
        'f', 1750,
        'k', 1904,
        'o', 591,
        's', 791,
        'y', 732,
      );
      END_STATE();
    case 403:
      if (lookahead == 'A') ADVANCE(1769);
      if (lookahead == 'a') ADVANCE(1769);
      END_STATE();
    case 404:
      if (lookahead == 'A') ADVANCE(1769);
      if (lookahead == 'a') ADVANCE(1769);
      if (lookahead == 'p') ADVANCE(546);
      END_STATE();
    case 405:
      if (lookahead == 'A') ADVANCE(1769);
      if (lookahead == 'a') ADVANCE(1762);
      if (lookahead == 'c') ADVANCE(346);
      if (lookahead == 'm') ADVANCE(1223);
      if (lookahead == 's') ADVANCE(2122);
      if (lookahead == 't') ADVANCE(1471);
      if (lookahead == 'x') ADVANCE(1958);
      END_STATE();
    case 406:
      if (lookahead == 'A') ADVANCE(1769);
      if (lookahead == 'a') ADVANCE(1762);
      if (lookahead == 'n') ADVANCE(2122);
      END_STATE();
    case 407:
      if (lookahead == 'A') ADVANCE(1769);
      if (lookahead == 'a') ADVANCE(1762);
      if (lookahead == 'n') ADVANCE(975);
      END_STATE();
    case 408:
      if (lookahead == 'A') ADVANCE(1769);
      if (lookahead == 'a') ADVANCE(1861);
      if (lookahead == 'i') ADVANCE(1154);
      if (lookahead == 't') ADVANCE(1844);
      END_STATE();
    case 409:
      if (lookahead == 'A') ADVANCE(1769);
      if (lookahead == 'e') ADVANCE(152);
      if (lookahead == 't') ADVANCE(332);
      END_STATE();
    case 410:
      if (lookahead == 'A') ADVANCE(1769);
      if (lookahead == 't') ADVANCE(1839);
      END_STATE();
    case 411:
      ADVANCE_MAP(
        'A', 1884,
        'D', 1652,
        'E', 1743,
        'T', 1018,
        'a', 1881,
        'd', 1659,
        'p', 1027,
        's', 1240,
      );
      END_STATE();
    case 412:
      if (lookahead == 'A') ADVANCE(818);
      END_STATE();
    case 413:
      if (lookahead == 'A') ADVANCE(818);
      if (lookahead == 'D') ADVANCE(1596);
      if (lookahead == 'G') ADVANCE(1802);
      if (lookahead == 'T') ADVANCE(1318);
      END_STATE();
    case 414:
      if (lookahead == 'A') ADVANCE(1400);
      END_STATE();
    case 415:
      ADVANCE_MAP(
        'A', 1576,
        'C', 1088,
        'D', 1593,
        'F', 1402,
        'T', 1033,
        'U', 1691,
        'V', 1067,
        'a', 1881,
      );
      END_STATE();
    case 416:
      if (lookahead == 'A') ADVANCE(1881);
      END_STATE();
    case 417:
      if (lookahead == 'A') ADVANCE(1881);
      if (lookahead == 'D') ADVANCE(1652);
      END_STATE();
    case 418:
      if (lookahead == 'A') ADVANCE(1881);
      if (lookahead == 'R') ADVANCE(1325);
      END_STATE();
    case 419:
      if (lookahead == 'A') ADVANCE(1881);
      if (lookahead == 'R') ADVANCE(1325);
      if (lookahead == 'T') ADVANCE(1003);
      END_STATE();
    case 420:
      if (lookahead == 'A') ADVANCE(1881);
      if (lookahead == 'T') ADVANCE(1003);
      END_STATE();
    case 421:
      if (lookahead == 'A') ADVANCE(1881);
      if (lookahead == 'V') ADVANCE(1072);
      END_STATE();
    case 422:
      if (lookahead == 'A') ADVANCE(1885);
      if (lookahead == 'B') ADVANCE(1749);
      if (lookahead == 'L') ADVANCE(1065);
      if (lookahead == 'R') ADVANCE(1323);
      if (lookahead == 'T') ADVANCE(1018);
      if (lookahead == 'a') ADVANCE(1881);
      END_STATE();
    case 423:
      if (lookahead == 'B') ADVANCE(549);
      if (lookahead == 'P') ADVANCE(698);
      END_STATE();
    case 424:
      ADVANCE_MAP(
        'B', 583,
        'E', 180,
        'a', 822,
        'c', 613,
        'e', 361,
        'f', 1750,
        'h', 1588,
        'i', 1132,
        'o', 1686,
        'r', 1317,
        's', 785,
        'u', 1393,
      );
      END_STATE();
    case 425:
      if (lookahead == 'B') ADVANCE(546);
      END_STATE();
    case 426:
      if (lookahead == 'B') ADVANCE(546);
      if (lookahead == 'L') ADVANCE(1272);
      if (lookahead == 'S') ADVANCE(1060);
      if (lookahead == 'T') ADVANCE(1318);
      END_STATE();
    case 427:
      if (lookahead == 'B') ADVANCE(1882);
      END_STATE();
    case 428:
      if (lookahead == 'B') ADVANCE(1874);
      if (lookahead == 'n') ADVANCE(429);
      if (lookahead == 'p') ADVANCE(1096);
      if (lookahead == 't') ADVANCE(163);
      END_STATE();
    case 429:
      if (lookahead == 'B') ADVANCE(1879);
      END_STATE();
    case 430:
      if (lookahead == 'C') ADVANCE(482);
      if (lookahead == 'c') ADVANCE(2139);
      END_STATE();
    case 431:
      if (lookahead == 'C') ADVANCE(451);
      END_STATE();
    case 432:
      if (lookahead == 'C') ADVANCE(572);
      END_STATE();
    case 433:
      if (lookahead == 'C') ADVANCE(1653);
      if (lookahead == 'T') ADVANCE(1304);
      END_STATE();
    case 434:
      if (lookahead == 'C') ADVANCE(1330);
      END_STATE();
    case 435:
      if (lookahead == 'C') ADVANCE(1425);
      END_STATE();
    case 436:
      if (lookahead == 'C') ADVANCE(2087);
      END_STATE();
    case 437:
      if (lookahead == 'C') ADVANCE(1669);
      END_STATE();
    case 438:
      if (lookahead == 'C') ADVANCE(1669);
      if (lookahead == 'D') ADVANCE(1595);
      if (lookahead == 'L') ADVANCE(1077);
      if (lookahead == 'R') ADVANCE(1327);
      if (lookahead == 'U') ADVANCE(1692);
      if (lookahead == 'V') ADVANCE(1086);
      END_STATE();
    case 439:
      if (lookahead == 'D') ADVANCE(1598);
      END_STATE();
    case 440:
      if (lookahead == 'D') ADVANCE(1598);
      if (lookahead == 'M') ADVANCE(1315);
      if (lookahead == 'P') ADVANCE(1448);
      if (lookahead == 'T') ADVANCE(1304);
      END_STATE();
    case 441:
      if (lookahead == 'D') ADVANCE(1598);
      if (lookahead == 'a') ADVANCE(1769);
      END_STATE();
    case 442:
      if (lookahead == 'D') ADVANCE(1598);
      if (lookahead == 'o') ADVANCE(1958);
      END_STATE();
    case 443:
      if (lookahead == 'D') ADVANCE(1598);
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 444:
      ADVANCE_MAP(
        'D', 319,
        'J', 754,
        'S', 754,
        'Z', 754,
        'a', 1136,
        'c', 616,
        'e', 1359,
        'f', 1750,
        'i', 558,
        'o', 1684,
        's', 799,
      );
      END_STATE();
    case 445:
      if (lookahead == 'D') ADVANCE(152);
      END_STATE();
    case 446:
      ADVANCE_MAP(
        'D', 442,
        'a', 816,
        'c', 614,
        'd', 1598,
        'e', 152,
        'f', 443,
        'g', 331,
        'l', 296,
        'm', 545,
        'n', 1121,
        'o', 1138,
        'p', 627,
        'q', 809,
        'r', 441,
        's', 779,
        't', 362,
        'u', 1465,
        'x', 837,
      );
      END_STATE();
    case 447:
      ADVANCE_MAP(
        'D', 439,
        'a', 764,
        'c', 1654,
        'd', 579,
        'e', 662,
        'f', 1750,
        'h', 1588,
        'i', 853,
        'l', 817,
        'n', 1708,
        'o', 917,
        'p', 152,
        's', 798,
        'u', 304,
      );
      END_STATE();
    case 448:
      if (lookahead == 'D') ADVANCE(462);
      END_STATE();
    case 449:
      ADVANCE_MAP(
        'D', 2174,
        'H', 371,
        'U', 2174,
        'V', 372,
        'b', 1603,
        'd', 2174,
        'h', 371,
        'm', 1315,
        'p', 1448,
        't', 1304,
        'u', 2174,
        'v', 372,
      );
      END_STATE();
    case 450:
      if (lookahead == 'D') ADVANCE(754);
      END_STATE();
    case 451:
      if (lookahead == 'D') ADVANCE(397);
      END_STATE();
    case 452:
      ADVANCE_MAP(
        'D', 579,
        'H', 583,
        'a', 1677,
        'd', 579,
        'g', 2166,
        'i', 1522,
        'l', 409,
        'r', 410,
        's', 1255,
      );
      END_STATE();
    case 453:
      ADVANCE_MAP(
        'D', 579,
        'b', 546,
        'c', 2139,
        'd', 582,
        'e', 929,
        'f', 1750,
        'o', 1680,
        's', 778,
        'v', 897,
      );
      END_STATE();
    case 454:
      if (lookahead == 'D') ADVANCE(579);
      if (lookahead == 'd') ADVANCE(579);
      END_STATE();
    case 455:
      if (lookahead == 'D') ADVANCE(1652);
      if (lookahead == 'L') ADVANCE(1074);
      if (lookahead == 'R') ADVANCE(1325);
      if (lookahead == 'U') ADVANCE(1696);
      END_STATE();
    case 456:
      if (lookahead == 'D') ADVANCE(1254);
      END_STATE();
    case 457:
      if (lookahead == 'D') ADVANCE(1020);
      END_STATE();
    case 458:
      if (lookahead == 'D') ADVANCE(1660);
      if (lookahead == 'E') ADVANCE(1740);
      END_STATE();
    case 459:
      if (lookahead == 'D') ADVANCE(1664);
      if (lookahead == 'T') ADVANCE(1039);
      if (lookahead == 'V') ADVANCE(1067);
      END_STATE();
    case 460:
      if (lookahead == 'D') ADVANCE(1674);
      if (lookahead == 'Q') ADVANCE(2098);
      END_STATE();
    case 461:
      ADVANCE_MAP(
        'E', 1398,
        'M', 187,
        'a', 812,
        'b', 1749,
        'c', 1270,
        'f', 1750,
        'g', 1811,
        'l', 1679,
        'm', 541,
        'n', 881,
        'o', 1138,
        'p', 1704,
        'r', 1245,
        's', 796,
        't', 1292,
        'u', 1464,
      );
      END_STATE();
    case 462:
      if (lookahead == 'E') ADVANCE(152);
      END_STATE();
    case 463:
      if (lookahead == 'E') ADVANCE(152);
      if (lookahead == 'a') ADVANCE(1677);
      if (lookahead == 's') ADVANCE(1255);
      END_STATE();
    case 464:
      if (lookahead == 'E') ADVANCE(152);
      if (lookahead == 'a') ADVANCE(1695);
      if (lookahead == 'e') ADVANCE(328);
      if (lookahead == 's') ADVANCE(1255);
      END_STATE();
    case 465:
      if (lookahead == 'E') ADVANCE(152);
      if (lookahead == 'e') ADVANCE(327);
      if (lookahead == 's') ADVANCE(1255);
      if (lookahead == 't') ADVANCE(330);
      END_STATE();
    case 466:
      if (lookahead == 'E') ADVANCE(1371);
      if (lookahead == 'U') ADVANCE(1727);
      END_STATE();
    case 467:
      ADVANCE_MAP(
        'E', 754,
        'J', 1404,
        'O', 754,
        'a', 812,
        'c', 1270,
        'd', 1598,
        'f', 1750,
        'g', 1811,
        'm', 192,
        'n', 1986,
        'o', 1139,
        's', 778,
        't', 1318,
        'u', 1347,
      );
      END_STATE();
    case 468:
      if (lookahead == 'E') ADVANCE(1370);
      END_STATE();
    case 469:
      ADVANCE_MAP(
        'E', 1404,
        'a', 812,
        'c', 1270,
        'd', 752,
        'f', 1750,
        'g', 1811,
        'm', 543,
        'o', 1680,
        'p', 990,
        'r', 152,
        's', 793,
        't', 1239,
        'u', 1464,
        'v', 1005,
      );
      END_STATE();
    case 470:
      if (lookahead == 'E') ADVANCE(1743);
      END_STATE();
    case 471:
      if (lookahead == 'E') ADVANCE(1740);
      END_STATE();
    case 472:
      if (lookahead == 'E') ADVANCE(1745);
      if (lookahead == 'F') ADVANCE(2097);
      if (lookahead == 'G') ADVANCE(1890);
      if (lookahead == 'L') ADVANCE(972);
      if (lookahead == 'S') ADVANCE(1458);
      if (lookahead == 'T') ADVANCE(1318);
      END_STATE();
    case 473:
      if (lookahead == 'E') ADVANCE(1746);
      if (lookahead == 'F') ADVANCE(2097);
      if (lookahead == 'G') ADVANCE(1890);
      if (lookahead == 'L') ADVANCE(972);
      if (lookahead == 'S') ADVANCE(1458);
      if (lookahead == 'T') ADVANCE(1318);
      END_STATE();
    case 474:
      if (lookahead == 'F') ADVANCE(517);
      END_STATE();
    case 475:
      if (lookahead == 'F') ADVANCE(2091);
      END_STATE();
    case 476:
      if (lookahead == 'G') ADVANCE(152);
      END_STATE();
    case 477:
      ADVANCE_MAP(
        'G', 1122,
        'L', 1053,
        'R', 1317,
        'V', 454,
        'a', 736,
        'b', 1905,
        'c', 566,
        'd', 579,
        'e', 154,
        'f', 1750,
        'g', 465,
        'h', 404,
        'i', 336,
        'j', 754,
        'l', 399,
        'm', 1222,
        'o', 323,
        'p', 635,
        'r', 408,
        's', 771,
        't', 1142,
        'u', 307,
        'v', 452,
        'w', 407,
      );
      END_STATE();
    case 478:
      if (lookahead == 'G') ADVANCE(1890);
      END_STATE();
    case 479:
      if (lookahead == 'G') ADVANCE(1899);
      if (lookahead == 'L') ADVANCE(1055);
      END_STATE();
    case 480:
      ADVANCE_MAP(
        'H', 430,
        'O', 474,
        'a', 818,
        'c', 208,
        'f', 1750,
        'h', 1655,
        'i', 1140,
        'm', 660,
        'o', 1680,
        'q', 1776,
        's', 778,
        't', 546,
        'u', 720,
      );
      END_STATE();
    case 481:
      ADVANCE_MAP(
        'H', 502,
        'R', 395,
        'S', 486,
        'a', 2163,
        'c', 613,
        'f', 1750,
        'h', 960,
        'i', 1386,
        'o', 1680,
        'r', 1297,
        's', 799,
      );
      END_STATE();
    case 482:
      if (lookahead == 'H') ADVANCE(754);
      END_STATE();
    case 483:
      if (lookahead == 'H') ADVANCE(754);
      if (lookahead == 'J') ADVANCE(754);
      if (lookahead == 'a') ADVANCE(1701);
      if (lookahead == 'c') ADVANCE(981);
      if (lookahead == 'f') ADVANCE(1750);
      if (lookahead == 'o') ADVANCE(1680);
      if (lookahead == 's') ADVANCE(778);
      END_STATE();
    case 484:
      ADVANCE_MAP(
        'H', 754,
        'O', 503,
        'a', 824,
        'c', 612,
        'd', 1598,
        'e', 914,
        'f', 1750,
        'h', 1223,
        'i', 1797,
        'l', 1602,
        'o', 1442,
        'r', 1604,
        's', 778,
        'u', 1687,
      );
      END_STATE();
    case 485:
      ADVANCE_MAP(
        'H', 754,
        'a', 818,
        'c', 616,
        'd', 1598,
        'e', 1807,
        'f', 1750,
        'o', 1680,
        's', 778,
      );
      END_STATE();
    case 486:
      if (lookahead == 'H') ADVANCE(754);
      if (lookahead == 'c') ADVANCE(2139);
      END_STATE();
    case 487:
      if (lookahead == 'H') ADVANCE(2099);
      END_STATE();
    case 488:
      if (lookahead == 'I') ADVANCE(152);
      END_STATE();
    case 489:
      if (lookahead == 'I') ADVANCE(1498);
      END_STATE();
    case 490:
      if (lookahead == 'I') ADVANCE(1565);
      END_STATE();
    case 491:
      ADVANCE_MAP(
        'J', 754,
        'a', 818,
        'c', 613,
        'e', 1143,
        'f', 1750,
        'o', 428,
        's', 778,
        't', 1292,
        'u', 152,
      );
      END_STATE();
    case 492:
      if (lookahead == 'L') ADVANCE(972);
      END_STATE();
    case 493:
      if (lookahead == 'L') ADVANCE(1272);
      END_STATE();
    case 494:
      if (lookahead == 'L') ADVANCE(1070);
      if (lookahead == 'R') ADVANCE(1325);
      END_STATE();
    case 495:
      if (lookahead == 'L') ADVANCE(1070);
      if (lookahead == 'R') ADVANCE(1325);
      if (lookahead == 'l') ADVANCE(1052);
      if (lookahead == 'r') ADVANCE(1317);
      END_STATE();
    case 496:
      if (lookahead == 'L') ADVANCE(1074);
      if (lookahead == 'R') ADVANCE(1325);
      END_STATE();
    case 497:
      if (lookahead == 'M') ADVANCE(1056);
      if (lookahead == 'T') ADVANCE(1205);
      if (lookahead == 'V') ADVANCE(1044);
      END_STATE();
    case 498:
      if (lookahead == 'M') ADVANCE(1315);
      END_STATE();
    case 499:
      ADVANCE_MAP(
        'N', 1598,
        'a', 808,
        'b', 1793,
        'c', 1619,
        'd', 1739,
        'e', 873,
        'f', 1750,
        'i', 1123,
        'k', 678,
        'l', 559,
        'n', 938,
        'o', 1685,
        'p', 1820,
        'r', 936,
        's', 780,
        'u', 1405,
      );
      END_STATE();
    case 500:
      ADVANCE_MAP(
        'N', 476,
        'T', 181,
        'a', 812,
        'c', 615,
        'd', 1598,
        'f', 1750,
        'g', 1811,
        'l', 1057,
        'm', 544,
        'o', 1138,
        'p', 1954,
        'q', 2051,
        's', 788,
        't', 532,
        'u', 1464,
        'x', 1248,
      );
      END_STATE();
    case 501:
      if (lookahead == 'O') ADVANCE(189);
      END_STATE();
    case 502:
      if (lookahead == 'O') ADVANCE(508);
      END_STATE();
    case 503:
      if (lookahead == 'P') ADVANCE(191);
      END_STATE();
    case 504:
      if (lookahead == 'P') ADVANCE(546);
      END_STATE();
    case 505:
      if (lookahead == 'P') ADVANCE(546);
      if (lookahead == 'i') ADVANCE(368);
      END_STATE();
    case 506:
      if (lookahead == 'P') ADVANCE(1448);
      END_STATE();
    case 507:
      if (lookahead == 'Q') ADVANCE(2098);
      END_STATE();
    case 508:
      if (lookahead == 'R') ADVANCE(186);
      END_STATE();
    case 509:
      if (lookahead == 'R') ADVANCE(450);
      END_STATE();
    case 510:
      if (lookahead == 'R') ADVANCE(1328);
      if (lookahead == 'T') ADVANCE(1039);
      if (lookahead == 'V') ADVANCE(1067);
      END_STATE();
    case 511:
      ADVANCE_MAP(
        'S', 152,
        'a', 815,
        'c', 1270,
        'd', 580,
        'e', 1404,
        'f', 851,
        'g', 1630,
        'h', 727,
        'i', 1516,
        'l', 586,
        'm', 542,
        'o', 1680,
        'p', 547,
        'r', 204,
        's', 794,
        't', 1287,
        'u', 1464,
        'v', 725,
      );
      END_STATE();
    case 512:
      if (lookahead == 'S') ADVANCE(1502);
      END_STATE();
    case 513:
      if (lookahead == 'S') ADVANCE(1502);
      if (lookahead == 'V') ADVANCE(1042);
      END_STATE();
    case 514:
      if (lookahead == 'S') ADVANCE(1720);
      END_STATE();
    case 515:
      if (lookahead == 'S') ADVANCE(2061);
      END_STATE();
    case 516:
      if (lookahead == 'S') ADVANCE(1747);
      END_STATE();
    case 517:
      if (lookahead == 'T') ADVANCE(754);
      END_STATE();
    case 518:
      if (lookahead == 'T') ADVANCE(393);
      END_STATE();
    case 519:
      if (lookahead == 'T') ADVANCE(1219);
      END_STATE();
    case 520:
      if (lookahead == 'T') ADVANCE(1200);
      END_STATE();
    case 521:
      if (lookahead == 'T') ADVANCE(1039);
      if (lookahead == 'V') ADVANCE(1067);
      END_STATE();
    case 522:
      if (lookahead == 'T') ADVANCE(1901);
      END_STATE();
    case 523:
      if (lookahead == 'U') ADVANCE(501);
      if (lookahead == 'f') ADVANCE(1750);
      if (lookahead == 'o') ADVANCE(1680);
      if (lookahead == 's') ADVANCE(778);
      END_STATE();
    case 524:
      if (lookahead == 'V') ADVANCE(1086);
      END_STATE();
    case 525:
      if (lookahead == 'V') ADVANCE(1072);
      END_STATE();
    case 526:
      if (lookahead == 'W') ADVANCE(1274);
      END_STATE();
    case 527:
      if (lookahead == '[') ADVANCE(2240);
      END_STATE();
    case 528:
      if (lookahead == '_') ADVANCE(528);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '@' < lookahead) &&
          (lookahead < '[' || '`' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(2245);
      END_STATE();
    case 529:
      ADVANCE_MAP(
        'a', 812,
        'b', 1749,
        'c', 289,
        'e', 1398,
        'f', 330,
        'g', 1811,
        'l', 937,
        'm', 197,
        'n', 885,
        'o', 1138,
        'p', 202,
        'r', 1245,
        's', 797,
        't', 1292,
        'u', 1464,
        'w', 833,
      );
      END_STATE();
    case 530:
      ADVANCE_MAP(
        'a', 812,
        'c', 290,
        'e', 761,
        'f', 2167,
        'g', 1811,
        'i', 287,
        'j', 1404,
        'm', 538,
        'n', 239,
        'o', 758,
        'p', 1810,
        'q', 2066,
        's', 790,
        't', 295,
        'u', 1347,
      );
      END_STATE();
    case 531:
      ADVANCE_MAP(
        'a', 804,
        'c', 2139,
        'e', 839,
        'f', 1750,
        'o', 1680,
        'r', 935,
        's', 778,
        'u', 1475,
      );
      END_STATE();
    case 532:
      if (lookahead == 'a') ADVANCE(152);
      END_STATE();
    case 533:
      if (lookahead == 'a') ADVANCE(330);
      END_STATE();
    case 534:
      if (lookahead == 'a') ADVANCE(1739);
      if (lookahead == 'c') ADVANCE(1750);
      if (lookahead == 'h') ADVANCE(152);
      if (lookahead == 'i') ADVANCE(1469);
      if (lookahead == 'q') ADVANCE(719);
      if (lookahead == 't') ADVANCE(1821);
      END_STATE();
    case 535:
      if (lookahead == 'a') ADVANCE(1739);
      if (lookahead == 'c') ADVANCE(1750);
      if (lookahead == 'h') ADVANCE(152);
      if (lookahead == 'q') ADVANCE(719);
      END_STATE();
    case 536:
      ADVANCE_MAP(
        'a', 823,
        'c', 561,
        'd', 1598,
        'e', 907,
        'f', 1750,
        'h', 756,
        'i', 1754,
        'l', 2056,
        'o', 1452,
        'r', 592,
        's', 800,
        't', 876,
        'u', 924,
        'w', 833,
        'y', 1395,
      );
      END_STATE();
    case 537:
      if (lookahead == 'a') ADVANCE(2113);
      END_STATE();
    case 538:
      if (lookahead == 'a') ADVANCE(783);
      if (lookahead == 'o') ADVANCE(1096);
      if (lookahead == 'p') ADVANCE(925);
      END_STATE();
    case 539:
      if (lookahead == 'a') ADVANCE(1412);
      if (lookahead == 'e') ADVANCE(1725);
      if (lookahead == 'i') ADVANCE(883);
      if (lookahead == 't') ADVANCE(261);
      END_STATE();
    case 540:
      if (lookahead == 'a') ADVANCE(367);
      END_STATE();
    case 541:
      if (lookahead == 'a') ADVANCE(778);
      END_STATE();
    case 542:
      if (lookahead == 'a') ADVANCE(778);
      if (lookahead == 'e') ADVANCE(1131);
      if (lookahead == 'i') ADVANCE(845);
      END_STATE();
    case 543:
      if (lookahead == 'a') ADVANCE(778);
      if (lookahead == 'e') ADVANCE(1131);
      if (lookahead == 'i') ADVANCE(844);
      END_STATE();
    case 544:
      if (lookahead == 'a') ADVANCE(778);
      if (lookahead == 'p') ADVANCE(1985);
      END_STATE();
    case 545:
      if (lookahead == 'a') ADVANCE(778);
      if (lookahead == 'p') ADVANCE(1993);
      if (lookahead == 's') ADVANCE(1690);
      END_STATE();
    case 546:
      if (lookahead == 'a') ADVANCE(1750);
      END_STATE();
    case 547:
      if (lookahead == 'a') ADVANCE(1750);
      if (lookahead == 'e') ADVANCE(1798);
      if (lookahead == 'l') ADVANCE(2065);
      END_STATE();
    case 548:
      if (lookahead == 'a') ADVANCE(1750);
      if (lookahead == 'f') ADVANCE(152);
      if (lookahead == 'l') ADVANCE(2065);
      END_STATE();
    case 549:
      if (lookahead == 'a') ADVANCE(1750);
      if (lookahead == 'r') ADVANCE(628);
      END_STATE();
    case 550:
      ADVANCE_MAP(
        'a', 814,
        'b', 1772,
        'c', 1270,
        'd', 752,
        'f', 1750,
        'g', 1811,
        'm', 541,
        'n', 895,
        'o', 1138,
        'p', 411,
        'r', 1260,
        's', 778,
        't', 1318,
        'u', 1464,
      );
      END_STATE();
    case 551:
      if (lookahead == 'a') ADVANCE(1516);
      END_STATE();
    case 552:
      if (lookahead == 'a') ADVANCE(358);
      END_STATE();
    case 553:
      ADVANCE_MAP(
        'a', 1875,
        'b', 1804,
        'c', 613,
        'd', 1598,
        'e', 1453,
        'f', 1750,
        'h', 967,
        'i', 1441,
        'o', 958,
        'p', 1820,
        'r', 665,
        's', 769,
        'w', 1227,
      );
      END_STATE();
    case 554:
      ADVANCE_MAP(
        'a', 1526,
        'b', 1804,
        'n', 1129,
        'o', 1726,
        'p', 548,
        't', 1304,
        'w', 596,
        'z', 269,
      );
      END_STATE();
    case 555:
      if (lookahead == 'a') ADVANCE(1526);
      if (lookahead == 'b') ADVANCE(1804);
      if (lookahead == 'p') ADVANCE(548);
      if (lookahead == 't') ADVANCE(1304);
      END_STATE();
    case 556:
      if (lookahead == 'a') ADVANCE(1958);
      END_STATE();
    case 557:
      if (lookahead == 'a') ADVANCE(1958);
      if (lookahead == 'l') ADVANCE(1252);
      if (lookahead == 't') ADVANCE(1532);
      END_STATE();
    case 558:
      if (lookahead == 'a') ADVANCE(867);
      if (lookahead == 'f') ADVANCE(1107);
      END_STATE();
    case 559:
      if (lookahead == 'a') ADVANCE(834);
      if (lookahead == 'k') ADVANCE(144);
      if (lookahead == 'o') ADVANCE(827);
      END_STATE();
    case 560:
      if (lookahead == 'a') ADVANCE(243);
      END_STATE();
    case 561:
      if (lookahead == 'a') ADVANCE(1702);
      if (lookahead == 'e') ADVANCE(906);
      if (lookahead == 'i') ADVANCE(1817);
      if (lookahead == 'u') ADVANCE(1710);
      END_STATE();
    case 562:
      if (lookahead == 'a') ADVANCE(918);
      END_STATE();
    case 563:
      if (lookahead == 'a') ADVANCE(338);
      END_STATE();
    case 564:
      if (lookahead == 'a') ADVANCE(2111);
      END_STATE();
    case 565:
      if (lookahead == 'a') ADVANCE(774);
      if (lookahead == 'o') ADVANCE(2127);
      END_STATE();
    case 566:
      if (lookahead == 'a') ADVANCE(1678);
      if (lookahead == 'e') ADVANCE(921);
      if (lookahead == 'o') ADVANCE(1539);
      if (lookahead == 'u') ADVANCE(1677);
      if (lookahead == 'y') ADVANCE(152);
      END_STATE();
    case 567:
      if (lookahead == 'a') ADVANCE(346);
      END_STATE();
    case 568:
      ADVANCE_MAP(
        'a', 773,
        'c', 1291,
        'e', 309,
        'f', 1750,
        'i', 754,
        'o', 1680,
        's', 778,
        'u', 760,
      );
      END_STATE();
    case 569:
      ADVANCE_MAP(
        'a', 1800,
        'c', 2139,
        'f', 1750,
        'h', 1223,
        'i', 152,
        'l', 2060,
        'o', 1288,
        'r', 262,
        's', 787,
      );
      END_STATE();
    case 570:
      if (lookahead == 'a') ADVANCE(1701);
      END_STATE();
    case 571:
      if (lookahead == 'a') ADVANCE(1713);
      if (lookahead == 'd') ADVANCE(1598);
      if (lookahead == 'e') ADVANCE(1734);
      if (lookahead == 'l') ADVANCE(972);
      if (lookahead == 's') ADVANCE(1255);
      END_STATE();
    case 572:
      if (lookahead == 'a') ADVANCE(1677);
      END_STATE();
    case 573:
      ADVANCE_MAP(
        'a', 1677,
        'c', 2139,
        'e', 902,
        'f', 1750,
        'i', 1556,
        'o', 1680,
        's', 778,
        'u', 152,
      );
      END_STATE();
    case 574:
      if (lookahead == 'a') ADVANCE(1677);
      if (lookahead == 'i') ADVANCE(1817);
      if (lookahead == 'u') ADVANCE(1677);
      END_STATE();
    case 575:
      if (lookahead == 'a') ADVANCE(1677);
      if (lookahead == 's') ADVANCE(1255);
      END_STATE();
    case 576:
      if (lookahead == 'a') ADVANCE(1677);
      if (lookahead == 'u') ADVANCE(1677);
      END_STATE();
    case 577:
      if (lookahead == 'a') ADVANCE(1120);
      END_STATE();
    case 578:
      ADVANCE_MAP(
        'a', 1460,
        'c', 2139,
        'e', 1490,
        'f', 1285,
        'i', 1404,
        'j', 1404,
        'l', 557,
        'n', 1590,
        'o', 1681,
        'p', 668,
        'r', 565,
        's', 778,
      );
      END_STATE();
    case 579:
      if (lookahead == 'a') ADVANCE(1924);
      END_STATE();
    case 580:
      if (lookahead == 'a') ADVANCE(1924);
      if (lookahead == 'b') ADVANCE(1438);
      if (lookahead == 'i') ADVANCE(2108);
      if (lookahead == 'o') ADVANCE(1958);
      if (lookahead == 's') ADVANCE(1640);
      END_STATE();
    case 581:
      if (lookahead == 'a') ADVANCE(1339);
      END_STATE();
    case 582:
      if (lookahead == 'a') ADVANCE(1927);
      END_STATE();
    case 583:
      if (lookahead == 'a') ADVANCE(1769);
      END_STATE();
    case 584:
      if (lookahead == 'a') ADVANCE(1769);
      if (lookahead == 'b') ADVANCE(1804);
      if (lookahead == 'r') ADVANCE(618);
      END_STATE();
    case 585:
      if (lookahead == 'a') ADVANCE(1769);
      if (lookahead == 'b') ADVANCE(1438);
      if (lookahead == 'h') ADVANCE(546);
      END_STATE();
    case 586:
      if (lookahead == 'a') ADVANCE(1769);
      if (lookahead == 'c') ADVANCE(1234);
      if (lookahead == 'i') ADVANCE(1538);
      if (lookahead == 't') ADVANCE(152);
      END_STATE();
    case 587:
      if (lookahead == 'a') ADVANCE(1769);
      if (lookahead == 'c') ADVANCE(1649);
      if (lookahead == 'h') ADVANCE(649);
      if (lookahead == 'm') ADVANCE(152);
      if (lookahead == 't') ADVANCE(1785);
      END_STATE();
    case 588:
      if (lookahead == 'a') ADVANCE(1769);
      if (lookahead == 'h') ADVANCE(546);
      END_STATE();
    case 589:
      if (lookahead == 'a') ADVANCE(1769);
      if (lookahead == 'h') ADVANCE(546);
      if (lookahead == 'm') ADVANCE(152);
      END_STATE();
    case 590:
      if (lookahead == 'a') ADVANCE(1769);
      if (lookahead == 'm') ADVANCE(297);
      END_STATE();
    case 591:
      if (lookahead == 'a') ADVANCE(1769);
      if (lookahead == 'm') ADVANCE(2000);
      if (lookahead == 'o') ADVANCE(1342);
      if (lookahead == 'p') ADVANCE(1096);
      if (lookahead == 'r') ADVANCE(725);
      END_STATE();
    case 592:
      if (lookahead == 'a') ADVANCE(1769);
      if (lookahead == 'o') ADVANCE(1929);
      END_STATE();
    case 593:
      if (lookahead == 'a') ADVANCE(1769);
      if (lookahead == 'r') ADVANCE(1750);
      if (lookahead == 't') ADVANCE(679);
      END_STATE();
    case 594:
      if (lookahead == 'a') ADVANCE(1467);
      if (lookahead == 'e') ADVANCE(152);
      if (lookahead == 'g') ADVANCE(661);
      if (lookahead == 's') ADVANCE(1267);
      if (lookahead == 'v') ADVANCE(288);
      END_STATE();
    case 595:
      if (lookahead == 'a') ADVANCE(2150);
      END_STATE();
    case 596:
      if (lookahead == 'a') ADVANCE(1914);
      if (lookahead == 'b') ADVANCE(546);
      END_STATE();
    case 597:
      if (lookahead == 'a') ADVANCE(1914);
      if (lookahead == 'c') ADVANCE(1289);
      if (lookahead == 'd') ADVANCE(579);
      if (lookahead == 'R' ||
          lookahead == 'S') ADVANCE(152);
      END_STATE();
    case 598:
      if (lookahead == 'a') ADVANCE(1537);
      END_STATE();
    case 599:
      if (lookahead == 'a') ADVANCE(1997);
      END_STATE();
    case 600:
      if (lookahead == 'a') ADVANCE(1358);
      END_STATE();
    case 601:
      ADVANCE_MAP(
        'a', 1756,
        'c', 2139,
        'e', 1757,
        'f', 1750,
        'h', 1237,
        'i', 352,
        'l', 617,
        'm', 152,
        'o', 1298,
        'r', 168,
        's', 787,
        'u', 1536,
      );
      END_STATE();
    case 602:
      if (lookahead == 'a') ADVANCE(1991);
      if (lookahead == 'e') ADVANCE(1938);
      if (lookahead == 'o') ADVANCE(346);
      END_STATE();
    case 603:
      if (lookahead == 'a') ADVANCE(1182);
      END_STATE();
    case 604:
      if (lookahead == 'a') ADVANCE(1356);
      END_STATE();
    case 605:
      if (lookahead == 'a') ADVANCE(1381);
      if (lookahead == 'l') ADVANCE(1272);
      if (lookahead == 's') ADVANCE(2085);
      END_STATE();
    case 606:
      if (lookahead == 'a') ADVANCE(1804);
      END_STATE();
    case 607:
      if (lookahead == 'a') ADVANCE(1917);
      END_STATE();
    case 608:
      if (lookahead == 'a') ADVANCE(1504);
      END_STATE();
    case 609:
      if (lookahead == 'a') ADVANCE(762);
      END_STATE();
    case 610:
      if (lookahead == 'a') ADVANCE(1538);
      END_STATE();
    case 611:
      if (lookahead == 'a') ADVANCE(1803);
      if (lookahead == 'e') ADVANCE(922);
      if (lookahead == 'u') ADVANCE(718);
      if (lookahead == 'y') ADVANCE(152);
      END_STATE();
    case 612:
      if (lookahead == 'a') ADVANCE(1803);
      if (lookahead == 'e') ADVANCE(906);
      if (lookahead == 'i') ADVANCE(1817);
      if (lookahead == 'o') ADVANCE(1566);
      END_STATE();
    case 613:
      if (lookahead == 'a') ADVANCE(1803);
      if (lookahead == 'e') ADVANCE(921);
      if (lookahead == 'y') ADVANCE(152);
      END_STATE();
    case 614:
      if (lookahead == 'a') ADVANCE(1803);
      if (lookahead == 'i') ADVANCE(1780);
      if (lookahead == 'o') ADVANCE(1388);
      if (lookahead == 'y') ADVANCE(152);
      END_STATE();
    case 615:
      if (lookahead == 'a') ADVANCE(1803);
      if (lookahead == 'i') ADVANCE(1780);
      if (lookahead == 'y') ADVANCE(152);
      END_STATE();
    case 616:
      if (lookahead == 'a') ADVANCE(1803);
      if (lookahead == 'y') ADVANCE(152);
      END_STATE();
    case 617:
      if (lookahead == 'a') ADVANCE(1510);
      if (lookahead == 'u') ADVANCE(1908);
      END_STATE();
    case 618:
      if (lookahead == 'a') ADVANCE(776);
      if (lookahead == 'k') ADVANCE(930);
      END_STATE();
    case 619:
      if (lookahead == 'a') ADVANCE(1699);
      if (lookahead == 'u') ADVANCE(1699);
      END_STATE();
    case 620:
      if (lookahead == 'a') ADVANCE(887);
      END_STATE();
    case 621:
      if (lookahead == 'a') ADVANCE(1375);
      END_STATE();
    case 622:
      if (lookahead == 'a') ADVANCE(1375);
      if (lookahead == 'i') ADVANCE(1420);
      END_STATE();
    case 623:
      if (lookahead == 'a') ADVANCE(1759);
      END_STATE();
    case 624:
      if (lookahead == 'a') ADVANCE(1759);
      if (lookahead == 'b') ADVANCE(1389);
      END_STATE();
    case 625:
      if (lookahead == 'a') ADVANCE(1394);
      END_STATE();
    case 626:
      if (lookahead == 'a') ADVANCE(1394);
      if (lookahead == 'e') ADVANCE(1914);
      if (lookahead == 'i') ADVANCE(2110);
      END_STATE();
    case 627:
      if (lookahead == 'a') ADVANCE(1794);
      if (lookahead == 'l') ADVANCE(2065);
      if (lookahead == 's') ADVANCE(1230);
      END_STATE();
    case 628:
      if (lookahead == 'a') ADVANCE(777);
      END_STATE();
    case 629:
      if (lookahead == 'a') ADVANCE(1789);
      if (lookahead == 'b') ADVANCE(1389);
      END_STATE();
    case 630:
      if (lookahead == 'a') ADVANCE(1789);
      if (lookahead == 'o') ADVANCE(358);
      END_STATE();
    case 631:
      if (lookahead == 'a') ADVANCE(1721);
      END_STATE();
    case 632:
      if (lookahead == 'a') ADVANCE(862);
      END_STATE();
    case 633:
      if (lookahead == 'a') ADVANCE(1787);
      END_STATE();
    case 634:
      if (lookahead == 'a') ADVANCE(1387);
      END_STATE();
    case 635:
      if (lookahead == 'a') ADVANCE(1779);
      if (lookahead == 'o') ADVANCE(1454);
      if (lookahead == 'r') ADVANCE(237);
      END_STATE();
    case 636:
      if (lookahead == 'a') ADVANCE(1385);
      END_STATE();
    case 637:
      if (lookahead == 'a') ADVANCE(1774);
      if (lookahead == 'p') ADVANCE(1673);
      END_STATE();
    case 638:
      if (lookahead == 'a') ADVANCE(1760);
      if (lookahead == 'r') ADVANCE(709);
      END_STATE();
    case 639:
      if (lookahead == 'a') ADVANCE(1365);
      END_STATE();
    case 640:
      if (lookahead == 'a') ADVANCE(1773);
      END_STATE();
    case 641:
      if (lookahead == 'a') ADVANCE(1373);
      END_STATE();
    case 642:
      if (lookahead == 'a') ADVANCE(1360);
      END_STATE();
    case 643:
      if (lookahead == 'a') ADVANCE(1366);
      END_STATE();
    case 644:
      if (lookahead == 'a') ADVANCE(1361);
      END_STATE();
    case 645:
      if (lookahead == 'a') ADVANCE(1827);
      END_STATE();
    case 646:
      if (lookahead == 'a') ADVANCE(1379);
      END_STATE();
    case 647:
      if (lookahead == 'a') ADVANCE(1367);
      END_STATE();
    case 648:
      if (lookahead == 'a') ADVANCE(1748);
      END_STATE();
    case 649:
      if (lookahead == 'a') ADVANCE(1777);
      END_STATE();
    case 650:
      if (lookahead == 'a') ADVANCE(1753);
      END_STATE();
    case 651:
      if (lookahead == 'a') ADVANCE(1831);
      END_STATE();
    case 652:
      if (lookahead == 'a') ADVANCE(1775);
      END_STATE();
    case 653:
      if (lookahead == 'a') ADVANCE(2015);
      END_STATE();
    case 654:
      if (lookahead == 'a') ADVANCE(1842);
      END_STATE();
    case 655:
      if (lookahead == 'a') ADVANCE(1815);
      END_STATE();
    case 656:
      if (lookahead == 'a') ADVANCE(1806);
      END_STATE();
    case 657:
      if (lookahead == 'a') ADVANCE(1812);
      END_STATE();
    case 658:
      ADVANCE_MAP(
        'a', 818,
        'b', 1739,
        'c', 198,
        'd', 1627,
        'e', 405,
        'f', 1770,
        'h', 213,
        'i', 1159,
        'l', 583,
        'm', 539,
        'o', 1104,
        'p', 562,
        'q', 806,
        'r', 583,
        's', 781,
        't', 638,
        'u', 721,
        'w', 406,
        'z', 1398,
      );
      END_STATE();
    case 659:
      ADVANCE_MAP(
        'a', 818,
        'c', 616,
        'd', 1598,
        'e', 1063,
        'f', 1750,
        'h', 754,
        'i', 1153,
        'o', 1680,
        's', 778,
        'w', 1338,
      );
      END_STATE();
    case 660:
      if (lookahead == 'a') ADVANCE(1410);
      END_STATE();
    case 661:
      if (lookahead == 'a') ADVANCE(1479);
      END_STATE();
    case 662:
      if (lookahead == 'a') ADVANCE(1936);
      END_STATE();
    case 663:
      ADVANCE_MAP(
        'a', 1705,
        'c', 981,
        'f', 1750,
        'g', 1814,
        'h', 754,
        'j', 754,
        'o', 1680,
        's', 778,
      );
      END_STATE();
    case 664:
      if (lookahead == 'a') ADVANCE(856);
      END_STATE();
    case 665:
      if (lookahead == 'a') ADVANCE(903);
      if (lookahead == 'i') ADVANCE(710);
      if (lookahead == 'p') ADVANCE(965);
      END_STATE();
    case 666:
      if (lookahead == 'a') ADVANCE(1863);
      END_STATE();
    case 667:
      if (lookahead == 'a') ADVANCE(2012);
      END_STATE();
    case 668:
      if (lookahead == 'a') ADVANCE(1830);
      END_STATE();
    case 669:
      if (lookahead == 'a') ADVANCE(1712);
      if (lookahead == 'd') ADVANCE(1598);
      if (lookahead == 'e') ADVANCE(1735);
      if (lookahead == 'g') ADVANCE(1978);
      if (lookahead == 's') ADVANCE(1255);
      END_STATE();
    case 670:
      if (lookahead == 'a') ADVANCE(1712);
      if (lookahead == 'e') ADVANCE(1738);
      if (lookahead == 's') ADVANCE(1255);
      END_STATE();
    case 671:
      if (lookahead == 'a') ADVANCE(1712);
      if (lookahead == 's') ADVANCE(1255);
      END_STATE();
    case 672:
      if (lookahead == 'a') ADVANCE(842);
      END_STATE();
    case 673:
      if (lookahead == 'a') ADVANCE(1864);
      if (lookahead == 'l') ADVANCE(2141);
      if (lookahead == 'r') ADVANCE(934);
      if (lookahead == 'v') ADVANCE(1083);
      END_STATE();
    case 674:
      if (lookahead == 'a') ADVANCE(1549);
      END_STATE();
    case 675:
      if (lookahead == 'a') ADVANCE(1400);
      if (lookahead == 'k') ADVANCE(358);
      END_STATE();
    case 676:
      if (lookahead == 'a') ADVANCE(2022);
      END_STATE();
    case 677:
      if (lookahead == 'a') ADVANCE(1876);
      if (lookahead == 'l') ADVANCE(1415);
      if (lookahead == 'r') ADVANCE(826);
      END_STATE();
    case 678:
      if (lookahead == 'a') ADVANCE(1826);
      END_STATE();
    case 679:
      if (lookahead == 'a') ADVANCE(1263);
      END_STATE();
    case 680:
      if (lookahead == 'a') ADVANCE(1263);
      if (lookahead == 'i') ADVANCE(1600);
      END_STATE();
    case 681:
      if (lookahead == 'a') ADVANCE(2076);
      END_STATE();
    case 682:
      if (lookahead == 'a') ADVANCE(1422);
      END_STATE();
    case 683:
      if (lookahead == 'a') ADVANCE(1867);
      END_STATE();
    case 684:
      if (lookahead == 'a') ADVANCE(2078);
      END_STATE();
    case 685:
      if (lookahead == 'a') ADVANCE(2030);
      END_STATE();
    case 686:
      if (lookahead == 'a') ADVANCE(1550);
      END_STATE();
    case 687:
      if (lookahead == 'a') ADVANCE(1869);
      END_STATE();
    case 688:
      if (lookahead == 'a') ADVANCE(1407);
      END_STATE();
    case 689:
      if (lookahead == 'a') ADVANCE(1859);
      END_STATE();
    case 690:
      if (lookahead == 'a') ADVANCE(1818);
      END_STATE();
    case 691:
      if (lookahead == 'a') ADVANCE(1865);
      END_STATE();
    case 692:
      if (lookahead == 'a') ADVANCE(1866);
      END_STATE();
    case 693:
      if (lookahead == 'a') ADVANCE(1457);
      END_STATE();
    case 694:
      if (lookahead == 'a') ADVANCE(1881);
      END_STATE();
    case 695:
      if (lookahead == 'a') ADVANCE(1881);
      if (lookahead == 'd') ADVANCE(1659);
      if (lookahead == 'h') ADVANCE(651);
      if (lookahead == 'l') ADVANCE(2065);
      if (lookahead == 's') ADVANCE(1232);
      if (lookahead == 'u') ADVANCE(1731);
      END_STATE();
    case 696:
      if (lookahead == 'a') ADVANCE(1881);
      if (lookahead == 'd') ADVANCE(1675);
      if (lookahead == 'h') ADVANCE(651);
      END_STATE();
    case 697:
      if (lookahead == 'a') ADVANCE(1881);
      if (lookahead == 'r') ADVANCE(1317);
      END_STATE();
    case 698:
      if (lookahead == 'a') ADVANCE(1892);
      END_STATE();
    case 699:
      if (lookahead == 'a') ADVANCE(2038);
      END_STATE();
    case 700:
      if (lookahead == 'a') ADVANCE(1886);
      if (lookahead == 'h') ADVANCE(711);
      if (lookahead == 'l') ADVANCE(1075);
      if (lookahead == 'r') ADVANCE(1332);
      if (lookahead == 's') ADVANCE(1742);
      if (lookahead == 't') ADVANCE(1220);
      END_STATE();
    case 701:
      if (lookahead == 'a') ADVANCE(1886);
      if (lookahead == 'h') ADVANCE(711);
      if (lookahead == 'l') ADVANCE(1095);
      if (lookahead == 'r') ADVANCE(1326);
      if (lookahead == 't') ADVANCE(1220);
      END_STATE();
    case 702:
      if (lookahead == 'a') ADVANCE(2040);
      END_STATE();
    case 703:
      if (lookahead == 'a') ADVANCE(1887);
      END_STATE();
    case 704:
      if (lookahead == 'a') ADVANCE(1887);
      if (lookahead == 'd') ADVANCE(597);
      END_STATE();
    case 705:
      if (lookahead == 'a') ADVANCE(1888);
      END_STATE();
    case 706:
      if (lookahead == 'a') ADVANCE(1888);
      if (lookahead == 'h') ADVANCE(713);
      END_STATE();
    case 707:
      if (lookahead == 'a') ADVANCE(2042);
      END_STATE();
    case 708:
      if (lookahead == 'a') ADVANCE(1889);
      if (lookahead == 'h') ADVANCE(713);
      if (lookahead == 's') ADVANCE(1742);
      END_STATE();
    case 709:
      if (lookahead == 'a') ADVANCE(1322);
      if (lookahead == 'n') ADVANCE(1903);
      END_STATE();
    case 710:
      if (lookahead == 'a') ADVANCE(1571);
      if (lookahead == 'd') ADVANCE(1598);
      if (lookahead == 'e') ADVANCE(152);
      if (lookahead == 'm') ADVANCE(1315);
      if (lookahead == 'p') ADVANCE(1448);
      if (lookahead == 's') ADVANCE(718);
      if (lookahead == 't') ADVANCE(1300);
      END_STATE();
    case 711:
      if (lookahead == 'a') ADVANCE(1894);
      END_STATE();
    case 712:
      if (lookahead == 'a') ADVANCE(1578);
      END_STATE();
    case 713:
      if (lookahead == 'a') ADVANCE(1896);
      END_STATE();
    case 714:
      if (lookahead == 'a') ADVANCE(1579);
      END_STATE();
    case 715:
      if (lookahead == 'a') ADVANCE(1581);
      END_STATE();
    case 716:
      if (lookahead == 'a') ADVANCE(1582);
      END_STATE();
    case 717:
      if (lookahead == 'a') ADVANCE(1583);
      END_STATE();
    case 718:
      if (lookahead == 'b') ADVANCE(152);
      END_STATE();
    case 719:
      if (lookahead == 'b') ADVANCE(152);
      if (lookahead == 'u') ADVANCE(1589);
      END_STATE();
    case 720:
      if (lookahead == 'b') ADVANCE(343);
      if (lookahead == 'c') ADVANCE(864);
      if (lookahead == 'm') ADVANCE(152);
      if (lookahead == 'p') ADVANCE(270);
      END_STATE();
    case 721:
      if (lookahead == 'b') ADVANCE(169);
      if (lookahead == 'c') ADVANCE(775);
      if (lookahead == 'm') ADVANCE(152);
      if (lookahead == 'n') ADVANCE(1120);
      if (lookahead == 'p') ADVANCE(245);
      END_STATE();
    case 722:
      if (lookahead == 'b') ADVANCE(344);
      if (lookahead == 'c') ADVANCE(831);
      if (lookahead == 'p') ADVANCE(344);
      END_STATE();
    case 723:
      if (lookahead == 'b') ADVANCE(243);
      END_STATE();
    case 724:
      if (lookahead == 'b') ADVANCE(252);
      if (lookahead == 'p') ADVANCE(252);
      END_STATE();
    case 725:
      if (lookahead == 'b') ADVANCE(546);
      END_STATE();
    case 726:
      if (lookahead == 'b') ADVANCE(546);
      if (lookahead == 'g') ADVANCE(969);
      END_STATE();
    case 727:
      if (lookahead == 'b') ADVANCE(546);
      if (lookahead == 'm') ADVANCE(152);
      END_STATE();
    case 728:
      if (lookahead == 'b') ADVANCE(546);
      if (lookahead == 't') ADVANCE(152);
      END_STATE();
    case 729:
      if (lookahead == 'b') ADVANCE(546);
      if (lookahead == 't') ADVANCE(293);
      if (lookahead == 'y') ADVANCE(519);
      END_STATE();
    case 730:
      if (lookahead == 'b') ADVANCE(1354);
      if (lookahead == 'c') ADVANCE(1648);
      END_STATE();
    case 731:
      if (lookahead == 'b') ADVANCE(250);
      if (lookahead == 'p') ADVANCE(250);
      END_STATE();
    case 732:
      if (lookahead == 'b') ADVANCE(2094);
      if (lookahead == 'p') ADVANCE(1215);
      END_STATE();
    case 733:
      if (lookahead == 'b') ADVANCE(891);
      END_STATE();
    case 734:
      if (lookahead == 'b') ADVANCE(1804);
      END_STATE();
    case 735:
      if (lookahead == 'b') ADVANCE(926);
      if (lookahead == 'p') ADVANCE(926);
      END_STATE();
    case 736:
      if (lookahead == 'b') ADVANCE(1368);
      if (lookahead == 'c') ADVANCE(2095);
      if (lookahead == 'n') ADVANCE(1120);
      if (lookahead == 'p') ADVANCE(172);
      if (lookahead == 't') ADVANCE(2084);
      END_STATE();
    case 737:
      if (lookahead == 'b') ADVANCE(1909);
      END_STATE();
    case 738:
      if (lookahead == 'b') ADVANCE(533);
      END_STATE();
    case 739:
      if (lookahead == 'b') ADVANCE(1078);
      END_STATE();
    case 740:
      if (lookahead == 'b') ADVANCE(1511);
      if (lookahead == 'p') ADVANCE(1511);
      END_STATE();
    case 741:
      if (lookahead == 'b') ADVANCE(1953);
      if (lookahead == 'c') ADVANCE(863);
      if (lookahead == 'p') ADVANCE(1030);
      END_STATE();
    case 742:
      if (lookahead == 'b') ADVANCE(1953);
      if (lookahead == 'p') ADVANCE(1030);
      END_STATE();
    case 743:
      if (lookahead == 'b') ADVANCE(1424);
      END_STATE();
    case 744:
      if (lookahead == 'b') ADVANCE(1427);
      END_STATE();
    case 745:
      if (lookahead == 'b') ADVANCE(1870);
      END_STATE();
    case 746:
      if (lookahead == 'b') ADVANCE(1430);
      END_STATE();
    case 747:
      if (lookahead == 'b') ADVANCE(1431);
      END_STATE();
    case 748:
      if (lookahead == 'b') ADVANCE(1445);
      END_STATE();
    case 749:
      if (lookahead == 'b') ADVANCE(657);
      END_STATE();
    case 750:
      if (lookahead == 'b') ADVANCE(1436);
      END_STATE();
    case 751:
      if (lookahead == 'b') ADVANCE(1437);
      END_STATE();
    case 752:
      if (lookahead == 'b') ADVANCE(1438);
      END_STATE();
    case 753:
      if (lookahead == 'b') ADVANCE(1956);
      if (lookahead == 'p') ADVANCE(1956);
      END_STATE();
    case 754:
      if (lookahead == 'c') ADVANCE(2139);
      END_STATE();
    case 755:
      if (lookahead == 'c') ADVANCE(2139);
      if (lookahead == 'e') ADVANCE(2113);
      END_STATE();
    case 756:
      if (lookahead == 'c') ADVANCE(2139);
      if (lookahead == 'e') ADVANCE(836);
      if (lookahead == 'i') ADVANCE(152);
      END_STATE();
    case 757:
      if (lookahead == 'c') ADVANCE(2139);
      if (lookahead == 'f') ADVANCE(1750);
      if (lookahead == 'i') ADVANCE(1449);
      if (lookahead == 'o') ADVANCE(1682);
      if (lookahead == 's') ADVANCE(778);
      END_STATE();
    case 758:
      if (lookahead == 'c') ADVANCE(2139);
      if (lookahead == 'g') ADVANCE(1629);
      if (lookahead == 'p') ADVANCE(1096);
      if (lookahead == 't') ADVANCE(532);
      END_STATE();
    case 759:
      if (lookahead == 'c') ADVANCE(2139);
      if (lookahead == 'i') ADVANCE(1153);
      END_STATE();
    case 760:
      if (lookahead == 'c') ADVANCE(2139);
      if (lookahead == 'm') ADVANCE(297);
      END_STATE();
    case 761:
      if (lookahead == 'c') ADVANCE(2139);
      if (lookahead == 'x') ADVANCE(765);
      END_STATE();
    case 762:
      if (lookahead == 'c') ADVANCE(152);
      END_STATE();
    case 763:
      if (lookahead == 'c') ADVANCE(152);
      if (lookahead == 'i') ADVANCE(1750);
      END_STATE();
    case 764:
      if (lookahead == 'c') ADVANCE(330);
      if (lookahead == 'l') ADVANCE(931);
      if (lookahead == 'p') ADVANCE(341);
      if (lookahead == 'r') ADVANCE(1351);
      END_STATE();
    case 765:
      if (lookahead == 'c') ADVANCE(297);
      END_STATE();
    case 766:
      ADVANCE_MAP(
        'c', 574,
        'd', 2016,
        'f', 1750,
        'h', 403,
        'i', 152,
        'l', 403,
        'm', 572,
        'n', 1259,
        'o', 878,
        'r', 403,
        's', 795,
        'u', 1709,
        'v', 1003,
        'w', 966,
      );
      END_STATE();
    case 767:
      if (lookahead == 'c') ADVANCE(574);
      if (lookahead == 'o') ADVANCE(879);
      if (lookahead == 's') ADVANCE(1744);
      if (lookahead == 't') ADVANCE(1900);
      if (lookahead == 'u') ADVANCE(1708);
      if (lookahead == 'v') ADVANCE(1003);
      if (lookahead == 'w') ADVANCE(966);
      END_STATE();
    case 768:
      if (lookahead == 'c') ADVANCE(1648);
      END_STATE();
    case 769:
      if (lookahead == 'c') ADVANCE(2170);
      if (lookahead == 'h') ADVANCE(754);
      if (lookahead == 't') ADVANCE(1821);
      END_STATE();
    case 770:
      if (lookahead == 'c') ADVANCE(2170);
      if (lookahead == 'o') ADVANCE(1358);
      if (lookahead == 't') ADVANCE(1821);
      END_STATE();
    case 771:
      if (lookahead == 'c') ADVANCE(238);
      if (lookahead == 'h') ADVANCE(1666);
      if (lookahead == 'i') ADVANCE(1480);
      if (lookahead == 'm') ADVANCE(1222);
      if (lookahead == 'p') ADVANCE(546);
      if (lookahead == 'q') ADVANCE(1937);
      if (lookahead == 'u') ADVANCE(722);
      END_STATE();
    case 772:
      if (lookahead == 'c') ADVANCE(932);
      if (lookahead == 'd') ADVANCE(1269);
      if (lookahead == 'e') ADVANCE(1481);
      if (lookahead == 'n') ADVANCE(1130);
      if (lookahead == 'q') ADVANCE(2054);
      if (lookahead == 'r') ADVANCE(1763);
      if (lookahead == 't') ADVANCE(680);
      END_STATE();
    case 773:
      if (lookahead == 'c') ADVANCE(2063);
      END_STATE();
    case 774:
      if (lookahead == 'c') ADVANCE(146);
      if (lookahead == 's') ADVANCE(1358);
      END_STATE();
    case 775:
      if (lookahead == 'c') ADVANCE(216);
      END_STATE();
    case 776:
      if (lookahead == 'c') ADVANCE(2165);
      END_STATE();
    case 777:
      if (lookahead == 'c') ADVANCE(927);
      END_STATE();
    case 778:
      if (lookahead == 'c') ADVANCE(1750);
      END_STATE();
    case 779:
      if (lookahead == 'c') ADVANCE(1750);
      if (lookahead == 'd') ADVANCE(1598);
      if (lookahead == 'i') ADVANCE(1463);
      END_STATE();
    case 780:
      if (lookahead == 'c') ADVANCE(1750);
      if (lookahead == 'e') ADVANCE(1472);
      if (lookahead == 'i') ADVANCE(1473);
      if (lookahead == 'o') ADVANCE(1362);
      END_STATE();
    case 781:
      if (lookahead == 'c') ADVANCE(1750);
      if (lookahead == 'e') ADVANCE(2006);
      if (lookahead == 'm') ADVANCE(1312);
      if (lookahead == 't') ADVANCE(650);
      END_STATE();
    case 782:
      if (lookahead == 'c') ADVANCE(1750);
      if (lookahead == 'e') ADVANCE(1783);
      END_STATE();
    case 783:
      if (lookahead == 'c') ADVANCE(1750);
      if (lookahead == 'g') ADVANCE(928);
      if (lookahead == 't') ADVANCE(1183);
      END_STATE();
    case 784:
      if (lookahead == 'c') ADVANCE(1750);
      if (lookahead == 'g') ADVANCE(1282);
      END_STATE();
    case 785:
      if (lookahead == 'c') ADVANCE(1750);
      if (lookahead == 'h') ADVANCE(152);
      END_STATE();
    case 786:
      if (lookahead == 'c') ADVANCE(1750);
      if (lookahead == 'h') ADVANCE(152);
      if (lookahead == 't') ADVANCE(1821);
      END_STATE();
    case 787:
      if (lookahead == 'c') ADVANCE(1750);
      if (lookahead == 'i') ADVANCE(152);
      END_STATE();
    case 788:
      if (lookahead == 'c') ADVANCE(1750);
      if (lookahead == 'i') ADVANCE(1463);
      END_STATE();
    case 789:
      if (lookahead == 'c') ADVANCE(1750);
      if (lookahead == 'i') ADVANCE(1468);
      END_STATE();
    case 790:
      if (lookahead == 'c') ADVANCE(1750);
      if (lookahead == 'i') ADVANCE(1509);
      END_STATE();
    case 791:
      if (lookahead == 'c') ADVANCE(1750);
      if (lookahead == 'l') ADVANCE(579);
      if (lookahead == 't') ADVANCE(1821);
      END_STATE();
    case 792:
      if (lookahead == 'c') ADVANCE(1750);
      if (lookahead == 'l') ADVANCE(1120);
      END_STATE();
    case 793:
      if (lookahead == 'c') ADVANCE(1750);
      if (lookahead == 'l') ADVANCE(607);
      END_STATE();
    case 794:
      if (lookahead == 'c') ADVANCE(1750);
      if (lookahead == 'l') ADVANCE(607);
      if (lookahead == 'o') ADVANCE(1358);
      END_STATE();
    case 795:
      if (lookahead == 'c') ADVANCE(1750);
      if (lookahead == 'q') ADVANCE(847);
      END_STATE();
    case 796:
      if (lookahead == 'c') ADVANCE(1750);
      if (lookahead == 's') ADVANCE(1265);
      END_STATE();
    case 797:
      if (lookahead == 'c') ADVANCE(1750);
      if (lookahead == 't') ADVANCE(152);
      if (lookahead == 'y') ADVANCE(1488);
      END_STATE();
    case 798:
      if (lookahead == 'c') ADVANCE(1750);
      if (lookahead == 't') ADVANCE(1718);
      END_STATE();
    case 799:
      if (lookahead == 'c') ADVANCE(1750);
      if (lookahead == 't') ADVANCE(1821);
      END_STATE();
    case 800:
      if (lookahead == 'c') ADVANCE(1750);
      if (lookahead == 'u') ADVANCE(731);
      END_STATE();
    case 801:
      if (lookahead == 'c') ADVANCE(1750);
      if (lookahead == 'u') ADVANCE(740);
      END_STATE();
    case 802:
      if (lookahead == 'c') ADVANCE(532);
      if (lookahead == 'l') ADVANCE(912);
      if (lookahead == 'q') ADVANCE(2074);
      if (lookahead == 's') ADVANCE(1183);
      END_STATE();
    case 803:
      if (lookahead == 'c') ADVANCE(532);
      if (lookahead == 'q') ADVANCE(2074);
      if (lookahead == 'r') ADVANCE(913);
      if (lookahead == 's') ADVANCE(1183);
      END_STATE();
    case 804:
      if (lookahead == 'c') ADVANCE(1350);
      if (lookahead == 'r') ADVANCE(2109);
      END_STATE();
    case 805:
      if (lookahead == 'c') ADVANCE(1516);
      if (lookahead == 'i') ADVANCE(1587);
      if (lookahead == 'm') ADVANCE(1263);
      if (lookahead == 'p') ADVANCE(152);
      if (lookahead == 't') ADVANCE(1019);
      END_STATE();
    case 806:
      if (lookahead == 'c') ADVANCE(619);
      if (lookahead == 's') ADVANCE(2055);
      if (lookahead == 'u') ADVANCE(215);
      END_STATE();
    case 807:
      if (lookahead == 'c') ADVANCE(1958);
      END_STATE();
    case 808:
      if (lookahead == 'c') ADVANCE(1341);
      if (lookahead == 'r') ADVANCE(2112);
      END_STATE();
    case 809:
      if (lookahead == 'c') ADVANCE(1290);
      if (lookahead == 's') ADVANCE(1257);
      if (lookahead == 'u') ADVANCE(626);
      if (lookahead == 'v') ADVANCE(1725);
      END_STATE();
    case 810:
      if (lookahead == 'c') ADVANCE(1289);
      if (lookahead == 'e') ADVANCE(886);
      if (lookahead == 'f') ADVANCE(1750);
      if (lookahead == 'o') ADVANCE(1680);
      if (lookahead == 'p') ADVANCE(152);
      if (lookahead == 'r') ADVANCE(266);
      if (lookahead == 's') ADVANCE(778);
      END_STATE();
    case 811:
      if (lookahead == 'c') ADVANCE(1289);
      if (lookahead == 'e') ADVANCE(915);
      if (lookahead == 'f') ADVANCE(1750);
      if (lookahead == 'o') ADVANCE(1680);
      if (lookahead == 's') ADVANCE(778);
      END_STATE();
    case 812:
      if (lookahead == 'c') ADVANCE(2062);
      END_STATE();
    case 813:
      if (lookahead == 'c') ADVANCE(2062);
      if (lookahead == 'r') ADVANCE(1750);
      END_STATE();
    case 814:
      if (lookahead == 'c') ADVANCE(2062);
      if (lookahead == 'r') ADVANCE(1786);
      END_STATE();
    case 815:
      if (lookahead == 'c') ADVANCE(2062);
      if (lookahead == 's') ADVANCE(1958);
      END_STATE();
    case 816:
      if (lookahead == 'c') ADVANCE(2062);
      if (lookahead == 's') ADVANCE(2012);
      END_STATE();
    case 817:
      if (lookahead == 'c') ADVANCE(1677);
      if (lookahead == 'd') ADVANCE(1750);
      END_STATE();
    case 818:
      if (lookahead == 'c') ADVANCE(2095);
      END_STATE();
    case 819:
      ADVANCE_MAP(
        'c', 2095,
        'e', 1481,
        'g', 1868,
        'm', 733,
        'n', 1128,
        'p', 152,
        'q', 2054,
        'r', 1761,
        't', 217,
      );
      END_STATE();
    case 820:
      if (lookahead == 'c') ADVANCE(2095);
      if (lookahead == 'm') ADVANCE(733);
      if (lookahead == 'n') ADVANCE(1120);
      if (lookahead == 'p') ADVANCE(1447);
      if (lookahead == 'r') ADVANCE(1750);
      END_STATE();
    case 821:
      if (lookahead == 'c') ADVANCE(2095);
      if (lookahead == 'm') ADVANCE(1491);
      if (lookahead == 'p') ADVANCE(152);
      END_STATE();
    case 822:
      if (lookahead == 'c') ADVANCE(2095);
      if (lookahead == 'n') ADVANCE(1120);
      if (lookahead == 'r') ADVANCE(1796);
      END_STATE();
    case 823:
      if (lookahead == 'c') ADVANCE(2095);
      if (lookahead == 'p') ADVANCE(210);
      if (lookahead == 'r') ADVANCE(962);
      END_STATE();
    case 824:
      if (lookahead == 'c') ADVANCE(2095);
      if (lookahead == 'p') ADVANCE(292);
      if (lookahead == 'y') ADVANCE(1408);
      END_STATE();
    case 825:
      if (lookahead == 'c') ADVANCE(989);
      if (lookahead == 't') ADVANCE(152);
      END_STATE();
    case 826:
      if (lookahead == 'c') ADVANCE(1629);
      END_STATE();
    case 827:
      if (lookahead == 'c') ADVANCE(1339);
      END_STATE();
    case 828:
      if (lookahead == 'c') ADVANCE(1348);
      END_STATE();
    case 829:
      if (lookahead == 'c') ADVANCE(1348);
      if (lookahead == 's') ADVANCE(963);
      END_STATE();
    case 830:
      if (lookahead == 'c') ADVANCE(1340);
      if (lookahead == 'n') ADVANCE(514);
      END_STATE();
    case 831:
      if (lookahead == 'c') ADVANCE(259);
      END_STATE();
    case 832:
      if (lookahead == 'c') ADVANCE(1216);
      END_STATE();
    case 833:
      if (lookahead == 'c') ADVANCE(1609);
      if (lookahead == 'i') ADVANCE(1516);
      END_STATE();
    case 834:
      if (lookahead == 'c') ADVANCE(1343);
      if (lookahead == 'n') ADVANCE(1339);
      END_STATE();
    case 835:
      if (lookahead == 'c') ADVANCE(572);
      END_STATE();
    case 836:
      if (lookahead == 'c') ADVANCE(1344);
      END_STATE();
    case 837:
      if (lookahead == 'c') ADVANCE(1358);
      if (lookahead == 'i') ADVANCE(1914);
      if (lookahead == 'p') ADVANCE(1058);
      END_STATE();
    case 838:
      if (lookahead == 'c') ADVANCE(1353);
      if (lookahead == 'n') ADVANCE(1923);
      END_STATE();
    case 839:
      if (lookahead == 'c') ADVANCE(681);
      if (lookahead == 'r') ADVANCE(1541);
      if (lookahead == 't') ADVANCE(532);
      END_STATE();
    case 840:
      if (lookahead == 'c') ADVANCE(1345);
      if (lookahead == 'k') ADVANCE(2108);
      END_STATE();
    case 841:
      if (lookahead == 'c') ADVANCE(762);
      END_STATE();
    case 842:
      if (lookahead == 'c') ADVANCE(926);
      END_STATE();
    case 843:
      if (lookahead == 'c') ADVANCE(1197);
      END_STATE();
    case 844:
      if (lookahead == 'c') ADVANCE(1803);
      END_STATE();
    case 845:
      if (lookahead == 'c') ADVANCE(1803);
      if (lookahead == 'd') ADVANCE(152);
      if (lookahead == 'n') ADVANCE(2065);
      END_STATE();
    case 846:
      if (lookahead == 'c') ADVANCE(1923);
      END_STATE();
    case 847:
      if (lookahead == 'c') ADVANCE(2058);
      END_STATE();
    case 848:
      if (lookahead == 'c') ADVANCE(1957);
      END_STATE();
    case 849:
      if (lookahead == 'c') ADVANCE(600);
      END_STATE();
    case 850:
      if (lookahead == 'c') ADVANCE(1233);
      END_STATE();
    case 851:
      if (lookahead == 'c') ADVANCE(1233);
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 852:
      if (lookahead == 'c') ADVANCE(1066);
      END_STATE();
    case 853:
      if (lookahead == 'c') ADVANCE(1792);
      if (lookahead == 'd') ADVANCE(206);
      if (lookahead == 'n') ADVANCE(2073);
      END_STATE();
    case 854:
      if (lookahead == 'c') ADVANCE(2044);
      END_STATE();
    case 855:
      if (lookahead == 'c') ADVANCE(2031);
      END_STATE();
    case 856:
      if (lookahead == 'c') ADVANCE(1062);
      END_STATE();
    case 857:
      if (lookahead == 'c') ADVANCE(2015);
      END_STATE();
    case 858:
      if (lookahead == 'c') ADVANCE(1291);
      if (lookahead == 'f') ADVANCE(1750);
      if (lookahead == 'm') ADVANCE(599);
      if (lookahead == 'o') ADVANCE(1680);
      if (lookahead == 's') ADVANCE(782);
      if (lookahead == 'u') ADVANCE(1346);
      END_STATE();
    case 859:
      if (lookahead == 'c') ADVANCE(1291);
      if (lookahead == 'f') ADVANCE(1750);
      if (lookahead == 'o') ADVANCE(1680);
      if (lookahead == 's') ADVANCE(782);
      if (lookahead == 'u') ADVANCE(1346);
      END_STATE();
    case 860:
      if (lookahead == 'c') ADVANCE(1650);
      if (lookahead == 'i') ADVANCE(1525);
      if (lookahead == 't') ADVANCE(1785);
      END_STATE();
    case 861:
      if (lookahead == 'c') ADVANCE(1650);
      if (lookahead == 't') ADVANCE(1785);
      END_STATE();
    case 862:
      if (lookahead == 'c') ADVANCE(1352);
      END_STATE();
    case 863:
      if (lookahead == 'c') ADVANCE(1032);
      END_STATE();
    case 864:
      if (lookahead == 'c') ADVANCE(1032);
      if (lookahead == 'h') ADVANCE(520);
      END_STATE();
    case 865:
      if (lookahead == 'c') ADVANCE(639);
      END_STATE();
    case 866:
      if (lookahead == 'c') ADVANCE(1423);
      END_STATE();
    case 867:
      if (lookahead == 'c') ADVANCE(1847);
      if (lookahead == 'm') ADVANCE(1635);
      END_STATE();
    case 868:
      if (lookahead == 'c') ADVANCE(643);
      END_STATE();
    case 869:
      if (lookahead == 'c') ADVANCE(2030);
      END_STATE();
    case 870:
      if (lookahead == 'c') ADVANCE(1618);
      if (lookahead == 'e') ADVANCE(1676);
      if (lookahead == 'p') ADVANCE(1820);
      if (lookahead == 's') ADVANCE(1275);
      END_STATE();
    case 871:
      if (lookahead == 'c') ADVANCE(1407);
      END_STATE();
    case 872:
      if (lookahead == 'c') ADVANCE(646);
      END_STATE();
    case 873:
      if (lookahead == 'c') ADVANCE(684);
      if (lookahead == 'm') ADVANCE(1711);
      if (lookahead == 'p') ADVANCE(1918);
      if (lookahead == 'r') ADVANCE(1564);
      if (lookahead == 't') ADVANCE(2126);
      END_STATE();
    case 874:
      if (lookahead == 'c') ADVANCE(691);
      END_STATE();
    case 875:
      if (lookahead == 'c') ADVANCE(1090);
      END_STATE();
    case 876:
      if (lookahead == 'd') ADVANCE(1598);
      END_STATE();
    case 877:
      if (lookahead == 'd') ADVANCE(1598);
      if (lookahead == 'i') ADVANCE(1440);
      if (lookahead == 'r') ADVANCE(1229);
      END_STATE();
    case 878:
      if (lookahead == 'd') ADVANCE(1598);
      if (lookahead == 'p') ADVANCE(1097);
      if (lookahead == 't') ADVANCE(1300);
      END_STATE();
    case 879:
      if (lookahead == 'd') ADVANCE(1598);
      if (lookahead == 'p') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(1304);
      END_STATE();
    case 880:
      if (lookahead == 'd') ADVANCE(1598);
      if (lookahead == 'r') ADVANCE(1229);
      END_STATE();
    case 881:
      if (lookahead == 'd') ADVANCE(152);
      END_STATE();
    case 882:
      if (lookahead == 'd') ADVANCE(152);
      if (lookahead == 'f') ADVANCE(605);
      if (lookahead == 'p') ADVANCE(348);
      END_STATE();
    case 883:
      if (lookahead == 'd') ADVANCE(152);
      if (lookahead == 'l') ADVANCE(926);
      END_STATE();
    case 884:
      if (lookahead == 'd') ADVANCE(152);
      if (lookahead == 'u') ADVANCE(297);
      END_STATE();
    case 885:
      if (lookahead == 'd') ADVANCE(211);
      if (lookahead == 'g') ADVANCE(251);
      END_STATE();
    case 886:
      if (lookahead == 'd') ADVANCE(726);
      if (lookahead == 'i') ADVANCE(1021);
      END_STATE();
    case 887:
      if (lookahead == 'd') ADVANCE(1444);
      END_STATE();
    case 888:
      if (lookahead == 'd') ADVANCE(513);
      END_STATE();
    case 889:
      if (lookahead == 'd') ADVANCE(489);
      END_STATE();
    case 890:
      if (lookahead == 'd') ADVANCE(479);
      END_STATE();
    case 891:
      if (lookahead == 'd') ADVANCE(532);
      END_STATE();
    case 892:
      if (lookahead == 'd') ADVANCE(754);
      if (lookahead == 'r') ADVANCE(236);
      END_STATE();
    case 893:
      if (lookahead == 'd') ADVANCE(283);
      END_STATE();
    case 894:
      if (lookahead == 'd') ADVANCE(194);
      END_STATE();
    case 895:
      if (lookahead == 'd') ADVANCE(1005);
      if (lookahead == 'i') ADVANCE(1633);
      END_STATE();
    case 896:
      if (lookahead == 'd') ADVANCE(250);
      END_STATE();
    case 897:
      if (lookahead == 'd') ADVANCE(579);
      END_STATE();
    case 898:
      if (lookahead == 'd') ADVANCE(598);
      END_STATE();
    case 899:
      if (lookahead == 'd') ADVANCE(345);
      END_STATE();
    case 900:
      if (lookahead == 'd') ADVANCE(263);
      END_STATE();
    case 901:
      if (lookahead == 'd') ADVANCE(1266);
      END_STATE();
    case 902:
      if (lookahead == 'd') ADVANCE(1266);
      if (lookahead == 'l') ADVANCE(1456);
      END_STATE();
    case 903:
      if (lookahead == 'd') ADVANCE(926);
      END_STATE();
    case 904:
      if (lookahead == 'd') ADVANCE(2070);
      END_STATE();
    case 905:
      if (lookahead == 'd') ADVANCE(2070);
      if (lookahead == 'p') ADVANCE(1672);
      END_STATE();
    case 906:
      if (lookahead == 'd') ADVANCE(1224);
      END_STATE();
    case 907:
      if (lookahead == 'd') ADVANCE(1224);
      if (lookahead == 'm') ADVANCE(1711);
      if (lookahead == 'n') ADVANCE(349);
      END_STATE();
    case 908:
      if (lookahead == 'd') ADVANCE(1949);
      if (lookahead == 'u') ADVANCE(1193);
      END_STATE();
    case 909:
      if (lookahead == 'd') ADVANCE(940);
      END_STATE();
    case 910:
      if (lookahead == 'd') ADVANCE(1912);
      END_STATE();
    case 911:
      if (lookahead == 'd') ADVANCE(2005);
      END_STATE();
    case 912:
      if (lookahead == 'd') ADVANCE(1193);
      END_STATE();
    case 913:
      if (lookahead == 'd') ADVANCE(1193);
      if (lookahead == 'u') ADVANCE(1949);
      END_STATE();
    case 914:
      if (lookahead == 'd') ADVANCE(1299);
      if (lookahead == 'n') ADVANCE(2034);
      END_STATE();
    case 915:
      if (lookahead == 'd') ADVANCE(1145);
      END_STATE();
    case 916:
      if (lookahead == 'd') ADVANCE(1591);
      if (lookahead == 'u') ADVANCE(1677);
      END_STATE();
    case 917:
      if (lookahead == 'd') ADVANCE(1010);
      if (lookahead == 'p') ADVANCE(1096);
      END_STATE();
    case 918:
      if (lookahead == 'd') ADVANCE(1006);
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 919:
      if (lookahead == 'd') ADVANCE(1023);
      END_STATE();
    case 920:
      if (lookahead == 'd') ADVANCE(1614);
      END_STATE();
    case 921:
      if (lookahead == 'd') ADVANCE(1263);
      END_STATE();
    case 922:
      if (lookahead == 'd') ADVANCE(1263);
      if (lookahead == 'i') ADVANCE(1358);
      END_STATE();
    case 923:
      if (lookahead == 'd') ADVANCE(1025);
      END_STATE();
    case 924:
      if (lookahead == 'd') ADVANCE(645);
      if (lookahead == 'e') ADVANCE(1693);
      if (lookahead == 'l') ADVANCE(666);
      if (lookahead == 'p') ADVANCE(226);
      if (lookahead == 'r') ADVANCE(673);
      if (lookahead == 'v') ADVANCE(1003);
      if (lookahead == 'w') ADVANCE(925);
      END_STATE();
    case 925:
      if (lookahead == 'e') ADVANCE(881);
      END_STATE();
    case 926:
      if (lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 927:
      if (lookahead == 'e') ADVANCE(152);
      if (lookahead == 'k') ADVANCE(961);
      END_STATE();
    case 928:
      if (lookahead == 'e') ADVANCE(152);
      if (lookahead == 'l') ADVANCE(1272);
      if (lookahead == 'p') ADVANCE(652);
      END_STATE();
    case 929:
      if (lookahead == 'e') ADVANCE(152);
      if (lookahead == 'r') ADVANCE(729);
      END_STATE();
    case 930:
      if (lookahead == 'e') ADVANCE(152);
      if (lookahead == 's') ADVANCE(1364);
      END_STATE();
    case 931:
      if (lookahead == 'e') ADVANCE(152);
      if (lookahead == 't') ADVANCE(268);
      END_STATE();
    case 932:
      if (lookahead == 'e') ADVANCE(152);
      if (lookahead == 'u') ADVANCE(2007);
      END_STATE();
    case 933:
      if (lookahead == 'e') ADVANCE(439);
      END_STATE();
    case 934:
      if (lookahead == 'e') ADVANCE(309);
      END_STATE();
    case 935:
      if (lookahead == 'e') ADVANCE(2113);
      END_STATE();
    case 936:
      if (lookahead == 'e') ADVANCE(2113);
      if (lookahead == 'v') ADVANCE(738);
      END_STATE();
    case 937:
      if (lookahead == 'e') ADVANCE(1105);
      if (lookahead == 'p') ADVANCE(1186);
      END_STATE();
    case 938:
      if (lookahead == 'e') ADVANCE(329);
      if (lookahead == 'o') ADVANCE(1958);
      END_STATE();
    case 939:
      if (lookahead == 'e') ADVANCE(225);
      if (lookahead == 'l') ADVANCE(1415);
      if (lookahead == 'r') ADVANCE(728);
      END_STATE();
    case 940:
      if (lookahead == 'e') ADVANCE(176);
      END_STATE();
    case 941:
      if (lookahead == 'e') ADVANCE(155);
      END_STATE();
    case 942:
      if (lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 943:
      if (lookahead == 'e') ADVANCE(440);
      END_STATE();
    case 944:
      if (lookahead == 'e') ADVANCE(438);
      END_STATE();
    case 945:
      if (lookahead == 'e') ADVANCE(182);
      END_STATE();
    case 946:
      if (lookahead == 'e') ADVANCE(704);
      END_STATE();
    case 947:
      if (lookahead == 'e') ADVANCE(1494);
      END_STATE();
    case 948:
      if (lookahead == 'e') ADVANCE(156);
      END_STATE();
    case 949:
      if (lookahead == 'e') ADVANCE(466);
      END_STATE();
    case 950:
      if (lookahead == 'e') ADVANCE(497);
      END_STATE();
    case 951:
      if (lookahead == 'e') ADVANCE(248);
      END_STATE();
    case 952:
      if (lookahead == 'e') ADVANCE(433);
      END_STATE();
    case 953:
      if (lookahead == 'e') ADVANCE(525);
      END_STATE();
    case 954:
      if (lookahead == 'e') ADVANCE(159);
      END_STATE();
    case 955:
      if (lookahead == 'e') ADVANCE(246);
      END_STATE();
    case 956:
      if (lookahead == 'e') ADVANCE(507);
      END_STATE();
    case 957:
      if (lookahead == 'e') ADVANCE(1750);
      END_STATE();
    case 958:
      if (lookahead == 'e') ADVANCE(532);
      if (lookahead == 'p') ADVANCE(219);
      if (lookahead == 's') ADVANCE(532);
      END_STATE();
    case 959:
      if (lookahead == 'e') ADVANCE(1516);
      END_STATE();
    case 960:
      if (lookahead == 'e') ADVANCE(1836);
      if (lookahead == 'i') ADVANCE(830);
      END_STATE();
    case 961:
      if (lookahead == 'e') ADVANCE(1958);
      END_STATE();
    case 962:
      if (lookahead == 'e') ADVANCE(1958);
      if (lookahead == 'o') ADVANCE(1504);
      END_STATE();
    case 963:
      if (lookahead == 'e') ADVANCE(436);
      END_STATE();
    case 964:
      if (lookahead == 'e') ADVANCE(427);
      END_STATE();
    case 965:
      if (lookahead == 'e') ADVANCE(2155);
      END_STATE();
    case 966:
      if (lookahead == 'e') ADVANCE(915);
      END_STATE();
    case 967:
      if (lookahead == 'e') ADVANCE(1852);
      if (lookahead == 'i') ADVANCE(838);
      if (lookahead == 'k') ADVANCE(575);
      if (lookahead == 'o') ADVANCE(1752);
      END_STATE();
    case 968:
      if (lookahead == 'e') ADVANCE(1106);
      END_STATE();
    case 969:
      if (lookahead == 'e') ADVANCE(325);
      END_STATE();
    case 970:
      if (lookahead == 'e') ADVANCE(468);
      END_STATE();
    case 971:
      if (lookahead == 'e') ADVANCE(515);
      END_STATE();
    case 972:
      if (lookahead == 'e') ADVANCE(1929);
      END_STATE();
    case 973:
      if (lookahead == 'e') ADVANCE(1732);
      END_STATE();
    case 974:
      if (lookahead == 'e') ADVANCE(916);
      END_STATE();
    case 975:
      if (lookahead == 'e') ADVANCE(546);
      END_STATE();
    case 976:
      if (lookahead == 'e') ADVANCE(546);
      if (lookahead == 'i') ADVANCE(1463);
      END_STATE();
    case 977:
      if (lookahead == 'e') ADVANCE(457);
      END_STATE();
    case 978:
      if (lookahead == 'e') ADVANCE(1110);
      END_STATE();
    case 979:
      if (lookahead == 'e') ADVANCE(334);
      END_STATE();
    case 980:
      if (lookahead == 'e') ADVANCE(921);
      if (lookahead == 'i') ADVANCE(1817);
      if (lookahead == 'y') ADVANCE(152);
      END_STATE();
    case 981:
      if (lookahead == 'e') ADVANCE(921);
      if (lookahead == 'y') ADVANCE(152);
      END_STATE();
    case 982:
      if (lookahead == 'e') ADVANCE(2151);
      END_STATE();
    case 983:
      if (lookahead == 'e') ADVANCE(412);
      END_STATE();
    case 984:
      if (lookahead == 'e') ADVANCE(1736);
      if (lookahead == 'v') ADVANCE(1003);
      if (lookahead == 'w') ADVANCE(966);
      END_STATE();
    case 985:
      if (lookahead == 'e') ADVANCE(437);
      END_STATE();
    case 986:
      if (lookahead == 'e') ADVANCE(1101);
      END_STATE();
    case 987:
      if (lookahead == 'e') ADVANCE(337);
      END_STATE();
    case 988:
      if (lookahead == 'e') ADVANCE(1738);
      END_STATE();
    case 989:
      if (lookahead == 'e') ADVANCE(1339);
      END_STATE();
    case 990:
      if (lookahead == 'e') ADVANCE(1517);
      END_STATE();
    case 991:
      if (lookahead == 'e') ADVANCE(1737);
      END_STATE();
    case 992:
      if (lookahead == 'e') ADVANCE(1979);
      END_STATE();
    case 993:
      if (lookahead == 'e') ADVANCE(1903);
      END_STATE();
    case 994:
      if (lookahead == 'e') ADVANCE(1914);
      END_STATE();
    case 995:
      if (lookahead == 'e') ADVANCE(1997);
      END_STATE();
    case 996:
      if (lookahead == 'e') ADVANCE(1358);
      END_STATE();
    case 997:
      if (lookahead == 'e') ADVANCE(888);
      END_STATE();
    case 998:
      if (lookahead == 'e') ADVANCE(699);
      END_STATE();
    case 999:
      if (lookahead == 'e') ADVANCE(890);
      END_STATE();
    case 1000:
      if (lookahead == 'e') ADVANCE(1504);
      END_STATE();
    case 1001:
      if (lookahead == 'e') ADVANCE(762);
      END_STATE();
    case 1002:
      if (lookahead == 'e') ADVANCE(893);
      END_STATE();
    case 1003:
      if (lookahead == 'e') ADVANCE(926);
      END_STATE();
    case 1004:
      if (lookahead == 'e') ADVANCE(910);
      END_STATE();
    case 1005:
      if (lookahead == 'e') ADVANCE(1758);
      END_STATE();
    case 1006:
      if (lookahead == 'e') ADVANCE(1909);
      END_STATE();
    case 1007:
      if (lookahead == 'e') ADVANCE(1676);
      if (lookahead == 'k') ADVANCE(570);
      if (lookahead == 'n') ADVANCE(1644);
      if (lookahead == 'p') ADVANCE(1192);
      if (lookahead == 'r') ADVANCE(286);
      if (lookahead == 's') ADVANCE(1238);
      if (lookahead == 't') ADVANCE(1209);
      END_STATE();
    case 1008:
      if (lookahead == 'e') ADVANCE(1676);
      if (lookahead == 'p') ADVANCE(1191);
      END_STATE();
    case 1009:
      if (lookahead == 'e') ADVANCE(1920);
      END_STATE();
    case 1010:
      if (lookahead == 'e') ADVANCE(1394);
      END_STATE();
    case 1011:
      if (lookahead == 'e') ADVANCE(869);
      END_STATE();
    case 1012:
      if (lookahead == 'e') ADVANCE(1558);
      END_STATE();
    case 1013:
      if (lookahead == 'e') ADVANCE(1951);
      END_STATE();
    case 1014:
      if (lookahead == 'e') ADVANCE(2003);
      END_STATE();
    case 1015:
      if (lookahead == 'e') ADVANCE(1922);
      END_STATE();
    case 1016:
      if (lookahead == 'e') ADVANCE(1981);
      END_STATE();
    case 1017:
      if (lookahead == 'e') ADVANCE(581);
      END_STATE();
    case 1018:
      if (lookahead == 'e') ADVANCE(941);
      END_STATE();
    case 1019:
      if (lookahead == 'e') ADVANCE(1530);
      END_STATE();
    case 1020:
      if (lookahead == 'e') ADVANCE(1421);
      END_STATE();
    case 1021:
      if (lookahead == 'e') ADVANCE(1798);
      END_STATE();
    case 1022:
      if (lookahead == 'e') ADVANCE(620);
      END_STATE();
    case 1023:
      if (lookahead == 'e') ADVANCE(1912);
      END_STATE();
    case 1024:
      if (lookahead == 'e') ADVANCE(604);
      END_STATE();
    case 1025:
      if (lookahead == 'e') ADVANCE(1913);
      END_STATE();
    case 1026:
      if (lookahead == 'e') ADVANCE(1968);
      if (lookahead == 'i') ADVANCE(1463);
      if (lookahead == 'u') ADVANCE(2162);
      END_STATE();
    case 1027:
      if (lookahead == 'e') ADVANCE(1764);
      END_STATE();
    case 1028:
      if (lookahead == 'e') ADVANCE(1871);
      END_STATE();
    case 1029:
      if (lookahead == 'e') ADVANCE(2004);
      END_STATE();
    case 1030:
      if (lookahead == 'e') ADVANCE(1835);
      END_STATE();
    case 1031:
      if (lookahead == 'e') ADVANCE(2011);
      END_STATE();
    case 1032:
      if (lookahead == 'e') ADVANCE(1004);
      END_STATE();
    case 1033:
      if (lookahead == 'e') ADVANCE(948);
      if (lookahead == 'r') ADVANCE(1335);
      END_STATE();
    case 1034:
      if (lookahead == 'e') ADVANCE(1751);
      END_STATE();
    case 1035:
      if (lookahead == 'e') ADVANCE(1845);
      if (lookahead == 'i') ADVANCE(1516);
      END_STATE();
    case 1036:
      if (lookahead == 'e') ADVANCE(1795);
      END_STATE();
    case 1037:
      if (lookahead == 'e') ADVANCE(1873);
      END_STATE();
    case 1038:
      if (lookahead == 'e') ADVANCE(1893);
      END_STATE();
    case 1039:
      if (lookahead == 'e') ADVANCE(953);
      END_STATE();
    case 1040:
      if (lookahead == 'e') ADVANCE(1808);
      END_STATE();
    case 1041:
      if (lookahead == 'e') ADVANCE(1080);
      END_STATE();
    case 1042:
      if (lookahead == 'e') ADVANCE(1805);
      END_STATE();
    case 1043:
      if (lookahead == 'e') ADVANCE(1768);
      END_STATE();
    case 1044:
      if (lookahead == 'e') ADVANCE(1813);
      END_STATE();
    case 1045:
      if (lookahead == 'e') ADVANCE(1771);
      END_STATE();
    case 1046:
      if (lookahead == 'e') ADVANCE(1111);
      END_STATE();
    case 1047:
      if (lookahead == 'e') ADVANCE(2115);
      if (lookahead == 'i') ADVANCE(1158);
      END_STATE();
    case 1048:
      if (lookahead == 'e') ADVANCE(1428);
      END_STATE();
    case 1049:
      if (lookahead == 'e') ADVANCE(524);
      END_STATE();
    case 1050:
      if (lookahead == 'e') ADVANCE(898);
      END_STATE();
    case 1051:
      if (lookahead == 'e') ADVANCE(678);
      if (lookahead == 'w') ADVANCE(678);
      END_STATE();
    case 1052:
      if (lookahead == 'e') ADVANCE(1108);
      END_STATE();
    case 1053:
      if (lookahead == 'e') ADVANCE(1108);
      if (lookahead == 'l') ADVANCE(152);
      if (lookahead == 't') ADVANCE(358);
      END_STATE();
    case 1054:
      if (lookahead == 'e') ADVANCE(1000);
      END_STATE();
    case 1055:
      if (lookahead == 'e') ADVANCE(1940);
      END_STATE();
    case 1056:
      if (lookahead == 'e') ADVANCE(901);
      END_STATE();
    case 1057:
      if (lookahead == 'e') ADVANCE(1493);
      END_STATE();
    case 1058:
      if (lookahead == 'e') ADVANCE(854);
      if (lookahead == 'o') ADVANCE(1574);
      END_STATE();
    case 1059:
      if (lookahead == 'e') ADVANCE(667);
      END_STATE();
    case 1060:
      if (lookahead == 'e') ADVANCE(1729);
      END_STATE();
    case 1061:
      if (lookahead == 'e') ADVANCE(1833);
      END_STATE();
    case 1062:
      if (lookahead == 'e') ADVANCE(2026);
      END_STATE();
    case 1063:
      if (lookahead == 'e') ADVANCE(2026);
      if (lookahead == 't') ADVANCE(532);
      END_STATE();
    case 1064:
      if (lookahead == 'e') ADVANCE(749);
      END_STATE();
    case 1065:
      if (lookahead == 'e') ADVANCE(1112);
      END_STATE();
    case 1066:
      if (lookahead == 'e') ADVANCE(919);
      END_STATE();
    case 1067:
      if (lookahead == 'e') ADVANCE(855);
      END_STATE();
    case 1068:
      if (lookahead == 'e') ADVANCE(1930);
      END_STATE();
    case 1069:
      if (lookahead == 'e') ADVANCE(1716);
      END_STATE();
    case 1070:
      if (lookahead == 'e') ADVANCE(1113);
      END_STATE();
    case 1071:
      if (lookahead == 'e') ADVANCE(1832);
      if (lookahead == 'n') ADVANCE(462);
      END_STATE();
    case 1072:
      if (lookahead == 'e') ADVANCE(857);
      END_STATE();
    case 1073:
      if (lookahead == 'e') ADVANCE(1584);
      END_STATE();
    case 1074:
      if (lookahead == 'e') ADVANCE(1114);
      END_STATE();
    case 1075:
      if (lookahead == 'e') ADVANCE(1115);
      END_STATE();
    case 1076:
      if (lookahead == 'e') ADVANCE(1567);
      END_STATE();
    case 1077:
      if (lookahead == 'e') ADVANCE(1116);
      if (lookahead == 'o') ADVANCE(1544);
      END_STATE();
    case 1078:
      if (lookahead == 'e') ADVANCE(1851);
      END_STATE();
    case 1079:
      if (lookahead == 'e') ADVANCE(1109);
      END_STATE();
    case 1080:
      if (lookahead == 'e') ADVANCE(2045);
      END_STATE();
    case 1081:
      if (lookahead == 'e') ADVANCE(1898);
      END_STATE();
    case 1082:
      if (lookahead == 'e') ADVANCE(1552);
      END_STATE();
    case 1083:
      if (lookahead == 'e') ADVANCE(703);
      END_STATE();
    case 1084:
      if (lookahead == 'e') ADVANCE(1462);
      END_STATE();
    case 1085:
      if (lookahead == 'e') ADVANCE(1160);
      END_STATE();
    case 1086:
      if (lookahead == 'e') ADVANCE(1895);
      END_STATE();
    case 1087:
      if (lookahead == 'e') ADVANCE(2032);
      END_STATE();
    case 1088:
      if (lookahead == 'e') ADVANCE(1311);
      END_STATE();
    case 1089:
      if (lookahead == 'e') ADVANCE(1878);
      END_STATE();
    case 1090:
      if (lookahead == 'e') ADVANCE(923);
      END_STATE();
    case 1091:
      if (lookahead == 'e') ADVANCE(702);
      END_STATE();
    case 1092:
      if (lookahead == 'e') ADVANCE(1527);
      END_STATE();
    case 1093:
      if (lookahead == 'e') ADVANCE(707);
      END_STATE();
    case 1094:
      if (lookahead == 'e') ADVANCE(875);
      END_STATE();
    case 1095:
      if (lookahead == 'e') ADVANCE(1119);
      END_STATE();
    case 1096:
      if (lookahead == 'f') ADVANCE(152);
      END_STATE();
    case 1097:
      if (lookahead == 'f') ADVANCE(152);
      if (lookahead == 'l') ADVANCE(2065);
      END_STATE();
    case 1098:
      if (lookahead == 'f') ADVANCE(152);
      if (lookahead == 'r') ADVANCE(1624);
      END_STATE();
    case 1099:
      if (lookahead == 'f') ADVANCE(1750);
      if (lookahead == 'i') ADVANCE(152);
      if (lookahead == 'o') ADVANCE(1680);
      if (lookahead == 's') ADVANCE(778);
      END_STATE();
    case 1100:
      if (lookahead == 'f') ADVANCE(1750);
      if (lookahead == 'i') ADVANCE(1516);
      if (lookahead == 'o') ADVANCE(1680);
      if (lookahead == 'p') ADVANCE(1820);
      if (lookahead == 's') ADVANCE(778);
      if (lookahead == 'u') ADVANCE(602);
      END_STATE();
    case 1101:
      if (lookahead == 'f') ADVANCE(1958);
      END_STATE();
    case 1102:
      if (lookahead == 'f') ADVANCE(1107);
      END_STATE();
    case 1103:
      if (lookahead == 'f') ADVANCE(1961);
      if (lookahead == 's') ADVANCE(1906);
      END_STATE();
    case 1104:
      if (lookahead == 'f') ADVANCE(1984);
      if (lookahead == 'l') ADVANCE(222);
      if (lookahead == 'p') ADVANCE(1096);
      END_STATE();
    case 1105:
      if (lookahead == 'f') ADVANCE(1925);
      if (lookahead == 'p') ADVANCE(1183);
      END_STATE();
    case 1106:
      if (lookahead == 'f') ADVANCE(2049);
      END_STATE();
    case 1107:
      if (lookahead == 'f') ADVANCE(1081);
      END_STATE();
    case 1108:
      if (lookahead == 'f') ADVANCE(1988);
      END_STATE();
    case 1109:
      if (lookahead == 'f') ADVANCE(2003);
      END_STATE();
    case 1110:
      if (lookahead == 'f') ADVANCE(1668);
      END_STATE();
    case 1111:
      if (lookahead == 'f') ADVANCE(1995);
      if (lookahead == 's') ADVANCE(1911);
      END_STATE();
    case 1112:
      if (lookahead == 'f') ADVANCE(1970);
      END_STATE();
    case 1113:
      if (lookahead == 'f') ADVANCE(1972);
      END_STATE();
    case 1114:
      if (lookahead == 'f') ADVANCE(1990);
      END_STATE();
    case 1115:
      if (lookahead == 'f') ADVANCE(2028);
      END_STATE();
    case 1116:
      if (lookahead == 'f') ADVANCE(1976);
      END_STATE();
    case 1117:
      if (lookahead == 'f') ADVANCE(1628);
      END_STATE();
    case 1118:
      if (lookahead == 'f') ADVANCE(1267);
      END_STATE();
    case 1119:
      if (lookahead == 'f') ADVANCE(2048);
      END_STATE();
    case 1120:
      if (lookahead == 'g') ADVANCE(152);
      END_STATE();
    case 1121:
      if (lookahead == 'g') ADVANCE(152);
      if (lookahead == 's') ADVANCE(1677);
      END_STATE();
    case 1122:
      if (lookahead == 'g') ADVANCE(152);
      if (lookahead == 't') ADVANCE(358);
      END_STATE();
    case 1123:
      if (lookahead == 'g') ADVANCE(767);
      END_STATE();
    case 1124:
      if (lookahead == 'g') ADVANCE(240);
      END_STATE();
    case 1125:
      if (lookahead == 'g') ADVANCE(240);
      if (lookahead == 'i') ADVANCE(1516);
      END_STATE();
    case 1126:
      if (lookahead == 'g') ADVANCE(495);
      END_STATE();
    case 1127:
      if (lookahead == 'g') ADVANCE(514);
      END_STATE();
    case 1128:
      if (lookahead == 'g') ADVANCE(244);
      END_STATE();
    case 1129:
      if (lookahead == 'g') ADVANCE(1461);
      END_STATE();
    case 1130:
      if (lookahead == 'g') ADVANCE(303);
      END_STATE();
    case 1131:
      if (lookahead == 'g') ADVANCE(532);
      END_STATE();
    case 1132:
      if (lookahead == 'g') ADVANCE(1199);
      END_STATE();
    case 1133:
      if (lookahead == 'g') ADVANCE(2154);
      END_STATE();
    case 1134:
      if (lookahead == 'g') ADVANCE(1146);
      if (lookahead == 'l') ADVANCE(995);
      if (lookahead == 'r') ADVANCE(1750);
      if (lookahead == 's') ADVANCE(1187);
      END_STATE();
    case 1135:
      if (lookahead == 'g') ADVANCE(1146);
      if (lookahead == 'r') ADVANCE(1750);
      END_STATE();
    case 1136:
      if (lookahead == 'g') ADVANCE(1146);
      if (lookahead == 'r') ADVANCE(1750);
      if (lookahead == 's') ADVANCE(1189);
      END_STATE();
    case 1137:
      if (lookahead == 'g') ADVANCE(1590);
      END_STATE();
    case 1138:
      if (lookahead == 'g') ADVANCE(1629);
      if (lookahead == 'p') ADVANCE(1096);
      END_STATE();
    case 1139:
      if (lookahead == 'g') ADVANCE(1629);
      if (lookahead == 'p') ADVANCE(1096);
      if (lookahead == 't') ADVANCE(532);
      END_STATE();
    case 1140:
      if (lookahead == 'g') ADVANCE(1470);
      END_STATE();
    case 1141:
      if (lookahead == 'g') ADVANCE(1188);
      END_STATE();
    case 1142:
      if (lookahead == 'g') ADVANCE(1358);
      if (lookahead == 'i') ADVANCE(1390);
      if (lookahead == 'l') ADVANCE(1120);
      if (lookahead == 'r') ADVANCE(1331);
      END_STATE();
    case 1143:
      if (lookahead == 'g') ADVANCE(676);
      if (lookahead == 's') ADVANCE(2014);
      if (lookahead == 'w') ADVANCE(493);
      END_STATE();
    case 1144:
      if (lookahead == 'g') ADVANCE(1504);
      END_STATE();
    case 1145:
      if (lookahead == 'g') ADVANCE(926);
      END_STATE();
    case 1146:
      if (lookahead == 'g') ADVANCE(957);
      END_STATE();
    case 1147:
      if (lookahead == 'g') ADVANCE(961);
      END_STATE();
    case 1148:
      if (lookahead == 'g') ADVANCE(1877);
      END_STATE();
    case 1149:
      if (lookahead == 'g') ADVANCE(1877);
      if (lookahead == 'i') ADVANCE(1516);
      if (lookahead == 't') ADVANCE(1658);
      END_STATE();
    case 1150:
      if (lookahead == 'g') ADVANCE(1775);
      END_STATE();
    case 1151:
      if (lookahead == 'g') ADVANCE(1202);
      if (lookahead == 'n') ADVANCE(1120);
      if (lookahead == 's') ADVANCE(1301);
      END_STATE();
    case 1152:
      if (lookahead == 'g') ADVANCE(920);
      END_STATE();
    case 1153:
      if (lookahead == 'g') ADVANCE(1784);
      END_STATE();
    case 1154:
      if (lookahead == 'g') ADVANCE(1198);
      END_STATE();
    case 1155:
      if (lookahead == 'g') ADVANCE(1978);
      END_STATE();
    case 1156:
      if (lookahead == 'g') ADVANCE(1978);
      if (lookahead == 'l') ADVANCE(972);
      END_STATE();
    case 1157:
      if (lookahead == 'g') ADVANCE(1978);
      if (lookahead == 'q') ADVANCE(1155);
      END_STATE();
    case 1158:
      if (lookahead == 'g') ADVANCE(1203);
      END_STATE();
    case 1159:
      if (lookahead == 'g') ADVANCE(1496);
      if (lookahead == 'm') ADVANCE(241);
      END_STATE();
    case 1160:
      if (lookahead == 'g') ADVANCE(1828);
      END_STATE();
    case 1161:
      if (lookahead == 'g') ADVANCE(1828);
      if (lookahead == 'r') ADVANCE(1945);
      END_STATE();
    case 1162:
      if (lookahead == 'g') ADVANCE(1204);
      END_STATE();
    case 1163:
      if (lookahead == 'g') ADVANCE(1206);
      END_STATE();
    case 1164:
      if (lookahead == 'g') ADVANCE(1207);
      END_STATE();
    case 1165:
      if (lookahead == 'g') ADVANCE(1208);
      END_STATE();
    case 1166:
      if (lookahead == 'g') ADVANCE(1407);
      END_STATE();
    case 1167:
      if (lookahead == 'g') ADVANCE(1210);
      END_STATE();
    case 1168:
      if (lookahead == 'g') ADVANCE(1040);
      if (lookahead == 'r') ADVANCE(849);
      END_STATE();
    case 1169:
      if (lookahead == 'g') ADVANCE(1211);
      END_STATE();
    case 1170:
      if (lookahead == 'g') ADVANCE(1212);
      END_STATE();
    case 1171:
      if (lookahead == 'g') ADVANCE(1429);
      END_STATE();
    case 1172:
      if (lookahead == 'g') ADVANCE(1201);
      END_STATE();
    case 1173:
      if (lookahead == 'g') ADVANCE(1431);
      END_STATE();
    case 1174:
      if (lookahead == 'g') ADVANCE(1432);
      END_STATE();
    case 1175:
      if (lookahead == 'g') ADVANCE(1433);
      END_STATE();
    case 1176:
      if (lookahead == 'g') ADVANCE(1446);
      END_STATE();
    case 1177:
      if (lookahead == 'g') ADVANCE(1434);
      END_STATE();
    case 1178:
      if (lookahead == 'g') ADVANCE(1435);
      END_STATE();
    case 1179:
      if (lookahead == 'g') ADVANCE(494);
      END_STATE();
    case 1180:
      if (lookahead == 'g') ADVANCE(694);
      END_STATE();
    case 1181:
      if (lookahead == 'g') ADVANCE(1221);
      END_STATE();
    case 1182:
      if (lookahead == 'h') ADVANCE(881);
      END_STATE();
    case 1183:
      if (lookahead == 'h') ADVANCE(152);
      END_STATE();
    case 1184:
      if (lookahead == 'h') ADVANCE(297);
      END_STATE();
    case 1185:
      if (lookahead == 'h') ADVANCE(514);
      END_STATE();
    case 1186:
      if (lookahead == 'h') ADVANCE(532);
      END_STATE();
    case 1187:
      if (lookahead == 'h') ADVANCE(358);
      END_STATE();
    case 1188:
      if (lookahead == 'h') ADVANCE(1958);
      END_STATE();
    case 1189:
      if (lookahead == 'h') ADVANCE(2108);
      END_STATE();
    case 1190:
      if (lookahead == 'h') ADVANCE(754);
      if (lookahead == 'y') ADVANCE(152);
      END_STATE();
    case 1191:
      if (lookahead == 'h') ADVANCE(1223);
      END_STATE();
    case 1192:
      if (lookahead == 'h') ADVANCE(1223);
      if (lookahead == 'i') ADVANCE(152);
      if (lookahead == 'r') ADVANCE(1657);
      END_STATE();
    case 1193:
      if (lookahead == 'h') ADVANCE(546);
      END_STATE();
    case 1194:
      if (lookahead == 'h') ADVANCE(1677);
      END_STATE();
    case 1195:
      if (lookahead == 'h') ADVANCE(1339);
      END_STATE();
    case 1196:
      if (lookahead == 'h') ADVANCE(1339);
      if (lookahead == 'r') ADVANCE(316);
      END_STATE();
    case 1197:
      if (lookahead == 'h') ADVANCE(926);
      END_STATE();
    case 1198:
      if (lookahead == 'h') ADVANCE(2049);
      END_STATE();
    case 1199:
      if (lookahead == 'h') ADVANCE(1965);
      END_STATE();
    case 1200:
      if (lookahead == 'h') ADVANCE(556);
      END_STATE();
    case 1201:
      if (lookahead == 'h') ADVANCE(2003);
      END_STATE();
    case 1202:
      if (lookahead == 'h') ADVANCE(1967);
      END_STATE();
    case 1203:
      if (lookahead == 'h') ADVANCE(1995);
      END_STATE();
    case 1204:
      if (lookahead == 'h') ADVANCE(1980);
      END_STATE();
    case 1205:
      if (lookahead == 'h') ADVANCE(1226);
      END_STATE();
    case 1206:
      if (lookahead == 'h') ADVANCE(1971);
      END_STATE();
    case 1207:
      if (lookahead == 'h') ADVANCE(1973);
      END_STATE();
    case 1208:
      if (lookahead == 'h') ADVANCE(1990);
      END_STATE();
    case 1209:
      if (lookahead == 'h') ADVANCE(992);
      if (lookahead == 'r') ADVANCE(1334);
      END_STATE();
    case 1210:
      if (lookahead == 'h') ADVANCE(1975);
      END_STATE();
    case 1211:
      if (lookahead == 'h') ADVANCE(1977);
      END_STATE();
    case 1212:
      if (lookahead == 'h') ADVANCE(1974);
      END_STATE();
    case 1213:
      if (lookahead == 'h') ADVANCE(1068);
      END_STATE();
    case 1214:
      if (lookahead == 'h') ADVANCE(1260);
      END_STATE();
    case 1215:
      if (lookahead == 'h') ADVANCE(1000);
      END_STATE();
    case 1216:
      if (lookahead == 'h') ADVANCE(1117);
      END_STATE();
    case 1217:
      if (lookahead == 'h') ADVANCE(1799);
      if (lookahead == 'i') ADVANCE(1497);
      if (lookahead == 'r') ADVANCE(1231);
      END_STATE();
    case 1218:
      if (lookahead == 'h') ADVANCE(1022);
      END_STATE();
    case 1219:
      if (lookahead == 'h') ADVANCE(1284);
      END_STATE();
    case 1220:
      if (lookahead == 'h') ADVANCE(1880);
      END_STATE();
    case 1221:
      if (lookahead == 'h') ADVANCE(2048);
      END_STATE();
    case 1222:
      if (lookahead == 'i') ADVANCE(881);
      END_STATE();
    case 1223:
      if (lookahead == 'i') ADVANCE(152);
      END_STATE();
    case 1224:
      if (lookahead == 'i') ADVANCE(297);
      END_STATE();
    case 1225:
      if (lookahead == 'i') ADVANCE(280);
      END_STATE();
    case 1226:
      if (lookahead == 'i') ADVANCE(830);
      END_STATE();
    case 1227:
      if (lookahead == 'i') ADVANCE(2137);
      if (lookahead == 'o') ADVANCE(1218);
      END_STATE();
    case 1228:
      if (lookahead == 'i') ADVANCE(2153);
      END_STATE();
    case 1229:
      if (lookahead == 'i') ADVANCE(274);
      END_STATE();
    case 1230:
      if (lookahead == 'i') ADVANCE(302);
      END_STATE();
    case 1231:
      if (lookahead == 'i') ADVANCE(299);
      END_STATE();
    case 1232:
      if (lookahead == 'i') ADVANCE(285);
      END_STATE();
    case 1233:
      if (lookahead == 'i') ADVANCE(1750);
      END_STATE();
    case 1234:
      if (lookahead == 'i') ADVANCE(1750);
      if (lookahead == 'r') ADVANCE(1604);
      END_STATE();
    case 1235:
      if (lookahead == 'i') ADVANCE(1516);
      END_STATE();
    case 1236:
      if (lookahead == 'i') ADVANCE(1516);
      if (lookahead == 'n') ADVANCE(1958);
      END_STATE();
    case 1237:
      if (lookahead == 'i') ADVANCE(358);
      if (lookahead == 'm') ADVANCE(1495);
      if (lookahead == 'o') ADVANCE(1538);
      END_STATE();
    case 1238:
      if (lookahead == 'i') ADVANCE(1140);
      if (lookahead == 'u') ADVANCE(753);
      END_STATE();
    case 1239:
      if (lookahead == 'i') ADVANCE(1391);
      END_STATE();
    case 1240:
      if (lookahead == 'i') ADVANCE(301);
      END_STATE();
    case 1241:
      if (lookahead == 'i') ADVANCE(1958);
      END_STATE();
    case 1242:
      if (lookahead == 'i') ADVANCE(2108);
      END_STATE();
    case 1243:
      if (lookahead == 'i') ADVANCE(876);
      END_STATE();
    case 1244:
      if (lookahead == 'i') ADVANCE(876);
      if (lookahead == 'o') ADVANCE(2092);
      END_STATE();
    case 1245:
      if (lookahead == 'i') ADVANCE(1505);
      END_STATE();
    case 1246:
      if (lookahead == 'i') ADVANCE(359);
      END_STATE();
    case 1247:
      if (lookahead == 'i') ADVANCE(1952);
      END_STATE();
    case 1248:
      if (lookahead == 'i') ADVANCE(1952);
      if (lookahead == 'p') ADVANCE(1632);
      END_STATE();
    case 1249:
      if (lookahead == 'i') ADVANCE(250);
      END_STATE();
    case 1250:
      if (lookahead == 'i') ADVANCE(1386);
      END_STATE();
    case 1251:
      if (lookahead == 'i') ADVANCE(1677);
      END_STATE();
    case 1252:
      if (lookahead == 'i') ADVANCE(1120);
      END_STATE();
    case 1253:
      if (lookahead == 'i') ADVANCE(1120);
      if (lookahead == 'l') ADVANCE(1252);
      END_STATE();
    case 1254:
      if (lookahead == 'i') ADVANCE(1102);
      END_STATE();
    case 1255:
      if (lookahead == 'i') ADVANCE(1463);
      END_STATE();
    case 1256:
      if (lookahead == 'i') ADVANCE(1463);
      if (lookahead == 'l') ADVANCE(152);
      END_STATE();
    case 1257:
      if (lookahead == 'i') ADVANCE(1463);
      if (lookahead == 'l') ADVANCE(674);
      END_STATE();
    case 1258:
      if (lookahead == 'i') ADVANCE(1629);
      END_STATE();
    case 1259:
      if (lookahead == 'i') ADVANCE(1903);
      END_STATE();
    case 1260:
      if (lookahead == 'i') ADVANCE(1525);
      END_STATE();
    case 1261:
      if (lookahead == 'i') ADVANCE(1928);
      if (lookahead == 'l') ADVANCE(1638);
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 1262:
      if (lookahead == 'i') ADVANCE(1928);
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 1263:
      if (lookahead == 'i') ADVANCE(1358);
      END_STATE();
    case 1264:
      if (lookahead == 'i') ADVANCE(1133);
      END_STATE();
    case 1265:
      if (lookahead == 'i') ADVANCE(1144);
      END_STATE();
    case 1266:
      if (lookahead == 'i') ADVANCE(2069);
      END_STATE();
    case 1267:
      if (lookahead == 'i') ADVANCE(1504);
      END_STATE();
    case 1268:
      if (lookahead == 'i') ADVANCE(1388);
      END_STATE();
    case 1269:
      if (lookahead == 'i') ADVANCE(762);
      END_STATE();
    case 1270:
      if (lookahead == 'i') ADVANCE(1780);
      if (lookahead == 'y') ADVANCE(152);
      END_STATE();
    case 1271:
      if (lookahead == 'i') ADVANCE(926);
      END_STATE();
    case 1272:
      if (lookahead == 'i') ADVANCE(1538);
      END_STATE();
    case 1273:
      if (lookahead == 'i') ADVANCE(688);
      END_STATE();
    case 1274:
      if (lookahead == 'i') ADVANCE(911);
      END_STATE();
    case 1275:
      if (lookahead == 'i') ADVANCE(1482);
      END_STATE();
    case 1276:
      if (lookahead == 'i') ADVANCE(1180);
      END_STATE();
    case 1277:
      if (lookahead == 'i') ADVANCE(1824);
      if (lookahead == 'l') ADVANCE(1096);
      if (lookahead == 'm') ADVANCE(1279);
      if (lookahead == 'r') ADVANCE(892);
      END_STATE();
    case 1278:
      if (lookahead == 'i') ADVANCE(1529);
      END_STATE();
    case 1279:
      if (lookahead == 'i') ADVANCE(1374);
      END_STATE();
    case 1280:
      if (lookahead == 'i') ADVANCE(993);
      END_STATE();
    case 1281:
      if (lookahead == 'i') ADVANCE(2064);
      END_STATE();
    case 1282:
      if (lookahead == 'i') ADVANCE(1569);
      END_STATE();
    case 1283:
      if (lookahead == 'i') ADVANCE(1562);
      END_STATE();
    case 1284:
      if (lookahead == 'i') ADVANCE(1507);
      END_STATE();
    case 1285:
      if (lookahead == 'i') ADVANCE(1404);
      if (lookahead == 'l') ADVANCE(1253);
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 1286:
      if (lookahead == 'i') ADVANCE(1141);
      END_STATE();
    case 1287:
      if (lookahead == 'i') ADVANCE(1392);
      END_STATE();
    case 1288:
      if (lookahead == 'i') ADVANCE(1540);
      if (lookahead == 'p') ADVANCE(1096);
      END_STATE();
    case 1289:
      if (lookahead == 'i') ADVANCE(1817);
      END_STATE();
    case 1290:
      if (lookahead == 'i') ADVANCE(1817);
      if (lookahead == 'o') ADVANCE(1388);
      END_STATE();
    case 1291:
      if (lookahead == 'i') ADVANCE(1817);
      if (lookahead == 'y') ADVANCE(152);
      END_STATE();
    case 1292:
      if (lookahead == 'i') ADVANCE(1390);
      END_STATE();
    case 1293:
      if (lookahead == 'i') ADVANCE(745);
      END_STATE();
    case 1294:
      if (lookahead == 'i') ADVANCE(636);
      END_STATE();
    case 1295:
      if (lookahead == 'i') ADVANCE(1943);
      END_STATE();
    case 1296:
      if (lookahead == 'i') ADVANCE(2114);
      END_STATE();
    case 1297:
      if (lookahead == 'i') ADVANCE(1723);
      END_STATE();
    case 1298:
      if (lookahead == 'i') ADVANCE(1548);
      if (lookahead == 'p') ADVANCE(1096);
      if (lookahead == 'u') ADVANCE(1519);
      END_STATE();
    case 1299:
      if (lookahead == 'i') ADVANCE(1409);
      END_STATE();
    case 1300:
      if (lookahead == 'i') ADVANCE(1487);
      END_STATE();
    case 1301:
      if (lookahead == 'i') ADVANCE(1542);
      END_STATE();
    case 1302:
      if (lookahead == 'i') ADVANCE(1947);
      END_STATE();
    case 1303:
      if (lookahead == 'i') ADVANCE(1942);
      END_STATE();
    case 1304:
      if (lookahead == 'i') ADVANCE(1497);
      END_STATE();
    case 1305:
      if (lookahead == 'i') ADVANCE(1483);
      END_STATE();
    case 1306:
      if (lookahead == 'i') ADVANCE(2023);
      END_STATE();
    case 1307:
      if (lookahead == 'i') ADVANCE(1420);
      END_STATE();
    case 1308:
      if (lookahead == 'i') ADVANCE(1546);
      END_STATE();
    case 1309:
      if (lookahead == 'i') ADVANCE(1037);
      END_STATE();
    case 1310:
      if (lookahead == 'i') ADVANCE(644);
      END_STATE();
    case 1311:
      if (lookahead == 'i') ADVANCE(1439);
      END_STATE();
    case 1312:
      if (lookahead == 'i') ADVANCE(1407);
      END_STATE();
    case 1313:
      if (lookahead == 'i') ADVANCE(1646);
      END_STATE();
    case 1314:
      if (lookahead == 'i') ADVANCE(1625);
      END_STATE();
    case 1315:
      if (lookahead == 'i') ADVANCE(1563);
      END_STATE();
    case 1316:
      if (lookahead == 'i') ADVANCE(1563);
      if (lookahead == 'n') ADVANCE(152);
      END_STATE();
    case 1317:
      if (lookahead == 'i') ADVANCE(1154);
      END_STATE();
    case 1318:
      if (lookahead == 'i') ADVANCE(1440);
      END_STATE();
    case 1319:
      if (lookahead == 'i') ADVANCE(868);
      END_STATE();
    case 1320:
      if (lookahead == 'i') ADVANCE(872);
      END_STATE();
    case 1321:
      if (lookahead == 'i') ADVANCE(746);
      END_STATE();
    case 1322:
      if (lookahead == 'i') ADVANCE(1162);
      END_STATE();
    case 1323:
      if (lookahead == 'i') ADVANCE(1163);
      END_STATE();
    case 1324:
      if (lookahead == 'i') ADVANCE(1164);
      END_STATE();
    case 1325:
      if (lookahead == 'i') ADVANCE(1165);
      END_STATE();
    case 1326:
      if (lookahead == 'i') ADVANCE(1167);
      END_STATE();
    case 1327:
      if (lookahead == 'i') ADVANCE(1169);
      END_STATE();
    case 1328:
      if (lookahead == 'i') ADVANCE(1170);
      END_STATE();
    case 1329:
      if (lookahead == 'i') ADVANCE(1172);
      END_STATE();
    case 1330:
      if (lookahead == 'i') ADVANCE(1891);
      END_STATE();
    case 1331:
      if (lookahead == 'i') ADVANCE(712);
      END_STATE();
    case 1332:
      if (lookahead == 'i') ADVANCE(1181);
      END_STATE();
    case 1333:
      if (lookahead == 'i') ADVANCE(714);
      END_STATE();
    case 1334:
      if (lookahead == 'i') ADVANCE(715);
      END_STATE();
    case 1335:
      if (lookahead == 'i') ADVANCE(716);
      END_STATE();
    case 1336:
      if (lookahead == 'i') ADVANCE(717);
      END_STATE();
    case 1337:
      if (lookahead == 'j') ADVANCE(152);
      END_STATE();
    case 1338:
      if (lookahead == 'j') ADVANCE(152);
      if (lookahead == 'n') ADVANCE(1337);
      END_STATE();
    case 1339:
      if (lookahead == 'k') ADVANCE(152);
      END_STATE();
    case 1340:
      if (lookahead == 'k') ADVANCE(514);
      END_STATE();
    case 1341:
      if (lookahead == 'k') ADVANCE(870);
      END_STATE();
    case 1342:
      if (lookahead == 'k') ADVANCE(1444);
      END_STATE();
    case 1343:
      if (lookahead == 'k') ADVANCE(1417);
      END_STATE();
    case 1344:
      if (lookahead == 'k') ADVANCE(308);
      END_STATE();
    case 1345:
      if (lookahead == 'k') ADVANCE(284);
      END_STATE();
    case 1346:
      if (lookahead == 'k') ADVANCE(754);
      END_STATE();
    case 1347:
      if (lookahead == 'k') ADVANCE(754);
      if (lookahead == 'm') ADVANCE(297);
      END_STATE();
    case 1348:
      if (lookahead == 'k') ADVANCE(2131);
      END_STATE();
    case 1349:
      if (lookahead == 'k') ADVANCE(350);
      END_STATE();
    case 1350:
      if (lookahead == 'k') ADVANCE(1939);
      END_STATE();
    case 1351:
      if (lookahead == 'k') ADVANCE(957);
      END_STATE();
    case 1352:
      if (lookahead == 'k') ADVANCE(961);
      END_STATE();
    case 1353:
      if (lookahead == 'k') ADVANCE(671);
      END_STATE();
    case 1354:
      if (lookahead == 'k') ADVANCE(678);
      END_STATE();
    case 1355:
      if (lookahead == 'k') ADVANCE(678);
      if (lookahead == 'l') ADVANCE(609);
      END_STATE();
    case 1356:
      if (lookahead == 'k') ADVANCE(1308);
      END_STATE();
    case 1357:
      if (lookahead == 'l') ADVANCE(881);
      END_STATE();
    case 1358:
      if (lookahead == 'l') ADVANCE(152);
      END_STATE();
    case 1359:
      if (lookahead == 'l') ADVANCE(347);
      END_STATE();
    case 1360:
      if (lookahead == 'l') ADVANCE(493);
      END_STATE();
    case 1361:
      if (lookahead == 'l') ADVANCE(462);
      END_STATE();
    case 1362:
      if (lookahead == 'l') ADVANCE(221);
      END_STATE();
    case 1363:
      if (lookahead == 'l') ADVANCE(291);
      END_STATE();
    case 1364:
      if (lookahead == 'l') ADVANCE(2164);
      END_STATE();
    case 1365:
      if (lookahead == 'l') ADVANCE(426);
      END_STATE();
    case 1366:
      if (lookahead == 'l') ADVANCE(413);
      END_STATE();
    case 1367:
      if (lookahead == 'l') ADVANCE(185);
      END_STATE();
    case 1368:
      if (lookahead == 'l') ADVANCE(532);
      END_STATE();
    case 1369:
      if (lookahead == 'l') ADVANCE(2143);
      END_STATE();
    case 1370:
      if (lookahead == 'l') ADVANCE(1057);
      END_STATE();
    case 1371:
      if (lookahead == 'l') ADVANCE(1057);
      if (lookahead == 'q') ADVANCE(2082);
      END_STATE();
    case 1372:
      if (lookahead == 'l') ADVANCE(1057);
      if (lookahead == 'q') ADVANCE(2081);
      if (lookahead == 'x') ADVANCE(1247);
      END_STATE();
    case 1373:
      if (lookahead == 'l') ADVANCE(478);
      END_STATE();
    case 1374:
      if (lookahead == 'l') ADVANCE(1958);
      END_STATE();
    case 1375:
      if (lookahead == 'l') ADVANCE(190);
      END_STATE();
    case 1376:
      if (lookahead == 'l') ADVANCE(471);
      END_STATE();
    case 1377:
      if (lookahead == 'l') ADVANCE(739);
      END_STATE();
    case 1378:
      if (lookahead == 'l') ADVANCE(434);
      END_STATE();
    case 1379:
      if (lookahead == 'l') ADVANCE(425);
      END_STATE();
    case 1380:
      if (lookahead == 'l') ADVANCE(516);
      END_STATE();
    case 1381:
      if (lookahead == 'l') ADVANCE(546);
      END_STATE();
    case 1382:
      if (lookahead == 'l') ADVANCE(334);
      END_STATE();
    case 1383:
      if (lookahead == 'l') ADVANCE(579);
      END_STATE();
    case 1384:
      if (lookahead == 'l') ADVANCE(255);
      END_STATE();
    case 1385:
      if (lookahead == 'l') ADVANCE(445);
      END_STATE();
    case 1386:
      if (lookahead == 'l') ADVANCE(909);
      END_STATE();
    case 1387:
      if (lookahead == 'l') ADVANCE(456);
      END_STATE();
    case 1388:
      if (lookahead == 'l') ADVANCE(1629);
      END_STATE();
    case 1389:
      if (lookahead == 'l') ADVANCE(1339);
      END_STATE();
    case 1390:
      if (lookahead == 'l') ADVANCE(896);
      END_STATE();
    case 1391:
      if (lookahead == 'l') ADVANCE(896);
      if (lookahead == 'm') ADVANCE(993);
      END_STATE();
    case 1392:
      if (lookahead == 'l') ADVANCE(896);
      if (lookahead == 'm') ADVANCE(1015);
      END_STATE();
    case 1393:
      if (lookahead == 'l') ADVANCE(977);
      END_STATE();
    case 1394:
      if (lookahead == 'l') ADVANCE(1903);
      END_STATE();
    case 1395:
      if (lookahead == 'l') ADVANCE(848);
      END_STATE();
    case 1396:
      if (lookahead == 'l') ADVANCE(1259);
      END_STATE();
    case 1397:
      if (lookahead == 'l') ADVANCE(2142);
      END_STATE();
    case 1398:
      if (lookahead == 'l') ADVANCE(1225);
      END_STATE();
    case 1399:
      if (lookahead == 'l') ADVANCE(996);
      END_STATE();
    case 1400:
      if (lookahead == 'l') ADVANCE(1358);
      END_STATE();
    case 1401:
      if (lookahead == 'l') ADVANCE(2152);
      END_STATE();
    case 1402:
      if (lookahead == 'l') ADVANCE(1638);
      END_STATE();
    case 1403:
      if (lookahead == 'l') ADVANCE(2089);
      END_STATE();
    case 1404:
      if (lookahead == 'l') ADVANCE(1252);
      END_STATE();
    case 1405:
      if (lookahead == 'l') ADVANCE(1384);
      if (lookahead == 'm') ADVANCE(1689);
      END_STATE();
    case 1406:
      if (lookahead == 'l') ADVANCE(1381);
      if (lookahead == 'p') ADVANCE(1096);
      if (lookahead == 't') ADVANCE(254);
      if (lookahead == 'u') ADVANCE(744);
      if (lookahead == 'w') ADVANCE(1508);
      END_STATE();
    case 1407:
      if (lookahead == 'l') ADVANCE(926);
      END_STATE();
    case 1408:
      if (lookahead == 'l') ADVANCE(982);
      END_STATE();
    case 1409:
      if (lookahead == 'l') ADVANCE(1368);
      END_STATE();
    case 1410:
      if (lookahead == 'l') ADVANCE(1378);
      END_STATE();
    case 1411:
      if (lookahead == 'l') ADVANCE(997);
      END_STATE();
    case 1412:
      if (lookahead == 'l') ADVANCE(1459);
      if (lookahead == 's') ADVANCE(1194);
      END_STATE();
    case 1413:
      if (lookahead == 'l') ADVANCE(1656);
      END_STATE();
    case 1414:
      if (lookahead == 'l') ADVANCE(1280);
      END_STATE();
    case 1415:
      if (lookahead == 'l') ADVANCE(1251);
      END_STATE();
    case 1416:
      if (lookahead == 'l') ADVANCE(1376);
      END_STATE();
    case 1417:
      if (lookahead == 'l') ADVANCE(1607);
      if (lookahead == 's') ADVANCE(1747);
      if (lookahead == 't') ADVANCE(1902);
      END_STATE();
    case 1418:
      if (lookahead == 'l') ADVANCE(972);
      END_STATE();
    case 1419:
      if (lookahead == 'l') ADVANCE(972);
      if (lookahead == 'q') ADVANCE(1418);
      END_STATE();
    case 1420:
      if (lookahead == 'l') ADVANCE(1293);
      END_STATE();
    case 1421:
      if (lookahead == 'l') ADVANCE(595);
      END_STATE();
    case 1422:
      if (lookahead == 'l') ADVANCE(1380);
      END_STATE();
    case 1423:
      if (lookahead == 'l') ADVANCE(943);
      END_STATE();
    case 1424:
      if (lookahead == 'l') ADVANCE(944);
      END_STATE();
    case 1425:
      if (lookahead == 'l') ADVANCE(1641);
      END_STATE();
    case 1426:
      if (lookahead == 'l') ADVANCE(933);
      END_STATE();
    case 1427:
      if (lookahead == 'l') ADVANCE(1064);
      END_STATE();
    case 1428:
      if (lookahead == 'l') ADVANCE(986);
      if (lookahead == 'r') ADVANCE(1286);
      END_STATE();
    case 1429:
      if (lookahead == 'l') ADVANCE(951);
      END_STATE();
    case 1430:
      if (lookahead == 'l') ADVANCE(952);
      END_STATE();
    case 1431:
      if (lookahead == 'l') ADVANCE(964);
      END_STATE();
    case 1432:
      if (lookahead == 'l') ADVANCE(1084);
      END_STATE();
    case 1433:
      if (lookahead == 'l') ADVANCE(974);
      END_STATE();
    case 1434:
      if (lookahead == 'l') ADVANCE(954);
      END_STATE();
    case 1435:
      if (lookahead == 'l') ADVANCE(955);
      END_STATE();
    case 1436:
      if (lookahead == 'l') ADVANCE(956);
      END_STATE();
    case 1437:
      if (lookahead == 'l') ADVANCE(983);
      END_STATE();
    case 1438:
      if (lookahead == 'l') ADVANCE(609);
      END_STATE();
    case 1439:
      if (lookahead == 'l') ADVANCE(1260);
      END_STATE();
    case 1440:
      if (lookahead == 'l') ADVANCE(903);
      END_STATE();
    case 1441:
      if (lookahead == 'l') ADVANCE(903);
      if (lookahead == 'm') ADVANCE(987);
      if (lookahead == 'n') ADVANCE(1958);
      END_STATE();
    case 1442:
      if (lookahead == 'l') ADVANCE(1631);
      if (lookahead == 'n') ADVANCE(1149);
      if (lookahead == 'p') ADVANCE(1098);
      if (lookahead == 'u') ADVANCE(1570);
      END_STATE();
    case 1443:
      if (lookahead == 'l') ADVANCE(551);
      END_STATE();
    case 1444:
      if (lookahead == 'l') ADVANCE(968);
      if (lookahead == 'r') ADVANCE(1317);
      END_STATE();
    case 1445:
      if (lookahead == 'l') ADVANCE(1049);
      END_STATE();
    case 1446:
      if (lookahead == 'l') ADVANCE(1048);
      END_STATE();
    case 1447:
      if (lookahead == 'l') ADVANCE(664);
      END_STATE();
    case 1448:
      if (lookahead == 'l') ADVANCE(2065);
      END_STATE();
    case 1449:
      if (lookahead == 'l') ADVANCE(1411);
      END_STATE();
    case 1450:
      if (lookahead == 'l') ADVANCE(610);
      END_STATE();
    case 1451:
      if (lookahead == 'l') ADVANCE(1301);
      END_STATE();
    case 1452:
      if (lookahead == 'l') ADVANCE(1636);
      if (lookahead == 'm') ADVANCE(1492);
      if (lookahead == 'n') ADVANCE(1125);
      if (lookahead == 'p') ADVANCE(275);
      END_STATE();
    case 1453:
      if (lookahead == 'l') ADVANCE(1849);
      END_STATE();
    case 1454:
      if (lookahead == 'l') ADVANCE(1235);
      END_STATE();
    case 1455:
      if (lookahead == 'l') ADVANCE(1396);
      END_STATE();
    case 1456:
      if (lookahead == 'l') ADVANCE(1283);
      END_STATE();
    case 1457:
      if (lookahead == 'l') ADVANCE(1399);
      END_STATE();
    case 1458:
      if (lookahead == 'l') ADVANCE(686);
      END_STATE();
    case 1459:
      if (lookahead == 'l') ADVANCE(1955);
      END_STATE();
    case 1460:
      if (lookahead == 'l') ADVANCE(1451);
      END_STATE();
    case 1461:
      if (lookahead == 'l') ADVANCE(1052);
      if (lookahead == 'm') ADVANCE(631);
      if (lookahead == 'r') ADVANCE(1317);
      END_STATE();
    case 1462:
      if (lookahead == 'l') ADVANCE(1079);
      if (lookahead == 'r') ADVANCE(1329);
      END_STATE();
    case 1463:
      if (lookahead == 'm') ADVANCE(152);
      END_STATE();
    case 1464:
      if (lookahead == 'm') ADVANCE(297);
      END_STATE();
    case 1465:
      if (lookahead == 'm') ADVANCE(297);
      if (lookahead == 'r') ADVANCE(1588);
      END_STATE();
    case 1466:
      if (lookahead == 'm') ADVANCE(514);
      END_STATE();
    case 1467:
      if (lookahead == 'm') ADVANCE(320);
      END_STATE();
    case 1468:
      if (lookahead == 'm') ADVANCE(366);
      END_STATE();
    case 1469:
      if (lookahead == 'm') ADVANCE(365);
      END_STATE();
    case 1470:
      if (lookahead == 'm') ADVANCE(532);
      END_STATE();
    case 1471:
      if (lookahead == 'm') ADVANCE(1316);
      END_STATE();
    case 1472:
      if (lookahead == 'm') ADVANCE(1223);
      END_STATE();
    case 1473:
      if (lookahead == 'm') ADVANCE(250);
      END_STATE();
    case 1474:
      if (lookahead == 'm') ADVANCE(1677);
      END_STATE();
    case 1475:
      if (lookahead == 'm') ADVANCE(1707);
      END_STATE();
    case 1476:
      if (lookahead == 'm') ADVANCE(1688);
      END_STATE();
    case 1477:
      if (lookahead == 'm') ADVANCE(1222);
      END_STATE();
    case 1478:
      if (lookahead == 'm') ADVANCE(1222);
      if (lookahead == 'p') ADVANCE(683);
      END_STATE();
    case 1479:
      if (lookahead == 'm') ADVANCE(1470);
      END_STATE();
    case 1480:
      if (lookahead == 'm') ADVANCE(258);
      END_STATE();
    case 1481:
      if (lookahead == 'm') ADVANCE(1711);
      END_STATE();
    case 1482:
      if (lookahead == 'm') ADVANCE(259);
      END_STATE();
    case 1483:
      if (lookahead == 'm') ADVANCE(572);
      END_STATE();
    case 1484:
      if (lookahead == 'm') ADVANCE(996);
      END_STATE();
    case 1485:
      if (lookahead == 'm') ADVANCE(1358);
      END_STATE();
    case 1486:
      if (lookahead == 'm') ADVANCE(1504);
      END_STATE();
    case 1487:
      if (lookahead == 'm') ADVANCE(926);
      END_STATE();
    case 1488:
      if (lookahead == 'm') ADVANCE(1703);
      END_STATE();
    case 1489:
      if (lookahead == 'm') ADVANCE(1698);
      END_STATE();
    case 1490:
      if (lookahead == 'm') ADVANCE(688);
      END_STATE();
    case 1491:
      if (lookahead == 'm') ADVANCE(560);
      END_STATE();
    case 1492:
      if (lookahead == 'm') ADVANCE(567);
      if (lookahead == 'p') ADVANCE(278);
      END_STATE();
    case 1493:
      if (lookahead == 'm') ADVANCE(959);
      END_STATE();
    case 1494:
      if (lookahead == 'm') ADVANCE(959);
      if (lookahead == 'x') ADVANCE(993);
      END_STATE();
    case 1495:
      if (lookahead == 'm') ADVANCE(556);
      END_STATE();
    case 1496:
      if (lookahead == 'm') ADVANCE(540);
      END_STATE();
    case 1497:
      if (lookahead == 'm') ADVANCE(993);
      END_STATE();
    case 1498:
      if (lookahead == 'm') ADVANCE(1719);
      END_STATE();
    case 1499:
      if (lookahead == 'm') ADVANCE(979);
      END_STATE();
    case 1500:
      if (lookahead == 'm') ADVANCE(1491);
      END_STATE();
    case 1501:
      if (lookahead == 'm') ADVANCE(1315);
      END_STATE();
    case 1502:
      if (lookahead == 'm') ADVANCE(682);
      END_STATE();
    case 1503:
      if (lookahead == 'n') ADVANCE(881);
      END_STATE();
    case 1504:
      if (lookahead == 'n') ADVANCE(152);
      END_STATE();
    case 1505:
      if (lookahead == 'n') ADVANCE(280);
      END_STATE();
    case 1506:
      if (lookahead == 'n') ADVANCE(422);
      END_STATE();
    case 1507:
      if (lookahead == 'n') ADVANCE(514);
      END_STATE();
    case 1508:
      if (lookahead == 'n') ADVANCE(696);
      END_STATE();
    case 1509:
      if (lookahead == 'n') ADVANCE(242);
      END_STATE();
    case 1510:
      if (lookahead == 'n') ADVANCE(840);
      END_STATE();
    case 1511:
      if (lookahead == 'n') ADVANCE(2160);
      END_STATE();
    case 1512:
      if (lookahead == 'n') ADVANCE(170);
      END_STATE();
    case 1513:
      if (lookahead == 'n') ADVANCE(521);
      END_STATE();
    case 1514:
      if (lookahead == 'n') ADVANCE(525);
      END_STATE();
    case 1515:
      if (lookahead == 'n') ADVANCE(188);
      END_STATE();
    case 1516:
      if (lookahead == 'n') ADVANCE(1958);
      END_STATE();
    case 1517:
      if (lookahead == 'n') ADVANCE(436);
      END_STATE();
    case 1518:
      if (lookahead == 'n') ADVANCE(487);
      END_STATE();
    case 1519:
      if (lookahead == 'n') ADVANCE(243);
      END_STATE();
    case 1520:
      if (lookahead == 'n') ADVANCE(2136);
      END_STATE();
    case 1521:
      if (lookahead == 'n') ADVANCE(416);
      END_STATE();
    case 1522:
      if (lookahead == 'n') ADVANCE(1118);
      END_STATE();
    case 1523:
      if (lookahead == 'n') ADVANCE(916);
      END_STATE();
    case 1524:
      if (lookahead == 'n') ADVANCE(250);
      END_STATE();
    case 1525:
      if (lookahead == 'n') ADVANCE(1120);
      END_STATE();
    case 1526:
      if (lookahead == 'n') ADVANCE(1120);
      if (lookahead == 'r') ADVANCE(1750);
      END_STATE();
    case 1527:
      if (lookahead == 'n') ADVANCE(2018);
      END_STATE();
    case 1528:
      if (lookahead == 'n') ADVANCE(1126);
      if (lookahead == 'p') ADVANCE(1096);
      if (lookahead == 'w') ADVANCE(1027);
      END_STATE();
    case 1529:
      if (lookahead == 'n') ADVANCE(355);
      END_STATE();
    case 1530:
      if (lookahead == 'n') ADVANCE(1339);
      END_STATE();
    case 1531:
      if (lookahead == 'n') ADVANCE(258);
      END_STATE();
    case 1532:
      if (lookahead == 'n') ADVANCE(1903);
      END_STATE();
    case 1533:
      if (lookahead == 'n') ADVANCE(889);
      END_STATE();
    case 1534:
      if (lookahead == 'n') ADVANCE(253);
      END_STATE();
    case 1535:
      if (lookahead == 'n') ADVANCE(1150);
      if (lookahead == 'r') ADVANCE(1007);
      END_STATE();
    case 1536:
      if (lookahead == 'n') ADVANCE(846);
      END_STATE();
    case 1537:
      if (lookahead == 'n') ADVANCE(1166);
      END_STATE();
    case 1538:
      if (lookahead == 'n') ADVANCE(926);
      END_STATE();
    case 1539:
      if (lookahead == 'n') ADVANCE(1124);
      END_STATE();
    case 1540:
      if (lookahead == 'n') ADVANCE(874);
      END_STATE();
    case 1541:
      if (lookahead == 'n') ADVANCE(1634);
      END_STATE();
    case 1542:
      if (lookahead == 'n') ADVANCE(1152);
      END_STATE();
    case 1543:
      if (lookahead == 'n') ADVANCE(899);
      END_STATE();
    case 1544:
      if (lookahead == 'n') ADVANCE(1179);
      END_STATE();
    case 1545:
      if (lookahead == 'n') ADVANCE(957);
      END_STATE();
    case 1546:
      if (lookahead == 'n') ADVANCE(1127);
      END_STATE();
    case 1547:
      if (lookahead == 'n') ADVANCE(869);
      END_STATE();
    case 1548:
      if (lookahead == 'n') ADVANCE(2036);
      END_STATE();
    case 1549:
      if (lookahead == 'n') ADVANCE(1969);
      END_STATE();
    case 1550:
      if (lookahead == 'n') ADVANCE(1983);
      END_STATE();
    case 1551:
      if (lookahead == 'n') ADVANCE(2008);
      END_STATE();
    case 1552:
      if (lookahead == 'n') ADVANCE(2010);
      END_STATE();
    case 1553:
      if (lookahead == 'n') ADVANCE(988);
      END_STATE();
    case 1554:
      if (lookahead == 'n') ADVANCE(991);
      END_STATE();
    case 1555:
      if (lookahead == 'n') ADVANCE(1428);
      END_STATE();
    case 1556:
      if (lookahead == 'n') ADVANCE(2067);
      END_STATE();
    case 1557:
      if (lookahead == 'n') ADVANCE(207);
      END_STATE();
    case 1558:
      if (lookahead == 'n') ADVANCE(1145);
      END_STATE();
    case 1559:
      if (lookahead == 'n') ADVANCE(1148);
      END_STATE();
    case 1560:
      if (lookahead == 'n') ADVANCE(1073);
      END_STATE();
    case 1561:
      if (lookahead == 'n') ADVANCE(1258);
      END_STATE();
    case 1562:
      if (lookahead == 'n') ADVANCE(2026);
      END_STATE();
    case 1563:
      if (lookahead == 'n') ADVANCE(2065);
      END_STATE();
    case 1564:
      if (lookahead == 'n') ADVANCE(1639);
      END_STATE();
    case 1565:
      if (lookahead == 'n') ADVANCE(2027);
      END_STATE();
    case 1566:
      if (lookahead == 'n') ADVANCE(1235);
      END_STATE();
    case 1567:
      if (lookahead == 'n') ADVANCE(2025);
      END_STATE();
    case 1568:
      if (lookahead == 'n') ADVANCE(2045);
      END_STATE();
    case 1569:
      if (lookahead == 'n') ADVANCE(656);
      END_STATE();
    case 1570:
      if (lookahead == 'n') ADVANCE(2037);
      END_STATE();
    case 1571:
      if (lookahead == 'n') ADVANCE(1171);
      END_STATE();
    case 1572:
      if (lookahead == 'n') ADVANCE(2035);
      END_STATE();
    case 1573:
      if (lookahead == 'n') ADVANCE(1314);
      END_STATE();
    case 1574:
      if (lookahead == 'n') ADVANCE(1076);
      END_STATE();
    case 1575:
      if (lookahead == 'n') ADVANCE(1173);
      if (lookahead == 'r') ADVANCE(1853);
      END_STATE();
    case 1576:
      if (lookahead == 'n') ADVANCE(1173);
      if (lookahead == 'r') ADVANCE(1857);
      END_STATE();
    case 1577:
      if (lookahead == 'n') ADVANCE(2039);
      END_STATE();
    case 1578:
      if (lookahead == 'n') ADVANCE(1174);
      END_STATE();
    case 1579:
      if (lookahead == 'n') ADVANCE(1175);
      END_STATE();
    case 1580:
      if (lookahead == 'n') ADVANCE(2041);
      END_STATE();
    case 1581:
      if (lookahead == 'n') ADVANCE(1176);
      END_STATE();
    case 1582:
      if (lookahead == 'n') ADVANCE(1177);
      END_STATE();
    case 1583:
      if (lookahead == 'n') ADVANCE(1178);
      END_STATE();
    case 1584:
      if (lookahead == 'n') ADVANCE(2046);
      END_STATE();
    case 1585:
      if (lookahead == 'n') ADVANCE(705);
      END_STATE();
    case 1586:
      if (lookahead == 'n') ADVANCE(694);
      END_STATE();
    case 1587:
      if (lookahead == 'o') ADVANCE(881);
      END_STATE();
    case 1588:
      if (lookahead == 'o') ADVANCE(152);
      END_STATE();
    case 1589:
      if (lookahead == 'o') ADVANCE(330);
      END_STATE();
    case 1590:
      if (lookahead == 'o') ADVANCE(1096);
      END_STATE();
    case 1591:
      if (lookahead == 'o') ADVANCE(2127);
      END_STATE();
    case 1592:
      if (lookahead == 'o') ADVANCE(526);
      END_STATE();
    case 1593:
      if (lookahead == 'o') ADVANCE(2106);
      END_STATE();
    case 1594:
      if (lookahead == 'o') ADVANCE(247);
      END_STATE();
    case 1595:
      if (lookahead == 'o') ADVANCE(1960);
      END_STATE();
    case 1596:
      if (lookahead == 'o') ADVANCE(1959);
      END_STATE();
    case 1597:
      if (lookahead == 'o') ADVANCE(1750);
      END_STATE();
    case 1598:
      if (lookahead == 'o') ADVANCE(1958);
      END_STATE();
    case 1599:
      if (lookahead == 'o') ADVANCE(1958);
      if (lookahead == 's') ADVANCE(2059);
      END_STATE();
    case 1600:
      if (lookahead == 'o') ADVANCE(310);
      END_STATE();
    case 1601:
      if (lookahead == 'o') ADVANCE(2138);
      END_STATE();
    case 1602:
      if (lookahead == 'o') ADVANCE(829);
      END_STATE();
    case 1603:
      if (lookahead == 'o') ADVANCE(2136);
      END_STATE();
    case 1604:
      if (lookahead == 'o') ADVANCE(1929);
      END_STATE();
    case 1605:
      if (lookahead == 'o') ADVANCE(346);
      END_STATE();
    case 1606:
      if (lookahead == 'o') ADVANCE(2116);
      END_STATE();
    case 1607:
      if (lookahead == 'o') ADVANCE(2156);
      END_STATE();
    case 1608:
      if (lookahead == 'o') ADVANCE(1677);
      END_STATE();
    case 1609:
      if (lookahead == 'o') ADVANCE(1566);
      END_STATE();
    case 1610:
      if (lookahead == 'o') ADVANCE(2117);
      END_STATE();
    case 1611:
      if (lookahead == 'o') ADVANCE(2118);
      END_STATE();
    case 1612:
      if (lookahead == 'o') ADVANCE(1463);
      END_STATE();
    case 1613:
      if (lookahead == 'o') ADVANCE(1339);
      END_STATE();
    case 1614:
      if (lookahead == 'o') ADVANCE(2013);
      END_STATE();
    case 1615:
      if (lookahead == 'o') ADVANCE(2119);
      END_STATE();
    case 1616:
      if (lookahead == 'o') ADVANCE(2132);
      END_STATE();
    case 1617:
      if (lookahead == 'o') ADVANCE(1903);
      END_STATE();
    case 1618:
      if (lookahead == 'o') ADVANCE(1525);
      END_STATE();
    case 1619:
      if (lookahead == 'o') ADVANCE(1525);
      if (lookahead == 'y') ADVANCE(152);
      END_STATE();
    case 1620:
      if (lookahead == 'o') ADVANCE(2133);
      END_STATE();
    case 1621:
      if (lookahead == 'o') ADVANCE(2125);
      END_STATE();
    case 1622:
      if (lookahead == 'o') ADVANCE(2120);
      END_STATE();
    case 1623:
      if (lookahead == 'o') ADVANCE(1358);
      if (lookahead == 'u') ADVANCE(718);
      END_STATE();
    case 1624:
      if (lookahead == 'o') ADVANCE(904);
      END_STATE();
    case 1625:
      if (lookahead == 'o') ADVANCE(1532);
      END_STATE();
    case 1626:
      if (lookahead == 'o') ADVANCE(2123);
      END_STATE();
    case 1627:
      if (lookahead == 'o') ADVANCE(1964);
      END_STATE();
    case 1628:
      if (lookahead == 'o') ADVANCE(1804);
      END_STATE();
    case 1629:
      if (lookahead == 'o') ADVANCE(1504);
      END_STATE();
    case 1630:
      if (lookahead == 'o') ADVANCE(1504);
      if (lookahead == 'r') ADVANCE(564);
      if (lookahead == 't') ADVANCE(152);
      END_STATE();
    case 1631:
      if (lookahead == 'o') ADVANCE(1524);
      END_STATE();
    case 1632:
      if (lookahead == 'o') ADVANCE(1560);
      END_STATE();
    case 1633:
      if (lookahead == 'o') ADVANCE(1515);
      END_STATE();
    case 1634:
      if (lookahead == 'o') ADVANCE(2102);
      END_STATE();
    case 1635:
      if (lookahead == 'o') ADVANCE(1503);
      END_STATE();
    case 1636:
      if (lookahead == 'o') ADVANCE(1531);
      END_STATE();
    case 1637:
      if (lookahead == 'o') ADVANCE(2104);
      END_STATE();
    case 1638:
      if (lookahead == 'o') ADVANCE(1597);
      END_STATE();
    case 1639:
      if (lookahead == 'o') ADVANCE(2050);
      END_STATE();
    case 1640:
      if (lookahead == 'o') ADVANCE(1357);
      END_STATE();
    case 1641:
      if (lookahead == 'o') ADVANCE(828);
      END_STATE();
    case 1642:
      if (lookahead == 'o') ADVANCE(1999);
      END_STATE();
    case 1643:
      if (lookahead == 'o') ADVANCE(2001);
      END_STATE();
    case 1644:
      if (lookahead == 'o') ADVANCE(2043);
      END_STATE();
    case 1645:
      if (lookahead == 'o') ADVANCE(1555);
      END_STATE();
    case 1646:
      if (lookahead == 'o') ADVANCE(1557);
      END_STATE();
    case 1647:
      if (lookahead == 'o') ADVANCE(1523);
      END_STATE();
    case 1648:
      if (lookahead == 'o') ADVANCE(1816);
      if (lookahead == 'r') ADVANCE(1608);
      END_STATE();
    case 1649:
      if (lookahead == 'o') ADVANCE(1841);
      END_STATE();
    case 1650:
      if (lookahead == 'o') ADVANCE(1843);
      if (lookahead == 'r') ADVANCE(1608);
      END_STATE();
    case 1651:
      if (lookahead == 'o') ADVANCE(1767);
      END_STATE();
    case 1652:
      if (lookahead == 'o') ADVANCE(2128);
      END_STATE();
    case 1653:
      if (lookahead == 'o') ADVANCE(1479);
      END_STATE();
    case 1654:
      if (lookahead == 'o') ADVANCE(1479);
      if (lookahead == 'y') ADVANCE(152);
      END_STATE();
    case 1655:
      if (lookahead == 'o') ADVANCE(1822);
      END_STATE();
    case 1656:
      if (lookahead == 'o') ADVANCE(1706);
      END_STATE();
    case 1657:
      if (lookahead == 'o') ADVANCE(1717);
      END_STATE();
    case 1658:
      if (lookahead == 'o') ADVANCE(2086);
      END_STATE();
    case 1659:
      if (lookahead == 'o') ADVANCE(2134);
      END_STATE();
    case 1660:
      if (lookahead == 'o') ADVANCE(2129);
      END_STATE();
    case 1661:
      if (lookahead == 'o') ADVANCE(2092);
      END_STATE();
    case 1662:
      if (lookahead == 'o') ADVANCE(2007);
      END_STATE();
    case 1663:
      if (lookahead == 'o') ADVANCE(1559);
      if (lookahead == 'u') ADVANCE(1697);
      END_STATE();
    case 1664:
      if (lookahead == 'o') ADVANCE(2130);
      END_STATE();
    case 1665:
      if (lookahead == 'o') ADVANCE(1572);
      END_STATE();
    case 1666:
      if (lookahead == 'o') ADVANCE(1837);
      END_STATE();
    case 1667:
      if (lookahead == 'o') ADVANCE(1645);
      END_STATE();
    case 1668:
      if (lookahead == 'o') ADVANCE(1818);
      END_STATE();
    case 1669:
      if (lookahead == 'o') ADVANCE(1551);
      END_STATE();
    case 1670:
      if (lookahead == 'o') ADVANCE(1625);
      END_STATE();
    case 1671:
      if (lookahead == 'o') ADVANCE(1647);
      END_STATE();
    case 1672:
      if (lookahead == 'o') ADVANCE(1883);
      END_STATE();
    case 1673:
      if (lookahead == 'o') ADVANCE(1454);
      END_STATE();
    case 1674:
      if (lookahead == 'o') ADVANCE(2107);
      END_STATE();
    case 1675:
      if (lookahead == 'o') ADVANCE(2135);
      END_STATE();
    case 1676:
      if (lookahead == 'p') ADVANCE(1954);
      END_STATE();
    case 1677:
      if (lookahead == 'p') ADVANCE(152);
      END_STATE();
    case 1678:
      if (lookahead == 'p') ADVANCE(152);
      if (lookahead == 'r') ADVANCE(1629);
      END_STATE();
    case 1679:
      if (lookahead == 'p') ADVANCE(1186);
      END_STATE();
    case 1680:
      if (lookahead == 'p') ADVANCE(1096);
      END_STATE();
    case 1681:
      if (lookahead == 'p') ADVANCE(1096);
      if (lookahead == 'r') ADVANCE(675);
      END_STATE();
    case 1682:
      if (lookahead == 'p') ADVANCE(1096);
      if (lookahead == 'r') ADVANCE(414);
      if (lookahead == 'u') ADVANCE(1834);
      END_STATE();
    case 1683:
      if (lookahead == 'p') ADVANCE(1096);
      if (lookahead == 'r') ADVANCE(1228);
      END_STATE();
    case 1684:
      if (lookahead == 'p') ADVANCE(1096);
      if (lookahead == 't') ADVANCE(165);
      if (lookahead == 'u') ADVANCE(743);
      if (lookahead == 'w') ADVANCE(1506);
      END_STATE();
    case 1685:
      if (lookahead == 'p') ADVANCE(1096);
      if (lookahead == 't') ADVANCE(354);
      if (lookahead == 'w') ADVANCE(2019);
      if (lookahead == 'x') ADVANCE(449);
      END_STATE();
    case 1686:
      if (lookahead == 'p') ADVANCE(1096);
      if (lookahead == 'u') ADVANCE(1533);
      END_STATE();
    case 1687:
      if (lookahead == 'p') ADVANCE(164);
      END_STATE();
    case 1688:
      if (lookahead == 'p') ADVANCE(458);
      END_STATE();
    case 1689:
      if (lookahead == 'p') ADVANCE(171);
      END_STATE();
    case 1690:
      if (lookahead == 'p') ADVANCE(145);
      END_STATE();
    case 1691:
      if (lookahead == 'p') ADVANCE(459);
      END_STATE();
    case 1692:
      if (lookahead == 'p') ADVANCE(417);
      END_STATE();
    case 1693:
      if (lookahead == 'p') ADVANCE(1750);
      if (lookahead == 's') ADVANCE(762);
      END_STATE();
    case 1694:
      if (lookahead == 'p') ADVANCE(532);
      END_STATE();
    case 1695:
      if (lookahead == 'p') ADVANCE(324);
      END_STATE();
    case 1696:
      if (lookahead == 'p') ADVANCE(416);
      END_STATE();
    case 1697:
      if (lookahead == 'p') ADVANCE(432);
      END_STATE();
    case 1698:
      if (lookahead == 'p') ADVANCE(250);
      END_STATE();
    case 1699:
      if (lookahead == 'p') ADVANCE(334);
      END_STATE();
    case 1700:
      if (lookahead == 'p') ADVANCE(1183);
      if (lookahead == 't') ADVANCE(152);
      END_STATE();
    case 1701:
      if (lookahead == 'p') ADVANCE(1694);
      END_STATE();
    case 1702:
      if (lookahead == 'p') ADVANCE(1903);
      if (lookahead == 'r') ADVANCE(1629);
      END_STATE();
    case 1703:
      if (lookahead == 'p') ADVANCE(259);
      END_STATE();
    case 1704:
      if (lookahead == 'p') ADVANCE(1369);
      END_STATE();
    case 1705:
      if (lookahead == 'p') ADVANCE(1714);
      END_STATE();
    case 1706:
      if (lookahead == 'p') ADVANCE(926);
      END_STATE();
    case 1707:
      if (lookahead == 'p') ADVANCE(973);
      END_STATE();
    case 1708:
      if (lookahead == 'p') ADVANCE(1448);
      END_STATE();
    case 1709:
      if (lookahead == 'p') ADVANCE(1448);
      if (lookahead == 't') ADVANCE(1785);
      END_STATE();
    case 1710:
      if (lookahead == 'p') ADVANCE(1926);
      END_STATE();
    case 1711:
      if (lookahead == 'p') ADVANCE(1998);
      END_STATE();
    case 1712:
      if (lookahead == 'p') ADVANCE(1724);
      END_STATE();
    case 1713:
      if (lookahead == 'p') ADVANCE(1724);
      if (lookahead == 'r') ADVANCE(1750);
      END_STATE();
    case 1714:
      if (lookahead == 'p') ADVANCE(552);
      END_STATE();
    case 1715:
      if (lookahead == 'p') ADVANCE(1667);
      END_STATE();
    case 1716:
      if (lookahead == 'p') ADVANCE(1450);
      END_STATE();
    case 1717:
      if (lookahead == 'p') ADVANCE(1989);
      END_STATE();
    case 1718:
      if (lookahead == 'p') ADVANCE(1617);
      END_STATE();
    case 1719:
      if (lookahead == 'p') ADVANCE(1414);
      END_STATE();
    case 1720:
      if (lookahead == 'p') ADVANCE(672);
      END_STATE();
    case 1721:
      if (lookahead == 'p') ADVANCE(1944);
      END_STATE();
    case 1722:
      if (lookahead == 'p') ADVANCE(1849);
      if (lookahead == 's') ADVANCE(2077);
      END_STATE();
    case 1723:
      if (lookahead == 'p') ADVANCE(1426);
      END_STATE();
    case 1724:
      if (lookahead == 'p') ADVANCE(1829);
      END_STATE();
    case 1725:
      if (lookahead == 'p') ADVANCE(654);
      END_STATE();
    case 1726:
      if (lookahead == 'p') ADVANCE(703);
      END_STATE();
    case 1727:
      if (lookahead == 'p') ADVANCE(470);
      END_STATE();
    case 1728:
      if (lookahead == 'p') ADVANCE(1671);
      END_STATE();
    case 1729:
      if (lookahead == 'p') ADVANCE(687);
      END_STATE();
    case 1730:
      if (lookahead == 'p') ADVANCE(1670);
      END_STATE();
    case 1731:
      if (lookahead == 'p') ADVANCE(705);
      END_STATE();
    case 1732:
      if (lookahead == 'q') ADVANCE(152);
      END_STATE();
    case 1733:
      if (lookahead == 'q') ADVANCE(240);
      END_STATE();
    case 1734:
      if (lookahead == 'q') ADVANCE(1419);
      END_STATE();
    case 1735:
      if (lookahead == 'q') ADVANCE(1157);
      END_STATE();
    case 1736:
      if (lookahead == 'q') ADVANCE(1722);
      END_STATE();
    case 1737:
      if (lookahead == 'q') ADVANCE(325);
      END_STATE();
    case 1738:
      if (lookahead == 'q') ADVANCE(1732);
      END_STATE();
    case 1739:
      if (lookahead == 'q') ADVANCE(2053);
      END_STATE();
    case 1740:
      if (lookahead == 'q') ADVANCE(2072);
      END_STATE();
    case 1741:
      if (lookahead == 'q') ADVANCE(2105);
      if (lookahead == 'u') ADVANCE(741);
      END_STATE();
    case 1742:
      if (lookahead == 'q') ADVANCE(2093);
      END_STATE();
    case 1743:
      if (lookahead == 'q') ADVANCE(2082);
      END_STATE();
    case 1744:
      if (lookahead == 'q') ADVANCE(847);
      if (lookahead == 't') ADVANCE(546);
      END_STATE();
    case 1745:
      if (lookahead == 'q') ADVANCE(2096);
      END_STATE();
    case 1746:
      if (lookahead == 'q') ADVANCE(2100);
      END_STATE();
    case 1747:
      if (lookahead == 'q') ADVANCE(2103);
      END_STATE();
    case 1748:
      if (lookahead == 'r') ADVANCE(881);
      END_STATE();
    case 1749:
      if (lookahead == 'r') ADVANCE(935);
      END_STATE();
    case 1750:
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 1751:
      if (lookahead == 'r') ADVANCE(439);
      END_STATE();
    case 1752:
      if (lookahead == 'r') ADVANCE(309);
      END_STATE();
    case 1753:
      if (lookahead == 'r') ADVANCE(1096);
      END_STATE();
    case 1754:
      if (lookahead == 'r') ADVANCE(228);
      END_STATE();
    case 1755:
      if (lookahead == 'r') ADVANCE(322);
      END_STATE();
    case 1756:
      if (lookahead == 'r') ADVANCE(199);
      END_STATE();
    case 1757:
      if (lookahead == 'r') ADVANCE(805);
      END_STATE();
    case 1758:
      if (lookahead == 'r') ADVANCE(423);
      END_STATE();
    case 1759:
      if (lookahead == 'r') ADVANCE(2168);
      END_STATE();
    case 1760:
      if (lookahead == 'r') ADVANCE(274);
      END_STATE();
    case 1761:
      if (lookahead == 'r') ADVANCE(224);
      END_STATE();
    case 1762:
      if (lookahead == 'r') ADVANCE(1196);
      END_STATE();
    case 1763:
      if (lookahead == 'r') ADVANCE(200);
      END_STATE();
    case 1764:
      if (lookahead == 'r') ADVANCE(496);
      END_STATE();
    case 1765:
      if (lookahead == 'r') ADVANCE(364);
      END_STATE();
    case 1766:
      if (lookahead == 'r') ADVANCE(2172);
      END_STATE();
    case 1767:
      if (lookahead == 'r') ADVANCE(157);
      END_STATE();
    case 1768:
      if (lookahead == 'r') ADVANCE(175);
      END_STATE();
    case 1769:
      if (lookahead == 'r') ADVANCE(1750);
      END_STATE();
    case 1770:
      if (lookahead == 'r') ADVANCE(315);
      END_STATE();
    case 1771:
      if (lookahead == 'r') ADVANCE(478);
      END_STATE();
    case 1772:
      if (lookahead == 'r') ADVANCE(755);
      END_STATE();
    case 1773:
      if (lookahead == 'r') ADVANCE(358);
      END_STATE();
    case 1774:
      if (lookahead == 'r') ADVANCE(282);
      END_STATE();
    case 1775:
      if (lookahead == 'r') ADVANCE(1958);
      END_STATE();
    case 1776:
      if (lookahead == 'r') ADVANCE(1958);
      if (lookahead == 'u') ADVANCE(689);
      END_STATE();
    case 1777:
      if (lookahead == 'r') ADVANCE(243);
      END_STATE();
    case 1778:
      if (lookahead == 'r') ADVANCE(908);
      END_STATE();
    case 1779:
      if (lookahead == 'r') ADVANCE(218);
      END_STATE();
    case 1780:
      if (lookahead == 'r') ADVANCE(227);
      END_STATE();
    case 1781:
      if (lookahead == 'r') ADVANCE(214);
      END_STATE();
    case 1782:
      if (lookahead == 'r') ADVANCE(490);
      END_STATE();
    case 1783:
      if (lookahead == 'r') ADVANCE(754);
      END_STATE();
    case 1784:
      if (lookahead == 'r') ADVANCE(583);
      END_STATE();
    case 1785:
      if (lookahead == 'r') ADVANCE(1223);
      END_STATE();
    case 1786:
      if (lookahead == 'r') ADVANCE(317);
      END_STATE();
    case 1787:
      if (lookahead == 'r') ADVANCE(300);
      END_STATE();
    case 1788:
      if (lookahead == 'r') ADVANCE(306);
      END_STATE();
    case 1789:
      if (lookahead == 'r') ADVANCE(884);
      END_STATE();
    case 1790:
      if (lookahead == 'r') ADVANCE(876);
      END_STATE();
    case 1791:
      if (lookahead == 'r') ADVANCE(1588);
      END_STATE();
    case 1792:
      if (lookahead == 'r') ADVANCE(311);
      END_STATE();
    case 1793:
      if (lookahead == 'r') ADVANCE(1349);
      END_STATE();
    case 1794:
      if (lookahead == 'r') ADVANCE(340);
      END_STATE();
    case 1795:
      if (lookahead == 'r') ADVANCE(435);
      END_STATE();
    case 1796:
      if (lookahead == 'r') ADVANCE(351);
      END_STATE();
    case 1797:
      if (lookahead == 'r') ADVANCE(866);
      END_STATE();
    case 1798:
      if (lookahead == 'r') ADVANCE(1677);
      END_STATE();
    case 1799:
      if (lookahead == 'r') ADVANCE(1003);
      END_STATE();
    case 1800:
      if (lookahead == 'r') ADVANCE(2018);
      END_STATE();
    case 1801:
      if (lookahead == 'r') ADVANCE(314);
      END_STATE();
    case 1802:
      if (lookahead == 'r') ADVANCE(537);
      END_STATE();
    case 1803:
      if (lookahead == 'r') ADVANCE(1629);
      END_STATE();
    case 1804:
      if (lookahead == 'r') ADVANCE(1339);
      END_STATE();
    case 1805:
      if (lookahead == 'r') ADVANCE(2146);
      END_STATE();
    case 1806:
      if (lookahead == 'r') ADVANCE(2148);
      END_STATE();
    case 1807:
      if (lookahead == 'r') ADVANCE(1592);
      if (lookahead == 't') ADVANCE(532);
      END_STATE();
    case 1808:
      if (lookahead == 'r') ADVANCE(1903);
      END_STATE();
    case 1809:
      if (lookahead == 'r') ADVANCE(996);
      END_STATE();
    case 1810:
      if (lookahead == 'r') ADVANCE(1587);
      END_STATE();
    case 1811:
      if (lookahead == 'r') ADVANCE(564);
      END_STATE();
    case 1812:
      if (lookahead == 'r') ADVANCE(2124);
      END_STATE();
    case 1813:
      if (lookahead == 'r') ADVANCE(2147);
      END_STATE();
    case 1814:
      if (lookahead == 'r') ADVANCE(1054);
      END_STATE();
    case 1815:
      if (lookahead == 'r') ADVANCE(1195);
      END_STATE();
    case 1816:
      if (lookahead == 'r') ADVANCE(1504);
      END_STATE();
    case 1817:
      if (lookahead == 'r') ADVANCE(762);
      END_STATE();
    case 1818:
      if (lookahead == 'r') ADVANCE(926);
      END_STATE();
    case 1819:
      if (lookahead == 'r') ADVANCE(1608);
      END_STATE();
    case 1820:
      if (lookahead == 'r') ADVANCE(1300);
      END_STATE();
    case 1821:
      if (lookahead == 'r') ADVANCE(1613);
      END_STATE();
    case 1822:
      if (lookahead == 'r') ADVANCE(1966);
      END_STATE();
    case 1823:
      if (lookahead == 'r') ADVANCE(1601);
      END_STATE();
    case 1824:
      if (lookahead == 'r') ADVANCE(1923);
      END_STATE();
    case 1825:
      if (lookahead == 'r') ADVANCE(835);
      END_STATE();
    case 1826:
      if (lookahead == 'r') ADVANCE(1606);
      END_STATE();
    case 1827:
      if (lookahead == 'r') ADVANCE(1759);
      END_STATE();
    case 1828:
      if (lookahead == 'r') ADVANCE(600);
      END_STATE();
    case 1829:
      if (lookahead == 'r') ADVANCE(1603);
      END_STATE();
    case 1830:
      if (lookahead == 'r') ADVANCE(2036);
      END_STATE();
    case 1831:
      if (lookahead == 'r') ADVANCE(1715);
      END_STATE();
    case 1832:
      if (lookahead == 'r') ADVANCE(2029);
      END_STATE();
    case 1833:
      if (lookahead == 'r') ADVANCE(1945);
      END_STATE();
    case 1834:
      if (lookahead == 'r') ADVANCE(1309);
      END_STATE();
    case 1835:
      if (lookahead == 'r') ADVANCE(1953);
      END_STATE();
    case 1836:
      if (lookahead == 'r') ADVANCE(978);
      if (lookahead == 't') ADVANCE(532);
      END_STATE();
    case 1837:
      if (lookahead == 'r') ADVANCE(1982);
      END_STATE();
    case 1838:
      if (lookahead == 'r') ADVANCE(603);
      END_STATE();
    case 1839:
      if (lookahead == 'r') ADVANCE(1271);
      END_STATE();
    case 1840:
      if (lookahead == 'r') ADVANCE(1610);
      END_STATE();
    case 1841:
      if (lookahead == 'r') ADVANCE(1545);
      END_STATE();
    case 1842:
      if (lookahead == 'r') ADVANCE(1931);
      END_STATE();
    case 1843:
      if (lookahead == 'r') ADVANCE(1534);
      END_STATE();
    case 1844:
      if (lookahead == 'r') ADVANCE(1249);
      END_STATE();
    case 1845:
      if (lookahead == 'r') ADVANCE(1573);
      END_STATE();
    case 1846:
      if (lookahead == 'r') ADVANCE(1397);
      END_STATE();
    case 1847:
      if (lookahead == 'r') ADVANCE(1306);
      END_STATE();
    case 1848:
      if (lookahead == 'r') ADVANCE(1401);
      END_STATE();
    case 1849:
      if (lookahead == 'r') ADVANCE(1001);
      END_STATE();
    case 1850:
      if (lookahead == 'r') ADVANCE(1611);
      END_STATE();
    case 1851:
      if (lookahead == 'r') ADVANCE(1962);
      END_STATE();
    case 1852:
      if (lookahead == 'r') ADVANCE(942);
      if (lookahead == 't') ADVANCE(563);
      END_STATE();
    case 1853:
      if (lookahead == 'r') ADVANCE(1615);
      END_STATE();
    case 1854:
      if (lookahead == 'r') ADVANCE(1616);
      END_STATE();
    case 1855:
      if (lookahead == 'r') ADVANCE(1620);
      END_STATE();
    case 1856:
      if (lookahead == 'r') ADVANCE(1621);
      END_STATE();
    case 1857:
      if (lookahead == 'r') ADVANCE(1622);
      END_STATE();
    case 1858:
      if (lookahead == 'r') ADVANCE(1094);
      END_STATE();
    case 1859:
      if (lookahead == 'r') ADVANCE(945);
      END_STATE();
    case 1860:
      if (lookahead == 'r') ADVANCE(1626);
      END_STATE();
    case 1861:
      if (lookahead == 'r') ADVANCE(1765);
      END_STATE();
    case 1862:
      if (lookahead == 'r') ADVANCE(1050);
      END_STATE();
    case 1863:
      if (lookahead == 'r') ADVANCE(1755);
      END_STATE();
    case 1864:
      if (lookahead == 'r') ADVANCE(1788);
      END_STATE();
    case 1865:
      if (lookahead == 'r') ADVANCE(1069);
      END_STATE();
    case 1866:
      if (lookahead == 'r') ADVANCE(971);
      END_STATE();
    case 1867:
      if (lookahead == 'r') ADVANCE(693);
      END_STATE();
    case 1868:
      if (lookahead == 'r') ADVANCE(608);
      END_STATE();
    case 1869:
      if (lookahead == 'r') ADVANCE(653);
      END_STATE();
    case 1870:
      if (lookahead == 'r') ADVANCE(1281);
      END_STATE();
    case 1871:
      if (lookahead == 'r') ADVANCE(1946);
      END_STATE();
    case 1872:
      if (lookahead == 'r') ADVANCE(847);
      END_STATE();
    case 1873:
      if (lookahead == 'r') ADVANCE(2026);
      END_STATE();
    case 1874:
      if (lookahead == 'r') ADVANCE(1017);
      END_STATE();
    case 1875:
      if (lookahead == 'r') ADVANCE(1147);
      if (lookahead == 'u') ADVANCE(152);
      END_STATE();
    case 1876:
      if (lookahead == 'r') ADVANCE(2009);
      END_STATE();
    case 1877:
      if (lookahead == 'r') ADVANCE(2071);
      END_STATE();
    case 1878:
      if (lookahead == 'r') ADVANCE(1948);
      END_STATE();
    case 1879:
      if (lookahead == 'r') ADVANCE(1024);
      END_STATE();
    case 1880:
      if (lookahead == 'r') ADVANCE(1041);
      END_STATE();
    case 1881:
      if (lookahead == 'r') ADVANCE(1826);
      END_STATE();
    case 1882:
      if (lookahead == 'r') ADVANCE(632);
      END_STATE();
    case 1883:
      if (lookahead == 'r') ADVANCE(2024);
      END_STATE();
    case 1884:
      if (lookahead == 'r') ADVANCE(1840);
      END_STATE();
    case 1885:
      if (lookahead == 'r') ADVANCE(1850);
      END_STATE();
    case 1886:
      if (lookahead == 'r') ADVANCE(1854);
      END_STATE();
    case 1887:
      if (lookahead == 'r') ADVANCE(1855);
      END_STATE();
    case 1888:
      if (lookahead == 'r') ADVANCE(1856);
      END_STATE();
    case 1889:
      if (lookahead == 'r') ADVANCE(1860);
      END_STATE();
    case 1890:
      if (lookahead == 'r') ADVANCE(1059);
      END_STATE();
    case 1891:
      if (lookahead == 'r') ADVANCE(871);
      END_STATE();
    case 1892:
      if (lookahead == 'r') ADVANCE(1082);
      END_STATE();
    case 1893:
      if (lookahead == 'r') ADVANCE(473);
      END_STATE();
    case 1894:
      if (lookahead == 'r') ADVANCE(1728);
      END_STATE();
    case 1895:
      if (lookahead == 'r') ADVANCE(2047);
      END_STATE();
    case 1896:
      if (lookahead == 'r') ADVANCE(1730);
      END_STATE();
    case 1897:
      if (lookahead == 'r') ADVANCE(1091);
      END_STATE();
    case 1898:
      if (lookahead == 'r') ADVANCE(1092);
      END_STATE();
    case 1899:
      if (lookahead == 'r') ADVANCE(1093);
      END_STATE();
    case 1900:
      if (lookahead == 'r') ADVANCE(1333);
      END_STATE();
    case 1901:
      if (lookahead == 'r') ADVANCE(1335);
      END_STATE();
    case 1902:
      if (lookahead == 'r') ADVANCE(1336);
      END_STATE();
    case 1903:
      if (lookahead == 's') ADVANCE(152);
      END_STATE();
    case 1904:
      if (lookahead == 's') ADVANCE(1051);
      END_STATE();
    case 1905:
      if (lookahead == 's') ADVANCE(322);
      if (lookahead == 'u') ADVANCE(1489);
      END_STATE();
    case 1906:
      if (lookahead == 's') ADVANCE(472);
      END_STATE();
    case 1907:
      if (lookahead == 's') ADVANCE(498);
      END_STATE();
    case 1908:
      if (lookahead == 's') ADVANCE(201);
      END_STATE();
    case 1909:
      if (lookahead == 's') ADVANCE(357);
      END_STATE();
    case 1910:
      if (lookahead == 's') ADVANCE(220);
      END_STATE();
    case 1911:
      if (lookahead == 's') ADVANCE(177);
      END_STATE();
    case 1912:
      if (lookahead == 's') ADVANCE(179);
      END_STATE();
    case 1913:
      if (lookahead == 's') ADVANCE(178);
      END_STATE();
    case 1914:
      if (lookahead == 's') ADVANCE(1958);
      END_STATE();
    case 1915:
      if (lookahead == 's') ADVANCE(492);
      END_STATE();
    case 1916:
      if (lookahead == 's') ADVANCE(1623);
      END_STATE();
    case 1917:
      if (lookahead == 's') ADVANCE(284);
      END_STATE();
    case 1918:
      if (lookahead == 's') ADVANCE(1223);
      END_STATE();
    case 1919:
      if (lookahead == 's') ADVANCE(506);
      END_STATE();
    case 1920:
      if (lookahead == 's') ADVANCE(346);
      END_STATE();
    case 1921:
      if (lookahead == 's') ADVANCE(250);
      END_STATE();
    case 1922:
      if (lookahead == 's') ADVANCE(205);
      END_STATE();
    case 1923:
      if (lookahead == 's') ADVANCE(1677);
      END_STATE();
    case 1924:
      if (lookahead == 's') ADVANCE(1183);
      END_STATE();
    case 1925:
      if (lookahead == 's') ADVANCE(2149);
      END_STATE();
    case 1926:
      if (lookahead == 's') ADVANCE(339);
      END_STATE();
    case 1927:
      if (lookahead == 's') ADVANCE(1184);
      END_STATE();
    case 1928:
      if (lookahead == 's') ADVANCE(1188);
      END_STATE();
    case 1929:
      if (lookahead == 's') ADVANCE(1903);
      END_STATE();
    case 1930:
      if (lookahead == 's') ADVANCE(1259);
      END_STATE();
    case 1931:
      if (lookahead == 's') ADVANCE(1358);
      END_STATE();
    case 1932:
      if (lookahead == 's') ADVANCE(2052);
      END_STATE();
    case 1933:
      if (lookahead == 's') ADVANCE(894);
      END_STATE();
    case 1934:
      if (lookahead == 's') ADVANCE(926);
      END_STATE();
    case 1935:
      if (lookahead == 's') ADVANCE(973);
      END_STATE();
    case 1936:
      if (lookahead == 's') ADVANCE(2101);
      END_STATE();
    case 1937:
      if (lookahead == 's') ADVANCE(2057);
      END_STATE();
    case 1938:
      if (lookahead == 's') ADVANCE(2003);
      END_STATE();
    case 1939:
      if (lookahead == 's') ADVANCE(1383);
      END_STATE();
    case 1940:
      if (lookahead == 's') ADVANCE(1915);
      END_STATE();
    case 1941:
      if (lookahead == 's') ADVANCE(1992);
      END_STATE();
    case 1942:
      if (lookahead == 's') ADVANCE(1996);
      END_STATE();
    case 1943:
      if (lookahead == 's') ADVANCE(1321);
      END_STATE();
    case 1944:
      if (lookahead == 's') ADVANCE(1989);
      END_STATE();
    case 1945:
      if (lookahead == 's') ADVANCE(1011);
      END_STATE();
    case 1946:
      if (lookahead == 's') ADVANCE(949);
      END_STATE();
    case 1947:
      if (lookahead == 's') ADVANCE(985);
      END_STATE();
    case 1948:
      if (lookahead == 's') ADVANCE(970);
      END_STATE();
    case 1949:
      if (lookahead == 's') ADVANCE(1193);
      END_STATE();
    case 1950:
      if (lookahead == 's') ADVANCE(2059);
      END_STATE();
    case 1951:
      if (lookahead == 's') ADVANCE(2014);
      END_STATE();
    case 1952:
      if (lookahead == 's') ADVANCE(2002);
      END_STATE();
    case 1953:
      if (lookahead == 's') ADVANCE(1016);
      END_STATE();
    case 1954:
      if (lookahead == 's') ADVANCE(1268);
      END_STATE();
    case 1955:
      if (lookahead == 's') ADVANCE(1031);
      END_STATE();
    case 1956:
      if (lookahead == 's') ADVANCE(1087);
      END_STATE();
    case 1957:
      if (lookahead == 't') ADVANCE(2139);
      END_STATE();
    case 1958:
      if (lookahead == 't') ADVANCE(152);
      END_STATE();
    case 1959:
      if (lookahead == 't') ADVANCE(152);
      if (lookahead == 'u') ADVANCE(751);
      END_STATE();
    case 1960:
      if (lookahead == 't') ADVANCE(152);
      if (lookahead == 'w') ADVANCE(1521);
      END_STATE();
    case 1961:
      if (lookahead == 't') ADVANCE(396);
      END_STATE();
    case 1962:
      if (lookahead == 't') ADVANCE(514);
      END_STATE();
    case 1963:
      if (lookahead == 't') ADVANCE(701);
      END_STATE();
    case 1964:
      if (lookahead == 't') ADVANCE(363);
      END_STATE();
    case 1965:
      if (lookahead == 't') ADVANCE(415);
      END_STATE();
    case 1966:
      if (lookahead == 't') ADVANCE(455);
      END_STATE();
    case 1967:
      if (lookahead == 't') ADVANCE(700);
      END_STATE();
    case 1968:
      if (lookahead == 't') ADVANCE(265);
      END_STATE();
    case 1969:
      if (lookahead == 't') ADVANCE(1156);
      END_STATE();
    case 1970:
      if (lookahead == 't') ADVANCE(510);
      END_STATE();
    case 1971:
      if (lookahead == 't') ADVANCE(521);
      END_STATE();
    case 1972:
      if (lookahead == 't') ADVANCE(418);
      END_STATE();
    case 1973:
      if (lookahead == 't') ADVANCE(421);
      END_STATE();
    case 1974:
      if (lookahead == 't') ADVANCE(525);
      END_STATE();
    case 1975:
      if (lookahead == 't') ADVANCE(708);
      END_STATE();
    case 1976:
      if (lookahead == 't') ADVANCE(419);
      END_STATE();
    case 1977:
      if (lookahead == 't') ADVANCE(420);
      END_STATE();
    case 1978:
      if (lookahead == 't') ADVANCE(1750);
      END_STATE();
    case 1979:
      if (lookahead == 't') ADVANCE(532);
      END_STATE();
    case 1980:
      if (lookahead == 't') ADVANCE(1008);
      END_STATE();
    case 1981:
      if (lookahead == 't') ADVANCE(174);
      END_STATE();
    case 1982:
      if (lookahead == 't') ADVANCE(1478);
      END_STATE();
    case 1983:
      if (lookahead == 't') ADVANCE(471);
      END_STATE();
    case 1984:
      if (lookahead == 't') ADVANCE(754);
      END_STATE();
    case 1985:
      if (lookahead == 't') ADVANCE(2140);
      END_STATE();
    case 1986:
      if (lookahead == 't') ADVANCE(256);
      if (lookahead == 'v') ADVANCE(1295);
      END_STATE();
    case 1987:
      if (lookahead == 't') ADVANCE(360);
      END_STATE();
    case 1988:
      if (lookahead == 't') ADVANCE(697);
      END_STATE();
    case 1989:
      if (lookahead == 't') ADVANCE(1588);
      END_STATE();
    case 1990:
      if (lookahead == 't') ADVANCE(416);
      END_STATE();
    case 1991:
      if (lookahead == 't') ADVANCE(1035);
      END_STATE();
    case 1992:
      if (lookahead == 't') ADVANCE(212);
      END_STATE();
    case 1993:
      if (lookahead == 't') ADVANCE(2144);
      END_STATE();
    case 1994:
      if (lookahead == 't') ADVANCE(250);
      END_STATE();
    case 1995:
      if (lookahead == 't') ADVANCE(522);
      END_STATE();
    case 1996:
      if (lookahead == 't') ADVANCE(334);
      END_STATE();
    case 1997:
      if (lookahead == 't') ADVANCE(1183);
      END_STATE();
    case 1998:
      if (lookahead == 't') ADVANCE(2145);
      END_STATE();
    case 1999:
      if (lookahead == 't') ADVANCE(313);
      END_STATE();
    case 2000:
      if (lookahead == 't') ADVANCE(1188);
      END_STATE();
    case 2001:
      if (lookahead == 't') ADVANCE(312);
      END_STATE();
    case 2002:
      if (lookahead == 't') ADVANCE(1903);
      END_STATE();
    case 2003:
      if (lookahead == 't') ADVANCE(259);
      END_STATE();
    case 2004:
      if (lookahead == 't') ADVANCE(264);
      END_STATE();
    case 2005:
      if (lookahead == 't') ADVANCE(1185);
      END_STATE();
    case 2006:
      if (lookahead == 't') ADVANCE(1486);
      END_STATE();
    case 2007:
      if (lookahead == 't') ADVANCE(926);
      END_STATE();
    case 2008:
      if (lookahead == 't') ADVANCE(1658);
      END_STATE();
    case 2009:
      if (lookahead == 't') ADVANCE(1909);
      END_STATE();
    case 2010:
      if (lookahead == 't') ADVANCE(1213);
      END_STATE();
    case 2011:
      if (lookahead == 't') ADVANCE(1501);
      END_STATE();
    case 2012:
      if (lookahead == 't') ADVANCE(957);
      END_STATE();
    case 2013:
      if (lookahead == 't') ADVANCE(1935);
      END_STATE();
    case 2014:
      if (lookahead == 't') ADVANCE(999);
      END_STATE();
    case 2015:
      if (lookahead == 't') ADVANCE(1597);
      END_STATE();
    case 2016:
      if (lookahead == 't') ADVANCE(1785);
      END_STATE();
    case 2017:
      if (lookahead == 't') ADVANCE(634);
      END_STATE();
    case 2018:
      if (lookahead == 't') ADVANCE(1294);
      END_STATE();
    case 2019:
      if (lookahead == 't') ADVANCE(1271);
      END_STATE();
    case 2020:
      if (lookahead == 't') ADVANCE(1305);
      END_STATE();
    case 2021:
      if (lookahead == 't') ADVANCE(1594);
      END_STATE();
    case 2022:
      if (lookahead == 't') ADVANCE(1296);
      END_STATE();
    case 2023:
      if (lookahead == 't') ADVANCE(1319);
      END_STATE();
    case 2024:
      if (lookahead == 't') ADVANCE(1313);
      END_STATE();
    case 2025:
      if (lookahead == 't') ADVANCE(1273);
      END_STATE();
    case 2026:
      if (lookahead == 't') ADVANCE(1753);
      END_STATE();
    case 2027:
      if (lookahead == 't') ADVANCE(1085);
      END_STATE();
    case 2028:
      if (lookahead == 't') ADVANCE(706);
      END_STATE();
    case 2029:
      if (lookahead == 't') ADVANCE(1553);
      END_STATE();
    case 2030:
      if (lookahead == 't') ADVANCE(1258);
      END_STATE();
    case 2031:
      if (lookahead == 't') ADVANCE(1651);
      END_STATE();
    case 2032:
      if (lookahead == 't') ADVANCE(1554);
      END_STATE();
    case 2033:
      if (lookahead == 't') ADVANCE(1838);
      END_STATE();
    case 2034:
      if (lookahead == 't') ADVANCE(1034);
      END_STATE();
    case 2035:
      if (lookahead == 't') ADVANCE(642);
      END_STATE();
    case 2036:
      if (lookahead == 't') ADVANCE(1235);
      END_STATE();
    case 2037:
      if (lookahead == 't') ADVANCE(1036);
      END_STATE();
    case 2038:
      if (lookahead == 't') ADVANCE(1038);
      END_STATE();
    case 2039:
      if (lookahead == 't') ADVANCE(1040);
      END_STATE();
    case 2040:
      if (lookahead == 't') ADVANCE(1043);
      END_STATE();
    case 2041:
      if (lookahead == 't') ADVANCE(1061);
      END_STATE();
    case 2042:
      if (lookahead == 't') ADVANCE(1045);
      END_STATE();
    case 2043:
      if (lookahead == 't') ADVANCE(1214);
      END_STATE();
    case 2044:
      if (lookahead == 't') ADVANCE(685);
      END_STATE();
    case 2045:
      if (lookahead == 't') ADVANCE(1304);
      END_STATE();
    case 2046:
      if (lookahead == 't') ADVANCE(1310);
      END_STATE();
    case 2047:
      if (lookahead == 't') ADVANCE(1320);
      END_STATE();
    case 2048:
      if (lookahead == 't') ADVANCE(705);
      END_STATE();
    case 2049:
      if (lookahead == 't') ADVANCE(694);
      END_STATE();
    case 2050:
      if (lookahead == 'u') ADVANCE(152);
      END_STATE();
    case 2051:
      if (lookahead == 'u') ADVANCE(622);
      END_STATE();
    case 2052:
      if (lookahead == 'u') ADVANCE(2162);
      END_STATE();
    case 2053:
      if (lookahead == 'u') ADVANCE(1588);
      END_STATE();
    case 2054:
      if (lookahead == 'u') ADVANCE(311);
      END_STATE();
    case 2055:
      if (lookahead == 'u') ADVANCE(724);
      END_STATE();
    case 2056:
      if (lookahead == 'u') ADVANCE(737);
      END_STATE();
    case 2057:
      if (lookahead == 'u') ADVANCE(735);
      END_STATE();
    case 2058:
      if (lookahead == 'u') ADVANCE(1677);
      END_STATE();
    case 2059:
      if (lookahead == 'u') ADVANCE(718);
      END_STATE();
    case 2060:
      if (lookahead == 'u') ADVANCE(1907);
      END_STATE();
    case 2061:
      if (lookahead == 'u') ADVANCE(742);
      END_STATE();
    case 2062:
      if (lookahead == 'u') ADVANCE(1994);
      END_STATE();
    case 2063:
      if (lookahead == 'u') ADVANCE(1994);
      if (lookahead == 'y') ADVANCE(152);
      END_STATE();
    case 2064:
      if (lookahead == 'u') ADVANCE(1463);
      END_STATE();
    case 2065:
      if (lookahead == 'u') ADVANCE(1903);
      END_STATE();
    case 2066:
      if (lookahead == 'u') ADVANCE(1009);
      END_STATE();
    case 2067:
      if (lookahead == 'u') ADVANCE(1919);
      END_STATE();
    case 2068:
      if (lookahead == 'u') ADVANCE(926);
      END_STATE();
    case 2069:
      if (lookahead == 'u') ADVANCE(1466);
      END_STATE();
    case 2070:
      if (lookahead == 'u') ADVANCE(807);
      END_STATE();
    case 2071:
      if (lookahead == 'u') ADVANCE(959);
      END_STATE();
    case 2072:
      if (lookahead == 'u') ADVANCE(600);
      END_STATE();
    case 2073:
      if (lookahead == 'u') ADVANCE(1910);
      END_STATE();
    case 2074:
      if (lookahead == 'u') ADVANCE(1589);
      END_STATE();
    case 2075:
      if (lookahead == 'u') ADVANCE(1374);
      END_STATE();
    case 2076:
      if (lookahead == 'u') ADVANCE(1934);
      END_STATE();
    case 2077:
      if (lookahead == 'u') ADVANCE(841);
      END_STATE();
    case 2078:
      if (lookahead == 'u') ADVANCE(1921);
      END_STATE();
    case 2079:
      if (lookahead == 'u') ADVANCE(1242);
      END_STATE();
    case 2080:
      if (lookahead == 'u') ADVANCE(994);
      END_STATE();
    case 2081:
      if (lookahead == 'u') ADVANCE(621);
      END_STATE();
    case 2082:
      if (lookahead == 'u') ADVANCE(1307);
      END_STATE();
    case 2083:
      if (lookahead == 'u') ADVANCE(1241);
      END_STATE();
    case 2084:
      if (lookahead == 'u') ADVANCE(1781);
      END_STATE();
    case 2085:
      if (lookahead == 'u') ADVANCE(1753);
      END_STATE();
    case 2086:
      if (lookahead == 'u') ADVANCE(1782);
      END_STATE();
    case 2087:
      if (lookahead == 'u') ADVANCE(1846);
      END_STATE();
    case 2088:
      if (lookahead == 'u') ADVANCE(1848);
      END_STATE();
    case 2089:
      if (lookahead == 'u') ADVANCE(1193);
      END_STATE();
    case 2090:
      if (lookahead == 'u') ADVANCE(1476);
      END_STATE();
    case 2091:
      if (lookahead == 'u') ADVANCE(1547);
      END_STATE();
    case 2092:
      if (lookahead == 'u') ADVANCE(1941);
      END_STATE();
    case 2093:
      if (lookahead == 'u') ADVANCE(1276);
      END_STATE();
    case 2094:
      if (lookahead == 'u') ADVANCE(1400);
      END_STATE();
    case 2095:
      if (lookahead == 'u') ADVANCE(2007);
      END_STATE();
    case 2096:
      if (lookahead == 'u') ADVANCE(641);
      END_STATE();
    case 2097:
      if (lookahead == 'u') ADVANCE(1416);
      END_STATE();
    case 2098:
      if (lookahead == 'u') ADVANCE(1662);
      END_STATE();
    case 2099:
      if (lookahead == 'u') ADVANCE(1474);
      END_STATE();
    case 2100:
      if (lookahead == 'u') ADVANCE(647);
      END_STATE();
    case 2101:
      if (lookahead == 'u') ADVANCE(1862);
      END_STATE();
    case 2102:
      if (lookahead == 'u') ADVANCE(1455);
      END_STATE();
    case 2103:
      if (lookahead == 'u') ADVANCE(690);
      END_STATE();
    case 2104:
      if (lookahead == 'u') ADVANCE(748);
      END_STATE();
    case 2105:
      if (lookahead == 'u') ADVANCE(692);
      END_STATE();
    case 2106:
      if (lookahead == 'u') ADVANCE(747);
      if (lookahead == 'w') ADVANCE(1513);
      END_STATE();
    case 2107:
      if (lookahead == 'u') ADVANCE(750);
      END_STATE();
    case 2108:
      if (lookahead == 'v') ADVANCE(152);
      END_STATE();
    case 2109:
      if (lookahead == 'v') ADVANCE(152);
      if (lookahead == 'w') ADVANCE(925);
      END_STATE();
    case 2110:
      if (lookahead == 'v') ADVANCE(166);
      END_STATE();
    case 2111:
      if (lookahead == 'v') ADVANCE(250);
      END_STATE();
    case 2112:
      if (lookahead == 'v') ADVANCE(1003);
      if (lookahead == 'w') ADVANCE(1002);
      END_STATE();
    case 2113:
      if (lookahead == 'v') ADVANCE(926);
      END_STATE();
    case 2114:
      if (lookahead == 'v') ADVANCE(950);
      END_STATE();
    case 2115:
      if (lookahead == 'v') ADVANCE(1089);
      END_STATE();
    case 2116:
      if (lookahead == 'w') ADVANCE(152);
      END_STATE();
    case 2117:
      if (lookahead == 'w') ADVANCE(158);
      END_STATE();
    case 2118:
      if (lookahead == 'w') ADVANCE(162);
      END_STATE();
    case 2119:
      if (lookahead == 'w') ADVANCE(161);
      END_STATE();
    case 2120:
      if (lookahead == 'w') ADVANCE(160);
      END_STATE();
    case 2121:
      if (lookahead == 'w') ADVANCE(1588);
      END_STATE();
    case 2122:
      if (lookahead == 'w') ADVANCE(546);
      END_STATE();
    case 2123:
      if (lookahead == 'w') ADVANCE(334);
      END_STATE();
    case 2124:
      if (lookahead == 'w') ADVANCE(966);
      END_STATE();
    case 2125:
      if (lookahead == 'w') ADVANCE(1903);
      END_STATE();
    case 2126:
      if (lookahead == 'w') ADVANCE(1054);
      if (lookahead == 'a' ||
          lookahead == 'h') ADVANCE(152);
      END_STATE();
    case 2127:
      if (lookahead == 'w') ADVANCE(1504);
      END_STATE();
    case 2128:
      if (lookahead == 'w') ADVANCE(1521);
      END_STATE();
    case 2129:
      if (lookahead == 'w') ADVANCE(1518);
      END_STATE();
    case 2130:
      if (lookahead == 'w') ADVANCE(1514);
      END_STATE();
    case 2131:
      if (lookahead == 'w') ADVANCE(1302);
      END_STATE();
    case 2132:
      if (lookahead == 'w') ADVANCE(353);
      END_STATE();
    case 2133:
      if (lookahead == 'w') ADVANCE(1428);
      END_STATE();
    case 2134:
      if (lookahead == 'w') ADVANCE(1586);
      END_STATE();
    case 2135:
      if (lookahead == 'w') ADVANCE(1585);
      END_STATE();
    case 2136:
      if (lookahead == 'x') ADVANCE(152);
      END_STATE();
    case 2137:
      if (lookahead == 'x') ADVANCE(1958);
      END_STATE();
    case 2138:
      if (lookahead == 'x') ADVANCE(259);
      END_STATE();
    case 2139:
      if (lookahead == 'y') ADVANCE(152);
      END_STATE();
    case 2140:
      if (lookahead == 'y') ADVANCE(513);
      END_STATE();
    case 2141:
      if (lookahead == 'y') ADVANCE(984);
      END_STATE();
    case 2142:
      if (lookahead == 'y') ADVANCE(460);
      END_STATE();
    case 2143:
      if (lookahead == 'y') ADVANCE(475);
      END_STATE();
    case 2144:
      if (lookahead == 'y') ADVANCE(342);
      END_STATE();
    case 2145:
      if (lookahead == 'y') ADVANCE(2108);
      END_STATE();
    case 2146:
      if (lookahead == 'y') ADVANCE(512);
      END_STATE();
    case 2147:
      if (lookahead == 'y') ADVANCE(519);
      END_STATE();
    case 2148:
      if (lookahead == 'y') ADVANCE(488);
      END_STATE();
    case 2149:
      if (lookahead == 'y') ADVANCE(1463);
      END_STATE();
    case 2150:
      if (lookahead == 'y') ADVANCE(925);
      END_STATE();
    case 2151:
      if (lookahead == 'y') ADVANCE(1903);
      END_STATE();
    case 2152:
      if (lookahead == 'y') ADVANCE(973);
      END_STATE();
    case 2153:
      if (lookahead == 'z') ADVANCE(1665);
      END_STATE();
    case 2154:
      if (lookahead == 'z') ADVANCE(577);
      END_STATE();
    case 2155:
      if (lookahead == 'z') ADVANCE(1281);
      END_STATE();
    case 2156:
      if (lookahead == 'z') ADVANCE(1012);
      END_STATE();
    case 2157:
      if (lookahead == '2' ||
          lookahead == '4') ADVANCE(152);
      END_STATE();
    case 2158:
      if (lookahead == '3' ||
          lookahead == '5') ADVANCE(152);
      END_STATE();
    case 2159:
      if (lookahead == '6' ||
          lookahead == '8') ADVANCE(152);
      END_STATE();
    case 2160:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 2161:
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(2176);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(380);
      END_STATE();
    case 2162:
      if (lookahead == 'b' ||
          lookahead == 'p') ADVANCE(152);
      END_STATE();
    case 2163:
      if (lookahead == 'b' ||
          lookahead == 'u') ADVANCE(152);
      END_STATE();
    case 2164:
      if (lookahead == 'd' ||
          lookahead == 'u') ADVANCE(152);
      END_STATE();
    case 2165:
      if (lookahead == 'e' ||
          lookahead == 'k') ADVANCE(152);
      END_STATE();
    case 2166:
      if (lookahead == 'e' ||
          lookahead == 't') ADVANCE(152);
      END_STATE();
    case 2167:
      if (lookahead == 'f' ||
          lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 2168:
      if (lookahead == 'l' ||
          lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 2169:
      if (lookahead == 'o' ||
          lookahead == 'u') ADVANCE(152);
      END_STATE();
    case 2170:
      if (lookahead == 'r' ||
          lookahead == 'y') ADVANCE(152);
      END_STATE();
    case 2171:
      if (lookahead == '3' ||
          lookahead == '4') ADVANCE(152);
      END_STATE();
    case 2172:
      if (lookahead == 'e' ||
          lookahead == 'f') ADVANCE(152);
      END_STATE();
    case 2173:
      if (('a' <= lookahead && lookahead <= 'c')) ADVANCE(152);
      END_STATE();
    case 2174:
      if (lookahead == 'L' ||
          lookahead == 'R' ||
          lookahead == 'l' ||
          lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 2175:
      if (('a' <= lookahead && lookahead <= 'h')) ADVANCE(152);
      END_STATE();
    case 2176:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(385);
      END_STATE();
    case 2177:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(19);
      END_STATE();
    case 2178:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 2179:
      if (eof) ADVANCE(2183);
      ADVANCE_MAP(
        '\t', 2242,
        '\n', 2226,
        '\r', 2227,
        ' ', 2244,
        '!', 2194,
        '"', 2195,
        '#', 2196,
        '$', 2197,
        '%', 2198,
        '&', 2200,
        '\'', 2201,
        '(', 2224,
        ')', 2225,
        '*', 2202,
        '+', 2203,
        ',', 2204,
        '-', 2206,
        '.', 2207,
        '/', 2208,
        ':', 2209,
        ';', 2210,
        '<', 2191,
        '=', 2211,
        '>', 2193,
        '?', 2212,
        '@', 2214,
        '[', 2187,
        '\\', 2216,
        ']', 2188,
        '^', 2217,
        '_', 2218,
        '`', 2219,
        '{', 2220,
        '|', 2221,
        '}', 2222,
        '~', 2223,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2246);
      if (lookahead != 0) ADVANCE(2245);
      END_STATE();
    case 2180:
      if (eof) ADVANCE(2183);
      ADVANCE_MAP(
        '\t', 2242,
        '\n', 2226,
        '\r', 2227,
        ' ', 2244,
        '!', 2194,
        '"', 2195,
        '#', 2196,
        '$', 2197,
        '%', 2198,
        '&', 2200,
        '\'', 2201,
        '(', 2224,
        ')', 2225,
        '*', 2202,
        '+', 2203,
        ',', 2204,
        '-', 2205,
        '.', 2207,
        '/', 2208,
        ':', 2209,
        ';', 2210,
        '<', 2191,
        '=', 2211,
        '>', 2193,
        '?', 2213,
        '@', 2214,
        '[', 2187,
        '\\', 2216,
        ']', 2188,
        '^', 2217,
        '_', 2218,
        '`', 2219,
        '{', 2220,
        '|', 2221,
        '}', 2222,
        '~', 2223,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2246);
      if (lookahead != 0) ADVANCE(2245);
      END_STATE();
    case 2181:
      if (eof) ADVANCE(2183);
      ADVANCE_MAP(
        '\t', 2242,
        '\n', 2226,
        '\r', 2227,
        ' ', 2244,
        '!', 2194,
        '"', 2195,
        '#', 2196,
        '$', 2197,
        '%', 2198,
        '&', 2200,
        '\'', 2201,
        '(', 2224,
        ')', 2225,
        '*', 2202,
        '+', 2203,
        ',', 2204,
        '-', 2205,
        '.', 2207,
        '/', 2208,
        ':', 2209,
        ';', 2210,
        '<', 2191,
        '=', 2211,
        '>', 2193,
        '?', 2212,
        '@', 2214,
        '[', 2187,
        '\\', 2216,
        ']', 2189,
        '^', 2217,
        '_', 2218,
        '`', 2219,
        '{', 2220,
        '|', 2221,
        '}', 2222,
        '~', 2223,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2246);
      if (lookahead != 0) ADVANCE(2245);
      END_STATE();
    case 2182:
      if (eof) ADVANCE(2183);
      ADVANCE_MAP(
        '\t', 2242,
        '\n', 2226,
        '\r', 2227,
        ' ', 2244,
        '!', 2194,
        '"', 2195,
        '#', 2196,
        '$', 2197,
        '%', 2198,
        '&', 2200,
        '\'', 2201,
        '(', 2224,
        ')', 2225,
        '*', 2202,
        '+', 2203,
        ',', 2204,
        '-', 2205,
        '.', 2207,
        '/', 2208,
        ':', 2209,
        ';', 2210,
        '<', 2191,
        '=', 2211,
        '>', 2193,
        '?', 2212,
        '@', 2214,
        '[', 2187,
        '\\', 2216,
        ']', 2188,
        '^', 2217,
        '_', 2218,
        '`', 2219,
        '{', 2220,
        '|', 2221,
        '}', 2222,
        '~', 2223,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(2246);
      if (lookahead != 0) ADVANCE(2245);
      END_STATE();
    case 2183:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 2184:
      ACCEPT_TOKEN(sym__backslash_escape);
      END_STATE();
    case 2185:
      ACCEPT_TOKEN(sym_entity_reference);
      END_STATE();
    case 2186:
      ACCEPT_TOKEN(sym_numeric_character_reference);
      END_STATE();
    case 2187:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 2188:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 2189:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      if (lookahead == ']') ADVANCE(387);
      END_STATE();
    case 2190:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 2191:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '!') ADVANCE(17);
      if (lookahead == '?') ADVANCE(2236);
      if (('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          ('^' <= lookahead && lookahead <= '`') ||
          ('{' <= lookahead && lookahead <= '~')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(389);
      END_STATE();
    case 2192:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '?') ADVANCE(2235);
      END_STATE();
    case 2193:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 2194:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 2195:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 2196:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 2197:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 2198:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 2199:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 2200:
      ACCEPT_TOKEN(anon_sym_AMP);
      ADVANCE_MAP(
        '#', 2161,
        'A', 461,
        'B', 531,
        'C', 484,
        'D', 444,
        'E', 500,
        'F', 757,
        'G', 184,
        'H', 391,
        'I', 467,
        'J', 859,
        'K', 483,
        'L', 183,
        'M', 573,
        'N', 491,
        'O', 469,
        'P', 569,
        'Q', 523,
        'R', 424,
        'S', 480,
        'T', 481,
        'U', 550,
        'V', 453,
        'W', 811,
        'X', 1099,
        'Y', 394,
        'Z', 485,
        'a', 529,
        'b', 499,
        'c', 536,
        'd', 400,
        'e', 446,
        'f', 578,
        'g', 173,
        'h', 402,
        'i', 530,
        'j', 858,
        'k', 663,
        'l', 153,
        'm', 447,
        'n', 477,
        'o', 511,
        'p', 601,
        'q', 1100,
        'r', 392,
        's', 658,
        't', 553,
        'u', 401,
        'v', 398,
        'w', 810,
        'x', 766,
        'y', 568,
        'z', 659,
      );
      END_STATE();
    case 2201:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 2202:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 2203:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 2204:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 2205:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 2206:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(386);
      END_STATE();
    case 2207:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 2208:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 2209:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 2210:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 2211:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 2212:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 2213:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '>') ADVANCE(2237);
      END_STATE();
    case 2214:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 2215:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      END_STATE();
    case 2216:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      if (('!' <= lookahead && lookahead <= '/') ||
          (':' <= lookahead && lookahead <= '@') ||
          ('[' <= lookahead && lookahead <= '`') ||
          ('{' <= lookahead && lookahead <= '~')) ADVANCE(2184);
      END_STATE();
    case 2217:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 2218:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    case 2219:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 2220:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 2221:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 2222:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 2223:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 2224:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 2225:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 2226:
      ACCEPT_TOKEN(sym__newline_token);
      END_STATE();
    case 2227:
      ACCEPT_TOKEN(sym__newline_token);
      if (lookahead == '\n') ADVANCE(2226);
      END_STATE();
    case 2228:
      ACCEPT_TOKEN(sym_uri_autolink);
      END_STATE();
    case 2229:
      ACCEPT_TOKEN(sym_email_autolink);
      END_STATE();
    case 2230:
      ACCEPT_TOKEN(sym__attribute_name);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(2230);
      END_STATE();
    case 2231:
      ACCEPT_TOKEN(aux_sym__attribute_value_token1);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          (lookahead < '<' || '>' < lookahead) &&
          lookahead != '`') ADVANCE(2231);
      END_STATE();
    case 2232:
      ACCEPT_TOKEN(anon_sym_LT_BANG_DASH_DASH);
      END_STATE();
    case 2233:
      ACCEPT_TOKEN(anon_sym_LT_BANG_DASH_DASH);
      if (lookahead == '@') ADVANCE(2177);
      if (lookahead == '!' ||
          ('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          ('^' <= lookahead && lookahead <= '~')) ADVANCE(390);
      END_STATE();
    case 2234:
      ACCEPT_TOKEN(anon_sym_DASH_DASH_GT);
      END_STATE();
    case 2235:
      ACCEPT_TOKEN(anon_sym_LT_QMARK);
      END_STATE();
    case 2236:
      ACCEPT_TOKEN(anon_sym_LT_QMARK);
      if (lookahead == '@') ADVANCE(2177);
      if (lookahead == '!' ||
          ('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          ('?' <= lookahead && lookahead <= 'Z') ||
          ('^' <= lookahead && lookahead <= '~')) ADVANCE(390);
      END_STATE();
    case 2237:
      ACCEPT_TOKEN(anon_sym_QMARK_GT);
      END_STATE();
    case 2238:
      ACCEPT_TOKEN(aux_sym__declaration_token1);
      if (lookahead == '@') ADVANCE(2177);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(2238);
      if (lookahead == '!' ||
          ('#' <= lookahead && lookahead <= '\'') ||
          lookahead == '*' ||
          lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          lookahead == '=' ||
          lookahead == '?' ||
          ('^' <= lookahead && lookahead <= '~')) ADVANCE(390);
      END_STATE();
    case 2239:
      ACCEPT_TOKEN(aux_sym__declaration_token1);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(2239);
      END_STATE();
    case 2240:
      ACCEPT_TOKEN(anon_sym_LT_BANG_LBRACKCDATA_LBRACK);
      END_STATE();
    case 2241:
      ACCEPT_TOKEN(anon_sym_RBRACK_RBRACK_GT);
      END_STATE();
    case 2242:
      ACCEPT_TOKEN(sym__whitespace_ge_2);
      END_STATE();
    case 2243:
      ACCEPT_TOKEN(sym__whitespace_ge_2);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2243);
      END_STATE();
    case 2244:
      ACCEPT_TOKEN(aux_sym__whitespace_token1);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2243);
      END_STATE();
    case 2245:
      ACCEPT_TOKEN(sym__word_no_digit);
      if (lookahead == '_') ADVANCE(528);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          (lookahead < ' ' || '@' < lookahead) &&
          (lookahead < '[' || '`' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(2245);
      END_STATE();
    case 2246:
      ACCEPT_TOKEN(sym__digits);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(2246);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 2182, .external_lex_state = 2},
  [2] = {.lex_state = 2182, .external_lex_state = 3},
  [3] = {.lex_state = 2182, .external_lex_state = 4},
  [4] = {.lex_state = 2182, .external_lex_state = 4},
  [5] = {.lex_state = 2182, .external_lex_state = 3},
  [6] = {.lex_state = 2182, .external_lex_state = 4},
  [7] = {.lex_state = 2182, .external_lex_state = 5},
  [8] = {.lex_state = 2182, .external_lex_state = 5},
  [9] = {.lex_state = 2182, .external_lex_state = 6},
  [10] = {.lex_state = 2182, .external_lex_state = 6},
  [11] = {.lex_state = 2182, .external_lex_state = 7},
  [12] = {.lex_state = 2182, .external_lex_state = 7},
  [13] = {.lex_state = 2182, .external_lex_state = 8},
  [14] = {.lex_state = 2182, .external_lex_state = 9},
  [15] = {.lex_state = 2182, .external_lex_state = 7},
  [16] = {.lex_state = 2182, .external_lex_state = 7},
  [17] = {.lex_state = 2182, .external_lex_state = 8},
  [18] = {.lex_state = 2182, .external_lex_state = 7},
  [19] = {.lex_state = 2182, .external_lex_state = 8},
  [20] = {.lex_state = 2182, .external_lex_state = 8},
  [21] = {.lex_state = 2182, .external_lex_state = 9},
  [22] = {.lex_state = 2182, .external_lex_state = 9},
  [23] = {.lex_state = 2182, .external_lex_state = 9},
  [24] = {.lex_state = 2182, .external_lex_state = 8},
  [25] = {.lex_state = 2182, .external_lex_state = 10},
  [26] = {.lex_state = 2182, .external_lex_state = 7},
  [27] = {.lex_state = 2182, .external_lex_state = 7},
  [28] = {.lex_state = 2182, .external_lex_state = 8},
  [29] = {.lex_state = 2182, .external_lex_state = 9},
  [30] = {.lex_state = 2182, .external_lex_state = 7},
  [31] = {.lex_state = 2182, .external_lex_state = 10},
  [32] = {.lex_state = 2182, .external_lex_state = 9},
  [33] = {.lex_state = 2182, .external_lex_state = 4},
  [34] = {.lex_state = 2182, .external_lex_state = 4},
  [35] = {.lex_state = 2182, .external_lex_state = 4},
  [36] = {.lex_state = 2182, .external_lex_state = 4},
  [37] = {.lex_state = 2182, .external_lex_state = 8},
  [38] = {.lex_state = 2182, .external_lex_state = 10},
  [39] = {.lex_state = 2182, .external_lex_state = 9},
  [40] = {.lex_state = 2182, .external_lex_state = 8},
  [41] = {.lex_state = 2182, .external_lex_state = 7},
  [42] = {.lex_state = 2182, .external_lex_state = 9},
  [43] = {.lex_state = 2182, .external_lex_state = 9},
  [44] = {.lex_state = 2182, .external_lex_state = 8},
  [45] = {.lex_state = 2182, .external_lex_state = 4},
  [46] = {.lex_state = 2182, .external_lex_state = 4},
  [47] = {.lex_state = 2182, .external_lex_state = 7},
  [48] = {.lex_state = 2182, .external_lex_state = 9},
  [49] = {.lex_state = 2182, .external_lex_state = 7},
  [50] = {.lex_state = 2182, .external_lex_state = 9},
  [51] = {.lex_state = 2182, .external_lex_state = 8},
  [52] = {.lex_state = 2182, .external_lex_state = 8},
  [53] = {.lex_state = 2182, .external_lex_state = 10},
  [54] = {.lex_state = 2182, .external_lex_state = 10},
  [55] = {.lex_state = 2182, .external_lex_state = 10},
  [56] = {.lex_state = 2182, .external_lex_state = 10},
  [57] = {.lex_state = 2182, .external_lex_state = 10},
  [58] = {.lex_state = 2182, .external_lex_state = 10},
  [59] = {.lex_state = 2182, .external_lex_state = 10},
  [60] = {.lex_state = 2182, .external_lex_state = 10},
  [61] = {.lex_state = 2182, .external_lex_state = 10},
  [62] = {.lex_state = 2182, .external_lex_state = 10},
  [63] = {.lex_state = 2182, .external_lex_state = 10},
  [64] = {.lex_state = 2182, .external_lex_state = 10},
  [65] = {.lex_state = 2182, .external_lex_state = 10},
  [66] = {.lex_state = 2182, .external_lex_state = 10},
  [67] = {.lex_state = 2182, .external_lex_state = 10},
  [68] = {.lex_state = 2182, .external_lex_state = 10},
  [69] = {.lex_state = 2182, .external_lex_state = 10},
  [70] = {.lex_state = 2182, .external_lex_state = 10},
  [71] = {.lex_state = 2182, .external_lex_state = 10},
  [72] = {.lex_state = 2182, .external_lex_state = 10},
  [73] = {.lex_state = 2182, .external_lex_state = 10},
  [74] = {.lex_state = 2182, .external_lex_state = 10},
  [75] = {.lex_state = 2182, .external_lex_state = 10},
  [76] = {.lex_state = 2182, .external_lex_state = 10},
  [77] = {.lex_state = 2182, .external_lex_state = 10},
  [78] = {.lex_state = 2182, .external_lex_state = 10},
  [79] = {.lex_state = 2182, .external_lex_state = 10},
  [80] = {.lex_state = 2182, .external_lex_state = 10},
  [81] = {.lex_state = 2182, .external_lex_state = 10},
  [82] = {.lex_state = 2182, .external_lex_state = 10},
  [83] = {.lex_state = 2182, .external_lex_state = 10},
  [84] = {.lex_state = 2182, .external_lex_state = 10},
  [85] = {.lex_state = 2182, .external_lex_state = 10},
  [86] = {.lex_state = 2182, .external_lex_state = 6},
  [87] = {.lex_state = 2182, .external_lex_state = 4},
  [88] = {.lex_state = 2182, .external_lex_state = 5},
  [89] = {.lex_state = 2182, .external_lex_state = 3},
  [90] = {.lex_state = 2182, .external_lex_state = 4},
  [91] = {.lex_state = 2182, .external_lex_state = 4},
  [92] = {.lex_state = 2182, .external_lex_state = 3},
  [93] = {.lex_state = 2182, .external_lex_state = 3},
  [94] = {.lex_state = 2182, .external_lex_state = 5},
  [95] = {.lex_state = 2182, .external_lex_state = 5},
  [96] = {.lex_state = 2182, .external_lex_state = 4},
  [97] = {.lex_state = 2182, .external_lex_state = 4},
  [98] = {.lex_state = 2182, .external_lex_state = 6},
  [99] = {.lex_state = 2182, .external_lex_state = 6},
  [100] = {.lex_state = 2182, .external_lex_state = 7},
  [101] = {.lex_state = 2182, .external_lex_state = 4},
  [102] = {.lex_state = 2182, .external_lex_state = 7},
  [103] = {.lex_state = 2182, .external_lex_state = 7},
  [104] = {.lex_state = 2182, .external_lex_state = 10},
  [105] = {.lex_state = 2182, .external_lex_state = 9},
  [106] = {.lex_state = 2182, .external_lex_state = 8},
  [107] = {.lex_state = 2182, .external_lex_state = 8},
  [108] = {.lex_state = 2182, .external_lex_state = 8},
  [109] = {.lex_state = 2182, .external_lex_state = 9},
  [110] = {.lex_state = 2182, .external_lex_state = 7},
  [111] = {.lex_state = 2182, .external_lex_state = 7},
  [112] = {.lex_state = 2182, .external_lex_state = 8},
  [113] = {.lex_state = 2182, .external_lex_state = 9},
  [114] = {.lex_state = 2182, .external_lex_state = 8},
  [115] = {.lex_state = 2182, .external_lex_state = 8},
  [116] = {.lex_state = 2182, .external_lex_state = 7},
  [117] = {.lex_state = 2182, .external_lex_state = 4},
  [118] = {.lex_state = 2182, .external_lex_state = 9},
  [119] = {.lex_state = 2182, .external_lex_state = 10},
  [120] = {.lex_state = 2182, .external_lex_state = 7},
  [121] = {.lex_state = 2182, .external_lex_state = 9},
  [122] = {.lex_state = 2182, .external_lex_state = 9},
  [123] = {.lex_state = 2182, .external_lex_state = 8},
  [124] = {.lex_state = 2182, .external_lex_state = 10},
  [125] = {.lex_state = 2182, .external_lex_state = 4},
  [126] = {.lex_state = 2182, .external_lex_state = 7},
  [127] = {.lex_state = 2182, .external_lex_state = 10},
  [128] = {.lex_state = 2182, .external_lex_state = 8},
  [129] = {.lex_state = 2182, .external_lex_state = 9},
  [130] = {.lex_state = 2182, .external_lex_state = 8},
  [131] = {.lex_state = 2182, .external_lex_state = 9},
  [132] = {.lex_state = 2182, .external_lex_state = 9},
  [133] = {.lex_state = 2182, .external_lex_state = 10},
  [134] = {.lex_state = 2182, .external_lex_state = 10},
  [135] = {.lex_state = 2182, .external_lex_state = 7},
  [136] = {.lex_state = 2182, .external_lex_state = 10},
  [137] = {.lex_state = 2182, .external_lex_state = 10},
  [138] = {.lex_state = 2182, .external_lex_state = 10},
  [139] = {.lex_state = 2182, .external_lex_state = 10},
  [140] = {.lex_state = 2182, .external_lex_state = 10},
  [141] = {.lex_state = 2182, .external_lex_state = 10},
  [142] = {.lex_state = 2182, .external_lex_state = 10},
  [143] = {.lex_state = 2182, .external_lex_state = 10},
  [144] = {.lex_state = 2182, .external_lex_state = 10},
  [145] = {.lex_state = 2182, .external_lex_state = 10},
  [146] = {.lex_state = 2182, .external_lex_state = 10},
  [147] = {.lex_state = 2182, .external_lex_state = 10},
  [148] = {.lex_state = 2182, .external_lex_state = 9},
  [149] = {.lex_state = 2182, .external_lex_state = 9},
  [150] = {.lex_state = 2182, .external_lex_state = 7},
  [151] = {.lex_state = 2182, .external_lex_state = 7},
  [152] = {.lex_state = 2182, .external_lex_state = 8},
  [153] = {.lex_state = 2182, .external_lex_state = 8},
  [154] = {.lex_state = 2182, .external_lex_state = 10},
  [155] = {.lex_state = 2182, .external_lex_state = 10},
  [156] = {.lex_state = 2182, .external_lex_state = 10},
  [157] = {.lex_state = 2182, .external_lex_state = 10},
  [158] = {.lex_state = 2182, .external_lex_state = 7},
  [159] = {.lex_state = 2182, .external_lex_state = 8},
  [160] = {.lex_state = 2182, .external_lex_state = 9},
  [161] = {.lex_state = 2182, .external_lex_state = 9},
  [162] = {.lex_state = 2182, .external_lex_state = 10},
  [163] = {.lex_state = 2182, .external_lex_state = 10},
  [164] = {.lex_state = 2182, .external_lex_state = 7},
  [165] = {.lex_state = 2182, .external_lex_state = 8},
  [166] = {.lex_state = 2181, .external_lex_state = 8},
  [167] = {.lex_state = 2180, .external_lex_state = 9},
  [168] = {.lex_state = 2181, .external_lex_state = 7},
  [169] = {.lex_state = 2181, .external_lex_state = 9},
  [170] = {.lex_state = 2181, .external_lex_state = 8},
  [171] = {.lex_state = 2180, .external_lex_state = 8},
  [172] = {.lex_state = 2180, .external_lex_state = 7},
  [173] = {.lex_state = 2180, .external_lex_state = 8},
  [174] = {.lex_state = 2180, .external_lex_state = 7},
  [175] = {.lex_state = 2180, .external_lex_state = 9},
  [176] = {.lex_state = 2181, .external_lex_state = 9},
  [177] = {.lex_state = 2181, .external_lex_state = 10},
  [178] = {.lex_state = 2180, .external_lex_state = 10},
  [179] = {.lex_state = 2181, .external_lex_state = 7},
  [180] = {.lex_state = 2179, .external_lex_state = 7},
  [181] = {.lex_state = 2179, .external_lex_state = 8},
  [182] = {.lex_state = 2180, .external_lex_state = 10},
  [183] = {.lex_state = 2181, .external_lex_state = 10},
  [184] = {.lex_state = 2181, .external_lex_state = 10},
  [185] = {.lex_state = 2179, .external_lex_state = 8},
  [186] = {.lex_state = 2179, .external_lex_state = 10},
  [187] = {.lex_state = 2180, .external_lex_state = 10},
  [188] = {.lex_state = 2179, .external_lex_state = 7},
  [189] = {.lex_state = 2179, .external_lex_state = 9},
  [190] = {.lex_state = 2179, .external_lex_state = 9},
  [191] = {.lex_state = 9, .external_lex_state = 11},
  [192] = {.lex_state = 9, .external_lex_state = 11},
  [193] = {.lex_state = 2179, .external_lex_state = 10},
  [194] = {.lex_state = 9, .external_lex_state = 11},
  [195] = {.lex_state = 9, .external_lex_state = 11},
  [196] = {.lex_state = 9, .external_lex_state = 11},
  [197] = {.lex_state = 2179, .external_lex_state = 10},
  [198] = {.lex_state = 9, .external_lex_state = 11},
  [199] = {.lex_state = 9, .external_lex_state = 11},
  [200] = {.lex_state = 9, .external_lex_state = 11},
  [201] = {.lex_state = 9, .external_lex_state = 11},
  [202] = {.lex_state = 9, .external_lex_state = 11},
  [203] = {.lex_state = 9, .external_lex_state = 11},
  [204] = {.lex_state = 2182, .external_lex_state = 6},
  [205] = {.lex_state = 2182, .external_lex_state = 3},
  [206] = {.lex_state = 2182, .external_lex_state = 8},
  [207] = {.lex_state = 2182, .external_lex_state = 3},
  [208] = {.lex_state = 2182, .external_lex_state = 12},
  [209] = {.lex_state = 2182, .external_lex_state = 6},
  [210] = {.lex_state = 2182, .external_lex_state = 4},
  [211] = {.lex_state = 2182, .external_lex_state = 4},
  [212] = {.lex_state = 2182, .external_lex_state = 5},
  [213] = {.lex_state = 2182, .external_lex_state = 10},
  [214] = {.lex_state = 2182, .external_lex_state = 2},
  [215] = {.lex_state = 2182, .external_lex_state = 13},
  [216] = {.lex_state = 2182, .external_lex_state = 9},
  [217] = {.lex_state = 2182, .external_lex_state = 14},
  [218] = {.lex_state = 2182, .external_lex_state = 5},
  [219] = {.lex_state = 2182, .external_lex_state = 7},
  [220] = {.lex_state = 2182, .external_lex_state = 6},
  [221] = {.lex_state = 11, .external_lex_state = 15},
  [222] = {.lex_state = 2182, .external_lex_state = 3},
  [223] = {.lex_state = 2182, .external_lex_state = 6},
  [224] = {.lex_state = 11, .external_lex_state = 15},
  [225] = {.lex_state = 2182, .external_lex_state = 4},
  [226] = {.lex_state = 2182, .external_lex_state = 3},
  [227] = {.lex_state = 2182, .external_lex_state = 5},
  [228] = {.lex_state = 2182, .external_lex_state = 3},
  [229] = {.lex_state = 11, .external_lex_state = 15},
  [230] = {.lex_state = 11, .external_lex_state = 15},
  [231] = {.lex_state = 2182, .external_lex_state = 13},
  [232] = {.lex_state = 11, .external_lex_state = 15},
  [233] = {.lex_state = 2182, .external_lex_state = 4},
  [234] = {.lex_state = 11, .external_lex_state = 15},
  [235] = {.lex_state = 2182, .external_lex_state = 3},
  [236] = {.lex_state = 2182, .external_lex_state = 6},
  [237] = {.lex_state = 2182, .external_lex_state = 5},
  [238] = {.lex_state = 2182, .external_lex_state = 10},
  [239] = {.lex_state = 2182, .external_lex_state = 12},
  [240] = {.lex_state = 2182, .external_lex_state = 13},
  [241] = {.lex_state = 2182, .external_lex_state = 14},
  [242] = {.lex_state = 11, .external_lex_state = 15},
  [243] = {.lex_state = 2182, .external_lex_state = 2},
  [244] = {.lex_state = 2182, .external_lex_state = 2},
  [245] = {.lex_state = 2182, .external_lex_state = 14},
  [246] = {.lex_state = 2182, .external_lex_state = 12},
  [247] = {.lex_state = 11, .external_lex_state = 15},
  [248] = {.lex_state = 2182, .external_lex_state = 5},
  [249] = {.lex_state = 11, .external_lex_state = 15},
  [250] = {.lex_state = 2182, .external_lex_state = 2},
  [251] = {.lex_state = 11, .external_lex_state = 15},
  [252] = {.lex_state = 2182, .external_lex_state = 5},
  [253] = {.lex_state = 2182, .external_lex_state = 4},
  [254] = {.lex_state = 2182, .external_lex_state = 4},
  [255] = {.lex_state = 2182, .external_lex_state = 4},
  [256] = {.lex_state = 2182, .external_lex_state = 6},
  [257] = {.lex_state = 11, .external_lex_state = 15},
  [258] = {.lex_state = 2182, .external_lex_state = 4},
  [259] = {.lex_state = 2182, .external_lex_state = 5},
  [260] = {.lex_state = 2182, .external_lex_state = 6},
  [261] = {.lex_state = 2182, .external_lex_state = 3},
  [262] = {.lex_state = 2182, .external_lex_state = 9},
  [263] = {.lex_state = 2182, .external_lex_state = 10},
  [264] = {.lex_state = 2182, .external_lex_state = 10},
  [265] = {.lex_state = 2182, .external_lex_state = 10},
  [266] = {.lex_state = 2182, .external_lex_state = 10},
  [267] = {.lex_state = 2182, .external_lex_state = 10},
  [268] = {.lex_state = 1, .external_lex_state = 16},
  [269] = {.lex_state = 2182, .external_lex_state = 8},
  [270] = {.lex_state = 2182, .external_lex_state = 10},
  [271] = {.lex_state = 2182, .external_lex_state = 10},
  [272] = {.lex_state = 2182, .external_lex_state = 9},
  [273] = {.lex_state = 1, .external_lex_state = 16},
  [274] = {.lex_state = 2182, .external_lex_state = 10},
  [275] = {.lex_state = 2182, .external_lex_state = 10},
  [276] = {.lex_state = 2182, .external_lex_state = 10},
  [277] = {.lex_state = 2182, .external_lex_state = 10},
  [278] = {.lex_state = 2182, .external_lex_state = 10},
  [279] = {.lex_state = 2182, .external_lex_state = 4},
  [280] = {.lex_state = 2182, .external_lex_state = 9},
  [281] = {.lex_state = 2182, .external_lex_state = 9},
  [282] = {.lex_state = 2182, .external_lex_state = 8},
  [283] = {.lex_state = 2182, .external_lex_state = 8},
  [284] = {.lex_state = 2182, .external_lex_state = 10},
  [285] = {.lex_state = 2182, .external_lex_state = 7},
  [286] = {.lex_state = 2182, .external_lex_state = 10},
  [287] = {.lex_state = 2182, .external_lex_state = 10},
  [288] = {.lex_state = 2182, .external_lex_state = 10},
  [289] = {.lex_state = 1, .external_lex_state = 16},
  [290] = {.lex_state = 2182, .external_lex_state = 3},
  [291] = {.lex_state = 2182, .external_lex_state = 10},
  [292] = {.lex_state = 2182, .external_lex_state = 10},
  [293] = {.lex_state = 2182, .external_lex_state = 10},
  [294] = {.lex_state = 2182, .external_lex_state = 2},
  [295] = {.lex_state = 2182, .external_lex_state = 10},
  [296] = {.lex_state = 2182, .external_lex_state = 10},
  [297] = {.lex_state = 2182, .external_lex_state = 10},
  [298] = {.lex_state = 2182, .external_lex_state = 10},
  [299] = {.lex_state = 2182, .external_lex_state = 10},
  [300] = {.lex_state = 1, .external_lex_state = 16},
  [301] = {.lex_state = 2182, .external_lex_state = 10},
  [302] = {.lex_state = 2182, .external_lex_state = 2},
  [303] = {.lex_state = 1, .external_lex_state = 16},
  [304] = {.lex_state = 2182, .external_lex_state = 10},
  [305] = {.lex_state = 2182, .external_lex_state = 5},
  [306] = {.lex_state = 1, .external_lex_state = 16},
  [307] = {.lex_state = 2182, .external_lex_state = 10},
  [308] = {.lex_state = 2182, .external_lex_state = 10},
  [309] = {.lex_state = 2182, .external_lex_state = 4},
  [310] = {.lex_state = 2182, .external_lex_state = 10},
  [311] = {.lex_state = 1, .external_lex_state = 16},
  [312] = {.lex_state = 2182, .external_lex_state = 10},
  [313] = {.lex_state = 2182, .external_lex_state = 8},
  [314] = {.lex_state = 2182, .external_lex_state = 6},
  [315] = {.lex_state = 2182, .external_lex_state = 9},
  [316] = {.lex_state = 2182, .external_lex_state = 9},
  [317] = {.lex_state = 2182, .external_lex_state = 10},
  [318] = {.lex_state = 2182, .external_lex_state = 7},
  [319] = {.lex_state = 2182, .external_lex_state = 10},
  [320] = {.lex_state = 2182, .external_lex_state = 8},
  [321] = {.lex_state = 2182, .external_lex_state = 7},
  [322] = {.lex_state = 2182, .external_lex_state = 7},
  [323] = {.lex_state = 2182, .external_lex_state = 7},
  [324] = {.lex_state = 1, .external_lex_state = 16},
  [325] = {.lex_state = 2182, .external_lex_state = 7},
  [326] = {.lex_state = 2182, .external_lex_state = 7},
  [327] = {.lex_state = 2182, .external_lex_state = 10},
  [328] = {.lex_state = 2182, .external_lex_state = 10},
  [329] = {.lex_state = 2182, .external_lex_state = 7},
  [330] = {.lex_state = 2182, .external_lex_state = 4},
  [331] = {.lex_state = 2182, .external_lex_state = 7},
  [332] = {.lex_state = 2182, .external_lex_state = 9},
  [333] = {.lex_state = 1, .external_lex_state = 16},
  [334] = {.lex_state = 2182, .external_lex_state = 4},
  [335] = {.lex_state = 2182, .external_lex_state = 7},
  [336] = {.lex_state = 2182, .external_lex_state = 7},
  [337] = {.lex_state = 1, .external_lex_state = 16},
  [338] = {.lex_state = 2182, .external_lex_state = 10},
  [339] = {.lex_state = 2182, .external_lex_state = 7},
  [340] = {.lex_state = 2182, .external_lex_state = 7},
  [341] = {.lex_state = 2182, .external_lex_state = 7},
  [342] = {.lex_state = 2182, .external_lex_state = 7},
  [343] = {.lex_state = 1, .external_lex_state = 16},
  [344] = {.lex_state = 2182, .external_lex_state = 7},
  [345] = {.lex_state = 2182, .external_lex_state = 7},
  [346] = {.lex_state = 2182, .external_lex_state = 9},
  [347] = {.lex_state = 2182, .external_lex_state = 9},
  [348] = {.lex_state = 2182, .external_lex_state = 9},
  [349] = {.lex_state = 2182, .external_lex_state = 9},
  [350] = {.lex_state = 1, .external_lex_state = 16},
  [351] = {.lex_state = 2182, .external_lex_state = 7},
  [352] = {.lex_state = 2182, .external_lex_state = 7},
  [353] = {.lex_state = 2182, .external_lex_state = 10},
  [354] = {.lex_state = 2182, .external_lex_state = 9},
  [355] = {.lex_state = 2182, .external_lex_state = 9},
  [356] = {.lex_state = 2182, .external_lex_state = 7},
  [357] = {.lex_state = 2182, .external_lex_state = 7},
  [358] = {.lex_state = 2182, .external_lex_state = 9},
  [359] = {.lex_state = 2182, .external_lex_state = 7},
  [360] = {.lex_state = 1, .external_lex_state = 16},
  [361] = {.lex_state = 2182, .external_lex_state = 10},
  [362] = {.lex_state = 2182, .external_lex_state = 10},
  [363] = {.lex_state = 2182, .external_lex_state = 10},
  [364] = {.lex_state = 2182, .external_lex_state = 10},
  [365] = {.lex_state = 2182, .external_lex_state = 9},
  [366] = {.lex_state = 2182, .external_lex_state = 9},
  [367] = {.lex_state = 2182, .external_lex_state = 9},
  [368] = {.lex_state = 2182, .external_lex_state = 10},
  [369] = {.lex_state = 2182, .external_lex_state = 9},
  [370] = {.lex_state = 2182, .external_lex_state = 9},
  [371] = {.lex_state = 2182, .external_lex_state = 9},
  [372] = {.lex_state = 2182, .external_lex_state = 9},
  [373] = {.lex_state = 2182, .external_lex_state = 9},
  [374] = {.lex_state = 2182, .external_lex_state = 10},
  [375] = {.lex_state = 2182, .external_lex_state = 9},
  [376] = {.lex_state = 2182, .external_lex_state = 9},
  [377] = {.lex_state = 2182, .external_lex_state = 10},
  [378] = {.lex_state = 2182, .external_lex_state = 8},
  [379] = {.lex_state = 2182, .external_lex_state = 10},
  [380] = {.lex_state = 2182, .external_lex_state = 10},
  [381] = {.lex_state = 1, .external_lex_state = 16},
  [382] = {.lex_state = 2182, .external_lex_state = 10},
  [383] = {.lex_state = 1, .external_lex_state = 16},
  [384] = {.lex_state = 2182, .external_lex_state = 9},
  [385] = {.lex_state = 2182, .external_lex_state = 9},
  [386] = {.lex_state = 2182, .external_lex_state = 9},
  [387] = {.lex_state = 2182, .external_lex_state = 9},
  [388] = {.lex_state = 2182, .external_lex_state = 9},
  [389] = {.lex_state = 2182, .external_lex_state = 9},
  [390] = {.lex_state = 2182, .external_lex_state = 9},
  [391] = {.lex_state = 2182, .external_lex_state = 4},
  [392] = {.lex_state = 2182, .external_lex_state = 7},
  [393] = {.lex_state = 2182, .external_lex_state = 10},
  [394] = {.lex_state = 2182, .external_lex_state = 7},
  [395] = {.lex_state = 2182, .external_lex_state = 7},
  [396] = {.lex_state = 2182, .external_lex_state = 7},
  [397] = {.lex_state = 2182, .external_lex_state = 7},
  [398] = {.lex_state = 2182, .external_lex_state = 7},
  [399] = {.lex_state = 2182, .external_lex_state = 7},
  [400] = {.lex_state = 2182, .external_lex_state = 8},
  [401] = {.lex_state = 2182, .external_lex_state = 8},
  [402] = {.lex_state = 2182, .external_lex_state = 9},
  [403] = {.lex_state = 2182, .external_lex_state = 9},
  [404] = {.lex_state = 2182, .external_lex_state = 9},
  [405] = {.lex_state = 2182, .external_lex_state = 7},
  [406] = {.lex_state = 2182, .external_lex_state = 7},
  [407] = {.lex_state = 2182, .external_lex_state = 8},
  [408] = {.lex_state = 2182, .external_lex_state = 8},
  [409] = {.lex_state = 2182, .external_lex_state = 8},
  [410] = {.lex_state = 2182, .external_lex_state = 9},
  [411] = {.lex_state = 2182, .external_lex_state = 9},
  [412] = {.lex_state = 2182, .external_lex_state = 9},
  [413] = {.lex_state = 2182, .external_lex_state = 10},
  [414] = {.lex_state = 2182, .external_lex_state = 10},
  [415] = {.lex_state = 2182, .external_lex_state = 9},
  [416] = {.lex_state = 2182, .external_lex_state = 9},
  [417] = {.lex_state = 2182, .external_lex_state = 9},
  [418] = {.lex_state = 2182, .external_lex_state = 9},
  [419] = {.lex_state = 2182, .external_lex_state = 9},
  [420] = {.lex_state = 2182, .external_lex_state = 9},
  [421] = {.lex_state = 2182, .external_lex_state = 8},
  [422] = {.lex_state = 2182, .external_lex_state = 10},
  [423] = {.lex_state = 2182, .external_lex_state = 8},
  [424] = {.lex_state = 2182, .external_lex_state = 7},
  [425] = {.lex_state = 2182, .external_lex_state = 10},
  [426] = {.lex_state = 2182, .external_lex_state = 10},
  [427] = {.lex_state = 2182, .external_lex_state = 7},
  [428] = {.lex_state = 2182, .external_lex_state = 10},
  [429] = {.lex_state = 2182, .external_lex_state = 7},
  [430] = {.lex_state = 2182, .external_lex_state = 8},
  [431] = {.lex_state = 2182, .external_lex_state = 8},
  [432] = {.lex_state = 2182, .external_lex_state = 10},
  [433] = {.lex_state = 2182, .external_lex_state = 8},
  [434] = {.lex_state = 2182, .external_lex_state = 8},
  [435] = {.lex_state = 2182, .external_lex_state = 8},
  [436] = {.lex_state = 2182, .external_lex_state = 8},
  [437] = {.lex_state = 2182, .external_lex_state = 9},
  [438] = {.lex_state = 2182, .external_lex_state = 8},
  [439] = {.lex_state = 2182, .external_lex_state = 8},
  [440] = {.lex_state = 2182, .external_lex_state = 8},
  [441] = {.lex_state = 2182, .external_lex_state = 9},
  [442] = {.lex_state = 2182, .external_lex_state = 8},
  [443] = {.lex_state = 2182, .external_lex_state = 9},
  [444] = {.lex_state = 2182, .external_lex_state = 9},
  [445] = {.lex_state = 2182, .external_lex_state = 9},
  [446] = {.lex_state = 2182, .external_lex_state = 9},
  [447] = {.lex_state = 2182, .external_lex_state = 9},
  [448] = {.lex_state = 2182, .external_lex_state = 8},
  [449] = {.lex_state = 2182, .external_lex_state = 8},
  [450] = {.lex_state = 2182, .external_lex_state = 8},
  [451] = {.lex_state = 2182, .external_lex_state = 8},
  [452] = {.lex_state = 2182, .external_lex_state = 8},
  [453] = {.lex_state = 2182, .external_lex_state = 8},
  [454] = {.lex_state = 2182, .external_lex_state = 8},
  [455] = {.lex_state = 2182, .external_lex_state = 8},
  [456] = {.lex_state = 2182, .external_lex_state = 8},
  [457] = {.lex_state = 2182, .external_lex_state = 8},
  [458] = {.lex_state = 2182, .external_lex_state = 8},
  [459] = {.lex_state = 2182, .external_lex_state = 9},
  [460] = {.lex_state = 2182, .external_lex_state = 9},
  [461] = {.lex_state = 2182, .external_lex_state = 9},
  [462] = {.lex_state = 2182, .external_lex_state = 9},
  [463] = {.lex_state = 2182, .external_lex_state = 9},
  [464] = {.lex_state = 2182, .external_lex_state = 8},
  [465] = {.lex_state = 2182, .external_lex_state = 8},
  [466] = {.lex_state = 2182, .external_lex_state = 8},
  [467] = {.lex_state = 2182, .external_lex_state = 8},
  [468] = {.lex_state = 2182, .external_lex_state = 8},
  [469] = {.lex_state = 2182, .external_lex_state = 8},
  [470] = {.lex_state = 2182, .external_lex_state = 8},
  [471] = {.lex_state = 2182, .external_lex_state = 7},
  [472] = {.lex_state = 2182, .external_lex_state = 7},
  [473] = {.lex_state = 2182, .external_lex_state = 7},
  [474] = {.lex_state = 2182, .external_lex_state = 7},
  [475] = {.lex_state = 2182, .external_lex_state = 7},
  [476] = {.lex_state = 2182, .external_lex_state = 9},
  [477] = {.lex_state = 2182, .external_lex_state = 9},
  [478] = {.lex_state = 1, .external_lex_state = 16},
  [479] = {.lex_state = 2182, .external_lex_state = 10},
  [480] = {.lex_state = 2182, .external_lex_state = 9},
  [481] = {.lex_state = 2182, .external_lex_state = 9},
  [482] = {.lex_state = 2182, .external_lex_state = 8},
  [483] = {.lex_state = 2182, .external_lex_state = 8},
  [484] = {.lex_state = 2182, .external_lex_state = 8},
  [485] = {.lex_state = 2182, .external_lex_state = 7},
  [486] = {.lex_state = 2182, .external_lex_state = 7},
  [487] = {.lex_state = 2182, .external_lex_state = 8},
  [488] = {.lex_state = 2182, .external_lex_state = 9},
  [489] = {.lex_state = 2182, .external_lex_state = 9},
  [490] = {.lex_state = 2182, .external_lex_state = 9},
  [491] = {.lex_state = 2182, .external_lex_state = 8},
  [492] = {.lex_state = 2182, .external_lex_state = 8},
  [493] = {.lex_state = 2182, .external_lex_state = 9},
  [494] = {.lex_state = 2182, .external_lex_state = 9},
  [495] = {.lex_state = 2182, .external_lex_state = 8},
  [496] = {.lex_state = 2182, .external_lex_state = 8},
  [497] = {.lex_state = 2182, .external_lex_state = 8},
  [498] = {.lex_state = 2182, .external_lex_state = 8},
  [499] = {.lex_state = 2182, .external_lex_state = 8},
  [500] = {.lex_state = 2182, .external_lex_state = 8},
  [501] = {.lex_state = 2182, .external_lex_state = 7},
  [502] = {.lex_state = 2182, .external_lex_state = 8},
  [503] = {.lex_state = 2182, .external_lex_state = 10},
  [504] = {.lex_state = 2182, .external_lex_state = 10},
  [505] = {.lex_state = 2182, .external_lex_state = 8},
  [506] = {.lex_state = 2182, .external_lex_state = 8},
  [507] = {.lex_state = 2182, .external_lex_state = 4},
  [508] = {.lex_state = 2182, .external_lex_state = 10},
  [509] = {.lex_state = 2182, .external_lex_state = 10},
  [510] = {.lex_state = 2182, .external_lex_state = 10},
  [511] = {.lex_state = 2182, .external_lex_state = 8},
  [512] = {.lex_state = 2182, .external_lex_state = 7},
  [513] = {.lex_state = 2182, .external_lex_state = 7},
  [514] = {.lex_state = 2182, .external_lex_state = 7},
  [515] = {.lex_state = 2182, .external_lex_state = 7},
  [516] = {.lex_state = 2182, .external_lex_state = 7},
  [517] = {.lex_state = 2182, .external_lex_state = 8},
  [518] = {.lex_state = 2182, .external_lex_state = 7},
  [519] = {.lex_state = 2182, .external_lex_state = 7},
  [520] = {.lex_state = 2182, .external_lex_state = 7},
  [521] = {.lex_state = 2182, .external_lex_state = 8},
  [522] = {.lex_state = 2182, .external_lex_state = 7},
  [523] = {.lex_state = 2182, .external_lex_state = 8},
  [524] = {.lex_state = 2182, .external_lex_state = 8},
  [525] = {.lex_state = 2182, .external_lex_state = 8},
  [526] = {.lex_state = 2182, .external_lex_state = 8},
  [527] = {.lex_state = 2182, .external_lex_state = 8},
  [528] = {.lex_state = 2182, .external_lex_state = 7},
  [529] = {.lex_state = 2182, .external_lex_state = 7},
  [530] = {.lex_state = 2182, .external_lex_state = 7},
  [531] = {.lex_state = 2182, .external_lex_state = 7},
  [532] = {.lex_state = 2182, .external_lex_state = 7},
  [533] = {.lex_state = 2182, .external_lex_state = 7},
  [534] = {.lex_state = 2182, .external_lex_state = 7},
  [535] = {.lex_state = 2182, .external_lex_state = 7},
  [536] = {.lex_state = 2182, .external_lex_state = 10},
  [537] = {.lex_state = 2182, .external_lex_state = 10},
  [538] = {.lex_state = 2182, .external_lex_state = 7},
  [539] = {.lex_state = 2182, .external_lex_state = 10},
  [540] = {.lex_state = 2182, .external_lex_state = 10},
  [541] = {.lex_state = 2182, .external_lex_state = 10},
  [542] = {.lex_state = 2182, .external_lex_state = 10},
  [543] = {.lex_state = 2182, .external_lex_state = 10},
  [544] = {.lex_state = 2182, .external_lex_state = 10},
  [545] = {.lex_state = 2182, .external_lex_state = 10},
  [546] = {.lex_state = 2182, .external_lex_state = 10},
  [547] = {.lex_state = 2182, .external_lex_state = 10},
  [548] = {.lex_state = 2182, .external_lex_state = 10},
  [549] = {.lex_state = 2182, .external_lex_state = 10},
  [550] = {.lex_state = 2182, .external_lex_state = 10},
  [551] = {.lex_state = 2182, .external_lex_state = 10},
  [552] = {.lex_state = 2182, .external_lex_state = 10},
  [553] = {.lex_state = 2182, .external_lex_state = 10},
  [554] = {.lex_state = 2182, .external_lex_state = 10},
  [555] = {.lex_state = 2182, .external_lex_state = 10},
  [556] = {.lex_state = 2182, .external_lex_state = 10},
  [557] = {.lex_state = 2182, .external_lex_state = 10},
  [558] = {.lex_state = 2182, .external_lex_state = 10},
  [559] = {.lex_state = 2182, .external_lex_state = 10},
  [560] = {.lex_state = 2182, .external_lex_state = 8},
  [561] = {.lex_state = 2182, .external_lex_state = 9},
  [562] = {.lex_state = 2182, .external_lex_state = 10},
  [563] = {.lex_state = 2182, .external_lex_state = 10},
  [564] = {.lex_state = 2182, .external_lex_state = 10},
  [565] = {.lex_state = 2182, .external_lex_state = 10},
  [566] = {.lex_state = 2182, .external_lex_state = 10},
  [567] = {.lex_state = 2182, .external_lex_state = 10},
  [568] = {.lex_state = 2182, .external_lex_state = 10},
  [569] = {.lex_state = 2182, .external_lex_state = 10},
  [570] = {.lex_state = 2182, .external_lex_state = 10},
  [571] = {.lex_state = 2182, .external_lex_state = 10},
  [572] = {.lex_state = 2182, .external_lex_state = 10},
  [573] = {.lex_state = 2182, .external_lex_state = 10},
  [574] = {.lex_state = 2182, .external_lex_state = 10},
  [575] = {.lex_state = 2182, .external_lex_state = 10},
  [576] = {.lex_state = 2182, .external_lex_state = 10},
  [577] = {.lex_state = 2182, .external_lex_state = 10},
  [578] = {.lex_state = 2182, .external_lex_state = 10},
  [579] = {.lex_state = 2182, .external_lex_state = 10},
  [580] = {.lex_state = 2182, .external_lex_state = 10},
  [581] = {.lex_state = 2182, .external_lex_state = 10},
  [582] = {.lex_state = 2182, .external_lex_state = 10},
  [583] = {.lex_state = 2182, .external_lex_state = 10},
  [584] = {.lex_state = 2182, .external_lex_state = 10},
  [585] = {.lex_state = 2182, .external_lex_state = 10},
  [586] = {.lex_state = 2182, .external_lex_state = 10},
  [587] = {.lex_state = 2182, .external_lex_state = 10},
  [588] = {.lex_state = 2182, .external_lex_state = 10},
  [589] = {.lex_state = 2182, .external_lex_state = 10},
  [590] = {.lex_state = 2182, .external_lex_state = 10},
  [591] = {.lex_state = 2182, .external_lex_state = 10},
  [592] = {.lex_state = 2182, .external_lex_state = 10},
  [593] = {.lex_state = 2182, .external_lex_state = 10},
  [594] = {.lex_state = 2182, .external_lex_state = 10},
  [595] = {.lex_state = 2182, .external_lex_state = 10},
  [596] = {.lex_state = 2182, .external_lex_state = 10},
  [597] = {.lex_state = 2182, .external_lex_state = 10},
  [598] = {.lex_state = 2182, .external_lex_state = 10},
  [599] = {.lex_state = 2182, .external_lex_state = 10},
  [600] = {.lex_state = 2182, .external_lex_state = 8},
  [601] = {.lex_state = 2182, .external_lex_state = 9},
  [602] = {.lex_state = 2182, .external_lex_state = 10},
  [603] = {.lex_state = 2182, .external_lex_state = 10},
  [604] = {.lex_state = 2182, .external_lex_state = 10},
  [605] = {.lex_state = 2182, .external_lex_state = 8},
  [606] = {.lex_state = 2182, .external_lex_state = 10},
  [607] = {.lex_state = 2182, .external_lex_state = 10},
  [608] = {.lex_state = 2182, .external_lex_state = 9},
  [609] = {.lex_state = 2182, .external_lex_state = 9},
  [610] = {.lex_state = 2182, .external_lex_state = 8},
  [611] = {.lex_state = 2182, .external_lex_state = 9},
  [612] = {.lex_state = 2182, .external_lex_state = 9},
  [613] = {.lex_state = 2182, .external_lex_state = 9},
  [614] = {.lex_state = 2182, .external_lex_state = 10},
  [615] = {.lex_state = 2182, .external_lex_state = 10},
  [616] = {.lex_state = 2182, .external_lex_state = 10},
  [617] = {.lex_state = 2182, .external_lex_state = 7},
  [618] = {.lex_state = 2182, .external_lex_state = 8},
  [619] = {.lex_state = 2182, .external_lex_state = 8},
  [620] = {.lex_state = 2182, .external_lex_state = 9},
  [621] = {.lex_state = 2182, .external_lex_state = 8},
  [622] = {.lex_state = 2182, .external_lex_state = 8},
  [623] = {.lex_state = 2182, .external_lex_state = 8},
  [624] = {.lex_state = 2182, .external_lex_state = 10},
  [625] = {.lex_state = 2182, .external_lex_state = 8},
  [626] = {.lex_state = 2182, .external_lex_state = 8},
  [627] = {.lex_state = 2182, .external_lex_state = 8},
  [628] = {.lex_state = 2182, .external_lex_state = 8},
  [629] = {.lex_state = 2182, .external_lex_state = 7},
  [630] = {.lex_state = 2182, .external_lex_state = 7},
  [631] = {.lex_state = 2182, .external_lex_state = 7},
  [632] = {.lex_state = 2182, .external_lex_state = 9},
  [633] = {.lex_state = 2182, .external_lex_state = 7},
  [634] = {.lex_state = 2182, .external_lex_state = 7},
  [635] = {.lex_state = 2182, .external_lex_state = 8},
  [636] = {.lex_state = 2182, .external_lex_state = 9},
  [637] = {.lex_state = 2182, .external_lex_state = 9},
  [638] = {.lex_state = 2182, .external_lex_state = 9},
  [639] = {.lex_state = 2182, .external_lex_state = 10},
  [640] = {.lex_state = 2182, .external_lex_state = 7},
  [641] = {.lex_state = 2182, .external_lex_state = 9},
  [642] = {.lex_state = 2182, .external_lex_state = 9},
  [643] = {.lex_state = 2182, .external_lex_state = 7},
  [644] = {.lex_state = 2182, .external_lex_state = 7},
  [645] = {.lex_state = 2},
  [646] = {.lex_state = 2},
  [647] = {.lex_state = 2},
  [648] = {.lex_state = 2},
  [649] = {.lex_state = 2},
  [650] = {.lex_state = 2},
  [651] = {.lex_state = 2},
  [652] = {.lex_state = 2},
  [653] = {.lex_state = 2},
  [654] = {.lex_state = 2, .external_lex_state = 17},
  [655] = {.lex_state = 2, .external_lex_state = 17},
  [656] = {.lex_state = 2},
  [657] = {.lex_state = 6, .external_lex_state = 11},
  [658] = {.lex_state = 2},
  [659] = {.lex_state = 8, .external_lex_state = 11},
  [660] = {.lex_state = 2},
  [661] = {.lex_state = 2},
  [662] = {.lex_state = 2},
  [663] = {.lex_state = 2},
  [664] = {.lex_state = 2},
  [665] = {.lex_state = 2},
  [666] = {.lex_state = 2},
  [667] = {.lex_state = 2},
  [668] = {.lex_state = 2},
  [669] = {.lex_state = 2},
  [670] = {.lex_state = 1, .external_lex_state = 18},
  [671] = {.lex_state = 1, .external_lex_state = 18},
  [672] = {.lex_state = 3, .external_lex_state = 11},
  [673] = {.lex_state = 7, .external_lex_state = 15},
  [674] = {.lex_state = 10, .external_lex_state = 15},
  [675] = {.lex_state = 1, .external_lex_state = 19},
  [676] = {.lex_state = 1, .external_lex_state = 16},
  [677] = {.lex_state = 1, .external_lex_state = 16},
  [678] = {.lex_state = 4, .external_lex_state = 15},
  [679] = {.lex_state = 1, .external_lex_state = 16},
  [680] = {.lex_state = 1, .external_lex_state = 16},
  [681] = {.lex_state = 2},
  [682] = {.lex_state = 9, .external_lex_state = 11},
  [683] = {.lex_state = 2},
  [684] = {.lex_state = 2},
  [685] = {.lex_state = 2},
  [686] = {.lex_state = 2, .external_lex_state = 17},
  [687] = {.lex_state = 2},
  [688] = {.lex_state = 2, .external_lex_state = 17},
  [689] = {.lex_state = 9, .external_lex_state = 20},
  [690] = {.lex_state = 2},
  [691] = {.lex_state = 2, .external_lex_state = 17},
  [692] = {.lex_state = 2},
  [693] = {.lex_state = 11, .external_lex_state = 21},
  [694] = {.lex_state = 2},
  [695] = {.lex_state = 9, .external_lex_state = 20},
  [696] = {.lex_state = 9, .external_lex_state = 22},
  [697] = {.lex_state = 9, .external_lex_state = 22},
  [698] = {.lex_state = 2},
  [699] = {.lex_state = 2},
  [700] = {.lex_state = 2},
  [701] = {.lex_state = 2},
  [702] = {.lex_state = 2},
  [703] = {.lex_state = 2},
  [704] = {.lex_state = 11, .external_lex_state = 15},
  [705] = {.lex_state = 5, .external_lex_state = 17},
  [706] = {.lex_state = 9, .external_lex_state = 11},
  [707] = {.lex_state = 11, .external_lex_state = 21},
  [708] = {.lex_state = 11, .external_lex_state = 23},
  [709] = {.lex_state = 9, .external_lex_state = 11},
  [710] = {.lex_state = 9, .external_lex_state = 11},
  [711] = {.lex_state = 9, .external_lex_state = 11},
  [712] = {.lex_state = 9, .external_lex_state = 11},
  [713] = {.lex_state = 11, .external_lex_state = 23},
  [714] = {.lex_state = 5, .external_lex_state = 17},
  [715] = {.lex_state = 9, .external_lex_state = 11},
  [716] = {.lex_state = 5, .external_lex_state = 17},
  [717] = {.lex_state = 9, .external_lex_state = 11},
  [718] = {.lex_state = 5, .external_lex_state = 17},
  [719] = {.lex_state = 5, .external_lex_state = 17},
  [720] = {.lex_state = 5, .external_lex_state = 17},
  [721] = {.lex_state = 5, .external_lex_state = 17},
  [722] = {.lex_state = 9, .external_lex_state = 11},
  [723] = {.lex_state = 5, .external_lex_state = 17},
  [724] = {.lex_state = 5, .external_lex_state = 17},
  [725] = {.lex_state = 9, .external_lex_state = 11},
  [726] = {.lex_state = 9, .external_lex_state = 11},
  [727] = {.lex_state = 9, .external_lex_state = 11},
  [728] = {.lex_state = 5, .external_lex_state = 17},
  [729] = {.lex_state = 9, .external_lex_state = 11},
  [730] = {.lex_state = 9, .external_lex_state = 11},
  [731] = {.lex_state = 9, .external_lex_state = 11},
  [732] = {.lex_state = 9, .external_lex_state = 11},
  [733] = {.lex_state = 9, .external_lex_state = 11},
  [734] = {.lex_state = 9, .external_lex_state = 11},
  [735] = {.lex_state = 9, .external_lex_state = 11},
  [736] = {.lex_state = 9, .external_lex_state = 11},
  [737] = {.lex_state = 9, .external_lex_state = 11},
  [738] = {.lex_state = 9, .external_lex_state = 11},
  [739] = {.lex_state = 9, .external_lex_state = 11},
  [740] = {.lex_state = 2182},
  [741] = {.lex_state = 2182},
  [742] = {.lex_state = 5, .external_lex_state = 17},
  [743] = {.lex_state = 5, .external_lex_state = 17},
  [744] = {.lex_state = 2},
  [745] = {.lex_state = 2182},
  [746] = {.lex_state = 5, .external_lex_state = 17},
  [747] = {.lex_state = 5, .external_lex_state = 17},
  [748] = {.lex_state = 5},
  [749] = {.lex_state = 5},
  [750] = {.lex_state = 5},
  [751] = {.lex_state = 5},
  [752] = {.lex_state = 5},
  [753] = {.lex_state = 5},
  [754] = {.lex_state = 13},
  [755] = {.lex_state = 12},
  [756] = {.lex_state = 5},
  [757] = {.lex_state = 5},
  [758] = {.lex_state = 5},
  [759] = {.lex_state = 5},
  [760] = {.lex_state = 12},
  [761] = {.lex_state = 5},
  [762] = {.lex_state = 13},
  [763] = {.lex_state = 5},
  [764] = {.lex_state = 5},
  [765] = {.lex_state = 5},
  [766] = {.lex_state = 5},
  [767] = {.lex_state = 5},
  [768] = {.lex_state = 5},
  [769] = {.lex_state = 5},
  [770] = {.lex_state = 5},
  [771] = {.lex_state = 5},
  [772] = {.lex_state = 5},
  [773] = {.lex_state = 5},
  [774] = {.lex_state = 5},
  [775] = {.lex_state = 5},
  [776] = {.lex_state = 5},
  [777] = {.lex_state = 12},
  [778] = {.lex_state = 5},
  [779] = {.lex_state = 12},
  [780] = {.lex_state = 11, .external_lex_state = 15},
  [781] = {.lex_state = 13},
  [782] = {.lex_state = 13},
  [783] = {.lex_state = 13},
  [784] = {.lex_state = 11, .external_lex_state = 15},
  [785] = {.lex_state = 11, .external_lex_state = 15},
  [786] = {.lex_state = 11, .external_lex_state = 15},
  [787] = {.lex_state = 11, .external_lex_state = 15},
  [788] = {.lex_state = 12},
  [789] = {.lex_state = 11, .external_lex_state = 15},
  [790] = {.lex_state = 11, .external_lex_state = 15},
  [791] = {.lex_state = 5},
  [792] = {.lex_state = 11, .external_lex_state = 15},
  [793] = {.lex_state = 5},
  [794] = {.lex_state = 12},
  [795] = {.lex_state = 5},
  [796] = {.lex_state = 13},
  [797] = {.lex_state = 11, .external_lex_state = 15},
  [798] = {.lex_state = 11, .external_lex_state = 15},
  [799] = {.lex_state = 11, .external_lex_state = 15},
  [800] = {.lex_state = 13},
  [801] = {.lex_state = 11, .external_lex_state = 15},
  [802] = {.lex_state = 12},
  [803] = {.lex_state = 11, .external_lex_state = 15},
  [804] = {.lex_state = 11, .external_lex_state = 15},
  [805] = {.lex_state = 11, .external_lex_state = 15},
  [806] = {.lex_state = 11, .external_lex_state = 15},
  [807] = {.lex_state = 11, .external_lex_state = 15},
  [808] = {.lex_state = 13},
  [809] = {.lex_state = 5},
  [810] = {.lex_state = 5},
  [811] = {.lex_state = 5},
  [812] = {.lex_state = 5},
  [813] = {.lex_state = 11, .external_lex_state = 15},
  [814] = {.lex_state = 5},
  [815] = {.lex_state = 5},
  [816] = {.lex_state = 11, .external_lex_state = 15},
  [817] = {.lex_state = 5},
  [818] = {.lex_state = 11, .external_lex_state = 15},
  [819] = {.lex_state = 12},
  [820] = {.lex_state = 5},
  [821] = {.lex_state = 11, .external_lex_state = 15},
  [822] = {.lex_state = 5},
  [823] = {.lex_state = 5},
  [824] = {.lex_state = 5},
  [825] = {.lex_state = 5},
  [826] = {.lex_state = 5},
  [827] = {.lex_state = 5},
  [828] = {.lex_state = 14},
  [829] = {.lex_state = 14},
  [830] = {.lex_state = 2},
  [831] = {.lex_state = 2, .external_lex_state = 17},
  [832] = {.lex_state = 2, .external_lex_state = 17},
  [833] = {.lex_state = 14},
  [834] = {.lex_state = 2, .external_lex_state = 17},
  [835] = {.lex_state = 14},
  [836] = {.lex_state = 2, .external_lex_state = 17},
  [837] = {.lex_state = 2},
  [838] = {.lex_state = 2, .external_lex_state = 17},
  [839] = {.lex_state = 2, .external_lex_state = 17},
  [840] = {.lex_state = 14},
  [841] = {.lex_state = 14},
  [842] = {.lex_state = 14},
  [843] = {.lex_state = 14},
  [844] = {.lex_state = 2},
  [845] = {.lex_state = 2, .external_lex_state = 17},
  [846] = {.lex_state = 14},
  [847] = {.lex_state = 14},
  [848] = {.lex_state = 2, .external_lex_state = 24},
  [849] = {.lex_state = 14},
  [850] = {.lex_state = 2, .external_lex_state = 24},
  [851] = {.lex_state = 14},
  [852] = {.lex_state = 14},
  [853] = {.lex_state = 14},
  [854] = {.lex_state = 14},
  [855] = {.lex_state = 2},
  [856] = {.lex_state = 14},
  [857] = {.lex_state = 14},
  [858] = {.lex_state = 14},
  [859] = {.lex_state = 14},
  [860] = {.lex_state = 14},
  [861] = {.lex_state = 14},
  [862] = {.lex_state = 2},
  [863] = {.lex_state = 2},
  [864] = {.lex_state = 2},
  [865] = {.lex_state = 2},
  [866] = {.lex_state = 2},
  [867] = {.lex_state = 2},
  [868] = {.lex_state = 2},
  [869] = {.lex_state = 2},
  [870] = {.lex_state = 2},
  [871] = {.lex_state = 2},
  [872] = {.lex_state = 2},
  [873] = {.lex_state = 2},
  [874] = {.lex_state = 2},
  [875] = {.lex_state = 2, .external_lex_state = 17},
  [876] = {.lex_state = 2},
  [877] = {.lex_state = 2},
  [878] = {.lex_state = 2},
  [879] = {.lex_state = 2},
  [880] = {.lex_state = 2},
  [881] = {.lex_state = 5, .external_lex_state = 17},
  [882] = {.lex_state = 12, .external_lex_state = 24},
  [883] = {.lex_state = 2},
  [884] = {.lex_state = 2},
  [885] = {.lex_state = 2182, .external_lex_state = 17},
  [886] = {.lex_state = 5, .external_lex_state = 24},
  [887] = {.lex_state = 13, .external_lex_state = 24},
  [888] = {.lex_state = 5, .external_lex_state = 17},
  [889] = {.lex_state = 5},
  [890] = {.lex_state = 12, .external_lex_state = 17},
  [891] = {.lex_state = 5, .external_lex_state = 24},
  [892] = {.lex_state = 13, .external_lex_state = 24},
  [893] = {.lex_state = 12, .external_lex_state = 24},
  [894] = {.lex_state = 13, .external_lex_state = 17},
  [895] = {.lex_state = 14, .external_lex_state = 17},
  [896] = {.lex_state = 13},
  [897] = {.lex_state = 12},
  [898] = {.lex_state = 12},
  [899] = {.lex_state = 12},
  [900] = {.lex_state = 14, .external_lex_state = 24},
  [901] = {.lex_state = 14, .external_lex_state = 24},
  [902] = {.lex_state = 5},
  [903] = {.lex_state = 2182},
  [904] = {.lex_state = 5},
  [905] = {.lex_state = 14, .external_lex_state = 17},
  [906] = {.lex_state = 13},
  [907] = {.lex_state = 5},
  [908] = {.lex_state = 14, .external_lex_state = 17},
  [909] = {.lex_state = 5},
  [910] = {.lex_state = 13},
  [911] = {.lex_state = 14},
  [912] = {.lex_state = 14},
  [913] = {.lex_state = 14},
  [914] = {.lex_state = 14},
  [915] = {.lex_state = 14},
  [916] = {.lex_state = 14},
  [917] = {.lex_state = 14},
  [918] = {.lex_state = 14},
  [919] = {.lex_state = 14},
  [920] = {.lex_state = 14},
  [921] = {.lex_state = 14},
  [922] = {.lex_state = 14},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 0},
  [925] = {.lex_state = 0},
  [926] = {.lex_state = 0},
  [927] = {.lex_state = 0},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 0},
  [930] = {.lex_state = 0},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 0},
  [933] = {.lex_state = 0},
  [934] = {.lex_state = 0},
  [935] = {.lex_state = 0},
  [936] = {.lex_state = 0},
  [937] = {.lex_state = 0},
  [938] = {.lex_state = 0},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 0},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 0},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 0},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 0},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 15},
  [952] = {.lex_state = 15},
  [953] = {.lex_state = 0},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 0},
  [956] = {.lex_state = 0},
  [957] = {.lex_state = 0},
  [958] = {.lex_state = 15},
  [959] = {.lex_state = 0},
  [960] = {.lex_state = 0},
  [961] = {.lex_state = 0},
  [962] = {.lex_state = 15},
  [963] = {.lex_state = 16},
  [964] = {.lex_state = 16},
  [965] = {.lex_state = 2182},
  [966] = {.lex_state = 16},
  [967] = {.lex_state = 16},
  [968] = {.lex_state = 16},
  [969] = {.lex_state = 16},
  [970] = {.lex_state = 16},
  [971] = {.lex_state = 16},
  [972] = {.lex_state = 16},
  [973] = {.lex_state = 15},
  [974] = {.lex_state = 16},
  [975] = {.lex_state = 16},
  [976] = {.lex_state = 16},
  [977] = {.lex_state = 16},
  [978] = {.lex_state = 2182},
  [979] = {.lex_state = 2182},
  [980] = {.lex_state = 16},
  [981] = {.lex_state = 16},
  [982] = {.lex_state = 16},
  [983] = {.lex_state = 0},
  [984] = {.lex_state = 16, .external_lex_state = 24},
  [985] = {.lex_state = 15, .external_lex_state = 24},
  [986] = {.lex_state = 15, .external_lex_state = 24},
  [987] = {.lex_state = 0},
  [988] = {.lex_state = 0},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 0},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 0},
  [996] = {.lex_state = 0},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 0},
  [1001] = {.lex_state = 0},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0},
  [1008] = {.lex_state = 0},
  [1009] = {.lex_state = 0},
  [1010] = {.lex_state = 0},
  [1011] = {.lex_state = 0},
  [1012] = {.lex_state = 0},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 0},
  [1020] = {.lex_state = 0},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 0},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 0},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 0},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 0},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 0},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 0},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 0},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 0},
  [1054] = {.lex_state = 0},
  [1055] = {.lex_state = 0},
  [1056] = {.lex_state = 0},
  [1057] = {.lex_state = 0},
  [1058] = {.lex_state = 0},
  [1059] = {.lex_state = 0},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 0},
  [1063] = {.lex_state = 0},
  [1064] = {.lex_state = 0},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 0},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 0},
  [1073] = {.lex_state = 0},
  [1074] = {.lex_state = 0},
  [1075] = {.lex_state = 0},
  [1076] = {.lex_state = 0},
  [1077] = {.lex_state = 0},
  [1078] = {.lex_state = 16, .external_lex_state = 24},
  [1079] = {.lex_state = 0},
  [1080] = {.lex_state = 0},
  [1081] = {.lex_state = 0},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 0},
  [1084] = {.lex_state = 0},
  [1085] = {.lex_state = 0},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 0},
  [1088] = {.lex_state = 0},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 0},
  [1091] = {.lex_state = 0},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 0},
  [1094] = {.lex_state = 0},
  [1095] = {.lex_state = 0},
  [1096] = {.lex_state = 0},
  [1097] = {.lex_state = 0},
  [1098] = {.lex_state = 0},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 0},
  [1102] = {.lex_state = 0},
  [1103] = {.lex_state = 16},
  [1104] = {.lex_state = 16},
  [1105] = {.lex_state = 15},
  [1106] = {.lex_state = 15},
  [1107] = {.lex_state = 0},
  [1108] = {.lex_state = 0},
  [1109] = {.lex_state = 0},
  [1110] = {.lex_state = 0},
  [1111] = {.lex_state = 0},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 0},
  [1114] = {.lex_state = 0},
  [1115] = {.lex_state = 0},
  [1116] = {.lex_state = 0},
  [1117] = {.lex_state = 0},
  [1118] = {.lex_state = 0},
  [1119] = {.lex_state = 0},
  [1120] = {.lex_state = 0},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 0},
  [1123] = {.lex_state = 0},
  [1124] = {.lex_state = 0},
  [1125] = {.lex_state = 0},
  [1126] = {.lex_state = 0, .external_lex_state = 25},
  [1127] = {.lex_state = 0},
  [1128] = {.lex_state = 0},
  [1129] = {.lex_state = 0},
  [1130] = {.lex_state = 0},
  [1131] = {.lex_state = 0},
  [1132] = {.lex_state = 0},
  [1133] = {.lex_state = 0},
  [1134] = {.lex_state = 0},
  [1135] = {.lex_state = 0},
  [1136] = {.lex_state = 0},
  [1137] = {.lex_state = 0},
  [1138] = {.lex_state = 0},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 0},
  [1141] = {.lex_state = 0},
  [1142] = {.lex_state = 0},
  [1143] = {.lex_state = 0},
  [1144] = {.lex_state = 0},
  [1145] = {.lex_state = 0},
  [1146] = {.lex_state = 0},
  [1147] = {.lex_state = 0, .external_lex_state = 26},
  [1148] = {.lex_state = 0},
  [1149] = {.lex_state = 0},
  [1150] = {.lex_state = 0},
  [1151] = {.lex_state = 0},
  [1152] = {.lex_state = 0},
  [1153] = {.lex_state = 0},
  [1154] = {.lex_state = 0, .external_lex_state = 26},
  [1155] = {.lex_state = 0},
  [1156] = {.lex_state = 0},
  [1157] = {.lex_state = 0, .external_lex_state = 26},
  [1158] = {.lex_state = 0},
  [1159] = {.lex_state = 0, .external_lex_state = 26},
  [1160] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym__backslash_escape] = ACTIONS(1),
    [sym_entity_reference] = ACTIONS(1),
    [sym_numeric_character_reference] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [sym__newline_token] = ACTIONS(1),
    [sym_uri_autolink] = ACTIONS(1),
    [sym_email_autolink] = ACTIONS(1),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1),
    [anon_sym_DASH_DASH_GT] = ACTIONS(1),
    [anon_sym_LT_QMARK] = ACTIONS(1),
    [anon_sym_QMARK_GT] = ACTIONS(1),
    [aux_sym__declaration_token1] = ACTIONS(1),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK_RBRACK_GT] = ACTIONS(1),
    [sym__whitespace_ge_2] = ACTIONS(1),
    [aux_sym__whitespace_token1] = ACTIONS(1),
    [sym__word_no_digit] = ACTIONS(1),
    [sym__digits] = ACTIONS(1),
    [sym__error] = ACTIONS(1),
    [sym__trigger_error] = ACTIONS(1),
    [sym__code_span_start] = ACTIONS(1),
    [sym__code_span_close] = ACTIONS(1),
    [sym__emphasis_open_star] = ACTIONS(1),
    [sym__emphasis_open_underscore] = ACTIONS(1),
    [sym__emphasis_close_star] = ACTIONS(1),
    [sym__emphasis_close_underscore] = ACTIONS(1),
    [sym__last_token_whitespace] = ACTIONS(1),
    [sym__last_token_punctuation] = ACTIONS(1),
    [sym__strikethrough_open] = ACTIONS(1),
    [sym__strikethrough_close] = ACTIONS(1),
    [sym__latex_span_start] = ACTIONS(1),
    [sym__latex_span_close] = ACTIONS(1),
    [sym__unclosed_span] = ACTIONS(1),
  },
  [1] = {
    [sym_inline] = STATE(1142),
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(264),
    [sym_shortcut_link] = STATE(271),
    [sym_full_reference_link] = STATE(271),
    [sym_collapsed_reference_link] = STATE(271),
    [sym_inline_link] = STATE(271),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(265),
    [sym__image_shortcut_link] = STATE(265),
    [sym__image_full_reference_link] = STATE(265),
    [sym__image_collapsed_reference_link] = STATE(265),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(266),
    [sym__html_tag] = STATE(267),
    [sym__open_tag] = STATE(270),
    [sym__closing_tag] = STATE(270),
    [sym__html_comment] = STATE(270),
    [sym__processing_instruction] = STATE(270),
    [sym__declaration] = STATE(270),
    [sym__cdata_section] = STATE(270),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(271),
    [sym__text_base] = STATE(154),
    [sym__inline_element] = STATE(271),
    [aux_sym__inline] = STATE(31),
    [sym__strikethrough] = STATE(271),
    [sym__emphasis_star] = STATE(274),
    [sym__strong_emphasis_star] = STATE(271),
    [sym__emphasis_underscore] = STATE(274),
    [sym__strong_emphasis_underscore] = STATE(271),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(3),
    [sym_entity_reference] = ACTIONS(5),
    [sym_numeric_character_reference] = ACTIONS(5),
    [anon_sym_LBRACK] = ACTIONS(7),
    [anon_sym_RBRACK] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(11),
    [anon_sym_GT] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_POUND] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_PERCENT] = ACTIONS(13),
    [anon_sym_AMP] = ACTIONS(17),
    [anon_sym_SQUOTE] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(13),
    [anon_sym_DASH] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(13),
    [anon_sym_SLASH] = ACTIONS(13),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_SEMI] = ACTIONS(13),
    [anon_sym_EQ] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(13),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_BSLASH] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(13),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_PIPE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(13),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(13),
    [sym__newline_token] = ACTIONS(21),
    [sym_uri_autolink] = ACTIONS(5),
    [sym_email_autolink] = ACTIONS(5),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(23),
    [anon_sym_LT_QMARK] = ACTIONS(25),
    [aux_sym__declaration_token1] = ACTIONS(27),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(29),
    [sym__whitespace_ge_2] = ACTIONS(31),
    [aux_sym__whitespace_token1] = ACTIONS(33),
    [sym__word_no_digit] = ACTIONS(5),
    [sym__digits] = ACTIONS(5),
    [sym__code_span_start] = ACTIONS(35),
    [sym__emphasis_open_star] = ACTIONS(37),
    [sym__emphasis_open_underscore] = ACTIONS(39),
    [sym__last_token_whitespace] = ACTIONS(41),
    [sym__strikethrough_open] = ACTIONS(43),
    [sym__latex_span_start] = ACTIONS(45),
    [sym__unclosed_span] = ACTIONS(5),
  },
  [2] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(40),
    [sym_full_reference_link] = STATE(40),
    [sym_collapsed_reference_link] = STATE(40),
    [sym_inline_link] = STATE(40),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(40),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(40),
    [aux_sym__inline_no_underscore] = STATE(40),
    [sym__strikethrough] = STATE(40),
    [sym__emphasis_star] = STATE(282),
    [sym__strong_emphasis_star] = STATE(40),
    [sym__emphasis_underscore] = STATE(269),
    [sym__strong_emphasis_underscore] = STATE(40),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(47),
    [sym_entity_reference] = ACTIONS(50),
    [sym_numeric_character_reference] = ACTIONS(50),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_RBRACK] = ACTIONS(56),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_GT] = ACTIONS(62),
    [anon_sym_BANG] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(62),
    [anon_sym_POUND] = ACTIONS(62),
    [anon_sym_DOLLAR] = ACTIONS(62),
    [anon_sym_PERCENT] = ACTIONS(62),
    [anon_sym_AMP] = ACTIONS(68),
    [anon_sym_SQUOTE] = ACTIONS(62),
    [anon_sym_STAR] = ACTIONS(62),
    [anon_sym_PLUS] = ACTIONS(62),
    [anon_sym_COMMA] = ACTIONS(62),
    [anon_sym_DASH] = ACTIONS(62),
    [anon_sym_DOT] = ACTIONS(62),
    [anon_sym_SLASH] = ACTIONS(62),
    [anon_sym_COLON] = ACTIONS(62),
    [anon_sym_SEMI] = ACTIONS(62),
    [anon_sym_EQ] = ACTIONS(62),
    [anon_sym_QMARK] = ACTIONS(62),
    [anon_sym_AT] = ACTIONS(62),
    [anon_sym_BSLASH] = ACTIONS(71),
    [anon_sym_CARET] = ACTIONS(62),
    [anon_sym__] = ACTIONS(62),
    [anon_sym_BQUOTE] = ACTIONS(62),
    [anon_sym_LBRACE] = ACTIONS(62),
    [anon_sym_PIPE] = ACTIONS(62),
    [anon_sym_RBRACE] = ACTIONS(62),
    [anon_sym_TILDE] = ACTIONS(62),
    [anon_sym_LPAREN] = ACTIONS(62),
    [anon_sym_RPAREN] = ACTIONS(62),
    [sym__newline_token] = ACTIONS(74),
    [sym_uri_autolink] = ACTIONS(50),
    [sym_email_autolink] = ACTIONS(50),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(77),
    [anon_sym_LT_QMARK] = ACTIONS(80),
    [aux_sym__declaration_token1] = ACTIONS(83),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(86),
    [sym__whitespace_ge_2] = ACTIONS(89),
    [aux_sym__whitespace_token1] = ACTIONS(92),
    [sym__word_no_digit] = ACTIONS(50),
    [sym__digits] = ACTIONS(50),
    [sym__code_span_start] = ACTIONS(95),
    [sym__emphasis_open_star] = ACTIONS(98),
    [sym__emphasis_open_underscore] = ACTIONS(101),
    [sym__last_token_punctuation] = ACTIONS(104),
    [sym__strikethrough_open] = ACTIONS(106),
    [sym__strikethrough_close] = ACTIONS(109),
    [sym__latex_span_start] = ACTIONS(111),
    [sym__unclosed_span] = ACTIONS(50),
  },
  [3] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(346),
    [sym_shortcut_link] = STATE(42),
    [sym_full_reference_link] = STATE(42),
    [sym_collapsed_reference_link] = STATE(42),
    [sym_inline_link] = STATE(42),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(348),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(42),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(42),
    [aux_sym__inline_no_star] = STATE(42),
    [sym__strikethrough] = STATE(42),
    [sym__emphasis_star] = STATE(280),
    [sym__strong_emphasis_star] = STATE(42),
    [sym__emphasis_underscore] = STATE(281),
    [sym__strong_emphasis_underscore] = STATE(42),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [ts_builtin_sym_end] = ACTIONS(114),
    [sym__backslash_escape] = ACTIONS(116),
    [sym_entity_reference] = ACTIONS(119),
    [sym_numeric_character_reference] = ACTIONS(119),
    [anon_sym_LBRACK] = ACTIONS(122),
    [anon_sym_RBRACK] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(128),
    [anon_sym_GT] = ACTIONS(131),
    [anon_sym_BANG] = ACTIONS(134),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(131),
    [anon_sym_DOLLAR] = ACTIONS(131),
    [anon_sym_PERCENT] = ACTIONS(131),
    [anon_sym_AMP] = ACTIONS(137),
    [anon_sym_SQUOTE] = ACTIONS(131),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(131),
    [anon_sym_COMMA] = ACTIONS(131),
    [anon_sym_DASH] = ACTIONS(131),
    [anon_sym_DOT] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(131),
    [anon_sym_COLON] = ACTIONS(131),
    [anon_sym_SEMI] = ACTIONS(131),
    [anon_sym_EQ] = ACTIONS(131),
    [anon_sym_QMARK] = ACTIONS(131),
    [anon_sym_AT] = ACTIONS(131),
    [anon_sym_BSLASH] = ACTIONS(140),
    [anon_sym_CARET] = ACTIONS(131),
    [anon_sym__] = ACTIONS(131),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_PIPE] = ACTIONS(131),
    [anon_sym_RBRACE] = ACTIONS(131),
    [anon_sym_TILDE] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(131),
    [anon_sym_RPAREN] = ACTIONS(131),
    [sym__newline_token] = ACTIONS(143),
    [sym_uri_autolink] = ACTIONS(119),
    [sym_email_autolink] = ACTIONS(119),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(146),
    [anon_sym_LT_QMARK] = ACTIONS(149),
    [aux_sym__declaration_token1] = ACTIONS(152),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(155),
    [sym__whitespace_ge_2] = ACTIONS(158),
    [aux_sym__whitespace_token1] = ACTIONS(161),
    [sym__word_no_digit] = ACTIONS(119),
    [sym__digits] = ACTIONS(119),
    [sym__code_span_start] = ACTIONS(164),
    [sym__emphasis_open_star] = ACTIONS(167),
    [sym__emphasis_open_underscore] = ACTIONS(170),
    [sym__last_token_punctuation] = ACTIONS(173),
    [sym__strikethrough_open] = ACTIONS(175),
    [sym__latex_span_start] = ACTIONS(178),
    [sym__unclosed_span] = ACTIONS(119),
  },
  [4] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(51),
    [sym_full_reference_link] = STATE(51),
    [sym_collapsed_reference_link] = STATE(51),
    [sym_inline_link] = STATE(51),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(51),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(51),
    [aux_sym__inline_no_underscore] = STATE(51),
    [sym__strikethrough] = STATE(51),
    [sym__emphasis_star] = STATE(282),
    [sym__strong_emphasis_star] = STATE(51),
    [sym__emphasis_underscore] = STATE(283),
    [sym__strong_emphasis_underscore] = STATE(51),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [ts_builtin_sym_end] = ACTIONS(114),
    [sym__backslash_escape] = ACTIONS(181),
    [sym_entity_reference] = ACTIONS(184),
    [sym_numeric_character_reference] = ACTIONS(184),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_RBRACK] = ACTIONS(190),
    [anon_sym_LT] = ACTIONS(193),
    [anon_sym_GT] = ACTIONS(196),
    [anon_sym_BANG] = ACTIONS(199),
    [anon_sym_DQUOTE] = ACTIONS(196),
    [anon_sym_POUND] = ACTIONS(196),
    [anon_sym_DOLLAR] = ACTIONS(196),
    [anon_sym_PERCENT] = ACTIONS(196),
    [anon_sym_AMP] = ACTIONS(202),
    [anon_sym_SQUOTE] = ACTIONS(196),
    [anon_sym_STAR] = ACTIONS(196),
    [anon_sym_PLUS] = ACTIONS(196),
    [anon_sym_COMMA] = ACTIONS(196),
    [anon_sym_DASH] = ACTIONS(196),
    [anon_sym_DOT] = ACTIONS(196),
    [anon_sym_SLASH] = ACTIONS(196),
    [anon_sym_COLON] = ACTIONS(196),
    [anon_sym_SEMI] = ACTIONS(196),
    [anon_sym_EQ] = ACTIONS(196),
    [anon_sym_QMARK] = ACTIONS(196),
    [anon_sym_AT] = ACTIONS(196),
    [anon_sym_BSLASH] = ACTIONS(205),
    [anon_sym_CARET] = ACTIONS(196),
    [anon_sym__] = ACTIONS(196),
    [anon_sym_BQUOTE] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(196),
    [anon_sym_PIPE] = ACTIONS(196),
    [anon_sym_RBRACE] = ACTIONS(196),
    [anon_sym_TILDE] = ACTIONS(196),
    [anon_sym_LPAREN] = ACTIONS(196),
    [anon_sym_RPAREN] = ACTIONS(196),
    [sym__newline_token] = ACTIONS(208),
    [sym_uri_autolink] = ACTIONS(184),
    [sym_email_autolink] = ACTIONS(184),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(211),
    [anon_sym_LT_QMARK] = ACTIONS(214),
    [aux_sym__declaration_token1] = ACTIONS(217),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(220),
    [sym__whitespace_ge_2] = ACTIONS(223),
    [aux_sym__whitespace_token1] = ACTIONS(226),
    [sym__word_no_digit] = ACTIONS(184),
    [sym__digits] = ACTIONS(184),
    [sym__code_span_start] = ACTIONS(229),
    [sym__emphasis_open_star] = ACTIONS(232),
    [sym__emphasis_open_underscore] = ACTIONS(235),
    [sym__last_token_punctuation] = ACTIONS(238),
    [sym__strikethrough_open] = ACTIONS(240),
    [sym__latex_span_start] = ACTIONS(243),
    [sym__unclosed_span] = ACTIONS(184),
  },
  [5] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(346),
    [sym_shortcut_link] = STATE(48),
    [sym_full_reference_link] = STATE(48),
    [sym_collapsed_reference_link] = STATE(48),
    [sym_inline_link] = STATE(48),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(348),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(48),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(48),
    [aux_sym__inline_no_star] = STATE(48),
    [sym__strikethrough] = STATE(48),
    [sym__emphasis_star] = STATE(272),
    [sym__strong_emphasis_star] = STATE(48),
    [sym__emphasis_underscore] = STATE(281),
    [sym__strong_emphasis_underscore] = STATE(48),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(246),
    [sym_entity_reference] = ACTIONS(249),
    [sym_numeric_character_reference] = ACTIONS(249),
    [anon_sym_LBRACK] = ACTIONS(252),
    [anon_sym_RBRACK] = ACTIONS(255),
    [anon_sym_LT] = ACTIONS(258),
    [anon_sym_GT] = ACTIONS(261),
    [anon_sym_BANG] = ACTIONS(264),
    [anon_sym_DQUOTE] = ACTIONS(261),
    [anon_sym_POUND] = ACTIONS(261),
    [anon_sym_DOLLAR] = ACTIONS(261),
    [anon_sym_PERCENT] = ACTIONS(261),
    [anon_sym_AMP] = ACTIONS(267),
    [anon_sym_SQUOTE] = ACTIONS(261),
    [anon_sym_STAR] = ACTIONS(261),
    [anon_sym_PLUS] = ACTIONS(261),
    [anon_sym_COMMA] = ACTIONS(261),
    [anon_sym_DASH] = ACTIONS(261),
    [anon_sym_DOT] = ACTIONS(261),
    [anon_sym_SLASH] = ACTIONS(261),
    [anon_sym_COLON] = ACTIONS(261),
    [anon_sym_SEMI] = ACTIONS(261),
    [anon_sym_EQ] = ACTIONS(261),
    [anon_sym_QMARK] = ACTIONS(261),
    [anon_sym_AT] = ACTIONS(261),
    [anon_sym_BSLASH] = ACTIONS(270),
    [anon_sym_CARET] = ACTIONS(261),
    [anon_sym__] = ACTIONS(261),
    [anon_sym_BQUOTE] = ACTIONS(261),
    [anon_sym_LBRACE] = ACTIONS(261),
    [anon_sym_PIPE] = ACTIONS(261),
    [anon_sym_RBRACE] = ACTIONS(261),
    [anon_sym_TILDE] = ACTIONS(261),
    [anon_sym_LPAREN] = ACTIONS(261),
    [anon_sym_RPAREN] = ACTIONS(261),
    [sym__newline_token] = ACTIONS(273),
    [sym_uri_autolink] = ACTIONS(249),
    [sym_email_autolink] = ACTIONS(249),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(276),
    [anon_sym_LT_QMARK] = ACTIONS(279),
    [aux_sym__declaration_token1] = ACTIONS(282),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(285),
    [sym__whitespace_ge_2] = ACTIONS(288),
    [aux_sym__whitespace_token1] = ACTIONS(291),
    [sym__word_no_digit] = ACTIONS(249),
    [sym__digits] = ACTIONS(249),
    [sym__code_span_start] = ACTIONS(294),
    [sym__emphasis_open_star] = ACTIONS(297),
    [sym__emphasis_open_underscore] = ACTIONS(300),
    [sym__last_token_punctuation] = ACTIONS(303),
    [sym__strikethrough_open] = ACTIONS(305),
    [sym__strikethrough_close] = ACTIONS(109),
    [sym__latex_span_start] = ACTIONS(308),
    [sym__unclosed_span] = ACTIONS(249),
  },
  [6] = {
    [sym_backslash_escape] = STATE(151),
    [sym_code_span] = STATE(151),
    [sym_latex_block] = STATE(151),
    [sym__link_text] = STATE(1124),
    [sym__link_text_non_empty] = STATE(513),
    [sym_shortcut_link] = STATE(49),
    [sym_full_reference_link] = STATE(49),
    [sym_collapsed_reference_link] = STATE(49),
    [sym_inline_link] = STATE(49),
    [sym_image] = STATE(151),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(515),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(151),
    [sym__whitespace] = STATE(151),
    [sym__word] = STATE(151),
    [sym__soft_line_break] = STATE(151),
    [sym__inline_base] = STATE(49),
    [sym__text_base] = STATE(151),
    [sym__inline_element_no_tilde] = STATE(49),
    [aux_sym__inline_no_tilde] = STATE(49),
    [sym__strikethrough] = STATE(49),
    [sym__emphasis_star] = STATE(285),
    [sym__strong_emphasis_star] = STATE(49),
    [sym__emphasis_underscore] = STATE(285),
    [sym__strong_emphasis_underscore] = STATE(49),
    [aux_sym__inline_base_repeat1] = STATE(151),
    [ts_builtin_sym_end] = ACTIONS(114),
    [sym__backslash_escape] = ACTIONS(311),
    [sym_entity_reference] = ACTIONS(314),
    [sym_numeric_character_reference] = ACTIONS(314),
    [anon_sym_LBRACK] = ACTIONS(317),
    [anon_sym_RBRACK] = ACTIONS(320),
    [anon_sym_LT] = ACTIONS(323),
    [anon_sym_GT] = ACTIONS(326),
    [anon_sym_BANG] = ACTIONS(329),
    [anon_sym_DQUOTE] = ACTIONS(326),
    [anon_sym_POUND] = ACTIONS(326),
    [anon_sym_DOLLAR] = ACTIONS(326),
    [anon_sym_PERCENT] = ACTIONS(326),
    [anon_sym_AMP] = ACTIONS(332),
    [anon_sym_SQUOTE] = ACTIONS(326),
    [anon_sym_STAR] = ACTIONS(326),
    [anon_sym_PLUS] = ACTIONS(326),
    [anon_sym_COMMA] = ACTIONS(326),
    [anon_sym_DASH] = ACTIONS(326),
    [anon_sym_DOT] = ACTIONS(326),
    [anon_sym_SLASH] = ACTIONS(326),
    [anon_sym_COLON] = ACTIONS(326),
    [anon_sym_SEMI] = ACTIONS(326),
    [anon_sym_EQ] = ACTIONS(326),
    [anon_sym_QMARK] = ACTIONS(326),
    [anon_sym_AT] = ACTIONS(326),
    [anon_sym_BSLASH] = ACTIONS(335),
    [anon_sym_CARET] = ACTIONS(326),
    [anon_sym__] = ACTIONS(326),
    [anon_sym_BQUOTE] = ACTIONS(326),
    [anon_sym_LBRACE] = ACTIONS(326),
    [anon_sym_PIPE] = ACTIONS(326),
    [anon_sym_RBRACE] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(326),
    [anon_sym_LPAREN] = ACTIONS(326),
    [anon_sym_RPAREN] = ACTIONS(326),
    [sym__newline_token] = ACTIONS(338),
    [sym_uri_autolink] = ACTIONS(314),
    [sym_email_autolink] = ACTIONS(314),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(341),
    [anon_sym_LT_QMARK] = ACTIONS(344),
    [aux_sym__declaration_token1] = ACTIONS(347),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(350),
    [sym__whitespace_ge_2] = ACTIONS(353),
    [aux_sym__whitespace_token1] = ACTIONS(356),
    [sym__word_no_digit] = ACTIONS(314),
    [sym__digits] = ACTIONS(314),
    [sym__code_span_start] = ACTIONS(359),
    [sym__emphasis_open_star] = ACTIONS(362),
    [sym__emphasis_open_underscore] = ACTIONS(365),
    [sym__last_token_punctuation] = ACTIONS(368),
    [sym__strikethrough_open] = ACTIONS(370),
    [sym__latex_span_start] = ACTIONS(373),
    [sym__unclosed_span] = ACTIONS(314),
  },
  [7] = {
    [sym_backslash_escape] = STATE(151),
    [sym_code_span] = STATE(151),
    [sym_latex_block] = STATE(151),
    [sym__link_text] = STATE(1124),
    [sym__link_text_non_empty] = STATE(513),
    [sym_shortcut_link] = STATE(41),
    [sym_full_reference_link] = STATE(41),
    [sym_collapsed_reference_link] = STATE(41),
    [sym_inline_link] = STATE(41),
    [sym_image] = STATE(151),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(515),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(151),
    [sym__whitespace] = STATE(151),
    [sym__word] = STATE(151),
    [sym__soft_line_break] = STATE(151),
    [sym__inline_base] = STATE(41),
    [sym__text_base] = STATE(151),
    [sym__inline_element_no_tilde] = STATE(41),
    [aux_sym__inline_no_tilde] = STATE(41),
    [sym__strikethrough] = STATE(41),
    [sym__emphasis_star] = STATE(285),
    [sym__strong_emphasis_star] = STATE(41),
    [sym__emphasis_underscore] = STATE(285),
    [sym__strong_emphasis_underscore] = STATE(41),
    [aux_sym__inline_base_repeat1] = STATE(151),
    [sym__backslash_escape] = ACTIONS(376),
    [sym_entity_reference] = ACTIONS(379),
    [sym_numeric_character_reference] = ACTIONS(379),
    [anon_sym_LBRACK] = ACTIONS(382),
    [anon_sym_RBRACK] = ACTIONS(385),
    [anon_sym_LT] = ACTIONS(388),
    [anon_sym_GT] = ACTIONS(391),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_DQUOTE] = ACTIONS(391),
    [anon_sym_POUND] = ACTIONS(391),
    [anon_sym_DOLLAR] = ACTIONS(391),
    [anon_sym_PERCENT] = ACTIONS(391),
    [anon_sym_AMP] = ACTIONS(397),
    [anon_sym_SQUOTE] = ACTIONS(391),
    [anon_sym_STAR] = ACTIONS(391),
    [anon_sym_PLUS] = ACTIONS(391),
    [anon_sym_COMMA] = ACTIONS(391),
    [anon_sym_DASH] = ACTIONS(391),
    [anon_sym_DOT] = ACTIONS(391),
    [anon_sym_SLASH] = ACTIONS(391),
    [anon_sym_COLON] = ACTIONS(391),
    [anon_sym_SEMI] = ACTIONS(391),
    [anon_sym_EQ] = ACTIONS(391),
    [anon_sym_QMARK] = ACTIONS(391),
    [anon_sym_AT] = ACTIONS(391),
    [anon_sym_BSLASH] = ACTIONS(400),
    [anon_sym_CARET] = ACTIONS(391),
    [anon_sym__] = ACTIONS(391),
    [anon_sym_BQUOTE] = ACTIONS(391),
    [anon_sym_LBRACE] = ACTIONS(391),
    [anon_sym_PIPE] = ACTIONS(391),
    [anon_sym_RBRACE] = ACTIONS(391),
    [anon_sym_TILDE] = ACTIONS(391),
    [anon_sym_LPAREN] = ACTIONS(391),
    [anon_sym_RPAREN] = ACTIONS(391),
    [sym__newline_token] = ACTIONS(403),
    [sym_uri_autolink] = ACTIONS(379),
    [sym_email_autolink] = ACTIONS(379),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(406),
    [anon_sym_LT_QMARK] = ACTIONS(409),
    [aux_sym__declaration_token1] = ACTIONS(412),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(415),
    [sym__whitespace_ge_2] = ACTIONS(418),
    [aux_sym__whitespace_token1] = ACTIONS(421),
    [sym__word_no_digit] = ACTIONS(379),
    [sym__digits] = ACTIONS(379),
    [sym__code_span_start] = ACTIONS(424),
    [sym__emphasis_open_star] = ACTIONS(427),
    [sym__emphasis_open_underscore] = ACTIONS(430),
    [sym__emphasis_close_underscore] = ACTIONS(433),
    [sym__last_token_punctuation] = ACTIONS(435),
    [sym__strikethrough_open] = ACTIONS(437),
    [sym__latex_span_start] = ACTIONS(440),
    [sym__unclosed_span] = ACTIONS(379),
  },
  [8] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(346),
    [sym_shortcut_link] = STATE(50),
    [sym_full_reference_link] = STATE(50),
    [sym_collapsed_reference_link] = STATE(50),
    [sym_inline_link] = STATE(50),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(348),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(50),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(50),
    [aux_sym__inline_no_star] = STATE(50),
    [sym__strikethrough] = STATE(50),
    [sym__emphasis_star] = STATE(315),
    [sym__strong_emphasis_star] = STATE(50),
    [sym__emphasis_underscore] = STATE(281),
    [sym__strong_emphasis_underscore] = STATE(50),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(443),
    [sym_entity_reference] = ACTIONS(446),
    [sym_numeric_character_reference] = ACTIONS(446),
    [anon_sym_LBRACK] = ACTIONS(449),
    [anon_sym_RBRACK] = ACTIONS(452),
    [anon_sym_LT] = ACTIONS(455),
    [anon_sym_GT] = ACTIONS(458),
    [anon_sym_BANG] = ACTIONS(461),
    [anon_sym_DQUOTE] = ACTIONS(458),
    [anon_sym_POUND] = ACTIONS(458),
    [anon_sym_DOLLAR] = ACTIONS(458),
    [anon_sym_PERCENT] = ACTIONS(458),
    [anon_sym_AMP] = ACTIONS(464),
    [anon_sym_SQUOTE] = ACTIONS(458),
    [anon_sym_STAR] = ACTIONS(458),
    [anon_sym_PLUS] = ACTIONS(458),
    [anon_sym_COMMA] = ACTIONS(458),
    [anon_sym_DASH] = ACTIONS(458),
    [anon_sym_DOT] = ACTIONS(458),
    [anon_sym_SLASH] = ACTIONS(458),
    [anon_sym_COLON] = ACTIONS(458),
    [anon_sym_SEMI] = ACTIONS(458),
    [anon_sym_EQ] = ACTIONS(458),
    [anon_sym_QMARK] = ACTIONS(458),
    [anon_sym_AT] = ACTIONS(458),
    [anon_sym_BSLASH] = ACTIONS(467),
    [anon_sym_CARET] = ACTIONS(458),
    [anon_sym__] = ACTIONS(458),
    [anon_sym_BQUOTE] = ACTIONS(458),
    [anon_sym_LBRACE] = ACTIONS(458),
    [anon_sym_PIPE] = ACTIONS(458),
    [anon_sym_RBRACE] = ACTIONS(458),
    [anon_sym_TILDE] = ACTIONS(458),
    [anon_sym_LPAREN] = ACTIONS(458),
    [anon_sym_RPAREN] = ACTIONS(458),
    [sym__newline_token] = ACTIONS(470),
    [sym_uri_autolink] = ACTIONS(446),
    [sym_email_autolink] = ACTIONS(446),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(473),
    [anon_sym_LT_QMARK] = ACTIONS(476),
    [aux_sym__declaration_token1] = ACTIONS(479),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(482),
    [sym__whitespace_ge_2] = ACTIONS(485),
    [aux_sym__whitespace_token1] = ACTIONS(488),
    [sym__word_no_digit] = ACTIONS(446),
    [sym__digits] = ACTIONS(446),
    [sym__code_span_start] = ACTIONS(491),
    [sym__emphasis_open_star] = ACTIONS(494),
    [sym__emphasis_open_underscore] = ACTIONS(497),
    [sym__emphasis_close_underscore] = ACTIONS(433),
    [sym__last_token_punctuation] = ACTIONS(500),
    [sym__strikethrough_open] = ACTIONS(502),
    [sym__latex_span_start] = ACTIONS(505),
    [sym__unclosed_span] = ACTIONS(446),
  },
  [9] = {
    [sym_backslash_escape] = STATE(151),
    [sym_code_span] = STATE(151),
    [sym_latex_block] = STATE(151),
    [sym__link_text] = STATE(1124),
    [sym__link_text_non_empty] = STATE(513),
    [sym_shortcut_link] = STATE(18),
    [sym_full_reference_link] = STATE(18),
    [sym_collapsed_reference_link] = STATE(18),
    [sym_inline_link] = STATE(18),
    [sym_image] = STATE(151),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(515),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(151),
    [sym__whitespace] = STATE(151),
    [sym__word] = STATE(151),
    [sym__soft_line_break] = STATE(151),
    [sym__inline_base] = STATE(18),
    [sym__text_base] = STATE(151),
    [sym__inline_element_no_tilde] = STATE(18),
    [aux_sym__inline_no_tilde] = STATE(18),
    [sym__strikethrough] = STATE(18),
    [sym__emphasis_star] = STATE(285),
    [sym__strong_emphasis_star] = STATE(18),
    [sym__emphasis_underscore] = STATE(285),
    [sym__strong_emphasis_underscore] = STATE(18),
    [aux_sym__inline_base_repeat1] = STATE(151),
    [sym__backslash_escape] = ACTIONS(508),
    [sym_entity_reference] = ACTIONS(511),
    [sym_numeric_character_reference] = ACTIONS(511),
    [anon_sym_LBRACK] = ACTIONS(514),
    [anon_sym_RBRACK] = ACTIONS(517),
    [anon_sym_LT] = ACTIONS(520),
    [anon_sym_GT] = ACTIONS(523),
    [anon_sym_BANG] = ACTIONS(526),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_POUND] = ACTIONS(523),
    [anon_sym_DOLLAR] = ACTIONS(523),
    [anon_sym_PERCENT] = ACTIONS(523),
    [anon_sym_AMP] = ACTIONS(529),
    [anon_sym_SQUOTE] = ACTIONS(523),
    [anon_sym_STAR] = ACTIONS(523),
    [anon_sym_PLUS] = ACTIONS(523),
    [anon_sym_COMMA] = ACTIONS(523),
    [anon_sym_DASH] = ACTIONS(523),
    [anon_sym_DOT] = ACTIONS(523),
    [anon_sym_SLASH] = ACTIONS(523),
    [anon_sym_COLON] = ACTIONS(523),
    [anon_sym_SEMI] = ACTIONS(523),
    [anon_sym_EQ] = ACTIONS(523),
    [anon_sym_QMARK] = ACTIONS(523),
    [anon_sym_AT] = ACTIONS(523),
    [anon_sym_BSLASH] = ACTIONS(532),
    [anon_sym_CARET] = ACTIONS(523),
    [anon_sym__] = ACTIONS(523),
    [anon_sym_BQUOTE] = ACTIONS(523),
    [anon_sym_LBRACE] = ACTIONS(523),
    [anon_sym_PIPE] = ACTIONS(523),
    [anon_sym_RBRACE] = ACTIONS(523),
    [anon_sym_TILDE] = ACTIONS(523),
    [anon_sym_LPAREN] = ACTIONS(523),
    [anon_sym_RPAREN] = ACTIONS(523),
    [sym__newline_token] = ACTIONS(535),
    [sym_uri_autolink] = ACTIONS(511),
    [sym_email_autolink] = ACTIONS(511),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(538),
    [anon_sym_LT_QMARK] = ACTIONS(541),
    [aux_sym__declaration_token1] = ACTIONS(544),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(547),
    [sym__whitespace_ge_2] = ACTIONS(550),
    [aux_sym__whitespace_token1] = ACTIONS(553),
    [sym__word_no_digit] = ACTIONS(511),
    [sym__digits] = ACTIONS(511),
    [sym__code_span_start] = ACTIONS(556),
    [sym__emphasis_open_star] = ACTIONS(559),
    [sym__emphasis_open_underscore] = ACTIONS(562),
    [sym__emphasis_close_star] = ACTIONS(565),
    [sym__last_token_punctuation] = ACTIONS(567),
    [sym__strikethrough_open] = ACTIONS(569),
    [sym__latex_span_start] = ACTIONS(572),
    [sym__unclosed_span] = ACTIONS(511),
  },
  [10] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(17),
    [sym_full_reference_link] = STATE(17),
    [sym_collapsed_reference_link] = STATE(17),
    [sym_inline_link] = STATE(17),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(17),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(17),
    [aux_sym__inline_no_underscore] = STATE(17),
    [sym__strikethrough] = STATE(17),
    [sym__emphasis_star] = STATE(282),
    [sym__strong_emphasis_star] = STATE(17),
    [sym__emphasis_underscore] = STATE(408),
    [sym__strong_emphasis_underscore] = STATE(17),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(575),
    [sym_entity_reference] = ACTIONS(578),
    [sym_numeric_character_reference] = ACTIONS(578),
    [anon_sym_LBRACK] = ACTIONS(581),
    [anon_sym_RBRACK] = ACTIONS(584),
    [anon_sym_LT] = ACTIONS(587),
    [anon_sym_GT] = ACTIONS(590),
    [anon_sym_BANG] = ACTIONS(593),
    [anon_sym_DQUOTE] = ACTIONS(590),
    [anon_sym_POUND] = ACTIONS(590),
    [anon_sym_DOLLAR] = ACTIONS(590),
    [anon_sym_PERCENT] = ACTIONS(590),
    [anon_sym_AMP] = ACTIONS(596),
    [anon_sym_SQUOTE] = ACTIONS(590),
    [anon_sym_STAR] = ACTIONS(590),
    [anon_sym_PLUS] = ACTIONS(590),
    [anon_sym_COMMA] = ACTIONS(590),
    [anon_sym_DASH] = ACTIONS(590),
    [anon_sym_DOT] = ACTIONS(590),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_COLON] = ACTIONS(590),
    [anon_sym_SEMI] = ACTIONS(590),
    [anon_sym_EQ] = ACTIONS(590),
    [anon_sym_QMARK] = ACTIONS(590),
    [anon_sym_AT] = ACTIONS(590),
    [anon_sym_BSLASH] = ACTIONS(599),
    [anon_sym_CARET] = ACTIONS(590),
    [anon_sym__] = ACTIONS(590),
    [anon_sym_BQUOTE] = ACTIONS(590),
    [anon_sym_LBRACE] = ACTIONS(590),
    [anon_sym_PIPE] = ACTIONS(590),
    [anon_sym_RBRACE] = ACTIONS(590),
    [anon_sym_TILDE] = ACTIONS(590),
    [anon_sym_LPAREN] = ACTIONS(590),
    [anon_sym_RPAREN] = ACTIONS(590),
    [sym__newline_token] = ACTIONS(602),
    [sym_uri_autolink] = ACTIONS(578),
    [sym_email_autolink] = ACTIONS(578),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(605),
    [anon_sym_LT_QMARK] = ACTIONS(608),
    [aux_sym__declaration_token1] = ACTIONS(611),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(614),
    [sym__whitespace_ge_2] = ACTIONS(617),
    [aux_sym__whitespace_token1] = ACTIONS(620),
    [sym__word_no_digit] = ACTIONS(578),
    [sym__digits] = ACTIONS(578),
    [sym__code_span_start] = ACTIONS(623),
    [sym__emphasis_open_star] = ACTIONS(626),
    [sym__emphasis_open_underscore] = ACTIONS(629),
    [sym__emphasis_close_star] = ACTIONS(565),
    [sym__last_token_punctuation] = ACTIONS(632),
    [sym__strikethrough_open] = ACTIONS(634),
    [sym__latex_span_start] = ACTIONS(637),
    [sym__unclosed_span] = ACTIONS(578),
  },
  [11] = {
    [sym_backslash_escape] = STATE(151),
    [sym_code_span] = STATE(151),
    [sym_latex_block] = STATE(151),
    [sym__link_text] = STATE(1124),
    [sym__link_text_non_empty] = STATE(513),
    [sym_shortcut_link] = STATE(15),
    [sym_full_reference_link] = STATE(15),
    [sym_collapsed_reference_link] = STATE(15),
    [sym_inline_link] = STATE(15),
    [sym_image] = STATE(151),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(515),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(151),
    [sym__whitespace] = STATE(151),
    [sym__word] = STATE(151),
    [sym__soft_line_break] = STATE(151),
    [sym__inline_base] = STATE(15),
    [sym__text_base] = STATE(151),
    [sym__inline_element_no_tilde] = STATE(15),
    [aux_sym__inline_no_tilde] = STATE(15),
    [sym__strikethrough] = STATE(15),
    [sym__emphasis_star] = STATE(285),
    [sym__strong_emphasis_star] = STATE(15),
    [sym__emphasis_underscore] = STATE(285),
    [sym__strong_emphasis_underscore] = STATE(15),
    [aux_sym__inline_base_repeat1] = STATE(151),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__strikethrough_open] = ACTIONS(678),
    [sym__strikethrough_close] = ACTIONS(680),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [12] = {
    [sym_backslash_escape] = STATE(151),
    [sym_code_span] = STATE(151),
    [sym_latex_block] = STATE(151),
    [sym__link_text] = STATE(1124),
    [sym__link_text_non_empty] = STATE(513),
    [sym_shortcut_link] = STATE(15),
    [sym_full_reference_link] = STATE(15),
    [sym_collapsed_reference_link] = STATE(15),
    [sym_inline_link] = STATE(15),
    [sym_image] = STATE(151),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(515),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(151),
    [sym__whitespace] = STATE(151),
    [sym__word] = STATE(151),
    [sym__soft_line_break] = STATE(151),
    [sym__inline_base] = STATE(15),
    [sym__text_base] = STATE(151),
    [sym__inline_element_no_tilde] = STATE(15),
    [aux_sym__inline_no_tilde] = STATE(15),
    [sym__strikethrough] = STATE(15),
    [sym__emphasis_star] = STATE(285),
    [sym__strong_emphasis_star] = STATE(15),
    [sym__emphasis_underscore] = STATE(285),
    [sym__strong_emphasis_underscore] = STATE(15),
    [aux_sym__inline_base_repeat1] = STATE(151),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__strikethrough_open] = ACTIONS(678),
    [sym__strikethrough_close] = ACTIONS(684),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [13] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(19),
    [sym_full_reference_link] = STATE(19),
    [sym_collapsed_reference_link] = STATE(19),
    [sym_inline_link] = STATE(19),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(19),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(19),
    [aux_sym__inline_no_underscore] = STATE(19),
    [sym__strikethrough] = STATE(19),
    [sym__emphasis_star] = STATE(282),
    [sym__strong_emphasis_star] = STATE(19),
    [sym__emphasis_underscore] = STATE(282),
    [sym__strong_emphasis_underscore] = STATE(19),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(688),
    [sym_numeric_character_reference] = ACTIONS(688),
    [anon_sym_LBRACK] = ACTIONS(690),
    [anon_sym_RBRACK] = ACTIONS(692),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(698),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(688),
    [sym_email_autolink] = ACTIONS(688),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(706),
    [anon_sym_LT_QMARK] = ACTIONS(708),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(712),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(688),
    [sym__digits] = ACTIONS(688),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(720),
    [sym__emphasis_open_underscore] = ACTIONS(722),
    [sym__emphasis_close_underscore] = ACTIONS(724),
    [sym__strikethrough_open] = ACTIONS(726),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(688),
  },
  [14] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(346),
    [sym_shortcut_link] = STATE(21),
    [sym_full_reference_link] = STATE(21),
    [sym_collapsed_reference_link] = STATE(21),
    [sym_inline_link] = STATE(21),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(348),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(21),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(21),
    [aux_sym__inline_no_star] = STATE(21),
    [sym__strikethrough] = STATE(21),
    [sym__emphasis_star] = STATE(281),
    [sym__strong_emphasis_star] = STATE(21),
    [sym__emphasis_underscore] = STATE(281),
    [sym__strong_emphasis_underscore] = STATE(21),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(732),
    [sym_numeric_character_reference] = ACTIONS(732),
    [anon_sym_LBRACK] = ACTIONS(734),
    [anon_sym_RBRACK] = ACTIONS(736),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(742),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(732),
    [sym_email_autolink] = ACTIONS(732),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(750),
    [anon_sym_LT_QMARK] = ACTIONS(752),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(756),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(732),
    [sym__digits] = ACTIONS(732),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(764),
    [sym__emphasis_open_underscore] = ACTIONS(766),
    [sym__emphasis_close_star] = ACTIONS(768),
    [sym__strikethrough_open] = ACTIONS(770),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(732),
  },
  [15] = {
    [sym_backslash_escape] = STATE(151),
    [sym_code_span] = STATE(151),
    [sym_latex_block] = STATE(151),
    [sym__link_text] = STATE(1124),
    [sym__link_text_non_empty] = STATE(513),
    [sym_shortcut_link] = STATE(15),
    [sym_full_reference_link] = STATE(15),
    [sym_collapsed_reference_link] = STATE(15),
    [sym_inline_link] = STATE(15),
    [sym_image] = STATE(151),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(515),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(151),
    [sym__whitespace] = STATE(151),
    [sym__word] = STATE(151),
    [sym__soft_line_break] = STATE(151),
    [sym__inline_base] = STATE(15),
    [sym__text_base] = STATE(151),
    [sym__inline_element_no_tilde] = STATE(15),
    [aux_sym__inline_no_tilde] = STATE(15),
    [sym__strikethrough] = STATE(15),
    [sym__emphasis_star] = STATE(285),
    [sym__strong_emphasis_star] = STATE(15),
    [sym__emphasis_underscore] = STATE(285),
    [sym__strong_emphasis_underscore] = STATE(15),
    [aux_sym__inline_base_repeat1] = STATE(151),
    [sym__backslash_escape] = ACTIONS(774),
    [sym_entity_reference] = ACTIONS(777),
    [sym_numeric_character_reference] = ACTIONS(777),
    [anon_sym_LBRACK] = ACTIONS(780),
    [anon_sym_RBRACK] = ACTIONS(783),
    [anon_sym_LT] = ACTIONS(786),
    [anon_sym_GT] = ACTIONS(789),
    [anon_sym_BANG] = ACTIONS(792),
    [anon_sym_DQUOTE] = ACTIONS(789),
    [anon_sym_POUND] = ACTIONS(789),
    [anon_sym_DOLLAR] = ACTIONS(789),
    [anon_sym_PERCENT] = ACTIONS(789),
    [anon_sym_AMP] = ACTIONS(795),
    [anon_sym_SQUOTE] = ACTIONS(789),
    [anon_sym_STAR] = ACTIONS(789),
    [anon_sym_PLUS] = ACTIONS(789),
    [anon_sym_COMMA] = ACTIONS(789),
    [anon_sym_DASH] = ACTIONS(789),
    [anon_sym_DOT] = ACTIONS(789),
    [anon_sym_SLASH] = ACTIONS(789),
    [anon_sym_COLON] = ACTIONS(789),
    [anon_sym_SEMI] = ACTIONS(789),
    [anon_sym_EQ] = ACTIONS(789),
    [anon_sym_QMARK] = ACTIONS(789),
    [anon_sym_AT] = ACTIONS(789),
    [anon_sym_BSLASH] = ACTIONS(798),
    [anon_sym_CARET] = ACTIONS(789),
    [anon_sym__] = ACTIONS(789),
    [anon_sym_BQUOTE] = ACTIONS(789),
    [anon_sym_LBRACE] = ACTIONS(789),
    [anon_sym_PIPE] = ACTIONS(789),
    [anon_sym_RBRACE] = ACTIONS(789),
    [anon_sym_TILDE] = ACTIONS(789),
    [anon_sym_LPAREN] = ACTIONS(789),
    [anon_sym_RPAREN] = ACTIONS(789),
    [sym__newline_token] = ACTIONS(801),
    [sym_uri_autolink] = ACTIONS(777),
    [sym_email_autolink] = ACTIONS(777),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(804),
    [anon_sym_LT_QMARK] = ACTIONS(807),
    [aux_sym__declaration_token1] = ACTIONS(810),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(813),
    [sym__whitespace_ge_2] = ACTIONS(816),
    [aux_sym__whitespace_token1] = ACTIONS(819),
    [sym__word_no_digit] = ACTIONS(777),
    [sym__digits] = ACTIONS(777),
    [sym__code_span_start] = ACTIONS(822),
    [sym__emphasis_open_star] = ACTIONS(825),
    [sym__emphasis_open_underscore] = ACTIONS(828),
    [sym__strikethrough_open] = ACTIONS(831),
    [sym__strikethrough_close] = ACTIONS(834),
    [sym__latex_span_start] = ACTIONS(836),
    [sym__unclosed_span] = ACTIONS(777),
  },
  [16] = {
    [sym_backslash_escape] = STATE(151),
    [sym_code_span] = STATE(151),
    [sym_latex_block] = STATE(151),
    [sym__link_text] = STATE(1124),
    [sym__link_text_non_empty] = STATE(513),
    [sym_shortcut_link] = STATE(15),
    [sym_full_reference_link] = STATE(15),
    [sym_collapsed_reference_link] = STATE(15),
    [sym_inline_link] = STATE(15),
    [sym_image] = STATE(151),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(515),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(151),
    [sym__whitespace] = STATE(151),
    [sym__word] = STATE(151),
    [sym__soft_line_break] = STATE(151),
    [sym__inline_base] = STATE(15),
    [sym__text_base] = STATE(151),
    [sym__inline_element_no_tilde] = STATE(15),
    [aux_sym__inline_no_tilde] = STATE(15),
    [sym__strikethrough] = STATE(15),
    [sym__emphasis_star] = STATE(285),
    [sym__strong_emphasis_star] = STATE(15),
    [sym__emphasis_underscore] = STATE(285),
    [sym__strong_emphasis_underscore] = STATE(15),
    [aux_sym__inline_base_repeat1] = STATE(151),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__strikethrough_open] = ACTIONS(678),
    [sym__strikethrough_close] = ACTIONS(839),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [17] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(19),
    [sym_full_reference_link] = STATE(19),
    [sym_collapsed_reference_link] = STATE(19),
    [sym_inline_link] = STATE(19),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(19),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(19),
    [aux_sym__inline_no_underscore] = STATE(19),
    [sym__strikethrough] = STATE(19),
    [sym__emphasis_star] = STATE(282),
    [sym__strong_emphasis_star] = STATE(19),
    [sym__emphasis_underscore] = STATE(282),
    [sym__strong_emphasis_underscore] = STATE(19),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(688),
    [sym_numeric_character_reference] = ACTIONS(688),
    [anon_sym_LBRACK] = ACTIONS(690),
    [anon_sym_RBRACK] = ACTIONS(692),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(698),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(688),
    [sym_email_autolink] = ACTIONS(688),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(706),
    [anon_sym_LT_QMARK] = ACTIONS(708),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(712),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(688),
    [sym__digits] = ACTIONS(688),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(720),
    [sym__emphasis_open_underscore] = ACTIONS(722),
    [sym__emphasis_close_underscore] = ACTIONS(841),
    [sym__strikethrough_open] = ACTIONS(726),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(688),
  },
  [18] = {
    [sym_backslash_escape] = STATE(151),
    [sym_code_span] = STATE(151),
    [sym_latex_block] = STATE(151),
    [sym__link_text] = STATE(1124),
    [sym__link_text_non_empty] = STATE(513),
    [sym_shortcut_link] = STATE(15),
    [sym_full_reference_link] = STATE(15),
    [sym_collapsed_reference_link] = STATE(15),
    [sym_inline_link] = STATE(15),
    [sym_image] = STATE(151),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(515),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(151),
    [sym__whitespace] = STATE(151),
    [sym__word] = STATE(151),
    [sym__soft_line_break] = STATE(151),
    [sym__inline_base] = STATE(15),
    [sym__text_base] = STATE(151),
    [sym__inline_element_no_tilde] = STATE(15),
    [aux_sym__inline_no_tilde] = STATE(15),
    [sym__strikethrough] = STATE(15),
    [sym__emphasis_star] = STATE(285),
    [sym__strong_emphasis_star] = STATE(15),
    [sym__emphasis_underscore] = STATE(285),
    [sym__strong_emphasis_underscore] = STATE(15),
    [aux_sym__inline_base_repeat1] = STATE(151),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__strikethrough_open] = ACTIONS(678),
    [sym__strikethrough_close] = ACTIONS(843),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [19] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(19),
    [sym_full_reference_link] = STATE(19),
    [sym_collapsed_reference_link] = STATE(19),
    [sym_inline_link] = STATE(19),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(19),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(19),
    [aux_sym__inline_no_underscore] = STATE(19),
    [sym__strikethrough] = STATE(19),
    [sym__emphasis_star] = STATE(282),
    [sym__strong_emphasis_star] = STATE(19),
    [sym__emphasis_underscore] = STATE(282),
    [sym__strong_emphasis_underscore] = STATE(19),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(845),
    [sym_entity_reference] = ACTIONS(848),
    [sym_numeric_character_reference] = ACTIONS(848),
    [anon_sym_LBRACK] = ACTIONS(851),
    [anon_sym_RBRACK] = ACTIONS(854),
    [anon_sym_LT] = ACTIONS(857),
    [anon_sym_GT] = ACTIONS(860),
    [anon_sym_BANG] = ACTIONS(863),
    [anon_sym_DQUOTE] = ACTIONS(860),
    [anon_sym_POUND] = ACTIONS(860),
    [anon_sym_DOLLAR] = ACTIONS(860),
    [anon_sym_PERCENT] = ACTIONS(860),
    [anon_sym_AMP] = ACTIONS(866),
    [anon_sym_SQUOTE] = ACTIONS(860),
    [anon_sym_STAR] = ACTIONS(860),
    [anon_sym_PLUS] = ACTIONS(860),
    [anon_sym_COMMA] = ACTIONS(860),
    [anon_sym_DASH] = ACTIONS(860),
    [anon_sym_DOT] = ACTIONS(860),
    [anon_sym_SLASH] = ACTIONS(860),
    [anon_sym_COLON] = ACTIONS(860),
    [anon_sym_SEMI] = ACTIONS(860),
    [anon_sym_EQ] = ACTIONS(860),
    [anon_sym_QMARK] = ACTIONS(860),
    [anon_sym_AT] = ACTIONS(860),
    [anon_sym_BSLASH] = ACTIONS(869),
    [anon_sym_CARET] = ACTIONS(860),
    [anon_sym__] = ACTIONS(860),
    [anon_sym_BQUOTE] = ACTIONS(860),
    [anon_sym_LBRACE] = ACTIONS(860),
    [anon_sym_PIPE] = ACTIONS(860),
    [anon_sym_RBRACE] = ACTIONS(860),
    [anon_sym_TILDE] = ACTIONS(860),
    [anon_sym_LPAREN] = ACTIONS(860),
    [anon_sym_RPAREN] = ACTIONS(860),
    [sym__newline_token] = ACTIONS(872),
    [sym_uri_autolink] = ACTIONS(848),
    [sym_email_autolink] = ACTIONS(848),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(875),
    [anon_sym_LT_QMARK] = ACTIONS(878),
    [aux_sym__declaration_token1] = ACTIONS(881),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(884),
    [sym__whitespace_ge_2] = ACTIONS(887),
    [aux_sym__whitespace_token1] = ACTIONS(890),
    [sym__word_no_digit] = ACTIONS(848),
    [sym__digits] = ACTIONS(848),
    [sym__code_span_start] = ACTIONS(893),
    [sym__emphasis_open_star] = ACTIONS(896),
    [sym__emphasis_open_underscore] = ACTIONS(899),
    [sym__emphasis_close_underscore] = ACTIONS(902),
    [sym__strikethrough_open] = ACTIONS(904),
    [sym__latex_span_start] = ACTIONS(907),
    [sym__unclosed_span] = ACTIONS(848),
  },
  [20] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(19),
    [sym_full_reference_link] = STATE(19),
    [sym_collapsed_reference_link] = STATE(19),
    [sym_inline_link] = STATE(19),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(19),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(19),
    [aux_sym__inline_no_underscore] = STATE(19),
    [sym__strikethrough] = STATE(19),
    [sym__emphasis_star] = STATE(282),
    [sym__strong_emphasis_star] = STATE(19),
    [sym__emphasis_underscore] = STATE(282),
    [sym__strong_emphasis_underscore] = STATE(19),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(688),
    [sym_numeric_character_reference] = ACTIONS(688),
    [anon_sym_LBRACK] = ACTIONS(690),
    [anon_sym_RBRACK] = ACTIONS(692),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(698),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(688),
    [sym_email_autolink] = ACTIONS(688),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(706),
    [anon_sym_LT_QMARK] = ACTIONS(708),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(712),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(688),
    [sym__digits] = ACTIONS(688),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(720),
    [sym__emphasis_open_underscore] = ACTIONS(722),
    [sym__emphasis_close_underscore] = ACTIONS(910),
    [sym__strikethrough_open] = ACTIONS(726),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(688),
  },
  [21] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(346),
    [sym_shortcut_link] = STATE(21),
    [sym_full_reference_link] = STATE(21),
    [sym_collapsed_reference_link] = STATE(21),
    [sym_inline_link] = STATE(21),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(348),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(21),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(21),
    [aux_sym__inline_no_star] = STATE(21),
    [sym__strikethrough] = STATE(21),
    [sym__emphasis_star] = STATE(281),
    [sym__strong_emphasis_star] = STATE(21),
    [sym__emphasis_underscore] = STATE(281),
    [sym__strong_emphasis_underscore] = STATE(21),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(912),
    [sym_entity_reference] = ACTIONS(915),
    [sym_numeric_character_reference] = ACTIONS(915),
    [anon_sym_LBRACK] = ACTIONS(918),
    [anon_sym_RBRACK] = ACTIONS(921),
    [anon_sym_LT] = ACTIONS(924),
    [anon_sym_GT] = ACTIONS(927),
    [anon_sym_BANG] = ACTIONS(930),
    [anon_sym_DQUOTE] = ACTIONS(927),
    [anon_sym_POUND] = ACTIONS(927),
    [anon_sym_DOLLAR] = ACTIONS(927),
    [anon_sym_PERCENT] = ACTIONS(927),
    [anon_sym_AMP] = ACTIONS(933),
    [anon_sym_SQUOTE] = ACTIONS(927),
    [anon_sym_STAR] = ACTIONS(927),
    [anon_sym_PLUS] = ACTIONS(927),
    [anon_sym_COMMA] = ACTIONS(927),
    [anon_sym_DASH] = ACTIONS(927),
    [anon_sym_DOT] = ACTIONS(927),
    [anon_sym_SLASH] = ACTIONS(927),
    [anon_sym_COLON] = ACTIONS(927),
    [anon_sym_SEMI] = ACTIONS(927),
    [anon_sym_EQ] = ACTIONS(927),
    [anon_sym_QMARK] = ACTIONS(927),
    [anon_sym_AT] = ACTIONS(927),
    [anon_sym_BSLASH] = ACTIONS(936),
    [anon_sym_CARET] = ACTIONS(927),
    [anon_sym__] = ACTIONS(927),
    [anon_sym_BQUOTE] = ACTIONS(927),
    [anon_sym_LBRACE] = ACTIONS(927),
    [anon_sym_PIPE] = ACTIONS(927),
    [anon_sym_RBRACE] = ACTIONS(927),
    [anon_sym_TILDE] = ACTIONS(927),
    [anon_sym_LPAREN] = ACTIONS(927),
    [anon_sym_RPAREN] = ACTIONS(927),
    [sym__newline_token] = ACTIONS(939),
    [sym_uri_autolink] = ACTIONS(915),
    [sym_email_autolink] = ACTIONS(915),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(942),
    [anon_sym_LT_QMARK] = ACTIONS(945),
    [aux_sym__declaration_token1] = ACTIONS(948),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(951),
    [sym__whitespace_ge_2] = ACTIONS(954),
    [aux_sym__whitespace_token1] = ACTIONS(957),
    [sym__word_no_digit] = ACTIONS(915),
    [sym__digits] = ACTIONS(915),
    [sym__code_span_start] = ACTIONS(960),
    [sym__emphasis_open_star] = ACTIONS(963),
    [sym__emphasis_open_underscore] = ACTIONS(966),
    [sym__emphasis_close_star] = ACTIONS(969),
    [sym__strikethrough_open] = ACTIONS(971),
    [sym__latex_span_start] = ACTIONS(974),
    [sym__unclosed_span] = ACTIONS(915),
  },
  [22] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(346),
    [sym_shortcut_link] = STATE(21),
    [sym_full_reference_link] = STATE(21),
    [sym_collapsed_reference_link] = STATE(21),
    [sym_inline_link] = STATE(21),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(348),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(21),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(21),
    [aux_sym__inline_no_star] = STATE(21),
    [sym__strikethrough] = STATE(21),
    [sym__emphasis_star] = STATE(281),
    [sym__strong_emphasis_star] = STATE(21),
    [sym__emphasis_underscore] = STATE(281),
    [sym__strong_emphasis_underscore] = STATE(21),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(732),
    [sym_numeric_character_reference] = ACTIONS(732),
    [anon_sym_LBRACK] = ACTIONS(734),
    [anon_sym_RBRACK] = ACTIONS(736),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(742),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(732),
    [sym_email_autolink] = ACTIONS(732),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(750),
    [anon_sym_LT_QMARK] = ACTIONS(752),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(756),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(732),
    [sym__digits] = ACTIONS(732),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(764),
    [sym__emphasis_open_underscore] = ACTIONS(766),
    [sym__emphasis_close_star] = ACTIONS(977),
    [sym__strikethrough_open] = ACTIONS(770),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(732),
  },
  [23] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(346),
    [sym_shortcut_link] = STATE(21),
    [sym_full_reference_link] = STATE(21),
    [sym_collapsed_reference_link] = STATE(21),
    [sym_inline_link] = STATE(21),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(348),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(21),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(21),
    [aux_sym__inline_no_star] = STATE(21),
    [sym__strikethrough] = STATE(21),
    [sym__emphasis_star] = STATE(281),
    [sym__strong_emphasis_star] = STATE(21),
    [sym__emphasis_underscore] = STATE(281),
    [sym__strong_emphasis_underscore] = STATE(21),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(732),
    [sym_numeric_character_reference] = ACTIONS(732),
    [anon_sym_LBRACK] = ACTIONS(734),
    [anon_sym_RBRACK] = ACTIONS(736),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(742),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(732),
    [sym_email_autolink] = ACTIONS(732),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(750),
    [anon_sym_LT_QMARK] = ACTIONS(752),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(756),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(732),
    [sym__digits] = ACTIONS(732),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(764),
    [sym__emphasis_open_underscore] = ACTIONS(766),
    [sym__emphasis_close_star] = ACTIONS(979),
    [sym__strikethrough_open] = ACTIONS(770),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(732),
  },
  [24] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(19),
    [sym_full_reference_link] = STATE(19),
    [sym_collapsed_reference_link] = STATE(19),
    [sym_inline_link] = STATE(19),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(19),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(19),
    [aux_sym__inline_no_underscore] = STATE(19),
    [sym__strikethrough] = STATE(19),
    [sym__emphasis_star] = STATE(282),
    [sym__strong_emphasis_star] = STATE(19),
    [sym__emphasis_underscore] = STATE(282),
    [sym__strong_emphasis_underscore] = STATE(19),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(688),
    [sym_numeric_character_reference] = ACTIONS(688),
    [anon_sym_LBRACK] = ACTIONS(690),
    [anon_sym_RBRACK] = ACTIONS(692),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(698),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(688),
    [sym_email_autolink] = ACTIONS(688),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(706),
    [anon_sym_LT_QMARK] = ACTIONS(708),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(712),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(688),
    [sym__digits] = ACTIONS(688),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(720),
    [sym__emphasis_open_underscore] = ACTIONS(722),
    [sym__emphasis_close_underscore] = ACTIONS(981),
    [sym__strikethrough_open] = ACTIONS(726),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(688),
  },
  [25] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(264),
    [sym_shortcut_link] = STATE(271),
    [sym_full_reference_link] = STATE(271),
    [sym_collapsed_reference_link] = STATE(271),
    [sym_inline_link] = STATE(271),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(265),
    [sym__image_shortcut_link] = STATE(265),
    [sym__image_full_reference_link] = STATE(265),
    [sym__image_collapsed_reference_link] = STATE(265),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(266),
    [sym__html_tag] = STATE(267),
    [sym__open_tag] = STATE(270),
    [sym__closing_tag] = STATE(270),
    [sym__html_comment] = STATE(270),
    [sym__processing_instruction] = STATE(270),
    [sym__declaration] = STATE(270),
    [sym__cdata_section] = STATE(270),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(271),
    [sym__text_base] = STATE(154),
    [sym__inline_element] = STATE(271),
    [aux_sym__inline] = STATE(25),
    [sym__strikethrough] = STATE(271),
    [sym__emphasis_star] = STATE(274),
    [sym__strong_emphasis_star] = STATE(271),
    [sym__emphasis_underscore] = STATE(274),
    [sym__strong_emphasis_underscore] = STATE(271),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [ts_builtin_sym_end] = ACTIONS(983),
    [sym__backslash_escape] = ACTIONS(985),
    [sym_entity_reference] = ACTIONS(988),
    [sym_numeric_character_reference] = ACTIONS(988),
    [anon_sym_LBRACK] = ACTIONS(991),
    [anon_sym_RBRACK] = ACTIONS(994),
    [anon_sym_LT] = ACTIONS(997),
    [anon_sym_GT] = ACTIONS(1000),
    [anon_sym_BANG] = ACTIONS(1003),
    [anon_sym_DQUOTE] = ACTIONS(1000),
    [anon_sym_POUND] = ACTIONS(1000),
    [anon_sym_DOLLAR] = ACTIONS(1000),
    [anon_sym_PERCENT] = ACTIONS(1000),
    [anon_sym_AMP] = ACTIONS(1006),
    [anon_sym_SQUOTE] = ACTIONS(1000),
    [anon_sym_STAR] = ACTIONS(1000),
    [anon_sym_PLUS] = ACTIONS(1000),
    [anon_sym_COMMA] = ACTIONS(1000),
    [anon_sym_DASH] = ACTIONS(1000),
    [anon_sym_DOT] = ACTIONS(1000),
    [anon_sym_SLASH] = ACTIONS(1000),
    [anon_sym_COLON] = ACTIONS(1000),
    [anon_sym_SEMI] = ACTIONS(1000),
    [anon_sym_EQ] = ACTIONS(1000),
    [anon_sym_QMARK] = ACTIONS(1000),
    [anon_sym_AT] = ACTIONS(1000),
    [anon_sym_BSLASH] = ACTIONS(1009),
    [anon_sym_CARET] = ACTIONS(1000),
    [anon_sym__] = ACTIONS(1000),
    [anon_sym_BQUOTE] = ACTIONS(1000),
    [anon_sym_LBRACE] = ACTIONS(1000),
    [anon_sym_PIPE] = ACTIONS(1000),
    [anon_sym_RBRACE] = ACTIONS(1000),
    [anon_sym_TILDE] = ACTIONS(1000),
    [anon_sym_LPAREN] = ACTIONS(1000),
    [anon_sym_RPAREN] = ACTIONS(1000),
    [sym__newline_token] = ACTIONS(1012),
    [sym_uri_autolink] = ACTIONS(988),
    [sym_email_autolink] = ACTIONS(988),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1015),
    [anon_sym_LT_QMARK] = ACTIONS(1018),
    [aux_sym__declaration_token1] = ACTIONS(1021),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1024),
    [sym__whitespace_ge_2] = ACTIONS(1027),
    [aux_sym__whitespace_token1] = ACTIONS(1030),
    [sym__word_no_digit] = ACTIONS(988),
    [sym__digits] = ACTIONS(988),
    [sym__code_span_start] = ACTIONS(1033),
    [sym__emphasis_open_star] = ACTIONS(1036),
    [sym__emphasis_open_underscore] = ACTIONS(1039),
    [sym__strikethrough_open] = ACTIONS(1042),
    [sym__latex_span_start] = ACTIONS(1045),
    [sym__unclosed_span] = ACTIONS(988),
  },
  [26] = {
    [sym_backslash_escape] = STATE(151),
    [sym_code_span] = STATE(151),
    [sym_latex_block] = STATE(151),
    [sym__link_text] = STATE(1124),
    [sym__link_text_non_empty] = STATE(513),
    [sym_shortcut_link] = STATE(15),
    [sym_full_reference_link] = STATE(15),
    [sym_collapsed_reference_link] = STATE(15),
    [sym_inline_link] = STATE(15),
    [sym_image] = STATE(151),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(515),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(151),
    [sym__whitespace] = STATE(151),
    [sym__word] = STATE(151),
    [sym__soft_line_break] = STATE(151),
    [sym__inline_base] = STATE(15),
    [sym__text_base] = STATE(151),
    [sym__inline_element_no_tilde] = STATE(15),
    [aux_sym__inline_no_tilde] = STATE(15),
    [sym__strikethrough] = STATE(15),
    [sym__emphasis_star] = STATE(285),
    [sym__strong_emphasis_star] = STATE(15),
    [sym__emphasis_underscore] = STATE(285),
    [sym__strong_emphasis_underscore] = STATE(15),
    [aux_sym__inline_base_repeat1] = STATE(151),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__strikethrough_open] = ACTIONS(678),
    [sym__strikethrough_close] = ACTIONS(1048),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [27] = {
    [sym_backslash_escape] = STATE(151),
    [sym_code_span] = STATE(151),
    [sym_latex_block] = STATE(151),
    [sym__link_text] = STATE(1124),
    [sym__link_text_non_empty] = STATE(513),
    [sym_shortcut_link] = STATE(15),
    [sym_full_reference_link] = STATE(15),
    [sym_collapsed_reference_link] = STATE(15),
    [sym_inline_link] = STATE(15),
    [sym_image] = STATE(151),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(515),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(151),
    [sym__whitespace] = STATE(151),
    [sym__word] = STATE(151),
    [sym__soft_line_break] = STATE(151),
    [sym__inline_base] = STATE(15),
    [sym__text_base] = STATE(151),
    [sym__inline_element_no_tilde] = STATE(15),
    [aux_sym__inline_no_tilde] = STATE(15),
    [sym__strikethrough] = STATE(15),
    [sym__emphasis_star] = STATE(285),
    [sym__strong_emphasis_star] = STATE(15),
    [sym__emphasis_underscore] = STATE(285),
    [sym__strong_emphasis_underscore] = STATE(15),
    [aux_sym__inline_base_repeat1] = STATE(151),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__strikethrough_open] = ACTIONS(678),
    [sym__strikethrough_close] = ACTIONS(1050),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [28] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(19),
    [sym_full_reference_link] = STATE(19),
    [sym_collapsed_reference_link] = STATE(19),
    [sym_inline_link] = STATE(19),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(19),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(19),
    [aux_sym__inline_no_underscore] = STATE(19),
    [sym__strikethrough] = STATE(19),
    [sym__emphasis_star] = STATE(282),
    [sym__strong_emphasis_star] = STATE(19),
    [sym__emphasis_underscore] = STATE(282),
    [sym__strong_emphasis_underscore] = STATE(19),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(688),
    [sym_numeric_character_reference] = ACTIONS(688),
    [anon_sym_LBRACK] = ACTIONS(690),
    [anon_sym_RBRACK] = ACTIONS(692),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(698),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(688),
    [sym_email_autolink] = ACTIONS(688),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(706),
    [anon_sym_LT_QMARK] = ACTIONS(708),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(712),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(688),
    [sym__digits] = ACTIONS(688),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(720),
    [sym__emphasis_open_underscore] = ACTIONS(722),
    [sym__emphasis_close_underscore] = ACTIONS(1052),
    [sym__strikethrough_open] = ACTIONS(726),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(688),
  },
  [29] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(346),
    [sym_shortcut_link] = STATE(21),
    [sym_full_reference_link] = STATE(21),
    [sym_collapsed_reference_link] = STATE(21),
    [sym_inline_link] = STATE(21),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(348),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(21),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(21),
    [aux_sym__inline_no_star] = STATE(21),
    [sym__strikethrough] = STATE(21),
    [sym__emphasis_star] = STATE(281),
    [sym__strong_emphasis_star] = STATE(21),
    [sym__emphasis_underscore] = STATE(281),
    [sym__strong_emphasis_underscore] = STATE(21),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(732),
    [sym_numeric_character_reference] = ACTIONS(732),
    [anon_sym_LBRACK] = ACTIONS(734),
    [anon_sym_RBRACK] = ACTIONS(736),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(742),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(732),
    [sym_email_autolink] = ACTIONS(732),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(750),
    [anon_sym_LT_QMARK] = ACTIONS(752),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(756),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(732),
    [sym__digits] = ACTIONS(732),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(764),
    [sym__emphasis_open_underscore] = ACTIONS(766),
    [sym__emphasis_close_star] = ACTIONS(1054),
    [sym__strikethrough_open] = ACTIONS(770),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(732),
  },
  [30] = {
    [sym_backslash_escape] = STATE(151),
    [sym_code_span] = STATE(151),
    [sym_latex_block] = STATE(151),
    [sym__link_text] = STATE(1124),
    [sym__link_text_non_empty] = STATE(513),
    [sym_shortcut_link] = STATE(15),
    [sym_full_reference_link] = STATE(15),
    [sym_collapsed_reference_link] = STATE(15),
    [sym_inline_link] = STATE(15),
    [sym_image] = STATE(151),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(515),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(151),
    [sym__whitespace] = STATE(151),
    [sym__word] = STATE(151),
    [sym__soft_line_break] = STATE(151),
    [sym__inline_base] = STATE(15),
    [sym__text_base] = STATE(151),
    [sym__inline_element_no_tilde] = STATE(15),
    [aux_sym__inline_no_tilde] = STATE(15),
    [sym__strikethrough] = STATE(15),
    [sym__emphasis_star] = STATE(285),
    [sym__strong_emphasis_star] = STATE(15),
    [sym__emphasis_underscore] = STATE(285),
    [sym__strong_emphasis_underscore] = STATE(15),
    [aux_sym__inline_base_repeat1] = STATE(151),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__strikethrough_open] = ACTIONS(678),
    [sym__strikethrough_close] = ACTIONS(1056),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [31] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(264),
    [sym_shortcut_link] = STATE(271),
    [sym_full_reference_link] = STATE(271),
    [sym_collapsed_reference_link] = STATE(271),
    [sym_inline_link] = STATE(271),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(265),
    [sym__image_shortcut_link] = STATE(265),
    [sym__image_full_reference_link] = STATE(265),
    [sym__image_collapsed_reference_link] = STATE(265),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(266),
    [sym__html_tag] = STATE(267),
    [sym__open_tag] = STATE(270),
    [sym__closing_tag] = STATE(270),
    [sym__html_comment] = STATE(270),
    [sym__processing_instruction] = STATE(270),
    [sym__declaration] = STATE(270),
    [sym__cdata_section] = STATE(270),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(271),
    [sym__text_base] = STATE(154),
    [sym__inline_element] = STATE(271),
    [aux_sym__inline] = STATE(25),
    [sym__strikethrough] = STATE(271),
    [sym__emphasis_star] = STATE(274),
    [sym__strong_emphasis_star] = STATE(271),
    [sym__emphasis_underscore] = STATE(274),
    [sym__strong_emphasis_underscore] = STATE(271),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [ts_builtin_sym_end] = ACTIONS(1058),
    [sym__backslash_escape] = ACTIONS(3),
    [sym_entity_reference] = ACTIONS(5),
    [sym_numeric_character_reference] = ACTIONS(5),
    [anon_sym_LBRACK] = ACTIONS(7),
    [anon_sym_RBRACK] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(11),
    [anon_sym_GT] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_POUND] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_PERCENT] = ACTIONS(13),
    [anon_sym_AMP] = ACTIONS(17),
    [anon_sym_SQUOTE] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(13),
    [anon_sym_DASH] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(13),
    [anon_sym_SLASH] = ACTIONS(13),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_SEMI] = ACTIONS(13),
    [anon_sym_EQ] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(13),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_BSLASH] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(13),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_PIPE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(13),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(13),
    [sym__newline_token] = ACTIONS(21),
    [sym_uri_autolink] = ACTIONS(5),
    [sym_email_autolink] = ACTIONS(5),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(23),
    [anon_sym_LT_QMARK] = ACTIONS(25),
    [aux_sym__declaration_token1] = ACTIONS(27),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(29),
    [sym__whitespace_ge_2] = ACTIONS(31),
    [aux_sym__whitespace_token1] = ACTIONS(33),
    [sym__word_no_digit] = ACTIONS(5),
    [sym__digits] = ACTIONS(5),
    [sym__code_span_start] = ACTIONS(35),
    [sym__emphasis_open_star] = ACTIONS(37),
    [sym__emphasis_open_underscore] = ACTIONS(39),
    [sym__strikethrough_open] = ACTIONS(43),
    [sym__latex_span_start] = ACTIONS(45),
    [sym__unclosed_span] = ACTIONS(5),
  },
  [32] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(346),
    [sym_shortcut_link] = STATE(21),
    [sym_full_reference_link] = STATE(21),
    [sym_collapsed_reference_link] = STATE(21),
    [sym_inline_link] = STATE(21),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(348),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(21),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(21),
    [aux_sym__inline_no_star] = STATE(21),
    [sym__strikethrough] = STATE(21),
    [sym__emphasis_star] = STATE(281),
    [sym__strong_emphasis_star] = STATE(21),
    [sym__emphasis_underscore] = STATE(281),
    [sym__strong_emphasis_underscore] = STATE(21),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(732),
    [sym_numeric_character_reference] = ACTIONS(732),
    [anon_sym_LBRACK] = ACTIONS(734),
    [anon_sym_RBRACK] = ACTIONS(736),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(742),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(732),
    [sym_email_autolink] = ACTIONS(732),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(750),
    [anon_sym_LT_QMARK] = ACTIONS(752),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(756),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(732),
    [sym__digits] = ACTIONS(732),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(764),
    [sym__emphasis_open_underscore] = ACTIONS(766),
    [sym__emphasis_close_star] = ACTIONS(1060),
    [sym__strikethrough_open] = ACTIONS(770),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(732),
  },
  [33] = {
    [sym_backslash_escape] = STATE(151),
    [sym_code_span] = STATE(151),
    [sym_latex_block] = STATE(151),
    [sym__link_text] = STATE(1124),
    [sym__link_text_non_empty] = STATE(513),
    [sym_shortcut_link] = STATE(12),
    [sym_full_reference_link] = STATE(12),
    [sym_collapsed_reference_link] = STATE(12),
    [sym_inline_link] = STATE(12),
    [sym_image] = STATE(151),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(515),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(151),
    [sym__whitespace] = STATE(151),
    [sym__word] = STATE(151),
    [sym__soft_line_break] = STATE(151),
    [sym__inline_base] = STATE(12),
    [sym__text_base] = STATE(151),
    [sym__inline_element_no_tilde] = STATE(12),
    [aux_sym__inline_no_tilde] = STATE(12),
    [sym__strikethrough] = STATE(12),
    [sym__emphasis_star] = STATE(285),
    [sym__strong_emphasis_star] = STATE(12),
    [sym__emphasis_underscore] = STATE(285),
    [sym__strong_emphasis_underscore] = STATE(12),
    [aux_sym__inline_base_repeat1] = STATE(151),
    [sym__backslash_escape] = ACTIONS(311),
    [sym_entity_reference] = ACTIONS(314),
    [sym_numeric_character_reference] = ACTIONS(314),
    [anon_sym_LBRACK] = ACTIONS(317),
    [anon_sym_RBRACK] = ACTIONS(320),
    [anon_sym_LT] = ACTIONS(323),
    [anon_sym_GT] = ACTIONS(326),
    [anon_sym_BANG] = ACTIONS(329),
    [anon_sym_DQUOTE] = ACTIONS(326),
    [anon_sym_POUND] = ACTIONS(326),
    [anon_sym_DOLLAR] = ACTIONS(326),
    [anon_sym_PERCENT] = ACTIONS(326),
    [anon_sym_AMP] = ACTIONS(332),
    [anon_sym_SQUOTE] = ACTIONS(326),
    [anon_sym_STAR] = ACTIONS(326),
    [anon_sym_PLUS] = ACTIONS(326),
    [anon_sym_COMMA] = ACTIONS(326),
    [anon_sym_DASH] = ACTIONS(326),
    [anon_sym_DOT] = ACTIONS(326),
    [anon_sym_SLASH] = ACTIONS(326),
    [anon_sym_COLON] = ACTIONS(326),
    [anon_sym_SEMI] = ACTIONS(326),
    [anon_sym_EQ] = ACTIONS(326),
    [anon_sym_QMARK] = ACTIONS(326),
    [anon_sym_AT] = ACTIONS(326),
    [anon_sym_BSLASH] = ACTIONS(335),
    [anon_sym_CARET] = ACTIONS(326),
    [anon_sym__] = ACTIONS(326),
    [anon_sym_BQUOTE] = ACTIONS(326),
    [anon_sym_LBRACE] = ACTIONS(326),
    [anon_sym_PIPE] = ACTIONS(326),
    [anon_sym_RBRACE] = ACTIONS(326),
    [anon_sym_TILDE] = ACTIONS(326),
    [anon_sym_LPAREN] = ACTIONS(326),
    [anon_sym_RPAREN] = ACTIONS(326),
    [sym__newline_token] = ACTIONS(338),
    [sym_uri_autolink] = ACTIONS(314),
    [sym_email_autolink] = ACTIONS(314),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(341),
    [anon_sym_LT_QMARK] = ACTIONS(344),
    [aux_sym__declaration_token1] = ACTIONS(347),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(350),
    [sym__whitespace_ge_2] = ACTIONS(353),
    [aux_sym__whitespace_token1] = ACTIONS(356),
    [sym__word_no_digit] = ACTIONS(314),
    [sym__digits] = ACTIONS(314),
    [sym__code_span_start] = ACTIONS(359),
    [sym__emphasis_open_star] = ACTIONS(362),
    [sym__emphasis_open_underscore] = ACTIONS(365),
    [sym__last_token_punctuation] = ACTIONS(1062),
    [sym__strikethrough_open] = ACTIONS(370),
    [sym__latex_span_start] = ACTIONS(373),
    [sym__unclosed_span] = ACTIONS(314),
  },
  [34] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(52),
    [sym_full_reference_link] = STATE(52),
    [sym_collapsed_reference_link] = STATE(52),
    [sym_inline_link] = STATE(52),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(52),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(52),
    [aux_sym__inline_no_underscore] = STATE(52),
    [sym__strikethrough] = STATE(52),
    [sym__emphasis_star] = STATE(282),
    [sym__strong_emphasis_star] = STATE(52),
    [sym__emphasis_underscore] = STATE(320),
    [sym__strong_emphasis_underscore] = STATE(52),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(181),
    [sym_entity_reference] = ACTIONS(184),
    [sym_numeric_character_reference] = ACTIONS(184),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_RBRACK] = ACTIONS(190),
    [anon_sym_LT] = ACTIONS(193),
    [anon_sym_GT] = ACTIONS(196),
    [anon_sym_BANG] = ACTIONS(199),
    [anon_sym_DQUOTE] = ACTIONS(196),
    [anon_sym_POUND] = ACTIONS(196),
    [anon_sym_DOLLAR] = ACTIONS(196),
    [anon_sym_PERCENT] = ACTIONS(196),
    [anon_sym_AMP] = ACTIONS(202),
    [anon_sym_SQUOTE] = ACTIONS(196),
    [anon_sym_STAR] = ACTIONS(196),
    [anon_sym_PLUS] = ACTIONS(196),
    [anon_sym_COMMA] = ACTIONS(196),
    [anon_sym_DASH] = ACTIONS(196),
    [anon_sym_DOT] = ACTIONS(196),
    [anon_sym_SLASH] = ACTIONS(196),
    [anon_sym_COLON] = ACTIONS(196),
    [anon_sym_SEMI] = ACTIONS(196),
    [anon_sym_EQ] = ACTIONS(196),
    [anon_sym_QMARK] = ACTIONS(196),
    [anon_sym_AT] = ACTIONS(196),
    [anon_sym_BSLASH] = ACTIONS(205),
    [anon_sym_CARET] = ACTIONS(196),
    [anon_sym__] = ACTIONS(196),
    [anon_sym_BQUOTE] = ACTIONS(196),
    [anon_sym_LBRACE] = ACTIONS(196),
    [anon_sym_PIPE] = ACTIONS(196),
    [anon_sym_RBRACE] = ACTIONS(196),
    [anon_sym_TILDE] = ACTIONS(196),
    [anon_sym_LPAREN] = ACTIONS(196),
    [anon_sym_RPAREN] = ACTIONS(196),
    [sym__newline_token] = ACTIONS(208),
    [sym_uri_autolink] = ACTIONS(184),
    [sym_email_autolink] = ACTIONS(184),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(211),
    [anon_sym_LT_QMARK] = ACTIONS(214),
    [aux_sym__declaration_token1] = ACTIONS(217),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(220),
    [sym__whitespace_ge_2] = ACTIONS(223),
    [aux_sym__whitespace_token1] = ACTIONS(226),
    [sym__word_no_digit] = ACTIONS(184),
    [sym__digits] = ACTIONS(184),
    [sym__code_span_start] = ACTIONS(229),
    [sym__emphasis_open_star] = ACTIONS(232),
    [sym__emphasis_open_underscore] = ACTIONS(235),
    [sym__last_token_punctuation] = ACTIONS(1064),
    [sym__strikethrough_open] = ACTIONS(240),
    [sym__latex_span_start] = ACTIONS(243),
    [sym__unclosed_span] = ACTIONS(184),
  },
  [35] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(346),
    [sym_shortcut_link] = STATE(43),
    [sym_full_reference_link] = STATE(43),
    [sym_collapsed_reference_link] = STATE(43),
    [sym_inline_link] = STATE(43),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(348),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(43),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(43),
    [aux_sym__inline_no_star] = STATE(43),
    [sym__strikethrough] = STATE(43),
    [sym__emphasis_star] = STATE(316),
    [sym__strong_emphasis_star] = STATE(43),
    [sym__emphasis_underscore] = STATE(281),
    [sym__strong_emphasis_underscore] = STATE(43),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(116),
    [sym_entity_reference] = ACTIONS(119),
    [sym_numeric_character_reference] = ACTIONS(119),
    [anon_sym_LBRACK] = ACTIONS(122),
    [anon_sym_RBRACK] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(128),
    [anon_sym_GT] = ACTIONS(131),
    [anon_sym_BANG] = ACTIONS(134),
    [anon_sym_DQUOTE] = ACTIONS(131),
    [anon_sym_POUND] = ACTIONS(131),
    [anon_sym_DOLLAR] = ACTIONS(131),
    [anon_sym_PERCENT] = ACTIONS(131),
    [anon_sym_AMP] = ACTIONS(137),
    [anon_sym_SQUOTE] = ACTIONS(131),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_PLUS] = ACTIONS(131),
    [anon_sym_COMMA] = ACTIONS(131),
    [anon_sym_DASH] = ACTIONS(131),
    [anon_sym_DOT] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(131),
    [anon_sym_COLON] = ACTIONS(131),
    [anon_sym_SEMI] = ACTIONS(131),
    [anon_sym_EQ] = ACTIONS(131),
    [anon_sym_QMARK] = ACTIONS(131),
    [anon_sym_AT] = ACTIONS(131),
    [anon_sym_BSLASH] = ACTIONS(140),
    [anon_sym_CARET] = ACTIONS(131),
    [anon_sym__] = ACTIONS(131),
    [anon_sym_BQUOTE] = ACTIONS(131),
    [anon_sym_LBRACE] = ACTIONS(131),
    [anon_sym_PIPE] = ACTIONS(131),
    [anon_sym_RBRACE] = ACTIONS(131),
    [anon_sym_TILDE] = ACTIONS(131),
    [anon_sym_LPAREN] = ACTIONS(131),
    [anon_sym_RPAREN] = ACTIONS(131),
    [sym__newline_token] = ACTIONS(143),
    [sym_uri_autolink] = ACTIONS(119),
    [sym_email_autolink] = ACTIONS(119),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(146),
    [anon_sym_LT_QMARK] = ACTIONS(149),
    [aux_sym__declaration_token1] = ACTIONS(152),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(155),
    [sym__whitespace_ge_2] = ACTIONS(158),
    [aux_sym__whitespace_token1] = ACTIONS(161),
    [sym__word_no_digit] = ACTIONS(119),
    [sym__digits] = ACTIONS(119),
    [sym__code_span_start] = ACTIONS(164),
    [sym__emphasis_open_star] = ACTIONS(167),
    [sym__emphasis_open_underscore] = ACTIONS(170),
    [sym__last_token_punctuation] = ACTIONS(1066),
    [sym__strikethrough_open] = ACTIONS(175),
    [sym__latex_span_start] = ACTIONS(178),
    [sym__unclosed_span] = ACTIONS(119),
  },
  [36] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(346),
    [sym_shortcut_link] = STATE(14),
    [sym_full_reference_link] = STATE(14),
    [sym_collapsed_reference_link] = STATE(14),
    [sym_inline_link] = STATE(14),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(348),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(14),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(14),
    [aux_sym__inline_no_star] = STATE(14),
    [sym__strikethrough] = STATE(14),
    [sym__emphasis_star] = STATE(410),
    [sym__strong_emphasis_star] = STATE(14),
    [sym__emphasis_underscore] = STATE(281),
    [sym__strong_emphasis_underscore] = STATE(14),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(732),
    [sym_numeric_character_reference] = ACTIONS(732),
    [anon_sym_LBRACK] = ACTIONS(734),
    [anon_sym_RBRACK] = ACTIONS(736),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(742),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(732),
    [sym_email_autolink] = ACTIONS(732),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(750),
    [anon_sym_LT_QMARK] = ACTIONS(752),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(756),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(732),
    [sym__digits] = ACTIONS(732),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(764),
    [sym__emphasis_open_underscore] = ACTIONS(766),
    [sym__last_token_punctuation] = ACTIONS(1068),
    [sym__strikethrough_open] = ACTIONS(770),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(732),
  },
  [37] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(19),
    [sym_full_reference_link] = STATE(19),
    [sym_collapsed_reference_link] = STATE(19),
    [sym_inline_link] = STATE(19),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(19),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(19),
    [aux_sym__inline_no_underscore] = STATE(19),
    [sym__strikethrough] = STATE(19),
    [sym__emphasis_star] = STATE(282),
    [sym__strong_emphasis_star] = STATE(19),
    [sym__emphasis_underscore] = STATE(282),
    [sym__strong_emphasis_underscore] = STATE(19),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(688),
    [sym_numeric_character_reference] = ACTIONS(688),
    [anon_sym_LBRACK] = ACTIONS(690),
    [anon_sym_RBRACK] = ACTIONS(692),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(698),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(688),
    [sym_email_autolink] = ACTIONS(688),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(706),
    [anon_sym_LT_QMARK] = ACTIONS(708),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(712),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(688),
    [sym__digits] = ACTIONS(688),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(720),
    [sym__emphasis_open_underscore] = ACTIONS(722),
    [sym__emphasis_close_underscore] = ACTIONS(1070),
    [sym__strikethrough_open] = ACTIONS(726),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(688),
  },
  [38] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(264),
    [sym_shortcut_link] = STATE(271),
    [sym_full_reference_link] = STATE(271),
    [sym_collapsed_reference_link] = STATE(271),
    [sym_inline_link] = STATE(271),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(265),
    [sym__image_shortcut_link] = STATE(265),
    [sym__image_full_reference_link] = STATE(265),
    [sym__image_collapsed_reference_link] = STATE(265),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(266),
    [sym__html_tag] = STATE(267),
    [sym__open_tag] = STATE(270),
    [sym__closing_tag] = STATE(270),
    [sym__html_comment] = STATE(270),
    [sym__processing_instruction] = STATE(270),
    [sym__declaration] = STATE(270),
    [sym__cdata_section] = STATE(270),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(271),
    [sym__text_base] = STATE(154),
    [sym__inline_element] = STATE(271),
    [aux_sym__inline] = STATE(25),
    [sym__strikethrough] = STATE(271),
    [sym__emphasis_star] = STATE(274),
    [sym__strong_emphasis_star] = STATE(271),
    [sym__emphasis_underscore] = STATE(274),
    [sym__strong_emphasis_underscore] = STATE(271),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [ts_builtin_sym_end] = ACTIONS(1072),
    [sym__backslash_escape] = ACTIONS(3),
    [sym_entity_reference] = ACTIONS(5),
    [sym_numeric_character_reference] = ACTIONS(5),
    [anon_sym_LBRACK] = ACTIONS(7),
    [anon_sym_RBRACK] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(11),
    [anon_sym_GT] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_POUND] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_PERCENT] = ACTIONS(13),
    [anon_sym_AMP] = ACTIONS(17),
    [anon_sym_SQUOTE] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(13),
    [anon_sym_DASH] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(13),
    [anon_sym_SLASH] = ACTIONS(13),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_SEMI] = ACTIONS(13),
    [anon_sym_EQ] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(13),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_BSLASH] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(13),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_PIPE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(13),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(13),
    [sym__newline_token] = ACTIONS(21),
    [sym_uri_autolink] = ACTIONS(5),
    [sym_email_autolink] = ACTIONS(5),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(23),
    [anon_sym_LT_QMARK] = ACTIONS(25),
    [aux_sym__declaration_token1] = ACTIONS(27),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(29),
    [sym__whitespace_ge_2] = ACTIONS(31),
    [aux_sym__whitespace_token1] = ACTIONS(33),
    [sym__word_no_digit] = ACTIONS(5),
    [sym__digits] = ACTIONS(5),
    [sym__code_span_start] = ACTIONS(35),
    [sym__emphasis_open_star] = ACTIONS(37),
    [sym__emphasis_open_underscore] = ACTIONS(39),
    [sym__strikethrough_open] = ACTIONS(43),
    [sym__latex_span_start] = ACTIONS(45),
    [sym__unclosed_span] = ACTIONS(5),
  },
  [39] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(346),
    [sym_shortcut_link] = STATE(21),
    [sym_full_reference_link] = STATE(21),
    [sym_collapsed_reference_link] = STATE(21),
    [sym_inline_link] = STATE(21),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(348),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(21),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(21),
    [aux_sym__inline_no_star] = STATE(21),
    [sym__strikethrough] = STATE(21),
    [sym__emphasis_star] = STATE(281),
    [sym__strong_emphasis_star] = STATE(21),
    [sym__emphasis_underscore] = STATE(281),
    [sym__strong_emphasis_underscore] = STATE(21),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(732),
    [sym_numeric_character_reference] = ACTIONS(732),
    [anon_sym_LBRACK] = ACTIONS(734),
    [anon_sym_RBRACK] = ACTIONS(736),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(742),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(732),
    [sym_email_autolink] = ACTIONS(732),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(750),
    [anon_sym_LT_QMARK] = ACTIONS(752),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(756),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(732),
    [sym__digits] = ACTIONS(732),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(764),
    [sym__emphasis_open_underscore] = ACTIONS(766),
    [sym__emphasis_close_star] = ACTIONS(1074),
    [sym__strikethrough_open] = ACTIONS(770),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(732),
  },
  [40] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(19),
    [sym_full_reference_link] = STATE(19),
    [sym_collapsed_reference_link] = STATE(19),
    [sym_inline_link] = STATE(19),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(19),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(19),
    [aux_sym__inline_no_underscore] = STATE(19),
    [sym__strikethrough] = STATE(19),
    [sym__emphasis_star] = STATE(282),
    [sym__strong_emphasis_star] = STATE(19),
    [sym__emphasis_underscore] = STATE(282),
    [sym__strong_emphasis_underscore] = STATE(19),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(688),
    [sym_numeric_character_reference] = ACTIONS(688),
    [anon_sym_LBRACK] = ACTIONS(690),
    [anon_sym_RBRACK] = ACTIONS(692),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(698),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(688),
    [sym_email_autolink] = ACTIONS(688),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(706),
    [anon_sym_LT_QMARK] = ACTIONS(708),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(712),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(688),
    [sym__digits] = ACTIONS(688),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(720),
    [sym__emphasis_open_underscore] = ACTIONS(722),
    [sym__emphasis_close_underscore] = ACTIONS(1076),
    [sym__strikethrough_open] = ACTIONS(726),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(688),
  },
  [41] = {
    [sym_backslash_escape] = STATE(151),
    [sym_code_span] = STATE(151),
    [sym_latex_block] = STATE(151),
    [sym__link_text] = STATE(1124),
    [sym__link_text_non_empty] = STATE(513),
    [sym_shortcut_link] = STATE(15),
    [sym_full_reference_link] = STATE(15),
    [sym_collapsed_reference_link] = STATE(15),
    [sym_inline_link] = STATE(15),
    [sym_image] = STATE(151),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(515),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(151),
    [sym__whitespace] = STATE(151),
    [sym__word] = STATE(151),
    [sym__soft_line_break] = STATE(151),
    [sym__inline_base] = STATE(15),
    [sym__text_base] = STATE(151),
    [sym__inline_element_no_tilde] = STATE(15),
    [aux_sym__inline_no_tilde] = STATE(15),
    [sym__strikethrough] = STATE(15),
    [sym__emphasis_star] = STATE(285),
    [sym__strong_emphasis_star] = STATE(15),
    [sym__emphasis_underscore] = STATE(285),
    [sym__strong_emphasis_underscore] = STATE(15),
    [aux_sym__inline_base_repeat1] = STATE(151),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__strikethrough_open] = ACTIONS(678),
    [sym__strikethrough_close] = ACTIONS(1078),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [42] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(346),
    [sym_shortcut_link] = STATE(21),
    [sym_full_reference_link] = STATE(21),
    [sym_collapsed_reference_link] = STATE(21),
    [sym_inline_link] = STATE(21),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(348),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(21),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(21),
    [aux_sym__inline_no_star] = STATE(21),
    [sym__strikethrough] = STATE(21),
    [sym__emphasis_star] = STATE(281),
    [sym__strong_emphasis_star] = STATE(21),
    [sym__emphasis_underscore] = STATE(281),
    [sym__strong_emphasis_underscore] = STATE(21),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(732),
    [sym_numeric_character_reference] = ACTIONS(732),
    [anon_sym_LBRACK] = ACTIONS(734),
    [anon_sym_RBRACK] = ACTIONS(736),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(742),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(732),
    [sym_email_autolink] = ACTIONS(732),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(750),
    [anon_sym_LT_QMARK] = ACTIONS(752),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(756),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(732),
    [sym__digits] = ACTIONS(732),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(764),
    [sym__emphasis_open_underscore] = ACTIONS(766),
    [sym__emphasis_close_star] = ACTIONS(1080),
    [sym__strikethrough_open] = ACTIONS(770),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(732),
  },
  [43] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(346),
    [sym_shortcut_link] = STATE(21),
    [sym_full_reference_link] = STATE(21),
    [sym_collapsed_reference_link] = STATE(21),
    [sym_inline_link] = STATE(21),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(348),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(21),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(21),
    [aux_sym__inline_no_star] = STATE(21),
    [sym__strikethrough] = STATE(21),
    [sym__emphasis_star] = STATE(281),
    [sym__strong_emphasis_star] = STATE(21),
    [sym__emphasis_underscore] = STATE(281),
    [sym__strong_emphasis_underscore] = STATE(21),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(732),
    [sym_numeric_character_reference] = ACTIONS(732),
    [anon_sym_LBRACK] = ACTIONS(734),
    [anon_sym_RBRACK] = ACTIONS(736),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(742),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(732),
    [sym_email_autolink] = ACTIONS(732),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(750),
    [anon_sym_LT_QMARK] = ACTIONS(752),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(756),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(732),
    [sym__digits] = ACTIONS(732),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(764),
    [sym__emphasis_open_underscore] = ACTIONS(766),
    [sym__emphasis_close_star] = ACTIONS(1082),
    [sym__strikethrough_open] = ACTIONS(770),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(732),
  },
  [44] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(19),
    [sym_full_reference_link] = STATE(19),
    [sym_collapsed_reference_link] = STATE(19),
    [sym_inline_link] = STATE(19),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(19),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(19),
    [aux_sym__inline_no_underscore] = STATE(19),
    [sym__strikethrough] = STATE(19),
    [sym__emphasis_star] = STATE(282),
    [sym__strong_emphasis_star] = STATE(19),
    [sym__emphasis_underscore] = STATE(282),
    [sym__strong_emphasis_underscore] = STATE(19),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(688),
    [sym_numeric_character_reference] = ACTIONS(688),
    [anon_sym_LBRACK] = ACTIONS(690),
    [anon_sym_RBRACK] = ACTIONS(692),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(698),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(688),
    [sym_email_autolink] = ACTIONS(688),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(706),
    [anon_sym_LT_QMARK] = ACTIONS(708),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(712),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(688),
    [sym__digits] = ACTIONS(688),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(720),
    [sym__emphasis_open_underscore] = ACTIONS(722),
    [sym__emphasis_close_underscore] = ACTIONS(1084),
    [sym__strikethrough_open] = ACTIONS(726),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(688),
  },
  [45] = {
    [sym_backslash_escape] = STATE(151),
    [sym_code_span] = STATE(151),
    [sym_latex_block] = STATE(151),
    [sym__link_text] = STATE(1124),
    [sym__link_text_non_empty] = STATE(513),
    [sym_shortcut_link] = STATE(30),
    [sym_full_reference_link] = STATE(30),
    [sym_collapsed_reference_link] = STATE(30),
    [sym_inline_link] = STATE(30),
    [sym_image] = STATE(151),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(515),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(151),
    [sym__whitespace] = STATE(151),
    [sym__word] = STATE(151),
    [sym__soft_line_break] = STATE(151),
    [sym__inline_base] = STATE(30),
    [sym__text_base] = STATE(151),
    [sym__inline_element_no_tilde] = STATE(30),
    [aux_sym__inline_no_tilde] = STATE(30),
    [sym__strikethrough] = STATE(30),
    [sym__emphasis_star] = STATE(285),
    [sym__strong_emphasis_star] = STATE(30),
    [sym__emphasis_underscore] = STATE(285),
    [sym__strong_emphasis_underscore] = STATE(30),
    [aux_sym__inline_base_repeat1] = STATE(151),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__last_token_punctuation] = ACTIONS(1086),
    [sym__strikethrough_open] = ACTIONS(678),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [46] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(44),
    [sym_full_reference_link] = STATE(44),
    [sym_collapsed_reference_link] = STATE(44),
    [sym_inline_link] = STATE(44),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(44),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(44),
    [aux_sym__inline_no_underscore] = STATE(44),
    [sym__strikethrough] = STATE(44),
    [sym__emphasis_star] = STATE(282),
    [sym__strong_emphasis_star] = STATE(44),
    [sym__emphasis_underscore] = STATE(313),
    [sym__strong_emphasis_underscore] = STATE(44),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(688),
    [sym_numeric_character_reference] = ACTIONS(688),
    [anon_sym_LBRACK] = ACTIONS(690),
    [anon_sym_RBRACK] = ACTIONS(692),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(698),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(688),
    [sym_email_autolink] = ACTIONS(688),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(706),
    [anon_sym_LT_QMARK] = ACTIONS(708),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(712),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(688),
    [sym__digits] = ACTIONS(688),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(720),
    [sym__emphasis_open_underscore] = ACTIONS(722),
    [sym__last_token_punctuation] = ACTIONS(1088),
    [sym__strikethrough_open] = ACTIONS(726),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(688),
  },
  [47] = {
    [sym_backslash_escape] = STATE(151),
    [sym_code_span] = STATE(151),
    [sym_latex_block] = STATE(151),
    [sym__link_text] = STATE(1124),
    [sym__link_text_non_empty] = STATE(513),
    [sym_shortcut_link] = STATE(15),
    [sym_full_reference_link] = STATE(15),
    [sym_collapsed_reference_link] = STATE(15),
    [sym_inline_link] = STATE(15),
    [sym_image] = STATE(151),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(515),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(151),
    [sym__whitespace] = STATE(151),
    [sym__word] = STATE(151),
    [sym__soft_line_break] = STATE(151),
    [sym__inline_base] = STATE(15),
    [sym__text_base] = STATE(151),
    [sym__inline_element_no_tilde] = STATE(15),
    [aux_sym__inline_no_tilde] = STATE(15),
    [sym__strikethrough] = STATE(15),
    [sym__emphasis_star] = STATE(285),
    [sym__strong_emphasis_star] = STATE(15),
    [sym__emphasis_underscore] = STATE(285),
    [sym__strong_emphasis_underscore] = STATE(15),
    [aux_sym__inline_base_repeat1] = STATE(151),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__strikethrough_open] = ACTIONS(678),
    [sym__strikethrough_close] = ACTIONS(1090),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [48] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(346),
    [sym_shortcut_link] = STATE(21),
    [sym_full_reference_link] = STATE(21),
    [sym_collapsed_reference_link] = STATE(21),
    [sym_inline_link] = STATE(21),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(348),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(21),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(21),
    [aux_sym__inline_no_star] = STATE(21),
    [sym__strikethrough] = STATE(21),
    [sym__emphasis_star] = STATE(281),
    [sym__strong_emphasis_star] = STATE(21),
    [sym__emphasis_underscore] = STATE(281),
    [sym__strong_emphasis_underscore] = STATE(21),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(732),
    [sym_numeric_character_reference] = ACTIONS(732),
    [anon_sym_LBRACK] = ACTIONS(734),
    [anon_sym_RBRACK] = ACTIONS(736),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(742),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(732),
    [sym_email_autolink] = ACTIONS(732),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(750),
    [anon_sym_LT_QMARK] = ACTIONS(752),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(756),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(732),
    [sym__digits] = ACTIONS(732),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(764),
    [sym__emphasis_open_underscore] = ACTIONS(766),
    [sym__emphasis_close_star] = ACTIONS(1092),
    [sym__strikethrough_open] = ACTIONS(770),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(732),
  },
  [49] = {
    [sym_backslash_escape] = STATE(151),
    [sym_code_span] = STATE(151),
    [sym_latex_block] = STATE(151),
    [sym__link_text] = STATE(1124),
    [sym__link_text_non_empty] = STATE(513),
    [sym_shortcut_link] = STATE(15),
    [sym_full_reference_link] = STATE(15),
    [sym_collapsed_reference_link] = STATE(15),
    [sym_inline_link] = STATE(15),
    [sym_image] = STATE(151),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(515),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(151),
    [sym__whitespace] = STATE(151),
    [sym__word] = STATE(151),
    [sym__soft_line_break] = STATE(151),
    [sym__inline_base] = STATE(15),
    [sym__text_base] = STATE(151),
    [sym__inline_element_no_tilde] = STATE(15),
    [aux_sym__inline_no_tilde] = STATE(15),
    [sym__strikethrough] = STATE(15),
    [sym__emphasis_star] = STATE(285),
    [sym__strong_emphasis_star] = STATE(15),
    [sym__emphasis_underscore] = STATE(285),
    [sym__strong_emphasis_underscore] = STATE(15),
    [aux_sym__inline_base_repeat1] = STATE(151),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__strikethrough_open] = ACTIONS(678),
    [sym__strikethrough_close] = ACTIONS(1094),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [50] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(346),
    [sym_shortcut_link] = STATE(21),
    [sym_full_reference_link] = STATE(21),
    [sym_collapsed_reference_link] = STATE(21),
    [sym_inline_link] = STATE(21),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(348),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(21),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(21),
    [aux_sym__inline_no_star] = STATE(21),
    [sym__strikethrough] = STATE(21),
    [sym__emphasis_star] = STATE(281),
    [sym__strong_emphasis_star] = STATE(21),
    [sym__emphasis_underscore] = STATE(281),
    [sym__strong_emphasis_underscore] = STATE(21),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(732),
    [sym_numeric_character_reference] = ACTIONS(732),
    [anon_sym_LBRACK] = ACTIONS(734),
    [anon_sym_RBRACK] = ACTIONS(736),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(742),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(732),
    [sym_email_autolink] = ACTIONS(732),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(750),
    [anon_sym_LT_QMARK] = ACTIONS(752),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(756),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(732),
    [sym__digits] = ACTIONS(732),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(764),
    [sym__emphasis_open_underscore] = ACTIONS(766),
    [sym__emphasis_close_star] = ACTIONS(1096),
    [sym__strikethrough_open] = ACTIONS(770),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(732),
  },
  [51] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(19),
    [sym_full_reference_link] = STATE(19),
    [sym_collapsed_reference_link] = STATE(19),
    [sym_inline_link] = STATE(19),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(19),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(19),
    [aux_sym__inline_no_underscore] = STATE(19),
    [sym__strikethrough] = STATE(19),
    [sym__emphasis_star] = STATE(282),
    [sym__strong_emphasis_star] = STATE(19),
    [sym__emphasis_underscore] = STATE(282),
    [sym__strong_emphasis_underscore] = STATE(19),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(688),
    [sym_numeric_character_reference] = ACTIONS(688),
    [anon_sym_LBRACK] = ACTIONS(690),
    [anon_sym_RBRACK] = ACTIONS(692),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(698),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(688),
    [sym_email_autolink] = ACTIONS(688),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(706),
    [anon_sym_LT_QMARK] = ACTIONS(708),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(712),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(688),
    [sym__digits] = ACTIONS(688),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(720),
    [sym__emphasis_open_underscore] = ACTIONS(722),
    [sym__emphasis_close_underscore] = ACTIONS(1098),
    [sym__strikethrough_open] = ACTIONS(726),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(688),
  },
  [52] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(19),
    [sym_full_reference_link] = STATE(19),
    [sym_collapsed_reference_link] = STATE(19),
    [sym_inline_link] = STATE(19),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(19),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(19),
    [aux_sym__inline_no_underscore] = STATE(19),
    [sym__strikethrough] = STATE(19),
    [sym__emphasis_star] = STATE(282),
    [sym__strong_emphasis_star] = STATE(19),
    [sym__emphasis_underscore] = STATE(282),
    [sym__strong_emphasis_underscore] = STATE(19),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(688),
    [sym_numeric_character_reference] = ACTIONS(688),
    [anon_sym_LBRACK] = ACTIONS(690),
    [anon_sym_RBRACK] = ACTIONS(692),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(698),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(688),
    [sym_email_autolink] = ACTIONS(688),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(706),
    [anon_sym_LT_QMARK] = ACTIONS(708),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(712),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(688),
    [sym__digits] = ACTIONS(688),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(720),
    [sym__emphasis_open_underscore] = ACTIONS(722),
    [sym__emphasis_close_underscore] = ACTIONS(1100),
    [sym__strikethrough_open] = ACTIONS(726),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(688),
  },
  [53] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(20),
    [sym_full_reference_link] = STATE(20),
    [sym_collapsed_reference_link] = STATE(20),
    [sym_inline_link] = STATE(20),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(20),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(20),
    [aux_sym__inline_no_underscore] = STATE(20),
    [sym__strikethrough] = STATE(20),
    [sym__emphasis_star] = STATE(282),
    [sym__strong_emphasis_star] = STATE(20),
    [sym__emphasis_underscore] = STATE(282),
    [sym__strong_emphasis_underscore] = STATE(20),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(688),
    [sym_numeric_character_reference] = ACTIONS(688),
    [anon_sym_LBRACK] = ACTIONS(690),
    [anon_sym_RBRACK] = ACTIONS(692),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(698),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(688),
    [sym_email_autolink] = ACTIONS(688),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(706),
    [anon_sym_LT_QMARK] = ACTIONS(708),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(712),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(688),
    [sym__digits] = ACTIONS(688),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(720),
    [sym__emphasis_open_underscore] = ACTIONS(722),
    [sym__strikethrough_open] = ACTIONS(726),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(688),
  },
  [54] = {
    [sym_backslash_escape] = STATE(156),
    [sym_code_span] = STATE(156),
    [sym_latex_block] = STATE(156),
    [sym__link_text] = STATE(1125),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(574),
    [sym_full_reference_link] = STATE(574),
    [sym_collapsed_reference_link] = STATE(574),
    [sym_inline_link] = STATE(574),
    [sym_image] = STATE(156),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(537),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(156),
    [sym__whitespace] = STATE(156),
    [sym__word] = STATE(156),
    [sym__soft_line_break] = STATE(156),
    [sym__inline_base] = STATE(574),
    [sym__text_base] = STATE(156),
    [sym__inline_element] = STATE(574),
    [aux_sym__inline] = STATE(73),
    [sym__strikethrough] = STATE(574),
    [sym__emphasis_star] = STATE(573),
    [sym__strong_emphasis_star] = STATE(574),
    [sym__emphasis_underscore] = STATE(573),
    [sym__strong_emphasis_underscore] = STATE(574),
    [aux_sym__inline_base_repeat1] = STATE(156),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1108),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [55] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(346),
    [sym_shortcut_link] = STATE(29),
    [sym_full_reference_link] = STATE(29),
    [sym_collapsed_reference_link] = STATE(29),
    [sym_inline_link] = STATE(29),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(348),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(29),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(29),
    [aux_sym__inline_no_star] = STATE(29),
    [sym__strikethrough] = STATE(29),
    [sym__emphasis_star] = STATE(281),
    [sym__strong_emphasis_star] = STATE(29),
    [sym__emphasis_underscore] = STATE(281),
    [sym__strong_emphasis_underscore] = STATE(29),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(732),
    [sym_numeric_character_reference] = ACTIONS(732),
    [anon_sym_LBRACK] = ACTIONS(734),
    [anon_sym_RBRACK] = ACTIONS(736),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(742),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(732),
    [sym_email_autolink] = ACTIONS(732),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(750),
    [anon_sym_LT_QMARK] = ACTIONS(752),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(756),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(732),
    [sym__digits] = ACTIONS(732),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(764),
    [sym__emphasis_open_underscore] = ACTIONS(766),
    [sym__strikethrough_open] = ACTIONS(770),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(732),
  },
  [56] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(28),
    [sym_full_reference_link] = STATE(28),
    [sym_collapsed_reference_link] = STATE(28),
    [sym_inline_link] = STATE(28),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(28),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(28),
    [aux_sym__inline_no_underscore] = STATE(28),
    [sym__strikethrough] = STATE(28),
    [sym__emphasis_star] = STATE(282),
    [sym__strong_emphasis_star] = STATE(28),
    [sym__emphasis_underscore] = STATE(282),
    [sym__strong_emphasis_underscore] = STATE(28),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(688),
    [sym_numeric_character_reference] = ACTIONS(688),
    [anon_sym_LBRACK] = ACTIONS(690),
    [anon_sym_RBRACK] = ACTIONS(692),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(698),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(688),
    [sym_email_autolink] = ACTIONS(688),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(706),
    [anon_sym_LT_QMARK] = ACTIONS(708),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(712),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(688),
    [sym__digits] = ACTIONS(688),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(720),
    [sym__emphasis_open_underscore] = ACTIONS(722),
    [sym__strikethrough_open] = ACTIONS(726),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(688),
  },
  [57] = {
    [sym_backslash_escape] = STATE(151),
    [sym_code_span] = STATE(151),
    [sym_latex_block] = STATE(151),
    [sym__link_text] = STATE(1124),
    [sym__link_text_non_empty] = STATE(513),
    [sym_shortcut_link] = STATE(27),
    [sym_full_reference_link] = STATE(27),
    [sym_collapsed_reference_link] = STATE(27),
    [sym_inline_link] = STATE(27),
    [sym_image] = STATE(151),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(515),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(151),
    [sym__whitespace] = STATE(151),
    [sym__word] = STATE(151),
    [sym__soft_line_break] = STATE(151),
    [sym__inline_base] = STATE(27),
    [sym__text_base] = STATE(151),
    [sym__inline_element_no_tilde] = STATE(27),
    [aux_sym__inline_no_tilde] = STATE(27),
    [sym__strikethrough] = STATE(27),
    [sym__emphasis_star] = STATE(285),
    [sym__strong_emphasis_star] = STATE(27),
    [sym__emphasis_underscore] = STATE(285),
    [sym__strong_emphasis_underscore] = STATE(27),
    [aux_sym__inline_base_repeat1] = STATE(151),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__strikethrough_open] = ACTIONS(678),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [58] = {
    [sym_backslash_escape] = STATE(154),
    [sym_code_span] = STATE(154),
    [sym_latex_block] = STATE(154),
    [sym__link_text] = STATE(1118),
    [sym__link_text_non_empty] = STATE(264),
    [sym_shortcut_link] = STATE(271),
    [sym_full_reference_link] = STATE(271),
    [sym_collapsed_reference_link] = STATE(271),
    [sym_inline_link] = STATE(271),
    [sym_image] = STATE(154),
    [sym__image_inline_link] = STATE(265),
    [sym__image_shortcut_link] = STATE(265),
    [sym__image_full_reference_link] = STATE(265),
    [sym__image_collapsed_reference_link] = STATE(265),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(266),
    [sym__html_tag] = STATE(267),
    [sym__open_tag] = STATE(270),
    [sym__closing_tag] = STATE(270),
    [sym__html_comment] = STATE(270),
    [sym__processing_instruction] = STATE(270),
    [sym__declaration] = STATE(270),
    [sym__cdata_section] = STATE(270),
    [sym_hard_line_break] = STATE(154),
    [sym__whitespace] = STATE(154),
    [sym__word] = STATE(154),
    [sym__soft_line_break] = STATE(154),
    [sym__inline_base] = STATE(271),
    [sym__text_base] = STATE(154),
    [sym__inline_element] = STATE(271),
    [aux_sym__inline] = STATE(38),
    [sym__strikethrough] = STATE(271),
    [sym__emphasis_star] = STATE(274),
    [sym__strong_emphasis_star] = STATE(271),
    [sym__emphasis_underscore] = STATE(274),
    [sym__strong_emphasis_underscore] = STATE(271),
    [aux_sym__inline_base_repeat1] = STATE(154),
    [sym__backslash_escape] = ACTIONS(3),
    [sym_entity_reference] = ACTIONS(5),
    [sym_numeric_character_reference] = ACTIONS(5),
    [anon_sym_LBRACK] = ACTIONS(7),
    [anon_sym_RBRACK] = ACTIONS(9),
    [anon_sym_LT] = ACTIONS(11),
    [anon_sym_GT] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_POUND] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_PERCENT] = ACTIONS(13),
    [anon_sym_AMP] = ACTIONS(17),
    [anon_sym_SQUOTE] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(13),
    [anon_sym_DASH] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(13),
    [anon_sym_SLASH] = ACTIONS(13),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_SEMI] = ACTIONS(13),
    [anon_sym_EQ] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(13),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_BSLASH] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(13),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_PIPE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(13),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(13),
    [sym__newline_token] = ACTIONS(21),
    [sym_uri_autolink] = ACTIONS(5),
    [sym_email_autolink] = ACTIONS(5),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(23),
    [anon_sym_LT_QMARK] = ACTIONS(25),
    [aux_sym__declaration_token1] = ACTIONS(27),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(29),
    [sym__whitespace_ge_2] = ACTIONS(31),
    [aux_sym__whitespace_token1] = ACTIONS(33),
    [sym__word_no_digit] = ACTIONS(5),
    [sym__digits] = ACTIONS(5),
    [sym__code_span_start] = ACTIONS(35),
    [sym__emphasis_open_star] = ACTIONS(37),
    [sym__emphasis_open_underscore] = ACTIONS(39),
    [sym__strikethrough_open] = ACTIONS(43),
    [sym__latex_span_start] = ACTIONS(45),
    [sym__unclosed_span] = ACTIONS(5),
  },
  [59] = {
    [sym_backslash_escape] = STATE(151),
    [sym_code_span] = STATE(151),
    [sym_latex_block] = STATE(151),
    [sym__link_text] = STATE(1124),
    [sym__link_text_non_empty] = STATE(513),
    [sym_shortcut_link] = STATE(11),
    [sym_full_reference_link] = STATE(11),
    [sym_collapsed_reference_link] = STATE(11),
    [sym_inline_link] = STATE(11),
    [sym_image] = STATE(151),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(515),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(151),
    [sym__whitespace] = STATE(151),
    [sym__word] = STATE(151),
    [sym__soft_line_break] = STATE(151),
    [sym__inline_base] = STATE(11),
    [sym__text_base] = STATE(151),
    [sym__inline_element_no_tilde] = STATE(11),
    [aux_sym__inline_no_tilde] = STATE(11),
    [sym__strikethrough] = STATE(11),
    [sym__emphasis_star] = STATE(285),
    [sym__strong_emphasis_star] = STATE(11),
    [sym__emphasis_underscore] = STATE(285),
    [sym__strong_emphasis_underscore] = STATE(11),
    [aux_sym__inline_base_repeat1] = STATE(151),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__strikethrough_open] = ACTIONS(678),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [60] = {
    [sym_backslash_escape] = STATE(156),
    [sym_code_span] = STATE(156),
    [sym_latex_block] = STATE(156),
    [sym__link_text] = STATE(1125),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(574),
    [sym_full_reference_link] = STATE(574),
    [sym_collapsed_reference_link] = STATE(574),
    [sym_inline_link] = STATE(574),
    [sym_image] = STATE(156),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(537),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(156),
    [sym__whitespace] = STATE(156),
    [sym__word] = STATE(156),
    [sym__soft_line_break] = STATE(156),
    [sym__inline_base] = STATE(574),
    [sym__text_base] = STATE(156),
    [sym__inline_element] = STATE(574),
    [aux_sym__inline] = STATE(79),
    [sym__strikethrough] = STATE(574),
    [sym__emphasis_star] = STATE(573),
    [sym__strong_emphasis_star] = STATE(574),
    [sym__emphasis_underscore] = STATE(573),
    [sym__strong_emphasis_underscore] = STATE(574),
    [aux_sym__inline_base_repeat1] = STATE(156),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1144),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [61] = {
    [sym_backslash_escape] = STATE(156),
    [sym_code_span] = STATE(156),
    [sym_latex_block] = STATE(156),
    [sym__link_text] = STATE(1125),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(574),
    [sym_full_reference_link] = STATE(574),
    [sym_collapsed_reference_link] = STATE(574),
    [sym_inline_link] = STATE(574),
    [sym_image] = STATE(156),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(537),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(156),
    [sym__whitespace] = STATE(156),
    [sym__word] = STATE(156),
    [sym__soft_line_break] = STATE(156),
    [sym__inline_base] = STATE(574),
    [sym__text_base] = STATE(156),
    [sym__inline_element] = STATE(574),
    [aux_sym__inline] = STATE(68),
    [sym__strikethrough] = STATE(574),
    [sym__emphasis_star] = STATE(573),
    [sym__strong_emphasis_star] = STATE(574),
    [sym__emphasis_underscore] = STATE(573),
    [sym__strong_emphasis_underscore] = STATE(574),
    [aux_sym__inline_base_repeat1] = STATE(156),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1108),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [62] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(346),
    [sym_shortcut_link] = STATE(39),
    [sym_full_reference_link] = STATE(39),
    [sym_collapsed_reference_link] = STATE(39),
    [sym_inline_link] = STATE(39),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(348),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(39),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(39),
    [aux_sym__inline_no_star] = STATE(39),
    [sym__strikethrough] = STATE(39),
    [sym__emphasis_star] = STATE(281),
    [sym__strong_emphasis_star] = STATE(39),
    [sym__emphasis_underscore] = STATE(281),
    [sym__strong_emphasis_underscore] = STATE(39),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(732),
    [sym_numeric_character_reference] = ACTIONS(732),
    [anon_sym_LBRACK] = ACTIONS(734),
    [anon_sym_RBRACK] = ACTIONS(736),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(742),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(732),
    [sym_email_autolink] = ACTIONS(732),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(750),
    [anon_sym_LT_QMARK] = ACTIONS(752),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(756),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(732),
    [sym__digits] = ACTIONS(732),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(764),
    [sym__emphasis_open_underscore] = ACTIONS(766),
    [sym__strikethrough_open] = ACTIONS(770),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(732),
  },
  [63] = {
    [sym_backslash_escape] = STATE(156),
    [sym_code_span] = STATE(156),
    [sym_latex_block] = STATE(156),
    [sym__link_text] = STATE(1125),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(574),
    [sym_full_reference_link] = STATE(574),
    [sym_collapsed_reference_link] = STATE(574),
    [sym_inline_link] = STATE(574),
    [sym_image] = STATE(156),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(537),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(156),
    [sym__whitespace] = STATE(156),
    [sym__word] = STATE(156),
    [sym__soft_line_break] = STATE(156),
    [sym__inline_base] = STATE(574),
    [sym__text_base] = STATE(156),
    [sym__inline_element] = STATE(574),
    [aux_sym__inline] = STATE(85),
    [sym__strikethrough] = STATE(574),
    [sym__emphasis_star] = STATE(573),
    [sym__strong_emphasis_star] = STATE(574),
    [sym__emphasis_underscore] = STATE(573),
    [sym__strong_emphasis_underscore] = STATE(574),
    [aux_sym__inline_base_repeat1] = STATE(156),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1108),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [64] = {
    [sym_backslash_escape] = STATE(151),
    [sym_code_span] = STATE(151),
    [sym_latex_block] = STATE(151),
    [sym__link_text] = STATE(1124),
    [sym__link_text_non_empty] = STATE(513),
    [sym_shortcut_link] = STATE(26),
    [sym_full_reference_link] = STATE(26),
    [sym_collapsed_reference_link] = STATE(26),
    [sym_inline_link] = STATE(26),
    [sym_image] = STATE(151),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(515),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(151),
    [sym__whitespace] = STATE(151),
    [sym__word] = STATE(151),
    [sym__soft_line_break] = STATE(151),
    [sym__inline_base] = STATE(26),
    [sym__text_base] = STATE(151),
    [sym__inline_element_no_tilde] = STATE(26),
    [aux_sym__inline_no_tilde] = STATE(26),
    [sym__strikethrough] = STATE(26),
    [sym__emphasis_star] = STATE(285),
    [sym__strong_emphasis_star] = STATE(26),
    [sym__emphasis_underscore] = STATE(285),
    [sym__strong_emphasis_underscore] = STATE(26),
    [aux_sym__inline_base_repeat1] = STATE(151),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__strikethrough_open] = ACTIONS(678),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [65] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(24),
    [sym_full_reference_link] = STATE(24),
    [sym_collapsed_reference_link] = STATE(24),
    [sym_inline_link] = STATE(24),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(24),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(24),
    [aux_sym__inline_no_underscore] = STATE(24),
    [sym__strikethrough] = STATE(24),
    [sym__emphasis_star] = STATE(282),
    [sym__strong_emphasis_star] = STATE(24),
    [sym__emphasis_underscore] = STATE(282),
    [sym__strong_emphasis_underscore] = STATE(24),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(688),
    [sym_numeric_character_reference] = ACTIONS(688),
    [anon_sym_LBRACK] = ACTIONS(690),
    [anon_sym_RBRACK] = ACTIONS(692),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(698),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(688),
    [sym_email_autolink] = ACTIONS(688),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(706),
    [anon_sym_LT_QMARK] = ACTIONS(708),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(712),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(688),
    [sym__digits] = ACTIONS(688),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(720),
    [sym__emphasis_open_underscore] = ACTIONS(722),
    [sym__strikethrough_open] = ACTIONS(726),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(688),
  },
  [66] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(346),
    [sym_shortcut_link] = STATE(23),
    [sym_full_reference_link] = STATE(23),
    [sym_collapsed_reference_link] = STATE(23),
    [sym_inline_link] = STATE(23),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(348),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(23),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(23),
    [aux_sym__inline_no_star] = STATE(23),
    [sym__strikethrough] = STATE(23),
    [sym__emphasis_star] = STATE(281),
    [sym__strong_emphasis_star] = STATE(23),
    [sym__emphasis_underscore] = STATE(281),
    [sym__strong_emphasis_underscore] = STATE(23),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(732),
    [sym_numeric_character_reference] = ACTIONS(732),
    [anon_sym_LBRACK] = ACTIONS(734),
    [anon_sym_RBRACK] = ACTIONS(736),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(742),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(732),
    [sym_email_autolink] = ACTIONS(732),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(750),
    [anon_sym_LT_QMARK] = ACTIONS(752),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(756),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(732),
    [sym__digits] = ACTIONS(732),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(764),
    [sym__emphasis_open_underscore] = ACTIONS(766),
    [sym__strikethrough_open] = ACTIONS(770),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(732),
  },
  [67] = {
    [sym_backslash_escape] = STATE(156),
    [sym_code_span] = STATE(156),
    [sym_latex_block] = STATE(156),
    [sym__link_text] = STATE(1125),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(574),
    [sym_full_reference_link] = STATE(574),
    [sym_collapsed_reference_link] = STATE(574),
    [sym_inline_link] = STATE(574),
    [sym_image] = STATE(156),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(537),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(156),
    [sym__whitespace] = STATE(156),
    [sym__word] = STATE(156),
    [sym__soft_line_break] = STATE(156),
    [sym__inline_base] = STATE(574),
    [sym__text_base] = STATE(156),
    [sym__inline_element] = STATE(574),
    [aux_sym__inline] = STATE(79),
    [sym__strikethrough] = STATE(574),
    [sym__emphasis_star] = STATE(573),
    [sym__strong_emphasis_star] = STATE(574),
    [sym__emphasis_underscore] = STATE(573),
    [sym__strong_emphasis_underscore] = STATE(574),
    [aux_sym__inline_base_repeat1] = STATE(156),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1146),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [68] = {
    [sym_backslash_escape] = STATE(156),
    [sym_code_span] = STATE(156),
    [sym_latex_block] = STATE(156),
    [sym__link_text] = STATE(1125),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(574),
    [sym_full_reference_link] = STATE(574),
    [sym_collapsed_reference_link] = STATE(574),
    [sym_inline_link] = STATE(574),
    [sym_image] = STATE(156),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(537),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(156),
    [sym__whitespace] = STATE(156),
    [sym__word] = STATE(156),
    [sym__soft_line_break] = STATE(156),
    [sym__inline_base] = STATE(574),
    [sym__text_base] = STATE(156),
    [sym__inline_element] = STATE(574),
    [aux_sym__inline] = STATE(79),
    [sym__strikethrough] = STATE(574),
    [sym__emphasis_star] = STATE(573),
    [sym__strong_emphasis_star] = STATE(574),
    [sym__emphasis_underscore] = STATE(573),
    [sym__strong_emphasis_underscore] = STATE(574),
    [aux_sym__inline_base_repeat1] = STATE(156),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1148),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [69] = {
    [sym_backslash_escape] = STATE(156),
    [sym_code_span] = STATE(156),
    [sym_latex_block] = STATE(156),
    [sym__link_text] = STATE(1125),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(574),
    [sym_full_reference_link] = STATE(574),
    [sym_collapsed_reference_link] = STATE(574),
    [sym_inline_link] = STATE(574),
    [sym_image] = STATE(156),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(537),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(156),
    [sym__whitespace] = STATE(156),
    [sym__word] = STATE(156),
    [sym__soft_line_break] = STATE(156),
    [sym__inline_base] = STATE(574),
    [sym__text_base] = STATE(156),
    [sym__inline_element] = STATE(574),
    [aux_sym__inline] = STATE(67),
    [sym__strikethrough] = STATE(574),
    [sym__emphasis_star] = STATE(573),
    [sym__strong_emphasis_star] = STATE(574),
    [sym__emphasis_underscore] = STATE(573),
    [sym__strong_emphasis_underscore] = STATE(574),
    [aux_sym__inline_base_repeat1] = STATE(156),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1108),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [70] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(346),
    [sym_shortcut_link] = STATE(22),
    [sym_full_reference_link] = STATE(22),
    [sym_collapsed_reference_link] = STATE(22),
    [sym_inline_link] = STATE(22),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(348),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(22),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(22),
    [aux_sym__inline_no_star] = STATE(22),
    [sym__strikethrough] = STATE(22),
    [sym__emphasis_star] = STATE(281),
    [sym__strong_emphasis_star] = STATE(22),
    [sym__emphasis_underscore] = STATE(281),
    [sym__strong_emphasis_underscore] = STATE(22),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(732),
    [sym_numeric_character_reference] = ACTIONS(732),
    [anon_sym_LBRACK] = ACTIONS(734),
    [anon_sym_RBRACK] = ACTIONS(736),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(742),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(732),
    [sym_email_autolink] = ACTIONS(732),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(750),
    [anon_sym_LT_QMARK] = ACTIONS(752),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(756),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(732),
    [sym__digits] = ACTIONS(732),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(764),
    [sym__emphasis_open_underscore] = ACTIONS(766),
    [sym__strikethrough_open] = ACTIONS(770),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(732),
  },
  [71] = {
    [sym_backslash_escape] = STATE(156),
    [sym_code_span] = STATE(156),
    [sym_latex_block] = STATE(156),
    [sym__link_text] = STATE(1125),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(574),
    [sym_full_reference_link] = STATE(574),
    [sym_collapsed_reference_link] = STATE(574),
    [sym_inline_link] = STATE(574),
    [sym_image] = STATE(156),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(537),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(156),
    [sym__whitespace] = STATE(156),
    [sym__word] = STATE(156),
    [sym__soft_line_break] = STATE(156),
    [sym__inline_base] = STATE(574),
    [sym__text_base] = STATE(156),
    [sym__inline_element] = STATE(574),
    [aux_sym__inline] = STATE(79),
    [sym__strikethrough] = STATE(574),
    [sym__emphasis_star] = STATE(573),
    [sym__strong_emphasis_star] = STATE(574),
    [sym__emphasis_underscore] = STATE(573),
    [sym__strong_emphasis_underscore] = STATE(574),
    [aux_sym__inline_base_repeat1] = STATE(156),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1150),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [72] = {
    [sym_backslash_escape] = STATE(156),
    [sym_code_span] = STATE(156),
    [sym_latex_block] = STATE(156),
    [sym__link_text] = STATE(1125),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(574),
    [sym_full_reference_link] = STATE(574),
    [sym_collapsed_reference_link] = STATE(574),
    [sym_inline_link] = STATE(574),
    [sym_image] = STATE(156),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(537),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(156),
    [sym__whitespace] = STATE(156),
    [sym__word] = STATE(156),
    [sym__soft_line_break] = STATE(156),
    [sym__inline_base] = STATE(574),
    [sym__text_base] = STATE(156),
    [sym__inline_element] = STATE(574),
    [aux_sym__inline] = STATE(78),
    [sym__strikethrough] = STATE(574),
    [sym__emphasis_star] = STATE(573),
    [sym__strong_emphasis_star] = STATE(574),
    [sym__emphasis_underscore] = STATE(573),
    [sym__strong_emphasis_underscore] = STATE(574),
    [aux_sym__inline_base_repeat1] = STATE(156),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1108),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [73] = {
    [sym_backslash_escape] = STATE(156),
    [sym_code_span] = STATE(156),
    [sym_latex_block] = STATE(156),
    [sym__link_text] = STATE(1125),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(574),
    [sym_full_reference_link] = STATE(574),
    [sym_collapsed_reference_link] = STATE(574),
    [sym_inline_link] = STATE(574),
    [sym_image] = STATE(156),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(537),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(156),
    [sym__whitespace] = STATE(156),
    [sym__word] = STATE(156),
    [sym__soft_line_break] = STATE(156),
    [sym__inline_base] = STATE(574),
    [sym__text_base] = STATE(156),
    [sym__inline_element] = STATE(574),
    [aux_sym__inline] = STATE(79),
    [sym__strikethrough] = STATE(574),
    [sym__emphasis_star] = STATE(573),
    [sym__strong_emphasis_star] = STATE(574),
    [sym__emphasis_underscore] = STATE(573),
    [sym__strong_emphasis_underscore] = STATE(574),
    [aux_sym__inline_base_repeat1] = STATE(156),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1152),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [74] = {
    [sym_backslash_escape] = STATE(151),
    [sym_code_span] = STATE(151),
    [sym_latex_block] = STATE(151),
    [sym__link_text] = STATE(1124),
    [sym__link_text_non_empty] = STATE(513),
    [sym_shortcut_link] = STATE(16),
    [sym_full_reference_link] = STATE(16),
    [sym_collapsed_reference_link] = STATE(16),
    [sym_inline_link] = STATE(16),
    [sym_image] = STATE(151),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(515),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(151),
    [sym__whitespace] = STATE(151),
    [sym__word] = STATE(151),
    [sym__soft_line_break] = STATE(151),
    [sym__inline_base] = STATE(16),
    [sym__text_base] = STATE(151),
    [sym__inline_element_no_tilde] = STATE(16),
    [aux_sym__inline_no_tilde] = STATE(16),
    [sym__strikethrough] = STATE(16),
    [sym__emphasis_star] = STATE(285),
    [sym__strong_emphasis_star] = STATE(16),
    [sym__emphasis_underscore] = STATE(285),
    [sym__strong_emphasis_underscore] = STATE(16),
    [aux_sym__inline_base_repeat1] = STATE(151),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__strikethrough_open] = ACTIONS(678),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [75] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(13),
    [sym_full_reference_link] = STATE(13),
    [sym_collapsed_reference_link] = STATE(13),
    [sym_inline_link] = STATE(13),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(13),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(13),
    [aux_sym__inline_no_underscore] = STATE(13),
    [sym__strikethrough] = STATE(13),
    [sym__emphasis_star] = STATE(282),
    [sym__strong_emphasis_star] = STATE(13),
    [sym__emphasis_underscore] = STATE(282),
    [sym__strong_emphasis_underscore] = STATE(13),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(688),
    [sym_numeric_character_reference] = ACTIONS(688),
    [anon_sym_LBRACK] = ACTIONS(690),
    [anon_sym_RBRACK] = ACTIONS(692),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(698),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(688),
    [sym_email_autolink] = ACTIONS(688),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(706),
    [anon_sym_LT_QMARK] = ACTIONS(708),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(712),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(688),
    [sym__digits] = ACTIONS(688),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(720),
    [sym__emphasis_open_underscore] = ACTIONS(722),
    [sym__strikethrough_open] = ACTIONS(726),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(688),
  },
  [76] = {
    [sym_backslash_escape] = STATE(149),
    [sym_code_span] = STATE(149),
    [sym_latex_block] = STATE(149),
    [sym__link_text] = STATE(1116),
    [sym__link_text_non_empty] = STATE(346),
    [sym_shortcut_link] = STATE(32),
    [sym_full_reference_link] = STATE(32),
    [sym_collapsed_reference_link] = STATE(32),
    [sym_inline_link] = STATE(32),
    [sym_image] = STATE(149),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(348),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(149),
    [sym__whitespace] = STATE(149),
    [sym__word] = STATE(149),
    [sym__soft_line_break] = STATE(149),
    [sym__inline_base] = STATE(32),
    [sym__text_base] = STATE(149),
    [sym__inline_element_no_star] = STATE(32),
    [aux_sym__inline_no_star] = STATE(32),
    [sym__strikethrough] = STATE(32),
    [sym__emphasis_star] = STATE(281),
    [sym__strong_emphasis_star] = STATE(32),
    [sym__emphasis_underscore] = STATE(281),
    [sym__strong_emphasis_underscore] = STATE(32),
    [aux_sym__inline_base_repeat1] = STATE(149),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(732),
    [sym_numeric_character_reference] = ACTIONS(732),
    [anon_sym_LBRACK] = ACTIONS(734),
    [anon_sym_RBRACK] = ACTIONS(736),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(742),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(732),
    [sym_email_autolink] = ACTIONS(732),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(750),
    [anon_sym_LT_QMARK] = ACTIONS(752),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(756),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(732),
    [sym__digits] = ACTIONS(732),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(764),
    [sym__emphasis_open_underscore] = ACTIONS(766),
    [sym__strikethrough_open] = ACTIONS(770),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(732),
  },
  [77] = {
    [sym_backslash_escape] = STATE(156),
    [sym_code_span] = STATE(156),
    [sym_latex_block] = STATE(156),
    [sym__link_text] = STATE(1125),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(574),
    [sym_full_reference_link] = STATE(574),
    [sym_collapsed_reference_link] = STATE(574),
    [sym_inline_link] = STATE(574),
    [sym_image] = STATE(156),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(537),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(156),
    [sym__whitespace] = STATE(156),
    [sym__word] = STATE(156),
    [sym__soft_line_break] = STATE(156),
    [sym__inline_base] = STATE(574),
    [sym__text_base] = STATE(156),
    [sym__inline_element] = STATE(574),
    [aux_sym__inline] = STATE(60),
    [sym__strikethrough] = STATE(574),
    [sym__emphasis_star] = STATE(573),
    [sym__strong_emphasis_star] = STATE(574),
    [sym__emphasis_underscore] = STATE(573),
    [sym__strong_emphasis_underscore] = STATE(574),
    [aux_sym__inline_base_repeat1] = STATE(156),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1108),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [78] = {
    [sym_backslash_escape] = STATE(156),
    [sym_code_span] = STATE(156),
    [sym_latex_block] = STATE(156),
    [sym__link_text] = STATE(1125),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(574),
    [sym_full_reference_link] = STATE(574),
    [sym_collapsed_reference_link] = STATE(574),
    [sym_inline_link] = STATE(574),
    [sym_image] = STATE(156),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(537),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(156),
    [sym__whitespace] = STATE(156),
    [sym__word] = STATE(156),
    [sym__soft_line_break] = STATE(156),
    [sym__inline_base] = STATE(574),
    [sym__text_base] = STATE(156),
    [sym__inline_element] = STATE(574),
    [aux_sym__inline] = STATE(79),
    [sym__strikethrough] = STATE(574),
    [sym__emphasis_star] = STATE(573),
    [sym__strong_emphasis_star] = STATE(574),
    [sym__emphasis_underscore] = STATE(573),
    [sym__strong_emphasis_underscore] = STATE(574),
    [aux_sym__inline_base_repeat1] = STATE(156),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1154),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [79] = {
    [sym_backslash_escape] = STATE(156),
    [sym_code_span] = STATE(156),
    [sym_latex_block] = STATE(156),
    [sym__link_text] = STATE(1125),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(574),
    [sym_full_reference_link] = STATE(574),
    [sym_collapsed_reference_link] = STATE(574),
    [sym_inline_link] = STATE(574),
    [sym_image] = STATE(156),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(537),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(156),
    [sym__whitespace] = STATE(156),
    [sym__word] = STATE(156),
    [sym__soft_line_break] = STATE(156),
    [sym__inline_base] = STATE(574),
    [sym__text_base] = STATE(156),
    [sym__inline_element] = STATE(574),
    [aux_sym__inline] = STATE(79),
    [sym__strikethrough] = STATE(574),
    [sym__emphasis_star] = STATE(573),
    [sym__strong_emphasis_star] = STATE(574),
    [sym__emphasis_underscore] = STATE(573),
    [sym__strong_emphasis_underscore] = STATE(574),
    [aux_sym__inline_base_repeat1] = STATE(156),
    [sym__backslash_escape] = ACTIONS(1156),
    [sym_entity_reference] = ACTIONS(1159),
    [sym_numeric_character_reference] = ACTIONS(1159),
    [anon_sym_LBRACK] = ACTIONS(1162),
    [anon_sym_RBRACK] = ACTIONS(1165),
    [anon_sym_LT] = ACTIONS(1168),
    [anon_sym_GT] = ACTIONS(1171),
    [anon_sym_BANG] = ACTIONS(1174),
    [anon_sym_DQUOTE] = ACTIONS(1171),
    [anon_sym_POUND] = ACTIONS(1171),
    [anon_sym_DOLLAR] = ACTIONS(1171),
    [anon_sym_PERCENT] = ACTIONS(1171),
    [anon_sym_AMP] = ACTIONS(1177),
    [anon_sym_SQUOTE] = ACTIONS(1171),
    [anon_sym_STAR] = ACTIONS(1171),
    [anon_sym_PLUS] = ACTIONS(1171),
    [anon_sym_COMMA] = ACTIONS(1171),
    [anon_sym_DASH] = ACTIONS(1171),
    [anon_sym_DOT] = ACTIONS(1171),
    [anon_sym_SLASH] = ACTIONS(1171),
    [anon_sym_COLON] = ACTIONS(1171),
    [anon_sym_SEMI] = ACTIONS(1171),
    [anon_sym_EQ] = ACTIONS(1171),
    [anon_sym_QMARK] = ACTIONS(1171),
    [anon_sym_AT] = ACTIONS(1171),
    [anon_sym_BSLASH] = ACTIONS(1180),
    [anon_sym_CARET] = ACTIONS(1171),
    [anon_sym__] = ACTIONS(1171),
    [anon_sym_BQUOTE] = ACTIONS(1171),
    [anon_sym_LBRACE] = ACTIONS(1171),
    [anon_sym_PIPE] = ACTIONS(1171),
    [anon_sym_RBRACE] = ACTIONS(1171),
    [anon_sym_TILDE] = ACTIONS(1171),
    [anon_sym_LPAREN] = ACTIONS(1171),
    [anon_sym_RPAREN] = ACTIONS(1171),
    [sym__newline_token] = ACTIONS(1183),
    [sym_uri_autolink] = ACTIONS(1159),
    [sym_email_autolink] = ACTIONS(1159),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1186),
    [anon_sym_LT_QMARK] = ACTIONS(1189),
    [aux_sym__declaration_token1] = ACTIONS(1192),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1195),
    [sym__whitespace_ge_2] = ACTIONS(1198),
    [aux_sym__whitespace_token1] = ACTIONS(1201),
    [sym__word_no_digit] = ACTIONS(1159),
    [sym__digits] = ACTIONS(1159),
    [sym__code_span_start] = ACTIONS(1204),
    [sym__emphasis_open_star] = ACTIONS(1207),
    [sym__emphasis_open_underscore] = ACTIONS(1210),
    [sym__strikethrough_open] = ACTIONS(1213),
    [sym__latex_span_start] = ACTIONS(1216),
    [sym__unclosed_span] = ACTIONS(1159),
  },
  [80] = {
    [sym_backslash_escape] = STATE(153),
    [sym_code_span] = STATE(153),
    [sym_latex_block] = STATE(153),
    [sym__link_text] = STATE(1120),
    [sym__link_text_non_empty] = STATE(433),
    [sym_shortcut_link] = STATE(37),
    [sym_full_reference_link] = STATE(37),
    [sym_collapsed_reference_link] = STATE(37),
    [sym_inline_link] = STATE(37),
    [sym_image] = STATE(153),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(153),
    [sym__whitespace] = STATE(153),
    [sym__word] = STATE(153),
    [sym__soft_line_break] = STATE(153),
    [sym__inline_base] = STATE(37),
    [sym__text_base] = STATE(153),
    [sym__inline_element_no_underscore] = STATE(37),
    [aux_sym__inline_no_underscore] = STATE(37),
    [sym__strikethrough] = STATE(37),
    [sym__emphasis_star] = STATE(282),
    [sym__strong_emphasis_star] = STATE(37),
    [sym__emphasis_underscore] = STATE(282),
    [sym__strong_emphasis_underscore] = STATE(37),
    [aux_sym__inline_base_repeat1] = STATE(153),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(688),
    [sym_numeric_character_reference] = ACTIONS(688),
    [anon_sym_LBRACK] = ACTIONS(690),
    [anon_sym_RBRACK] = ACTIONS(692),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(698),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(688),
    [sym_email_autolink] = ACTIONS(688),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(706),
    [anon_sym_LT_QMARK] = ACTIONS(708),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(712),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(688),
    [sym__digits] = ACTIONS(688),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(720),
    [sym__emphasis_open_underscore] = ACTIONS(722),
    [sym__strikethrough_open] = ACTIONS(726),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(688),
  },
  [81] = {
    [sym_backslash_escape] = STATE(156),
    [sym_code_span] = STATE(156),
    [sym_latex_block] = STATE(156),
    [sym__link_text] = STATE(1125),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(574),
    [sym_full_reference_link] = STATE(574),
    [sym_collapsed_reference_link] = STATE(574),
    [sym_inline_link] = STATE(574),
    [sym_image] = STATE(156),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(537),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(156),
    [sym__whitespace] = STATE(156),
    [sym__word] = STATE(156),
    [sym__soft_line_break] = STATE(156),
    [sym__inline_base] = STATE(574),
    [sym__text_base] = STATE(156),
    [sym__inline_element] = STATE(574),
    [aux_sym__inline] = STATE(82),
    [sym__strikethrough] = STATE(574),
    [sym__emphasis_star] = STATE(573),
    [sym__strong_emphasis_star] = STATE(574),
    [sym__emphasis_underscore] = STATE(573),
    [sym__strong_emphasis_underscore] = STATE(574),
    [aux_sym__inline_base_repeat1] = STATE(156),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1108),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [82] = {
    [sym_backslash_escape] = STATE(156),
    [sym_code_span] = STATE(156),
    [sym_latex_block] = STATE(156),
    [sym__link_text] = STATE(1125),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(574),
    [sym_full_reference_link] = STATE(574),
    [sym_collapsed_reference_link] = STATE(574),
    [sym_inline_link] = STATE(574),
    [sym_image] = STATE(156),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(537),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(156),
    [sym__whitespace] = STATE(156),
    [sym__word] = STATE(156),
    [sym__soft_line_break] = STATE(156),
    [sym__inline_base] = STATE(574),
    [sym__text_base] = STATE(156),
    [sym__inline_element] = STATE(574),
    [aux_sym__inline] = STATE(79),
    [sym__strikethrough] = STATE(574),
    [sym__emphasis_star] = STATE(573),
    [sym__strong_emphasis_star] = STATE(574),
    [sym__emphasis_underscore] = STATE(573),
    [sym__strong_emphasis_underscore] = STATE(574),
    [aux_sym__inline_base_repeat1] = STATE(156),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1219),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [83] = {
    [sym_backslash_escape] = STATE(151),
    [sym_code_span] = STATE(151),
    [sym_latex_block] = STATE(151),
    [sym__link_text] = STATE(1124),
    [sym__link_text_non_empty] = STATE(513),
    [sym_shortcut_link] = STATE(47),
    [sym_full_reference_link] = STATE(47),
    [sym_collapsed_reference_link] = STATE(47),
    [sym_inline_link] = STATE(47),
    [sym_image] = STATE(151),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(515),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(151),
    [sym__whitespace] = STATE(151),
    [sym__word] = STATE(151),
    [sym__soft_line_break] = STATE(151),
    [sym__inline_base] = STATE(47),
    [sym__text_base] = STATE(151),
    [sym__inline_element_no_tilde] = STATE(47),
    [aux_sym__inline_no_tilde] = STATE(47),
    [sym__strikethrough] = STATE(47),
    [sym__emphasis_star] = STATE(285),
    [sym__strong_emphasis_star] = STATE(47),
    [sym__emphasis_underscore] = STATE(285),
    [sym__strong_emphasis_underscore] = STATE(47),
    [aux_sym__inline_base_repeat1] = STATE(151),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(642),
    [sym_numeric_character_reference] = ACTIONS(642),
    [anon_sym_LBRACK] = ACTIONS(644),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(642),
    [sym_email_autolink] = ACTIONS(642),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(642),
    [sym__digits] = ACTIONS(642),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(674),
    [sym__emphasis_open_underscore] = ACTIONS(676),
    [sym__strikethrough_open] = ACTIONS(678),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(642),
  },
  [84] = {
    [sym_backslash_escape] = STATE(156),
    [sym_code_span] = STATE(156),
    [sym_latex_block] = STATE(156),
    [sym__link_text] = STATE(1125),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(574),
    [sym_full_reference_link] = STATE(574),
    [sym_collapsed_reference_link] = STATE(574),
    [sym_inline_link] = STATE(574),
    [sym_image] = STATE(156),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(537),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(156),
    [sym__whitespace] = STATE(156),
    [sym__word] = STATE(156),
    [sym__soft_line_break] = STATE(156),
    [sym__inline_base] = STATE(574),
    [sym__text_base] = STATE(156),
    [sym__inline_element] = STATE(574),
    [aux_sym__inline] = STATE(71),
    [sym__strikethrough] = STATE(574),
    [sym__emphasis_star] = STATE(573),
    [sym__strong_emphasis_star] = STATE(574),
    [sym__emphasis_underscore] = STATE(573),
    [sym__strong_emphasis_underscore] = STATE(574),
    [aux_sym__inline_base_repeat1] = STATE(156),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1108),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [85] = {
    [sym_backslash_escape] = STATE(156),
    [sym_code_span] = STATE(156),
    [sym_latex_block] = STATE(156),
    [sym__link_text] = STATE(1125),
    [sym__link_text_non_empty] = STATE(592),
    [sym_shortcut_link] = STATE(574),
    [sym_full_reference_link] = STATE(574),
    [sym_collapsed_reference_link] = STATE(574),
    [sym_inline_link] = STATE(574),
    [sym_image] = STATE(156),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(537),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(156),
    [sym__whitespace] = STATE(156),
    [sym__word] = STATE(156),
    [sym__soft_line_break] = STATE(156),
    [sym__inline_base] = STATE(574),
    [sym__text_base] = STATE(156),
    [sym__inline_element] = STATE(574),
    [aux_sym__inline] = STATE(79),
    [sym__strikethrough] = STATE(574),
    [sym__emphasis_star] = STATE(573),
    [sym__strong_emphasis_star] = STATE(574),
    [sym__emphasis_underscore] = STATE(573),
    [sym__strong_emphasis_underscore] = STATE(574),
    [aux_sym__inline_base_repeat1] = STATE(156),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(1104),
    [sym_numeric_character_reference] = ACTIONS(1104),
    [anon_sym_LBRACK] = ACTIONS(1106),
    [anon_sym_RBRACK] = ACTIONS(1221),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(1104),
    [sym_email_autolink] = ACTIONS(1104),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(1104),
    [sym__digits] = ACTIONS(1104),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(1136),
    [sym__emphasis_open_underscore] = ACTIONS(1138),
    [sym__strikethrough_open] = ACTIONS(1140),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(1104),
  },
  [86] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(615),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_link] = STATE(615),
    [aux_sym__inline_no_link] = STATE(104),
    [sym__strikethrough_no_link] = STATE(615),
    [sym__emphasis_star_no_link] = STATE(616),
    [sym__strong_emphasis_star_no_link] = STATE(615),
    [sym__emphasis_underscore_no_link] = STATE(616),
    [sym__strong_emphasis_underscore_no_link] = STATE(615),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(1223),
    [sym_entity_reference] = ACTIONS(1226),
    [sym_numeric_character_reference] = ACTIONS(1226),
    [anon_sym_LBRACK] = ACTIONS(565),
    [anon_sym_RBRACK] = ACTIONS(1229),
    [anon_sym_LT] = ACTIONS(1232),
    [anon_sym_GT] = ACTIONS(1235),
    [anon_sym_BANG] = ACTIONS(1238),
    [anon_sym_DQUOTE] = ACTIONS(1235),
    [anon_sym_POUND] = ACTIONS(1235),
    [anon_sym_DOLLAR] = ACTIONS(1235),
    [anon_sym_PERCENT] = ACTIONS(1235),
    [anon_sym_AMP] = ACTIONS(1241),
    [anon_sym_SQUOTE] = ACTIONS(1235),
    [anon_sym_STAR] = ACTIONS(1235),
    [anon_sym_PLUS] = ACTIONS(1235),
    [anon_sym_COMMA] = ACTIONS(1235),
    [anon_sym_DASH] = ACTIONS(1235),
    [anon_sym_DOT] = ACTIONS(1235),
    [anon_sym_SLASH] = ACTIONS(1235),
    [anon_sym_COLON] = ACTIONS(1235),
    [anon_sym_SEMI] = ACTIONS(1235),
    [anon_sym_EQ] = ACTIONS(1235),
    [anon_sym_QMARK] = ACTIONS(1235),
    [anon_sym_AT] = ACTIONS(1235),
    [anon_sym_BSLASH] = ACTIONS(1244),
    [anon_sym_CARET] = ACTIONS(1235),
    [anon_sym__] = ACTIONS(1235),
    [anon_sym_BQUOTE] = ACTIONS(1235),
    [anon_sym_LBRACE] = ACTIONS(1235),
    [anon_sym_PIPE] = ACTIONS(1235),
    [anon_sym_RBRACE] = ACTIONS(1235),
    [anon_sym_TILDE] = ACTIONS(1235),
    [anon_sym_LPAREN] = ACTIONS(1235),
    [anon_sym_RPAREN] = ACTIONS(1235),
    [sym__newline_token] = ACTIONS(1247),
    [sym_uri_autolink] = ACTIONS(1226),
    [sym_email_autolink] = ACTIONS(1226),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1250),
    [anon_sym_LT_QMARK] = ACTIONS(1253),
    [aux_sym__declaration_token1] = ACTIONS(1256),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1259),
    [sym__whitespace_ge_2] = ACTIONS(1262),
    [aux_sym__whitespace_token1] = ACTIONS(1265),
    [sym__word_no_digit] = ACTIONS(1226),
    [sym__digits] = ACTIONS(1226),
    [sym__code_span_start] = ACTIONS(1268),
    [sym__emphasis_open_star] = ACTIONS(1271),
    [sym__emphasis_open_underscore] = ACTIONS(1274),
    [sym__emphasis_close_star] = ACTIONS(565),
    [sym__last_token_punctuation] = ACTIONS(1277),
    [sym__strikethrough_open] = ACTIONS(1279),
    [sym__latex_span_start] = ACTIONS(1282),
    [sym__unclosed_span] = ACTIONS(1226),
  },
  [87] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(615),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_link] = STATE(615),
    [aux_sym__inline_no_link] = STATE(134),
    [sym__strikethrough_no_link] = STATE(615),
    [sym__emphasis_star_no_link] = STATE(616),
    [sym__strong_emphasis_star_no_link] = STATE(615),
    [sym__emphasis_underscore_no_link] = STATE(616),
    [sym__strong_emphasis_underscore_no_link] = STATE(615),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [ts_builtin_sym_end] = ACTIONS(114),
    [sym__backslash_escape] = ACTIONS(1285),
    [sym_entity_reference] = ACTIONS(1288),
    [sym_numeric_character_reference] = ACTIONS(1288),
    [anon_sym_LBRACK] = ACTIONS(114),
    [anon_sym_RBRACK] = ACTIONS(1291),
    [anon_sym_LT] = ACTIONS(1294),
    [anon_sym_GT] = ACTIONS(1297),
    [anon_sym_BANG] = ACTIONS(1300),
    [anon_sym_DQUOTE] = ACTIONS(1297),
    [anon_sym_POUND] = ACTIONS(1297),
    [anon_sym_DOLLAR] = ACTIONS(1297),
    [anon_sym_PERCENT] = ACTIONS(1297),
    [anon_sym_AMP] = ACTIONS(1303),
    [anon_sym_SQUOTE] = ACTIONS(1297),
    [anon_sym_STAR] = ACTIONS(1297),
    [anon_sym_PLUS] = ACTIONS(1297),
    [anon_sym_COMMA] = ACTIONS(1297),
    [anon_sym_DASH] = ACTIONS(1297),
    [anon_sym_DOT] = ACTIONS(1297),
    [anon_sym_SLASH] = ACTIONS(1297),
    [anon_sym_COLON] = ACTIONS(1297),
    [anon_sym_SEMI] = ACTIONS(1297),
    [anon_sym_EQ] = ACTIONS(1297),
    [anon_sym_QMARK] = ACTIONS(1297),
    [anon_sym_AT] = ACTIONS(1297),
    [anon_sym_BSLASH] = ACTIONS(1306),
    [anon_sym_CARET] = ACTIONS(1297),
    [anon_sym__] = ACTIONS(1297),
    [anon_sym_BQUOTE] = ACTIONS(1297),
    [anon_sym_LBRACE] = ACTIONS(1297),
    [anon_sym_PIPE] = ACTIONS(1297),
    [anon_sym_RBRACE] = ACTIONS(1297),
    [anon_sym_TILDE] = ACTIONS(1297),
    [anon_sym_LPAREN] = ACTIONS(1297),
    [anon_sym_RPAREN] = ACTIONS(1297),
    [sym__newline_token] = ACTIONS(1309),
    [sym_uri_autolink] = ACTIONS(1288),
    [sym_email_autolink] = ACTIONS(1288),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1312),
    [anon_sym_LT_QMARK] = ACTIONS(1315),
    [aux_sym__declaration_token1] = ACTIONS(1318),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1321),
    [sym__whitespace_ge_2] = ACTIONS(1324),
    [aux_sym__whitespace_token1] = ACTIONS(1327),
    [sym__word_no_digit] = ACTIONS(1288),
    [sym__digits] = ACTIONS(1288),
    [sym__code_span_start] = ACTIONS(1330),
    [sym__emphasis_open_star] = ACTIONS(1333),
    [sym__emphasis_open_underscore] = ACTIONS(1336),
    [sym__last_token_punctuation] = ACTIONS(1339),
    [sym__strikethrough_open] = ACTIONS(1341),
    [sym__latex_span_start] = ACTIONS(1344),
    [sym__unclosed_span] = ACTIONS(1288),
  },
  [88] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(615),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_link] = STATE(615),
    [aux_sym__inline_no_link] = STATE(124),
    [sym__strikethrough_no_link] = STATE(615),
    [sym__emphasis_star_no_link] = STATE(616),
    [sym__strong_emphasis_star_no_link] = STATE(615),
    [sym__emphasis_underscore_no_link] = STATE(616),
    [sym__strong_emphasis_underscore_no_link] = STATE(615),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(1347),
    [sym_entity_reference] = ACTIONS(1350),
    [sym_numeric_character_reference] = ACTIONS(1350),
    [anon_sym_LBRACK] = ACTIONS(433),
    [anon_sym_RBRACK] = ACTIONS(1353),
    [anon_sym_LT] = ACTIONS(1356),
    [anon_sym_GT] = ACTIONS(1359),
    [anon_sym_BANG] = ACTIONS(1362),
    [anon_sym_DQUOTE] = ACTIONS(1359),
    [anon_sym_POUND] = ACTIONS(1359),
    [anon_sym_DOLLAR] = ACTIONS(1359),
    [anon_sym_PERCENT] = ACTIONS(1359),
    [anon_sym_AMP] = ACTIONS(1365),
    [anon_sym_SQUOTE] = ACTIONS(1359),
    [anon_sym_STAR] = ACTIONS(1359),
    [anon_sym_PLUS] = ACTIONS(1359),
    [anon_sym_COMMA] = ACTIONS(1359),
    [anon_sym_DASH] = ACTIONS(1359),
    [anon_sym_DOT] = ACTIONS(1359),
    [anon_sym_SLASH] = ACTIONS(1359),
    [anon_sym_COLON] = ACTIONS(1359),
    [anon_sym_SEMI] = ACTIONS(1359),
    [anon_sym_EQ] = ACTIONS(1359),
    [anon_sym_QMARK] = ACTIONS(1359),
    [anon_sym_AT] = ACTIONS(1359),
    [anon_sym_BSLASH] = ACTIONS(1368),
    [anon_sym_CARET] = ACTIONS(1359),
    [anon_sym__] = ACTIONS(1359),
    [anon_sym_BQUOTE] = ACTIONS(1359),
    [anon_sym_LBRACE] = ACTIONS(1359),
    [anon_sym_PIPE] = ACTIONS(1359),
    [anon_sym_RBRACE] = ACTIONS(1359),
    [anon_sym_TILDE] = ACTIONS(1359),
    [anon_sym_LPAREN] = ACTIONS(1359),
    [anon_sym_RPAREN] = ACTIONS(1359),
    [sym__newline_token] = ACTIONS(1371),
    [sym_uri_autolink] = ACTIONS(1350),
    [sym_email_autolink] = ACTIONS(1350),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1374),
    [anon_sym_LT_QMARK] = ACTIONS(1377),
    [aux_sym__declaration_token1] = ACTIONS(1380),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1383),
    [sym__whitespace_ge_2] = ACTIONS(1386),
    [aux_sym__whitespace_token1] = ACTIONS(1389),
    [sym__word_no_digit] = ACTIONS(1350),
    [sym__digits] = ACTIONS(1350),
    [sym__code_span_start] = ACTIONS(1392),
    [sym__emphasis_open_star] = ACTIONS(1395),
    [sym__emphasis_open_underscore] = ACTIONS(1398),
    [sym__emphasis_close_underscore] = ACTIONS(433),
    [sym__last_token_punctuation] = ACTIONS(1401),
    [sym__strikethrough_open] = ACTIONS(1403),
    [sym__latex_span_start] = ACTIONS(1406),
    [sym__unclosed_span] = ACTIONS(1350),
  },
  [89] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(615),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_link] = STATE(615),
    [aux_sym__inline_no_link] = STATE(127),
    [sym__strikethrough_no_link] = STATE(615),
    [sym__emphasis_star_no_link] = STATE(616),
    [sym__strong_emphasis_star_no_link] = STATE(615),
    [sym__emphasis_underscore_no_link] = STATE(616),
    [sym__strong_emphasis_underscore_no_link] = STATE(615),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(1409),
    [sym_entity_reference] = ACTIONS(1412),
    [sym_numeric_character_reference] = ACTIONS(1412),
    [anon_sym_LBRACK] = ACTIONS(109),
    [anon_sym_RBRACK] = ACTIONS(1415),
    [anon_sym_LT] = ACTIONS(1418),
    [anon_sym_GT] = ACTIONS(1421),
    [anon_sym_BANG] = ACTIONS(1424),
    [anon_sym_DQUOTE] = ACTIONS(1421),
    [anon_sym_POUND] = ACTIONS(1421),
    [anon_sym_DOLLAR] = ACTIONS(1421),
    [anon_sym_PERCENT] = ACTIONS(1421),
    [anon_sym_AMP] = ACTIONS(1427),
    [anon_sym_SQUOTE] = ACTIONS(1421),
    [anon_sym_STAR] = ACTIONS(1421),
    [anon_sym_PLUS] = ACTIONS(1421),
    [anon_sym_COMMA] = ACTIONS(1421),
    [anon_sym_DASH] = ACTIONS(1421),
    [anon_sym_DOT] = ACTIONS(1421),
    [anon_sym_SLASH] = ACTIONS(1421),
    [anon_sym_COLON] = ACTIONS(1421),
    [anon_sym_SEMI] = ACTIONS(1421),
    [anon_sym_EQ] = ACTIONS(1421),
    [anon_sym_QMARK] = ACTIONS(1421),
    [anon_sym_AT] = ACTIONS(1421),
    [anon_sym_BSLASH] = ACTIONS(1430),
    [anon_sym_CARET] = ACTIONS(1421),
    [anon_sym__] = ACTIONS(1421),
    [anon_sym_BQUOTE] = ACTIONS(1421),
    [anon_sym_LBRACE] = ACTIONS(1421),
    [anon_sym_PIPE] = ACTIONS(1421),
    [anon_sym_RBRACE] = ACTIONS(1421),
    [anon_sym_TILDE] = ACTIONS(1421),
    [anon_sym_LPAREN] = ACTIONS(1421),
    [anon_sym_RPAREN] = ACTIONS(1421),
    [sym__newline_token] = ACTIONS(1433),
    [sym_uri_autolink] = ACTIONS(1412),
    [sym_email_autolink] = ACTIONS(1412),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1436),
    [anon_sym_LT_QMARK] = ACTIONS(1439),
    [aux_sym__declaration_token1] = ACTIONS(1442),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1445),
    [sym__whitespace_ge_2] = ACTIONS(1448),
    [aux_sym__whitespace_token1] = ACTIONS(1451),
    [sym__word_no_digit] = ACTIONS(1412),
    [sym__digits] = ACTIONS(1412),
    [sym__code_span_start] = ACTIONS(1454),
    [sym__emphasis_open_star] = ACTIONS(1457),
    [sym__emphasis_open_underscore] = ACTIONS(1460),
    [sym__last_token_punctuation] = ACTIONS(1463),
    [sym__strikethrough_open] = ACTIONS(1465),
    [sym__strikethrough_close] = ACTIONS(109),
    [sym__latex_span_start] = ACTIONS(1468),
    [sym__unclosed_span] = ACTIONS(1412),
  },
  [90] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(615),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_link] = STATE(615),
    [aux_sym__inline_no_link] = STATE(119),
    [sym__strikethrough_no_link] = STATE(615),
    [sym__emphasis_star_no_link] = STATE(616),
    [sym__strong_emphasis_star_no_link] = STATE(615),
    [sym__emphasis_underscore_no_link] = STATE(616),
    [sym__strong_emphasis_underscore_no_link] = STATE(615),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(1285),
    [sym_entity_reference] = ACTIONS(1288),
    [sym_numeric_character_reference] = ACTIONS(1288),
    [anon_sym_LBRACK] = ACTIONS(114),
    [anon_sym_RBRACK] = ACTIONS(1291),
    [anon_sym_LT] = ACTIONS(1294),
    [anon_sym_GT] = ACTIONS(1297),
    [anon_sym_BANG] = ACTIONS(1300),
    [anon_sym_DQUOTE] = ACTIONS(1297),
    [anon_sym_POUND] = ACTIONS(1297),
    [anon_sym_DOLLAR] = ACTIONS(1297),
    [anon_sym_PERCENT] = ACTIONS(1297),
    [anon_sym_AMP] = ACTIONS(1303),
    [anon_sym_SQUOTE] = ACTIONS(1297),
    [anon_sym_STAR] = ACTIONS(1297),
    [anon_sym_PLUS] = ACTIONS(1297),
    [anon_sym_COMMA] = ACTIONS(1297),
    [anon_sym_DASH] = ACTIONS(1297),
    [anon_sym_DOT] = ACTIONS(1297),
    [anon_sym_SLASH] = ACTIONS(1297),
    [anon_sym_COLON] = ACTIONS(1297),
    [anon_sym_SEMI] = ACTIONS(1297),
    [anon_sym_EQ] = ACTIONS(1297),
    [anon_sym_QMARK] = ACTIONS(1297),
    [anon_sym_AT] = ACTIONS(1297),
    [anon_sym_BSLASH] = ACTIONS(1306),
    [anon_sym_CARET] = ACTIONS(1297),
    [anon_sym__] = ACTIONS(1297),
    [anon_sym_BQUOTE] = ACTIONS(1297),
    [anon_sym_LBRACE] = ACTIONS(1297),
    [anon_sym_PIPE] = ACTIONS(1297),
    [anon_sym_RBRACE] = ACTIONS(1297),
    [anon_sym_TILDE] = ACTIONS(1297),
    [anon_sym_LPAREN] = ACTIONS(1297),
    [anon_sym_RPAREN] = ACTIONS(1297),
    [sym__newline_token] = ACTIONS(1309),
    [sym_uri_autolink] = ACTIONS(1288),
    [sym_email_autolink] = ACTIONS(1288),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1312),
    [anon_sym_LT_QMARK] = ACTIONS(1315),
    [aux_sym__declaration_token1] = ACTIONS(1318),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1321),
    [sym__whitespace_ge_2] = ACTIONS(1324),
    [aux_sym__whitespace_token1] = ACTIONS(1327),
    [sym__word_no_digit] = ACTIONS(1288),
    [sym__digits] = ACTIONS(1288),
    [sym__code_span_start] = ACTIONS(1330),
    [sym__emphasis_open_star] = ACTIONS(1333),
    [sym__emphasis_open_underscore] = ACTIONS(1336),
    [sym__last_token_punctuation] = ACTIONS(1471),
    [sym__strikethrough_open] = ACTIONS(1341),
    [sym__latex_span_start] = ACTIONS(1344),
    [sym__unclosed_span] = ACTIONS(1288),
  },
  [91] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(135),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(135),
    [aux_sym__inline_no_tilde_no_link] = STATE(135),
    [sym__strikethrough_no_link] = STATE(135),
    [sym__emphasis_star_no_link] = STATE(617),
    [sym__strong_emphasis_star_no_link] = STATE(135),
    [sym__emphasis_underscore_no_link] = STATE(617),
    [sym__strong_emphasis_underscore_no_link] = STATE(135),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(1473),
    [sym_entity_reference] = ACTIONS(1476),
    [sym_numeric_character_reference] = ACTIONS(1476),
    [anon_sym_RBRACK] = ACTIONS(1479),
    [anon_sym_LT] = ACTIONS(1481),
    [anon_sym_GT] = ACTIONS(1484),
    [anon_sym_BANG] = ACTIONS(1487),
    [anon_sym_DQUOTE] = ACTIONS(1484),
    [anon_sym_POUND] = ACTIONS(1484),
    [anon_sym_DOLLAR] = ACTIONS(1484),
    [anon_sym_PERCENT] = ACTIONS(1484),
    [anon_sym_AMP] = ACTIONS(1490),
    [anon_sym_SQUOTE] = ACTIONS(1484),
    [anon_sym_STAR] = ACTIONS(1484),
    [anon_sym_PLUS] = ACTIONS(1484),
    [anon_sym_COMMA] = ACTIONS(1484),
    [anon_sym_DASH] = ACTIONS(1484),
    [anon_sym_DOT] = ACTIONS(1484),
    [anon_sym_SLASH] = ACTIONS(1484),
    [anon_sym_COLON] = ACTIONS(1484),
    [anon_sym_SEMI] = ACTIONS(1484),
    [anon_sym_EQ] = ACTIONS(1484),
    [anon_sym_QMARK] = ACTIONS(1484),
    [anon_sym_AT] = ACTIONS(1484),
    [anon_sym_BSLASH] = ACTIONS(1493),
    [anon_sym_CARET] = ACTIONS(1484),
    [anon_sym__] = ACTIONS(1484),
    [anon_sym_BQUOTE] = ACTIONS(1484),
    [anon_sym_LBRACE] = ACTIONS(1484),
    [anon_sym_PIPE] = ACTIONS(1484),
    [anon_sym_RBRACE] = ACTIONS(1484),
    [anon_sym_TILDE] = ACTIONS(1484),
    [anon_sym_LPAREN] = ACTIONS(1484),
    [anon_sym_RPAREN] = ACTIONS(1484),
    [sym__newline_token] = ACTIONS(1496),
    [sym_uri_autolink] = ACTIONS(1476),
    [sym_email_autolink] = ACTIONS(1476),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1499),
    [anon_sym_LT_QMARK] = ACTIONS(1502),
    [aux_sym__declaration_token1] = ACTIONS(1505),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1508),
    [sym__whitespace_ge_2] = ACTIONS(1511),
    [aux_sym__whitespace_token1] = ACTIONS(1514),
    [sym__word_no_digit] = ACTIONS(1476),
    [sym__digits] = ACTIONS(1476),
    [sym__code_span_start] = ACTIONS(1517),
    [sym__emphasis_open_star] = ACTIONS(1520),
    [sym__emphasis_open_underscore] = ACTIONS(1523),
    [sym__last_token_punctuation] = ACTIONS(1526),
    [sym__strikethrough_open] = ACTIONS(1528),
    [sym__latex_span_start] = ACTIONS(1531),
    [sym__unclosed_span] = ACTIONS(1476),
  },
  [92] = {
    [sym_backslash_escape] = STATE(159),
    [sym_code_span] = STATE(159),
    [sym_latex_block] = STATE(159),
    [sym_image] = STATE(159),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(560),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(159),
    [sym__whitespace] = STATE(159),
    [sym__word] = STATE(159),
    [sym__soft_line_break] = STATE(159),
    [sym__inline_base] = STATE(114),
    [sym__text_base] = STATE(159),
    [sym__inline_element_no_underscore_no_link] = STATE(114),
    [aux_sym__inline_no_underscore_no_link] = STATE(114),
    [sym__strikethrough_no_link] = STATE(114),
    [sym__emphasis_star_no_link] = STATE(605),
    [sym__strong_emphasis_star_no_link] = STATE(114),
    [sym__emphasis_underscore_no_link] = STATE(600),
    [sym__strong_emphasis_underscore_no_link] = STATE(114),
    [aux_sym__inline_base_repeat1] = STATE(159),
    [sym__backslash_escape] = ACTIONS(1534),
    [sym_entity_reference] = ACTIONS(1537),
    [sym_numeric_character_reference] = ACTIONS(1537),
    [anon_sym_LT] = ACTIONS(1540),
    [anon_sym_GT] = ACTIONS(1543),
    [anon_sym_BANG] = ACTIONS(1546),
    [anon_sym_DQUOTE] = ACTIONS(1543),
    [anon_sym_POUND] = ACTIONS(1543),
    [anon_sym_DOLLAR] = ACTIONS(1543),
    [anon_sym_PERCENT] = ACTIONS(1543),
    [anon_sym_AMP] = ACTIONS(1549),
    [anon_sym_SQUOTE] = ACTIONS(1543),
    [anon_sym_STAR] = ACTIONS(1543),
    [anon_sym_PLUS] = ACTIONS(1543),
    [anon_sym_COMMA] = ACTIONS(1543),
    [anon_sym_DASH] = ACTIONS(1543),
    [anon_sym_DOT] = ACTIONS(1543),
    [anon_sym_SLASH] = ACTIONS(1543),
    [anon_sym_COLON] = ACTIONS(1543),
    [anon_sym_SEMI] = ACTIONS(1543),
    [anon_sym_EQ] = ACTIONS(1543),
    [anon_sym_QMARK] = ACTIONS(1543),
    [anon_sym_AT] = ACTIONS(1543),
    [anon_sym_BSLASH] = ACTIONS(1552),
    [anon_sym_CARET] = ACTIONS(1543),
    [anon_sym__] = ACTIONS(1543),
    [anon_sym_BQUOTE] = ACTIONS(1543),
    [anon_sym_LBRACE] = ACTIONS(1543),
    [anon_sym_PIPE] = ACTIONS(1543),
    [anon_sym_RBRACE] = ACTIONS(1543),
    [anon_sym_TILDE] = ACTIONS(1543),
    [anon_sym_LPAREN] = ACTIONS(1543),
    [anon_sym_RPAREN] = ACTIONS(1543),
    [sym__newline_token] = ACTIONS(1555),
    [sym_uri_autolink] = ACTIONS(1537),
    [sym_email_autolink] = ACTIONS(1537),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1558),
    [anon_sym_LT_QMARK] = ACTIONS(1561),
    [aux_sym__declaration_token1] = ACTIONS(1564),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1567),
    [sym__whitespace_ge_2] = ACTIONS(1570),
    [aux_sym__whitespace_token1] = ACTIONS(1573),
    [sym__word_no_digit] = ACTIONS(1537),
    [sym__digits] = ACTIONS(1537),
    [sym__code_span_start] = ACTIONS(1576),
    [sym__emphasis_open_star] = ACTIONS(1579),
    [sym__emphasis_open_underscore] = ACTIONS(1582),
    [sym__last_token_punctuation] = ACTIONS(1585),
    [sym__strikethrough_open] = ACTIONS(1587),
    [sym__strikethrough_close] = ACTIONS(1590),
    [sym__latex_span_start] = ACTIONS(1592),
    [sym__unclosed_span] = ACTIONS(1537),
  },
  [93] = {
    [sym_backslash_escape] = STATE(161),
    [sym_code_span] = STATE(161),
    [sym_latex_block] = STATE(161),
    [sym_image] = STATE(161),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(561),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(161),
    [sym__whitespace] = STATE(161),
    [sym__word] = STATE(161),
    [sym__soft_line_break] = STATE(161),
    [sym__inline_base] = STATE(132),
    [sym__text_base] = STATE(161),
    [sym__inline_element_no_star_no_link] = STATE(132),
    [aux_sym__inline_no_star_no_link] = STATE(132),
    [sym__strikethrough_no_link] = STATE(132),
    [sym__emphasis_star_no_link] = STATE(632),
    [sym__strong_emphasis_star_no_link] = STATE(132),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(132),
    [aux_sym__inline_base_repeat1] = STATE(161),
    [sym__backslash_escape] = ACTIONS(1595),
    [sym_entity_reference] = ACTIONS(1598),
    [sym_numeric_character_reference] = ACTIONS(1598),
    [anon_sym_LT] = ACTIONS(1601),
    [anon_sym_GT] = ACTIONS(1604),
    [anon_sym_BANG] = ACTIONS(1607),
    [anon_sym_DQUOTE] = ACTIONS(1604),
    [anon_sym_POUND] = ACTIONS(1604),
    [anon_sym_DOLLAR] = ACTIONS(1604),
    [anon_sym_PERCENT] = ACTIONS(1604),
    [anon_sym_AMP] = ACTIONS(1610),
    [anon_sym_SQUOTE] = ACTIONS(1604),
    [anon_sym_STAR] = ACTIONS(1604),
    [anon_sym_PLUS] = ACTIONS(1604),
    [anon_sym_COMMA] = ACTIONS(1604),
    [anon_sym_DASH] = ACTIONS(1604),
    [anon_sym_DOT] = ACTIONS(1604),
    [anon_sym_SLASH] = ACTIONS(1604),
    [anon_sym_COLON] = ACTIONS(1604),
    [anon_sym_SEMI] = ACTIONS(1604),
    [anon_sym_EQ] = ACTIONS(1604),
    [anon_sym_QMARK] = ACTIONS(1604),
    [anon_sym_AT] = ACTIONS(1604),
    [anon_sym_BSLASH] = ACTIONS(1613),
    [anon_sym_CARET] = ACTIONS(1604),
    [anon_sym__] = ACTIONS(1604),
    [anon_sym_BQUOTE] = ACTIONS(1604),
    [anon_sym_LBRACE] = ACTIONS(1604),
    [anon_sym_PIPE] = ACTIONS(1604),
    [anon_sym_RBRACE] = ACTIONS(1604),
    [anon_sym_TILDE] = ACTIONS(1604),
    [anon_sym_LPAREN] = ACTIONS(1604),
    [anon_sym_RPAREN] = ACTIONS(1604),
    [sym__newline_token] = ACTIONS(1616),
    [sym_uri_autolink] = ACTIONS(1598),
    [sym_email_autolink] = ACTIONS(1598),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1619),
    [anon_sym_LT_QMARK] = ACTIONS(1622),
    [aux_sym__declaration_token1] = ACTIONS(1625),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1628),
    [sym__whitespace_ge_2] = ACTIONS(1631),
    [aux_sym__whitespace_token1] = ACTIONS(1634),
    [sym__word_no_digit] = ACTIONS(1598),
    [sym__digits] = ACTIONS(1598),
    [sym__code_span_start] = ACTIONS(1637),
    [sym__emphasis_open_star] = ACTIONS(1640),
    [sym__emphasis_open_underscore] = ACTIONS(1643),
    [sym__last_token_punctuation] = ACTIONS(1646),
    [sym__strikethrough_open] = ACTIONS(1648),
    [sym__strikethrough_close] = ACTIONS(1590),
    [sym__latex_span_start] = ACTIONS(1651),
    [sym__unclosed_span] = ACTIONS(1598),
  },
  [94] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(111),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(111),
    [aux_sym__inline_no_tilde_no_link] = STATE(111),
    [sym__strikethrough_no_link] = STATE(111),
    [sym__emphasis_star_no_link] = STATE(617),
    [sym__strong_emphasis_star_no_link] = STATE(111),
    [sym__emphasis_underscore_no_link] = STATE(617),
    [sym__strong_emphasis_underscore_no_link] = STATE(111),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(1654),
    [sym_entity_reference] = ACTIONS(1657),
    [sym_numeric_character_reference] = ACTIONS(1657),
    [anon_sym_LT] = ACTIONS(1660),
    [anon_sym_GT] = ACTIONS(1663),
    [anon_sym_BANG] = ACTIONS(1666),
    [anon_sym_DQUOTE] = ACTIONS(1663),
    [anon_sym_POUND] = ACTIONS(1663),
    [anon_sym_DOLLAR] = ACTIONS(1663),
    [anon_sym_PERCENT] = ACTIONS(1663),
    [anon_sym_AMP] = ACTIONS(1669),
    [anon_sym_SQUOTE] = ACTIONS(1663),
    [anon_sym_STAR] = ACTIONS(1663),
    [anon_sym_PLUS] = ACTIONS(1663),
    [anon_sym_COMMA] = ACTIONS(1663),
    [anon_sym_DASH] = ACTIONS(1663),
    [anon_sym_DOT] = ACTIONS(1663),
    [anon_sym_SLASH] = ACTIONS(1663),
    [anon_sym_COLON] = ACTIONS(1663),
    [anon_sym_SEMI] = ACTIONS(1663),
    [anon_sym_EQ] = ACTIONS(1663),
    [anon_sym_QMARK] = ACTIONS(1663),
    [anon_sym_AT] = ACTIONS(1663),
    [anon_sym_BSLASH] = ACTIONS(1672),
    [anon_sym_CARET] = ACTIONS(1663),
    [anon_sym__] = ACTIONS(1663),
    [anon_sym_BQUOTE] = ACTIONS(1663),
    [anon_sym_LBRACE] = ACTIONS(1663),
    [anon_sym_PIPE] = ACTIONS(1663),
    [anon_sym_RBRACE] = ACTIONS(1663),
    [anon_sym_TILDE] = ACTIONS(1663),
    [anon_sym_LPAREN] = ACTIONS(1663),
    [anon_sym_RPAREN] = ACTIONS(1663),
    [sym__newline_token] = ACTIONS(1675),
    [sym_uri_autolink] = ACTIONS(1657),
    [sym_email_autolink] = ACTIONS(1657),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1678),
    [anon_sym_LT_QMARK] = ACTIONS(1681),
    [aux_sym__declaration_token1] = ACTIONS(1684),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1687),
    [sym__whitespace_ge_2] = ACTIONS(1690),
    [aux_sym__whitespace_token1] = ACTIONS(1693),
    [sym__word_no_digit] = ACTIONS(1657),
    [sym__digits] = ACTIONS(1657),
    [sym__code_span_start] = ACTIONS(1696),
    [sym__emphasis_open_star] = ACTIONS(1699),
    [sym__emphasis_open_underscore] = ACTIONS(1702),
    [sym__emphasis_close_underscore] = ACTIONS(1705),
    [sym__last_token_punctuation] = ACTIONS(1707),
    [sym__strikethrough_open] = ACTIONS(1709),
    [sym__latex_span_start] = ACTIONS(1712),
    [sym__unclosed_span] = ACTIONS(1657),
  },
  [95] = {
    [sym_backslash_escape] = STATE(161),
    [sym_code_span] = STATE(161),
    [sym_latex_block] = STATE(161),
    [sym_image] = STATE(161),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(561),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(161),
    [sym__whitespace] = STATE(161),
    [sym__word] = STATE(161),
    [sym__soft_line_break] = STATE(161),
    [sym__inline_base] = STATE(122),
    [sym__text_base] = STATE(161),
    [sym__inline_element_no_star_no_link] = STATE(122),
    [aux_sym__inline_no_star_no_link] = STATE(122),
    [sym__strikethrough_no_link] = STATE(122),
    [sym__emphasis_star_no_link] = STATE(637),
    [sym__strong_emphasis_star_no_link] = STATE(122),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(122),
    [aux_sym__inline_base_repeat1] = STATE(161),
    [sym__backslash_escape] = ACTIONS(1715),
    [sym_entity_reference] = ACTIONS(1718),
    [sym_numeric_character_reference] = ACTIONS(1718),
    [anon_sym_LT] = ACTIONS(1721),
    [anon_sym_GT] = ACTIONS(1724),
    [anon_sym_BANG] = ACTIONS(1727),
    [anon_sym_DQUOTE] = ACTIONS(1724),
    [anon_sym_POUND] = ACTIONS(1724),
    [anon_sym_DOLLAR] = ACTIONS(1724),
    [anon_sym_PERCENT] = ACTIONS(1724),
    [anon_sym_AMP] = ACTIONS(1730),
    [anon_sym_SQUOTE] = ACTIONS(1724),
    [anon_sym_STAR] = ACTIONS(1724),
    [anon_sym_PLUS] = ACTIONS(1724),
    [anon_sym_COMMA] = ACTIONS(1724),
    [anon_sym_DASH] = ACTIONS(1724),
    [anon_sym_DOT] = ACTIONS(1724),
    [anon_sym_SLASH] = ACTIONS(1724),
    [anon_sym_COLON] = ACTIONS(1724),
    [anon_sym_SEMI] = ACTIONS(1724),
    [anon_sym_EQ] = ACTIONS(1724),
    [anon_sym_QMARK] = ACTIONS(1724),
    [anon_sym_AT] = ACTIONS(1724),
    [anon_sym_BSLASH] = ACTIONS(1733),
    [anon_sym_CARET] = ACTIONS(1724),
    [anon_sym__] = ACTIONS(1724),
    [anon_sym_BQUOTE] = ACTIONS(1724),
    [anon_sym_LBRACE] = ACTIONS(1724),
    [anon_sym_PIPE] = ACTIONS(1724),
    [anon_sym_RBRACE] = ACTIONS(1724),
    [anon_sym_TILDE] = ACTIONS(1724),
    [anon_sym_LPAREN] = ACTIONS(1724),
    [anon_sym_RPAREN] = ACTIONS(1724),
    [sym__newline_token] = ACTIONS(1736),
    [sym_uri_autolink] = ACTIONS(1718),
    [sym_email_autolink] = ACTIONS(1718),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1739),
    [anon_sym_LT_QMARK] = ACTIONS(1742),
    [aux_sym__declaration_token1] = ACTIONS(1745),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1748),
    [sym__whitespace_ge_2] = ACTIONS(1751),
    [aux_sym__whitespace_token1] = ACTIONS(1754),
    [sym__word_no_digit] = ACTIONS(1718),
    [sym__digits] = ACTIONS(1718),
    [sym__code_span_start] = ACTIONS(1757),
    [sym__emphasis_open_star] = ACTIONS(1760),
    [sym__emphasis_open_underscore] = ACTIONS(1763),
    [sym__emphasis_close_underscore] = ACTIONS(1705),
    [sym__last_token_punctuation] = ACTIONS(1766),
    [sym__strikethrough_open] = ACTIONS(1768),
    [sym__latex_span_start] = ACTIONS(1771),
    [sym__unclosed_span] = ACTIONS(1718),
  },
  [96] = {
    [sym_backslash_escape] = STATE(161),
    [sym_code_span] = STATE(161),
    [sym_latex_block] = STATE(161),
    [sym_image] = STATE(161),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(561),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(161),
    [sym__whitespace] = STATE(161),
    [sym__word] = STATE(161),
    [sym__soft_line_break] = STATE(161),
    [sym__inline_base] = STATE(121),
    [sym__text_base] = STATE(161),
    [sym__inline_element_no_star_no_link] = STATE(121),
    [aux_sym__inline_no_star_no_link] = STATE(121),
    [sym__strikethrough_no_link] = STATE(121),
    [sym__emphasis_star_no_link] = STATE(636),
    [sym__strong_emphasis_star_no_link] = STATE(121),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(121),
    [aux_sym__inline_base_repeat1] = STATE(161),
    [sym__backslash_escape] = ACTIONS(1774),
    [sym_entity_reference] = ACTIONS(1777),
    [sym_numeric_character_reference] = ACTIONS(1777),
    [anon_sym_RBRACK] = ACTIONS(1479),
    [anon_sym_LT] = ACTIONS(1780),
    [anon_sym_GT] = ACTIONS(1783),
    [anon_sym_BANG] = ACTIONS(1786),
    [anon_sym_DQUOTE] = ACTIONS(1783),
    [anon_sym_POUND] = ACTIONS(1783),
    [anon_sym_DOLLAR] = ACTIONS(1783),
    [anon_sym_PERCENT] = ACTIONS(1783),
    [anon_sym_AMP] = ACTIONS(1789),
    [anon_sym_SQUOTE] = ACTIONS(1783),
    [anon_sym_STAR] = ACTIONS(1783),
    [anon_sym_PLUS] = ACTIONS(1783),
    [anon_sym_COMMA] = ACTIONS(1783),
    [anon_sym_DASH] = ACTIONS(1783),
    [anon_sym_DOT] = ACTIONS(1783),
    [anon_sym_SLASH] = ACTIONS(1783),
    [anon_sym_COLON] = ACTIONS(1783),
    [anon_sym_SEMI] = ACTIONS(1783),
    [anon_sym_EQ] = ACTIONS(1783),
    [anon_sym_QMARK] = ACTIONS(1783),
    [anon_sym_AT] = ACTIONS(1783),
    [anon_sym_BSLASH] = ACTIONS(1792),
    [anon_sym_CARET] = ACTIONS(1783),
    [anon_sym__] = ACTIONS(1783),
    [anon_sym_BQUOTE] = ACTIONS(1783),
    [anon_sym_LBRACE] = ACTIONS(1783),
    [anon_sym_PIPE] = ACTIONS(1783),
    [anon_sym_RBRACE] = ACTIONS(1783),
    [anon_sym_TILDE] = ACTIONS(1783),
    [anon_sym_LPAREN] = ACTIONS(1783),
    [anon_sym_RPAREN] = ACTIONS(1783),
    [sym__newline_token] = ACTIONS(1795),
    [sym_uri_autolink] = ACTIONS(1777),
    [sym_email_autolink] = ACTIONS(1777),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1798),
    [anon_sym_LT_QMARK] = ACTIONS(1801),
    [aux_sym__declaration_token1] = ACTIONS(1804),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1807),
    [sym__whitespace_ge_2] = ACTIONS(1810),
    [aux_sym__whitespace_token1] = ACTIONS(1813),
    [sym__word_no_digit] = ACTIONS(1777),
    [sym__digits] = ACTIONS(1777),
    [sym__code_span_start] = ACTIONS(1816),
    [sym__emphasis_open_star] = ACTIONS(1819),
    [sym__emphasis_open_underscore] = ACTIONS(1822),
    [sym__last_token_punctuation] = ACTIONS(1825),
    [sym__strikethrough_open] = ACTIONS(1827),
    [sym__latex_span_start] = ACTIONS(1830),
    [sym__unclosed_span] = ACTIONS(1777),
  },
  [97] = {
    [sym_backslash_escape] = STATE(159),
    [sym_code_span] = STATE(159),
    [sym_latex_block] = STATE(159),
    [sym_image] = STATE(159),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(560),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(159),
    [sym__whitespace] = STATE(159),
    [sym__word] = STATE(159),
    [sym__soft_line_break] = STATE(159),
    [sym__inline_base] = STATE(128),
    [sym__text_base] = STATE(159),
    [sym__inline_element_no_underscore_no_link] = STATE(128),
    [aux_sym__inline_no_underscore_no_link] = STATE(128),
    [sym__strikethrough_no_link] = STATE(128),
    [sym__emphasis_star_no_link] = STATE(605),
    [sym__strong_emphasis_star_no_link] = STATE(128),
    [sym__emphasis_underscore_no_link] = STATE(610),
    [sym__strong_emphasis_underscore_no_link] = STATE(128),
    [aux_sym__inline_base_repeat1] = STATE(159),
    [sym__backslash_escape] = ACTIONS(1833),
    [sym_entity_reference] = ACTIONS(1836),
    [sym_numeric_character_reference] = ACTIONS(1836),
    [anon_sym_RBRACK] = ACTIONS(1479),
    [anon_sym_LT] = ACTIONS(1839),
    [anon_sym_GT] = ACTIONS(1842),
    [anon_sym_BANG] = ACTIONS(1845),
    [anon_sym_DQUOTE] = ACTIONS(1842),
    [anon_sym_POUND] = ACTIONS(1842),
    [anon_sym_DOLLAR] = ACTIONS(1842),
    [anon_sym_PERCENT] = ACTIONS(1842),
    [anon_sym_AMP] = ACTIONS(1848),
    [anon_sym_SQUOTE] = ACTIONS(1842),
    [anon_sym_STAR] = ACTIONS(1842),
    [anon_sym_PLUS] = ACTIONS(1842),
    [anon_sym_COMMA] = ACTIONS(1842),
    [anon_sym_DASH] = ACTIONS(1842),
    [anon_sym_DOT] = ACTIONS(1842),
    [anon_sym_SLASH] = ACTIONS(1842),
    [anon_sym_COLON] = ACTIONS(1842),
    [anon_sym_SEMI] = ACTIONS(1842),
    [anon_sym_EQ] = ACTIONS(1842),
    [anon_sym_QMARK] = ACTIONS(1842),
    [anon_sym_AT] = ACTIONS(1842),
    [anon_sym_BSLASH] = ACTIONS(1851),
    [anon_sym_CARET] = ACTIONS(1842),
    [anon_sym__] = ACTIONS(1842),
    [anon_sym_BQUOTE] = ACTIONS(1842),
    [anon_sym_LBRACE] = ACTIONS(1842),
    [anon_sym_PIPE] = ACTIONS(1842),
    [anon_sym_RBRACE] = ACTIONS(1842),
    [anon_sym_TILDE] = ACTIONS(1842),
    [anon_sym_LPAREN] = ACTIONS(1842),
    [anon_sym_RPAREN] = ACTIONS(1842),
    [sym__newline_token] = ACTIONS(1854),
    [sym_uri_autolink] = ACTIONS(1836),
    [sym_email_autolink] = ACTIONS(1836),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1857),
    [anon_sym_LT_QMARK] = ACTIONS(1860),
    [aux_sym__declaration_token1] = ACTIONS(1863),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1866),
    [sym__whitespace_ge_2] = ACTIONS(1869),
    [aux_sym__whitespace_token1] = ACTIONS(1872),
    [sym__word_no_digit] = ACTIONS(1836),
    [sym__digits] = ACTIONS(1836),
    [sym__code_span_start] = ACTIONS(1875),
    [sym__emphasis_open_star] = ACTIONS(1878),
    [sym__emphasis_open_underscore] = ACTIONS(1881),
    [sym__last_token_punctuation] = ACTIONS(1884),
    [sym__strikethrough_open] = ACTIONS(1886),
    [sym__latex_span_start] = ACTIONS(1889),
    [sym__unclosed_span] = ACTIONS(1836),
  },
  [98] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(102),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(102),
    [aux_sym__inline_no_tilde_no_link] = STATE(102),
    [sym__strikethrough_no_link] = STATE(102),
    [sym__emphasis_star_no_link] = STATE(617),
    [sym__strong_emphasis_star_no_link] = STATE(102),
    [sym__emphasis_underscore_no_link] = STATE(617),
    [sym__strong_emphasis_underscore_no_link] = STATE(102),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(1892),
    [sym_entity_reference] = ACTIONS(1895),
    [sym_numeric_character_reference] = ACTIONS(1895),
    [anon_sym_LT] = ACTIONS(1898),
    [anon_sym_GT] = ACTIONS(1901),
    [anon_sym_BANG] = ACTIONS(1904),
    [anon_sym_DQUOTE] = ACTIONS(1901),
    [anon_sym_POUND] = ACTIONS(1901),
    [anon_sym_DOLLAR] = ACTIONS(1901),
    [anon_sym_PERCENT] = ACTIONS(1901),
    [anon_sym_AMP] = ACTIONS(1907),
    [anon_sym_SQUOTE] = ACTIONS(1901),
    [anon_sym_STAR] = ACTIONS(1901),
    [anon_sym_PLUS] = ACTIONS(1901),
    [anon_sym_COMMA] = ACTIONS(1901),
    [anon_sym_DASH] = ACTIONS(1901),
    [anon_sym_DOT] = ACTIONS(1901),
    [anon_sym_SLASH] = ACTIONS(1901),
    [anon_sym_COLON] = ACTIONS(1901),
    [anon_sym_SEMI] = ACTIONS(1901),
    [anon_sym_EQ] = ACTIONS(1901),
    [anon_sym_QMARK] = ACTIONS(1901),
    [anon_sym_AT] = ACTIONS(1901),
    [anon_sym_BSLASH] = ACTIONS(1910),
    [anon_sym_CARET] = ACTIONS(1901),
    [anon_sym__] = ACTIONS(1901),
    [anon_sym_BQUOTE] = ACTIONS(1901),
    [anon_sym_LBRACE] = ACTIONS(1901),
    [anon_sym_PIPE] = ACTIONS(1901),
    [anon_sym_RBRACE] = ACTIONS(1901),
    [anon_sym_TILDE] = ACTIONS(1901),
    [anon_sym_LPAREN] = ACTIONS(1901),
    [anon_sym_RPAREN] = ACTIONS(1901),
    [sym__newline_token] = ACTIONS(1913),
    [sym_uri_autolink] = ACTIONS(1895),
    [sym_email_autolink] = ACTIONS(1895),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1916),
    [anon_sym_LT_QMARK] = ACTIONS(1919),
    [aux_sym__declaration_token1] = ACTIONS(1922),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1925),
    [sym__whitespace_ge_2] = ACTIONS(1928),
    [aux_sym__whitespace_token1] = ACTIONS(1931),
    [sym__word_no_digit] = ACTIONS(1895),
    [sym__digits] = ACTIONS(1895),
    [sym__code_span_start] = ACTIONS(1934),
    [sym__emphasis_open_star] = ACTIONS(1937),
    [sym__emphasis_open_underscore] = ACTIONS(1940),
    [sym__emphasis_close_star] = ACTIONS(1943),
    [sym__last_token_punctuation] = ACTIONS(1945),
    [sym__strikethrough_open] = ACTIONS(1947),
    [sym__latex_span_start] = ACTIONS(1950),
    [sym__unclosed_span] = ACTIONS(1895),
  },
  [99] = {
    [sym_backslash_escape] = STATE(159),
    [sym_code_span] = STATE(159),
    [sym_latex_block] = STATE(159),
    [sym_image] = STATE(159),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(560),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(159),
    [sym__whitespace] = STATE(159),
    [sym__word] = STATE(159),
    [sym__soft_line_break] = STATE(159),
    [sym__inline_base] = STATE(112),
    [sym__text_base] = STATE(159),
    [sym__inline_element_no_underscore_no_link] = STATE(112),
    [aux_sym__inline_no_underscore_no_link] = STATE(112),
    [sym__strikethrough_no_link] = STATE(112),
    [sym__emphasis_star_no_link] = STATE(605),
    [sym__strong_emphasis_star_no_link] = STATE(112),
    [sym__emphasis_underscore_no_link] = STATE(621),
    [sym__strong_emphasis_underscore_no_link] = STATE(112),
    [aux_sym__inline_base_repeat1] = STATE(159),
    [sym__backslash_escape] = ACTIONS(1953),
    [sym_entity_reference] = ACTIONS(1956),
    [sym_numeric_character_reference] = ACTIONS(1956),
    [anon_sym_LT] = ACTIONS(1959),
    [anon_sym_GT] = ACTIONS(1962),
    [anon_sym_BANG] = ACTIONS(1965),
    [anon_sym_DQUOTE] = ACTIONS(1962),
    [anon_sym_POUND] = ACTIONS(1962),
    [anon_sym_DOLLAR] = ACTIONS(1962),
    [anon_sym_PERCENT] = ACTIONS(1962),
    [anon_sym_AMP] = ACTIONS(1968),
    [anon_sym_SQUOTE] = ACTIONS(1962),
    [anon_sym_STAR] = ACTIONS(1962),
    [anon_sym_PLUS] = ACTIONS(1962),
    [anon_sym_COMMA] = ACTIONS(1962),
    [anon_sym_DASH] = ACTIONS(1962),
    [anon_sym_DOT] = ACTIONS(1962),
    [anon_sym_SLASH] = ACTIONS(1962),
    [anon_sym_COLON] = ACTIONS(1962),
    [anon_sym_SEMI] = ACTIONS(1962),
    [anon_sym_EQ] = ACTIONS(1962),
    [anon_sym_QMARK] = ACTIONS(1962),
    [anon_sym_AT] = ACTIONS(1962),
    [anon_sym_BSLASH] = ACTIONS(1971),
    [anon_sym_CARET] = ACTIONS(1962),
    [anon_sym__] = ACTIONS(1962),
    [anon_sym_BQUOTE] = ACTIONS(1962),
    [anon_sym_LBRACE] = ACTIONS(1962),
    [anon_sym_PIPE] = ACTIONS(1962),
    [anon_sym_RBRACE] = ACTIONS(1962),
    [anon_sym_TILDE] = ACTIONS(1962),
    [anon_sym_LPAREN] = ACTIONS(1962),
    [anon_sym_RPAREN] = ACTIONS(1962),
    [sym__newline_token] = ACTIONS(1974),
    [sym_uri_autolink] = ACTIONS(1956),
    [sym_email_autolink] = ACTIONS(1956),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1977),
    [anon_sym_LT_QMARK] = ACTIONS(1980),
    [aux_sym__declaration_token1] = ACTIONS(1983),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1986),
    [sym__whitespace_ge_2] = ACTIONS(1989),
    [aux_sym__whitespace_token1] = ACTIONS(1992),
    [sym__word_no_digit] = ACTIONS(1956),
    [sym__digits] = ACTIONS(1956),
    [sym__code_span_start] = ACTIONS(1995),
    [sym__emphasis_open_star] = ACTIONS(1998),
    [sym__emphasis_open_underscore] = ACTIONS(2001),
    [sym__emphasis_close_star] = ACTIONS(1943),
    [sym__last_token_punctuation] = ACTIONS(2004),
    [sym__strikethrough_open] = ACTIONS(2006),
    [sym__latex_span_start] = ACTIONS(2009),
    [sym__unclosed_span] = ACTIONS(1956),
  },
  [100] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(120),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(120),
    [aux_sym__inline_no_tilde_no_link] = STATE(120),
    [sym__strikethrough_no_link] = STATE(120),
    [sym__emphasis_star_no_link] = STATE(617),
    [sym__strong_emphasis_star_no_link] = STATE(120),
    [sym__emphasis_underscore_no_link] = STATE(617),
    [sym__strong_emphasis_underscore_no_link] = STATE(120),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2012),
    [sym_numeric_character_reference] = ACTIONS(2012),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2014),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2012),
    [sym_email_autolink] = ACTIONS(2012),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2016),
    [anon_sym_LT_QMARK] = ACTIONS(2018),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2020),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2012),
    [sym__digits] = ACTIONS(2012),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2022),
    [sym__emphasis_open_underscore] = ACTIONS(2024),
    [sym__strikethrough_open] = ACTIONS(2026),
    [sym__strikethrough_close] = ACTIONS(2028),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2012),
  },
  [101] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(110),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(110),
    [aux_sym__inline_no_tilde_no_link] = STATE(110),
    [sym__strikethrough_no_link] = STATE(110),
    [sym__emphasis_star_no_link] = STATE(617),
    [sym__strong_emphasis_star_no_link] = STATE(110),
    [sym__emphasis_underscore_no_link] = STATE(617),
    [sym__strong_emphasis_underscore_no_link] = STATE(110),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2012),
    [sym_numeric_character_reference] = ACTIONS(2012),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2014),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2012),
    [sym_email_autolink] = ACTIONS(2012),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2016),
    [anon_sym_LT_QMARK] = ACTIONS(2018),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2020),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2012),
    [sym__digits] = ACTIONS(2012),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2022),
    [sym__emphasis_open_underscore] = ACTIONS(2024),
    [sym__last_token_punctuation] = ACTIONS(2030),
    [sym__strikethrough_open] = ACTIONS(2026),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2012),
  },
  [102] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(120),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(120),
    [aux_sym__inline_no_tilde_no_link] = STATE(120),
    [sym__strikethrough_no_link] = STATE(120),
    [sym__emphasis_star_no_link] = STATE(617),
    [sym__strong_emphasis_star_no_link] = STATE(120),
    [sym__emphasis_underscore_no_link] = STATE(617),
    [sym__strong_emphasis_underscore_no_link] = STATE(120),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2012),
    [sym_numeric_character_reference] = ACTIONS(2012),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2014),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2012),
    [sym_email_autolink] = ACTIONS(2012),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2016),
    [anon_sym_LT_QMARK] = ACTIONS(2018),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2020),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2012),
    [sym__digits] = ACTIONS(2012),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2022),
    [sym__emphasis_open_underscore] = ACTIONS(2024),
    [sym__strikethrough_open] = ACTIONS(2026),
    [sym__strikethrough_close] = ACTIONS(2032),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2012),
  },
  [103] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(120),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(120),
    [aux_sym__inline_no_tilde_no_link] = STATE(120),
    [sym__strikethrough_no_link] = STATE(120),
    [sym__emphasis_star_no_link] = STATE(617),
    [sym__strong_emphasis_star_no_link] = STATE(120),
    [sym__emphasis_underscore_no_link] = STATE(617),
    [sym__strong_emphasis_underscore_no_link] = STATE(120),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2012),
    [sym_numeric_character_reference] = ACTIONS(2012),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2014),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2012),
    [sym_email_autolink] = ACTIONS(2012),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2016),
    [anon_sym_LT_QMARK] = ACTIONS(2018),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2020),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2012),
    [sym__digits] = ACTIONS(2012),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2022),
    [sym__emphasis_open_underscore] = ACTIONS(2024),
    [sym__strikethrough_open] = ACTIONS(2026),
    [sym__strikethrough_close] = ACTIONS(2034),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2012),
  },
  [104] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(615),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_link] = STATE(615),
    [aux_sym__inline_no_link] = STATE(133),
    [sym__strikethrough_no_link] = STATE(615),
    [sym__emphasis_star_no_link] = STATE(616),
    [sym__strong_emphasis_star_no_link] = STATE(615),
    [sym__emphasis_underscore_no_link] = STATE(616),
    [sym__strong_emphasis_underscore_no_link] = STATE(615),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(2036),
    [sym_numeric_character_reference] = ACTIONS(2036),
    [anon_sym_RBRACK] = ACTIONS(2038),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(2040),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(2036),
    [sym_email_autolink] = ACTIONS(2036),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2042),
    [anon_sym_LT_QMARK] = ACTIONS(2044),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2046),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(2036),
    [sym__digits] = ACTIONS(2036),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(2048),
    [sym__emphasis_open_underscore] = ACTIONS(2050),
    [sym__strikethrough_open] = ACTIONS(2052),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(2036),
  },
  [105] = {
    [sym_backslash_escape] = STATE(161),
    [sym_code_span] = STATE(161),
    [sym_latex_block] = STATE(161),
    [sym_image] = STATE(161),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(561),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(161),
    [sym__whitespace] = STATE(161),
    [sym__word] = STATE(161),
    [sym__soft_line_break] = STATE(161),
    [sym__inline_base] = STATE(109),
    [sym__text_base] = STATE(161),
    [sym__inline_element_no_star_no_link] = STATE(109),
    [aux_sym__inline_no_star_no_link] = STATE(109),
    [sym__strikethrough_no_link] = STATE(109),
    [sym__emphasis_star_no_link] = STATE(641),
    [sym__strong_emphasis_star_no_link] = STATE(109),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(109),
    [aux_sym__inline_base_repeat1] = STATE(161),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(2054),
    [sym_numeric_character_reference] = ACTIONS(2054),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(2056),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(2054),
    [sym_email_autolink] = ACTIONS(2054),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2058),
    [anon_sym_LT_QMARK] = ACTIONS(2060),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2062),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(2054),
    [sym__digits] = ACTIONS(2054),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(2064),
    [sym__emphasis_open_underscore] = ACTIONS(2066),
    [sym__emphasis_close_star] = ACTIONS(2068),
    [sym__strikethrough_open] = ACTIONS(2070),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(2054),
  },
  [106] = {
    [sym_backslash_escape] = STATE(159),
    [sym_code_span] = STATE(159),
    [sym_latex_block] = STATE(159),
    [sym_image] = STATE(159),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(560),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(159),
    [sym__whitespace] = STATE(159),
    [sym__word] = STATE(159),
    [sym__soft_line_break] = STATE(159),
    [sym__inline_base] = STATE(106),
    [sym__text_base] = STATE(159),
    [sym__inline_element_no_underscore_no_link] = STATE(106),
    [aux_sym__inline_no_underscore_no_link] = STATE(106),
    [sym__strikethrough_no_link] = STATE(106),
    [sym__emphasis_star_no_link] = STATE(605),
    [sym__strong_emphasis_star_no_link] = STATE(106),
    [sym__emphasis_underscore_no_link] = STATE(605),
    [sym__strong_emphasis_underscore_no_link] = STATE(106),
    [aux_sym__inline_base_repeat1] = STATE(159),
    [sym__backslash_escape] = ACTIONS(2072),
    [sym_entity_reference] = ACTIONS(2075),
    [sym_numeric_character_reference] = ACTIONS(2075),
    [anon_sym_LT] = ACTIONS(2078),
    [anon_sym_GT] = ACTIONS(2081),
    [anon_sym_BANG] = ACTIONS(2084),
    [anon_sym_DQUOTE] = ACTIONS(2081),
    [anon_sym_POUND] = ACTIONS(2081),
    [anon_sym_DOLLAR] = ACTIONS(2081),
    [anon_sym_PERCENT] = ACTIONS(2081),
    [anon_sym_AMP] = ACTIONS(2087),
    [anon_sym_SQUOTE] = ACTIONS(2081),
    [anon_sym_STAR] = ACTIONS(2081),
    [anon_sym_PLUS] = ACTIONS(2081),
    [anon_sym_COMMA] = ACTIONS(2081),
    [anon_sym_DASH] = ACTIONS(2081),
    [anon_sym_DOT] = ACTIONS(2081),
    [anon_sym_SLASH] = ACTIONS(2081),
    [anon_sym_COLON] = ACTIONS(2081),
    [anon_sym_SEMI] = ACTIONS(2081),
    [anon_sym_EQ] = ACTIONS(2081),
    [anon_sym_QMARK] = ACTIONS(2081),
    [anon_sym_AT] = ACTIONS(2081),
    [anon_sym_BSLASH] = ACTIONS(2090),
    [anon_sym_CARET] = ACTIONS(2081),
    [anon_sym__] = ACTIONS(2081),
    [anon_sym_BQUOTE] = ACTIONS(2081),
    [anon_sym_LBRACE] = ACTIONS(2081),
    [anon_sym_PIPE] = ACTIONS(2081),
    [anon_sym_RBRACE] = ACTIONS(2081),
    [anon_sym_TILDE] = ACTIONS(2081),
    [anon_sym_LPAREN] = ACTIONS(2081),
    [anon_sym_RPAREN] = ACTIONS(2081),
    [sym__newline_token] = ACTIONS(2093),
    [sym_uri_autolink] = ACTIONS(2075),
    [sym_email_autolink] = ACTIONS(2075),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2096),
    [anon_sym_LT_QMARK] = ACTIONS(2099),
    [aux_sym__declaration_token1] = ACTIONS(2102),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2105),
    [sym__whitespace_ge_2] = ACTIONS(2108),
    [aux_sym__whitespace_token1] = ACTIONS(2111),
    [sym__word_no_digit] = ACTIONS(2075),
    [sym__digits] = ACTIONS(2075),
    [sym__code_span_start] = ACTIONS(2114),
    [sym__emphasis_open_star] = ACTIONS(2117),
    [sym__emphasis_open_underscore] = ACTIONS(2120),
    [sym__emphasis_close_underscore] = ACTIONS(2123),
    [sym__strikethrough_open] = ACTIONS(2125),
    [sym__latex_span_start] = ACTIONS(2128),
    [sym__unclosed_span] = ACTIONS(2075),
  },
  [107] = {
    [sym_backslash_escape] = STATE(159),
    [sym_code_span] = STATE(159),
    [sym_latex_block] = STATE(159),
    [sym_image] = STATE(159),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(560),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(159),
    [sym__whitespace] = STATE(159),
    [sym__word] = STATE(159),
    [sym__soft_line_break] = STATE(159),
    [sym__inline_base] = STATE(106),
    [sym__text_base] = STATE(159),
    [sym__inline_element_no_underscore_no_link] = STATE(106),
    [aux_sym__inline_no_underscore_no_link] = STATE(106),
    [sym__strikethrough_no_link] = STATE(106),
    [sym__emphasis_star_no_link] = STATE(605),
    [sym__strong_emphasis_star_no_link] = STATE(106),
    [sym__emphasis_underscore_no_link] = STATE(605),
    [sym__strong_emphasis_underscore_no_link] = STATE(106),
    [aux_sym__inline_base_repeat1] = STATE(159),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(2131),
    [sym_numeric_character_reference] = ACTIONS(2131),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(2133),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(2131),
    [sym_email_autolink] = ACTIONS(2131),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2135),
    [anon_sym_LT_QMARK] = ACTIONS(2137),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2139),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(2131),
    [sym__digits] = ACTIONS(2131),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(2141),
    [sym__emphasis_open_underscore] = ACTIONS(2143),
    [sym__emphasis_close_underscore] = ACTIONS(2145),
    [sym__strikethrough_open] = ACTIONS(2147),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(2131),
  },
  [108] = {
    [sym_backslash_escape] = STATE(159),
    [sym_code_span] = STATE(159),
    [sym_latex_block] = STATE(159),
    [sym_image] = STATE(159),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(560),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(159),
    [sym__whitespace] = STATE(159),
    [sym__word] = STATE(159),
    [sym__soft_line_break] = STATE(159),
    [sym__inline_base] = STATE(106),
    [sym__text_base] = STATE(159),
    [sym__inline_element_no_underscore_no_link] = STATE(106),
    [aux_sym__inline_no_underscore_no_link] = STATE(106),
    [sym__strikethrough_no_link] = STATE(106),
    [sym__emphasis_star_no_link] = STATE(605),
    [sym__strong_emphasis_star_no_link] = STATE(106),
    [sym__emphasis_underscore_no_link] = STATE(605),
    [sym__strong_emphasis_underscore_no_link] = STATE(106),
    [aux_sym__inline_base_repeat1] = STATE(159),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(2131),
    [sym_numeric_character_reference] = ACTIONS(2131),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(2133),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(2131),
    [sym_email_autolink] = ACTIONS(2131),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2135),
    [anon_sym_LT_QMARK] = ACTIONS(2137),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2139),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(2131),
    [sym__digits] = ACTIONS(2131),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(2141),
    [sym__emphasis_open_underscore] = ACTIONS(2143),
    [sym__emphasis_close_underscore] = ACTIONS(2149),
    [sym__strikethrough_open] = ACTIONS(2147),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(2131),
  },
  [109] = {
    [sym_backslash_escape] = STATE(161),
    [sym_code_span] = STATE(161),
    [sym_latex_block] = STATE(161),
    [sym_image] = STATE(161),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(561),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(161),
    [sym__whitespace] = STATE(161),
    [sym__word] = STATE(161),
    [sym__soft_line_break] = STATE(161),
    [sym__inline_base] = STATE(109),
    [sym__text_base] = STATE(161),
    [sym__inline_element_no_star_no_link] = STATE(109),
    [aux_sym__inline_no_star_no_link] = STATE(109),
    [sym__strikethrough_no_link] = STATE(109),
    [sym__emphasis_star_no_link] = STATE(641),
    [sym__strong_emphasis_star_no_link] = STATE(109),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(109),
    [aux_sym__inline_base_repeat1] = STATE(161),
    [sym__backslash_escape] = ACTIONS(2151),
    [sym_entity_reference] = ACTIONS(2154),
    [sym_numeric_character_reference] = ACTIONS(2154),
    [anon_sym_LT] = ACTIONS(2157),
    [anon_sym_GT] = ACTIONS(2160),
    [anon_sym_BANG] = ACTIONS(2163),
    [anon_sym_DQUOTE] = ACTIONS(2160),
    [anon_sym_POUND] = ACTIONS(2160),
    [anon_sym_DOLLAR] = ACTIONS(2160),
    [anon_sym_PERCENT] = ACTIONS(2160),
    [anon_sym_AMP] = ACTIONS(2166),
    [anon_sym_SQUOTE] = ACTIONS(2160),
    [anon_sym_STAR] = ACTIONS(2160),
    [anon_sym_PLUS] = ACTIONS(2160),
    [anon_sym_COMMA] = ACTIONS(2160),
    [anon_sym_DASH] = ACTIONS(2160),
    [anon_sym_DOT] = ACTIONS(2160),
    [anon_sym_SLASH] = ACTIONS(2160),
    [anon_sym_COLON] = ACTIONS(2160),
    [anon_sym_SEMI] = ACTIONS(2160),
    [anon_sym_EQ] = ACTIONS(2160),
    [anon_sym_QMARK] = ACTIONS(2160),
    [anon_sym_AT] = ACTIONS(2160),
    [anon_sym_BSLASH] = ACTIONS(2169),
    [anon_sym_CARET] = ACTIONS(2160),
    [anon_sym__] = ACTIONS(2160),
    [anon_sym_BQUOTE] = ACTIONS(2160),
    [anon_sym_LBRACE] = ACTIONS(2160),
    [anon_sym_PIPE] = ACTIONS(2160),
    [anon_sym_RBRACE] = ACTIONS(2160),
    [anon_sym_TILDE] = ACTIONS(2160),
    [anon_sym_LPAREN] = ACTIONS(2160),
    [anon_sym_RPAREN] = ACTIONS(2160),
    [sym__newline_token] = ACTIONS(2172),
    [sym_uri_autolink] = ACTIONS(2154),
    [sym_email_autolink] = ACTIONS(2154),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2175),
    [anon_sym_LT_QMARK] = ACTIONS(2178),
    [aux_sym__declaration_token1] = ACTIONS(2181),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2184),
    [sym__whitespace_ge_2] = ACTIONS(2187),
    [aux_sym__whitespace_token1] = ACTIONS(2190),
    [sym__word_no_digit] = ACTIONS(2154),
    [sym__digits] = ACTIONS(2154),
    [sym__code_span_start] = ACTIONS(2193),
    [sym__emphasis_open_star] = ACTIONS(2196),
    [sym__emphasis_open_underscore] = ACTIONS(2199),
    [sym__emphasis_close_star] = ACTIONS(2202),
    [sym__strikethrough_open] = ACTIONS(2204),
    [sym__latex_span_start] = ACTIONS(2207),
    [sym__unclosed_span] = ACTIONS(2154),
  },
  [110] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(120),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(120),
    [aux_sym__inline_no_tilde_no_link] = STATE(120),
    [sym__strikethrough_no_link] = STATE(120),
    [sym__emphasis_star_no_link] = STATE(617),
    [sym__strong_emphasis_star_no_link] = STATE(120),
    [sym__emphasis_underscore_no_link] = STATE(617),
    [sym__strong_emphasis_underscore_no_link] = STATE(120),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2012),
    [sym_numeric_character_reference] = ACTIONS(2012),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2014),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2012),
    [sym_email_autolink] = ACTIONS(2012),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2016),
    [anon_sym_LT_QMARK] = ACTIONS(2018),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2020),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2012),
    [sym__digits] = ACTIONS(2012),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2022),
    [sym__emphasis_open_underscore] = ACTIONS(2024),
    [sym__strikethrough_open] = ACTIONS(2026),
    [sym__strikethrough_close] = ACTIONS(2210),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2012),
  },
  [111] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(120),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(120),
    [aux_sym__inline_no_tilde_no_link] = STATE(120),
    [sym__strikethrough_no_link] = STATE(120),
    [sym__emphasis_star_no_link] = STATE(617),
    [sym__strong_emphasis_star_no_link] = STATE(120),
    [sym__emphasis_underscore_no_link] = STATE(617),
    [sym__strong_emphasis_underscore_no_link] = STATE(120),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2012),
    [sym_numeric_character_reference] = ACTIONS(2012),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2014),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2012),
    [sym_email_autolink] = ACTIONS(2012),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2016),
    [anon_sym_LT_QMARK] = ACTIONS(2018),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2020),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2012),
    [sym__digits] = ACTIONS(2012),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2022),
    [sym__emphasis_open_underscore] = ACTIONS(2024),
    [sym__strikethrough_open] = ACTIONS(2026),
    [sym__strikethrough_close] = ACTIONS(2212),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2012),
  },
  [112] = {
    [sym_backslash_escape] = STATE(159),
    [sym_code_span] = STATE(159),
    [sym_latex_block] = STATE(159),
    [sym_image] = STATE(159),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(560),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(159),
    [sym__whitespace] = STATE(159),
    [sym__word] = STATE(159),
    [sym__soft_line_break] = STATE(159),
    [sym__inline_base] = STATE(106),
    [sym__text_base] = STATE(159),
    [sym__inline_element_no_underscore_no_link] = STATE(106),
    [aux_sym__inline_no_underscore_no_link] = STATE(106),
    [sym__strikethrough_no_link] = STATE(106),
    [sym__emphasis_star_no_link] = STATE(605),
    [sym__strong_emphasis_star_no_link] = STATE(106),
    [sym__emphasis_underscore_no_link] = STATE(605),
    [sym__strong_emphasis_underscore_no_link] = STATE(106),
    [aux_sym__inline_base_repeat1] = STATE(159),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(2131),
    [sym_numeric_character_reference] = ACTIONS(2131),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(2133),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(2131),
    [sym_email_autolink] = ACTIONS(2131),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2135),
    [anon_sym_LT_QMARK] = ACTIONS(2137),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2139),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(2131),
    [sym__digits] = ACTIONS(2131),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(2141),
    [sym__emphasis_open_underscore] = ACTIONS(2143),
    [sym__emphasis_close_underscore] = ACTIONS(2214),
    [sym__strikethrough_open] = ACTIONS(2147),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(2131),
  },
  [113] = {
    [sym_backslash_escape] = STATE(161),
    [sym_code_span] = STATE(161),
    [sym_latex_block] = STATE(161),
    [sym_image] = STATE(161),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(561),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(161),
    [sym__whitespace] = STATE(161),
    [sym__word] = STATE(161),
    [sym__soft_line_break] = STATE(161),
    [sym__inline_base] = STATE(109),
    [sym__text_base] = STATE(161),
    [sym__inline_element_no_star_no_link] = STATE(109),
    [aux_sym__inline_no_star_no_link] = STATE(109),
    [sym__strikethrough_no_link] = STATE(109),
    [sym__emphasis_star_no_link] = STATE(641),
    [sym__strong_emphasis_star_no_link] = STATE(109),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(109),
    [aux_sym__inline_base_repeat1] = STATE(161),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(2054),
    [sym_numeric_character_reference] = ACTIONS(2054),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(2056),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(2054),
    [sym_email_autolink] = ACTIONS(2054),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2058),
    [anon_sym_LT_QMARK] = ACTIONS(2060),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2062),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(2054),
    [sym__digits] = ACTIONS(2054),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(2064),
    [sym__emphasis_open_underscore] = ACTIONS(2066),
    [sym__emphasis_close_star] = ACTIONS(2216),
    [sym__strikethrough_open] = ACTIONS(2070),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(2054),
  },
  [114] = {
    [sym_backslash_escape] = STATE(159),
    [sym_code_span] = STATE(159),
    [sym_latex_block] = STATE(159),
    [sym_image] = STATE(159),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(560),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(159),
    [sym__whitespace] = STATE(159),
    [sym__word] = STATE(159),
    [sym__soft_line_break] = STATE(159),
    [sym__inline_base] = STATE(106),
    [sym__text_base] = STATE(159),
    [sym__inline_element_no_underscore_no_link] = STATE(106),
    [aux_sym__inline_no_underscore_no_link] = STATE(106),
    [sym__strikethrough_no_link] = STATE(106),
    [sym__emphasis_star_no_link] = STATE(605),
    [sym__strong_emphasis_star_no_link] = STATE(106),
    [sym__emphasis_underscore_no_link] = STATE(605),
    [sym__strong_emphasis_underscore_no_link] = STATE(106),
    [aux_sym__inline_base_repeat1] = STATE(159),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(2131),
    [sym_numeric_character_reference] = ACTIONS(2131),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(2133),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(2131),
    [sym_email_autolink] = ACTIONS(2131),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2135),
    [anon_sym_LT_QMARK] = ACTIONS(2137),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2139),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(2131),
    [sym__digits] = ACTIONS(2131),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(2141),
    [sym__emphasis_open_underscore] = ACTIONS(2143),
    [sym__emphasis_close_underscore] = ACTIONS(2218),
    [sym__strikethrough_open] = ACTIONS(2147),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(2131),
  },
  [115] = {
    [sym_backslash_escape] = STATE(159),
    [sym_code_span] = STATE(159),
    [sym_latex_block] = STATE(159),
    [sym_image] = STATE(159),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(560),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(159),
    [sym__whitespace] = STATE(159),
    [sym__word] = STATE(159),
    [sym__soft_line_break] = STATE(159),
    [sym__inline_base] = STATE(106),
    [sym__text_base] = STATE(159),
    [sym__inline_element_no_underscore_no_link] = STATE(106),
    [aux_sym__inline_no_underscore_no_link] = STATE(106),
    [sym__strikethrough_no_link] = STATE(106),
    [sym__emphasis_star_no_link] = STATE(605),
    [sym__strong_emphasis_star_no_link] = STATE(106),
    [sym__emphasis_underscore_no_link] = STATE(605),
    [sym__strong_emphasis_underscore_no_link] = STATE(106),
    [aux_sym__inline_base_repeat1] = STATE(159),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(2131),
    [sym_numeric_character_reference] = ACTIONS(2131),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(2133),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(2131),
    [sym_email_autolink] = ACTIONS(2131),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2135),
    [anon_sym_LT_QMARK] = ACTIONS(2137),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2139),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(2131),
    [sym__digits] = ACTIONS(2131),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(2141),
    [sym__emphasis_open_underscore] = ACTIONS(2143),
    [sym__emphasis_close_underscore] = ACTIONS(2220),
    [sym__strikethrough_open] = ACTIONS(2147),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(2131),
  },
  [116] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(120),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(120),
    [aux_sym__inline_no_tilde_no_link] = STATE(120),
    [sym__strikethrough_no_link] = STATE(120),
    [sym__emphasis_star_no_link] = STATE(617),
    [sym__strong_emphasis_star_no_link] = STATE(120),
    [sym__emphasis_underscore_no_link] = STATE(617),
    [sym__strong_emphasis_underscore_no_link] = STATE(120),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2012),
    [sym_numeric_character_reference] = ACTIONS(2012),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2014),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2012),
    [sym_email_autolink] = ACTIONS(2012),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2016),
    [anon_sym_LT_QMARK] = ACTIONS(2018),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2020),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2012),
    [sym__digits] = ACTIONS(2012),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2022),
    [sym__emphasis_open_underscore] = ACTIONS(2024),
    [sym__strikethrough_open] = ACTIONS(2026),
    [sym__strikethrough_close] = ACTIONS(2222),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2012),
  },
  [117] = {
    [sym_backslash_escape] = STATE(161),
    [sym_code_span] = STATE(161),
    [sym_latex_block] = STATE(161),
    [sym_image] = STATE(161),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(561),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(161),
    [sym__whitespace] = STATE(161),
    [sym__word] = STATE(161),
    [sym__soft_line_break] = STATE(161),
    [sym__inline_base] = STATE(118),
    [sym__text_base] = STATE(161),
    [sym__inline_element_no_star_no_link] = STATE(118),
    [aux_sym__inline_no_star_no_link] = STATE(118),
    [sym__strikethrough_no_link] = STATE(118),
    [sym__emphasis_star_no_link] = STATE(620),
    [sym__strong_emphasis_star_no_link] = STATE(118),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(118),
    [aux_sym__inline_base_repeat1] = STATE(161),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(2054),
    [sym_numeric_character_reference] = ACTIONS(2054),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(2056),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(2054),
    [sym_email_autolink] = ACTIONS(2054),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2058),
    [anon_sym_LT_QMARK] = ACTIONS(2060),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2062),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(2054),
    [sym__digits] = ACTIONS(2054),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(2064),
    [sym__emphasis_open_underscore] = ACTIONS(2066),
    [sym__last_token_punctuation] = ACTIONS(2224),
    [sym__strikethrough_open] = ACTIONS(2070),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(2054),
  },
  [118] = {
    [sym_backslash_escape] = STATE(161),
    [sym_code_span] = STATE(161),
    [sym_latex_block] = STATE(161),
    [sym_image] = STATE(161),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(561),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(161),
    [sym__whitespace] = STATE(161),
    [sym__word] = STATE(161),
    [sym__soft_line_break] = STATE(161),
    [sym__inline_base] = STATE(109),
    [sym__text_base] = STATE(161),
    [sym__inline_element_no_star_no_link] = STATE(109),
    [aux_sym__inline_no_star_no_link] = STATE(109),
    [sym__strikethrough_no_link] = STATE(109),
    [sym__emphasis_star_no_link] = STATE(641),
    [sym__strong_emphasis_star_no_link] = STATE(109),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(109),
    [aux_sym__inline_base_repeat1] = STATE(161),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(2054),
    [sym_numeric_character_reference] = ACTIONS(2054),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(2056),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(2054),
    [sym_email_autolink] = ACTIONS(2054),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2058),
    [anon_sym_LT_QMARK] = ACTIONS(2060),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2062),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(2054),
    [sym__digits] = ACTIONS(2054),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(2064),
    [sym__emphasis_open_underscore] = ACTIONS(2066),
    [sym__emphasis_close_star] = ACTIONS(2226),
    [sym__strikethrough_open] = ACTIONS(2070),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(2054),
  },
  [119] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(615),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_link] = STATE(615),
    [aux_sym__inline_no_link] = STATE(133),
    [sym__strikethrough_no_link] = STATE(615),
    [sym__emphasis_star_no_link] = STATE(616),
    [sym__strong_emphasis_star_no_link] = STATE(615),
    [sym__emphasis_underscore_no_link] = STATE(616),
    [sym__strong_emphasis_underscore_no_link] = STATE(615),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(2036),
    [sym_numeric_character_reference] = ACTIONS(2036),
    [anon_sym_RBRACK] = ACTIONS(2228),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(2040),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(2036),
    [sym_email_autolink] = ACTIONS(2036),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2042),
    [anon_sym_LT_QMARK] = ACTIONS(2044),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2046),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(2036),
    [sym__digits] = ACTIONS(2036),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(2048),
    [sym__emphasis_open_underscore] = ACTIONS(2050),
    [sym__strikethrough_open] = ACTIONS(2052),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(2036),
  },
  [120] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(120),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(120),
    [aux_sym__inline_no_tilde_no_link] = STATE(120),
    [sym__strikethrough_no_link] = STATE(120),
    [sym__emphasis_star_no_link] = STATE(617),
    [sym__strong_emphasis_star_no_link] = STATE(120),
    [sym__emphasis_underscore_no_link] = STATE(617),
    [sym__strong_emphasis_underscore_no_link] = STATE(120),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(2230),
    [sym_entity_reference] = ACTIONS(2233),
    [sym_numeric_character_reference] = ACTIONS(2233),
    [anon_sym_LT] = ACTIONS(2236),
    [anon_sym_GT] = ACTIONS(2239),
    [anon_sym_BANG] = ACTIONS(2242),
    [anon_sym_DQUOTE] = ACTIONS(2239),
    [anon_sym_POUND] = ACTIONS(2239),
    [anon_sym_DOLLAR] = ACTIONS(2239),
    [anon_sym_PERCENT] = ACTIONS(2239),
    [anon_sym_AMP] = ACTIONS(2245),
    [anon_sym_SQUOTE] = ACTIONS(2239),
    [anon_sym_STAR] = ACTIONS(2239),
    [anon_sym_PLUS] = ACTIONS(2239),
    [anon_sym_COMMA] = ACTIONS(2239),
    [anon_sym_DASH] = ACTIONS(2239),
    [anon_sym_DOT] = ACTIONS(2239),
    [anon_sym_SLASH] = ACTIONS(2239),
    [anon_sym_COLON] = ACTIONS(2239),
    [anon_sym_SEMI] = ACTIONS(2239),
    [anon_sym_EQ] = ACTIONS(2239),
    [anon_sym_QMARK] = ACTIONS(2239),
    [anon_sym_AT] = ACTIONS(2239),
    [anon_sym_BSLASH] = ACTIONS(2248),
    [anon_sym_CARET] = ACTIONS(2239),
    [anon_sym__] = ACTIONS(2239),
    [anon_sym_BQUOTE] = ACTIONS(2239),
    [anon_sym_LBRACE] = ACTIONS(2239),
    [anon_sym_PIPE] = ACTIONS(2239),
    [anon_sym_RBRACE] = ACTIONS(2239),
    [anon_sym_TILDE] = ACTIONS(2239),
    [anon_sym_LPAREN] = ACTIONS(2239),
    [anon_sym_RPAREN] = ACTIONS(2239),
    [sym__newline_token] = ACTIONS(2251),
    [sym_uri_autolink] = ACTIONS(2233),
    [sym_email_autolink] = ACTIONS(2233),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2254),
    [anon_sym_LT_QMARK] = ACTIONS(2257),
    [aux_sym__declaration_token1] = ACTIONS(2260),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2263),
    [sym__whitespace_ge_2] = ACTIONS(2266),
    [aux_sym__whitespace_token1] = ACTIONS(2269),
    [sym__word_no_digit] = ACTIONS(2233),
    [sym__digits] = ACTIONS(2233),
    [sym__code_span_start] = ACTIONS(2272),
    [sym__emphasis_open_star] = ACTIONS(2275),
    [sym__emphasis_open_underscore] = ACTIONS(2278),
    [sym__strikethrough_open] = ACTIONS(2281),
    [sym__strikethrough_close] = ACTIONS(2284),
    [sym__latex_span_start] = ACTIONS(2286),
    [sym__unclosed_span] = ACTIONS(2233),
  },
  [121] = {
    [sym_backslash_escape] = STATE(161),
    [sym_code_span] = STATE(161),
    [sym_latex_block] = STATE(161),
    [sym_image] = STATE(161),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(561),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(161),
    [sym__whitespace] = STATE(161),
    [sym__word] = STATE(161),
    [sym__soft_line_break] = STATE(161),
    [sym__inline_base] = STATE(109),
    [sym__text_base] = STATE(161),
    [sym__inline_element_no_star_no_link] = STATE(109),
    [aux_sym__inline_no_star_no_link] = STATE(109),
    [sym__strikethrough_no_link] = STATE(109),
    [sym__emphasis_star_no_link] = STATE(641),
    [sym__strong_emphasis_star_no_link] = STATE(109),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(109),
    [aux_sym__inline_base_repeat1] = STATE(161),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(2054),
    [sym_numeric_character_reference] = ACTIONS(2054),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(2056),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(2054),
    [sym_email_autolink] = ACTIONS(2054),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2058),
    [anon_sym_LT_QMARK] = ACTIONS(2060),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2062),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(2054),
    [sym__digits] = ACTIONS(2054),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(2064),
    [sym__emphasis_open_underscore] = ACTIONS(2066),
    [sym__emphasis_close_star] = ACTIONS(2289),
    [sym__strikethrough_open] = ACTIONS(2070),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(2054),
  },
  [122] = {
    [sym_backslash_escape] = STATE(161),
    [sym_code_span] = STATE(161),
    [sym_latex_block] = STATE(161),
    [sym_image] = STATE(161),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(561),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(161),
    [sym__whitespace] = STATE(161),
    [sym__word] = STATE(161),
    [sym__soft_line_break] = STATE(161),
    [sym__inline_base] = STATE(109),
    [sym__text_base] = STATE(161),
    [sym__inline_element_no_star_no_link] = STATE(109),
    [aux_sym__inline_no_star_no_link] = STATE(109),
    [sym__strikethrough_no_link] = STATE(109),
    [sym__emphasis_star_no_link] = STATE(641),
    [sym__strong_emphasis_star_no_link] = STATE(109),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(109),
    [aux_sym__inline_base_repeat1] = STATE(161),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(2054),
    [sym_numeric_character_reference] = ACTIONS(2054),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(2056),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(2054),
    [sym_email_autolink] = ACTIONS(2054),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2058),
    [anon_sym_LT_QMARK] = ACTIONS(2060),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2062),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(2054),
    [sym__digits] = ACTIONS(2054),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(2064),
    [sym__emphasis_open_underscore] = ACTIONS(2066),
    [sym__emphasis_close_star] = ACTIONS(2291),
    [sym__strikethrough_open] = ACTIONS(2070),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(2054),
  },
  [123] = {
    [sym_backslash_escape] = STATE(159),
    [sym_code_span] = STATE(159),
    [sym_latex_block] = STATE(159),
    [sym_image] = STATE(159),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(560),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(159),
    [sym__whitespace] = STATE(159),
    [sym__word] = STATE(159),
    [sym__soft_line_break] = STATE(159),
    [sym__inline_base] = STATE(106),
    [sym__text_base] = STATE(159),
    [sym__inline_element_no_underscore_no_link] = STATE(106),
    [aux_sym__inline_no_underscore_no_link] = STATE(106),
    [sym__strikethrough_no_link] = STATE(106),
    [sym__emphasis_star_no_link] = STATE(605),
    [sym__strong_emphasis_star_no_link] = STATE(106),
    [sym__emphasis_underscore_no_link] = STATE(605),
    [sym__strong_emphasis_underscore_no_link] = STATE(106),
    [aux_sym__inline_base_repeat1] = STATE(159),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(2131),
    [sym_numeric_character_reference] = ACTIONS(2131),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(2133),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(2131),
    [sym_email_autolink] = ACTIONS(2131),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2135),
    [anon_sym_LT_QMARK] = ACTIONS(2137),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2139),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(2131),
    [sym__digits] = ACTIONS(2131),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(2141),
    [sym__emphasis_open_underscore] = ACTIONS(2143),
    [sym__emphasis_close_underscore] = ACTIONS(2293),
    [sym__strikethrough_open] = ACTIONS(2147),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(2131),
  },
  [124] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(615),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_link] = STATE(615),
    [aux_sym__inline_no_link] = STATE(133),
    [sym__strikethrough_no_link] = STATE(615),
    [sym__emphasis_star_no_link] = STATE(616),
    [sym__strong_emphasis_star_no_link] = STATE(615),
    [sym__emphasis_underscore_no_link] = STATE(616),
    [sym__strong_emphasis_underscore_no_link] = STATE(615),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(2036),
    [sym_numeric_character_reference] = ACTIONS(2036),
    [anon_sym_RBRACK] = ACTIONS(2295),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(2040),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(2036),
    [sym_email_autolink] = ACTIONS(2036),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2042),
    [anon_sym_LT_QMARK] = ACTIONS(2044),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2046),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(2036),
    [sym__digits] = ACTIONS(2036),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(2048),
    [sym__emphasis_open_underscore] = ACTIONS(2050),
    [sym__strikethrough_open] = ACTIONS(2052),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(2036),
  },
  [125] = {
    [sym_backslash_escape] = STATE(159),
    [sym_code_span] = STATE(159),
    [sym_latex_block] = STATE(159),
    [sym_image] = STATE(159),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(560),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(159),
    [sym__whitespace] = STATE(159),
    [sym__word] = STATE(159),
    [sym__soft_line_break] = STATE(159),
    [sym__inline_base] = STATE(107),
    [sym__text_base] = STATE(159),
    [sym__inline_element_no_underscore_no_link] = STATE(107),
    [aux_sym__inline_no_underscore_no_link] = STATE(107),
    [sym__strikethrough_no_link] = STATE(107),
    [sym__emphasis_star_no_link] = STATE(605),
    [sym__strong_emphasis_star_no_link] = STATE(107),
    [sym__emphasis_underscore_no_link] = STATE(635),
    [sym__strong_emphasis_underscore_no_link] = STATE(107),
    [aux_sym__inline_base_repeat1] = STATE(159),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(2131),
    [sym_numeric_character_reference] = ACTIONS(2131),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(2133),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(2131),
    [sym_email_autolink] = ACTIONS(2131),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2135),
    [anon_sym_LT_QMARK] = ACTIONS(2137),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2139),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(2131),
    [sym__digits] = ACTIONS(2131),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(2141),
    [sym__emphasis_open_underscore] = ACTIONS(2143),
    [sym__last_token_punctuation] = ACTIONS(2297),
    [sym__strikethrough_open] = ACTIONS(2147),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(2131),
  },
  [126] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(120),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(120),
    [aux_sym__inline_no_tilde_no_link] = STATE(120),
    [sym__strikethrough_no_link] = STATE(120),
    [sym__emphasis_star_no_link] = STATE(617),
    [sym__strong_emphasis_star_no_link] = STATE(120),
    [sym__emphasis_underscore_no_link] = STATE(617),
    [sym__strong_emphasis_underscore_no_link] = STATE(120),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2012),
    [sym_numeric_character_reference] = ACTIONS(2012),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2014),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2012),
    [sym_email_autolink] = ACTIONS(2012),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2016),
    [anon_sym_LT_QMARK] = ACTIONS(2018),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2020),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2012),
    [sym__digits] = ACTIONS(2012),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2022),
    [sym__emphasis_open_underscore] = ACTIONS(2024),
    [sym__strikethrough_open] = ACTIONS(2026),
    [sym__strikethrough_close] = ACTIONS(2299),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2012),
  },
  [127] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(615),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_link] = STATE(615),
    [aux_sym__inline_no_link] = STATE(133),
    [sym__strikethrough_no_link] = STATE(615),
    [sym__emphasis_star_no_link] = STATE(616),
    [sym__strong_emphasis_star_no_link] = STATE(615),
    [sym__emphasis_underscore_no_link] = STATE(616),
    [sym__strong_emphasis_underscore_no_link] = STATE(615),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(2036),
    [sym_numeric_character_reference] = ACTIONS(2036),
    [anon_sym_RBRACK] = ACTIONS(2301),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(2040),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(2036),
    [sym_email_autolink] = ACTIONS(2036),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2042),
    [anon_sym_LT_QMARK] = ACTIONS(2044),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2046),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(2036),
    [sym__digits] = ACTIONS(2036),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(2048),
    [sym__emphasis_open_underscore] = ACTIONS(2050),
    [sym__strikethrough_open] = ACTIONS(2052),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(2036),
  },
  [128] = {
    [sym_backslash_escape] = STATE(159),
    [sym_code_span] = STATE(159),
    [sym_latex_block] = STATE(159),
    [sym_image] = STATE(159),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(560),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(159),
    [sym__whitespace] = STATE(159),
    [sym__word] = STATE(159),
    [sym__soft_line_break] = STATE(159),
    [sym__inline_base] = STATE(106),
    [sym__text_base] = STATE(159),
    [sym__inline_element_no_underscore_no_link] = STATE(106),
    [aux_sym__inline_no_underscore_no_link] = STATE(106),
    [sym__strikethrough_no_link] = STATE(106),
    [sym__emphasis_star_no_link] = STATE(605),
    [sym__strong_emphasis_star_no_link] = STATE(106),
    [sym__emphasis_underscore_no_link] = STATE(605),
    [sym__strong_emphasis_underscore_no_link] = STATE(106),
    [aux_sym__inline_base_repeat1] = STATE(159),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(2131),
    [sym_numeric_character_reference] = ACTIONS(2131),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(2133),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(2131),
    [sym_email_autolink] = ACTIONS(2131),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2135),
    [anon_sym_LT_QMARK] = ACTIONS(2137),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2139),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(2131),
    [sym__digits] = ACTIONS(2131),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(2141),
    [sym__emphasis_open_underscore] = ACTIONS(2143),
    [sym__emphasis_close_underscore] = ACTIONS(2303),
    [sym__strikethrough_open] = ACTIONS(2147),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(2131),
  },
  [129] = {
    [sym_backslash_escape] = STATE(161),
    [sym_code_span] = STATE(161),
    [sym_latex_block] = STATE(161),
    [sym_image] = STATE(161),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(561),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(161),
    [sym__whitespace] = STATE(161),
    [sym__word] = STATE(161),
    [sym__soft_line_break] = STATE(161),
    [sym__inline_base] = STATE(109),
    [sym__text_base] = STATE(161),
    [sym__inline_element_no_star_no_link] = STATE(109),
    [aux_sym__inline_no_star_no_link] = STATE(109),
    [sym__strikethrough_no_link] = STATE(109),
    [sym__emphasis_star_no_link] = STATE(641),
    [sym__strong_emphasis_star_no_link] = STATE(109),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(109),
    [aux_sym__inline_base_repeat1] = STATE(161),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(2054),
    [sym_numeric_character_reference] = ACTIONS(2054),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(2056),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(2054),
    [sym_email_autolink] = ACTIONS(2054),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2058),
    [anon_sym_LT_QMARK] = ACTIONS(2060),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2062),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(2054),
    [sym__digits] = ACTIONS(2054),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(2064),
    [sym__emphasis_open_underscore] = ACTIONS(2066),
    [sym__emphasis_close_star] = ACTIONS(2305),
    [sym__strikethrough_open] = ACTIONS(2070),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(2054),
  },
  [130] = {
    [sym_backslash_escape] = STATE(159),
    [sym_code_span] = STATE(159),
    [sym_latex_block] = STATE(159),
    [sym_image] = STATE(159),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(560),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(159),
    [sym__whitespace] = STATE(159),
    [sym__word] = STATE(159),
    [sym__soft_line_break] = STATE(159),
    [sym__inline_base] = STATE(106),
    [sym__text_base] = STATE(159),
    [sym__inline_element_no_underscore_no_link] = STATE(106),
    [aux_sym__inline_no_underscore_no_link] = STATE(106),
    [sym__strikethrough_no_link] = STATE(106),
    [sym__emphasis_star_no_link] = STATE(605),
    [sym__strong_emphasis_star_no_link] = STATE(106),
    [sym__emphasis_underscore_no_link] = STATE(605),
    [sym__strong_emphasis_underscore_no_link] = STATE(106),
    [aux_sym__inline_base_repeat1] = STATE(159),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(2131),
    [sym_numeric_character_reference] = ACTIONS(2131),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(2133),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(2131),
    [sym_email_autolink] = ACTIONS(2131),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2135),
    [anon_sym_LT_QMARK] = ACTIONS(2137),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2139),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(2131),
    [sym__digits] = ACTIONS(2131),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(2141),
    [sym__emphasis_open_underscore] = ACTIONS(2143),
    [sym__emphasis_close_underscore] = ACTIONS(2307),
    [sym__strikethrough_open] = ACTIONS(2147),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(2131),
  },
  [131] = {
    [sym_backslash_escape] = STATE(161),
    [sym_code_span] = STATE(161),
    [sym_latex_block] = STATE(161),
    [sym_image] = STATE(161),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(561),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(161),
    [sym__whitespace] = STATE(161),
    [sym__word] = STATE(161),
    [sym__soft_line_break] = STATE(161),
    [sym__inline_base] = STATE(109),
    [sym__text_base] = STATE(161),
    [sym__inline_element_no_star_no_link] = STATE(109),
    [aux_sym__inline_no_star_no_link] = STATE(109),
    [sym__strikethrough_no_link] = STATE(109),
    [sym__emphasis_star_no_link] = STATE(641),
    [sym__strong_emphasis_star_no_link] = STATE(109),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(109),
    [aux_sym__inline_base_repeat1] = STATE(161),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(2054),
    [sym_numeric_character_reference] = ACTIONS(2054),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(2056),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(2054),
    [sym_email_autolink] = ACTIONS(2054),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2058),
    [anon_sym_LT_QMARK] = ACTIONS(2060),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2062),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(2054),
    [sym__digits] = ACTIONS(2054),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(2064),
    [sym__emphasis_open_underscore] = ACTIONS(2066),
    [sym__emphasis_close_star] = ACTIONS(2309),
    [sym__strikethrough_open] = ACTIONS(2070),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(2054),
  },
  [132] = {
    [sym_backslash_escape] = STATE(161),
    [sym_code_span] = STATE(161),
    [sym_latex_block] = STATE(161),
    [sym_image] = STATE(161),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(561),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(161),
    [sym__whitespace] = STATE(161),
    [sym__word] = STATE(161),
    [sym__soft_line_break] = STATE(161),
    [sym__inline_base] = STATE(109),
    [sym__text_base] = STATE(161),
    [sym__inline_element_no_star_no_link] = STATE(109),
    [aux_sym__inline_no_star_no_link] = STATE(109),
    [sym__strikethrough_no_link] = STATE(109),
    [sym__emphasis_star_no_link] = STATE(641),
    [sym__strong_emphasis_star_no_link] = STATE(109),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(109),
    [aux_sym__inline_base_repeat1] = STATE(161),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(2054),
    [sym_numeric_character_reference] = ACTIONS(2054),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(2056),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(2054),
    [sym_email_autolink] = ACTIONS(2054),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2058),
    [anon_sym_LT_QMARK] = ACTIONS(2060),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2062),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(2054),
    [sym__digits] = ACTIONS(2054),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(2064),
    [sym__emphasis_open_underscore] = ACTIONS(2066),
    [sym__emphasis_close_star] = ACTIONS(2311),
    [sym__strikethrough_open] = ACTIONS(2070),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(2054),
  },
  [133] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(615),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_link] = STATE(615),
    [aux_sym__inline_no_link] = STATE(133),
    [sym__strikethrough_no_link] = STATE(615),
    [sym__emphasis_star_no_link] = STATE(616),
    [sym__strong_emphasis_star_no_link] = STATE(615),
    [sym__emphasis_underscore_no_link] = STATE(616),
    [sym__strong_emphasis_underscore_no_link] = STATE(615),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(2313),
    [sym_entity_reference] = ACTIONS(2316),
    [sym_numeric_character_reference] = ACTIONS(2316),
    [anon_sym_RBRACK] = ACTIONS(2319),
    [anon_sym_LT] = ACTIONS(2321),
    [anon_sym_GT] = ACTIONS(2324),
    [anon_sym_BANG] = ACTIONS(2327),
    [anon_sym_DQUOTE] = ACTIONS(2324),
    [anon_sym_POUND] = ACTIONS(2324),
    [anon_sym_DOLLAR] = ACTIONS(2324),
    [anon_sym_PERCENT] = ACTIONS(2324),
    [anon_sym_AMP] = ACTIONS(2330),
    [anon_sym_SQUOTE] = ACTIONS(2324),
    [anon_sym_STAR] = ACTIONS(2324),
    [anon_sym_PLUS] = ACTIONS(2324),
    [anon_sym_COMMA] = ACTIONS(2324),
    [anon_sym_DASH] = ACTIONS(2324),
    [anon_sym_DOT] = ACTIONS(2324),
    [anon_sym_SLASH] = ACTIONS(2324),
    [anon_sym_COLON] = ACTIONS(2324),
    [anon_sym_SEMI] = ACTIONS(2324),
    [anon_sym_EQ] = ACTIONS(2324),
    [anon_sym_QMARK] = ACTIONS(2324),
    [anon_sym_AT] = ACTIONS(2324),
    [anon_sym_BSLASH] = ACTIONS(2333),
    [anon_sym_CARET] = ACTIONS(2324),
    [anon_sym__] = ACTIONS(2324),
    [anon_sym_BQUOTE] = ACTIONS(2324),
    [anon_sym_LBRACE] = ACTIONS(2324),
    [anon_sym_PIPE] = ACTIONS(2324),
    [anon_sym_RBRACE] = ACTIONS(2324),
    [anon_sym_TILDE] = ACTIONS(2324),
    [anon_sym_LPAREN] = ACTIONS(2324),
    [anon_sym_RPAREN] = ACTIONS(2324),
    [sym__newline_token] = ACTIONS(2336),
    [sym_uri_autolink] = ACTIONS(2316),
    [sym_email_autolink] = ACTIONS(2316),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2339),
    [anon_sym_LT_QMARK] = ACTIONS(2342),
    [aux_sym__declaration_token1] = ACTIONS(2345),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2348),
    [sym__whitespace_ge_2] = ACTIONS(2351),
    [aux_sym__whitespace_token1] = ACTIONS(2354),
    [sym__word_no_digit] = ACTIONS(2316),
    [sym__digits] = ACTIONS(2316),
    [sym__code_span_start] = ACTIONS(2357),
    [sym__emphasis_open_star] = ACTIONS(2360),
    [sym__emphasis_open_underscore] = ACTIONS(2363),
    [sym__strikethrough_open] = ACTIONS(2366),
    [sym__latex_span_start] = ACTIONS(2369),
    [sym__unclosed_span] = ACTIONS(2316),
  },
  [134] = {
    [sym_backslash_escape] = STATE(163),
    [sym_code_span] = STATE(163),
    [sym_latex_block] = STATE(163),
    [sym_image] = STATE(163),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(163),
    [sym__whitespace] = STATE(163),
    [sym__word] = STATE(163),
    [sym__soft_line_break] = STATE(163),
    [sym__inline_base] = STATE(615),
    [sym__text_base] = STATE(163),
    [sym__inline_element_no_link] = STATE(615),
    [aux_sym__inline_no_link] = STATE(133),
    [sym__strikethrough_no_link] = STATE(615),
    [sym__emphasis_star_no_link] = STATE(616),
    [sym__strong_emphasis_star_no_link] = STATE(615),
    [sym__emphasis_underscore_no_link] = STATE(616),
    [sym__strong_emphasis_underscore_no_link] = STATE(615),
    [aux_sym__inline_base_repeat1] = STATE(163),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(2036),
    [sym_numeric_character_reference] = ACTIONS(2036),
    [anon_sym_RBRACK] = ACTIONS(2372),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(2040),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(2036),
    [sym_email_autolink] = ACTIONS(2036),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2042),
    [anon_sym_LT_QMARK] = ACTIONS(2044),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2046),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(2036),
    [sym__digits] = ACTIONS(2036),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(2048),
    [sym__emphasis_open_underscore] = ACTIONS(2050),
    [sym__strikethrough_open] = ACTIONS(2052),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(2036),
  },
  [135] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(120),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(120),
    [aux_sym__inline_no_tilde_no_link] = STATE(120),
    [sym__strikethrough_no_link] = STATE(120),
    [sym__emphasis_star_no_link] = STATE(617),
    [sym__strong_emphasis_star_no_link] = STATE(120),
    [sym__emphasis_underscore_no_link] = STATE(617),
    [sym__strong_emphasis_underscore_no_link] = STATE(120),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2012),
    [sym_numeric_character_reference] = ACTIONS(2012),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2014),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2012),
    [sym_email_autolink] = ACTIONS(2012),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2016),
    [anon_sym_LT_QMARK] = ACTIONS(2018),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2020),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2012),
    [sym__digits] = ACTIONS(2012),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2022),
    [sym__emphasis_open_underscore] = ACTIONS(2024),
    [sym__strikethrough_open] = ACTIONS(2026),
    [sym__strikethrough_close] = ACTIONS(2374),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2012),
  },
  [136] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(103),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(103),
    [aux_sym__inline_no_tilde_no_link] = STATE(103),
    [sym__strikethrough_no_link] = STATE(103),
    [sym__emphasis_star_no_link] = STATE(617),
    [sym__strong_emphasis_star_no_link] = STATE(103),
    [sym__emphasis_underscore_no_link] = STATE(617),
    [sym__strong_emphasis_underscore_no_link] = STATE(103),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2012),
    [sym_numeric_character_reference] = ACTIONS(2012),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2014),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2012),
    [sym_email_autolink] = ACTIONS(2012),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2016),
    [anon_sym_LT_QMARK] = ACTIONS(2018),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2020),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2012),
    [sym__digits] = ACTIONS(2012),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2022),
    [sym__emphasis_open_underscore] = ACTIONS(2024),
    [sym__strikethrough_open] = ACTIONS(2026),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2012),
  },
  [137] = {
    [sym_backslash_escape] = STATE(159),
    [sym_code_span] = STATE(159),
    [sym_latex_block] = STATE(159),
    [sym_image] = STATE(159),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(560),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(159),
    [sym__whitespace] = STATE(159),
    [sym__word] = STATE(159),
    [sym__soft_line_break] = STATE(159),
    [sym__inline_base] = STATE(108),
    [sym__text_base] = STATE(159),
    [sym__inline_element_no_underscore_no_link] = STATE(108),
    [aux_sym__inline_no_underscore_no_link] = STATE(108),
    [sym__strikethrough_no_link] = STATE(108),
    [sym__emphasis_star_no_link] = STATE(605),
    [sym__strong_emphasis_star_no_link] = STATE(108),
    [sym__emphasis_underscore_no_link] = STATE(605),
    [sym__strong_emphasis_underscore_no_link] = STATE(108),
    [aux_sym__inline_base_repeat1] = STATE(159),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(2131),
    [sym_numeric_character_reference] = ACTIONS(2131),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(2133),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(2131),
    [sym_email_autolink] = ACTIONS(2131),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2135),
    [anon_sym_LT_QMARK] = ACTIONS(2137),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2139),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(2131),
    [sym__digits] = ACTIONS(2131),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(2141),
    [sym__emphasis_open_underscore] = ACTIONS(2143),
    [sym__strikethrough_open] = ACTIONS(2147),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(2131),
  },
  [138] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(116),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(116),
    [aux_sym__inline_no_tilde_no_link] = STATE(116),
    [sym__strikethrough_no_link] = STATE(116),
    [sym__emphasis_star_no_link] = STATE(617),
    [sym__strong_emphasis_star_no_link] = STATE(116),
    [sym__emphasis_underscore_no_link] = STATE(617),
    [sym__strong_emphasis_underscore_no_link] = STATE(116),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2012),
    [sym_numeric_character_reference] = ACTIONS(2012),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2014),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2012),
    [sym_email_autolink] = ACTIONS(2012),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2016),
    [anon_sym_LT_QMARK] = ACTIONS(2018),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2020),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2012),
    [sym__digits] = ACTIONS(2012),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2022),
    [sym__emphasis_open_underscore] = ACTIONS(2024),
    [sym__strikethrough_open] = ACTIONS(2026),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2012),
  },
  [139] = {
    [sym_backslash_escape] = STATE(159),
    [sym_code_span] = STATE(159),
    [sym_latex_block] = STATE(159),
    [sym_image] = STATE(159),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(560),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(159),
    [sym__whitespace] = STATE(159),
    [sym__word] = STATE(159),
    [sym__soft_line_break] = STATE(159),
    [sym__inline_base] = STATE(115),
    [sym__text_base] = STATE(159),
    [sym__inline_element_no_underscore_no_link] = STATE(115),
    [aux_sym__inline_no_underscore_no_link] = STATE(115),
    [sym__strikethrough_no_link] = STATE(115),
    [sym__emphasis_star_no_link] = STATE(605),
    [sym__strong_emphasis_star_no_link] = STATE(115),
    [sym__emphasis_underscore_no_link] = STATE(605),
    [sym__strong_emphasis_underscore_no_link] = STATE(115),
    [aux_sym__inline_base_repeat1] = STATE(159),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(2131),
    [sym_numeric_character_reference] = ACTIONS(2131),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(2133),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(2131),
    [sym_email_autolink] = ACTIONS(2131),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2135),
    [anon_sym_LT_QMARK] = ACTIONS(2137),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2139),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(2131),
    [sym__digits] = ACTIONS(2131),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(2141),
    [sym__emphasis_open_underscore] = ACTIONS(2143),
    [sym__strikethrough_open] = ACTIONS(2147),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(2131),
  },
  [140] = {
    [sym_backslash_escape] = STATE(161),
    [sym_code_span] = STATE(161),
    [sym_latex_block] = STATE(161),
    [sym_image] = STATE(161),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(561),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(161),
    [sym__whitespace] = STATE(161),
    [sym__word] = STATE(161),
    [sym__soft_line_break] = STATE(161),
    [sym__inline_base] = STATE(105),
    [sym__text_base] = STATE(161),
    [sym__inline_element_no_star_no_link] = STATE(105),
    [aux_sym__inline_no_star_no_link] = STATE(105),
    [sym__strikethrough_no_link] = STATE(105),
    [sym__emphasis_star_no_link] = STATE(641),
    [sym__strong_emphasis_star_no_link] = STATE(105),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(105),
    [aux_sym__inline_base_repeat1] = STATE(161),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(2054),
    [sym_numeric_character_reference] = ACTIONS(2054),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(2056),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(2054),
    [sym_email_autolink] = ACTIONS(2054),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2058),
    [anon_sym_LT_QMARK] = ACTIONS(2060),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2062),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(2054),
    [sym__digits] = ACTIONS(2054),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(2064),
    [sym__emphasis_open_underscore] = ACTIONS(2066),
    [sym__strikethrough_open] = ACTIONS(2070),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(2054),
  },
  [141] = {
    [sym_backslash_escape] = STATE(161),
    [sym_code_span] = STATE(161),
    [sym_latex_block] = STATE(161),
    [sym_image] = STATE(161),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(561),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(161),
    [sym__whitespace] = STATE(161),
    [sym__word] = STATE(161),
    [sym__soft_line_break] = STATE(161),
    [sym__inline_base] = STATE(113),
    [sym__text_base] = STATE(161),
    [sym__inline_element_no_star_no_link] = STATE(113),
    [aux_sym__inline_no_star_no_link] = STATE(113),
    [sym__strikethrough_no_link] = STATE(113),
    [sym__emphasis_star_no_link] = STATE(641),
    [sym__strong_emphasis_star_no_link] = STATE(113),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(113),
    [aux_sym__inline_base_repeat1] = STATE(161),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(2054),
    [sym_numeric_character_reference] = ACTIONS(2054),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(2056),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(2054),
    [sym_email_autolink] = ACTIONS(2054),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2058),
    [anon_sym_LT_QMARK] = ACTIONS(2060),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2062),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(2054),
    [sym__digits] = ACTIONS(2054),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(2064),
    [sym__emphasis_open_underscore] = ACTIONS(2066),
    [sym__strikethrough_open] = ACTIONS(2070),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(2054),
  },
  [142] = {
    [sym_backslash_escape] = STATE(159),
    [sym_code_span] = STATE(159),
    [sym_latex_block] = STATE(159),
    [sym_image] = STATE(159),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(560),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(159),
    [sym__whitespace] = STATE(159),
    [sym__word] = STATE(159),
    [sym__soft_line_break] = STATE(159),
    [sym__inline_base] = STATE(123),
    [sym__text_base] = STATE(159),
    [sym__inline_element_no_underscore_no_link] = STATE(123),
    [aux_sym__inline_no_underscore_no_link] = STATE(123),
    [sym__strikethrough_no_link] = STATE(123),
    [sym__emphasis_star_no_link] = STATE(605),
    [sym__strong_emphasis_star_no_link] = STATE(123),
    [sym__emphasis_underscore_no_link] = STATE(605),
    [sym__strong_emphasis_underscore_no_link] = STATE(123),
    [aux_sym__inline_base_repeat1] = STATE(159),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(2131),
    [sym_numeric_character_reference] = ACTIONS(2131),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(2133),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(2131),
    [sym_email_autolink] = ACTIONS(2131),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2135),
    [anon_sym_LT_QMARK] = ACTIONS(2137),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2139),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(2131),
    [sym__digits] = ACTIONS(2131),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(2141),
    [sym__emphasis_open_underscore] = ACTIONS(2143),
    [sym__strikethrough_open] = ACTIONS(2147),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(2131),
  },
  [143] = {
    [sym_backslash_escape] = STATE(161),
    [sym_code_span] = STATE(161),
    [sym_latex_block] = STATE(161),
    [sym_image] = STATE(161),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(561),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(161),
    [sym__whitespace] = STATE(161),
    [sym__word] = STATE(161),
    [sym__soft_line_break] = STATE(161),
    [sym__inline_base] = STATE(129),
    [sym__text_base] = STATE(161),
    [sym__inline_element_no_star_no_link] = STATE(129),
    [aux_sym__inline_no_star_no_link] = STATE(129),
    [sym__strikethrough_no_link] = STATE(129),
    [sym__emphasis_star_no_link] = STATE(641),
    [sym__strong_emphasis_star_no_link] = STATE(129),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(129),
    [aux_sym__inline_base_repeat1] = STATE(161),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(2054),
    [sym_numeric_character_reference] = ACTIONS(2054),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(2056),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(2054),
    [sym_email_autolink] = ACTIONS(2054),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2058),
    [anon_sym_LT_QMARK] = ACTIONS(2060),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2062),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(2054),
    [sym__digits] = ACTIONS(2054),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(2064),
    [sym__emphasis_open_underscore] = ACTIONS(2066),
    [sym__strikethrough_open] = ACTIONS(2070),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(2054),
  },
  [144] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(100),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(100),
    [aux_sym__inline_no_tilde_no_link] = STATE(100),
    [sym__strikethrough_no_link] = STATE(100),
    [sym__emphasis_star_no_link] = STATE(617),
    [sym__strong_emphasis_star_no_link] = STATE(100),
    [sym__emphasis_underscore_no_link] = STATE(617),
    [sym__strong_emphasis_underscore_no_link] = STATE(100),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2012),
    [sym_numeric_character_reference] = ACTIONS(2012),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2014),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2012),
    [sym_email_autolink] = ACTIONS(2012),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2016),
    [anon_sym_LT_QMARK] = ACTIONS(2018),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2020),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2012),
    [sym__digits] = ACTIONS(2012),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2022),
    [sym__emphasis_open_underscore] = ACTIONS(2024),
    [sym__strikethrough_open] = ACTIONS(2026),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2012),
  },
  [145] = {
    [sym_backslash_escape] = STATE(161),
    [sym_code_span] = STATE(161),
    [sym_latex_block] = STATE(161),
    [sym_image] = STATE(161),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(561),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(161),
    [sym__whitespace] = STATE(161),
    [sym__word] = STATE(161),
    [sym__soft_line_break] = STATE(161),
    [sym__inline_base] = STATE(131),
    [sym__text_base] = STATE(161),
    [sym__inline_element_no_star_no_link] = STATE(131),
    [aux_sym__inline_no_star_no_link] = STATE(131),
    [sym__strikethrough_no_link] = STATE(131),
    [sym__emphasis_star_no_link] = STATE(641),
    [sym__strong_emphasis_star_no_link] = STATE(131),
    [sym__emphasis_underscore_no_link] = STATE(641),
    [sym__strong_emphasis_underscore_no_link] = STATE(131),
    [aux_sym__inline_base_repeat1] = STATE(161),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(2054),
    [sym_numeric_character_reference] = ACTIONS(2054),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(2056),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(2054),
    [sym_email_autolink] = ACTIONS(2054),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2058),
    [anon_sym_LT_QMARK] = ACTIONS(2060),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2062),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(2054),
    [sym__digits] = ACTIONS(2054),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(2064),
    [sym__emphasis_open_underscore] = ACTIONS(2066),
    [sym__strikethrough_open] = ACTIONS(2070),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(2054),
  },
  [146] = {
    [sym_backslash_escape] = STATE(158),
    [sym_code_span] = STATE(158),
    [sym_latex_block] = STATE(158),
    [sym_image] = STATE(158),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(158),
    [sym__whitespace] = STATE(158),
    [sym__word] = STATE(158),
    [sym__soft_line_break] = STATE(158),
    [sym__inline_base] = STATE(126),
    [sym__text_base] = STATE(158),
    [sym__inline_element_no_tilde_no_link] = STATE(126),
    [aux_sym__inline_no_tilde_no_link] = STATE(126),
    [sym__strikethrough_no_link] = STATE(126),
    [sym__emphasis_star_no_link] = STATE(617),
    [sym__strong_emphasis_star_no_link] = STATE(126),
    [sym__emphasis_underscore_no_link] = STATE(617),
    [sym__strong_emphasis_underscore_no_link] = STATE(126),
    [aux_sym__inline_base_repeat1] = STATE(158),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2012),
    [sym_numeric_character_reference] = ACTIONS(2012),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2014),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2012),
    [sym_email_autolink] = ACTIONS(2012),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2016),
    [anon_sym_LT_QMARK] = ACTIONS(2018),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2020),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2012),
    [sym__digits] = ACTIONS(2012),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2022),
    [sym__emphasis_open_underscore] = ACTIONS(2024),
    [sym__strikethrough_open] = ACTIONS(2026),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2012),
  },
  [147] = {
    [sym_backslash_escape] = STATE(159),
    [sym_code_span] = STATE(159),
    [sym_latex_block] = STATE(159),
    [sym_image] = STATE(159),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(560),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(159),
    [sym__whitespace] = STATE(159),
    [sym__word] = STATE(159),
    [sym__soft_line_break] = STATE(159),
    [sym__inline_base] = STATE(130),
    [sym__text_base] = STATE(159),
    [sym__inline_element_no_underscore_no_link] = STATE(130),
    [aux_sym__inline_no_underscore_no_link] = STATE(130),
    [sym__strikethrough_no_link] = STATE(130),
    [sym__emphasis_star_no_link] = STATE(605),
    [sym__strong_emphasis_star_no_link] = STATE(130),
    [sym__emphasis_underscore_no_link] = STATE(605),
    [sym__strong_emphasis_underscore_no_link] = STATE(130),
    [aux_sym__inline_base_repeat1] = STATE(159),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(2131),
    [sym_numeric_character_reference] = ACTIONS(2131),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(2133),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(2131),
    [sym_email_autolink] = ACTIONS(2131),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2135),
    [anon_sym_LT_QMARK] = ACTIONS(2137),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2139),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(2131),
    [sym__digits] = ACTIONS(2131),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(2141),
    [sym__emphasis_open_underscore] = ACTIONS(2143),
    [sym__strikethrough_open] = ACTIONS(2147),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(2131),
  },
  [148] = {
    [sym_backslash_escape] = STATE(148),
    [sym_code_span] = STATE(148),
    [sym_latex_block] = STATE(148),
    [sym_image] = STATE(148),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(348),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(148),
    [sym__whitespace] = STATE(148),
    [sym__word] = STATE(148),
    [sym__soft_line_break] = STATE(148),
    [sym__text_base] = STATE(148),
    [aux_sym__inline_base_repeat1] = STATE(148),
    [sym__backslash_escape] = ACTIONS(2376),
    [sym_entity_reference] = ACTIONS(2379),
    [sym_numeric_character_reference] = ACTIONS(2379),
    [anon_sym_LBRACK] = ACTIONS(2382),
    [anon_sym_RBRACK] = ACTIONS(2382),
    [anon_sym_LT] = ACTIONS(2384),
    [anon_sym_GT] = ACTIONS(2387),
    [anon_sym_BANG] = ACTIONS(2390),
    [anon_sym_DQUOTE] = ACTIONS(2387),
    [anon_sym_POUND] = ACTIONS(2387),
    [anon_sym_DOLLAR] = ACTIONS(2387),
    [anon_sym_PERCENT] = ACTIONS(2387),
    [anon_sym_AMP] = ACTIONS(2393),
    [anon_sym_SQUOTE] = ACTIONS(2387),
    [anon_sym_STAR] = ACTIONS(2387),
    [anon_sym_PLUS] = ACTIONS(2387),
    [anon_sym_COMMA] = ACTIONS(2387),
    [anon_sym_DASH] = ACTIONS(2387),
    [anon_sym_DOT] = ACTIONS(2387),
    [anon_sym_SLASH] = ACTIONS(2387),
    [anon_sym_COLON] = ACTIONS(2387),
    [anon_sym_SEMI] = ACTIONS(2387),
    [anon_sym_EQ] = ACTIONS(2387),
    [anon_sym_QMARK] = ACTIONS(2387),
    [anon_sym_AT] = ACTIONS(2387),
    [anon_sym_BSLASH] = ACTIONS(2396),
    [anon_sym_CARET] = ACTIONS(2387),
    [anon_sym__] = ACTIONS(2387),
    [anon_sym_BQUOTE] = ACTIONS(2387),
    [anon_sym_LBRACE] = ACTIONS(2387),
    [anon_sym_PIPE] = ACTIONS(2387),
    [anon_sym_RBRACE] = ACTIONS(2387),
    [anon_sym_TILDE] = ACTIONS(2387),
    [anon_sym_LPAREN] = ACTIONS(2387),
    [anon_sym_RPAREN] = ACTIONS(2387),
    [sym__newline_token] = ACTIONS(2399),
    [sym_uri_autolink] = ACTIONS(2379),
    [sym_email_autolink] = ACTIONS(2379),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2402),
    [anon_sym_LT_QMARK] = ACTIONS(2405),
    [aux_sym__declaration_token1] = ACTIONS(2408),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2411),
    [sym__whitespace_ge_2] = ACTIONS(2414),
    [aux_sym__whitespace_token1] = ACTIONS(2417),
    [sym__word_no_digit] = ACTIONS(2379),
    [sym__digits] = ACTIONS(2379),
    [sym__code_span_start] = ACTIONS(2420),
    [sym__emphasis_open_star] = ACTIONS(2382),
    [sym__emphasis_open_underscore] = ACTIONS(2382),
    [sym__emphasis_close_star] = ACTIONS(2382),
    [sym__strikethrough_open] = ACTIONS(2382),
    [sym__latex_span_start] = ACTIONS(2423),
    [sym__unclosed_span] = ACTIONS(2379),
  },
  [149] = {
    [sym_backslash_escape] = STATE(148),
    [sym_code_span] = STATE(148),
    [sym_latex_block] = STATE(148),
    [sym_image] = STATE(148),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(348),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(148),
    [sym__whitespace] = STATE(148),
    [sym__word] = STATE(148),
    [sym__soft_line_break] = STATE(148),
    [sym__text_base] = STATE(148),
    [aux_sym__inline_base_repeat1] = STATE(148),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(2426),
    [sym_numeric_character_reference] = ACTIONS(2426),
    [anon_sym_LBRACK] = ACTIONS(2428),
    [anon_sym_RBRACK] = ACTIONS(2428),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(742),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(2426),
    [sym_email_autolink] = ACTIONS(2426),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(750),
    [anon_sym_LT_QMARK] = ACTIONS(752),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(756),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(2426),
    [sym__digits] = ACTIONS(2426),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__emphasis_close_star] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(2426),
  },
  [150] = {
    [sym_backslash_escape] = STATE(150),
    [sym_code_span] = STATE(150),
    [sym_latex_block] = STATE(150),
    [sym_image] = STATE(150),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(515),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(150),
    [sym__whitespace] = STATE(150),
    [sym__word] = STATE(150),
    [sym__soft_line_break] = STATE(150),
    [sym__text_base] = STATE(150),
    [aux_sym__inline_base_repeat1] = STATE(150),
    [sym__backslash_escape] = ACTIONS(2430),
    [sym_entity_reference] = ACTIONS(2433),
    [sym_numeric_character_reference] = ACTIONS(2433),
    [anon_sym_LBRACK] = ACTIONS(2382),
    [anon_sym_RBRACK] = ACTIONS(2382),
    [anon_sym_LT] = ACTIONS(2436),
    [anon_sym_GT] = ACTIONS(2439),
    [anon_sym_BANG] = ACTIONS(2442),
    [anon_sym_DQUOTE] = ACTIONS(2439),
    [anon_sym_POUND] = ACTIONS(2439),
    [anon_sym_DOLLAR] = ACTIONS(2439),
    [anon_sym_PERCENT] = ACTIONS(2439),
    [anon_sym_AMP] = ACTIONS(2445),
    [anon_sym_SQUOTE] = ACTIONS(2439),
    [anon_sym_STAR] = ACTIONS(2439),
    [anon_sym_PLUS] = ACTIONS(2439),
    [anon_sym_COMMA] = ACTIONS(2439),
    [anon_sym_DASH] = ACTIONS(2439),
    [anon_sym_DOT] = ACTIONS(2439),
    [anon_sym_SLASH] = ACTIONS(2439),
    [anon_sym_COLON] = ACTIONS(2439),
    [anon_sym_SEMI] = ACTIONS(2439),
    [anon_sym_EQ] = ACTIONS(2439),
    [anon_sym_QMARK] = ACTIONS(2439),
    [anon_sym_AT] = ACTIONS(2439),
    [anon_sym_BSLASH] = ACTIONS(2448),
    [anon_sym_CARET] = ACTIONS(2439),
    [anon_sym__] = ACTIONS(2439),
    [anon_sym_BQUOTE] = ACTIONS(2439),
    [anon_sym_LBRACE] = ACTIONS(2439),
    [anon_sym_PIPE] = ACTIONS(2439),
    [anon_sym_RBRACE] = ACTIONS(2439),
    [anon_sym_TILDE] = ACTIONS(2439),
    [anon_sym_LPAREN] = ACTIONS(2439),
    [anon_sym_RPAREN] = ACTIONS(2439),
    [sym__newline_token] = ACTIONS(2451),
    [sym_uri_autolink] = ACTIONS(2433),
    [sym_email_autolink] = ACTIONS(2433),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2454),
    [anon_sym_LT_QMARK] = ACTIONS(2457),
    [aux_sym__declaration_token1] = ACTIONS(2460),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2463),
    [sym__whitespace_ge_2] = ACTIONS(2466),
    [aux_sym__whitespace_token1] = ACTIONS(2469),
    [sym__word_no_digit] = ACTIONS(2433),
    [sym__digits] = ACTIONS(2433),
    [sym__code_span_start] = ACTIONS(2472),
    [sym__emphasis_open_star] = ACTIONS(2382),
    [sym__emphasis_open_underscore] = ACTIONS(2382),
    [sym__strikethrough_open] = ACTIONS(2382),
    [sym__strikethrough_close] = ACTIONS(2382),
    [sym__latex_span_start] = ACTIONS(2475),
    [sym__unclosed_span] = ACTIONS(2433),
  },
  [151] = {
    [sym_backslash_escape] = STATE(150),
    [sym_code_span] = STATE(150),
    [sym_latex_block] = STATE(150),
    [sym_image] = STATE(150),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(515),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(150),
    [sym__whitespace] = STATE(150),
    [sym__word] = STATE(150),
    [sym__soft_line_break] = STATE(150),
    [sym__text_base] = STATE(150),
    [aux_sym__inline_base_repeat1] = STATE(150),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2478),
    [sym_numeric_character_reference] = ACTIONS(2478),
    [anon_sym_LBRACK] = ACTIONS(2428),
    [anon_sym_RBRACK] = ACTIONS(2428),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(652),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2478),
    [sym_email_autolink] = ACTIONS(2478),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(660),
    [anon_sym_LT_QMARK] = ACTIONS(662),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(666),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2478),
    [sym__digits] = ACTIONS(2478),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__strikethrough_close] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2478),
  },
  [152] = {
    [sym_backslash_escape] = STATE(152),
    [sym_code_span] = STATE(152),
    [sym_latex_block] = STATE(152),
    [sym_image] = STATE(152),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(152),
    [sym__whitespace] = STATE(152),
    [sym__word] = STATE(152),
    [sym__soft_line_break] = STATE(152),
    [sym__text_base] = STATE(152),
    [aux_sym__inline_base_repeat1] = STATE(152),
    [sym__backslash_escape] = ACTIONS(2480),
    [sym_entity_reference] = ACTIONS(2483),
    [sym_numeric_character_reference] = ACTIONS(2483),
    [anon_sym_LBRACK] = ACTIONS(2382),
    [anon_sym_RBRACK] = ACTIONS(2382),
    [anon_sym_LT] = ACTIONS(2486),
    [anon_sym_GT] = ACTIONS(2489),
    [anon_sym_BANG] = ACTIONS(2492),
    [anon_sym_DQUOTE] = ACTIONS(2489),
    [anon_sym_POUND] = ACTIONS(2489),
    [anon_sym_DOLLAR] = ACTIONS(2489),
    [anon_sym_PERCENT] = ACTIONS(2489),
    [anon_sym_AMP] = ACTIONS(2495),
    [anon_sym_SQUOTE] = ACTIONS(2489),
    [anon_sym_STAR] = ACTIONS(2489),
    [anon_sym_PLUS] = ACTIONS(2489),
    [anon_sym_COMMA] = ACTIONS(2489),
    [anon_sym_DASH] = ACTIONS(2489),
    [anon_sym_DOT] = ACTIONS(2489),
    [anon_sym_SLASH] = ACTIONS(2489),
    [anon_sym_COLON] = ACTIONS(2489),
    [anon_sym_SEMI] = ACTIONS(2489),
    [anon_sym_EQ] = ACTIONS(2489),
    [anon_sym_QMARK] = ACTIONS(2489),
    [anon_sym_AT] = ACTIONS(2489),
    [anon_sym_BSLASH] = ACTIONS(2498),
    [anon_sym_CARET] = ACTIONS(2489),
    [anon_sym__] = ACTIONS(2489),
    [anon_sym_BQUOTE] = ACTIONS(2489),
    [anon_sym_LBRACE] = ACTIONS(2489),
    [anon_sym_PIPE] = ACTIONS(2489),
    [anon_sym_RBRACE] = ACTIONS(2489),
    [anon_sym_TILDE] = ACTIONS(2489),
    [anon_sym_LPAREN] = ACTIONS(2489),
    [anon_sym_RPAREN] = ACTIONS(2489),
    [sym__newline_token] = ACTIONS(2501),
    [sym_uri_autolink] = ACTIONS(2483),
    [sym_email_autolink] = ACTIONS(2483),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2504),
    [anon_sym_LT_QMARK] = ACTIONS(2507),
    [aux_sym__declaration_token1] = ACTIONS(2510),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2513),
    [sym__whitespace_ge_2] = ACTIONS(2516),
    [aux_sym__whitespace_token1] = ACTIONS(2519),
    [sym__word_no_digit] = ACTIONS(2483),
    [sym__digits] = ACTIONS(2483),
    [sym__code_span_start] = ACTIONS(2522),
    [sym__emphasis_open_star] = ACTIONS(2382),
    [sym__emphasis_open_underscore] = ACTIONS(2382),
    [sym__emphasis_close_underscore] = ACTIONS(2382),
    [sym__strikethrough_open] = ACTIONS(2382),
    [sym__latex_span_start] = ACTIONS(2525),
    [sym__unclosed_span] = ACTIONS(2483),
  },
  [153] = {
    [sym_backslash_escape] = STATE(152),
    [sym_code_span] = STATE(152),
    [sym_latex_block] = STATE(152),
    [sym_image] = STATE(152),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(435),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(152),
    [sym__whitespace] = STATE(152),
    [sym__word] = STATE(152),
    [sym__soft_line_break] = STATE(152),
    [sym__text_base] = STATE(152),
    [aux_sym__inline_base_repeat1] = STATE(152),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(2528),
    [sym_numeric_character_reference] = ACTIONS(2528),
    [anon_sym_LBRACK] = ACTIONS(2428),
    [anon_sym_RBRACK] = ACTIONS(2428),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(698),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(2528),
    [sym_email_autolink] = ACTIONS(2528),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(706),
    [anon_sym_LT_QMARK] = ACTIONS(708),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(712),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(2528),
    [sym__digits] = ACTIONS(2528),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__emphasis_close_underscore] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(2528),
  },
  [154] = {
    [sym_backslash_escape] = STATE(155),
    [sym_code_span] = STATE(155),
    [sym_latex_block] = STATE(155),
    [sym_image] = STATE(155),
    [sym__image_inline_link] = STATE(265),
    [sym__image_shortcut_link] = STATE(265),
    [sym__image_full_reference_link] = STATE(265),
    [sym__image_collapsed_reference_link] = STATE(265),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(266),
    [sym__html_tag] = STATE(267),
    [sym__open_tag] = STATE(270),
    [sym__closing_tag] = STATE(270),
    [sym__html_comment] = STATE(270),
    [sym__processing_instruction] = STATE(270),
    [sym__declaration] = STATE(270),
    [sym__cdata_section] = STATE(270),
    [sym_hard_line_break] = STATE(155),
    [sym__whitespace] = STATE(155),
    [sym__word] = STATE(155),
    [sym__soft_line_break] = STATE(155),
    [sym__text_base] = STATE(155),
    [aux_sym__inline_base_repeat1] = STATE(155),
    [ts_builtin_sym_end] = ACTIONS(2428),
    [sym__backslash_escape] = ACTIONS(3),
    [sym_entity_reference] = ACTIONS(2530),
    [sym_numeric_character_reference] = ACTIONS(2530),
    [anon_sym_LBRACK] = ACTIONS(2428),
    [anon_sym_RBRACK] = ACTIONS(2428),
    [anon_sym_LT] = ACTIONS(11),
    [anon_sym_GT] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_DQUOTE] = ACTIONS(13),
    [anon_sym_POUND] = ACTIONS(13),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_PERCENT] = ACTIONS(13),
    [anon_sym_AMP] = ACTIONS(17),
    [anon_sym_SQUOTE] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(13),
    [anon_sym_PLUS] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(13),
    [anon_sym_DASH] = ACTIONS(13),
    [anon_sym_DOT] = ACTIONS(13),
    [anon_sym_SLASH] = ACTIONS(13),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_SEMI] = ACTIONS(13),
    [anon_sym_EQ] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(13),
    [anon_sym_AT] = ACTIONS(13),
    [anon_sym_BSLASH] = ACTIONS(19),
    [anon_sym_CARET] = ACTIONS(13),
    [anon_sym__] = ACTIONS(13),
    [anon_sym_BQUOTE] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_PIPE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(13),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_RPAREN] = ACTIONS(13),
    [sym__newline_token] = ACTIONS(21),
    [sym_uri_autolink] = ACTIONS(2530),
    [sym_email_autolink] = ACTIONS(2530),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(23),
    [anon_sym_LT_QMARK] = ACTIONS(25),
    [aux_sym__declaration_token1] = ACTIONS(27),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(29),
    [sym__whitespace_ge_2] = ACTIONS(31),
    [aux_sym__whitespace_token1] = ACTIONS(33),
    [sym__word_no_digit] = ACTIONS(2530),
    [sym__digits] = ACTIONS(2530),
    [sym__code_span_start] = ACTIONS(35),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(45),
    [sym__unclosed_span] = ACTIONS(2530),
  },
  [155] = {
    [sym_backslash_escape] = STATE(155),
    [sym_code_span] = STATE(155),
    [sym_latex_block] = STATE(155),
    [sym_image] = STATE(155),
    [sym__image_inline_link] = STATE(265),
    [sym__image_shortcut_link] = STATE(265),
    [sym__image_full_reference_link] = STATE(265),
    [sym__image_collapsed_reference_link] = STATE(265),
    [sym__image_description] = STATE(1119),
    [sym__image_description_non_empty] = STATE(266),
    [sym__html_tag] = STATE(267),
    [sym__open_tag] = STATE(270),
    [sym__closing_tag] = STATE(270),
    [sym__html_comment] = STATE(270),
    [sym__processing_instruction] = STATE(270),
    [sym__declaration] = STATE(270),
    [sym__cdata_section] = STATE(270),
    [sym_hard_line_break] = STATE(155),
    [sym__whitespace] = STATE(155),
    [sym__word] = STATE(155),
    [sym__soft_line_break] = STATE(155),
    [sym__text_base] = STATE(155),
    [aux_sym__inline_base_repeat1] = STATE(155),
    [ts_builtin_sym_end] = ACTIONS(2382),
    [sym__backslash_escape] = ACTIONS(2532),
    [sym_entity_reference] = ACTIONS(2535),
    [sym_numeric_character_reference] = ACTIONS(2535),
    [anon_sym_LBRACK] = ACTIONS(2382),
    [anon_sym_RBRACK] = ACTIONS(2382),
    [anon_sym_LT] = ACTIONS(2538),
    [anon_sym_GT] = ACTIONS(2541),
    [anon_sym_BANG] = ACTIONS(2544),
    [anon_sym_DQUOTE] = ACTIONS(2541),
    [anon_sym_POUND] = ACTIONS(2541),
    [anon_sym_DOLLAR] = ACTIONS(2541),
    [anon_sym_PERCENT] = ACTIONS(2541),
    [anon_sym_AMP] = ACTIONS(2547),
    [anon_sym_SQUOTE] = ACTIONS(2541),
    [anon_sym_STAR] = ACTIONS(2541),
    [anon_sym_PLUS] = ACTIONS(2541),
    [anon_sym_COMMA] = ACTIONS(2541),
    [anon_sym_DASH] = ACTIONS(2541),
    [anon_sym_DOT] = ACTIONS(2541),
    [anon_sym_SLASH] = ACTIONS(2541),
    [anon_sym_COLON] = ACTIONS(2541),
    [anon_sym_SEMI] = ACTIONS(2541),
    [anon_sym_EQ] = ACTIONS(2541),
    [anon_sym_QMARK] = ACTIONS(2541),
    [anon_sym_AT] = ACTIONS(2541),
    [anon_sym_BSLASH] = ACTIONS(2550),
    [anon_sym_CARET] = ACTIONS(2541),
    [anon_sym__] = ACTIONS(2541),
    [anon_sym_BQUOTE] = ACTIONS(2541),
    [anon_sym_LBRACE] = ACTIONS(2541),
    [anon_sym_PIPE] = ACTIONS(2541),
    [anon_sym_RBRACE] = ACTIONS(2541),
    [anon_sym_TILDE] = ACTIONS(2541),
    [anon_sym_LPAREN] = ACTIONS(2541),
    [anon_sym_RPAREN] = ACTIONS(2541),
    [sym__newline_token] = ACTIONS(2553),
    [sym_uri_autolink] = ACTIONS(2535),
    [sym_email_autolink] = ACTIONS(2535),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2556),
    [anon_sym_LT_QMARK] = ACTIONS(2559),
    [aux_sym__declaration_token1] = ACTIONS(2562),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2565),
    [sym__whitespace_ge_2] = ACTIONS(2568),
    [aux_sym__whitespace_token1] = ACTIONS(2571),
    [sym__word_no_digit] = ACTIONS(2535),
    [sym__digits] = ACTIONS(2535),
    [sym__code_span_start] = ACTIONS(2574),
    [sym__emphasis_open_star] = ACTIONS(2382),
    [sym__emphasis_open_underscore] = ACTIONS(2382),
    [sym__strikethrough_open] = ACTIONS(2382),
    [sym__latex_span_start] = ACTIONS(2577),
    [sym__unclosed_span] = ACTIONS(2535),
  },
  [156] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(537),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__text_base] = STATE(157),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(2580),
    [sym_numeric_character_reference] = ACTIONS(2580),
    [anon_sym_LBRACK] = ACTIONS(2428),
    [anon_sym_RBRACK] = ACTIONS(2428),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(1114),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(2580),
    [sym_email_autolink] = ACTIONS(2580),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(1122),
    [anon_sym_LT_QMARK] = ACTIONS(1124),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(1128),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(2580),
    [sym__digits] = ACTIONS(2580),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(2580),
  },
  [157] = {
    [sym_backslash_escape] = STATE(157),
    [sym_code_span] = STATE(157),
    [sym_latex_block] = STATE(157),
    [sym_image] = STATE(157),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(537),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(157),
    [sym__whitespace] = STATE(157),
    [sym__word] = STATE(157),
    [sym__soft_line_break] = STATE(157),
    [sym__text_base] = STATE(157),
    [aux_sym__inline_base_repeat1] = STATE(157),
    [sym__backslash_escape] = ACTIONS(2582),
    [sym_entity_reference] = ACTIONS(2585),
    [sym_numeric_character_reference] = ACTIONS(2585),
    [anon_sym_LBRACK] = ACTIONS(2382),
    [anon_sym_RBRACK] = ACTIONS(2382),
    [anon_sym_LT] = ACTIONS(2588),
    [anon_sym_GT] = ACTIONS(2591),
    [anon_sym_BANG] = ACTIONS(2594),
    [anon_sym_DQUOTE] = ACTIONS(2591),
    [anon_sym_POUND] = ACTIONS(2591),
    [anon_sym_DOLLAR] = ACTIONS(2591),
    [anon_sym_PERCENT] = ACTIONS(2591),
    [anon_sym_AMP] = ACTIONS(2597),
    [anon_sym_SQUOTE] = ACTIONS(2591),
    [anon_sym_STAR] = ACTIONS(2591),
    [anon_sym_PLUS] = ACTIONS(2591),
    [anon_sym_COMMA] = ACTIONS(2591),
    [anon_sym_DASH] = ACTIONS(2591),
    [anon_sym_DOT] = ACTIONS(2591),
    [anon_sym_SLASH] = ACTIONS(2591),
    [anon_sym_COLON] = ACTIONS(2591),
    [anon_sym_SEMI] = ACTIONS(2591),
    [anon_sym_EQ] = ACTIONS(2591),
    [anon_sym_QMARK] = ACTIONS(2591),
    [anon_sym_AT] = ACTIONS(2591),
    [anon_sym_BSLASH] = ACTIONS(2600),
    [anon_sym_CARET] = ACTIONS(2591),
    [anon_sym__] = ACTIONS(2591),
    [anon_sym_BQUOTE] = ACTIONS(2591),
    [anon_sym_LBRACE] = ACTIONS(2591),
    [anon_sym_PIPE] = ACTIONS(2591),
    [anon_sym_RBRACE] = ACTIONS(2591),
    [anon_sym_TILDE] = ACTIONS(2591),
    [anon_sym_LPAREN] = ACTIONS(2591),
    [anon_sym_RPAREN] = ACTIONS(2591),
    [sym__newline_token] = ACTIONS(2603),
    [sym_uri_autolink] = ACTIONS(2585),
    [sym_email_autolink] = ACTIONS(2585),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2606),
    [anon_sym_LT_QMARK] = ACTIONS(2609),
    [aux_sym__declaration_token1] = ACTIONS(2612),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2615),
    [sym__whitespace_ge_2] = ACTIONS(2618),
    [aux_sym__whitespace_token1] = ACTIONS(2621),
    [sym__word_no_digit] = ACTIONS(2585),
    [sym__digits] = ACTIONS(2585),
    [sym__code_span_start] = ACTIONS(2624),
    [sym__emphasis_open_star] = ACTIONS(2382),
    [sym__emphasis_open_underscore] = ACTIONS(2382),
    [sym__strikethrough_open] = ACTIONS(2382),
    [sym__latex_span_start] = ACTIONS(2627),
    [sym__unclosed_span] = ACTIONS(2585),
  },
  [158] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__text_base] = STATE(164),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(640),
    [sym_entity_reference] = ACTIONS(2630),
    [sym_numeric_character_reference] = ACTIONS(2630),
    [anon_sym_LT] = ACTIONS(648),
    [anon_sym_GT] = ACTIONS(650),
    [anon_sym_BANG] = ACTIONS(2014),
    [anon_sym_DQUOTE] = ACTIONS(650),
    [anon_sym_POUND] = ACTIONS(650),
    [anon_sym_DOLLAR] = ACTIONS(650),
    [anon_sym_PERCENT] = ACTIONS(650),
    [anon_sym_AMP] = ACTIONS(654),
    [anon_sym_SQUOTE] = ACTIONS(650),
    [anon_sym_STAR] = ACTIONS(650),
    [anon_sym_PLUS] = ACTIONS(650),
    [anon_sym_COMMA] = ACTIONS(650),
    [anon_sym_DASH] = ACTIONS(650),
    [anon_sym_DOT] = ACTIONS(650),
    [anon_sym_SLASH] = ACTIONS(650),
    [anon_sym_COLON] = ACTIONS(650),
    [anon_sym_SEMI] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(650),
    [anon_sym_QMARK] = ACTIONS(650),
    [anon_sym_AT] = ACTIONS(650),
    [anon_sym_BSLASH] = ACTIONS(656),
    [anon_sym_CARET] = ACTIONS(650),
    [anon_sym__] = ACTIONS(650),
    [anon_sym_BQUOTE] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_PIPE] = ACTIONS(650),
    [anon_sym_RBRACE] = ACTIONS(650),
    [anon_sym_TILDE] = ACTIONS(650),
    [anon_sym_LPAREN] = ACTIONS(650),
    [anon_sym_RPAREN] = ACTIONS(650),
    [sym__newline_token] = ACTIONS(658),
    [sym_uri_autolink] = ACTIONS(2630),
    [sym_email_autolink] = ACTIONS(2630),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2016),
    [anon_sym_LT_QMARK] = ACTIONS(2018),
    [aux_sym__declaration_token1] = ACTIONS(664),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2020),
    [sym__whitespace_ge_2] = ACTIONS(668),
    [aux_sym__whitespace_token1] = ACTIONS(670),
    [sym__word_no_digit] = ACTIONS(2630),
    [sym__digits] = ACTIONS(2630),
    [sym__code_span_start] = ACTIONS(672),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__strikethrough_close] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(682),
    [sym__unclosed_span] = ACTIONS(2630),
  },
  [159] = {
    [sym_backslash_escape] = STATE(165),
    [sym_code_span] = STATE(165),
    [sym_latex_block] = STATE(165),
    [sym_image] = STATE(165),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(560),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(165),
    [sym__whitespace] = STATE(165),
    [sym__word] = STATE(165),
    [sym__soft_line_break] = STATE(165),
    [sym__text_base] = STATE(165),
    [aux_sym__inline_base_repeat1] = STATE(165),
    [sym__backslash_escape] = ACTIONS(686),
    [sym_entity_reference] = ACTIONS(2632),
    [sym_numeric_character_reference] = ACTIONS(2632),
    [anon_sym_LT] = ACTIONS(694),
    [anon_sym_GT] = ACTIONS(696),
    [anon_sym_BANG] = ACTIONS(2133),
    [anon_sym_DQUOTE] = ACTIONS(696),
    [anon_sym_POUND] = ACTIONS(696),
    [anon_sym_DOLLAR] = ACTIONS(696),
    [anon_sym_PERCENT] = ACTIONS(696),
    [anon_sym_AMP] = ACTIONS(700),
    [anon_sym_SQUOTE] = ACTIONS(696),
    [anon_sym_STAR] = ACTIONS(696),
    [anon_sym_PLUS] = ACTIONS(696),
    [anon_sym_COMMA] = ACTIONS(696),
    [anon_sym_DASH] = ACTIONS(696),
    [anon_sym_DOT] = ACTIONS(696),
    [anon_sym_SLASH] = ACTIONS(696),
    [anon_sym_COLON] = ACTIONS(696),
    [anon_sym_SEMI] = ACTIONS(696),
    [anon_sym_EQ] = ACTIONS(696),
    [anon_sym_QMARK] = ACTIONS(696),
    [anon_sym_AT] = ACTIONS(696),
    [anon_sym_BSLASH] = ACTIONS(702),
    [anon_sym_CARET] = ACTIONS(696),
    [anon_sym__] = ACTIONS(696),
    [anon_sym_BQUOTE] = ACTIONS(696),
    [anon_sym_LBRACE] = ACTIONS(696),
    [anon_sym_PIPE] = ACTIONS(696),
    [anon_sym_RBRACE] = ACTIONS(696),
    [anon_sym_TILDE] = ACTIONS(696),
    [anon_sym_LPAREN] = ACTIONS(696),
    [anon_sym_RPAREN] = ACTIONS(696),
    [sym__newline_token] = ACTIONS(704),
    [sym_uri_autolink] = ACTIONS(2632),
    [sym_email_autolink] = ACTIONS(2632),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2135),
    [anon_sym_LT_QMARK] = ACTIONS(2137),
    [aux_sym__declaration_token1] = ACTIONS(710),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2139),
    [sym__whitespace_ge_2] = ACTIONS(714),
    [aux_sym__whitespace_token1] = ACTIONS(716),
    [sym__word_no_digit] = ACTIONS(2632),
    [sym__digits] = ACTIONS(2632),
    [sym__code_span_start] = ACTIONS(718),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__emphasis_close_underscore] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(728),
    [sym__unclosed_span] = ACTIONS(2632),
  },
  [160] = {
    [sym_backslash_escape] = STATE(160),
    [sym_code_span] = STATE(160),
    [sym_latex_block] = STATE(160),
    [sym_image] = STATE(160),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(561),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(160),
    [sym__whitespace] = STATE(160),
    [sym__word] = STATE(160),
    [sym__soft_line_break] = STATE(160),
    [sym__text_base] = STATE(160),
    [aux_sym__inline_base_repeat1] = STATE(160),
    [sym__backslash_escape] = ACTIONS(2376),
    [sym_entity_reference] = ACTIONS(2634),
    [sym_numeric_character_reference] = ACTIONS(2634),
    [anon_sym_LT] = ACTIONS(2384),
    [anon_sym_GT] = ACTIONS(2387),
    [anon_sym_BANG] = ACTIONS(2637),
    [anon_sym_DQUOTE] = ACTIONS(2387),
    [anon_sym_POUND] = ACTIONS(2387),
    [anon_sym_DOLLAR] = ACTIONS(2387),
    [anon_sym_PERCENT] = ACTIONS(2387),
    [anon_sym_AMP] = ACTIONS(2393),
    [anon_sym_SQUOTE] = ACTIONS(2387),
    [anon_sym_STAR] = ACTIONS(2387),
    [anon_sym_PLUS] = ACTIONS(2387),
    [anon_sym_COMMA] = ACTIONS(2387),
    [anon_sym_DASH] = ACTIONS(2387),
    [anon_sym_DOT] = ACTIONS(2387),
    [anon_sym_SLASH] = ACTIONS(2387),
    [anon_sym_COLON] = ACTIONS(2387),
    [anon_sym_SEMI] = ACTIONS(2387),
    [anon_sym_EQ] = ACTIONS(2387),
    [anon_sym_QMARK] = ACTIONS(2387),
    [anon_sym_AT] = ACTIONS(2387),
    [anon_sym_BSLASH] = ACTIONS(2396),
    [anon_sym_CARET] = ACTIONS(2387),
    [anon_sym__] = ACTIONS(2387),
    [anon_sym_BQUOTE] = ACTIONS(2387),
    [anon_sym_LBRACE] = ACTIONS(2387),
    [anon_sym_PIPE] = ACTIONS(2387),
    [anon_sym_RBRACE] = ACTIONS(2387),
    [anon_sym_TILDE] = ACTIONS(2387),
    [anon_sym_LPAREN] = ACTIONS(2387),
    [anon_sym_RPAREN] = ACTIONS(2387),
    [sym__newline_token] = ACTIONS(2399),
    [sym_uri_autolink] = ACTIONS(2634),
    [sym_email_autolink] = ACTIONS(2634),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2640),
    [anon_sym_LT_QMARK] = ACTIONS(2643),
    [aux_sym__declaration_token1] = ACTIONS(2408),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2646),
    [sym__whitespace_ge_2] = ACTIONS(2414),
    [aux_sym__whitespace_token1] = ACTIONS(2417),
    [sym__word_no_digit] = ACTIONS(2634),
    [sym__digits] = ACTIONS(2634),
    [sym__code_span_start] = ACTIONS(2420),
    [sym__emphasis_open_star] = ACTIONS(2382),
    [sym__emphasis_open_underscore] = ACTIONS(2382),
    [sym__emphasis_close_star] = ACTIONS(2382),
    [sym__strikethrough_open] = ACTIONS(2382),
    [sym__latex_span_start] = ACTIONS(2423),
    [sym__unclosed_span] = ACTIONS(2634),
  },
  [161] = {
    [sym_backslash_escape] = STATE(160),
    [sym_code_span] = STATE(160),
    [sym_latex_block] = STATE(160),
    [sym_image] = STATE(160),
    [sym__image_inline_link] = STATE(347),
    [sym__image_shortcut_link] = STATE(347),
    [sym__image_full_reference_link] = STATE(347),
    [sym__image_collapsed_reference_link] = STATE(347),
    [sym__image_description] = STATE(1122),
    [sym__image_description_non_empty] = STATE(561),
    [sym__html_tag] = STATE(349),
    [sym__open_tag] = STATE(437),
    [sym__closing_tag] = STATE(437),
    [sym__html_comment] = STATE(437),
    [sym__processing_instruction] = STATE(437),
    [sym__declaration] = STATE(437),
    [sym__cdata_section] = STATE(437),
    [sym_hard_line_break] = STATE(160),
    [sym__whitespace] = STATE(160),
    [sym__word] = STATE(160),
    [sym__soft_line_break] = STATE(160),
    [sym__text_base] = STATE(160),
    [aux_sym__inline_base_repeat1] = STATE(160),
    [sym__backslash_escape] = ACTIONS(730),
    [sym_entity_reference] = ACTIONS(2649),
    [sym_numeric_character_reference] = ACTIONS(2649),
    [anon_sym_LT] = ACTIONS(738),
    [anon_sym_GT] = ACTIONS(740),
    [anon_sym_BANG] = ACTIONS(2056),
    [anon_sym_DQUOTE] = ACTIONS(740),
    [anon_sym_POUND] = ACTIONS(740),
    [anon_sym_DOLLAR] = ACTIONS(740),
    [anon_sym_PERCENT] = ACTIONS(740),
    [anon_sym_AMP] = ACTIONS(744),
    [anon_sym_SQUOTE] = ACTIONS(740),
    [anon_sym_STAR] = ACTIONS(740),
    [anon_sym_PLUS] = ACTIONS(740),
    [anon_sym_COMMA] = ACTIONS(740),
    [anon_sym_DASH] = ACTIONS(740),
    [anon_sym_DOT] = ACTIONS(740),
    [anon_sym_SLASH] = ACTIONS(740),
    [anon_sym_COLON] = ACTIONS(740),
    [anon_sym_SEMI] = ACTIONS(740),
    [anon_sym_EQ] = ACTIONS(740),
    [anon_sym_QMARK] = ACTIONS(740),
    [anon_sym_AT] = ACTIONS(740),
    [anon_sym_BSLASH] = ACTIONS(746),
    [anon_sym_CARET] = ACTIONS(740),
    [anon_sym__] = ACTIONS(740),
    [anon_sym_BQUOTE] = ACTIONS(740),
    [anon_sym_LBRACE] = ACTIONS(740),
    [anon_sym_PIPE] = ACTIONS(740),
    [anon_sym_RBRACE] = ACTIONS(740),
    [anon_sym_TILDE] = ACTIONS(740),
    [anon_sym_LPAREN] = ACTIONS(740),
    [anon_sym_RPAREN] = ACTIONS(740),
    [sym__newline_token] = ACTIONS(748),
    [sym_uri_autolink] = ACTIONS(2649),
    [sym_email_autolink] = ACTIONS(2649),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2058),
    [anon_sym_LT_QMARK] = ACTIONS(2060),
    [aux_sym__declaration_token1] = ACTIONS(754),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2062),
    [sym__whitespace_ge_2] = ACTIONS(758),
    [aux_sym__whitespace_token1] = ACTIONS(760),
    [sym__word_no_digit] = ACTIONS(2649),
    [sym__digits] = ACTIONS(2649),
    [sym__code_span_start] = ACTIONS(762),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__emphasis_close_star] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(772),
    [sym__unclosed_span] = ACTIONS(2649),
  },
  [162] = {
    [sym_backslash_escape] = STATE(162),
    [sym_code_span] = STATE(162),
    [sym_latex_block] = STATE(162),
    [sym_image] = STATE(162),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(162),
    [sym__whitespace] = STATE(162),
    [sym__word] = STATE(162),
    [sym__soft_line_break] = STATE(162),
    [sym__text_base] = STATE(162),
    [aux_sym__inline_base_repeat1] = STATE(162),
    [sym__backslash_escape] = ACTIONS(2582),
    [sym_entity_reference] = ACTIONS(2651),
    [sym_numeric_character_reference] = ACTIONS(2651),
    [anon_sym_RBRACK] = ACTIONS(2382),
    [anon_sym_LT] = ACTIONS(2588),
    [anon_sym_GT] = ACTIONS(2591),
    [anon_sym_BANG] = ACTIONS(2654),
    [anon_sym_DQUOTE] = ACTIONS(2591),
    [anon_sym_POUND] = ACTIONS(2591),
    [anon_sym_DOLLAR] = ACTIONS(2591),
    [anon_sym_PERCENT] = ACTIONS(2591),
    [anon_sym_AMP] = ACTIONS(2597),
    [anon_sym_SQUOTE] = ACTIONS(2591),
    [anon_sym_STAR] = ACTIONS(2591),
    [anon_sym_PLUS] = ACTIONS(2591),
    [anon_sym_COMMA] = ACTIONS(2591),
    [anon_sym_DASH] = ACTIONS(2591),
    [anon_sym_DOT] = ACTIONS(2591),
    [anon_sym_SLASH] = ACTIONS(2591),
    [anon_sym_COLON] = ACTIONS(2591),
    [anon_sym_SEMI] = ACTIONS(2591),
    [anon_sym_EQ] = ACTIONS(2591),
    [anon_sym_QMARK] = ACTIONS(2591),
    [anon_sym_AT] = ACTIONS(2591),
    [anon_sym_BSLASH] = ACTIONS(2600),
    [anon_sym_CARET] = ACTIONS(2591),
    [anon_sym__] = ACTIONS(2591),
    [anon_sym_BQUOTE] = ACTIONS(2591),
    [anon_sym_LBRACE] = ACTIONS(2591),
    [anon_sym_PIPE] = ACTIONS(2591),
    [anon_sym_RBRACE] = ACTIONS(2591),
    [anon_sym_TILDE] = ACTIONS(2591),
    [anon_sym_LPAREN] = ACTIONS(2591),
    [anon_sym_RPAREN] = ACTIONS(2591),
    [sym__newline_token] = ACTIONS(2603),
    [sym_uri_autolink] = ACTIONS(2651),
    [sym_email_autolink] = ACTIONS(2651),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2657),
    [anon_sym_LT_QMARK] = ACTIONS(2660),
    [aux_sym__declaration_token1] = ACTIONS(2612),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2663),
    [sym__whitespace_ge_2] = ACTIONS(2618),
    [aux_sym__whitespace_token1] = ACTIONS(2621),
    [sym__word_no_digit] = ACTIONS(2651),
    [sym__digits] = ACTIONS(2651),
    [sym__code_span_start] = ACTIONS(2624),
    [sym__emphasis_open_star] = ACTIONS(2382),
    [sym__emphasis_open_underscore] = ACTIONS(2382),
    [sym__strikethrough_open] = ACTIONS(2382),
    [sym__latex_span_start] = ACTIONS(2627),
    [sym__unclosed_span] = ACTIONS(2651),
  },
  [163] = {
    [sym_backslash_escape] = STATE(162),
    [sym_code_span] = STATE(162),
    [sym_latex_block] = STATE(162),
    [sym_image] = STATE(162),
    [sym__image_inline_link] = STATE(593),
    [sym__image_shortcut_link] = STATE(593),
    [sym__image_full_reference_link] = STATE(593),
    [sym__image_collapsed_reference_link] = STATE(593),
    [sym__image_description] = STATE(1117),
    [sym__image_description_non_empty] = STATE(594),
    [sym__html_tag] = STATE(595),
    [sym__open_tag] = STATE(559),
    [sym__closing_tag] = STATE(559),
    [sym__html_comment] = STATE(559),
    [sym__processing_instruction] = STATE(559),
    [sym__declaration] = STATE(559),
    [sym__cdata_section] = STATE(559),
    [sym_hard_line_break] = STATE(162),
    [sym__whitespace] = STATE(162),
    [sym__word] = STATE(162),
    [sym__soft_line_break] = STATE(162),
    [sym__text_base] = STATE(162),
    [aux_sym__inline_base_repeat1] = STATE(162),
    [sym__backslash_escape] = ACTIONS(1102),
    [sym_entity_reference] = ACTIONS(2666),
    [sym_numeric_character_reference] = ACTIONS(2666),
    [anon_sym_RBRACK] = ACTIONS(2428),
    [anon_sym_LT] = ACTIONS(1110),
    [anon_sym_GT] = ACTIONS(1112),
    [anon_sym_BANG] = ACTIONS(2040),
    [anon_sym_DQUOTE] = ACTIONS(1112),
    [anon_sym_POUND] = ACTIONS(1112),
    [anon_sym_DOLLAR] = ACTIONS(1112),
    [anon_sym_PERCENT] = ACTIONS(1112),
    [anon_sym_AMP] = ACTIONS(1116),
    [anon_sym_SQUOTE] = ACTIONS(1112),
    [anon_sym_STAR] = ACTIONS(1112),
    [anon_sym_PLUS] = ACTIONS(1112),
    [anon_sym_COMMA] = ACTIONS(1112),
    [anon_sym_DASH] = ACTIONS(1112),
    [anon_sym_DOT] = ACTIONS(1112),
    [anon_sym_SLASH] = ACTIONS(1112),
    [anon_sym_COLON] = ACTIONS(1112),
    [anon_sym_SEMI] = ACTIONS(1112),
    [anon_sym_EQ] = ACTIONS(1112),
    [anon_sym_QMARK] = ACTIONS(1112),
    [anon_sym_AT] = ACTIONS(1112),
    [anon_sym_BSLASH] = ACTIONS(1118),
    [anon_sym_CARET] = ACTIONS(1112),
    [anon_sym__] = ACTIONS(1112),
    [anon_sym_BQUOTE] = ACTIONS(1112),
    [anon_sym_LBRACE] = ACTIONS(1112),
    [anon_sym_PIPE] = ACTIONS(1112),
    [anon_sym_RBRACE] = ACTIONS(1112),
    [anon_sym_TILDE] = ACTIONS(1112),
    [anon_sym_LPAREN] = ACTIONS(1112),
    [anon_sym_RPAREN] = ACTIONS(1112),
    [sym__newline_token] = ACTIONS(1120),
    [sym_uri_autolink] = ACTIONS(2666),
    [sym_email_autolink] = ACTIONS(2666),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2042),
    [anon_sym_LT_QMARK] = ACTIONS(2044),
    [aux_sym__declaration_token1] = ACTIONS(1126),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2046),
    [sym__whitespace_ge_2] = ACTIONS(1130),
    [aux_sym__whitespace_token1] = ACTIONS(1132),
    [sym__word_no_digit] = ACTIONS(2666),
    [sym__digits] = ACTIONS(2666),
    [sym__code_span_start] = ACTIONS(1134),
    [sym__emphasis_open_star] = ACTIONS(2428),
    [sym__emphasis_open_underscore] = ACTIONS(2428),
    [sym__strikethrough_open] = ACTIONS(2428),
    [sym__latex_span_start] = ACTIONS(1142),
    [sym__unclosed_span] = ACTIONS(2666),
  },
  [164] = {
    [sym_backslash_escape] = STATE(164),
    [sym_code_span] = STATE(164),
    [sym_latex_block] = STATE(164),
    [sym_image] = STATE(164),
    [sym__image_inline_link] = STATE(514),
    [sym__image_shortcut_link] = STATE(514),
    [sym__image_full_reference_link] = STATE(514),
    [sym__image_collapsed_reference_link] = STATE(514),
    [sym__image_description] = STATE(1123),
    [sym__image_description_non_empty] = STATE(538),
    [sym__html_tag] = STATE(516),
    [sym__open_tag] = STATE(359),
    [sym__closing_tag] = STATE(359),
    [sym__html_comment] = STATE(359),
    [sym__processing_instruction] = STATE(359),
    [sym__declaration] = STATE(359),
    [sym__cdata_section] = STATE(359),
    [sym_hard_line_break] = STATE(164),
    [sym__whitespace] = STATE(164),
    [sym__word] = STATE(164),
    [sym__soft_line_break] = STATE(164),
    [sym__text_base] = STATE(164),
    [aux_sym__inline_base_repeat1] = STATE(164),
    [sym__backslash_escape] = ACTIONS(2430),
    [sym_entity_reference] = ACTIONS(2668),
    [sym_numeric_character_reference] = ACTIONS(2668),
    [anon_sym_LT] = ACTIONS(2436),
    [anon_sym_GT] = ACTIONS(2439),
    [anon_sym_BANG] = ACTIONS(2671),
    [anon_sym_DQUOTE] = ACTIONS(2439),
    [anon_sym_POUND] = ACTIONS(2439),
    [anon_sym_DOLLAR] = ACTIONS(2439),
    [anon_sym_PERCENT] = ACTIONS(2439),
    [anon_sym_AMP] = ACTIONS(2445),
    [anon_sym_SQUOTE] = ACTIONS(2439),
    [anon_sym_STAR] = ACTIONS(2439),
    [anon_sym_PLUS] = ACTIONS(2439),
    [anon_sym_COMMA] = ACTIONS(2439),
    [anon_sym_DASH] = ACTIONS(2439),
    [anon_sym_DOT] = ACTIONS(2439),
    [anon_sym_SLASH] = ACTIONS(2439),
    [anon_sym_COLON] = ACTIONS(2439),
    [anon_sym_SEMI] = ACTIONS(2439),
    [anon_sym_EQ] = ACTIONS(2439),
    [anon_sym_QMARK] = ACTIONS(2439),
    [anon_sym_AT] = ACTIONS(2439),
    [anon_sym_BSLASH] = ACTIONS(2448),
    [anon_sym_CARET] = ACTIONS(2439),
    [anon_sym__] = ACTIONS(2439),
    [anon_sym_BQUOTE] = ACTIONS(2439),
    [anon_sym_LBRACE] = ACTIONS(2439),
    [anon_sym_PIPE] = ACTIONS(2439),
    [anon_sym_RBRACE] = ACTIONS(2439),
    [anon_sym_TILDE] = ACTIONS(2439),
    [anon_sym_LPAREN] = ACTIONS(2439),
    [anon_sym_RPAREN] = ACTIONS(2439),
    [sym__newline_token] = ACTIONS(2451),
    [sym_uri_autolink] = ACTIONS(2668),
    [sym_email_autolink] = ACTIONS(2668),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2674),
    [anon_sym_LT_QMARK] = ACTIONS(2677),
    [aux_sym__declaration_token1] = ACTIONS(2460),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2680),
    [sym__whitespace_ge_2] = ACTIONS(2466),
    [aux_sym__whitespace_token1] = ACTIONS(2469),
    [sym__word_no_digit] = ACTIONS(2668),
    [sym__digits] = ACTIONS(2668),
    [sym__code_span_start] = ACTIONS(2472),
    [sym__emphasis_open_star] = ACTIONS(2382),
    [sym__emphasis_open_underscore] = ACTIONS(2382),
    [sym__strikethrough_open] = ACTIONS(2382),
    [sym__strikethrough_close] = ACTIONS(2382),
    [sym__latex_span_start] = ACTIONS(2475),
    [sym__unclosed_span] = ACTIONS(2668),
  },
  [165] = {
    [sym_backslash_escape] = STATE(165),
    [sym_code_span] = STATE(165),
    [sym_latex_block] = STATE(165),
    [sym_image] = STATE(165),
    [sym__image_inline_link] = STATE(434),
    [sym__image_shortcut_link] = STATE(434),
    [sym__image_full_reference_link] = STATE(434),
    [sym__image_collapsed_reference_link] = STATE(434),
    [sym__image_description] = STATE(1121),
    [sym__image_description_non_empty] = STATE(560),
    [sym__html_tag] = STATE(436),
    [sym__open_tag] = STATE(517),
    [sym__closing_tag] = STATE(517),
    [sym__html_comment] = STATE(517),
    [sym__processing_instruction] = STATE(517),
    [sym__declaration] = STATE(517),
    [sym__cdata_section] = STATE(517),
    [sym_hard_line_break] = STATE(165),
    [sym__whitespace] = STATE(165),
    [sym__word] = STATE(165),
    [sym__soft_line_break] = STATE(165),
    [sym__text_base] = STATE(165),
    [aux_sym__inline_base_repeat1] = STATE(165),
    [sym__backslash_escape] = ACTIONS(2480),
    [sym_entity_reference] = ACTIONS(2683),
    [sym_numeric_character_reference] = ACTIONS(2683),
    [anon_sym_LT] = ACTIONS(2486),
    [anon_sym_GT] = ACTIONS(2489),
    [anon_sym_BANG] = ACTIONS(2686),
    [anon_sym_DQUOTE] = ACTIONS(2489),
    [anon_sym_POUND] = ACTIONS(2489),
    [anon_sym_DOLLAR] = ACTIONS(2489),
    [anon_sym_PERCENT] = ACTIONS(2489),
    [anon_sym_AMP] = ACTIONS(2495),
    [anon_sym_SQUOTE] = ACTIONS(2489),
    [anon_sym_STAR] = ACTIONS(2489),
    [anon_sym_PLUS] = ACTIONS(2489),
    [anon_sym_COMMA] = ACTIONS(2489),
    [anon_sym_DASH] = ACTIONS(2489),
    [anon_sym_DOT] = ACTIONS(2489),
    [anon_sym_SLASH] = ACTIONS(2489),
    [anon_sym_COLON] = ACTIONS(2489),
    [anon_sym_SEMI] = ACTIONS(2489),
    [anon_sym_EQ] = ACTIONS(2489),
    [anon_sym_QMARK] = ACTIONS(2489),
    [anon_sym_AT] = ACTIONS(2489),
    [anon_sym_BSLASH] = ACTIONS(2498),
    [anon_sym_CARET] = ACTIONS(2489),
    [anon_sym__] = ACTIONS(2489),
    [anon_sym_BQUOTE] = ACTIONS(2489),
    [anon_sym_LBRACE] = ACTIONS(2489),
    [anon_sym_PIPE] = ACTIONS(2489),
    [anon_sym_RBRACE] = ACTIONS(2489),
    [anon_sym_TILDE] = ACTIONS(2489),
    [anon_sym_LPAREN] = ACTIONS(2489),
    [anon_sym_RPAREN] = ACTIONS(2489),
    [sym__newline_token] = ACTIONS(2501),
    [sym_uri_autolink] = ACTIONS(2683),
    [sym_email_autolink] = ACTIONS(2683),
    [anon_sym_LT_BANG_DASH_DASH] = ACTIONS(2689),
    [anon_sym_LT_QMARK] = ACTIONS(2692),
    [aux_sym__declaration_token1] = ACTIONS(2510),
    [anon_sym_LT_BANG_LBRACKCDATA_LBRACK] = ACTIONS(2695),
    [sym__whitespace_ge_2] = ACTIONS(2516),
    [aux_sym__whitespace_token1] = ACTIONS(2519),
    [sym__word_no_digit] = ACTIONS(2683),
    [sym__digits] = ACTIONS(2683),
    [sym__code_span_start] = ACTIONS(2522),
    [sym__emphasis_open_star] = ACTIONS(2382),
    [sym__emphasis_open_underscore] = ACTIONS(2382),
    [sym__emphasis_close_underscore] = ACTIONS(2382),
    [sym__strikethrough_open] = ACTIONS(2382),
    [sym__latex_span_start] = ACTIONS(2525),
    [sym__unclosed_span] = ACTIONS(2683),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 10,
    ACTIONS(2706), 1,
      sym__newline_token,
    ACTIONS(2711), 1,
      anon_sym_RBRACK_RBRACK_GT,
    ACTIONS(2713), 1,
      sym__whitespace_ge_2,
    ACTIONS(2716), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2719), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2709), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2703), 4,
      anon_sym_RBRACK,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    STATE(754), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_underscore,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2700), 28,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [79] = 10,
    ACTIONS(2728), 1,
      sym__newline_token,
    ACTIONS(2731), 1,
      anon_sym_QMARK_GT,
    ACTIONS(2733), 1,
      sym__whitespace_ge_2,
    ACTIONS(2736), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2739), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2709), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2725), 4,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_QMARK,
      anon_sym_BSLASH,
    STATE(788), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_star,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2722), 28,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [158] = 10,
    ACTIONS(2706), 1,
      sym__newline_token,
    ACTIONS(2713), 1,
      sym__whitespace_ge_2,
    ACTIONS(2716), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2742), 1,
      anon_sym_RBRACK_RBRACK_GT,
    ACTIONS(2744), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2709), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2703), 4,
      anon_sym_RBRACK,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    STATE(762), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__strikethrough_open,
      sym__strikethrough_close,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2700), 28,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [237] = 10,
    ACTIONS(2706), 1,
      sym__newline_token,
    ACTIONS(2713), 1,
      sym__whitespace_ge_2,
    ACTIONS(2716), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2747), 1,
      anon_sym_RBRACK_RBRACK_GT,
    ACTIONS(2749), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2709), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2703), 4,
      anon_sym_RBRACK,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    STATE(783), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_star,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2700), 28,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [316] = 12,
    ACTIONS(2706), 1,
      sym__newline_token,
    ACTIONS(2711), 1,
      anon_sym_RBRACK_RBRACK_GT,
    ACTIONS(2713), 1,
      sym__whitespace_ge_2,
    ACTIONS(2716), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2752), 1,
      anon_sym_LBRACK,
    ACTIONS(2754), 1,
      anon_sym_RBRACK,
    ACTIONS(2719), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2703), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    ACTIONS(2709), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    STATE(754), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_underscore,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2700), 27,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [399] = 11,
    ACTIONS(2728), 1,
      sym__newline_token,
    ACTIONS(2733), 1,
      sym__whitespace_ge_2,
    ACTIONS(2736), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2758), 1,
      anon_sym_QMARK_GT,
    ACTIONS(2756), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(2760), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2709), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2725), 4,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_QMARK,
      anon_sym_BSLASH,
    STATE(755), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_underscore,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2722), 26,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [480] = 10,
    ACTIONS(2728), 1,
      sym__newline_token,
    ACTIONS(2733), 1,
      sym__whitespace_ge_2,
    ACTIONS(2736), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2763), 1,
      anon_sym_QMARK_GT,
    ACTIONS(2765), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2709), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2725), 4,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_QMARK,
      anon_sym_BSLASH,
    STATE(760), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__strikethrough_open,
      sym__strikethrough_close,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2722), 28,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [559] = 10,
    ACTIONS(2728), 1,
      sym__newline_token,
    ACTIONS(2733), 1,
      sym__whitespace_ge_2,
    ACTIONS(2736), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2758), 1,
      anon_sym_QMARK_GT,
    ACTIONS(2760), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2709), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2725), 4,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_QMARK,
      anon_sym_BSLASH,
    STATE(755), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_underscore,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2722), 28,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [638] = 11,
    ACTIONS(2728), 1,
      sym__newline_token,
    ACTIONS(2733), 1,
      sym__whitespace_ge_2,
    ACTIONS(2736), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2763), 1,
      anon_sym_QMARK_GT,
    ACTIONS(2756), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(2765), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2709), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2725), 4,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_QMARK,
      anon_sym_BSLASH,
    STATE(760), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__strikethrough_open,
      sym__strikethrough_close,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2722), 26,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [719] = 11,
    ACTIONS(2728), 1,
      sym__newline_token,
    ACTIONS(2731), 1,
      anon_sym_QMARK_GT,
    ACTIONS(2733), 1,
      sym__whitespace_ge_2,
    ACTIONS(2736), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2739), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2756), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(2709), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2725), 4,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_QMARK,
      anon_sym_BSLASH,
    STATE(788), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_star,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2722), 26,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [800] = 12,
    ACTIONS(2706), 1,
      sym__newline_token,
    ACTIONS(2713), 1,
      sym__whitespace_ge_2,
    ACTIONS(2716), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2747), 1,
      anon_sym_RBRACK_RBRACK_GT,
    ACTIONS(2752), 1,
      anon_sym_LBRACK,
    ACTIONS(2754), 1,
      anon_sym_RBRACK,
    ACTIONS(2749), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2703), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    ACTIONS(2709), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    STATE(783), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_star,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2700), 27,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [883] = 10,
    ACTIONS(2706), 1,
      sym__newline_token,
    ACTIONS(2713), 1,
      sym__whitespace_ge_2,
    ACTIONS(2716), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2768), 1,
      anon_sym_RBRACK_RBRACK_GT,
    ACTIONS(2770), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2709), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2703), 4,
      anon_sym_RBRACK,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    STATE(782), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      ts_builtin_sym_end,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2700), 28,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [962] = 10,
    ACTIONS(2728), 1,
      sym__newline_token,
    ACTIONS(2733), 1,
      sym__whitespace_ge_2,
    ACTIONS(2736), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2773), 1,
      anon_sym_QMARK_GT,
    ACTIONS(2775), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2709), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2725), 4,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_QMARK,
      anon_sym_BSLASH,
    STATE(777), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      ts_builtin_sym_end,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2722), 28,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1041] = 12,
    ACTIONS(2706), 1,
      sym__newline_token,
    ACTIONS(2713), 1,
      sym__whitespace_ge_2,
    ACTIONS(2716), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2742), 1,
      anon_sym_RBRACK_RBRACK_GT,
    ACTIONS(2752), 1,
      anon_sym_LBRACK,
    ACTIONS(2754), 1,
      anon_sym_RBRACK,
    ACTIONS(2744), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2703), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    ACTIONS(2709), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    STATE(762), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 13,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__strikethrough_open,
      sym__strikethrough_close,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2700), 27,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1124] = 11,
    ACTIONS(2784), 1,
      anon_sym_DASH,
    ACTIONS(2787), 1,
      sym__newline_token,
    ACTIONS(2790), 1,
      anon_sym_DASH_DASH_GT,
    ACTIONS(2792), 1,
      sym__whitespace_ge_2,
    ACTIONS(2795), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2798), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2709), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2781), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    STATE(759), 3,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
    ACTIONS(2698), 14,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__strikethrough_open,
      sym__strikethrough_close,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      anon_sym_GT,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2778), 27,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1204] = 12,
    ACTIONS(2787), 1,
      sym__newline_token,
    ACTIONS(2792), 1,
      sym__whitespace_ge_2,
    ACTIONS(2795), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2809), 1,
      anon_sym_DASH,
    ACTIONS(2812), 1,
      anon_sym_DASH_DASH_GT,
    ACTIONS(2801), 2,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
    ACTIONS(2814), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2709), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2803), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    STATE(756), 3,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
    ACTIONS(2698), 14,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_underscore,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      anon_sym_GT,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2806), 25,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1286] = 11,
    ACTIONS(2728), 1,
      sym__newline_token,
    ACTIONS(2733), 1,
      sym__whitespace_ge_2,
    ACTIONS(2736), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2756), 1,
      anon_sym_LBRACK,
    ACTIONS(2817), 1,
      anon_sym_QMARK_GT,
    ACTIONS(2819), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2709), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2725), 4,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_QMARK,
      anon_sym_BSLASH,
    STATE(819), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 12,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2722), 27,
      anon_sym_RBRACK,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1366] = 11,
    ACTIONS(2706), 1,
      sym__newline_token,
    ACTIONS(2713), 1,
      sym__whitespace_ge_2,
    ACTIONS(2716), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2752), 1,
      anon_sym_LBRACK,
    ACTIONS(2822), 1,
      anon_sym_RBRACK_RBRACK_GT,
    ACTIONS(2824), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2709), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2703), 4,
      anon_sym_RBRACK,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    STATE(808), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 12,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2700), 27,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1446] = 10,
    ACTIONS(2706), 1,
      sym__newline_token,
    ACTIONS(2713), 1,
      sym__whitespace_ge_2,
    ACTIONS(2716), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2822), 1,
      anon_sym_RBRACK_RBRACK_GT,
    ACTIONS(2824), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2709), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2703), 4,
      anon_sym_RBRACK,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    STATE(808), 4,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
      aux_sym__processing_instruction_repeat1,
    ACTIONS(2698), 12,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      sym_uri_autolink,
      sym_email_autolink,
      anon_sym_LT_BANG_LBRACKCDATA_LBRACK,
    ACTIONS(2700), 28,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_BANG,
      anon_sym_DQUOTE,
      anon_sym_POUND,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_COMMA,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_SLASH,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_CARET,
      anon_sym__,
      anon_sym_BQUOTE,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_TILDE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [1524] = 11,
    ACTIONS(2787), 1,
      sym__newline_token,
    ACTIONS(2792), 1,
      sym__whitespace_ge_2,
    ACTIONS(2795), 1,
      aux_sym__whitespace_token1,
    ACTIONS(2809), 1,
      anon_sym_DASH,
    ACTIONS(2812), 1,
      anon_sym_DASH_DASH_GT,
    ACTIONS(2814), 2,
      sym__word_no_digit,
      sym__digits,
    ACTIONS(2709), 3,
      anon_sym_LT_BANG_DASH_DASH,
      anon_sym_LT_QMARK,
      aux_sym__declaration_token1,
    ACTIONS(2803), 3,
      anon_sym_LT,
      anon_sym_AMP,
      anon_sym_BSLASH,
    STATE(756), 3,
      sym__whitespace,
      sym__word,
      sym__soft_line_break,
    ACTIONS(2698), 14,
      sym__code_span_start,
      sym__emphasis_open_star,
      sym__emphasis_open_underscore,
      sym__emphasis_close_underscore,
      sym__strikethrough_open,
      sym__latex_span_start,
      sym__unclosed_span,
      sym__backslash_escape,
      sym_entity_reference,
      sym_numeric_character_reference,
      anon_sym_GT,
      sym_uri_autolink,
      sym_em