% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{gene.vs.molecule.cell.filter}
\alias{gene.vs.molecule.cell.filter}
\title{Filter cells based on gene/molecule dependency}
\usage{
gene.vs.molecule.cell.filter(
  countMatrix,
  min.cell.size = 500,
  max.cell.size = 50000,
  p.level = min(0.001, 1/ncol(countMatrix)),
  alpha = 0.1,
  plot = TRUE,
  do.par = TRUE
)
}
\arguments{
\item{countMatrix}{input count matrix to be filtered}

\item{min.cell.size}{numeric Min allowed cell size (default=500)}

\item{max.cell.size}{numeric Max allowed cell size (default=5e4)}

\item{p.level}{numeric Statistical confidence level for deviation from the main trend, used for cell filtering (default=min(1e-3,1/ncol(countMatrix)))}

\item{alpha}{numeric Shading of the confidence band (default=0.1)}

\item{plot}{boolean Plot the molecule distribution and the gene/molecule dependency fit (default=TRUE)}

\item{do.par}{boolean Reset graphical parameters prior to plotting (default=TRUE)}
}
\value{
a filtered matrix
}
\description{
Filter cells based on gene/molecule dependency
}
