% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{read10xMatrix}
\alias{read10xMatrix}
\title{This function reads a matrix generated by the 10x processing pipeline
from the specified directory and returns it. It aborts if one of the required
files in the specified directory do not exist.}
\usage{
read10xMatrix(path, version = "V3", transcript.id = "SYMBOL", verbose = TRUE)
}
\arguments{
\item{path}{string Location of 10x output}

\item{version}{string Version of 10x output to read (default='V3'). Must be one of 'V2' or 'V3'.}

\item{transcript.id}{string Transcript identifier to use (default='SYMBOL'). Must be either 'SYMBOL' or 'ENSEMBL'.}

\item{verbose}{boolean Whether to return verbose output}
}
\value{
parsed 10x outputs into a matrix
}
\description{
This function reads a matrix generated by the 10x processing pipeline
from the specified directory and returns it. It aborts if one of the required
files in the specified directory do not exist.
}
