% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ord-recoverers.r
\name{recoverers}
\alias{recoverers}
\alias{recover_rows}
\alias{recover_cols}
\alias{recover_rows.default}
\alias{recover_cols.default}
\alias{recover_rows.data.frame}
\alias{recover_cols.data.frame}
\alias{get_rows}
\alias{get_cols}
\alias{as.matrix.tbl_ord}
\alias{recover_inertia}
\alias{recover_inertia.default}
\alias{recover_coord}
\alias{recover_coord.default}
\alias{recover_coord.data.frame}
\alias{get_coord}
\alias{get_inertia}
\alias{dim.tbl_ord}
\title{Access factors, coordinates, and metadata from ordination objects}
\usage{
recover_rows(x)

recover_cols(x)

\method{recover_rows}{default}(x)

\method{recover_cols}{default}(x)

\method{recover_rows}{data.frame}(x)

\method{recover_cols}{data.frame}(x)

get_rows(x, elements = "all")

get_cols(x, elements = "all")

\method{as.matrix}{tbl_ord}(x, ..., .matrix, elements = "all")

recover_inertia(x)

\method{recover_inertia}{default}(x)

recover_coord(x)

\method{recover_coord}{default}(x)

\method{recover_coord}{data.frame}(x)

get_coord(x)

get_inertia(x)

\method{dim}{tbl_ord}(x)
}
\arguments{
\item{x}{An object of class '\link{tbl_ord}'.}

\item{elements}{Character vector; which elements of each factor for which to
render graphical elements. One of \code{"all"} (the default), \code{"active"}, or any
supplementary element type defined by the specific class methods (e.g.
\code{"score"} for 'factanal', 'lda_ord', and 'cancord_ord' and \code{"intraset"} and
\code{"interset"} for 'cancor_ord').}

\item{...}{Additional arguments from \code{\link[base:matrix]{base::as.matrix()}}; ignored.}

\item{.matrix}{A character string partially matched (lowercase) to several
indicators for one or both matrices in a matrix decomposition used for
ordination. The standard values are \code{"rows"}, \code{"cols"}, and \code{"dims"} (for
both).}
}
\value{
The \verb{recover_*()} functions are generics whose methods return base R
objects retrieved from the model wrapped in the 'tbl_ord' class:
\itemize{
\item \code{rows}: the row matrix as stored in the model
\item \code{cols}: the column matrix as stored in the model
\item \code{inertia}: the vector of eigen-values or squared singular values,
often known by other names depending on the model
\item \code{coord}: names for the artificial axes, from the model if available
The \verb{get_*()} functions (which are not generics) return modifications of
these objects:
\item \code{rows}: the recovered rows,
adjusted according to any negation of axes or conference of inertia
\item \code{cols}: the recovered columns,
adjusted according to any negation of axes or conference of inertia
\item \code{inertia}: the recovered inertia, named by the recovered coordinates
\item \code{coord}: the recovered coordinates (unmodified)
\code{dim()} returns the dimensions of the decomposed matrix, i.e. the numbers of
rows of \code{recover_rows()} and of \code{recover_cols()}.
}
}
\description{
These functions return information about the matrix
factorization underlying an ordination.
}
\details{
The \verb{recover_*()} \link[base:UseMethod]{S3 methods} extract one or both of the
row and column matrix factors that constitute the original ordination. These
are interpreted as the case scores (rows) and the variable loadings
(columns). The \verb{get_*()} functions optionally (and by default) include any
supplemental observations (see \link{supplementation}).

The \verb{recover_*()} functions are generics that require methods for each
ordination class. They are not intended to be called directly but are
exported so that users can query \code{methods("recover_*")}.

\code{get_coord()} retrieves the names of the coordinates shared by the matrix
factors on which the original data were ordinated, and \code{get_inertia()}
retrieves a vector of the inertia with these names. \code{dim()} retrieves the
dimensions of the row and column factors, which reflect the dimensions of the
matrix they reconstruct---\strong{not} the original data matrix. (This matters for
techniques that rely on eigendecomposition, for which the decomposed matrix
is square.)
}
\examples{
# example ordination: LRA of U.S. arrests data
arrests_lra <- ordinate(USArrests, cols = c(Murder, Rape, Assault), lra)

# extract matrix factors
as.matrix(arrests_lra, .matrix = "rows")
as.matrix(arrests_lra, .matrix = "cols")
# special named functions
get_rows(arrests_lra)
get_cols(arrests_lra)
# get dimensions of underlying matrix factorization (not of original data)
dim(arrests_lra)

# get names of artificial / latent coordinates
get_coord(arrests_lra)
# get distribution of inertia
get_inertia(arrests_lra)
}
\seealso{
Other generic recoverers: 
\code{\link{augmentation}},
\code{\link{conference}},
\code{\link{supplementation}}
}
\concept{generic recoverers}
