% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-mass-lda.r
\name{methods-lda}
\alias{methods-lda}
\alias{as_tbl_ord.lda}
\alias{as_tbl_ord.lda_ord}
\alias{recover_rows.lda}
\alias{recover_rows.lda_ord}
\alias{recover_cols.lda}
\alias{recover_cols.lda_ord}
\alias{recover_inertia.lda}
\alias{recover_inertia.lda_ord}
\alias{recover_coord.lda}
\alias{recover_coord.lda_ord}
\alias{recover_conference.lda}
\alias{recover_conference.lda_ord}
\alias{recover_aug_rows.lda}
\alias{recover_aug_rows.lda_ord}
\alias{recover_aug_cols.lda}
\alias{recover_aug_cols.lda_ord}
\alias{recover_aug_coord.lda}
\alias{recover_aug_coord.lda_ord}
\alias{recover_supp_rows.lda}
\alias{recover_supp_rows.lda_ord}
\title{Functionality for linear discriminant analysis ('lda') objects}
\usage{
\method{as_tbl_ord}{lda}(x)

\method{as_tbl_ord}{lda_ord}(x)

\method{recover_rows}{lda}(x)

\method{recover_rows}{lda_ord}(x)

\method{recover_cols}{lda}(x)

\method{recover_cols}{lda_ord}(x)

\method{recover_inertia}{lda}(x)

\method{recover_inertia}{lda_ord}(x)

\method{recover_coord}{lda}(x)

\method{recover_coord}{lda_ord}(x)

\method{recover_conference}{lda}(x)

\method{recover_conference}{lda_ord}(x)

\method{recover_aug_rows}{lda}(x)

\method{recover_aug_rows}{lda_ord}(x)

\method{recover_aug_cols}{lda}(x)

\method{recover_aug_cols}{lda_ord}(x)

\method{recover_aug_coord}{lda}(x)

\method{recover_aug_coord}{lda_ord}(x)

\method{recover_supp_rows}{lda}(x)

\method{recover_supp_rows}{lda_ord}(x)
}
\arguments{
\item{x}{An ordination object.}
}
\value{
The recovery generics \verb{recover_*()} return \link[=recoverers]{core model components}, \link[=conference]{distribution of inertia},
\link[=supplementation]{supplementary elements}, and \link[=augmentation]{intrinsic metadata}; but they require methods for each model class to
tell them what these components are.

The generic \code{\link[=as_tbl_ord]{as_tbl_ord()}} returns its input wrapped in the 'tbl_ord'
class. Its methods determine what model classes it is allowed to wrap. It
then provides 'tbl_ord' methods with access to the recoverers and hence to
the model components.
}
\description{
These methods extract data from, and attribute new data to,
objects of class \code{"lda"} and \code{"lda_ord"} as returned by \code{\link[MASS:lda]{MASS::lda()}} and
\code{\link[=lda_ord]{lda_ord()}}.
}
\details{
See \link{lda-ord} for details.
}
\examples{
# data frame of Anderson iris species measurements
class(iris)
head(iris)

# default (unstandardized discriminant) coefficients
lda_ord(iris[, 1:4], iris[, 5]) \%>\%
  as_tbl_ord() \%>\%
  print() -> iris_lda

# recover centroid coordinates and measurement discriminant coefficients
get_rows(iris_lda, elements = "active")
head(get_rows(iris_lda, elements = "score"))
get_cols(iris_lda)

# augment ordination with centroid and measurement names
augment_ord(iris_lda)
}
\seealso{
Other methods for singular value decomposition-based techniques: 
\code{\link{methods-cancor}},
\code{\link{methods-correspondence}},
\code{\link{methods-lra}},
\code{\link{methods-mca}},
\code{\link{methods-prcomp}},
\code{\link{methods-princomp}},
\code{\link{methods-svd}}
}
\concept{methods for singular value decomposition-based techniques}
