% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_xlsx.R
\name{write_xlsx}
\alias{write_xlsx}
\title{Write data to an xlsx file}
\usage{
write_xlsx(x, file, as_table = FALSE, ...)
}
\arguments{
\item{x}{An object or a list of objects that can be handled by \code{\link[=wb_add_data]{wb_add_data()}} to write to file.}

\item{file}{An optional xlsx file name. If no file is passed, the object is not written to disk and only a workbook object is returned.}

\item{as_table}{If \code{TRUE}, will write as a data table, instead of data.}

\item{...}{
  Arguments passed on to \code{\link[=wb_workbook]{wb_workbook}}, \code{\link[=wb_add_worksheet]{wb_add_worksheet}}, \code{\link[=wb_add_data_table]{wb_add_data_table}}, \code{\link[=wb_add_data]{wb_add_data}}, \code{\link[=wb_freeze_pane]{wb_freeze_pane}}, \code{\link[=wb_set_col_widths]{wb_set_col_widths}}, \code{\link[=wb_save]{wb_save}}, \code{\link[=wb_set_base_font]{wb_set_base_font}}
  \describe{
    \item{\code{creator}}{Creator of the workbook (your name). Defaults to login username or \code{options("openxlsx2.creator")} if set.}
    \item{\code{sheet}}{A name for the new worksheet}
    \item{\code{grid_lines}}{A logical. If \code{FALSE}, the worksheet grid lines will be
hidden.}
    \item{\code{tab_color}}{Color of the sheet tab. A  \code{\link[=wb_color]{wb_color()}},  a valid color (belonging to
\code{grDevices::colors()}) or a valid hex color beginning with "#".}
    \item{\code{zoom}}{The sheet zoom level, a numeric between 10 and 400 as a
percentage. (A zoom value smaller than 10 will default to 10.)}
    \item{\code{total_row}}{logical. With the default \code{FALSE} no total row is added.}
    \item{\code{start_col}}{A vector specifying the starting column to write \code{x} to.}
    \item{\code{start_row}}{A vector specifying the starting row to write \code{x} to.}
    \item{\code{col_names}}{If \code{TRUE}, column names of \code{x} are written.}
    \item{\code{row_names}}{If \code{TRUE}, the row names of \code{x} are written.}
    \item{\code{na}}{Value used for replacing \code{NA} values from \code{x}. Default
looks if \code{options("openxlsx2.na")} is set. Otherwise \code{\link[=na_strings]{na_strings()}}
uses the special \verb{#N/A} value within the workbook.}
    \item{\code{first_active_row}}{Top row of active region}
    \item{\code{first_active_col}}{Furthest left column of active region}
    \item{\code{first_row}}{If \code{TRUE}, freezes the first row (equivalent to \code{first_active_row = 2})}
    \item{\code{first_col}}{If \code{TRUE}, freezes the first column (equivalent to \code{first_active_col = 2})}
    \item{\code{widths}}{Width to set \code{cols} to specified column width or \code{"auto"} for
automatic sizing. \code{widths} is recycled to the length of \code{cols}. openxlsx2
sets the default width is 8.43, as this is the standard in some spreadsheet
software. See \strong{Details} for general information on column widths.}
    \item{\code{overwrite}}{If \code{FALSE}, will not overwrite when \code{file} already exists.}
    \item{\code{font_size}}{Font size}
    \item{\code{font_color}}{Font color}
    \item{\code{font_name}}{Name of a font}
  }}
}
\value{
A workbook object
}
\description{
Write a data frame or list of data frames to an xlsx file.
}
\details{
columns of \code{x} with class \code{Date} or \code{POSIXt} are automatically
styled as dates and datetimes respectively.
}
\examples{
## write to working directory
write_xlsx(iris, file = temp_xlsx(), col_names = TRUE)

write_xlsx(iris,
  file = temp_xlsx(),
  col_names = TRUE
)

## Lists elements are written to individual worksheets, using list names as sheet names if available
l <- list("IRIS" = iris, "MTCARS" = mtcars, matrix(runif(1000), ncol = 5))
write_xlsx(l, temp_xlsx(), col_widths = c(NA, "auto", "auto"))

## different sheets can be given different parameters
write_xlsx(l, temp_xlsx(),
  start_col = c(1, 2, 3), start_row = 2,
  as_table = c(TRUE, TRUE, FALSE), with_filter = c(TRUE, FALSE, FALSE)
)

# specify column widths for multiple sheets
write_xlsx(l, temp_xlsx(), col_widths = 20)
write_xlsx(l, temp_xlsx(), col_widths = list(100, 200, 300))
write_xlsx(l, temp_xlsx(), col_widths = list(rep(10, 5), rep(8, 11), rep(5, 5)))

# set base font color to automatic so LibreOffice dark mode works as expected
write_xlsx(l, temp_xlsx(), font_color = wb_color(auto = TRUE))
}
