% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.list.R
\name{as.data.frame.data.list}
\alias{as.data.frame.data.list}
\title{Convert to data.frame}
\usage{
\method{as.data.frame}{data.list}(x, row.names = NULL, optional = FALSE, ...)
}
\arguments{
\item{x}{The data.list to be converted.}

\item{row.names}{Not used.}

\item{optional}{Not used.}

\item{...}{Not used.}
}
\value{
A data.frame
}
\description{
Converts a data.list to a data.frame.
}
\details{
The forecasts in the data.list will result in columns named \code{varname.kxx} in the data.frame.
}
\examples{

#' # Use the data.list with building heat load 
D <- Dbuilding
# Take a subset
D <- subset(D, 1:5, nms=c("t","Taobs","Ta","Iobs","I"), kseq=1:3)

# Convert to a data.frame, note the names of the forecasts are appended .kxx (i.e. for Ta and I)
as.data.frame(D)

}
