% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{funsZmixed.nonref}
\alias{funsZmixed.nonref}
\alias{Zmixed.nonref.ct}
\alias{Zmixed.nonref}
\title{Mixed-Non-Reflexivity Test with Normal Approximation}
\usage{
Zmixed.nonref.ct(
  rfct,
  nvec,
  Qv,
  Tv,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95
)

Zmixed.nonref(
  dat,
  lab,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{rfct}{An RCT, used in \code{Zmixed.nonref.ct} only}

\item{nvec}{The \code{vector} of class sizes, used in \code{Zmixed.nonref.ct} only}

\item{Qv}{The number of shared NNs, used in \code{Zmixed.nonref.ct} only}

\item{Tv}{\eqn{T} value, which is the number of triplets \eqn{(z_i, z_j, z_k)} with 
"\eqn{NN(z_i) = NN(z_j) = z_k} and \eqn{NN(z_k) = z_j} where \eqn{NN(\cdot)} is the nearest neighbor function, used in \code{Zmixed.nonref.ct} only.}

\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"} or \code{"greater"}.}

\item{conf.level}{Level of the upper and lower confidence limits, default is \code{0.95}, 
for the difference of the off-diagonal entries, \eqn{N_{12}-N_{21}}}

\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point,
used in \code{Zmixed.nonref} only}

\item{lab}{The \code{vector} of class labels (numerical or categorical), used in \code{Zmixed.nonref} only}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.
used in \code{Zmixed.nonref} only}
}
\value{
A \code{list} with the elements
\item{statistic}{The \eqn{Z} test statistic for mixed non-reflexivity corresponding to entry \eqn{(2,2)} in the RCT}
\item{p.value}{The \eqn{p}-value for the hypothesis test for the corresponding alternative}
\item{conf.int}{Confidence interval for the mixed non-reflexivity value (i.e., diagonal entry \eqn{(2,2)} value)
in the RCT at the given confidence level \code{conf.level} and depends on the type of \code{alternative}.} 
\item{estimate}{Estimate of the parameter, i.e., the observed diagonal entry \eqn{(2,2)} in the RCT, \code{rfct}.}
\item{null.value}{Hypothesized null value for the mixed non-reflexivity value (i.e., expected value of the 
diagonal entry \eqn{(2,2)} which is \eqn{E(N_{22})=R P_{ab}}) in the RCT.}
\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}}
\item{method}{Description of the hypothesis test}
\item{ct.name}{Name of the contingency table, \code{rfct}, returned by \code{Zmixed.nonref.ct} only}
\item{data.name}{Name of the data set, \code{dat}, returned by \code{Zmixed.nonref} only}
}
\description{
Two functions: \code{Zmixed.nonref.ct} and \code{Zmixed.nonref}.

Both functions are objects of class \code{"htest"} but with different arguments (see the parameter list below).
Each one performs hypothesis tests of mixed non-reflexivity in the NN structure using the
number of mixed-non-reflexive NN pairs (i.e. the second diagonal entry, \eqn{(2,2)}) in the RCT for \eqn{k \ge 2} classes.
That is, each test performs a test of mixed non-reflexivity corresponding to entry \eqn{(2,2)} in the RCT)
which is appropriate (i.e. have the appropriate asymptotic sampling distribution) for completely mapped data.
(See \insertCite{ceyhan:NNreflexivity2017;textual}{nnspat} for more detail).

The mixed non-reflexivity test is based on the normal approximation of the diagonal entry \eqn{(2,2)}
in the RCT and are due to \insertCite{ceyhan:NNreflexivity2017;textual}{nnspat}.

Each function yields the test statistic, \eqn{p}-value for the
corresponding alternative, the confidence interval, sample estimate (i.e. observed value) and null (i.e., expected) value for the
mixed non-reflexivity value (i.e., diagonal entry \eqn{(2,2)} value, respectively) in the RCT, 
and method and name of the data set used.

The null hypothesis is that \eqn{E(N_{22})=R P_{ab}} in the RCT, where \eqn{R} is the number of reflexive
NNs and \eqn{P_{ab}} is the probability of any two points selected are being from two different classes.
}
\examples{
n<-20
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))

ipd<-ipd.mat(Y)
W<-Wmat(ipd)
Qv<-Qvec(W)$q
R<-Rval(W)
Tv<-Tval(W,R)

nvec<-as.numeric(table(cls))
rfct<-rct(ipd,cls)

Zmixed.nonref(Y,cls)
Zmixed.nonref.ct(rfct,nvec,Qv,Tv)
Zmixed.nonref(Y,cls,alt="g")

Zmixed.nonref(Y,cls,method="max")

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))

ipd<-ipd.mat(Y)
W<-Wmat(ipd)
Qv<-Qvec(W)$q
R<-Rval(W)
Tv<-Tval(W,R)

nvec<-as.numeric(table(cls))
rfct<-rct(ipd,cls)

Zmixed.nonref(Y,cls,alt="g")

Zmixed.nonref.ct(rfct,nvec,Qv,Tv)
Zmixed.nonref.ct(rfct,nvec,Qv,Tv,alt="l")

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Zself.ref.ct}}, \code{\link{Zself.ref}}, \code{\link{Znnref.ct}} and
\code{\link{Znnref}}
}
\author{
Elvan Ceyhan
}
