% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saem_fit_aux.R
\name{calc.2LL}
\alias{calc.2LL}
\title{Log-likelihood using Gaussian Quadrature}
\usage{
calc.2LL(fit, nnodes.gq = 8, nsd.gq = 4)
}
\arguments{
\item{fit}{saemFit fit}

\item{nnodes.gq}{number of nodes to use for the Gaussian
quadrature when computing the likelihood with this method
(defaults to 1, equivalent to the Laplaclian likelihood)}

\item{nsd.gq}{span (in SD) over which to integrate when computing
the likelihood by Gaussian quadrature. Defaults to 3 (eg 3
times the SD)}
}
\value{
log-likelihood calculated by Gaussian Quadrature
}
\description{
Estimate the log-likelihood using Gaussian Quadrature (multidimensional
grid)
}
\references{
Kuhn E, Lavielle M. Maximum likelihood estimation in nonlinear
mixed effects models. Computational Statistics and Data Analysis 49, 4
(2005), 1020-1038.

Comets E, Lavenu A, Lavielle M. SAEMIX, an R version of the SAEM algorithm.
20th meeting of the Population Approach Group in Europe, Athens, Greece
(2011), Abstr 2173.
}
