% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dDynOcc.R
\name{dDynOcc}
\alias{dDynOcc}
\alias{dDynOcc_sss}
\alias{dDynOcc_svs}
\alias{dDynOcc_vss}
\alias{dDynOcc_vvs}
\alias{dDynOcc_ssv}
\alias{dDynOcc_svv}
\alias{dDynOcc_vsv}
\alias{dDynOcc_vvv}
\alias{dDynOcc_ssm}
\alias{dDynOcc_svm}
\alias{dDynOcc_vsm}
\alias{dDynOcc_vvm}
\alias{rDynOcc_vvm}
\alias{rDynOcc_vsm}
\alias{rDynOcc_svm}
\alias{rDynOcc_ssm}
\alias{rDynOcc_vvv}
\alias{rDynOcc_vsv}
\alias{rDynOcc_svv}
\alias{rDynOcc_ssv}
\alias{rDynOcc_vvs}
\alias{rDynOcc_vss}
\alias{rDynOcc_svs}
\alias{rDynOcc_sss}
\title{Dynamic occupancy distribution for use in \code{nimble} models
\code{dDynOcc_**} and \code{rDynOcc_**} provide dynamic occupancy
model distributions that can be used directly from R or in \code{nimble}
models.}
\usage{
dDynOcc_vvm(x, init, probPersist, probColonize, p, start, end, log = 0)

dDynOcc_vsm(x, init, probPersist, probColonize, p, start, end, log = 0)

dDynOcc_svm(x, init, probPersist, probColonize, p, start, end, log = 0)

dDynOcc_ssm(x, init, probPersist, probColonize, p, start, end, log = 0)

rDynOcc_vvm(n, init, probPersist, probColonize, p, start, end)

rDynOcc_vsm(n, init, probPersist, probColonize, p, start, end)

rDynOcc_svm(n, init, probPersist, probColonize, p, start, end)

rDynOcc_ssm(n, init, probPersist, probColonize, p, start, end)

dDynOcc_vvv(x, init, probPersist, probColonize, p, start, end, log = 0)

dDynOcc_vsv(x, init, probPersist, probColonize, p, start, end, log = 0)

dDynOcc_svv(x, init, probPersist, probColonize, p, start, end, log = 0)

dDynOcc_ssv(x, init, probPersist, probColonize, p, start, end, log = 0)

rDynOcc_vvv(n, init, probPersist, probColonize, p, start, end)

rDynOcc_vsv(n, init, probPersist, probColonize, p, start, end)

rDynOcc_svv(n, init, probPersist, probColonize, p, start, end)

rDynOcc_ssv(n, init, probPersist, probColonize, p, start, end)

dDynOcc_vvs(x, init, probPersist, probColonize, p, start, end, log = 0)

dDynOcc_vss(x, init, probPersist, probColonize, p, start, end, log = 0)

dDynOcc_svs(x, init, probPersist, probColonize, p, start, end, log = 0)

dDynOcc_sss(x, init, probPersist, probColonize, p, start, end, log = 0)

rDynOcc_vvs(n, init, probPersist, probColonize, p, start, end)

rDynOcc_vss(n, init, probPersist, probColonize, p, start, end)

rDynOcc_svs(n, init, probPersist, probColonize, p, start, end)

rDynOcc_sss(n, init, probPersist, probColonize, p, start, end)
}
\arguments{
\item{x}{detection/non-detection matrix of 0s (not detected) and 1s
(detected). Rows represent primary sampling occasions (e.g. different
seasons). Columns are secondary sampling locations (e.g. replicate
visits within a season) that may be different for each row}

\item{init}{probability of occupancy in the first sampling period}

\item{probPersist}{persistence probability--probability an occupied
cell remains occupied. 1-extinction probability. Scalar for
\code{dDynOcc_s**}, vector for \code{dDynOcc_v**}. If vector,
should have length dim(x)[1] - 1 since no transition occurs
after the last observation}

\item{probColonize}{colonization probability. Probability that
an unoccupied cell becomes occupied. Scalar for \code{dDynOcc_*s*},
vector for \code{dDynOcc_*v*}. If vector, should have length
dim(x)[1] - 1 since no transition occurs after the last observation}

\item{p}{Detection probabilities. Scalar for \code{dDynOcc_**s},
vector for \code{dDynOcc_**v}, matrix for \code{dDynOcc_**m}.
If a matrix, dimensions should match x}

\item{start}{indicates the column number of the first observation in each
row of x. A vector of length dim(x)[1]. This allows for different time
periods to have different numbers of sampling occasions}

\item{end}{indicates the column number of the last observation in each
row of x. A vector of length dim(x)[1]. This allows for different time
periods to have different numbers of sampling occasions}

\item{log}{TRUE (return log probability) or FALSE (return probability)}

\item{n}{number of random draws, each returning a matrix of dimension
\code{c(min(start), max(end))}. Currently only \code{n = 1} is supported,
but the argument exists for standardization of "\code{r}" functions}
}
\value{
For \code{dDynOcc_***}: the probability (or likelihood) or log probability
of observation vector \code{x}.
For \code{rDynOcc_***}: a simulated detection history, \code{x}.
}
\description{
Dynamic occupancy distribution for use in \code{nimble} models
\code{dDynOcc_**} and \code{rDynOcc_**} provide dynamic occupancy
model distributions that can be used directly from R or in \code{nimble}
models.
}
\details{
These nimbleFunctions provide distributions that can be used directly in R or
in \code{nimble} hierarchical models (via \code{\link[nimble]{nimbleCode}}
and \code{\link[nimble]{nimbleModel}}).

The probability (or likelihood) of observation \code{x[t, o]} depends on
the occupancy status of the site at time t-1, the transitition
probability of persistence (\code{probPersist} or \code{probPersist[t-1]}),
colonization (\code{probColonize} or \code{probColonize[t-1]}), and a
detection probability (\code{p}, \code{p[t]}, or \code{p[t, o]}).

The first two letters following the 'dDynOcc_' indicate whether the
probabilities of persistence and colonization are a constant scalar (s)
or time-indexed vector (v). For example, \code{dDynOcc_svm} takes scalar
persistence probability \code{probPersist} with a vector of colonization
probabilities \code{probColonize[1:(T-1)]}.

When vectors, \code{probColonize} and \code{probPersist} may be of any
length greater than or equal to \code{length(x) - 1}. Only the first \code{length(x) - 1}
indices are used, each corresponding to the transition from time t to t+1
(e.g. \code{probColonize[2]} describes the transition probability from
t = 2 to t = 3). All extra values are ignored. This is to make it easier to
use one distribution for many sites, some requiring probabilities of length 1.

The third letter in the suffix indicates whether the detection probability
is a constant (scalar), time-dependent (vector), or both time-dependent and
dependent on observation occasion (matrix). For example, \code{dDynOcc_svm}
takes a matrix of detection probabilities \code{p[1:T, 1:O]}.

The arguments \code{start} and \code{end} allow different time periods to
contain different numbers of sampling events. Suppose you have observations
for samples in three seasons; in the first two seasons, there are four
observations, but in the third, there are only three. The \code{start}
and \code{end} could be provided as \code{start = c(1,1,1)} and
\code{end = c(4,4,3)}. In this case, the value of \code{x[4,4]} would
be ignored.

For more explanation, see package vignette
(\code{vignette("Introduction_to_nimbleEcology")}).

Compared to writing \code{nimble} models with a discrete latent state for
true occupancy status and a separate scalar datum for each observation, use
of these distributions allows one to directly sum (marginalize) over the
discrete latent state and calculate the probability of all observations from
one site jointly.

These are \code{nimbleFunction}s written in the format of user-defined
distributions for NIMBLE's extension of the BUGS model language. More
information can be found in the NIMBLE User Manual at
\href{https://r-nimble.org}{https://r-nimble.org}.

When using these distributions in a \code{nimble} model, the left-hand side
will be used as \code{x}, and the user should not provide the \code{log}
argument.

For example, in \code{nimble} model code,

\code{detections[1:T, 1:O] ~ dDynOcc_ssm(init,
probPersist = persistence_prob,
probColonize = colonization_prob, p = p[1:T, 1:O],
start = start[1:T], end = end[1:T])}

declares that the \code{detections[1:T]} vector follows a dynamic occupancy
model distribution with parameters as indicated, assuming all the parameters
have been declared elsewhere in the model. This
will invoke (something like) the following call to \code{dDynOcc_ssm} when
\code{nimble} uses the model such as for MCMC:

\code{dDynOcc_ssm(detections[1:T, 1:O], init,
probPersist = persistence_prob,
probColonize = colonization_prob, p = p[1:T, 1:O],
start = start[1:T], end = end[1:T], log = TRUE)}

If an algorithm using a \code{nimble} model with this declaration
needs to generate a random draw for \code{detections[1:T, 1:O]}, it
will make a similar invocation of \code{rDynOcc_ssm}, with \code{n = 1}.

If the colonization probabilities are time-dependent, one would use:

\code{detections[1:T] ~ dDynOcc_svm(nrep, init = init_prob,
probPersist = persistence_prob,
probColonize = colonization_prob[1:(T-1)], p = p[1:T, 1:O])}
}
\examples{
# Set up constants and initial values for defining the model
  x <- matrix(c(0,0,0,0,
                1,1,1,0,
                0,0,0,0,
                0,0,1,0,
                0,0,0,0), nrow = 4)
  start <- c(1,1,2,1,1)
  end <- c(5,5,5,4,5)
  init <- 0.7
  probPersist <- 0.5
  probColonize <- 0.2
  p <- matrix(rep(0.5, 20), nrow = 4)


# Define code for a nimbleModel
 nc <- nimbleCode({

   x[1:2, 1:5] ~ dDynOcc_vvm(init,
     probPersist[1:2], probColonize[1:2], p[1:2,1:5],
     start = start[1:4], end = end[1:4])

   init ~ dunif(0,1)

   for (i in 1:2) {
     probPersist[i] ~ dunif(0,1)
     probColonize[i] ~ dunif(0,1)
   }

   for (i in 1:2) {
     for (j in 1:5) {
       p[i,j] ~ dunif(0,1)
     }
   }
 })

# Build the model, providing data and initial values
DynOcc_model <- nimbleModel(nc, data = list(x = x),
                            constants = list(start = start, end = end),
                            inits = list(p = p, probPersist = probPersist,
                                         init = init, probColonize = probColonize))

# Calculate log probability of data from the model
DynOcc_model$calculate("x")
# Use the model for a variety of other purposes...
}
\seealso{
For basic occupancy models, see documentation for
  \code{\link{dOcc}}.
}
\author{
Ben Goldstein, Perry de Valpine and Lauren Ponisio
}
