% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{make_parental_chain}
\alias{make_parental_chain}
\title{Construct parental chain id vector from pedigree trio information}
\usage{
make_parental_chain(id, fid, mid)
}
\arguments{
\item{id}{Numeric vector of ids}

\item{fid}{Numeric vector of ids of the father. This should be NA or 0 for a founder.}

\item{mid}{Numeric vector of ids of the mother. This should be NA or 0 for a founder.}
}
\value{
Returns an integer vector giving the family index
}
\description{
Create a vector of length n, giving the id of
parental chains.  If the pedigree is totally connected, then everyone
will end up in tree 1, otherwise the tree numbers represent the
disconnected subfamilies.  Singleton subjects each have unique
family numbers.

No check is done to ensure that the id, fid, and mid actually refer to proper family structure.
References to ids in the fid and mid arguments that are not part of the id vector are considered founders.
}
\examples{

id <- 1:11
fid <- c(0,0,1,0,0,4,0,0,3,7,7)
mid <- c(0,0,2,0,0,5,0,0,6,6,8)
make_parental_chain(id, fid, mid)

}
\author{
Claus Ekstrom \email{ekstrom@sund.ku.dk}
}
\keyword{manip}
