\name{runNetweavers}
\alias{runNetweavers}
\title{
  Perform the NetWeAvers Algorithm
}
\description{
  A wrapper for the functions in the NetWeAvers package. This function
  performs all of the steps in the NetWeAvers algorithm including 
  filtering the protein network, finding dense clusters (only if output 
  of \code{findDenseClusters} is not already provided), and calculating protein
  weights, protein measures, cluster scores, and cluster \emph{p}-values
  from a permutation test (optional). 
}
\usage{
runNetweavers(protein_pvals, network, clust_2_protein = NA, 
              min_clus_size = 4, steps = 10, weightamt = 10, 
              cscoremethod = "mean", permtest = TRUE, B = 1000)
}
\arguments{
  \item{protein_pvals}{
    Data frame on two variables: 
    \code{Protein}, a vector of protein identifiers, and \code{pvalue}, 
    a numeric vector of protein \emph{p}-values (between 0 and 1).
  }
  \item{network}{
    Data frame or matrix on two variables; node-node network format.
  }
  \item{clust_2_protein}{
    Optional data frame of cluster information containing the following:
      \describe{
      \item{\code{clusID}}{  Factor; a cluster ID.}
      \item{\code{clusSIZE}}{Numeric vector of integers containing the size (number of proteins) in each cluster.}
      \item{\code{X1 }}{      Character vector of proteins; the first protein for each cluster.}
      \item{\code{...}}{     Additional cluster symbols, as many as \code{clusSIZE} dictates per cluster.}
      }
  }
  \item{min_clus_size}{
    Integer indicating the required minimal size (number of vertices) of a cluster. 
  }  
  \item{steps}{
    Integer specifying the length of random walks to perform. 
  }
  \item{weightamt}{
    Positive numeric value (see Details). 
  }
  \item{cscoremethod}{
    Function (mean or median) for calculating cluster scores.
  }
  \item{permtest}{
    Logical indicator of whether to perform a permutation test. 
  }
  \item{B}{
    Integer specifying the number of permutations to run;  
    used only if \code{permtest} is TRUE.
  }
}
\details{
The variable \code{Protein} in \code{protein_pvals} should be a vector of identifiers that match those in \code{network}.
  
The argument \code{weightamt} should be a number indicating how much to weigh the protein weights as compared to the protein \emph{p}-values. 
The larger this value, the larger the impact of \emph{p}-values on the protein measures (and subsequent cluster scores) as compared to the weights.
See \code{\link{measureCalc}} for more details on \code{weightamt}.
  
The \code{network} will be filtered to contain only interactions where at least one protein is in \code{protein_pvals}.

See \href{http://igraph.sourceforge.net/doc/R/walktrap.community.html}{\code{walktrap.community}} in the
\pkg{igraph} package for more details on \code{steps}, 
the parameter required for community-finding using random walks.
}
\value{
  \item{proteininfo}{A data frame on the following 4 variables (protein information):
    \describe{
      \item{\code{Protein}}{Character vector of protein identifiers.}
      \item{\code{pvalue }}{Numeric vector of \emph{p}-values.}
      \item{\code{weight }}{Numeric vector of weights.}
      \item{\code{measure}}{Numeric vector.}
    }}
  \item{filt_net}{A data frame; the filtered \code{network}.}
  \item{clusterinfo}{A data frame on the following variables (cluster information):
    \describe{
      \item{\code{Cluster_ID}      }{Factor of cluster IDs.}
      \item{\code{Cluster_size     }}{Numeric vector of integers indicating the size (number of proteins) of the cluster.}
      \item{\code{Cluster_score    }}{Numeric vector of cluster scores.}
      \item{\code{Cluster_pvalue   }}{Numeric vector of values between 0 and 1.}
      \item{\code{Cluster_symbol.X1}}{Character vector of proteins; the first protein for each cluster.}
      \item{\code{...              }}{Additional protein symbols, 
                                      as many as \code{Cluster_size} dictates per cluster.}
  }}
}
\seealso{
\code{\link{filterNetwork}}, \code{\link{findDenseClusters}}, \code{\link{weightCalc}}, 
\code{\link{measureCalc}}, \code{\link{scoreClusters}}, \code{\link{permTest}}
}
\examples{
\dontrun{
data(vanHoof)
nw_out <- runNetweavers(pvalsSumVH, filtNetVH)
str(nw_out)
## or, if clust_2_protein available, e.g. clust_2_proteinVH generated by 
## clust_2_proteinVH <- findDenseClusters(network=filtNetVH,pvalsSumVH$Protein) 
## then:
nw_out <- runNetweavers(pvalsSumVH, filtNetVH, clust_2_proteinVH)
str(nw_out)}
}
\keyword{ methods }
