% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/respiratory_01.R
\name{respiratory_01}
\alias{respiratory_01}
\title{Respiratory-01 Calculation}
\usage{
respiratory_01(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  situation_table = NULL,
  vitals_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  eresponse_05_col,
  esituation_11_col,
  esituation_12_col,
  evitals_12_col,
  evitals_14_col,
  ...
)
}
\arguments{
\item{df}{A data frame containing incident data with each row representing an
observation.}

\item{patient_scene_table}{A data.frame or tibble containing at least
epatient and escene fields as a fact table.}

\item{response_table}{A data.frame or tibble containing at least the
eresponse fields needed for this measure's calculations.}

\item{situation_table}{A data.frame or tibble containing at least the
esituation fields needed for this measure's calculations.}

\item{vitals_table}{A data.frame or tibble containing at least the evitals
fields needed for this measure's calculations.}

\item{erecord_01_col}{Unique Patient ID}

\item{incident_date_col}{Column that contains the incident date. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{patient_DOB_col}{Column that contains the patient's date of birth. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{epatient_15_col}{Column giving the calculated age value.}

\item{epatient_16_col}{Column giving the provided age unit value.}

\item{eresponse_05_col}{Column name for 911 response codes (e.g., 2205001,
2205003, 2205009).}

\item{esituation_11_col}{Column name for primary impression codes related to
respiratory distress.}

\item{esituation_12_col}{Column name for secondary impression codes related
to respiratory distress.}

\item{evitals_12_col}{Column name for the first vital sign measurement.}

\item{evitals_14_col}{Column name for the second vital sign measurement.}

\item{...}{arguments passed to \code{dplyr::summarize()}.}
}
\value{
A tibble summarizing results for the Adults, Peds, and all records
with the following columns:

\code{measure}: The name of the measure being calculated.
\code{pop}: Population type (Adults, Peds, All).
\code{numerator}: Count of EMS responses originating from a 911 request for
patients with primary or secondary impression of respiratory distress who
had a respiratory assessment.
\code{denominator}: Total count of incidents.
\code{prop}: Proportion of EMS responses originating from a 911 request for
patients with primary or secondary impression of respiratory distress who
had a respiratory assessment.
\code{prop_label}: Proportion formatted as a percentage with a specified number
of decimal places.
}
\description{
The \code{respiratory_01} function filters and analyzes data related to emergency
911 respiratory distress incidents, providing summary statistics for adult
and pediatric populations. This function uses specific data columns for 911
response codes, primary and secondary impressions, and vital signs to
calculate the proportion of cases with complete vital signs recorded,
stratified by age.
}
\examples{
# Synthetic test data
test_data <- tibble::tibble(
  erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
  epatient_15 = c(34, 5, 45, 2, 60),  # Ages
  epatient_16 = c("Years", "Years", "Years", "Months", "Years"),
  eresponse_05 = rep(2205001, 5),
  esituation_11 = c(rep("J80", 3), rep("I50.9", 2)),
  esituation_12 = c(rep("J80", 2), rep("I50.9", 3)),
  evitals_12 = c(60, 59, 58, 57, 56),
  evitals_14 = c(16, 15, 14, 13, 12)
)

# Run the function
respiratory_01(
  df = test_data,
  erecord_01_col = erecord_01,
  epatient_15_col = epatient_15,
  epatient_16_col = epatient_16,
  eresponse_05_col = eresponse_05,
  esituation_11_col = esituation_11,
  esituation_12_col = esituation_12,
  evitals_12_col = evitals_12,
  evitals_14_col = evitals_14
)

}
\author{
Nicolas Foss, Ed.D., MS
}
