% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbc4va_help.R
\name{nbc4vaHelpDev}
\alias{nbc4vaHelpDev}
\title{Developer notes in nbc4va}
\usage{
nbc4vaHelpDev()
}
\description{
Developer notes in nbc4va
}
\section{About}{

This documentation page provides information for developers on the structure of the code, as well as any package and function dependencies.
}

\section{Internal Functions}{

\itemize{
  \item \strong{\code{\link{internalNBC}}}: execute and return the details of the naive bayes classifier algorithm
  \item \strong{\code{\link{internalCheckNBC}}}: checks the \code{\link{nbc}} function arguments
  \item \strong{\code{\link{internalCheckNBCSummary}}}: checks the \code{\link{summary.nbc}} function arguments
  \item \strong{\code{\link{internalGetCSMFMaxError}}}: calculates the CSMF maximum error given the observed cases
  \item \strong{\code{\link{internalGetCSMFAcc}}}: calculates the CSMF accuracy given the predicted and observed cases of any length
    \itemize{
      \item \strong{Dependencies}: \code{\link{internalGetCSMFMaxError}}
    }
  \item \strong{\code{\link{internalGetCauseMetrics}}}: creates a dataframe of particular metrics for each cause
  \item \strong{\code{\link{internalGetMetrics}}}: creates a vector of overall metrics given the observed and predicted cases
    \itemize{
      \item \strong{Dependencies}: \code{\link{internalGetCSMFMaxError}}, \code{\link{internalGetCSMFAcc}}
    }
  \item \strong{\code{\link{internalSubAsRest}}}: substitute a target value for the rest of the values by their distribution per column
    \itemize{
      \item \strong{Dependencies}: \code{\link{internalRoundFixedSum}}
    }
  \item \strong{\code{\link{internalRoundFixedSum}}}: round a vector of values to whole numbers while preserving their sum
}
}

\section{External Functions}{

\itemize{
  \item \strong{\code{\link{nbc}}}: main function for running the naive bayes classifier
    \itemize{
      \item \strong{Dependencies}: \code{\link{internalCheckNBC}}, \code{\link{internalNBC}}
    }
  \item \strong{\code{\link{summary.nbc}}}: consumes output from \code{\link{nbc}} to calculate informative metrics
    \itemize{
      \item \strong{Dependencies}: \code{\link{internalCheckNBCSummary}}, \code{\link{internalGetCauseMetrics}}, \code{\link{internalGetMetrics}}, \code{\link{internalGetCSMFMaxError}}, \code{\link{internalGetCSMFAcc}}
    }
  \item \strong{\code{\link{print.nbc_summary}}}: consumes output from \code{\link{summary.nbc}} to print a message of the top causes
    \itemize{
      \item \strong{Dependencies}: \code{\link{summary.nbc}}, \code{\link{nbc}}
    }
  \item \strong{\code{\link{plot.nbc}}}: consumes output from \code{\link{nbc}} to plot the top causes
    \itemize{
      \item \strong{Dependencies}: \code{\link{summary.nbc}}, \code{\link{nbc}}
    }
  \item \strong{\code{\link{nbc4vaIO}}}: file input and output for the main package functions
    \itemize{
      \item \strong{Dependencies}: \code{\link{summary.nbc}}, \code{\link{nbc}}
    }
  \item \strong{\code{\link{nbc4vaGUI}}}: graphical user interface to run the main package functions
    \itemize{
      \item \strong{Dependencies}: \code{\link{nbc4vaIO}}
      \item \strong{Required Packages}: \pkg{shiny}
    }
  \item \strong{\code{\link{csmf.nbc}}}: consumes output from \code{\link{nbc}} to get the predicted csmfs
    \itemize{
      \item \strong{Dependencies}: \code{\link{nbc}}, \code{\link{summary.nbc}}
    }
  \item \strong{\code{\link{topCOD.nbc}}}: consumes output from \code{\link{nbc}} to get the top predictions
    \itemize{
      \item \strong{Dependencies}: \code{\link{nbc}}
    }
}
}

\section{Extra Functions}{

\itemize{
  \item \strong{\code{\link{ova2nbc}}}: consumes arguments specified in the \href{https://cran.r-project.org/package=openVA}{openVA} package to get a modified \code{\link{nbc}} object
    \itemize{
      \item \strong{Suggested Packages}: \href{https://cran.r-project.org/package=openVA}{openVA}
    }
}
}
\seealso{
Guide for package: \code{\link{nbc4va}}

Other help functions: \code{\link{nbc4vaHelpAdvanced}},
  \code{\link{nbc4vaHelpBasic}},
  \code{\link{nbc4vaHelpData}},
  \code{\link{nbc4vaHelpFunctions}},
  \code{\link{nbc4vaHelpMethods}}, \code{\link{nbc4vaHelp}}
}

