% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_n_lineages.R
\name{get_n_lineages}
\alias{get_n_lineages}
\title{Collect the number of lineages from the stem age}
\usage{
get_n_lineages(phylogeny)
}
\arguments{
\item{phylogeny}{a phylogeny of class 'phylo'}
}
\value{
number of lineages, will go from 1 to the number of tips,
  if there is a stem, will go from 2 to the number of tips
  if there is no stem
}
\description{
Collect the number of lineages from the stem age
}
\examples{
  phylogeny <- ape::read.tree(text = "((a:2,b:2):1,c:3);")
  testthat::expect_true(
    all.equal(as.vector(nLTT::get_n_lineages(phylogeny)), c(2, 3)))
  phylogeny$root.edge <- 2 # nolint ape variable name
  testthat::expect_true(
    all.equal(as.vector(nLTT::get_n_lineages(phylogeny)), c(1, 2, 3)))
}
\author{
Richèl Bilderbeek
}
