% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxid.R
\name{taxid}
\alias{taxid}
\title{Retrieve taxonomy categories from NCBI Taxonomy}
\usage{
taxid(db.path, download = FALSE, update = FALSE, filter = NULL)
}
\arguments{
\item{db.path}{path to download and store the NCBI Taxonomy \code{categories.dmp} file. Default is the \code{tempdir()}
directory.}

\item{download}{a logical value specifying whether or not the \code{categories.dmp} shall be downloaded (\code{download = TRUE})
or whether a local version already exists on the users machine (\code{download = TRUE} - in this case please specify the \code{db.path} argument to target the local \code{categories.dmp} file).}

\item{update}{should the local file be updated? Please specify the \code{db.path} argument to target the local \code{categories.dmp} file.}

\item{filter}{a character string specifying the kingdom of life for which taxids shall be returned. Options are
\code{"Archea"}, \code{"Bacteria"}, \code{"Eukaryota"}, \code{"Viruses"}, \code{"Unclassified"}.}
}
\description{
This function retrieves category information 
from NCBI Taxonomy and is able to filter kingdom specific taxids.
}
\examples{
\dontrun{
# download categories.dmp file to current working directory 
# and filter for 'Archea' taxids
Archea.taxids <- taxid(db.path = getwd(), filter = "Archea", download = TRUE)

# Once the NCBI Taxonomy 'categories.dmp' file is downloaded to your machine ('download = TRUE')
# the 'taxid()' function can be proceed on the local 'categories.dmp' file
# e.g. filter for Virus taxids
Virus.taxids <- taxid(db.path = getwd(), filter = "Viruses")
}

}
\author{
Hajk-Georg Drost
}

