/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.gmwcs.graph;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.itmo.ctlab.virgo.Pair;
import ru.itmo.ctlab.virgo.gmwcs.graph.Blocks;
import ru.itmo.ctlab.virgo.gmwcs.graph.Graph;
import ru.itmo.ctlab.virgo.gmwcs.graph.Node;

public class Decomposition {
    private Set<Node> biggest;
    private List<Set<Node>> unrootedComponents;
    private List<Pair<Set<Node>, Node>> rootedComponents;
    private Graph graph;

    public Decomposition(Graph graph) {
        this.graph = graph;
        this.unrootedComponents = new ArrayList<Set<Node>>();
        this.rootedComponents = new ArrayList<Pair<Set<Node>, Node>>();
        List<Set<Node>> components = graph.connectedSets();
        Set<Node> bestComponent = null;
        Blocks partBest = null;
        int maxSize = 0;
        for (Set<Node> component : components) {
            Graph subgraph = graph.subgraph(component);
            Blocks blocks = new Blocks(subgraph);
            Set<Set<Node>> bicomponents = blocks.components();
            for (Set<Node> bicomponent : bicomponents) {
                if (bicomponent.size() <= maxSize) continue;
                maxSize = bicomponent.size();
                this.biggest = bicomponent;
                partBest = blocks;
                bestComponent = component;
            }
        }
        for (Set<Node> component : components) {
            if (component == bestComponent) continue;
            this.unrootedComponents.add(component);
        }
        this.processBest(partBest);
    }

    private void processBest(Blocks partBest) {
        LinkedHashSet<Node> cutpoints = new LinkedHashSet<Node>();
        for (Node cp : partBest.cutpoints()) {
            if (!this.biggest.contains(cp)) continue;
            cutpoints.add(cp);
        }
        Node root = this.biggest.iterator().next();
        Node cutpoint = cutpoints.contains(root) ? root : null;
        LinkedHashMap<Node, Boolean> visited = new LinkedHashMap<Node, Boolean>();
        LinkedHashMap<Node, Set<Node>> components = new LinkedHashMap<Node, Set<Node>>();
        for (Node cp : cutpoints) {
            components.put(cp, new LinkedHashSet());
            ((Set)components.get(cp)).add(cp);
        }
        this.dfs(root, cutpoint, cutpoints, visited, components);
        for (Node cp : cutpoints) {
            this.rootedComponents.add(new Pair(components.get(cp), cp));
            this.unrootedComponents.add((Set<Node>)components.get(cp));
        }
    }

    private void dfs(Node v, Node cp, Set<Node> cutpoints, Map<Node, Boolean> visited, Map<Node, Set<Node>> comps) {
        visited.put(v, true);
        if (!this.biggest.contains(v)) {
            comps.get(cp).add(v);
        }
        for (Node u : this.graph.neighborListOf(v)) {
            if (visited.get(u) != null) continue;
            this.dfs(u, cutpoints.contains(v) ? v : cp, cutpoints, visited, comps);
        }
    }

    public Set<Node> getBiggestComponent() {
        return this.biggest;
    }

    public List<Set<Node>> getUnrootedComponents() {
        return this.unrootedComponents;
    }

    public List<Pair<Set<Node>, Node>> getRootedComponents() {
        return this.rootedComponents;
    }
}

