% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avg.plot.R
\name{avg.plot}
\alias{avg.plot}
\title{Averaged simulated values plot function}
\usage{
avg.plot(
  data.mat,
  start,
  end,
  x.lab = "Iteration number",
  y.lab = "Average of simulated values",
  title = NULL,
  details = FALSE
)
}
\arguments{
\item{data.mat}{data matrix including the simulated values for plot.}

\item{start}{the number of cycle to start.}

\item{end}{the number of cycle to end.}

\item{x.lab}{label of the x axis in the generated plot, default is set to "Iteration number".}

\item{y.lab}{label of the y axis in the generated plot, default is set to "Average of simulated values".}

\item{title}{title of the generated plot.}

\item{details}{logical variable to specify whether the average simulated values are returned, default is set to FALSE.}
}
\value{
The plot of averaged values across iterations. If \code{details} = TRUE,
a matrix containing the averaged values of all the variables across iterations will be returned.
}
\description{
Calculates and the average simulated values of all parameters and generates plots.
}
\details{
This function calculates the average simulated values across simulations.
\code{iter} can be any number of iterations you want to draw, the corresponding number of rows
of the data should be \code{iter} + 1.
}
\examples{
### data and indicator
miss.dat <- simulated.dat[[1]]
data.ind <- simulated.dat[[2]]

### number of observations and variables
n <- nrow(miss.dat); p <- ncol(miss.dat)

#### bound matrices
b1 <- b2 <- matrix(nrow = nrow(data.ind), ncol = ncol(data.ind))

for (i in 1:nrow(b1)) {
  for (j in 1:ncol(b1)) {
    b1[i, j] <- ifelse(data.ind[i, j] != 1, NA,
                       miss.dat[i, j])
    b2[i, j] <- ifelse(data.ind[i, j] == 0, NA, miss.dat[i, j])
  }
}
colnames(b1) <- colnames(b2) <- colnames(miss.dat)

#### create a matrix for including the lower and upper bounds
bounds <- list()
bounds[[1]] <- b1; bounds[[2]] <- b2

### prior specifications
prior.param <- list(
  mu.0 = rep(0, p),
  Lambda.0 = diag(100, p),
  kappa.0 = 2,
  nu.0 = p * (p + 1) / 2
)

### starting values
start.vals <- list(
  mu = rep(0, p),
  sigma = diag(100, p)
)


### MI
num.iter <- 500

begin <- Sys.time()
sim.res <- multiple.imputation(
  bounds,
  prior.param,
  start.vals,
  num.iter,
  FALSE
)

### plot of average values of simulated mean and variance
avg.plot(sim.res$simulated.mu, 201, 501, title = "Simulated value: mean")
avg.plot(sim.res$simulated.sig, 201, 501, title = "Simulated value: variance")


}
