% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_pvalues.R
\name{cauchy_combined}
\alias{cauchy_combined}
\title{Cauchy p combine method on mvmapit return}
\usage{
cauchy_combined(pvalues, group_col = "id", p_col = "p")
}
\arguments{
\item{pvalues}{Tibble with p-values from mvmapit function call. Grouping is
based on the column named "id"}

\item{group_col}{String that denotes column by which to group and combine
p-values.}

\item{p_col}{String that denotes p-value column.}
}
\value{
A Tibble with the combined p-values.
}
\description{
This function takes in the p-values tibble that mvmapit returned. It then
computes the combined p-values grouped by variant id.
}
\examples{
set.seed(837)
p <- 200
n <- 100
d <- 2
X <- matrix(
    runif(p * n),
    ncol = p
)
Y <- matrix(
    runif(d * n),
    ncol = d
)
mapit <- mvmapit(
    t(X),
    t(Y),
    test = "normal", cores = 1, logLevel = "INFO"
)
cauchy <- cauchy_combined(mapit$pvalues)
}
