% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diststudent.R
\name{diststudent}
\alias{diststudent}
\title{Distance/Divergence between Centered Multivariate \eqn{t} Distributions}
\usage{
diststudent(nu1, Sigma1, nu2, Sigma2,
                   dist = c("renyi", "bhattacharyya", "hellinger"),
                   bet = NULL, eps = 1e-06)
}
\arguments{
\item{nu1}{numeric. The degrees of freedom of the first distribution.}

\item{Sigma1}{symmetric, positive-definite matrix. The correlation matrix of the first distribution.}

\item{nu2}{numeric. The degrees of freedom of the second distribution.}

\item{Sigma2}{symmetric, positive-definite matrix. The correlation matrix of the second distribution.}

\item{dist}{character. The distance or divergence used.
One of \code{"renyi"} (default), \code{"battacharyya"} or \code{"hellinger"}.}

\item{bet}{numeric, positive and not equal to 1. Order of the Renyi divergence.
Ignored if \code{distance="bhattacharyya"} or \code{distance="hellinger"}.}

\item{eps}{numeric. Precision for the computation of the partial derivative of the Lauricella \eqn{D}-hypergeometric function (see Details). Default: 1e-06.}
}
\value{
A numeric value: the divergence between the two distributions,
with two attributes \code{attr(, "epsilon")} (precision of the result of the Lauricella \eqn{D}-hypergeometric function,see Details)
and \code{attr(, "k")} (number of iterations).
}
\description{
Computes the distance or divergence (Renyi divergence, Bhattacharyya
distance or Hellinger distance) between two random vectors distributed
according to multivariate \eqn{t} distributions (MTD) with zero mean vector.
}
\details{
Given \eqn{X_1}, a random vector of \eqn{\mathbb{R}^p} distributed according to the MTD
with parameters \eqn{(\nu_1, \mathbf{0}, \Sigma_1)}
and \eqn{X_2}, a random vector of \eqn{\mathbb{R}^p} distributed according to the MTD
with parameters \eqn{(\nu_2, \mathbf{0}, \Sigma_2)}.

Let \eqn{\delta_1 = \frac{\nu_1 + p}{2} \beta}, \eqn{\delta_2 = \frac{\nu_2 + p}{2} (1 - \beta)}
and \eqn{\lambda_1, \dots, \lambda_p} the eigenvalues of the square matrix \eqn{\Sigma_1 \Sigma_2^{-1}}
sorted in increasing order: \deqn{\lambda_1 < \dots < \lambda_{p-1} < \lambda_p}
The Renyi divergence between \eqn{X_1} and \eqn{X_2} is:
\deqn{
\begin{aligned}
D_R^\beta(\mathbf{X}_1||\mathbf{X}_1) &  = & \displaystyle{\frac{1}{\beta - 1} \bigg[ \beta \ln\left(\frac{\Gamma\left(\frac{\nu_1+p}{2}\right) \Gamma\left(\frac{\nu_2}{2}\right) \nu_2^{\frac{p}{2}}}{\Gamma\left(\frac{\nu_2+p}{2}\right) \Gamma\left(\frac{\nu_1}{2}\right) \nu_1^{\frac{p}{2}}}\right) + \ln\left(\frac{\Gamma\left(\frac{\nu_2+p}{2}\right)}{\Gamma\left(\frac{\nu_2}{2}\right)}\right) + \ln\left(\frac{\Gamma\left(\delta_1 + \delta_2 - \frac{p}{2}\right)}{\Gamma(\delta_1 + \delta_2)}\right) } \\
&& \displaystyle{- \frac{\beta}{2} \sum_{i=1}^p{\ln\lambda_i} + \ln F_D \bigg]}
\end{aligned}
}
with \eqn{F_D} given by:
\itemize{
\item If \eqn{\displaystyle{\frac{\nu_1}{\nu_2} \lambda_1 > 1}}:

\eqn{
\displaystyle{ F_D = F_D^{(p)}{\bigg( \delta_1, \underbrace{\frac{1}{2}, \dots, \frac{1}{2}}_p; \delta_1+\delta_2; 1-\frac{\nu_2}{\nu_1 \lambda_1}, \dots, 1-\frac{\nu_2}{\nu_1 \lambda_p} \bigg)} }
}
\item If \eqn{\displaystyle{\frac{\nu_1}{\nu_2} \lambda_p < 1}}:

\eqn{
\displaystyle{ F_D = \prod_{i=1}^p{\left(\frac{\nu_1}{\nu_2} \lambda_i\right)^{\frac{1}{2}}} F_D^{(p)}\bigg(\delta_2, \underbrace{\frac{1}{2}, \dots, \frac{1}{2}}_p; \delta_1+\delta_2; 1-\frac{\nu_1}{\nu_2}\lambda_1, \dots, 1-\frac{\nu_1}{\nu_2}\lambda_p\bigg) }
}
\item If \eqn{\displaystyle{\frac{\nu_1}{\nu_2} \lambda_1 < 1}} and \eqn{\displaystyle{\frac{\nu_1}{\nu_2} \lambda_p > 1}}:

\eqn{
\displaystyle{ F_D = \left(\frac{\nu_2}{\nu_1} \frac{1}{\lambda_p}\right)^{\delta_2} \prod_{i=1}^p\left(\frac{\nu_1}{\nu_2}\lambda_i\right)^\frac{1}{2} F_D^{(p)}\bigg(\delta_2, \underbrace{\frac{1}{2}, \dots, \frac{1}{2}}_p, \delta_1+\delta_2-\frac{p}{2}; \delta_1+\delta2; 1-\frac{\lambda_1}{\lambda_p}, \dots, 1-\frac{\lambda_{p-1}}{\lambda_p}, 1-\frac{\nu_2}{\nu_1}\frac{1}{\lambda_p}\bigg) }
}
}

where \eqn{F_D^{(p)}} is the Lauricella \eqn{D}-hypergeometric function defined for \eqn{p} variables:
\deqn{ \displaystyle{ F_D^{(p)}\left(a; b_1, ..., b_p; g; x_1, ..., x_p\right) = \sum\limits_{m_1 \geq 0} ... \sum\limits_{m_p \geq 0}{ \frac{ (a)_{m_1+...+m_p}(b_1)_{m_1} ... (b_p)_{m_p} }{ (g)_{m_1+...+m_p} } \frac{x_1^{m_1}}{m_1!} ... \frac{x_p^{m_p}}{m_p!} } } }
Its computation uses the \code{\link{lauricella}} function.

The Bhattacharyya distance is given by:
\deqn{D_B(\mathbf{X}_1||\mathbf{X}_2) = \frac{1}{2} D_R^{1/2}(\mathbf{X}_1||\mathbf{X}_2)}

And the Hellinger distance is given by:
\deqn{D_H(\mathbf{X}_1||\mathbf{X}_2) = 1 - \exp{\left(-\frac{1}{2} D_R^{1/2}(\mathbf{X}_1||\mathbf{X}_2)\right)}}
}
\examples{
nu1 <- 2
Sigma1 <- matrix(c(2, 1.2, 0.4, 1.2, 2, 0.6, 0.4, 0.6, 2), nrow = 3)
nu2 <- 4
Sigma2 <- matrix(c(1, 0.3, 0.1, 0.3, 1, 0.4, 0.1, 0.4, 1), nrow = 3)

# Renyi divergence
diststudent(nu1, Sigma1, nu2, Sigma2, bet = 0.25)
diststudent(nu2, Sigma2, nu1, Sigma1, bet = 0.25)

# Bhattacharyya distance
diststudent(nu1, Sigma1, nu2, Sigma2, dist = "bhattacharyya")
diststudent(nu2, Sigma2, nu1, Sigma1, dist = "bhattacharyya")

# Hellinger distance
diststudent(nu1, Sigma1, nu2, Sigma2, dist = "hellinger")
diststudent(nu2, Sigma2, nu1, Sigma1, dist = "hellinger")

}
\references{
N. Bouhlel and D. Rousseau (2023), Exact Rényi and Kullback-Leibler Divergences Between Multivariate t-Distributions, IEEE Signal Processing Letters.
\doi{10.1109/LSP.2023.3324594}
}
\author{
Pierre Santagostini, Nizar Bouhlel
}
