% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivar_sim.R
\name{multivar_sim}
\alias{multivar_sim}
\title{Simulate multivar data.}
\usage{
multivar_sim(
  k,
  d,
  n,
  prop_fill_com,
  prop_fill_ind,
  lb,
  ub,
  sigma,
  unique_overlap = FALSE,
  mat_common = NULL,
  mat_unique = NULL,
  mat_total = NULL,
  diag = FALSE
)
}
\arguments{
\item{k}{Integer. The number of individuals (or datasets) to be generated.}

\item{d}{Integer. The number of variables per dataset. For now this will be constant across individuals.}

\item{n}{Integer. The time series length.}

\item{prop_fill_com}{Numeric. The proportion of nonzero paths in the common transition matrix.}

\item{prop_fill_ind}{Numeric. The proportion of nonzero unique (not in the common transition matrix or transition matrix of other individuals) paths in each individual transition matrix.}

\item{lb}{Numeric. The upper bound for individual elements of the transition matrices.}

\item{ub}{Numeric. The lower bound for individual elements of the transition matrices.}

\item{sigma}{Matrix. The (population) innovation covariance matrix.}

\item{unique_overlap}{Logical. Default is FALSE. Whether the unique portion should be completely unique (no overlap) or randomly chosen.}

\item{mat_common}{Matrix. A common effects transition matrix (if known).}

\item{mat_unique}{List. A list of unique effects transition matrix (if known).}

\item{mat_total}{List. A list of total effects transition matrix (if known).}

\item{diag}{Logical. Default is FALSE. Should diagonal elements be filled first for common elements.}
}
\description{
Simulate multivar data.
}
\examples{
k <- 3
d <- 10
n <- 20
prop_fill_com <- .1
prop_fill_ind <- .05
lb <- 0.1
ub <- 0.5
sigma <- diag(d)
data <- multivar_sim(k, d, n, prop_fill_com, prop_fill_ind, lb, ub,sigma)$data
}
\keyword{multivar}
\keyword{simulate}
\keyword{var}
