% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{binom_to_multinom}
\alias{binom_to_multinom}
\title{Converts Binary to Multinomial Frequencies}
\usage{
binom_to_multinom(k, n)
}
\arguments{
\item{k}{vector of observed response frequencies.}

\item{n}{the number of choices per item type.
If \code{k=n=0}, Bayesian inference is relies on the prior distribution only.}
}
\description{
Converts the number of "hits" in the binary choice format to the observed
frequencies across  for all response categories (i.e., the multinomial format).
}
\details{
In \code{multinomineq}, binary choice frequencies are represented by the number
of "hits" for each item type/condition (the vector \code{k}) and by the total
number of responses per item type/condition (the scalar or vector \code{n}).

In the multinomial format, the vector \code{k} includes all response categories
(not only the number of "hits"). This requires to define a vector \code{options},
which indicates how many categories belong to one item type/condition (since
the total number of responses per item type is fixed).
}
\examples{
k <- c(1, 5, 8, 10)
n <- 10
binom_to_multinom(k, n)

}
