% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pqrdata.R
\name{qdata}
\alias{qdata}
\alias{cdata}
\alias{pdata}
\alias{rdata}
\alias{ddata}
\title{The Data Distribution}
\usage{
qdata(formula, p = seq(0, 1, 0.25), data = NULL, ...)

cdata(formula, p = 0.95, data = NULL, ...)

pdata(formula, q, data = NULL, ...)

rdata(formula, n, data = NULL, ...)

ddata(formula, q, data = NULL, ...)
}
\arguments{
\item{formula}{a formula or a vector}

\item{p}{a vector of probabilities}

\item{data}{a data frame in which to evaluate \code{formula}}

\item{\dots}{additional arguments passed to \code{quantile} or \code{sample}}

\item{q}{a vector of quantiles}

\item{n}{number of values to sample}
}
\value{
For \code{qdata}, a vector of quantiles

for \code{cdata}, a data frame giving
upper and lower limits and the central proportion requested

For \code{pdata}, a vector of probabilities

For \code{rdata}, a vector of sampled values.

For \code{ddata}, a vector of probabilities (empirical densities)
}
\description{
Density, distribution function, quantile function, and random generation
from data.
}
\examples{
data(penguins, package = "palmerpenguins")
qdata(flipper_length_mm ~ species, 0.5, data = penguins)
qdata( ~ flipper_length_mm, p = 0.5, groups = species, data = penguins)
qdata(penguins$flipper_length_mm, p = 0.5)
qdata( ~ flipper_length_mm, p = 0.5, data = penguins)
qdata( ~ flipper_length_mm, p = 0.5, groups = species, data = penguins)
data(penguins, package = 'palmerpenguins')
cdata(penguins$flipper_length_mm, 0.5)
cdata( ~ flipper_length_mm, 0.5, data = penguins)
cdata( ~ flipper_length_mm, 0.5, data = penguins)
cdata( ~ flipper_length_mm | species, data = penguins, p = .5)
data(penguins, package = 'palmerpenguins')
pdata(penguins$flipper_length_mm, 3:6)
pdata( ~ flipper_length_mm, 3:6, data = penguins)
data(penguins, package = 'palmerpenguins')
rdata(penguins$species, 10)
rdata( ~ species, n = 10, data = penguins)
rdata(flipper_length_mm ~ species,  n = 5, data = penguins)
data(penguins, package = 'palmerpenguins')
ddata(penguins$species, 'setosa')
ddata( ~ species, 'setosa', data = penguins)
}
\keyword{distribution}
