% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregatingMeta.R
\name{aggregatingFunction1}
\alias{aggregatingFunction1}
\title{1-ary Aggregating functions}
\usage{
aggregatingFunction1(fun, output.multiple = FALSE,
  envir = parent.frame(), na.rm = getOption("na.rm", FALSE),
  style = c("formula1st", "formula", "flexible"))
}
\arguments{
\item{fun}{a function that takes a numeric vector and computes a summary statistic,
returning a numeric vector.}

\item{output.multiple}{a boolean indicating whether \code{fun} returns multiple values}

\item{envir}{an environment in which evaluation takes place.}

\item{na.rm}{the default value for na.rm in the resulting function.}

\item{style}{one of \code{"formula1st"}, \code{"formula2nd"} or \code{"flexible"}.  In the first
two cases, the first argument must be a formula or evaluate to an object.  In the latter case,
bare names will be converted into formulas.}
}
\value{
a function that generalizes \code{fun} to handle a formula/data frame interface.
}
\description{
\code{aggregatinFuntion1} creates statistical summaries of one numerical vector that are formula aware.
}
\details{
The logic of the resulting function is this: 1) If the first argument is a formula,
use that formula and \code{data} to create the necessary call(s) to \code{fun}; (2) Else simply
pass everything to \code{fun} for evaluation.
}
\section{Note}{

Earlier versions of this function supported a "bare name + data frame" interface.  This
functionality has been removed since it was (a) ambiguous in some cases, (b) unnecessary, and (c)
difficult to maintain.
}

\examples{
if (require(mosaicData)) {
  foo <- aggregatingFunction1(base::mean)
  foo( ~ length, data = KidsFeet)
  base::mean(KidsFeet$length)
  foo(length ~ sex, data = KidsFeet)
} 
}
