% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor-test.R
\name{cor_test.formula}
\alias{cor_test.formula}
\alias{cor.test}
\alias{cor_test.default}
\title{Alternative formula interface for cor.test}
\usage{
cor_test.formula(formula, ...)

cor.test(x, ...)

cor_test.default(x, y, ...)
}
\arguments{
\item{formula}{a formula}

\item{...}{other orguments passed to \code{\link[stats]{cor.test}()}.}

\item{x, y}{numeric vectors of data values. x and y must have the same length.}
}
\description{
\code{\link[stats]{cor.test}} in \pkg{stats} accepts formulas of the 
shape \code{~ y + x}.  The \pkg{mosaic} package allows the use 
of \code{y ~ x} as an alternative formula shape.
}
\examples{
# This is an example from example(stats::cor.test) done in old and new style
require(graphics)
cor.test(~ CONT + INTG, data = USJudgeRatings)
cor.test(CONT ~ INTG, data = USJudgeRatings)
}
\seealso{
\code{\link[stats]{cor.test}()} in the \pkg{stats} package.
}
