% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mm.R
\name{mm}
\alias{mm}
\title{Construct a model based on groupwise means}
\usage{
mm(formula, data = parent.frame(), fun = mean, drop = TRUE, ...)
}
\arguments{
\item{formula}{A formula.  The left-hand side specifies the variable over
which the mean will be taken.  The right-hand side gives the grouping variables, 
separated by \code{&}.}

\item{data}{A data frame to which the formula variables refer.  If not specified, variables 
will be taken from the current environment.}

\item{fun}{The function used to calculate the means.  Default: \code{mean}.}

\item{drop}{Logical flag indicating whether to drop unoccupied groups.  Default \code{TRUE}.
NOT YET IMPLEMENTED.}

\item{\dots}{Additional arguments to be passed to the \code{fun} doing the calculation.}
}
\value{
\code{mm} returns an object of class \code{groupwiseModel}.  The functions 
\code{fitted.values}, \code{residuals}, \code{coefficients}, and \code{summary} 
are useful for extracting various features of the value returned by \code{mm}
}
\description{
Calculate groupwise means, presenting the result as a model in the style of \code{lm}.
}
\details{
\code{mm} is a sort of training function for \code{lm}, meant to provide a 
basis for discussing inference and introducing resampling in a simple, intuitive setting 
of groupwise means.  \code{lm} provides a better, more general facility. When using
\code{lm} to recreate the results of \code{mm}, include all the interaction terms, 
that is, use \code{*} instead of \code{&}.  See the examples.
}
\seealso{
\code{\link{lm}}, 
\code{\link{do}}
}

