% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmtree.R
\name{pmtree}
\alias{pmtree}
\title{Compute model-based tree from model.}
\usage{
pmtree(
  model,
  data = NULL,
  zformula = ~.,
  control = ctree_control(),
  coeffun = coef,
  ...
)
}
\arguments{
\item{model}{a model object. The model can be a parametric model with a binary covariate.}

\item{data}{data. If NULL (default) the data from the model object are used.}

\item{zformula}{formula describing which variable should be used for partitioning.
Default is to use all variables in data that are not in the model (i.e. \code{~ .}).}

\item{control}{control parameters, see \code{\link[partykit]{ctree_control}}.}

\item{coeffun}{function that takes the model object and returns the coefficients.
Useful when \code{coef()} does not return all coefficients (e.g. \code{survreg}).}

\item{...}{additional parameters passed on to model fit such as weights.}
}
\value{
ctree object
}
\description{
Input a parametric model and get a model-based tree.
}
\details{
Sometimes the number of participant in each treatment group needs to 
be of a certain size. This can be accomplished by setting \code{control$converged}.
See example below.
}
\examples{
if(require("TH.data") & require("survival")) {
  ## base model
  bmod <- survreg(Surv(time, cens) ~ horTh, data = GBSG2, model = TRUE)
  survreg_plot(bmod)
  
  ## partitioned model
  tr <- pmtree(bmod)
  plot(tr, terminal_panel = node_pmterminal(tr, plotfun = survreg_plot, 
                                            confint = TRUE))
  summary(tr)
  summary(tr, node = 1:2)
  
  logLik(bmod)
  logLik(tr)
  
  
  ## Sometimes the number of participant in each treatment group needs to 
  ## be of a certain size. This can be accomplished using converged
  
  ## Each treatment group should have more than 33 observations
  ctrl <- ctree_control(lookahead = TRUE)
  ctrl$converged <- function(mod, data, subset) {
      all(table(data$horTh[subset]) > 33)
  }
  
  tr2 <- pmtree(bmod, control = ctrl)
  plot(tr2, terminal_panel = node_pmterminal(tr, plotfun = survreg_plot,
      confint = TRUE))
  
  summary(tr2[[5]]$data$horTh)
}


if(require("psychotools")) {
  data("MathExam14W", package = "psychotools")
  
  ## scale points achieved to [0, 100] percent
  MathExam14W$tests <- 100 * MathExam14W$tests/26
  MathExam14W$pcorrect <- 100 * MathExam14W$nsolved/13
  
  ## select variables to be used
  MathExam <- MathExam14W[ , c("pcorrect", "group", "tests", "study",
                               "attempt", "semester", "gender")]
  
  ## compute base model
  bmod_math <- lm(pcorrect ~ group, data = MathExam)
  lm_plot(bmod_math, densest = TRUE)
  
  ## compute tree
  (tr_math <- pmtree(bmod_math, control = ctree_control(maxdepth = 2)))
  plot(tr_math, terminal_panel = node_pmterminal(tr_math, plotfun = lm_plot, 
                                                 confint = FALSE))
  plot(tr_math, terminal_panel = node_pmterminal(tr_math, plotfun = lm_plot, 
                                                 densest = TRUE,
                                                 confint = TRUE))
  
  ## predict
  newdat <- MathExam[1:5, ]
  
  # terminal nodes
  (nodes <- predict(tr_math, type = "node", newdata = newdat))
  
  # response
  (pr <- predict(tr_math, type = "pass", newdata = newdat))
  
  # response including confidence intervals, see ?predict.lm
  (pr1 <- predict(tr_math, type = "pass", newdata = newdat,
                  predict_args = list(interval = "confidence")))
}
}
