% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{h_assert_lrt_suitability}
\alias{h_assert_lrt_suitability}
\title{Ensure LRT Is Appropriate for \code{list} of \code{mmrm} Fits}
\usage{
h_assert_lrt_suitability(fits, refit, dfs, is_reml)
}
\arguments{
\item{fits}{(\code{list})\cr list of \code{mmrm} fits.}

\item{refit}{(\code{flag})\cr \code{TRUE} or \code{FALSE} indicating whether or not the user
gave permission to refit models to make all models suitable for LRT.}

\item{dfs}{(\code{numeric})\cr vector of the degrees of freedom for each element
of \code{fits}.}

\item{is_reml}{(\code{logical})\cr vector indicating whether or not REML was used
for each element of \code{fits}.}
}
\value{
\code{TRUE} if the list of \code{fits} are suitable for LRT. Otherwise, an
error is thrown.
}
\description{
Throws an error if the degrees of freedom aren't monotonically increasing, if
the models aren't nested, or if \code{refit = FALSE} and the models have different
underlying data.
}
\keyword{internal}
